Source of information is the Arduino.cc website.
<br />
<br />
Since the Arduino DUE compatible side of the UDOO QUAD/DUAL is a replica of the original Arduino DUE you can find more info about in the [Arduino Due page](https://www.arduino.cc/en/Main/ArduinoBoardDue) of the Arduino.cc website.


The Arduino Due is the first Arduino board based on a 32-bit ARM core microcontroller. With 54 digital input/output pins, 12 analog inputs, it is the perfect board for powerful larger scale Arduino projects.

The Arduino Due compatible of the UDOO QUAD/DUAL is a microcontroller board based on the Atmel SAM3X8E ARM Cortex-M3 CPU. It is the first Arduino board based on a 32-bit ARM core microcontroller. It has 54 digital input/output pins (of which 12 can be used as PWM outputs), 12 analog inputs, 4 UARTs (hardware serial ports), a 84 MHz clock, 2 DAC (digital to analog), 2 TWI, an SPI header, a JTAG header, a reset jumper and an erase jumper.

<div class="alert alert-warning" role="alert">
  <span class="label label-warning">Warning!</span>
  <span class="sr-only">Warning!</span>
  Unlike most Arduino boards, the Arduino Due board runs at 3.3V. The maximum voltage that the I/O pins can tolerate is 3.3V. Applying voltages higher than 3.3V to any I/O pin could damage the board.
</div>


UDOO QUAD/DUAL pinout follows the Arduino 1.0 R3 pinout.


## Technical specs

| AVR Arduino microcontroller              |                                                |
|------------------------------------------|------------------------------------------------|
| Microcontroller	                         | AT91SAM3X8E                                    |
| Operating Voltage	                       | 3.3V                                           |
| Digital I/O Pins	                       | 54 (of which 12 provide PWM output)            |
| Analog Input Pins	                       | 12                                             |
| Analog Output Pins                       | 2 (DAC)                                        |
| Total DC Output Current on all I/O lines | 130 mA                                         |
| DC Current for 3.3V Pin	                 | 800 mA                                         |
| DC Current for 5V Pin	                   | 800 mA                                         |
| Flash Memory	                           | 512 KB all available for the user applications |
| SRAM                                     | 96 KB (two banks: 64KB and 32KB)               |
| Clock Speed	                             | 84 MHz                                         |

## ARM Core Benefits

* A 32-bit core, that allows operations on 4 bytes wide data within a single CPU clock. (for more information  go to int type page).
* CPU Clock at 84Mhz.
* 96 KBytes of SRAM.
* 512 KBytes of Flash memory for code.
* A DMA controller, that can relieve the CPU from doing memory intensive tasks.


## Power

The embedded Arduino Due compatible of the UDOO QUAD/DUAL is powered by the same power source of the entire board.

The power pins are as follows:
* **Vin**. The input voltage to the Arduino board when it's using an external power source from `CN22(DC-in)` power jack. You can supply voltage through this pin, or if supplying voltage via the power jack, access it through this pin.
* **5V**.This pin outputs a regulated 5V from the regulator on the board. The board can be supplied with power either from the `CN22(DC-in)` power jack (6-18V), or the VIN pin of the board (6-18V). Supplying voltage via the 5V or 3.3V pins bypasses the regulator, and can damage your board. We don't advise it.
* **3V3**. A 3.3 volt supply generated by the on-board regulator. Maximum current draw is 800 mA. This regulator also provides the power supply to the SAM3X microcontroller.
* **GND**. Ground pins.
* **IOREF**. This pin on the Arduino board provides the voltage reference with which the microcontroller operates. A properly configured shield can read the IOREF pin voltage and select the appropriate power source or enable voltage translators on the outputs for working with the 5V or 3.3V.

## Memory

The SAM3X has 512 KB (2 blocks of 256 KB) of flash memory for storing code. The bootloader is preburned in factory from Atmel and is stored in a dedicated ROM memory. The available SRAM is 96 KB in two contiguous bank of 64 KB and 32 KB. All the available memory (Flash, RAM and ROM) can be accessed directly as a flat addressing space.
<br />
It is possible to erase the Flash memory of the SAM3X with the onboard jumper `J22` (the one next to the power button). This will remove the currently loaded sketch from the MCU. To erase, plug a jumper in `J22` for a few seconds while the board is powered.

## Input and outputs

A graphical overview could be found in the [GPIO section](../Hardware_\&_Accessories/GPIO_Pinout.html).

* **Digital I/O**: pins from 0 to 53
Each of the 54 digital pins on the Due can be used as an input or output, using pinMode(), digitalWrite(), and digitalRead() functions. They operate at 3.3 volts. Each pin can provide (source) a current of 3 mA or 15 mA, depending on the pin, or receive (sink) a current of 6 mA or 9 mA, depending on the pin. They also have an internal pull-up resistor (disconnected by default) of 100 KOhm. In addition, some pins have specialized functions:
* **Serial: 0 (RX) and 1 (TX)**
* **Serial 1: 19 (RX) and 18 (TX)**
* **Serial 2: 17 (RX) and 16 (TX)**
* **Serial 3: 15 (RX) and 14 (TX)**
* **PWM**: Pins 2 to 13
Provide 8-bit PWM output with the analogWrite() function. the resolution of the PWM can be changed with the analogWriteResolution() function.
* **CAN**: CANRX and CANTX
These pins support the CAN communication protocol but are not not yet supported by Arduino APIs.
* **TWI 1**: 20 (SDA) and 21 (SCL)
* **TWI 2**: SDA1 and SCL1.
Support TWI communication using the Wire library. SDA1 and SCL1 can be controlled using the Wire1 class provided by the Wire library. While SDA and SCL have internal pullup resistors, SDA1 and SCL1 have not. Adding two pullup resistor on SDA1 and SCL1 lines is required for using Wire1.
* **Analog Inputs: pins from A0 to A11**
The Due has 12 analog inputs, each of which can provide 12 bits of resolution (i.e. 4096 different values). By default, the resolution of the readings is set at 10 bits, for compatibility with other Arduino boards. It is possible to change the resolution of the ADC with analogReadResolution(). The Due’s analog inputs pins measure from ground to a maximum value of 3.3V. Applying more than 3.3V on the Due’s pins will damage the SAM3X chip. The analogReference() function is ignored on the Due.
The AREF pin is connected to the SAM3X analog reference pin through a resistor bridge. To use the AREF pin, resistor BR1 must be desoldered from the PCB.
* **DAC1 and DAC2**
These pins provides true analog outputs with 12-bits resolution (4096 levels) with the analogWrite() function. These pins can be used to create an audio output using the Audio library.
Other pins on the board:
* **AREF**
Reference voltage for the analog inputs. Used with analogReference().
* **Reset**
The embedded Arduino DUE compatible could be reset by the `J16` jumper. To reset, plug a jumper in `J16` for a few seconds while the board is powered.


## Communication

The communication between the two processors is well described in the [IMX6_And_Sam3X_Communication](../Hardware_\&_Accessories/IMX6_And_Sam3X_Communication.html) section.
<br />
The embedded Arduino DUE compatible of the UDOO QUAD/DUAL can communicate with an external PC through the **Programming Port** on the micro-USB `CN6` connector when the jumper `J18` is NOT plugged.
The micro-USB `CN6` port is connected to a [CP210x USB to UART Bridge](http://www.silabs.com/products/mcu/pages/usbtouartbridgevcpdrivers.aspx), which provides a virtual COM port to software on a connected Windows computer, or a TTY device on a connected Linux/OSX computer.
<br/>
The SAM3X **Native Port** is connected to the USB OTG of the iMX6 processor and is used to communicate with an Android App through the ADK protocol when Android OS is running on the iMX6 processor.

## Programming

Uploading sketches to the SAM3X is different than the AVR microcontrollers found in other Arduino boards because the flash memory needs to be erased before being re-programmed. Upload to the chip is managed by ROM on the SAM3X, which is run only when the chip's flash memory is empty.
Unlike the original Arduino DUE, the UDOO QUAD/DUAL doesn't have a dedicated chip to erase and reset the SAM3X microprocessor in the programming stage.
In UDOO QUAD/DUAL this task is carried out by the iMX6 processor through two GPIOs connected to the erase and reset pins of the SAM3X.
When you try to program the SAM3X from an external PC, the uploader software called by the Arduino IDE ([bossac](https://github.com/UDOOboard/bossac)) sends a magic code that is intercepted/readed from a custom [driver](https://github.com/UDOOboard/linux_kernel/blob/3.14-1.0.x-udoo/drivers/misc/udoo_ard.c) contained in the UDOO's Kernel. When the code is recognized, the driver performs the erase and reset moving the connected GPIOs.
