<h1>UDOO DUAL/QUAD</h1>
<hr/>
<p>
	<strong>UDOO DUAL/QUAD</strong> is a single board computer that can be used both with Android and Linux, paired with an Arduino-compatible processor. It is a powerful prototyping board for software development and design; it’s easy to use and allows developing projects with minimum knowledge of hardware design. UDOO DUAL/QUAD merges different computing worlds together: each one has its proper strengths and weak points, but all of them are useful in todays life for educational purposes as well as Do-It-Yourself (DIY) and quick prototyping. UDOO DUAL/QUAD is an open hardware, low-cost platform equipped with an ARM i.MX6 Freescale processor, and an Arduino Due compatible section based on ATMEL SAM3X8E ARM processor, all this available on the same board!
</p>
<hr/>

<h3>UDOO DUAL/QUAD Goals:</h3>
<hr/>

* Develop an innovative product for a growing market
* Give a new vision to the educational framework, with the idea of training up a new generation of engineers, designers and software developers skilled in digital technology: physical computing, multi-media arts, interactive arts, IoT...
* Give a boost to the DIY world
* Offer a low cost embedded platform for interactive arts with powerful tools: Processing, OpenCV, PureData, openFramework
* Provide companies with a great tool for fast prototyping


<hr/>
<h3>Specifications</h3>
<hr/>

<img src="../img/udoo_fritzing.png" alt="alt text" class="img-responsive pull-right" height="441px" width="350px"  style="margin-bottom:20px; margin-left:30px;">


UDOO DUAL/QUAD retail line up consists of three models, sharing most of the features and different only for connectivity and i.MX6 processor used. All three models feature an embedded Arduino compatible section based on Arduino Due schematic. UDOO DUAL/QUAD’s dimensions are: 4.33 inch x 3.35 inch (11 cm x 8.5 cm).

* Freescale i.MX6Quad, 2\4 x ARM® Cortex™-A9 core @ 1GHz with ARMv7A instruction set
* GPU Vivante GC 2000 for 3D + Vivante GC 355 for 2D (vector graphics) + Vivante GC 320 for 2D
* Atmel SAM3X8E ARM Cortex-M3 CPU (same as Arduino Due)
* RAM DDR3 1GB
* 76 fully available GPIO with Arduino compatible R3 1.0 pinout
* HDMI and LVDS + Touch
* 2 Micro USB (1 OTG)
* 2 USB 2.0 type A and 1 USB 2.0 internal pin header (requires adapter cable)
* Analog Audio and Mic jacks
* CSI Camera Connection
* on board Micro SD card reader (boot device)
* Power Supply (6-15V) and External Battery connector
* Ethernet RJ45 (10/100/1000 MBit)
* WiFi Module
* SATA connector with power header

<strong>Warning: The UDOO DUAL/QUAD I/O pins are 3.3V compliant. Higher voltages (like 5V) would damage the board.</strong>

<br />

Here you can find a more technical and exhaustive document, the [UDOO QUAD/DUAL’s block diagram](http://udoo.org/wp-content/uploads/2013/04/UDOO_Block_Diagram_rel_1_1.pdf).

<br />

<hr/>
<h3>GPIO Features</h3>
<hr/>

* 76 fully available GPIO
* Arduino-compatible R3 1.0 pinout
* 3,3 V Compliant
* Compatible with All Arduino Due Shields and most Arduino Shields
* GPIO's can be accessed as Arduino pins, GPIO's or as additional S\PDIF, FlexCAN,I2S, SPI

[More information about UDOO DUAL/QUAD_GPIO_Pinout](../Hardware_&_Accessories/GPIO_Pinout.html)

<br />
<hr/>
<h2>Official Accessories</h2>
<hr/>

<hr/>
<h3>UDOO Camera Module</h3>
<hr/>

<img src="../img/600px-UDOO_Camera.jpg" alt="alt text" class="img-responsive pull-right" style="margin-bottom:20px; margin-left:30px; width:300px; height:169px;">


* Auto focus control (AFC) with embedded AF VCM driver
* Sensitivity: 600mV/lux-sec
* Video capture in Full Field of View (FOV): double sensitivity,improved signal-to.noise ratio (SNR)
* Post-binning re-sampling filter for sharper, crisper contours and colours
* Internal anti-shaking engine
* Image transfer rate

VGA (320x480) @120fps VGA (640x480) @90fps 720p @60fps 1280x960 @45fps 1080p @30fps QSXGA (2592x1944) @15fps

[More informations about UDOO Camera Modules](../Hardware_&_Accessories/UDOO_Camera_Module.html)

<a href="http://udoo.org/download/files/datasheets/datasheet_camera.pdf" target="_blank">UDOO Camera Module Datasheet</a>

<hr/>
<h3>UDOO LVDS Touch Screens</h3>
<hr/>

<b>7" Touch Panel Kit</b>

<img src="../img/600px-UDOO_LVDS_7.jpg" alt="alt text" class="img-responsive pull-right" style="margin-bottom:20px; margin-left:30px; width:300px; height:169px;">

* 7" TFT RGB Display
* I2C Touch Screen
* Dual Touch
* Resolution 800X480
* UDOO_VK-7T video cable for UDOO
* LCD BOARD ADAPTER

[How to setup LVDS panels](../Hardware_&_Accessories/UDOO_LVDS_Panels.html)

<a href="http://udoo.org/download/files/datasheets/datasheet7.pdf" target="_blank">UDOO 7" Touch Panel Display Kit Datasheet</a>

<b>15" Touch Panel Kit</b>

<img src="../img/600px-UDOO_LVDS_15.jpg" alt="alt text" class="img-responsive pull-right" style="margin-bottom:20px; margin-left:30px; width:300px; height:169px;">


* 15,6" LVDS Display
* USB Capacitive Touch Screen
* Resolution 1366X768 24bit
* UDOO_VK-15T video cable for UDOO
* USB CABLE for Third UDOO'USB
* Touch Controller Board

[How to setup LVDS panels](../Hardware_&_Accessories/UDOO_LVDS_Panels.html)

<a href="http://udoo.org/download/files/datasheets/datasheet15.pdf">UDOO 15" Touch Panel Display Kit Datasheet</a>


## Community

* Official web site [www.udoo.org](http://www.udoo.org)
* Official forum [www.udoo.org/forum](http://www.udoo.org/forum/index.php)

### Forums

<hr/>

The official UDOO forums can be found at [www.udoo.org/forum](http://www.udoo.org/forum)

The forum search facility has been tweaked to allow more general searching. <b>Please</b> do a search before making a post as the issue may already have been raised and answered.

### IRC channel

<hr/>

There is an (unofficial) UDOO discussion channel on IRC. Using the IRC client of your choice, use server information: `irc.freenode.net`. Room name is `#udoo`.


### Social networks

<hr/>

 * [Facebook fan page](http://www.facebook.com/udooboard)
 * [Twitter](http://twitter.com/UDOO_Board)
 * [Google+](https://plus.google.com/u/0/110742692974455430878/posts)
 * [YouTube](http://www.youtube.com/channel/UCXv5UyGn5jArK8xOAmuSeHg)
