/*
 * Copyright (C) 2014 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this software; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ADC
#endif

// Bitfields in register ADC_HC0.
static const field_t hw_adc_hc0[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1 (conversion ADC_HC0"
        " completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HC1.
static const field_t hw_adc_hc1[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1(conversion ADC_HC0 "
        "completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HS.
static const field_t hw_adc_hs[] =
{
    {
        "COCO0",
        "The COCOn flag is a read-only bit that is set each time a conversion i"
        "s completed when the compare function is disabled (ADC_GC[ACFE]=0) and"
        " the hardware average function is disabled (ADC_GC[AVGE]=0).",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COCO1",
        "See description for COCO0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R0.
static const field_t hw_adc_r0[] =
{
    {
        "D",
        "",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R1.
static const field_t hw_adc_r1[] =
{
    {
        "D",
        "Data (result of an ADC conversion)",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CFG.
static const field_t hw_adc_cfg[] =
{
    {
        "ADICLK",
        "Selects the input clock source to generate the internal clock ADCK.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Used to set the ADC resolution mode.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLSMP",
        "Selects between different sample times based on the ADC_CFG[ADSTS] fie"
        "ld.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIV",
        "Selects the divide ratio used by the ADC to generate the internal cloc"
        "k ADCK.",
        5, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLPC",
        "Puts the ADC hard block into low power mode and reduces the comparator"
        " enable period by controlling its timing in the SAR controller block t"
        "owards the anlong hard block.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADSTS",
        "Defines the sample time duration.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADHSC",
        "This bit configures the ADC for high speed operation.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFSEL",
        "Selects the voltage reference source used for conversions (see the chi"
        "p-specific SARADC information for details).",
        11, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADTRG",
        "Selects the type of trigger used for initiating a conversion.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Determines how many ADC conversions will be averaged to create the ADC"
        " average result.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVWREN",
        "Controls the overwriting of the next converted Data onto the existing "
        "(previous) unread data into the Data result register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GC.
static const field_t hw_adc_gc[] =
{
    {
        "ADACKEN",
        "Enables the ADC's asynchronous clock source and the clock source outpu"
        "t regardless of the conversion and input clock select (ADC_CFG[ADICLK]"
        ") settings of the ADC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAEN",
        "Enables the DMA logic.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACREN",
        "Configures the compare function to check the conversion result of the "
        "input being monitored is either between or outside the range formed by"
        " the compare values in register (ADC_CV) determined by the value of AC"
        "FGT.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFGT",
        "Configures the compare function to check the conversion result relativ"
        "e to the compare value register (ADC_CV) based upon the value of ACREN"
        " (bit 2 in ADC_GC register).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFE",
        "Enables the compare function.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGE",
        "Enables the hardware average function of the ADC.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCO",
        "Enables continuous conversions.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAL",
        "CAL begins the calibration sequence when set.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GS.
static const field_t hw_adc_gs[] =
{
    {
        "ADACT",
        "Indicates that a conversion or hardware averaging is in progress.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CALF",
        "Displays the result of the calibration sequence.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWKST",
        "Holds the status of asynchronous interrupt status that occured during "
        "stop mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CV.
static const field_t hw_adc_cv[] =
{
    {
        "CV1",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function ais enabled (ADC_GC[ACFE]=1).",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CV2",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function and compare range function are enabled (ADC_GC"
        "[ACFE]=1, ADC_GC[ACREN]=1).",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_OFS.
static const field_t hw_adc_ofs[] =
{
    {
        "OFS",
        "User configurable offset value.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIGN",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CAL.
static const field_t hw_adc_cal[] =
{
    {
        "CAL_CODE",
        "This value is automatically loaded and updated at the end of calibrati"
        "on.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ADC module.
static const reg_t hw_adc[] =
{
    {
        "HC0",
        "ADC_HC0 is for use only in hardware trigger mode.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc0
    },
    {
        "HC1",
        "ADC_HC1 are for use only in hardware trigger mode.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc1
    },
    {
        "HS",
        "Bit 0 is used for both software and hardware trigger modes of operatio"
        "n.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_adc_hs
    },
    {
        "R0",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective hardware trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r0
    },
    {
        "R1",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective Hardware Trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r1
    },
    {
        "CFG",
        "Selects the mode of operation, clock source, clock divide, configure f"
        "or low power, long sample time, high speed configuration and selects t"
        "he sample time duration.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_adc_cfg
    },
    {
        "GC",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_adc_gc
    },
    {
        "GS",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_adc_gs
    },
    {
        "CV",
        "Contains compare values used to compare with the conversion result whe"
        "n the compare function is enabled (ADC_GC[ACFE]=1).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_cv
    },
    {
        "OFS",
        "Contains the user-defined offset error correction value.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_ofs
    },
    {
        "CAL",
        "Contains calibration information that is generated by the calibration "
        "function.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_adc_cal
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AFE
#endif

// Bitfields in register AFE_BLOCK_ID.
static const field_t hw_afe_block_id[] =
{
    {
        "BLOCK_ID",
        "",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDBUF.
static const field_t hw_afe_pdbuf[] =
{
    {
        "ACAFE_PD_N",
        "Master power down control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BGR_BGR_PD_N",
        "Both bgr_npd and bgr_bgr_npd have to be enabled for the bandgap to be "
        "in power up.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BGR_PD_N",
        "Both bgr_pd_n and bgr_bgr_pd_n must be enabled for the bandgap to be i"
        "n power up.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TESTBUFFERS_PD_N",
        "",
        3, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_SWRST.
static const field_t hw_afe_swrst[] =
{
    {
        "SYSCLK_SW_RST_N",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADC_PROC_CLK_SW_RST_N",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACAFE_SW_RST_N",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_BGREG.
static const field_t hw_afe_bgreg[] =
{
    {
        "BGR_TRIMLEVEL",
        "Vbg(x) = 0.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BGR_EN_EXT_CURRENT",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ACCESSAR_ID.
static const field_t hw_afe_accessar_id[] =
{
    {
        "ACCESSAR_ID",
        "",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDADC.
static const field_t hw_afe_pdadc[] =
{
    {
        "ACCESSAR_PD_N",
        "Active low power down of all ADC related blocks.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLYLOOP_PD_N",
        "Active low power down of ADC delay loop reference.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADC_IREF_PD_N",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_PD_N",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDSARH.
static const field_t hw_afe_pdsarh[] =
{
    {
        "ADC_PD_N",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDSARL.
static const field_t hw_afe_pdsarl[] =
{
    {
        "ADC_PD_N",
        "",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDADCRFH.
static const field_t hw_afe_pdadcrfh[] =
{
    {
        "ADCREF_REFBUFSLICE_PD_N",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PDADCRFL.
static const field_t hw_afe_pdadcrfl[] =
{
    {
        "ADCREF_REFBUFSLICE_PD_N",
        "",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ADCGN.
static const field_t hw_afe_adcgn[] =
{
    {
        "ADC_GAIN",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_REFTRIML.
static const field_t hw_afe_reftriml[] =
{
    {
        "ADCREF_REFTRIM08",
        "Trim 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCREF_REFTRIM04",
        "Trim 0.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCREF_REFTRIM02",
        "Trim 0.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCREF_REFTRIMOP",
        "Trim reference buffers.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_REFTRIMH.
static const field_t hw_afe_reftrimh[] =
{
    {
        "ADCREF_REFTRIM",
        "Master trim.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_DACAMP.
static const field_t hw_afe_dacamp[] =
{
    {
        "CLAMPDAC_TRIM",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_CLMPDAT.
static const field_t hw_afe_clmpdat[] =
{
    {
        "CLAMPDAC_DATA",
        "Only valid when parameter clamp_current_reg_override is set to registe"
        "r mode.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_CLMPAMP.
static const field_t hw_afe_clmpamp[] =
{
    {
        "CLAMP_DACDATA_EXTRA",
        "Defines non-assigned bits when in current leakage mode.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_DACDATA_WEIGHT",
        "",
        3, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_UPDN_REG_OVERRIDE",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_CURRENT_REG_OVERRIDE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_CLAMP.
static const field_t hw_afe_clamp[] =
{
    {
        "NCLAMP_POWERSAVE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_VN",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_IPEN_REG",
        "Only valid when clamp_updn_reg_override.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_INEN_REG",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_LOWCURRMODE",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV_PROC_CLK",
        "Divides proc_clock by 4 or 8.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_UP_DOWN_POLARITY",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLAMP_PWN_MODE",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_INPBUF.
static const field_t hw_afe_inpbuf[] =
{
    {
        "BUFF_EN_RI",
        "Enable differential output of analog input buffer.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFF_EN_DI",
        "Enable direct input output of analog input buffer.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFF_EN_CM",
        "Enable common-mode output of analog input buffer.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_BUFFER_BP_EN",
        "Bypasses filter when set together with register mux_filterbypass.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_BUFFER_15M_EN",
        "Selects 15 MHz low-pass filter when set together with register [mux_fi"
        "lter_15m_en].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_CLAMPEN",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_INPFLT.
static const field_t hw_afe_inpflt[] =
{
    {
        "MUX_PDCURRENTMIRROR",
        "Enable buffter current mirrors.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_FILTER_15M_EN",
        "Selects 15 MHz low-pass filter when set together with AFE_INPBUF[mux_b"
        "uffer_15m_en].",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_FILTERBYPASS",
        "Bypasses filter when set together with register [mux_buffer_bp_en].",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ADCDGN.
static const field_t hw_afe_adcdgn[] =
{
    {
        "ADC_DIGITAL_GAIN",
        "Digital gain.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADC_DIGITAL_GAIN_BYPASS",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_OFFDRV.
static const field_t hw_afe_offdrv[] =
{
    {
        "ENOFFCHIPDRIVE",
        "Connect input VIN3 directly to ADC P-input and input VIN2 directly to "
        "ADC N-input.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SH_TRIM",
        "Bit[0] enables test mode for ADC reference.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_INPCONFIG.
static const field_t hw_afe_inpconfig[] =
{
    {
        "INPUT_PULLDOWN_EN",
        "Set on unused inputs to minimize crosstalk from unused inputs",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_ENLF",
        "One bit per port.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_PROGDELAY.
static const field_t hw_afe_progdelay[] =
{
    {
        "PROG_DELAY",
        "Programmed value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ADCOMT.
static const field_t hw_afe_adcomt[] =
{
    {
        "OVERRIDE",
        "Selects programmed value instead of value found by algorithm.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAIT_TIME",
        "Defines algorithm update frequency.",
        1, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MEASURE_TIMING",
        "Defines when to measure.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ALGDELAY.
static const field_t hw_afe_algdelay[] =
{
    {
        "ALGORITHM_DELAY",
        "Value found by algorithm.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ACC_ID.
static const field_t hw_afe_acc_id[] =
{
    {
        "BLOCK_ID",
        "",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ACCSTA.
static const field_t hw_afe_accsta[] =
{
    {
        "STATUS",
        "Bit number [2:0] Indicate current function state of the ACC.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ACCNOSLI.
static const field_t hw_afe_accnosli[] =
{
    {
        "NO_OF_SLICES",
        "",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_ACCCALCON.
static const field_t hw_afe_acccalcon[] =
{
    {
        "CALIBRATE_START",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Data output in serial mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CALIB",
        "Allow the user to bypass the calibration sequence for the coefficients"
        " and instead use the default values.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFSET_COMP_EN",
        "If enabled, the parameter ana_offset_comp_en should also be enabled.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANA_OFFSET_COMP_EN",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_BWEWRICTRL.
static const field_t hw_afe_bwewrictrl[] =
{
    {
        "BWE_CTRL",
        "",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWE_WRITE_CTRL",
        "Select programming of new weights can be completed on individual slice"
        "s or all slices minimize the number of writes at once.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_SELSLI.
static const field_t hw_afe_selsli[] =
{
    {
        "SELECT_SLICE",
        "Read/Write selector, lsb.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_SELBYT.
static const field_t hw_afe_selbyt[] =
{
    {
        "SELECT_BYTE",
        "Read/Write, msb.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_REDVAL.
static const field_t hw_afe_redval[] =
{
    {
        "READ_VALUE",
        "Weight read register, lsb.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AFE_WRIBYT.
static const field_t hw_afe_wribyt[] =
{
    {
        "WRITE_BYTE",
        "Weight write register, lsb.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AFE module.
static const reg_t hw_afe[] =
{
    {
        "BLOCK_ID",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_block_id
    },
    {
        "PDBUF",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_afe_pdbuf
    },
    {
        "SWRST",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_afe_swrst
    },
    {
        "BGREG",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_afe_bgreg
    },
    {
        "ACCESSAR_ID",
        "",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_accessar_id
    },
    {
        "PDADC",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_afe_pdadc
    },
    {
        "PDSARH",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_pdsarh
    },
    {
        "PDSARL",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_pdsarl
    },
    {
        "PDADCRFH",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_pdadcrfh
    },
    {
        "PDADCRFL",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_pdadcrfl
    },
    {
        "ADCGN",
        "",
        4, // Width in bytes
        0x0000041c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_adcgn
    },
    {
        "REFTRIML",
        "",
        4, // Width in bytes
        0x00000434, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_afe_reftriml
    },
    {
        "REFTRIMH",
        "",
        4, // Width in bytes
        0x00000438, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_reftrimh
    },
    {
        "DACAMP",
        "",
        4, // Width in bytes
        0x0000044c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_dacamp
    },
    {
        "CLMPDAT",
        "",
        4, // Width in bytes
        0x00000454, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_clmpdat
    },
    {
        "CLMPAMP",
        "",
        4, // Width in bytes
        0x00000458, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_afe_clmpamp
    },
    {
        "CLAMP",
        "",
        4, // Width in bytes
        0x0000045c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_afe_clamp
    },
    {
        "INPBUF",
        "",
        4, // Width in bytes
        0x00000460, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_afe_inpbuf
    },
    {
        "INPFLT",
        "",
        4, // Width in bytes
        0x00000464, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_afe_inpflt
    },
    {
        "ADCDGN",
        "",
        4, // Width in bytes
        0x00000468, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_afe_adcdgn
    },
    {
        "OFFDRV",
        "",
        4, // Width in bytes
        0x0000046c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_afe_offdrv
    },
    {
        "INPCONFIG",
        "",
        4, // Width in bytes
        0x00000470, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_afe_inpconfig
    },
    {
        "PROGDELAY",
        "",
        4, // Width in bytes
        0x00000474, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_progdelay
    },
    {
        "ADCOMT",
        "",
        4, // Width in bytes
        0x00000478, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_afe_adcomt
    },
    {
        "ALGDELAY",
        "",
        4, // Width in bytes
        0x0000047c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_algdelay
    },
    {
        "ACC_ID",
        "",
        4, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_acc_id
    },
    {
        "ACCSTA",
        "",
        4, // Width in bytes
        0x00000804, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_accsta
    },
    {
        "ACCNOSLI",
        "",
        4, // Width in bytes
        0x00000808, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_accnosli
    },
    {
        "ACCCALCON",
        "",
        4, // Width in bytes
        0x0000080c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_afe_acccalcon
    },
    {
        "BWEWRICTRL",
        "",
        4, // Width in bytes
        0x00000810, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_afe_bwewrictrl
    },
    {
        "SELSLI",
        "",
        4, // Width in bytes
        0x00000814, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_selsli
    },
    {
        "SELBYT",
        "",
        4, // Width in bytes
        0x00000818, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_selbyt
    },
    {
        "REDVAL",
        "",
        4, // Width in bytes
        0x00000820, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_afe_redval
    },
    {
        "WRIBYT",
        "",
        4, // Width in bytes
        0x00000824, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_afe_wribyt
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ASRC
#endif

// Bitfields in register ASRC_ASRCTR.
static const field_t hw_asrc_asrctr[] =
{
    {
        "ASRCEN",
        "ASRC Enable Enable the operation of ASRC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREA",
        "ASRC Enable A Enable the operation of the conversion A of ASRC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREB",
        "ASRC Enable B Enable the operation of the conversion B of ASRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREC",
        "ASRC Enable C Enable the operation of the conversion C of ASRC.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRST",
        "Software Reset This bit is self-clear bit.",
        4, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "IDRA",
        "Use Ideal Ratio for Pair A When USRA=0, this bit has no usage.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRA",
        "Use Ratio for Pair A Use ratio as the input to ASRC.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRB",
        "Use Ideal Ratio for Pair B When USRB=0, this bit has no usage.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRB",
        "Use Ratio for Pair B Use ratio as the input to ASRC.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRC",
        "Use Ideal Ratio for Pair C When USRC=0, this bit has no usage.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRC",
        "Use Ratio for Pair C Use ratio as the input to ASRC.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSA",
        "ASRC Pair A Automatic Selection For Processing Options When this bit i"
        "s 1, pair A will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODA, ASRCFG:POSTMODA see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSB",
        "ASRC Pair B Automatic Selection For Processing Options When this bit i"
        "s 1, pair B will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODB, ASRCFG:POSTMODB see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSC",
        "ASRC Pair C Automatic Selection For Processing Options When this bit i"
        "s 1, pair C will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODC, ASRCFG:POSTMODC see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIER.
static const field_t hw_asrc_asrier[] =
{
    {
        "ADIEA",
        "Data Input A Interrupt Enable Enables the data input A Interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEB",
        "Data Input B Interrupt Enable Enables the data input B interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEC",
        "Data Input C Interrupt Enable Enables the data input C interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEA",
        "Data Output A Interrupt Enable Enables the data output A interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEB",
        "Data Output B Interrupt Enable Enables the data output B interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEC",
        "Data Output C Interrupt Enable Enables the data output C interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOLIE",
        "Overload Interrupt Enable Enables the overload interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFPWE",
        "FP in Wait State Interrupt Enable Enables the FP in wait state interru"
        "pt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCNCR.
static const field_t hw_asrc_asrcncr[] =
{
    {
        "ANCA",
        "Number of A Channels",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCB",
        "Number of B Channels",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCC",
        "Number of C ChannelsANCC+ANCB+ANCA<=10.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCFG.
static const field_t hw_asrc_asrcfg[] =
{
    {
        "PREMODA",
        "Pre-Processing Configuration for Conversion Pair A These bits will be "
        "read/write by user if ASRCTR:ATSA=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODA",
        "Post-Processing Configuration for Conversion Pair A These bits will be"
        " read/write by user if ASRCTR:ATSA=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODB",
        "Pre-Processing Configuration for Conversion Pair B These bits will be "
        "read/write by user if ASRCTR:ATSB=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODB",
        "Post-Processing Configuration for Conversion Pair B These bits will be"
        " read/write by user if ASRCTR:ATSB=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODC",
        "Pre-Processing Configuration for Conversion Pair C These bits will be "
        "read/write by user if ASRCTR:ATSC=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODC",
        "Post-Processing Configuration for Conversion Pair C These bits will be"
        " read/write by user if ASRCTR:ATSC=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRA",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir A",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRB",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir B",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRC",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir C",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INIRQA",
        "Initialization for Conversion Pair A is served When this bit is 1, it "
        "means the initialization for conversion pair A is served.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQB",
        "Initialization for Conversion Pair B is served When this bit is 1, it "
        "means the initialization for conversion pair B is served.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQC",
        "Initialization for Conversion Pair C is served When this bit is 1, it "
        "means the initialization for conversion pair C is served.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCSR.
static const field_t hw_asrc_asrcsr[] =
{
    {
        "AICSA",
        "Input Clock Source A",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSB",
        "Input Clock Source B",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSC",
        "Input Clock Source C",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSA",
        "Output Clock Source A",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSB",
        "Output Clock Source B",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSC",
        "Output Clock Source C",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR1.
static const field_t hw_asrc_asrcdr1[] =
{
    {
        "AICPA",
        "Input Clock Prescaler A Specify the prescaling factor of the input pre"
        "scaler A.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDA",
        "Input Clock Divider A Specify the divide ratio of the input clock divi"
        "der A.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICPB",
        "Input Clock Prescaler B Specify the prescaling factor of the input pre"
        "scaler B.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDB",
        "Input Clock Divider B Specify the divide ratio of the input clock divi"
        "der B.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPA",
        "Output Clock Prescaler A Specify the prescaling factor of the output p"
        "rescaler A.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDA",
        "Output Clock Divider A Specify the divide ratio of the output clock di"
        "vider A.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPB",
        "Output Clock Prescaler B Specify the prescaling factor of the output p"
        "rescaler B.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDB",
        "Output Clock Divider B Specify the divide ratio of the output clock di"
        "vider B.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR2.
static const field_t hw_asrc_asrcdr2[] =
{
    {
        "AICPC",
        "Input Clock Prescaler C Specify the prescaling factor of the input pre"
        "scaler C.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDC",
        "Input Clock Divider C Specify the divide ratio of the input clock divi"
        "der C.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPC",
        "Output Clock Prescaler C Specify the prescaling factor of the output p"
        "rescaler C.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDC",
        "Output Clock Divider C Specify the divide ratio of the output clock di"
        "vider C.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRSTR.
static const field_t hw_asrc_asrstr[] =
{
    {
        "AIDEA",
        "Number of data in Input Data Buffer A is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRA is "
        "less than threshold and the processor can write data to ASRDIRA.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEB",
        "Number of data in Input Data Buffer B is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRB is "
        "less than threshold and the processor can write data to ASRDIRB.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEC",
        "Number of data in Input Data Buffer C is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRC is "
        "less than threshold and the processor can write data to ASRDIRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFA",
        "Number of data in Output Data Buffer A is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "A is greater than threshold and the processor can read data from ASRDO"
        "RA.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFB",
        "Number of data in Output Data Buffer B is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "B is greater than threshold and the processor can read data from ASRDO"
        "RB.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFC",
        "Number of data in Output Data Buffer C is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "C is greater than threshold and the processor can read data from ASRDO"
        "RC.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOLE",
        "Overload Error Flag When set, this bit indicates that the task rate is"
        " too high for the ASRC to handle.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FPWT",
        "FP is in wait states This bit is for debug only.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUA",
        "Input Data Buffer A has underflowed When set, this bit indicates that "
        "input data buffer A has underflowed.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUB",
        "Input Data Buffer B has underflowed When set, this bit indicates that "
        "input data buffer B has underflowed.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUC",
        "Input Data Buffer C has underflowed When set, this bit indicates that "
        "input data buffer C has underflowed.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOA",
        "Output Data Buffer A has overflowed When set, this bit indicates that "
        "output data buffer A has overflowed.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOB",
        "Output Data Buffer B has overflowed When set, this bit indicates that "
        "output data buffer B has overflowed.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOC",
        "Output Data Buffer C has overflowed When set, this bit indicates that "
        "output data buffer C has overflowed.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLA",
        "Pair A Input Task Overload When set, this bit indicates that pair A in"
        "put task is oveloaded.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLB",
        "Pair B Input Task Overload When set, this bit indicates that pair B in"
        "put task is oveloaded.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLC",
        "Pair C Input Task Overload When set, this bit indicates that pair C in"
        "put task is oveloaded.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLA",
        "Pair A Output Task Overload When set, this bit indicates that pair A o"
        "utput task is oveloaded.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLB",
        "Pair B Output Task Overload When set, this bit indicates that pair B o"
        "utput task is oveloaded.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLC",
        "Pair C Output Task Overload When set, this bit indicates that pair C o"
        "utput task is oveloaded.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ATQOL",
        "Task Queue FIFO overload When set, this bit indicates that task queue "
        "FIFO logic is oveloaded.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DSLCNT",
        "DSL Counter Input to FIFO ready When set, this bit indicates that new "
        "DSL counter information is stored in the internal ASRC FIFO.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn1.
static const field_t hw_asrc_asrpmn1[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn2.
static const field_t hw_asrc_asrpmn2[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn3.
static const field_t hw_asrc_asrpmn3[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn4.
static const field_t hw_asrc_asrpmn4[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn5.
static const field_t hw_asrc_asrpmn5[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRTFR1.
static const field_t hw_asrc_asrtfr1[] =
{
    {
        "TF_BASE",
        "Base address for task queue FIFO.",
        6, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF_FILL",
        "Current number of entries in task queue FIFO.",
        13, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCCR.
static const field_t hw_asrc_asrccr[] =
{
    {
        "ACIA",
        "The channel counter for Pair A's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair A"
        "'s input FIFO's usage.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIB",
        "The channel counter for Pair B's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair B"
        "'s input FIFO's usage.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIC",
        "The channel counter for Pair C's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair C"
        "'s input FIFO's usage.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOA",
        "The channel counter for Pair A's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "A's output FIFO's usage.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOB",
        "The channel counter for Pair B's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "B's output FIFO's usage.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOC",
        "The channel counter for Pair C's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "C's output FIFO's usage.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIA.
static const field_t hw_asrc_asrdia[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOA.
static const field_t hw_asrc_asrdoa[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIB.
static const field_t hw_asrc_asrdib[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOB.
static const field_t hw_asrc_asrdob[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIC.
static const field_t hw_asrc_asrdic[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOC.
static const field_t hw_asrc_asrdoc[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHA.
static const field_t hw_asrc_asridrha[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLA.
static const field_t hw_asrc_asridrla[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHB.
static const field_t hw_asrc_asridrhb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLB.
static const field_t hw_asrc_asridrlb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHC.
static const field_t hw_asrc_asridrhc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLC.
static const field_t hw_asrc_asridrlc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR76K.
static const field_t hw_asrc_asr76k[] =
{
    {
        "ASR76K",
        "Value for the period of the 76kHz sampling clock.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR56K.
static const field_t hw_asrc_asr56k[] =
{
    {
        "ASR56K",
        "Value for the period of the 56kHz sampling clock",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRA.
static const field_t hw_asrc_asrmcra[] =
{
    {
        "INFIFO_THRESHOLDA",
        "The threshold for Pair A's input FIFO per channel These bits stand for"
        " the threshold for Pair A's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFA",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOA=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFA",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIA=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDA",
        "The threshold for Pair A's output FIFO per channel These bits stand fo"
        "r the threshold for Pair A's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYA",
        "Bypass Polyphase Filtering for Pair A This bit will determine whether "
        "the polyphase filtering part of Pair A conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLA",
        "Stall Pair A conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair A.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHA",
        "Use external thresholds for FIFO control of Pair A This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair A.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFA",
        "Initialize buf of Pair A when pair A is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTA.
static const field_t hw_asrc_asrfsta[] =
{
    {
        "INFIFO_FILLA",
        "The fillings for Pair A's input FIFO per channel These bits stand for "
        "the fillings for Pair A's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEA",
        "Input FIFO is near Empty for Pair A This bit is to indicate whether th"
        "e input FIFO of Pair A is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLA",
        "The fillings for Pair A's output FIFO per channel These bits stand for"
        " the fillings for Pair A's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFA",
        "Output FIFO is near Full for Pair A This bit is to indicate whether th"
        "e output FIFO of Pair A is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRB.
static const field_t hw_asrc_asrmcrb[] =
{
    {
        "INFIFO_THRESHOLDB",
        "The threshold for Pair B's input FIFO per channel These bits stand for"
        " the threshold for Pair B's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFB",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOB=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFB",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIB=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDB",
        "The threshold for Pair B's output FIFO per channel These bits stand fo"
        "r the threshold for Pair B's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYB",
        "Bypass Polyphase Filtering for Pair B This bit will determine whether "
        "the polyphase filtering part of Pair B conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLB",
        "Stall Pair B conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair B.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHB",
        "Use external thresholds for FIFO control of Pair B This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair B.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFB",
        "Initialize buf of Pair B when pair B is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair B is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTB.
static const field_t hw_asrc_asrfstb[] =
{
    {
        "INFIFO_FILLB",
        "The fillings for Pair B's input FIFO per channel These bits stand for "
        "the fillings for Pair B's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEB",
        "Input FIFO is near Empty for Pair B This bit is to indicate whether th"
        "e input FIFO of Pair B is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLB",
        "The fillings for Pair B's output FIFO per channel These bits stand for"
        " the fillings for Pair B's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFB",
        "Output FIFO is near Full for Pair B This bit is to indicate whether th"
        "e output FIFO of Pair B is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRC.
static const field_t hw_asrc_asrmcrc[] =
{
    {
        "INFIFO_THRESHOLDC",
        "The threshold for Pair C's input FIFO per channel These bits stand for"
        " the threshold for Pair C's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFC",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOC=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFC",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIC=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDC",
        "The threshold for Pair C's output FIFO per channel These bits stand fo"
        "r the threshold for Pair C's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYC",
        "Bypass Polyphase Filtering for Pair C This bit will determine whether "
        "the polyphase filtering part of Pair C conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLC",
        "Stall Pair C conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair C.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHC",
        "Use external thresholds for FIFO control of Pair C This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair C.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFC",
        "Initialize buf of Pair C when pair C is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair C is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTC.
static const field_t hw_asrc_asrfstc[] =
{
    {
        "INFIFO_FILLC",
        "The fillings for Pair C's input FIFO per channel These bits stand for "
        "the fillings for Pair C's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEC",
        "Input FIFO is near Empty for Pair C This bit is to indicate whether th"
        "e input FIFO of Pair C is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLC",
        "The fillings for Pair C's output FIFO per channel These bits stand for"
        " the fillings for Pair C's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFC",
        "Output FIFO is near Full for Pair C This bit is to indicate whether th"
        "e output FIFO of Pair C is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1A.
static const field_t hw_asrc_asrmcr1a[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1B.
static const field_t hw_asrc_asrmcr1b[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1C.
static const field_t hw_asrc_asrmcr1c[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ASRC module.
static const reg_t hw_asrc[] =
{
    {
        "ASRCTR",
        "The ASRC control register (ASRCTR) is a 24-bit read/write register tha"
        "t controls the ASRC operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_asrc_asrctr
    },
    {
        "ASRIER",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrier
    },
    {
        "ASRCNCR",
        "The ASRC channel number configuration register (ASRCNCR) is a 24-bit r"
        "ead/write register that sets the number of channels used by each ASRC "
        "conversion pair.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_asrc_asrcncr
    },
    {
        "ASRCFG",
        "The ASRC configuration status register (ASRCFG) is a 24-bit read/write"
        " register that sets and/or automatically senses the ASRC operations.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_asrc_asrcfg
    },
    {
        "ASRCSR",
        "The ASRC clock source register (ASRCSR) is a 24-bit read/write registe"
        "r that controls the sources of the input and output clocks of the ASRC"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrcsr
    },
    {
        "ASRCDR1",
        "The ASRC clock divider register (ASRCDR1) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrcdr1
    },
    {
        "ASRCDR2",
        "The ASRC clock divider register (ASRCDR2) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_asrc_asrcdr2
    },
    {
        "ASRSTR",
        "The ASRC status register (ASRSTR) is a 24-bit read-write register used"
        " by the processor core to examine the status of the ASRC block and cle"
        "ar the overload interrupt request and AOLE flag bit.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        22, // Number of bitfields
        hw_asrc_asrstr
    },
    {
        "ASRPMn1",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn1
    },
    {
        "ASRPMn2",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn2
    },
    {
        "ASRPMn3",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn3
    },
    {
        "ASRPMn4",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn4
    },
    {
        "ASRPMn5",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn5
    },
    {
        "ASRTFR1",
        "The register defines and shows the parameters for ASRC inner task queu"
        "e FIFOs.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrtfr1
    },
    {
        "ASRCCR",
        "The ASRC channel counter register (ASRCCR) is a 24-bit read/write regi"
        "ster that sets and reflects the current specific input/output FIFO bei"
        "ng accessed through shared peripheral bus for each ASRC conversion pai"
        "r.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrccr
    },
    {
        "ASRDIA",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000060, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdia
    },
    {
        "ASRDOA",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoa
    },
    {
        "ASRDIB",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000068, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdib
    },
    {
        "ASRDOB",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdob
    },
    {
        "ASRDIC",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000070, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdic
    },
    {
        "ASRDOC",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoc
    },
    {
        "ASRIDRHA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrha
    },
    {
        "ASRIDRLA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrla
    },
    {
        "ASRIDRHB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhb
    },
    {
        "ASRIDRLB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlb
    },
    {
        "ASRIDRHC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhc
    },
    {
        "ASRIDRLC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlc
    },
    {
        "ASR76K",
        "The register (ASR76K) holds the period of the 76kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr76k
    },
    {
        "ASR56K",
        "The register (ASR56K) holds the period of the 56kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr56k
    },
    {
        "ASRMCRA",
        "The register (ASRMCRA) is used to control Pair A internal logic.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcra
    },
    {
        "ASRFSTA",
        "The register (ASRFSTA) is used to show Pair A internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfsta
    },
    {
        "ASRMCRB",
        "The register (ASRMCRB) is used to control Pair B internal logic.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrb
    },
    {
        "ASRFSTB",
        "The register (ASRFSTB) is used to show Pair B internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstb
    },
    {
        "ASRMCRC",
        "The register (ASRMCRC) is used to control Pair C internal logic.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrc
    },
    {
        "ASRFSTC",
        "The register (ASRFSTC) is used to show Pair C internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstc
    },
    {
        "ASRMCR1A",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1a
    },
    {
        "ASRMCR1B",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1b
    },
    {
        "ASRMCR1C",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1c
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AUDMUX
#endif

// Bitfields in register AUDMUX_PTCR1.
static const field_t hw_audmux_ptcr1[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR1.
static const field_t hw_audmux_pdcr1[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR2.
static const field_t hw_audmux_ptcr2[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR2.
static const field_t hw_audmux_pdcr2[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR3.
static const field_t hw_audmux_ptcr3[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR3.
static const field_t hw_audmux_pdcr3[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR4.
static const field_t hw_audmux_ptcr4[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR4.
static const field_t hw_audmux_pdcr4[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR5.
static const field_t hw_audmux_ptcr5[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR5.
static const field_t hw_audmux_pdcr5[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR6.
static const field_t hw_audmux_ptcr6[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR6.
static const field_t hw_audmux_pdcr6[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR7.
static const field_t hw_audmux_ptcr7[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR7.
static const field_t hw_audmux_pdcr7[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AUDMUX module.
static const reg_t hw_audmux[] =
{
    {
        "PTCR1",
        "PTCR1 is the Port Timing Control Register for Port 1.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr1
    },
    {
        "PDCR1",
        "PDCR1 is the Port Data Control Register for Port 1.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr1
    },
    {
        "PTCR2",
        "PTCR2 is the Port Timing Control Register for Port 2.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr2
    },
    {
        "PDCR2",
        "PDCR2 is the Port Data Control Register for Port 2.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr2
    },
    {
        "PTCR3",
        "PTCR3 is the Port Timing Control Register for Port 3.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr3
    },
    {
        "PDCR3",
        "PDCR3 is the Port Data Control Register for Port 3.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr3
    },
    {
        "PTCR4",
        "Port Timing Control Register for Port 4",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr4
    },
    {
        "PDCR4",
        "PDCR4 is the Port Data Control Register for Port 4.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr4
    },
    {
        "PTCR5",
        "Port Timing Control Register for Port 5",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr5
    },
    {
        "PDCR5",
        "PDCR5 is the Port Data Control Register for Port 5.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr5
    },
    {
        "PTCR6",
        "Port Timing Control Register for Port 6",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr6
    },
    {
        "PDCR6",
        "PDCR6 is the Port Data Control Register for Port 6.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr6
    },
    {
        "PTCR7",
        "Port Timing Control Register for Port 7",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr7
    },
    {
        "PDCR7",
        "PDCR7 is the Port Data Control Register for Port 7.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr7
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark BCH
#endif

// Bitfields in register BCH_CTRL.
static const field_t hw_bch_ctrl[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Reserved, always set these bits to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "Reserved, always set these bits to zero.",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "Reserved, always set these bits to zero.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "Reserved, always set this bit to zero.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_SET.
static const field_t hw_bch_ctrl_set[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Reserved, always set these bits to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "Reserved, always set these bits to zero.",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "Reserved, always set these bits to zero.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "Reserved, always set this bit to zero.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_CLR.
static const field_t hw_bch_ctrl_clr[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Reserved, always set these bits to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "Reserved, always set these bits to zero.",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "Reserved, always set these bits to zero.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "Reserved, always set this bit to zero.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_TOG.
static const field_t hw_bch_ctrl_tog[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Reserved, always set these bits to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "Reserved, always set these bits to zero.",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "Reserved, always set these bits to zero.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "Reserved, always set this bit to zero.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0.
static const field_t hw_bch_status0[] =
{
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_SET.
static const field_t hw_bch_status0_set[] =
{
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_CLR.
static const field_t hw_bch_status0_clr[] =
{
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_TOG.
static const field_t hw_bch_status0_tog[] =
{
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE.
static const field_t hw_bch_mode[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash page f"
        "or it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set these bits to zero.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_SET.
static const field_t hw_bch_mode_set[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash page f"
        "or it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set these bits to zero.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_CLR.
static const field_t hw_bch_mode_clr[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash page f"
        "or it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set these bits to zero.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_TOG.
static const field_t hw_bch_mode_tog[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash page f"
        "or it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "Reserved, always set these bits to zero.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR.
static const field_t hw_bch_encodeptr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_SET.
static const field_t hw_bch_encodeptr_set[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_CLR.
static const field_t hw_bch_encodeptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_TOG.
static const field_t hw_bch_encodeptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR.
static const field_t hw_bch_dataptr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_SET.
static const field_t hw_bch_dataptr_set[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_CLR.
static const field_t hw_bch_dataptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_TOG.
static const field_t hw_bch_dataptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR.
static const field_t hw_bch_metaptr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_SET.
static const field_t hw_bch_metaptr_set[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_CLR.
static const field_t hw_bch_metaptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_TOG.
static const field_t hw_bch_metaptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT.
static const field_t hw_bch_layoutselect[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_SET.
static const field_t hw_bch_layoutselect_set[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_CLR.
static const field_t hw_bch_layoutselect_clr[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_TOG.
static const field_t hw_bch_layoutselect_tog[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0.
static const field_t hw_bch_flash0layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_SET.
static const field_t hw_bch_flash0layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_CLR.
static const field_t hw_bch_flash0layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_TOG.
static const field_t hw_bch_flash0layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1.
static const field_t hw_bch_flash0layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_SET.
static const field_t hw_bch_flash0layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_CLR.
static const field_t hw_bch_flash0layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_TOG.
static const field_t hw_bch_flash0layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0.
static const field_t hw_bch_flash1layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_SET.
static const field_t hw_bch_flash1layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_CLR.
static const field_t hw_bch_flash1layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_TOG.
static const field_t hw_bch_flash1layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1.
static const field_t hw_bch_flash1layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_SET.
static const field_t hw_bch_flash1layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_CLR.
static const field_t hw_bch_flash1layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_TOG.
static const field_t hw_bch_flash1layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0.
static const field_t hw_bch_flash2layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_SET.
static const field_t hw_bch_flash2layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_CLR.
static const field_t hw_bch_flash2layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_TOG.
static const field_t hw_bch_flash2layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1.
static const field_t hw_bch_flash2layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_SET.
static const field_t hw_bch_flash2layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_CLR.
static const field_t hw_bch_flash2layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_TOG.
static const field_t hw_bch_flash2layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0.
static const field_t hw_bch_flash3layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_SET.
static const field_t hw_bch_flash3layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_CLR.
static const field_t hw_bch_flash3layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_TOG.
static const field_t hw_bch_flash3layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1.
static const field_t hw_bch_flash3layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_SET.
static const field_t hw_bch_flash3layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_CLR.
static const field_t hw_bch_flash3layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_TOG.
static const field_t hw_bch_flash3layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0.
static const field_t hw_bch_debug0[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all synd_gen writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and it has completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one to cause the KES engine to suppress toggling the KES_BM_DON"
        "E signal to the bus master and to suppress toggling the CF_BM_DONE sig"
        "nal by the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field will be shifted into the syndrome re"
        "gister array at the input of the KES engine whenever BCH_DEBUG0_KES_DE"
        "BUG_SHIFT_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_SET.
static const field_t hw_bch_debug0_set[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all synd_gen writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and it has completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one to cause the KES engine to suppress toggling the KES_BM_DON"
        "E signal to the bus master and to suppress toggling the CF_BM_DONE sig"
        "nal by the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field will be shifted into the syndrome re"
        "gister array at the input of the KES engine whenever BCH_DEBUG0_KES_DE"
        "BUG_SHIFT_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_CLR.
static const field_t hw_bch_debug0_clr[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all synd_gen writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and it has completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one to cause the KES engine to suppress toggling the KES_BM_DON"
        "E signal to the bus master and to suppress toggling the CF_BM_DONE sig"
        "nal by the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field will be shifted into the syndrome re"
        "gister array at the input of the KES engine whenever BCH_DEBUG0_KES_DE"
        "BUG_SHIFT_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_TOG.
static const field_t hw_bch_debug0_tog[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set these bits to zero.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all synd_gen writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and it has completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one to cause the KES engine to suppress toggling the KES_BM_DON"
        "E signal to the bus master and to suppress toggling the CF_BM_DONE sig"
        "nal by the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field will be shifted into the syndrome re"
        "gister array at the input of the KES engine whenever BCH_DEBUG0_KES_DE"
        "BUG_SHIFT_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved, always set these bits to zero.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD.
static const field_t hw_bch_dbgkesread[] =
{
    {
        "VALUES",
        "This register will return the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_SET.
static const field_t hw_bch_dbgkesread_set[] =
{
    {
        "VALUES",
        "This register will return the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_CLR.
static const field_t hw_bch_dbgkesread_clr[] =
{
    {
        "VALUES",
        "This register will return the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_TOG.
static const field_t hw_bch_dbgkesread_tog[] =
{
    {
        "VALUES",
        "This register will return the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD.
static const field_t hw_bch_dbgcsferead[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_SET.
static const field_t hw_bch_dbgcsferead_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_CLR.
static const field_t hw_bch_dbgcsferead_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_TOG.
static const field_t hw_bch_dbgcsferead_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD.
static const field_t hw_bch_dbgsyndgenread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_SET.
static const field_t hw_bch_dbgsyndgenread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_CLR.
static const field_t hw_bch_dbgsyndgenread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_TOG.
static const field_t hw_bch_dbgsyndgenread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD.
static const field_t hw_bch_dbgahbmread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_SET.
static const field_t hw_bch_dbgahbmread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_CLR.
static const field_t hw_bch_dbgahbmread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_TOG.
static const field_t hw_bch_dbgahbmread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME.
static const field_t hw_bch_blockname[] =
{
    {
        "NAME",
        "Should be the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_SET.
static const field_t hw_bch_blockname_set[] =
{
    {
        "NAME",
        "Should be the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_CLR.
static const field_t hw_bch_blockname_clr[] =
{
    {
        "NAME",
        "Should be the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_TOG.
static const field_t hw_bch_blockname_tog[] =
{
    {
        "NAME",
        "Should be the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION.
static const field_t hw_bch_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_SET.
static const field_t hw_bch_version_set[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_CLR.
static const field_t hw_bch_version_clr[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_TOG.
static const field_t hw_bch_version_tog[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a BCH module.
static const reg_t hw_bch[] =
{
    {
        "CTRL",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl
    },
    {
        "CTRL_SET",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_set
    },
    {
        "CTRL_CLR",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_clr
    },
    {
        "CTRL_TOG",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_tog
    },
    {
        "STATUS0",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0
    },
    {
        "STATUS0_SET",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_set
    },
    {
        "STATUS0_CLR",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_clr
    },
    {
        "STATUS0_TOG",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_tog
    },
    {
        "MODE",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode
    },
    {
        "MODE_SET",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_set
    },
    {
        "MODE_CLR",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_clr
    },
    {
        "MODE_TOG",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_tog
    },
    {
        "ENCODEPTR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr
    },
    {
        "ENCODEPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_set
    },
    {
        "ENCODEPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_clr
    },
    {
        "ENCODEPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_tog
    },
    {
        "DATAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr
    },
    {
        "DATAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_set
    },
    {
        "DATAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_clr
    },
    {
        "DATAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_tog
    },
    {
        "METAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr
    },
    {
        "METAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_set
    },
    {
        "METAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_clr
    },
    {
        "METAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_tog
    },
    {
        "LAYOUTSELECT",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect
    },
    {
        "LAYOUTSELECT_SET",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_set
    },
    {
        "LAYOUTSELECT_CLR",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_clr
    },
    {
        "LAYOUTSELECT_TOG",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_tog
    },
    {
        "FLASH0LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0
    },
    {
        "FLASH0LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_set
    },
    {
        "FLASH0LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_clr
    },
    {
        "FLASH0LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_tog
    },
    {
        "FLASH0LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1
    },
    {
        "FLASH0LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_set
    },
    {
        "FLASH0LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_clr
    },
    {
        "FLASH0LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_tog
    },
    {
        "FLASH1LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0
    },
    {
        "FLASH1LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_set
    },
    {
        "FLASH1LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_clr
    },
    {
        "FLASH1LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_tog
    },
    {
        "FLASH1LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1
    },
    {
        "FLASH1LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_set
    },
    {
        "FLASH1LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_clr
    },
    {
        "FLASH1LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000bc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_tog
    },
    {
        "FLASH2LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0
    },
    {
        "FLASH2LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_set
    },
    {
        "FLASH2LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_clr
    },
    {
        "FLASH2LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_tog
    },
    {
        "FLASH2LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1
    },
    {
        "FLASH2LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_set
    },
    {
        "FLASH2LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_clr
    },
    {
        "FLASH2LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_tog
    },
    {
        "FLASH3LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0
    },
    {
        "FLASH3LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_set
    },
    {
        "FLASH3LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_clr
    },
    {
        "FLASH3LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_tog
    },
    {
        "FLASH3LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1
    },
    {
        "FLASH3LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_set
    },
    {
        "FLASH3LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_clr
    },
    {
        "FLASH3LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_tog
    },
    {
        "DEBUG0",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0
    },
    {
        "DEBUG0_SET",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_set
    },
    {
        "DEBUG0_CLR",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_clr
    },
    {
        "DEBUG0_TOG",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_tog
    },
    {
        "DBGKESREAD",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread
    },
    {
        "DBGKESREAD_SET",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_set
    },
    {
        "DBGKESREAD_CLR",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_clr
    },
    {
        "DBGKESREAD_TOG",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_tog
    },
    {
        "DBGCSFEREAD",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead
    },
    {
        "DBGCSFEREAD_SET",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_set
    },
    {
        "DBGCSFEREAD_CLR",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000128, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_clr
    },
    {
        "DBGCSFEREAD_TOG",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000012c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_tog
    },
    {
        "DBGSYNDGENREAD",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread
    },
    {
        "DBGSYNDGENREAD_SET",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_set
    },
    {
        "DBGSYNDGENREAD_CLR",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_clr
    },
    {
        "DBGSYNDGENREAD_TOG",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_tog
    },
    {
        "DBGAHBMREAD",
        "The hardware BCH ECC accelerator bus master and ecc controller interna"
        "l state machines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread
    },
    {
        "DBGAHBMREAD_SET",
        "The hardware BCH ECC accelerator bus master and ecc controller interna"
        "l state machines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_set
    },
    {
        "DBGAHBMREAD_CLR",
        "The hardware BCH ECC accelerator bus master and ecc controller interna"
        "l state machines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000148, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_clr
    },
    {
        "DBGAHBMREAD_TOG",
        "The hardware BCH ECC accelerator bus master and ecc controller interna"
        "l state machines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_tog
    },
    {
        "BLOCKNAME",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname
    },
    {
        "BLOCKNAME_SET",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_set
    },
    {
        "BLOCKNAME_CLR",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_clr
    },
    {
        "BLOCKNAME_TOG",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_tog
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version
    },
    {
        "VERSION_SET",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_set
    },
    {
        "VERSION_CLR",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_clr
    },
    {
        "VERSION_TOG",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_CCR.
static const field_t hw_ccm_ccr[] =
{
    {
        "OSCNT",
        "Oscillator ready counter value.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_EN",
        "On chip oscillator enable bit - this bit value is reflected on the out"
        "put cosc_en.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG_BYPASS_COUNT",
        "Counter for analog_reg_bypass signal assertion after standby voltage r"
        "equest by PMIC_STBY_REQ.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBC_EN",
        "Enable for REG_BYPASS_COUNTER.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCDR.
static const field_t hw_ccm_ccdr[] =
{
    {
        "MMDC_MASK",
        "During divider ratio mmdc_axi_podf change or sync mux periph2_clk_sel "
        "change (but not jtag) or SRC request during warm reset, mask handshake"
        " with mmdc module.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSR.
static const field_t hw_ccm_csr[] =
{
    {
        "REF_EN_B",
        "Status of the value of CCM_REF_EN_B output of ccm",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COSC_READY",
        "Status indication of on board oscillator.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCSR.
static const field_t hw_ccm_ccsr[] =
{
    {
        "PLL3_SW_CLK_SEL",
        "Selects source to generate pll3_sw_clk.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL1_SW_CLK_SEL",
        "Selects source to generate pll1_sw_clk.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STEP_SEL",
        "Selects the option to be chosen for the step frequency when shifting A"
        "RM frequency.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CACRR.
static const field_t hw_ccm_cacrr[] =
{
    {
        "ARM_PODF",
        "Divider for ARM clock root.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCDR.
static const field_t hw_ccm_cbcdr[] =
{
    {
        "PERIPH2_CLK2_PODF",
        "Divider for periph2_clk2 podf.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FABRIC_MMDC_PODF",
        "Post divider for fabric / mmdc clock.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_CLK_SEL",
        "OCRAM clock source select",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_ALT_CLK_SEL",
        "OCRAM alternative clock select",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPG_PODF",
        "Divider for ipg podf.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF",
        "Divider for AHB PODF.",
        10, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_PODF",
        "Post divider for ocram clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL",
        "Selector for peripheral main clock (source of MMDC_CLK_ROOT).",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL",
        "Selector for peripheral2 main clock (source of mmdc_clk_root ).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_PODF",
        "Divider for periph2 clock podf.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCMR.
static const field_t hw_ccm_cbcmr[] =
{
    {
        "GPU_CORE_SEL",
        "Selector for gpu_core clock multiplexer",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_AXI_SEL",
        "Selector for gpu_axi clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_AXI_CLK_SEL",
        "Selector for pcie_axi clock multiplexer",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_SEL",
        "Selector for peripheral clk2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH_CLK_SEL",
        "Selector for pre_periph clock multiplexer",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK2_SEL",
        "Selector for periph2_clk2 clock multiplexer",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH2_CLK_SEL",
        "Selector for pre_periph2 clock multiplexer",
        21, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PODF",
        "Post-divider for lcdif1 clock.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_AXI_PODF",
        "Divider for gpu_axi_podf.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_CORE_PODF",
        "Post divider for gpu_core clock.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR1.
static const field_t hw_ccm_cscmr1[] =
{
    {
        "PERCLK_PODF",
        "Divider for perclk podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERCLK_CLK_SEL",
        "Selector for the perclk clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_SEL",
        "QSPI1 clock select",
        7, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_SEL",
        "Selector for ssi1 clock multiplexer",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_SEL",
        "Selector for ssi2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_SEL",
        "Selector for ssi3 clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_CLK_SEL",
        "Selector for usdhc1 clock multiplexer",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_CLK_SEL",
        "Selector for usdhc2 clock multiplexer",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_CLK_SEL",
        "Selector for usdhc3 clock multiplexer",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_CLK_SEL",
        "Selector for usdhc4 clock multiplexer",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF2_PODF",
        "Post-divider for lcdif2 clock.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_PODF",
        "Divider for aclk_eim_slow clock root.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_PODF",
        "Divider for QSPI1 clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_SEL",
        "Selector for aclk_eim_slow root clock multiplexer",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR2.
static const field_t hw_ccm_cscmr2[] =
{
    {
        "CAN_CLK_PODF",
        "Divider for can clock podf.",
        2, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN_CLK_SEL",
        "Selector for FlexCAN clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_DIV",
        "Control for divider of ldb clock for di0",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_DIV",
        "Control for divider of ldb clock for di1",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_SEL",
        "Selector for esai clock multiplexer",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_SEL",
        "Selector for vid clock multiplexer",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PRE_PODF",
        "Post-divider for vid clock root",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PODF",
        "Post-divider for vid clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR1.
static const field_t hw_ccm_cscdr1[] =
{
    {
        "UART_CLK_PODF",
        "Divider for uart clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UART_CLK_SEL",
        "Selector for the UART clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_PODF",
        "Divider for usdhc1 clock podf.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_PODF",
        "Divider for usdhc2 clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_PODF",
        "Divider for usdhc3 clock podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_PODF",
        "Divider for esdhc4 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS1CDR.
static const field_t hw_ccm_cs1cdr[] =
{
    {
        "SSI1_CLK_PODF",
        "Divider for ssi1 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_PRED",
        "Divider for ssi1 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PRED",
        "Divider for esai clock pred.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PODF",
        "Divider for ssi3 clock podf.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PRED",
        "Divider for ssi3 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PODF",
        "Divider for esai clock podf.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS2CDR.
static const field_t hw_ccm_cs2cdr[] =
{
    {
        "SSI2_CLK_PODF",
        "Divider for ssi2 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_PRED",
        "Divider for ssi2 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_CLK_SEL",
        "Selector for ldb_di1 clock multiplexerMultiplexor should be updated wh"
        "en both input and output clocks are gated.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_CLK_SEL",
        "Selector for ldb_di1 clock multiplexerMultiplexor should be updated wh"
        "en both input and output clocks are gated.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI2_CLK_SEL",
        "Selector for QSPI2 clock multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI2_CLK_PRED",
        "Divider for QSPI1 clock pred divider.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI2_CLK_PODF",
        "Divider for QSPI2 clock divider.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CDCDR.
static const field_t hw_ccm_cdcdr[] =
{
    {
        "AUDIO_CLK_SEL",
        "Selector for audio clock multiplexer",
        7, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_CLK_PODF",
        "Divider for audio clock podf.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_CLK_PRED",
        "Divider for audio clock pred.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_SEL",
        "Selector for spdif0 clock multiplexer",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PODF",
        "Divider for spdif0 clock podf.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PRED",
        "Divider for spdif0 clock pred.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CHSCCDR.
static const field_t hw_ccm_chsccdr[] =
{
    {
        "M4_CLK_SEL",
        "Selector for M4 root clock multiplexer",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M4_PODF",
        "Divider for M4 clock divider.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M4_PRE_CLK_SEL",
        "Selector for M4 root clock pre-multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_CLK_SEL",
        "Selector for ENET root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_PODF",
        "Divider for ENET clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_PRE_CLK_SEL",
        "Selector for ENET root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR2.
static const field_t hw_ccm_cscdr2[] =
{
    {
        "LCDIF2_CLK_SEL",
        "Selector for lcdif2 root clock multiplexer",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF2_PRED",
        "Pre-divider for lcdif2 clock.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF2_PRE_CLK_SEL",
        "Selector for lcdif2 root clock pre-multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_CLK_SEL",
        "Selector for lcdif1 root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRED",
        "Pre-divider for lcdif1 clock.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRE_CLK_SEL",
        "Selector for lcdif1 root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_SEL",
        "Selector for the ECSPI clock multiplexor",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_PODF",
        "Divider for ecspi clock podf.",
        19, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR3.
static const field_t hw_ccm_cscdr3[] =
{
    {
        "CSI_CLK_SEL",
        "Selector for csi clock multiplexer",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_PODF",
        "Post divider for csi_core clock.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISPLAY_CLK_SEL",
        "Selector for display clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISPLAY_PODF",
        "Divider for display clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CWDR.
static const field_t hw_ccm_cwdr[] =
{
    { 0 } // Terminator
};

// Bitfields in register CCM_CDHIPR.
static const field_t hw_ccm_cdhipr[] =
{
    {
        "OCRAM_PODF_BUSY",
        "Busy indicator for ocram_podf.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AHB_PODF_BUSY",
        "Busy indicator for ahb_podf.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_PODF_BUSY",
        "Busy indicator for mmdc_axi_podf.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_BUSY",
        "Busy indicator for periph2_clk_sel mux control.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH_CLK_SEL_BUSY",
        "Busy indicator for periph_clk_sel mux control.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_PODF_BUSY",
        "Busy indicator for arm_podf.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CLPCR.
static const field_t hw_ccm_clpcr[] =
{
    {
        "LPM",
        "Setting the low power mode that system will enter on next assertion of"
        " dsm_request signal.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_CLK_DIS_ON_LPM",
        "Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_w"
        "rck) will be disabled on wait mode.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SBYOS",
        "Standby clock oscillator bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_REF_OSC",
        "dis_ref_osc - in run mode, software can manually control closing of ex"
        "ternal reference oscillator clock, i.e.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSTBY",
        "Voltage standby request bit.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STBY_COUNT",
        "Standby counter definition.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_PWRDOWN",
        "In run mode, software can manually control powering down of on chip os"
        "cillator, i.e.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_LPM_HS",
        "Bypass handshake with mmdc on next entrance to low power mode (STOP or"
        " WAIT).",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE0_WFI",
        "Mask WFI of core0 for entering low power mode Assertion of all bits[27"
        ":22] will generate low power mode request",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_SCU_IDLE",
        "Mask SCU IDLE for entering low power mode Assertion of all bits[27:22]"
        " will generate low power mode request",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_L2CC_IDLE",
        "Mask L2CC IDLE for entering low power mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CISR.
static const field_t hw_ccm_cisr[] =
{
    {
        "LRF_PLL",
        "CCM interrupt request 2 generated due to lock of all enabled and not b"
        "ypaseed PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_READY",
        "CCM interrupt request 2 generated due to on board oscillator ready, i."
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of ocram_pod"
        "f",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to frequency change of periph2_c"
        "lk_sel",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of mmdc_podf"
        "_ loaded",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of arm_podf.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CIMR.
static const field_t hw_ccm_cimr[] =
{
    {
        "MASK_LRF_PLL",
        "mask interrupt generation due to lrf of PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_COSC_READY",
        "mask interrupt generation due to on board oscillator ready",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_OCRAM_PODF_LOADED",
        "mask interrupt generation due to frequency change of ocram_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH2_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph2_clk_sel.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AHB_PODF_LOADED",
        "mask interrupt generation due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_podf",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "mask interrupt generation due to frequency change of arm_podf",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCOSR.
static const field_t hw_ccm_ccosr[] =
{
    {
        "CLKO_SEL",
        "Selection of the clock to be generated on CCM_CLKO1",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_DIV",
        "Setting the divider of CCM_CLKO1",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_EN",
        "Enable of CCM_CLKO1 clock",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_OUT_SEL",
        "CCM_CLKO1 output to reflect CCM_CLKO1 or CCM_CLKO2 clocks",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_SEL",
        "Selection of the clock to be generated on CCM_CLKO2",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_DIV",
        "Setting the divider of CCM_CLKO2",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_EN",
        "Enable of CCM_CLKO2 clock",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CGPR.
static const field_t hw_ccm_cgpr[] =
{
    {
        "PMIC_DELAY_SCALER",
        "Defines clock dividion of clock for stby_count (pmic delay counter)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_EXT_CLK_DIS",
        "Disable external clock driver of MMDC during STOP mode",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EFUSE_PROG_SUPPLY_GATE",
        "Defines the value of the output signal cgpr_dout[4].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPL",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT_MEM_CLK_LPM",
        "Control for the Deep Sleep signal to the ARM Platform memories with ad"
        "ditional control logic based on the ARM WFI signal.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "CG0",
        "aips_tz1 clocks (aips_tz1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "aips_tz2 clocks (aips_tz2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "apbhdma hclk clock (apbhdma_hclk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "asrc clock (asrc_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "caam_secure_mem clock (caam_secure_mem_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "caam_wrapper_aclk clock (caam_wrapper_aclk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "caam_wrapper_ipg clock (caam_wrapper_ipg_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "can1 clock (can1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "can1_serial clock (can1_serial_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "can2 clock (can2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "can2_serial clock (can2_serial_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "CPU debug clocks (arm_dbg_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "dcic 1 clocks (dcic1_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "dcic2 clocks (dcic2_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "aips_tz3 clocks (aips_tz3_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "CG0",
        "ecspi1 clocks (ecspi1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ecspi2 clocks (ecspi2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ecspi3 clocks (ecspi3_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ecspi4 clocks (ecspi4_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "ecspi5 clocks (ecspi5_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "epit1 clocks (epit1_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "epit2 clocks (epit2_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "esai clocks (esai_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "wakeup clock (wakeup_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "gpt bus clock (gpt_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gpt serial clock (gpt_serial_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpu clock (gpu_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "ocram_s clock (ocram_s_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "canfd clock (canfd_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "csi clock (csi_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "i2c1_serial clock (i2c1_serial_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "i2c2_serial clock (i2c2_serial_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "i2c3_serial clock (i2c3_serial_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "OCOTP_CTRL clock (iim_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "ipmux1 clock (ipmux1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ipmux2 clock (ipmux2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ipmux3 clock (ipmux3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_e"
        "nable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "Reserved",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "lcd clocks (lcd_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pxp clocks (pxp_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "m4 clock (m4_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "enet clock (enet_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "display axi clock (disp_axi_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "lcdif2 pix clock (lcdif2_pix_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "lcdif1 pix clock (lcdif1_pix_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "ldb_di0 clock (ldb_di0_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "qspi1 clock (qspi1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "mlb clock (mlb_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "ocram clock (ocram_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "CG0",
        "pcie clock (pcie_root_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "Reserved.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "qspi2 clock (qspi2_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "pl301_mx6qper1_bch clocks (pl301_mx6qper1_bchclk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm1 clocks (pwm1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "pwm2 clocks (pwm2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "pwm3 clocks (pwm3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "pwm4 clocks (pwm4_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_e"
        "nable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "rawnand_u_gpmi_bch_input_gpmi_io clock (rawnand_u_gpmi_bch_input_gpmi_"
        "io_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "rawnand_u_gpmi_input_apb clock (rawnand_u_gpmi_input_apb_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "CG0",
        "rom clock (rom_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sdma clock (sdma_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "spba clock (spba_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "spdif / audio clock (spdif_clk_enable, audio_clk_root)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ssi1 clocks (ssi1_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ssi2 clocks (ssi2_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ssi3 clocks (ssi3_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart clock (uart_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "uart_serial clock (uart_serial_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "sai1 clock (sai1_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "sai2 clock (sai2_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "CG0",
        "usboh3 clock (usboh3_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "usdhc1 clocks (usdhc1_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "usdhc2 clocks (usdhc2_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "usdhc3 clocks (usdhc3_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "usdhc4 clocks (usdhc4_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "eim_slow clocks (eim_slow_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "Reserved",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm8 clocks (pwm8_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "vadc clocks (vadc_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gis clocks (gis_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "i2c4 serial clock (i2c4_serial_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "pwm5 clocks (pwm5_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "pwm6 clocks (pwm6_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pwm7 clocks (pwm7_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CMEOR.
static const field_t hw_ccm_cmeor[] =
{
    {
        "MOD_EN_OV_GPT",
        "Overide clock enable signal from GPT - clock will not be gated based o"
        "n GPT's signal 'ipg_enable_clk' .",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_EPIT",
        "Overide clock enable signal from EPIT - clock will not be gated based "
        "on EPIT's signal 'ipg_enable_clk' .",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_USDHC",
        "overide clock enable signal from USDHC.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPU",
        "Overide clock enable signal from GPU - clock will not be gated based o"
        "n GPU signal 'gpu_busy' .",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN2_CPI",
        "Overide clock enable signal from CAN2 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN1_CPI",
        "Overide clock enable signal from CAN1 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM module.
static const reg_t hw_ccm[] =
{
    {
        "CCR",
        "The figure below represents the CCM Control Register (CCR), which cont"
        "ains bits to control general operation of CCM.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ccr
    },
    {
        "CCDR",
        "The figure below represents the CCM Control Divider Register (CCDR), w"
        "hich contains bits that control the loading of the dividers that need "
        "handshake with the modules they affect.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_ccdr
    },
    {
        "CSR",
        "The figure below represents the CCM status Register (CSR).",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_ccm_csr
    },
    {
        "CCSR",
        "The figure below represents the CCM Clock Switcher register (CCSR).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_ccsr
    },
    {
        "CACRR",
        "The figure below represents the CCM Arm Clock Root register (CACRR).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cacrr
    },
    {
        "CBCDR",
        "The figure below represents the CCM Bus Clock Divider Register (CBCDR)"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcdr
    },
    {
        "CBCMR",
        "The figure below represents the CCM Bus Clock Multiplexer Register (CB"
        "CMR).",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcmr
    },
    {
        "CSCMR1",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "1 (CSCMR1).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_cscmr1
    },
    {
        "CSCMR2",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "2 (CSCMR2).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cscmr2
    },
    {
        "CSCDR1",
        "The figure below represents the CCM Serial Clock Divider Register 1 (C"
        "SCDR1).",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr1
    },
    {
        "CS1CDR",
        "The figure below represents the CCM SSI1, SSI3, ESAI Clock Divider Reg"
        "ister (CS1CDR).",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs1cdr
    },
    {
        "CS2CDR",
        "The figure below represents the CCM SSI2, LDB Clock Divider Register ("
        "CS2CDR).",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_cs2cdr
    },
    {
        "CDCDR",
        "The figure below represents the CCM DI Clock Divider Register (CDCDR).",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cdcdr
    },
    {
        "CHSCCDR",
        "The figure below represents the CCM HSC Clock Divider Register (CHSCCD"
        "R).",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_chsccdr
    },
    {
        "CSCDR2",
        "The figure below represents the CCM Serial Clock Divider Register 2(CS"
        "CDR2).",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cscdr2
    },
    {
        "CSCDR3",
        "The figure below represents the CCM Serial Clock Divider Register 3(CS"
        "CDR3).",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cscdr3
    },
    {
        "CWDR",
        "The figure below represents the CCM Wakeup Detector Register (CWDR).",
        4, // Width in bytes
        0x00000044, // Base address offset
        false, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_ccm_cwdr
    },
    {
        "CDHIPR",
        "The figure below represents the CCM Divider Handshake In-Process Regis"
        "ter (CDHIPR).",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_ccm_cdhipr
    },
    {
        "CLPCR",
        "The figure below represents the CCM Low Power Control Register (CLPCR)"
        ".",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_clpcr
    },
    {
        "CISR",
        "The figure below represents the CCM Interrupt Status Register (CISR).",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cisr
    },
    {
        "CIMR",
        "The figure below represents the CCM Interrupt Mask Register (CIMR).",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cimr
    },
    {
        "CCOSR",
        "The figure below represents the CCM Clock Output Source Register (CCOS"
        "R).",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_ccosr
    },
    {
        "CGPR",
        "Fast PLL enable.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cgpr
    },
    {
        "CCGR0",
        "CG(i) bits CCGR 0-6 These bits are used to turn on/off the clock to ea"
        "ch module independently.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr0
    },
    {
        "CCGR1",
        "The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1)"
        ".",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr1
    },
    {
        "CCGR2",
        "The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2"
        ").",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr2
    },
    {
        "CCGR3",
        "The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3"
        ").",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr3
    },
    {
        "CCGR4",
        "The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4"
        ").",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr4
    },
    {
        "CCGR5",
        "The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5"
        ").",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr5
    },
    {
        "CCGR6",
        "The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6"
        ").",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr6
    },
    {
        "CMEOR",
        "The follow figure represents the CCM Module Enable Override Register ("
        "CMEOR).",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cmeor
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM_ANALOG
#endif

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM.
static const field_t hw_ccm_analog_analog_pll_arm[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_SET.
static const field_t hw_ccm_analog_analog_pll_arm_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_CLR.
static const field_t hw_ccm_analog_analog_pll_arm_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_TOG.
static const field_t hw_ccm_analog_analog_pll_arm_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1.
static const field_t hw_ccm_analog_analog_pll_usb1[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_SET.
static const field_t hw_ccm_analog_analog_pll_usb1_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_CLR.
static const field_t hw_ccm_analog_analog_pll_usb1_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_TOG.
static const field_t hw_ccm_analog_analog_pll_usb1_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2.
static const field_t hw_ccm_analog_analog_pll_usb2[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_SET.
static const field_t hw_ccm_analog_analog_pll_usb2_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_CLR.
static const field_t hw_ccm_analog_analog_pll_usb2_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_TOG.
static const field_t hw_ccm_analog_analog_pll_usb2_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS.
static const field_t hw_ccm_analog_analog_pll_sys[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SET.
static const field_t hw_ccm_analog_analog_pll_sys_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_CLR.
static const field_t hw_ccm_analog_analog_pll_sys_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_TOG.
static const field_t hw_ccm_analog_analog_pll_sys_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SS.
static const field_t hw_ccm_analog_analog_pll_sys_ss[] =
{
    {
        "STEP",
        "Frequency change step = step/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP",
        "Frequency change = stop/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO.
static const field_t hw_ccm_analog_analog_pll_audio[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_SET.
static const field_t hw_ccm_analog_analog_pll_audio_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_CLR.
static const field_t hw_ccm_analog_analog_pll_audio_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_TOG.
static const field_t hw_ccm_analog_analog_pll_audio_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_NUM.
static const field_t hw_ccm_analog_analog_pll_audio_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_DENOM.
static const field_t hw_ccm_analog_analog_pll_audio_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO.
static const field_t hw_ccm_analog_analog_pll_video[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_SET.
static const field_t hw_ccm_analog_analog_pll_video_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_CLR.
static const field_t hw_ccm_analog_analog_pll_video_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_TOG.
static const field_t hw_ccm_analog_analog_pll_video_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_NUM.
static const field_t hw_ccm_analog_analog_pll_video_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider(Signed number), absolute v"
        "alue should be less than denominator",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_DENOM.
static const field_t hw_ccm_analog_analog_pll_video_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET.
static const field_t hw_ccm_analog_analog_pll_enet[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_SET.
static const field_t hw_ccm_analog_analog_pll_enet_set[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_CLR.
static const field_t hw_ccm_analog_analog_pll_enet_clr[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_TOG.
static const field_t hw_ccm_analog_analog_pll_enet_tog[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480.
static const field_t hw_ccm_analog_analog_pfd_480[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_SET.
static const field_t hw_ccm_analog_analog_pfd_480_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_CLR.
static const field_t hw_ccm_analog_analog_pfd_480_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_TOG.
static const field_t hw_ccm_analog_analog_pfd_480_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528.
static const field_t hw_ccm_analog_analog_pfd_528[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_SET.
static const field_t hw_ccm_analog_analog_pfd_528_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_CLR.
static const field_t hw_ccm_analog_analog_pfd_528_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_TOG.
static const field_t hw_ccm_analog_analog_pfd_528_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0.
static const field_t hw_ccm_analog_analog_misc0[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_RINGOSC_EN",
        "Enables the internal ring oscillator that can be used in lieu of an ex"
        "ternal 32k crystal.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_SET.
static const field_t hw_ccm_analog_analog_misc0_set[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_RINGOSC_EN",
        "Enables the internal ring oscillator that can be used in lieu of an ex"
        "ternal 32k crystal.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_CLR.
static const field_t hw_ccm_analog_analog_misc0_clr[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_RINGOSC_EN",
        "Enables the internal ring oscillator that can be used in lieu of an ex"
        "ternal 32k crystal.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_TOG.
static const field_t hw_ccm_analog_analog_misc0_tog[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_RINGOSC_EN",
        "Enables the internal ring oscillator that can be used in lieu of an ex"
        "ternal 32k crystal.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1.
static const field_t hw_ccm_analog_analog_misc1[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS2_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        5, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_OBEN",
        "This enables the LVDS output buffer for anaclk2/2b.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_IBEN",
        "This enables the LVDS input buffer for anaclk2/2b.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_SET.
static const field_t hw_ccm_analog_analog_misc1_set[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS2_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        5, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_OBEN",
        "This enables the LVDS output buffer for anaclk2/2b.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_IBEN",
        "This enables the LVDS input buffer for anaclk2/2b.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_CLR.
static const field_t hw_ccm_analog_analog_misc1_clr[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS2_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        5, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_OBEN",
        "This enables the LVDS output buffer for anaclk2/2b.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_IBEN",
        "This enables the LVDS input buffer for anaclk2/2b.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_TOG.
static const field_t hw_ccm_analog_analog_misc1_tog[] =
{
    {
        "LVDS1_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS2_CLK_SEL",
        "This field selects the clk to be routed to anaclk2/2b.",
        5, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_OBEN",
        "This enables the LVDS output buffer for anaclk1/1b.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_OBEN",
        "This enables the LVDS output buffer for anaclk2/2b.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK1_IBEN",
        "This enables the LVDS input buffer for anaclk1/1b.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDSCLK2_IBEN",
        "This enables the LVDS input buffer for anaclk2/2b.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2.
static const field_t hw_ccm_analog_analog_misc2[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_SET.
static const field_t hw_ccm_analog_analog_misc2_set[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_CLR.
static const field_t hw_ccm_analog_analog_misc2_clr[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_TOG.
static const field_t hw_ccm_analog_analog_misc2_tog[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM_ANALOG module.
static const reg_t hw_ccm_analog[] =
{
    {
        "ANALOG_PLL_ARM",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_ccm_analog_analog_pll_arm
    },
    {
        "ANALOG_PLL_ARM_SET",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_set
    },
    {
        "ANALOG_PLL_ARM_CLR",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_clr
    },
    {
        "ANALOG_PLL_ARM_TOG",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_tog
    },
    {
        "ANALOG_PLL_USB1",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1
    },
    {
        "ANALOG_PLL_USB1_SET",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_set
    },
    {
        "ANALOG_PLL_USB1_CLR",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_clr
    },
    {
        "ANALOG_PLL_USB1_TOG",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_tog
    },
    {
        "ANALOG_PLL_USB2",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2
    },
    {
        "ANALOG_PLL_USB2_SET",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_set
    },
    {
        "ANALOG_PLL_USB2_CLR",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_clr
    },
    {
        "ANALOG_PLL_USB2_TOG",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_tog
    },
    {
        "ANALOG_PLL_SYS",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys
    },
    {
        "ANALOG_PLL_SYS_SET",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_set
    },
    {
        "ANALOG_PLL_SYS_CLR",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_clr
    },
    {
        "ANALOG_PLL_SYS_TOG",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_tog
    },
    {
        "ANALOG_PLL_SYS_SS",
        "This register contains the 528 PLL spread spectrum controls.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_ss
    },
    {
        "ANALOG_PLL_AUDIO",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio
    },
    {
        "ANALOG_PLL_AUDIO_SET",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_set
    },
    {
        "ANALOG_PLL_AUDIO_CLR",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_clr
    },
    {
        "ANALOG_PLL_AUDIO_TOG",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_tog
    },
    {
        "ANALOG_PLL_AUDIO_NUM",
        "This register contains the numerator (A) of Audio PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_num
    },
    {
        "ANALOG_PLL_AUDIO_DENOM",
        "This register contains the Denominator (B) of Audio PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_denom
    },
    {
        "ANALOG_PLL_VIDEO",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video
    },
    {
        "ANALOG_PLL_VIDEO_SET",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_set
    },
    {
        "ANALOG_PLL_VIDEO_CLR",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_clr
    },
    {
        "ANALOG_PLL_VIDEO_TOG",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_tog
    },
    {
        "ANALOG_PLL_VIDEO_NUM",
        "This register contains the numerator (A) of Video PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_num
    },
    {
        "ANALOG_PLL_VIDEO_DENOM",
        "This register contains the Denominator (B) of Video PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_denom
    },
    {
        "ANALOG_PLL_ENET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet
    },
    {
        "ANALOG_PLL_ENET_SET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_set
    },
    {
        "ANALOG_PLL_ENET_CLR",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_clr
    },
    {
        "ANALOG_PLL_ENET_TOG",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_tog
    },
    {
        "ANALOG_PFD_480",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480
    },
    {
        "ANALOG_PFD_480_SET",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_set
    },
    {
        "ANALOG_PFD_480_CLR",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_clr
    },
    {
        "ANALOG_PFD_480_TOG",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_tog
    },
    {
        "ANALOG_PFD_528",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528
    },
    {
        "ANALOG_PFD_528_SET",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_set
    },
    {
        "ANALOG_PFD_528_CLR",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_clr
    },
    {
        "ANALOG_PFD_528_TOG",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_tog
    },
    {
        "ANALOG_MISC0",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0
    },
    {
        "ANALOG_MISC0_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_set
    },
    {
        "ANALOG_MISC0_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_clr
    },
    {
        "ANALOG_MISC0_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_tog
    },
    {
        "ANALOG_MISC1",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_analog_analog_misc1
    },
    {
        "ANALOG_MISC1_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_analog_analog_misc1_set
    },
    {
        "ANALOG_MISC1_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_analog_analog_misc1_clr
    },
    {
        "ANALOG_MISC1_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_analog_analog_misc1_tog
    },
    {
        "ANALOG_MISC2",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2
    },
    {
        "ANALOG_MISC2_SET",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_set
    },
    {
        "ANALOG_MISC2_CLR",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_clr
    },
    {
        "ANALOG_MISC2_TOG",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSI
#endif

// Bitfields in register CSI_CSICR1.
static const field_t hw_csi_csicr1[] =
{
    {
        "PIXEL_BIT",
        "Pixel Bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDGE",
        "Valid Pixel Clock Edge Select.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_PCLK",
        "Invert Pixel Clock Input.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_DATA",
        "Invert Data Input.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCLK_MODE",
        "Gated Clock Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_RXFIFO",
        "Asynchronous RXFIFO Clear.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_STATFIFO",
        "Asynchronous STATFIFO Clear.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PACK_DIR",
        "Data Packing Direction.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCC",
        "FIFO Clear Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CCIR_EN",
        "CCIR656 Interface Enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC Polarity Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INTEN",
        "Start Of Frame (SOF) Interrupt Enable.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_POL",
        "SOF Interrupt Polarity.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INTEN",
        "RxFIFO Full Interrupt Enable.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB1_DMA_DONE_INTEN",
        "Frame Buffer1 DMA Transfer Done Interrupt Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB2_DMA_DONE_INTEN",
        "Frame Buffer2 DMA Transfer Done Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INTEN",
        "STATFIFO Full Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFF_DMA_DONE_INTEN",
        "STATFIFO DMA Transfer Done Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INTEN",
        "RxFIFO Overrun Interrupt Enable.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INTEN",
        "STAT FIFO Overrun Interrupt Enable.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT_EN",
        "Change Of Image Field (COF) Interrupt Enable.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_MODE",
        "Video mode select.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRP_IF_EN",
        "CSI-PrP Interface Enable.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT_EN",
        "End-of-Frame Interrupt Enable.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_VSYNC",
        "External VSYNC Enable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWAP16_EN",
        "SWAP 16-Bit Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR2.
static const field_t hw_csi_csicr2[] =
{
    {
        "HSC",
        "Horizontal Skip Count.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSC",
        "Vertical Skip Count.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVRM",
        "Live View Resolution Mode.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BTS",
        "Bayer Tile Start.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCE",
        "Skip Count Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFS",
        "Auto Focus Spread.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRM",
        "Double Resolution Mode.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_SFF",
        "Burst Type of DMA Transfer from STATFIFO.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_RFF",
        "Burst Type of DMA Transfer from RxFIFO.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR3.
static const field_t hw_csi_csicr3[] =
{
    {
        "ECC_AUTO_EN",
        "Automatic Error Correction Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT_EN",
        "Error Detection Interrupt Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZERO_PACK_EN",
        "Dummy Zero Packing Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWO_8BIT_SENSOR",
        "Two 8-bit Sensor Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_LEVEL",
        "RxFIFO Full Level.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_EN",
        "Hresponse Error Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_LEVEL",
        "STATFIFO Full Level.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_SFF",
        "DMA Request Enable for STATFIFO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_RFF",
        "DMA Request Enable for RxFIFO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_SFF",
        "Reflash DMA Controller for STATFIFO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_RFF",
        "Reflash DMA Controller for RxFIFO.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT_RST",
        "Frame Count Reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT",
        "Frame Counter.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISTATFIFO.
static const field_t hw_csi_csistatfifo[] =
{
    {
        "STAT",
        "Static data from sensor",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRFIFO.
static const field_t hw_csi_csirfifo[] =
{
    {
        "IMAGE",
        "Received image data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRXCNT.
static const field_t hw_csi_csirxcnt[] =
{
    {
        "RXCNT",
        "RxFIFO Count.",
        0, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISR.
static const field_t hw_csi_csisr[] =
{
    {
        "DRDY",
        "RXFIFO Data Ready.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT",
        "CCIR Error Interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_INT",
        "Hresponse Error Interrupt Status.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT",
        "Change Of Field Interrupt Status.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_INT",
        "CCIR Field 1 Interrupt Status.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F2_INT",
        "CCIR Field 2 Interrupt Status.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INT",
        "Start of Frame Interrupt Status.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT",
        "End of Frame (EOF) Interrupt Status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INT",
        "RXFIFO Full Interrupt Status.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB1",
        "DMA Transfer Done in Frame Buffer1.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB2",
        "DMA Transfer Done in Frame Buffer2.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INT",
        "STATFIFO Full Interrupt Status.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_SFF",
        "DMA Transfer Done from StatFIFO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INT",
        "RxFIFO Overrun Interrupt Status.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INT",
        "STATFIFO Overrun Interrupt Status.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD0_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHHANGE_ERROR",
        "When using base address switching enable, this bit will be 1 when swit"
        "ching occur before DMA complete.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_STATFIFO.
static const field_t hw_csi_csidmasa_statfifo[] =
{
    {
        "DMA_START_ADDR_SFF",
        "DMA Start Address for STATFIFO.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMATS_STATFIFO.
static const field_t hw_csi_csidmats_statfifo[] =
{
    {
        "DMA_TSF_SIZE_SFF",
        "DMA Transfer Size for STATFIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB1.
static const field_t hw_csi_csidmasa_fb1[] =
{
    {
        "DMA_START_ADDR_FB1",
        "DMA Start Address in Frame Buffer1.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB2.
static const field_t hw_csi_csidmasa_fb2[] =
{
    {
        "DMA_START_ADDR_FB2",
        "DMA Start Address in Frame Buffer2.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIFBUF_PARA.
static const field_t hw_csi_csifbuf_para[] =
{
    {
        "FBUF_STRIDE",
        "Frame Buffer Parameter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIIMAG_PARA.
static const field_t hw_csi_csiimag_para[] =
{
    {
        "IMAGE_HEIGHT",
        "Image Height.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMAGE_WIDTH",
        "Image Width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR18.
static const field_t hw_csi_csicr18[] =
{
    {
        "NTSC_EN",
        "This bit is used to select NTSC/PAL mode When input is TVDECODER or st"
        "andard CCIR656 video.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TVDECODER_IN_EN",
        "When input is from TV decoder, this bit is enabled.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEINTERLACE_EN",
        "This bit is used to select the output method When input is TVDECODER o"
        "r standard CCIR656 video.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PARALLEL24_EN",
        "When input is parallel rgb888/yuv444 24bit, this bit can be enabled.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_EN",
        "When this bit is enabled, CSI DMA will switch the base address accordi"
        "ng to BASEADDR_SWITCH_SEL rather than atomically by DMA completed.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_SEL",
        "CSI 2 base addresses switching method.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIELD0_DONE_IE",
        "In interlace mode, fileld 0 means interrupt enabled.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE_IE",
        "When in interlace mode, field 1 done interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LAST_DMA_REQ_SEL",
        "Choosing the last DMA request condition.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHANGE_ERROR_IE",
        "Base address change error interrupt enable signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGB888A_FORMAT_SEL",
        "Output is 32-bit format.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_HPROT",
        "Hprot value in AHB bus protocol.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_LCDIF_BUFFER_LINES",
        "The number of lines are used in handshake mode with LCDIF.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_OPTION",
        "These bits used to choose the method to mask the CSI input.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_ENABLE",
        "CSI global enable signal.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR19.
static const field_t hw_csi_csicr19[] =
{
    {
        "DMA_RFIFO_HIGHEST_FIFO_LEVEL",
        "This byte stores the highest FIFO level achieved by CSI FIFO timely an"
        "d will be clear by writing 8'ff to it.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSI module.
static const reg_t hw_csi[] =
{
    {
        "CSICR1",
        "This register controls the sensor interface timing and interrupt gener"
        "ation.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_csi_csicr1
    },
    {
        "CSICR2",
        "This register provides the statistic block with data about which live "
        "view resolution is being used, and the starting sensor pixel of the Ba"
        "yer pattern.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_csi_csicr2
    },
    {
        "CSICR3",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1, adding additional control and features.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_csi_csicr3
    },
    {
        "CSISTATFIFO",
        "The StatFIFO is a read-only register containing statistic data from th"
        "e sensor.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csistatfifo
    },
    {
        "CSIRFIFO",
        "This read-only register contains received image data.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csirfifo
    },
    {
        "CSIRXCNT",
        "This register works for EOF interrupt generation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csirxcnt
    },
    {
        "CSISR",
        "This read/write register shows sensor interface status, and which kind"
        " of interrupt is being generated.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csi_csisr
    },
    {
        "CSIDMASA_STATFIFO",
        "This register provides the start address for the embedded DMA controll"
        "er of STATFIFO.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_statfifo
    },
    {
        "CSIDMATS_STATFIFO",
        "This register provides the total transfer size for the embedded DMA co"
        "ntroller of STATFIFO.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmats_statfifo
    },
    {
        "CSIDMASA_FB1",
        "This register provides the start address in the frame buffer1 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb1
    },
    {
        "CSIDMASA_FB2",
        "This register provides the start address in the frame buffer2 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb2
    },
    {
        "CSIFBUF_PARA",
        "This register provides the stride of the frame buffer to show how many"
        " words to skip before starting to write the next row of the image.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csifbuf_para
    },
    {
        "CSIIMAG_PARA",
        "This register provides the width and the height of the image from the "
        "sensor.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csiimag_para
    },
    {
        "CSICR18",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1 and mainly focus on new feature used in PEL"
        "E project.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_csi_csicr18
    },
    {
        "CSICR19",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1 and mainly focus on new feature used in PEL"
        "E project.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csicr19
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DCIC
#endif

// Bitfields in register DCIC_DCICC.
static const field_t hw_dcic_dcicc[] =
{
    {
        "IC_EN",
        "Integrity Check enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DE_POL",
        "DATA_EN_IN signal polarity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC_IN signal polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_POL",
        "VSYNC_IN signal polarity.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_POL",
        "DISP_CLK signal polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICIC.
static const field_t hw_dcic_dcicic[] =
{
    {
        "EI_MASK",
        "Error Interrupt mask.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FI_MASK",
        "Functional Interrupt mask.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FREEZE_MASK",
        "Disable change of interrupt masks.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_SIG_EN",
        "External controller mismatch indication signal.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICS.
static const field_t hw_dcic_dcics[] =
{
    {
        "ROI_MATCH_STAT",
        "Each set bit of this field indicates there was a mismatch at appropria"
        "te ROIs signature during the last frame.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EI_STAT",
        "Error Interrupt status.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FI_STAT",
        "Functional Interrupt status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRC.
static const field_t hw_dcic_dcicrc[] =
{
    {
        "START_OFFSET_X",
        "Column number of ROIs upper-left corner (X coordinate) Range: 0 to 2^1"
        "3-1",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "START_OFFSET_Y",
        "Row number of ROIs upper-left corner (Y coordinate) Range: 0 to 2^12-1",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROI_FREEZE",
        "When set, the only parameter of ROI #m that can be changed is referenc"
        "e signature.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROI_EN",
        "ROI #m tracking enable",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRS.
static const field_t hw_dcic_dcicrs[] =
{
    {
        "END_OFFSET_X",
        "Column number of ROIs lower-right corner (X coordinate) Range: 1 to 2^"
        "13-1",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "END_OFFSET_Y",
        "Row number of ROIs lower-right corner (Y coordinate) Range: 1 to 2^12-"
        "1",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRRS.
static const field_t hw_dcic_dcicrrs[] =
{
    {
        "REFERENCE_SIGNATURE",
        "32-bit expected signature (CRC calculation result) for ROI #m",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRCS.
static const field_t hw_dcic_dcicrcs[] =
{
    {
        "CALCULATED_SIGNATURE",
        "32-bit actual signature (CRC calculation result) for ROI #m during the"
        " last frame.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DCIC module.
static const reg_t hw_dcic[] =
{
    {
        "DCICC",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dcic_dcicc
    },
    {
        "DCICIC",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcic_dcicic
    },
    {
        "DCICS",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dcic_dcics
    },
    {
        "DCICRC",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcic_dcicrc
    },
    {
        "DCICRS",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcic_dcicrs
    },
    {
        "DCICRRS",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcic_dcicrrs
    },
    {
        "DCICRCS",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcic_dcicrcs
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DVFSC
#endif

// Bitfields in register DVFSC_THRS.
static const field_t hw_dvfsc_thrs[] =
{
    {
        "PNCTHR",
        "Panic threshold for load tracking",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DWTHR",
        "Down threshold for load tracking",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPTHR",
        "Upper threshold for load tracking",
        22, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_COUN.
static const field_t hw_dvfsc_coun[] =
{
    {
        "UPCNT",
        "UP counter threshold value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DN_CNT",
        "Down counter threshold value",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_SIG1.
static const field_t hw_dvfsc_sig1[] =
{
    {
        "WSW6",
        "General purpose load tracking signal weight dvfs_w_sig[6]",
        2, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW7",
        "General purpose load tracking signal weight dvfs_w_sig[7]",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW8",
        "General purpose load tracking signal weight dvfs_w_sig[8]",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW9",
        "General purpose load tracking signal weight dvfs_w_sig[9]",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW10",
        "General purpose load tracking signal weight dvfs_w_sig[10]",
        14, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW11",
        "General purpose load tracking signal weight dvfs_w_sig[11]",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW12",
        "General purpose load tracking signal weight dvfs_w_sig[12]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW13",
        "General purpose load tracking signal weight dvfs_w_sig[13]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW14",
        "General purpose load tracking signal weight dvfs_w_sig[14]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW15",
        "General purpose load tracking signal weight dvfs_w_sig[15]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSSIG0.
static const field_t hw_dvfsc_dvfssig0[] =
{
    {
        "WSW0",
        "General purpose load tracking signal weight dvfs_w_sig[0].",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW1",
        "General purpose load tracking signal weight dvfs_w_sig[1].",
        6, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW2",
        "General purpose load tracking signal weight dvfs_w_sig[2]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW3",
        "General purpose load tracking signal weight dvfs_w_sig[3]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW4",
        "General purpose load tracking signal weight dvfs_w_sig[4]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW5",
        "General purpose load tracking signal weight dvfs_w_sig[5]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC0.
static const field_t hw_dvfsc_dvfsgpc0[] =
{
    {
        "GPBC0",
        "GPBC0 - General Purpose bits Counter 0 During period of this counter t"
        "he GeP bit 0 will be set and WSW0 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C0ACT",
        "C0ACT - Counter 0 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C0STRT",
        "C0STRT - Counter 0 start Setting of this bit will initialize down coun"
        "ting of the GPC0 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC1.
static const field_t hw_dvfsc_dvfsgpc1[] =
{
    {
        "GPBC1",
        "GPBC1 - General Purpose bits Counter 1 During period of this counter t"
        "he GeP bit 1 will be set and WSW1 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C1ACT",
        "C1ACT - Counter 1 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C1STRT",
        "C1STRT - Counter 1start Setting of this bit will initialize down count"
        "ing of the GPC1 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPBT.
static const field_t hw_dvfsc_dvfsgpbt[] =
{
    {
        "GPB0",
        "General purpose bit 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB1",
        "General purpose bit 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB2",
        "General purpose bit 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB3",
        "General purpose bit 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB4",
        "General purpose bit 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB5",
        "General purpose bit 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB6",
        "General purpose bit 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB7",
        "General purpose bit 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB8",
        "General purpose bit 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB9",
        "General purpose bit 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB10",
        "General purpose bit 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB11",
        "General purpose bit 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB12",
        "General purpose bit 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB13",
        "General purpose bit 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB14",
        "General purpose bit 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB15",
        "General purpose bit 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSEMAC.
static const field_t hw_dvfsc_dvfsemac[] =
{
    {
        "EMAC",
        "EMAC - EMA control value",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN0",
        "DVFS tracking for core0 enable.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI0",
        "DVFS Frequency adjustment status of core 0.",
        16, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFIM0",
        "DVFS Wait for Interrupt of core 0 mask bit",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_CNTR.
static const field_t hw_dvfsc_cntr[] =
{
    {
        "LTBRSR",
        "LTBRSR - Load Tracking Buffer Register Source:",
        3, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LTBRSH",
        "LTBRSH - Load Tracking Buffer Register Shift:",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFUS",
        "PFUS - Periodic Frequency Update Status",
        6, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFUE",
        "PFUE - Period Frequency Update Enable",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV_RATIO",
        "DIV_RATIO - Divider value.",
        11, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MINF",
        "Minimum frequency reached.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAXF",
        "Maximum frequency reached.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI",
        "FSVAI DVFS Frequency adjustment interrupt.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAIM",
        "DVFS Frequency adjustment interrupt mask.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PIRQS",
        "PIRQS - Pattern IRQ Source * write '1' to clear.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFIS",
        "DVFS Interrupt select.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL0",
        "Load buffer 0 - full status bit.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL1",
        "Load buffer 1 - full status bit.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBMI",
        "Load buffer full mask interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEV",
        "Always give a DVFS event.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV3CK",
        "DIV3CK - div_3_clk division ratio inside the DVFS module.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_0.
static const field_t hw_dvfsc_dvfsltr0_0[] =
{
    {
        "LTS0_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_1.
static const field_t hw_dvfsc_dvfsltr0_1[] =
{
    {
        "LTS0_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_0.
static const field_t hw_dvfsc_dvfsltr1_0[] =
{
    {
        "LTS1_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_1.
static const field_t hw_dvfsc_dvfsltr1_1[] =
{
    {
        "LTS1_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT0.
static const field_t hw_dvfsc_dvfspt0[] =
{
    {
        "FPTN0",
        "FPTN0 - Frequency pattern 0 counter During period of this counter the "
        "frequency will be reduced from the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT0A",
        "PT0A - Pattern 0 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT1.
static const field_t hw_dvfsc_dvfspt1[] =
{
    {
        "FPTN1",
        "FPTN1 - Frequency pattern 1 counter During period of this counter the "
        "frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT1A",
        "PT1A - Pattern 1 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT2.
static const field_t hw_dvfsc_dvfspt2[] =
{
    {
        "FPTN2",
        "FPTN2 - Frequency pattern 2 counter During period of this counter the "
        "frequency will be increased to higher, than detected by the EMA-detect"
        "ed level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT2A",
        "PT2A - Pattern 2 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "P2THR",
        "P2THR - Pattern 2 Threshold Threshold of current DVFS load (after EMA)"
        ", for generating interrupts with PFUS indicators 110, 111.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT3.
static const field_t hw_dvfsc_dvfspt3[] =
{
    {
        "FPTN3",
        "FPTN3 - Frequency pattern 3 counter During period of this counter the "
        "frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT3A",
        "PT3A - Pattern 3 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DVFSC module.
static const reg_t hw_dvfsc[] =
{
    {
        "THRS",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_thrs
    },
    {
        "COUN",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_coun
    },
    {
        "SIG1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dvfsc_sig1
    },
    {
        "DVFSSIG0",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_dvfsc_dvfssig0
    },
    {
        "DVFSGPC0",
        "DVFS general purpose bits weight counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc0
    },
    {
        "DVFSGPC1",
        "DVFS general purpose bits weight counter1.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc1
    },
    {
        "DVFSGPBT",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_dvfsgpbt
    },
    {
        "DVFSEMAC",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dvfsc_dvfsemac
    },
    {
        "CNTR",
        "DIV3CK division DIV3CK setting dividing ratio sum_3 passing bits div_1"
        "_clk cumulative divider 00 1 4-0 1*512=512 001 4 6-2 4*512=2048 010 16"
        " 8-4 16*512=8192 011 64 10-6 64*512=32768 100 256 12-8 256*512=131072 "
        "101 1024 16-10 1024*512=524288 Preliminary Divider definition DIV_RATI"
        "O value ARM clk division ratio 000000 1 000001 2 000010 3 ...",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_cntr
    },
    {
        "DVFSLTR0_0",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_0
    },
    {
        "DVFSLTR0_1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_1
    },
    {
        "DVFSLTR1_0",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_0
    },
    {
        "DVFSLTR1_1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_1
    },
    {
        "DVFSPT0",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt0
    },
    {
        "DVFSPT1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt1
    },
    {
        "DVFSPT2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfspt2
    },
    {
        "DVFSPT3",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ECSPI
#endif

// Bitfields in register ECSPI_RXDATA.
static const field_t hw_ecspi_rxdata[] =
{
    {
        "ECSPI_RXDATA",
        "Receive Data.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TXDATA.
static const field_t hw_ecspi_txdata[] =
{
    {
        "ECSPI_TXDATA",
        "Transmit Data.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONREG.
static const field_t hw_ecspi_conreg[] =
{
    {
        "EN",
        "SPI Block Enable Control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT",
        "Hardware Trigger Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XCH",
        "SPI Exchange Bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMC",
        "Start Mode Control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_MODE",
        "SPI CHANNEL MODE selects the mode for each SPI channel.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIVIDER",
        "SPI Post Divider.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_DIVIDER",
        "SPI Pre Divider.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRCTL",
        "SPI Data Ready Control.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_SELECT",
        "SPI CHANNEL SELECT bits.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LENGTH",
        "Burst Length.",
        20, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONFIGREG.
static const field_t hw_ecspi_configreg[] =
{
    {
        "SCLK_PHA",
        "SPI Clock/Data Phase Control.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_POL",
        "SPI Clock Polarity Control.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_CTL",
        "SPI SS Wave Form Select.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_POL",
        "SPI SS Polarity Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_CTL",
        "DATA CTL.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_CTL",
        "SCLK CTL.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT_LENGTH",
        "HT LENGTH.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_INTREG.
static const field_t hw_ecspi_intreg[] =
{
    {
        "TEEN",
        "TXFIFO Empty Interrupt enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDREN",
        "TXFIFO Data Request Interrupt enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFEN",
        "TXFIFO Full Interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RREN",
        "RXFIFO Ready Interrupt enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDREN",
        "RXFIFO Data Request Interrupt enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "RXFIFO Full Interrupt enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROEN",
        "RXFIFO Overflow Interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCEN",
        "Transfer Completed Interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_DMAREG.
static const field_t hw_ecspi_dmareg[] =
{
    {
        "TX_THRESHOLD",
        "TX THRESHOLD.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDEN",
        "TXFIFO Empty DMA Request Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_THRESHOLD",
        "RX THRESHOLD.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDEN",
        "RXFIFO DMA Request Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_LENGTH",
        "RX DMA LENGTH.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXTDEN",
        "RXFIFO TAIL DMA Request Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_STATREG.
static const field_t hw_ecspi_statreg[] =
{
    {
        "TE",
        "TXFIFO Empty.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDR",
        "TXFIFO Data Request.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TF",
        "TXFIFO Full.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RR",
        "RXFIFO Ready.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDR",
        "RXFIFO Data Request.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RF",
        "RXFIFO Full.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RO",
        "RXFIFO Overflow.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC",
        "Transfer Completed Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_PERIODREG.
static const field_t hw_ecspi_periodreg[] =
{
    {
        "SAMPLE_PERIOD",
        "Sample Period Control.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSRC",
        "Clock Source Control.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSD_CTL",
        "Chip Select Delay Control bits.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TESTREG.
static const field_t hw_ecspi_testreg[] =
{
    {
        "TXCNT",
        "TXFIFO Counter.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXCNT",
        "RXFIFO Counter.",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBC",
        "Loop Back Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_MSGDATA.
static const field_t hw_ecspi_msgdata[] =
{
    {
        "ECSPI_MSGDATA",
        "ECSPI_MSGDATA holds the top word of MSG Data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a ECSPI module.
static const reg_t hw_ecspi[] =
{
    {
        "RXDATA",
        "The Receive Data register (ECSPI_RXDATA) is a read-only register that "
        "forms the top word of the 64 x 32 receive FIFO.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_rxdata
    },
    {
        "TXDATA",
        "The Transmit Data (ECSPI_TXDATA) register is a write-only data registe"
        "r that forms the bottom word of the 64 x 32 TXFIFO.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_txdata
    },
    {
        "CONREG",
        "The Control Register (ECSPI_CONREG) allows software to enable the ECSP"
        "I , configure its operating modes, specify the divider value, and SPI_"
        "RDY control signal, and define the transfer length.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ecspi_conreg
    },
    {
        "CONFIGREG",
        "The Config Register (ECSPI_CONFIGREG) allows software to configure eac"
        "h SPI channel, configure its operating modes, specify the phase and po"
        "larity of the clock, configure the Chip Select (SS), and define the HT"
        " transfer length.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ecspi_configreg
    },
    {
        "INTREG",
        "The Interrupt Control Register (ECSPI_INTREG) enables the generation o"
        "f interrupts to the host processor.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_intreg
    },
    {
        "DMAREG",
        "The Direct Memory Access Control Register (ECSPI_DMAREG) provides soft"
        "ware a way to use an on-chip DMA controller for ECSPI data.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ecspi_dmareg
    },
    {
        "STATREG",
        "The ECSPI Status Register (ECSPI_STATREG) reflects the status of the E"
        "CSPI's operating condition.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_statreg
    },
    {
        "PERIODREG",
        "The Sample Period Control Register (ECSPI_PERIODREG) provides software"
        " a way to insert delays (wait states) between consecutive SPI transfer"
        "s.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_periodreg
    },
    {
        "TESTREG",
        "The Test Control Register (ECSPI_TESTREG) provides software a mechanis"
        "m to internally connect the receive and transmit devices of the ECSPI "
        ", and monitor the contents of the receive and transmit FIFOs.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_testreg
    },
    {
        "MSGDATA",
        "The Message Data Register (ECSPI_MSGDATA) forms the top word of the 16"
        " x 32 MSG Data FIFO.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_msgdata
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EIM
#endif

// Bitfields in register EIM_CS0GCR1.
static const field_t hw_eim_cs0gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0GCR2.
static const field_t hw_eim_cs0gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR1.
static const field_t hw_eim_cs0rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR2.
static const field_t hw_eim_cs0rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR1.
static const field_t hw_eim_cs0wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR2.
static const field_t hw_eim_cs0wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR1.
static const field_t hw_eim_cs1gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR2.
static const field_t hw_eim_cs1gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR1.
static const field_t hw_eim_cs1rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR2.
static const field_t hw_eim_cs1rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR1.
static const field_t hw_eim_cs1wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR2.
static const field_t hw_eim_cs1wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR1.
static const field_t hw_eim_cs2gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR2.
static const field_t hw_eim_cs2gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR1.
static const field_t hw_eim_cs2rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR2.
static const field_t hw_eim_cs2rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR1.
static const field_t hw_eim_cs2wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR2.
static const field_t hw_eim_cs2wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR1.
static const field_t hw_eim_cs3gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR2.
static const field_t hw_eim_cs3gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR1.
static const field_t hw_eim_cs3rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR2.
static const field_t hw_eim_cs3rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR1.
static const field_t hw_eim_cs3wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR2.
static const field_t hw_eim_cs3wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR1.
static const field_t hw_eim_cs4gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR2.
static const field_t hw_eim_cs4gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR1.
static const field_t hw_eim_cs4rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR2.
static const field_t hw_eim_cs4rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR1.
static const field_t hw_eim_cs4wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR2.
static const field_t hw_eim_cs4wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR1.
static const field_t hw_eim_cs5gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR2.
static const field_t hw_eim_cs5gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR1.
static const field_t hw_eim_cs5rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR2.
static const field_t hw_eim_cs5rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR1.
static const field_t hw_eim_cs5wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR2.
static const field_t hw_eim_cs5wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WCR.
static const field_t hw_eim_wcr[] =
{
    {
        "BCM",
        "Burst Clock Mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBCD",
        "General Burst Clock Divisor.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CONT_BCLK_SEL",
        "When this bit is set BCLK pin output continuous clock.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTEN",
        "Interrupt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTPOL",
        "Interrupt Polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_EN",
        "Memory WDog enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_LIMIT",
        "Memory Watch Dog (WDog) cycle limit.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRUN_ACLK_EN",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_DCR.
static const field_t hw_eim_dcr[] =
{
    {
        "DLL_CTRL_ENABLE",
        "Set this bit to 1 to enable the DLL and delay chain; otherwise; set to"
        " 0 to bypasses DLL.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_RESET",
        "Setting this bit to 1 force a reset on DLL.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_FORCE_UPD",
        "Setting this bit to 1, forces the slave delay line to update to the DL"
        "L calibrated value immediately.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OFFSET_DEC",
        "Decrease(or increase) the value defined by DLL_CTRL_SLV_OFFSET when ca"
        "lculating DLL_STS_SLV_SEL",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OFFSET",
        "OFFSET value for DLL_CTRL_SLV_SEL",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_GATE_UPDATE",
        "Set this bit to 1 to force DLL not update from now on.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OVERRIDE",
        "Set this bit to 1 to Enable manual override for slave delay chain usin"
        "g SLV_OVERRIDE_VAL; to set 0 to disable manual override.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_OVERRIDE_VAL",
        "When SLV_OVERRIDE=1 This field is used to select 1 of 128 physical tap"
        "s manually.",
        9, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_REF_INITIAL_VAL",
        "This field is used to select the initial value of reference chain befo"
        "re DLL enabled.",
        16, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_SLV_UPDATE_INT",
        "If default 0 is used, it means 256 cycles of ref_clock.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_CTRL_REF_UPDATE_INT",
        "DLL control loop update interval.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_DSR.
static const field_t hw_eim_dsr[] =
{
    {
        "DLL_STS_SLV_LOCK",
        "Slave delay-line lock status.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_REF_LOCK",
        "Reference DLL lock status.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_SLV_SEL",
        "Slave delay line select status.",
        2, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_STS_REF_SEL",
        "Reference delay line select taps.",
        9, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WIAR.
static const field_t hw_eim_wiar[] =
{
    {
        "IPS_REQ",
        "IPS request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPS_ACK",
        "IPS ACK.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT",
        "Interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERRST",
        "READY After Reset.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EN",
        "ACLK enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_EAR.
static const field_t hw_eim_ear[] =
{
    {
        "ERROR_ADDR",
        "Error Address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EIM module.
static const reg_t hw_eim[] =
{
    {
        "CS0GCR1",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs0gcr1
    },
    {
        "CS0GCR2",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs0gcr2
    },
    {
        "CS0RCR1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs0rcr1
    },
    {
        "CS0RCR2",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs0rcr2
    },
    {
        "CS0WCR1",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs0wcr1
    },
    {
        "CS0WCR2",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs0wcr2
    },
    {
        "CS1GCR1",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs1gcr1
    },
    {
        "CS1GCR2",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs1gcr2
    },
    {
        "CS1RCR1",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs1rcr1
    },
    {
        "CS1RCR2",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs1rcr2
    },
    {
        "CS1WCR1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs1wcr1
    },
    {
        "CS1WCR2",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs1wcr2
    },
    {
        "CS2GCR1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs2gcr1
    },
    {
        "CS2GCR2",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs2gcr2
    },
    {
        "CS2RCR1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs2rcr1
    },
    {
        "CS2RCR2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs2rcr2
    },
    {
        "CS2WCR1",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs2wcr1
    },
    {
        "CS2WCR2",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs2wcr2
    },
    {
        "CS3GCR1",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs3gcr1
    },
    {
        "CS3GCR2",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs3gcr2
    },
    {
        "CS3RCR1",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs3rcr1
    },
    {
        "CS3RCR2",
        "",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs3rcr2
    },
    {
        "CS3WCR1",
        "",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs3wcr1
    },
    {
        "CS3WCR2",
        "",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs3wcr2
    },
    {
        "CS4GCR1",
        "",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs4gcr1
    },
    {
        "CS4GCR2",
        "",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs4gcr2
    },
    {
        "CS4RCR1",
        "",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs4rcr1
    },
    {
        "CS4RCR2",
        "",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs4rcr2
    },
    {
        "CS4WCR1",
        "",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs4wcr1
    },
    {
        "CS4WCR2",
        "",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs4wcr2
    },
    {
        "CS5GCR1",
        "",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs5gcr1
    },
    {
        "CS5GCR2",
        "",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs5gcr2
    },
    {
        "CS5RCR1",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs5rcr1
    },
    {
        "CS5RCR2",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs5rcr2
    },
    {
        "CS5WCR1",
        "",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs5wcr1
    },
    {
        "CS5WCR2",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs5wcr2
    },
    {
        "WCR",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_wcr
    },
    {
        "DCR",
        "",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_dcr
    },
    {
        "DSR",
        "",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_eim_dsr
    },
    {
        "WIAR",
        "",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_wiar
    },
    {
        "EAR",
        "",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_ear
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ENET
#endif

// Bitfields in register ENET_EIR.
static const field_t hw_enet_eir[] =
{
    {
        "RXB1",
        "This field indicates that a receive buffer descriptor, that not the la"
        "st in the frame, has been updated (ring/class 1).",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF1",
        "This field indicates that a frame has been received and the last corre"
        "sponding buffer descriptor has been updated (ring/class 1).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB1",
        "This field indicates that a transmit buffer descriptor has been update"
        "d (ring/class 1).",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF1",
        "This bit indicates that a frame has been transmitted and the last corr"
        "esponding buffer descriptor has been updated (ring/class 1).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB2",
        "This field indicates that a receive buffer descriptor, that not the la"
        "st in the frame, has been updated (ring/class 2).",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF2",
        "This field indicates that a frame has been received and the last corre"
        "sponding buffer descriptor has been updated (ring/class 2).",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB2",
        "This field indicates that a transmit buffer descriptor has been update"
        "d (ring/class 2).",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF2",
        "This bit indicates that a frame has been transmitted and the last corr"
        "esponding buffer descriptor has been updated (ring/class 2).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_0",
        "RX DMA Ring 0 flush indication.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_1",
        "RX DMA Ring 1 flush indication.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_2",
        "RX DMA Ring 2 flush indication.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_TIMER",
        "The adjustable timer reached the period event.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Indicates that the timestamp of the last transmitted timing frame is a"
        "vailable in the ATSTMP register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Read-only status bit to indicate that a magic packet has been detected"
        ".",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Indicates a frame was received with a payload length error.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Indicates the transmit FIFO became empty before the complete frame was"
        " transmitted.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Indicates a collision occurred on each of 16 successive attempts to tr"
        "ansmit the frame.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Indicates a collision occurred beyond the collision window (slot time)"
        " in half-duplex mode.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Indicates a system bus error occurred when a uDMA transaction is under"
        "way.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Indicates that the MII has completed the data transfer requested.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Indicates a receive buffer descriptor is not the last in the frame has"
        " been updated.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Indicates a frame has been received and the last corresponding buffer "
        "descriptor has been updated.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Indicates a transmit buffer descriptor has been updated.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Indicates a frame has been transmitted and the last corresponding buff"
        "er descriptor has been updated.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "This interrupt is asserted after the transmitter is put into a pause s"
        "tate after completion of the frame currently being transmitted.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Indicates the transmitted frame length exceeds RCR[MAX_FL] bytes.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Indicates a frame was received with length in excess of RCR[MAX_FL] by"
        "tes.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_EIMR.
static const field_t hw_enet_eimr[] =
{
    {
        "RXB1",
        "Corresponds to interrupt source EIR[RXB1] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF1",
        "Corresponds to interrupt source EIR[RXF1] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB1",
        "Corresponds to interrupt source EIR[TXB1] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF1",
        "Corresponds to interrupt source EIR[TXF1] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB2",
        "Corresponds to interrupt source EIR[RXB2] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF2",
        "Corresponds to interrupt source EIR[RXF2] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB2",
        "Corresponds to interrupt source EIR[TXB2] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF2",
        "Corresponds to interrupt source EIR[TXF2] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_0",
        "Corresponds to interrupt source EIR[RXFLUSH_0] and determines whether "
        "an interrupt condition can generate an interrupt.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_1",
        "Corresponds to interrupt source EIR[RXFLUSH_1] and determines whether "
        "an interrupt condition can generate an interrupt.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFLUSH_2",
        "Corresponds to interrupt source EIR[RXFLUSH_2] and determines whether "
        "an interrupt condition can generate an interrupt.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_TIMER",
        "Corresponds to interrupt source EIR[TS_TIMER] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Corresponds to interrupt source EIR[TS_AVAIL] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Corresponds to interrupt source EIR[WAKEUP] register and determines wh"
        "ether an interrupt condition can generate an interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Corresponds to interrupt source EIR[PLR] and determines whether an int"
        "errupt condition can generate an interrupt.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Corresponds to interrupt source EIR[UN] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Corresponds to interrupt source EIR[RL] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Corresponds to interrupt source EIR[LC] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Corresponds to interrupt source EIR[EBERR] and determines whether an i"
        "nterrupt condition can generate an interrupt.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Corresponds to interrupt source EIR[MII] and determines whether an int"
        "errupt condition can generate an interrupt.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Corresponds to interrupt source EIR[RXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Corresponds to interrupt source EIR[RXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Corresponds to interrupt source EIR[TXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Corresponds to interrupt source EIR[TXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Corresponds to interrupt source EIR[GRA] and determines whether an int"
        "errupt condition can generate an interrupt.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Corresponds to interrupt source EIR[BABT] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Corresponds to interrupt source EIR[BABR] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR.
static const field_t hw_enet_rdar[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR.
static const field_t hw_enet_tdar[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ECR.
static const field_t hw_enet_ecr[] =
{
    {
        "RESET",
        "When this field is set, it clears the ETHEREN field.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETHEREN",
        "Enables/disables the Ethernet MAC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAGICEN",
        "Enables/disables magic packet detection.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLEEP",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN1588",
        "Enables enhanced functionality of the MAC.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPEED",
        "Selects between 10/100 and 1000 Mbps modes of operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "Enables the MAC to enter hardware freeze mode when the device enters d"
        "ebug mode.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBSWP",
        "Swaps the byte locations of the buffer descriptors.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SVLANEN",
        "Enable additional detection of S-VLAN tag according to IEEE802.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VLANUSE2ND",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SVLANDBL",
        "If enabled, S-VLAN detection requires a double-tagged frame to define "
        "a frame as being a VLAN frame.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MMFR.
static const field_t hw_enet_mmfr[] =
{
    {
        "DATA",
        "This is the field for data to be written to or read from the PHY regis"
        "ter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TA",
        "This field must be programmed to 10 to generate a valid MII management"
        " frame.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RA",
        "Specifies one of up to 32 registers within the specified PHY device.",
        18, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PA",
        "Specifies one of up to 32 attached PHY devices.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OP",
        "Determines the frame operation.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ST",
        "These fields must be programmed to 01 for a valid MII management frame"
        ".",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MSCR.
static const field_t hw_enet_mscr[] =
{
    {
        "MII_SPEED",
        "Controls the frequency of the MII management interface clock (MDC) rel"
        "ative to the internal module clock.",
        1, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_PRE",
        "Enables/disables prepending a preamble to the MII management frame.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLDTIME",
        "IEEE802.3 clause 22 defines a minimum of 10 ns for the hold time on th"
        "e MDIO output.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MIBC.
static const field_t hw_enet_mibc[] =
{
    {
        "MIB_CLEAR",
        "This field is not self-clearing.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIB_IDLE",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIB_DIS",
        "If this control field is set,",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCR.
static const field_t hw_enet_rcr[] =
{
    {
        "LOOP",
        "This is an MII internal loopback, therefore MII_MODE must be written t"
        "o 1 and RMII_MODE must be written to 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRT",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII_MODE",
        "This field must always be set.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROM",
        "All frames are accepted regardless of address matching.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_REJ",
        "If set, frames with destination address (DA) equal to 0xFFFF_FFFF_FFFF"
        " are rejected unless the PROM field is set.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCE",
        "If set, the receiver detects PAUSE frames.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGMII_EN",
        "Do not set both RCR[RGMII_EN] and RCR[RMII_MODE].",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_MODE",
        "Specifies whether the MAC is configured for MII mode or RMII operation"
        " , when ECR[SPEED] is cleared .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_10T",
        "Enables 10-Mbps mode of the RMII or RGMII .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADEN",
        "Specifies whether the MAC removes padding from received frames.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUFWD",
        "Specifies whether pause frames are terminated or forwarded.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "Specifies whether the CRC field of received frames is transmitted or s"
        "tripped.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFEN",
        "Enables/disables the MAC control frame.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAX_FL",
        "Resets to decimal 1518.",
        16, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NLC",
        "Enables/disables a payload length check.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRS",
        "Read-only status indicating that the MAC receive datapath is stopped.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCR.
static const field_t hw_enet_tcr[] =
{
    {
        "GTS",
        "When this field is set, MAC stops transmission after any frame current"
        "ly transmitted is complete and EIR[GRA] is set.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FDEN",
        "If this field is set, frames transmit independent of carrier sense and"
        " collision inputs.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFC_PAUSE",
        "Pauses frame transmission.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFC_PAUSE",
        "This status field is set when a full-duplex flow control pause frame i"
        "s received and the transmitter pauses for the duration defined in this"
        " pause frame.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDSEL",
        "If ADDINS is set, indicates the MAC address that overwrites the source"
        " MAC address.",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDINS",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PALR.
static const field_t hw_enet_palr[] =
{
    {
        "PADDR1",
        "Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8), and 3 (bits 7:0) "
        "of the 6-byte individual address are used for exact match and the sour"
        "ce address field in PAUSE frames.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PAUR.
static const field_t hw_enet_paur[] =
{
    {
        "TYPE",
        "These fields have a constant value of 0x8808.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PADDR2",
        "Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual addre"
        "ss used for exact match, and the source address field in PAUSE frames.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_OPD.
static const field_t hw_enet_opd[] =
{
    {
        "PAUSE_DUR",
        "Pause duration field used in PAUSE frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE",
        "These fields have a constant value of 0x0001.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TXIC0.
static const field_t hw_enet_txic0[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be transmitted fo"
        "r raising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TXIC1.
static const field_t hw_enet_txic1[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be transmitted fo"
        "r raising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TXIC2.
static const field_t hw_enet_txic2[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be transmitted fo"
        "r raising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RXIC0.
static const field_t hw_enet_rxic0[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be received for r"
        "aising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RXIC1.
static const field_t hw_enet_rxic1[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be received for r"
        "aising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RXIC2.
static const field_t hw_enet_rxic2[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be received for r"
        "aising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IAUR.
static const field_t hw_enet_iaur[] =
{
    {
        "IADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IALR.
static const field_t hw_enet_ialr[] =
{
    {
        "IADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GAUR.
static const field_t hw_enet_gaur[] =
{
    {
        "GADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GALR.
static const field_t hw_enet_galr[] =
{
    {
        "GADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TFWR.
static const field_t hw_enet_tfwr[] =
{
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, this field indicates the number of bytes, "
        "in steps of 64 bytes, written to the transmit FIFO before transmission"
        " of a frame begins.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STRFWD",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR1.
static const field_t hw_enet_rdsr1[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of the receive buffer descriptor queue 1.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR1.
static const field_t hw_enet_tdsr1[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of transmit buffer descriptor queue 1.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR1.
static const field_t hw_enet_mrbr1[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR2.
static const field_t hw_enet_rdsr2[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of receive buffer descriptor queue 2.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR2.
static const field_t hw_enet_tdsr2[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of transmit buffer descriptor queue 2.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR2.
static const field_t hw_enet_mrbr2[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR.
static const field_t hw_enet_rdsr[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of the receive buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR.
static const field_t hw_enet_tdsr[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of the transmit buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR.
static const field_t hw_enet_mrbr[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSFL.
static const field_t hw_enet_rsfl[] =
{
    {
        "RX_SECTION_FULL",
        "Value, in 64-bit words, of the receive FIFO section full threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSEM.
static const field_t hw_enet_rsem[] =
{
    {
        "RX_SECTION_EMPTY",
        "Value, in 64-bit words, of the receive FIFO section empty threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STAT_SECTION_EMPTY",
        "Defines number of frames in the receive FIFO, independent of its size,"
        " that can be accepted.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAEM.
static const field_t hw_enet_raem[] =
{
    {
        "RX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the receive FIFO almost empty threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAFL.
static const field_t hw_enet_rafl[] =
{
    {
        "RX_ALMOST_FULL",
        "Value, in 64-bit words, of the receive FIFO almost full threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TSEM.
static const field_t hw_enet_tsem[] =
{
    {
        "TX_SECTION_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO section empty threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAEM.
static const field_t hw_enet_taem[] =
{
    {
        "TX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO almost empty threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAFL.
static const field_t hw_enet_tafl[] =
{
    {
        "TX_ALMOST_FULL",
        "Value, in 64-bit words, of the transmit FIFO almost full threshold.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TIPG.
static const field_t hw_enet_tipg[] =
{
    {
        "IPG",
        "Indicates the IPG, in bytes, between transmitted frames.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_FTRL.
static const field_t hw_enet_ftrl[] =
{
    {
        "TRUNC_FL",
        "Indicates the value a receive frame is truncated, if it is greater tha"
        "n this value.",
        0, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TACC.
static const field_t hw_enet_tacc[] =
{
    {
        "SHIFT16",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPCHK",
        "Enables insertion of IP header checksum.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROCHK",
        "Enables insertion of protocol checksum.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RACC.
static const field_t hw_enet_racc[] =
{
    {
        "PADREM",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPDIS",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRODIS",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINEDIS",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SHIFT16",
        "When this field is set, the actual frame data starts at bit 16 of the "
        "first word read from the RX FIFO aligning the Ethernet payload on a 32"
        "-bit boundary.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCMR1.
static const field_t hw_enet_rcmr1[] =
{
    {
        "CMP0",
        "A three-bit value that will be compared with the frame's VLAN priority"
        " field (if a VLAN frame is received).",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP1",
        "Second value to compare against.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP2",
        "Third value to compare against.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP3",
        "Fourth value to compare against.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MATCHEN",
        "A comparison is done only on incoming VLAN frames.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCMR2.
static const field_t hw_enet_rcmr2[] =
{
    {
        "CMP0",
        "A three-bit value that will be compared with the frame's VLAN priority"
        " field (if a VLAN frame is received).",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP1",
        "Second value to compare against.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP2",
        "Third value to compare against.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMP3",
        "Fourth value to compare against.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MATCHEN",
        "A comparison is done only on incoming VLAN frames.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_DMA1CFG.
static const field_t hw_enet_dma1cfg[] =
{
    {
        "IDLE_SLOPE",
        "16-bit value to define the per class idle slope setting used by the cr"
        "edit based shaper defining allocated bandwidth for the class.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_CLASS_EN",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CALC_NOIPG",
        "Disable inclusion of IPG bytes for bandwidth calculations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_DMA2CFG.
static const field_t hw_enet_dma2cfg[] =
{
    {
        "IDLE_SLOPE",
        "16-bit value to define the per class idle slope setting used by the cr"
        "edit based shaper defining allocated bandwidth for the class.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_CLASS_EN",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CALC_NOIPG",
        "Disable inclusion of IPG bytes for bandwidth calculations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR1.
static const field_t hw_enet_rdar1[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR1.
static const field_t hw_enet_tdar1[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR2.
static const field_t hw_enet_rdar2[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR2.
static const field_t hw_enet_tdar2[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_QOS.
static const field_t hw_enet_qos[] =
{
    {
        "TX_SCHEME",
        "Configuration information for DMA to select transmitter queue selectio"
        "n/arbitration scheme.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_FLUSH0",
        "Enable or disable RX Flush for ring 0.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_FLUSH1",
        "Enable or disable RX Flush for ring 1.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_FLUSH2",
        "Enable or disable RX Flush for ring 2.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_PACKETS.
static const field_t hw_enet_rmon_t_packets[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_BC_PKT.
static const field_t hw_enet_rmon_t_bc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_MC_PKT.
static const field_t hw_enet_rmon_t_mc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_CRC_ALIGN.
static const field_t hw_enet_rmon_t_crc_align[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_UNDERSIZE.
static const field_t hw_enet_rmon_t_undersize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OVERSIZE.
static const field_t hw_enet_rmon_t_oversize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_FRAG.
static const field_t hw_enet_rmon_t_frag[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_JAB.
static const field_t hw_enet_rmon_t_jab[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_COL.
static const field_t hw_enet_rmon_t_col[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P64.
static const field_t hw_enet_rmon_t_p64[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P65TO127.
static const field_t hw_enet_rmon_t_p65to127[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P128TO255.
static const field_t hw_enet_rmon_t_p128to255[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P256TO511.
static const field_t hw_enet_rmon_t_p256to511[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P512TO1023.
static const field_t hw_enet_rmon_t_p512to1023[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P1024TO2047.
static const field_t hw_enet_rmon_t_p1024to2047[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P_GTE2048.
static const field_t hw_enet_rmon_t_p_gte2048[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OCTETS.
static const field_t hw_enet_rmon_t_octets[] =
{
    {
        "TXOCTS",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FRAME_OK.
static const field_t hw_enet_ieee_t_frame_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_1COL.
static const field_t hw_enet_ieee_t_1col[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MCOL.
static const field_t hw_enet_ieee_t_mcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_DEF.
static const field_t hw_enet_ieee_t_def[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_LCOL.
static const field_t hw_enet_ieee_t_lcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_EXCOL.
static const field_t hw_enet_ieee_t_excol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MACERR.
static const field_t hw_enet_ieee_t_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_CSERR.
static const field_t hw_enet_ieee_t_cserr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FDXFC.
static const field_t hw_enet_ieee_t_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_OCTETS_OK.
static const field_t hw_enet_ieee_t_octets_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_PACKETS.
static const field_t hw_enet_rmon_r_packets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_BC_PKT.
static const field_t hw_enet_rmon_r_bc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_MC_PKT.
static const field_t hw_enet_rmon_r_mc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_CRC_ALIGN.
static const field_t hw_enet_rmon_r_crc_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_UNDERSIZE.
static const field_t hw_enet_rmon_r_undersize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OVERSIZE.
static const field_t hw_enet_rmon_r_oversize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_FRAG.
static const field_t hw_enet_rmon_r_frag[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_JAB.
static const field_t hw_enet_rmon_r_jab[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P64.
static const field_t hw_enet_rmon_r_p64[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P65TO127.
static const field_t hw_enet_rmon_r_p65to127[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P128TO255.
static const field_t hw_enet_rmon_r_p128to255[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P256TO511.
static const field_t hw_enet_rmon_r_p256to511[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P512TO1023.
static const field_t hw_enet_rmon_r_p512to1023[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P1024TO2047.
static const field_t hw_enet_rmon_r_p1024to2047[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P_GTE2048.
static const field_t hw_enet_rmon_r_p_gte2048[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OCTETS.
static const field_t hw_enet_rmon_r_octets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_DROP.
static const field_t hw_enet_ieee_r_drop[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FRAME_OK.
static const field_t hw_enet_ieee_r_frame_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_CRC.
static const field_t hw_enet_ieee_r_crc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_ALIGN.
static const field_t hw_enet_ieee_r_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_MACERR.
static const field_t hw_enet_ieee_r_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FDXFC.
static const field_t hw_enet_ieee_r_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_OCTETS_OK.
static const field_t hw_enet_ieee_r_octets_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCR.
static const field_t hw_enet_atcr[] =
{
    {
        "EN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFEN",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFRST",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEREN",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPER",
        "Enables event signal output assertion on period event.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESTART",
        "Resets the timer to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAPTURE",
        "This field automatically clears to 0 after the command completes.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLAVE",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATVR.
static const field_t hw_enet_atvr[] =
{
    {
        "ATIME",
        "A write sets the timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATOFF.
static const field_t hw_enet_atoff[] =
{
    {
        "OFFSET",
        "Offset value for one-shot event generation.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATPER.
static const field_t hw_enet_atper[] =
{
    {
        "PERIOD",
        "Value for generating periodic events.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCOR.
static const field_t hw_enet_atcor[] =
{
    {
        "COR",
        "Defines after how many timer clock cycles (ts_clk) the correction coun"
        "ter should be reset and trigger a correction increment on the timer.",
        0, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATINC.
static const field_t hw_enet_atinc[] =
{
    {
        "INC",
        "The timer increments by this amount each clock cycle.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_CORR",
        "This value is added every time the correction timer expires (every clo"
        "ck cycle given in ATCOR).",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATSTMP.
static const field_t hw_enet_atstmp[] =
{
    {
        "TIMESTAMP",
        "Timestamp of the last frame transmitted by the core that had TxBD[TS] "
        "set .",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TGSR.
static const field_t hw_enet_tgsr[] =
{
    {
        "TF0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR0.
static const field_t hw_enet_tcsr0[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR0.
static const field_t hw_enet_tccr0[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR1.
static const field_t hw_enet_tcsr1[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR1.
static const field_t hw_enet_tccr1[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR2.
static const field_t hw_enet_tcsr2[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR2.
static const field_t hw_enet_tccr2[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR3.
static const field_t hw_enet_tcsr3[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR3.
static const field_t hw_enet_tccr3[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ENET module.
static const reg_t hw_enet[] =
{
    {
        "EIR",
        "When an event occurs that sets a bit in EIR, an interrupt occurs if th"
        "e corresponding bit in the interrupt mask register (EIMR) is also set.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        27, // Number of bitfields
        hw_enet_eir
    },
    {
        "EIMR",
        "EIMR controls which interrupt events are allowed to generate actual in"
        "terrupts.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        27, // Number of bitfields
        hw_enet_eimr
    },
    {
        "RDAR",
        "RDAR is a command register, written by the user, to indicate that the "
        "receive descriptor ring 0 has been updated, that is, that the driver p"
        "roduced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar
    },
    {
        "TDAR",
        "The TDAR is a command register that the user writes to indicate that t"
        "he transmit descriptor ring 0 has been updated, that is, that transmit"
        " buffers have been produced by the driver with the ready bit set in th"
        "e buffer descriptor.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar
    },
    {
        "ECR",
        "ECR is a read/write user register, though hardware may also alter fiel"
        "ds in this register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_enet_ecr
    },
    {
        "MMFR",
        "Writing to MMFR triggers a management frame transaction to the PHY dev"
        "ice unless MSCR is programmed to zero.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_enet_mmfr
    },
    {
        "MSCR",
        "MSCR provides control of the MII clock (MDC pin) frequency and allows "
        "a preamble drop on the MII management frame.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mscr
    },
    {
        "MIBC",
        "MIBC is a read/write register controlling and observing the state of t"
        "he MIB block.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mibc
    },
    {
        "RCR",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_rcr
    },
    {
        "TCR",
        "TCR is read/write and configures the transmit block.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_tcr
    },
    {
        "PALR",
        "PALR contains the lower 32 bits (bytes 0, 1, 2, 3) of the 48-bit addre"
        "ss used in the address recognition process to compare with the destina"
        "tion address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_palr
    },
    {
        "PAUR",
        "PAUR contains the upper 16 bits (bytes 4 and 5) of the 48-bit address "
        "used in the address recognition process to compare with the destinatio"
        "n address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_paur
    },
    {
        "OPD",
        "OPD is read/write accessible.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_opd
    },
    {
        "TXIC0",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_txic0
    },
    {
        "TXIC1",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_txic1
    },
    {
        "TXIC2",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_txic2
    },
    {
        "RXIC0",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_rxic0
    },
    {
        "RXIC1",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_rxic1
    },
    {
        "RXIC2",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_rxic2
    },
    {
        "IAUR",
        "IAUR contains the upper 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_iaur
    },
    {
        "IALR",
        "IALR contains the lower 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ialr
    },
    {
        "GAUR",
        "GAUR contains the upper 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_gaur
    },
    {
        "GALR",
        "GALR contains the lower 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_galr
    },
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, TFWR[TFWR] controls the amount of data req"
        "uired in the transmit FIFO before transmission of a frame can begin.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_tfwr
    },
    {
        "RDSR1",
        "RDSR1 points to the beginning of circular receive buffer descriptor qu"
        "eue 1 in external memory.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr1
    },
    {
        "TDSR1",
        "TDSR1 provides a pointer to the beginning of the circular transmit buf"
        "fer descriptor queue 1 in external memory.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr1
    },
    {
        "MRBR1",
        "MRBR1 is a user-programmable register that dictates the maximum size o"
        "f all ring-1 receive buffers.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr1
    },
    {
        "RDSR2",
        "RDSR points to the beginning of circular receive buffer descriptor que"
        "ue 2 in external memory.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr2
    },
    {
        "TDSR2",
        "TDSR2 provides a pointer to the beginning of circular transmit buffer "
        "descriptor queue 2 in external memory.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr2
    },
    {
        "MRBR2",
        "MRBR2 is a user-programmable register that dictates the maximum size o"
        "f all ring-2 receive buffers.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr2
    },
    {
        "RDSR",
        "RDSR points to the beginning of the circular receive buffer descriptor"
        " queue in external memory.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr
    },
    {
        "TDSR",
        "TDSR provides a pointer to the beginning of the circular transmit buff"
        "er descriptor queue 0 in external memory.",
        4, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr
    },
    {
        "MRBR",
        "The MRBR is a user-programmable register that dictates the maximum siz"
        "e of all ring-0 receive buffers.",
        4, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr
    },
    {
        "RSFL",
        "",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rsfl
    },
    {
        "RSEM",
        "",
        4, // Width in bytes
        0x00000194, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_rsem
    },
    {
        "RAEM",
        "",
        4, // Width in bytes
        0x00000198, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_raem
    },
    {
        "RAFL",
        "",
        4, // Width in bytes
        0x0000019c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rafl
    },
    {
        "TSEM",
        "",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tsem
    },
    {
        "TAEM",
        "",
        4, // Width in bytes
        0x000001a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_taem
    },
    {
        "TAFL",
        "",
        4, // Width in bytes
        0x000001a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tafl
    },
    {
        "TIPG",
        "",
        4, // Width in bytes
        0x000001ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tipg
    },
    {
        "FTRL",
        "",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ftrl
    },
    {
        "TACC",
        "TACC controls accelerator actions when sending frames.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_tacc
    },
    {
        "RACC",
        "",
        4, // Width in bytes
        0x000001c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_racc
    },
    {
        "RCMR1",
        "This match register allows specifying up to four priorities, which are"
        " tested (OR'ed) simultaneously.",
        4, // Width in bytes
        0x000001c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_rcmr1
    },
    {
        "RCMR2",
        "This match register allows specifying up to four priorities, which are"
        " tested (OR'ed) simultaneously.",
        4, // Width in bytes
        0x000001cc, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_rcmr2
    },
    {
        "DMA1CFG",
        "The DMA class based configuration registers are used to configure the "
        "DMA controller interface to support the additional class 1 (buffer des"
        "criptor ring 1) and class 2 (buffer descriptor ring 2) traffic and def"
        "ine configuration options such as bandwidth allocation as needed.",
        4, // Width in bytes
        0x000001d8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_dma1cfg
    },
    {
        "DMA2CFG",
        "The DMA class based configuration registers are used to configure the "
        "DMA controller interface to support the additional class 1 (buffer des"
        "criptor ring 1) and class 2 (buffer descriptor ring 2) traffic and def"
        "ine configuration options such as bandwidth allocation as needed.",
        4, // Width in bytes
        0x000001dc, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_dma2cfg
    },
    {
        "RDAR1",
        "RDAR1 is a command register, written by the user, to indicate that the"
        " receive descriptor ring 1 has been updated, that is, that the driver "
        "produced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar1
    },
    {
        "TDAR1",
        "TDAR1 is a command register that the user writes to indicate that tran"
        "smit descriptor ring 1 has been updated, that is, that transmit buffer"
        "s have been produced by the driver with the ready bit set in the buffe"
        "r descriptor.",
        4, // Width in bytes
        0x000001e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar1
    },
    {
        "RDAR2",
        "RDAR2 is a command register, written by the user, to indicate that the"
        " receive descriptor ring 2 has been updated, that is, that the driver "
        "produced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x000001e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar2
    },
    {
        "TDAR2",
        "TDAR2 is a command register that the user writes to indicate that tran"
        "smit descriptor ring 2 has been updated, that is, that transmit buffer"
        "s have been produced by the driver with the ready bit set in the buffe"
        "r descriptor.",
        4, // Width in bytes
        0x000001ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar2
    },
    {
        "QOS",
        "This register sets the QOS scheme.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_qos
    },
    {
        "RMON_T_PACKETS",
        "",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_packets
    },
    {
        "RMON_T_BC_PKT",
        "RMON Tx Broadcast Packets",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_bc_pkt
    },
    {
        "RMON_T_MC_PKT",
        "",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_mc_pkt
    },
    {
        "RMON_T_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_crc_align
    },
    {
        "RMON_T_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_undersize
    },
    {
        "RMON_T_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_oversize
    },
    {
        "RMON_T_FRAG",
        ".",
        4, // Width in bytes
        0x0000021c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_frag
    },
    {
        "RMON_T_JAB",
        "",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_jab
    },
    {
        "RMON_T_COL",
        "",
        4, // Width in bytes
        0x00000224, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_col
    },
    {
        "RMON_T_P64",
        ".",
        4, // Width in bytes
        0x00000228, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p64
    },
    {
        "RMON_T_P65TO127",
        "",
        4, // Width in bytes
        0x0000022c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p65to127
    },
    {
        "RMON_T_P128TO255",
        "",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p128to255
    },
    {
        "RMON_T_P256TO511",
        "",
        4, // Width in bytes
        0x00000234, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p256to511
    },
    {
        "RMON_T_P512TO1023",
        ".",
        4, // Width in bytes
        0x00000238, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p512to1023
    },
    {
        "RMON_T_P1024TO2047",
        "",
        4, // Width in bytes
        0x0000023c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p1024to2047
    },
    {
        "RMON_T_P_GTE2048",
        "",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p_gte2048
    },
    {
        "RMON_T_OCTETS",
        "",
        4, // Width in bytes
        0x00000244, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_octets
    },
    {
        "IEEE_T_FRAME_OK",
        "",
        4, // Width in bytes
        0x0000024c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_frame_ok
    },
    {
        "IEEE_T_1COL",
        "",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_1col
    },
    {
        "IEEE_T_MCOL",
        "",
        4, // Width in bytes
        0x00000254, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_mcol
    },
    {
        "IEEE_T_DEF",
        "",
        4, // Width in bytes
        0x00000258, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_def
    },
    {
        "IEEE_T_LCOL",
        "",
        4, // Width in bytes
        0x0000025c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_lcol
    },
    {
        "IEEE_T_EXCOL",
        "",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_excol
    },
    {
        "IEEE_T_MACERR",
        "",
        4, // Width in bytes
        0x00000264, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_macerr
    },
    {
        "IEEE_T_CSERR",
        "",
        4, // Width in bytes
        0x00000268, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_cserr
    },
    {
        "IEEE_T_FDXFC",
        "",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_fdxfc
    },
    {
        "IEEE_T_OCTETS_OK",
        "Counts total octets (includes header and FCS fields).",
        4, // Width in bytes
        0x00000274, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_octets_ok
    },
    {
        "RMON_R_PACKETS",
        "",
        4, // Width in bytes
        0x00000284, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_packets
    },
    {
        "RMON_R_BC_PKT",
        "",
        4, // Width in bytes
        0x00000288, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_bc_pkt
    },
    {
        "RMON_R_MC_PKT",
        "",
        4, // Width in bytes
        0x0000028c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_mc_pkt
    },
    {
        "RMON_R_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_crc_align
    },
    {
        "RMON_R_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000294, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_undersize
    },
    {
        "RMON_R_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000298, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_oversize
    },
    {
        "RMON_R_FRAG",
        "",
        4, // Width in bytes
        0x0000029c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_frag
    },
    {
        "RMON_R_JAB",
        "",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_jab
    },
    {
        "RMON_R_P64",
        "",
        4, // Width in bytes
        0x000002a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p64
    },
    {
        "RMON_R_P65TO127",
        "",
        4, // Width in bytes
        0x000002ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p65to127
    },
    {
        "RMON_R_P128TO255",
        "",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p128to255
    },
    {
        "RMON_R_P256TO511",
        "",
        4, // Width in bytes
        0x000002b4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p256to511
    },
    {
        "RMON_R_P512TO1023",
        "",
        4, // Width in bytes
        0x000002b8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p512to1023
    },
    {
        "RMON_R_P1024TO2047",
        "",
        4, // Width in bytes
        0x000002bc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p1024to2047
    },
    {
        "RMON_R_P_GTE2048",
        "",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p_gte2048
    },
    {
        "RMON_R_OCTETS",
        "",
        4, // Width in bytes
        0x000002c4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_octets
    },
    {
        "IEEE_R_DROP",
        "Counter increments if a frame with invalid or missing SFD character is"
        " detected and has been dropped.",
        4, // Width in bytes
        0x000002c8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_drop
    },
    {
        "IEEE_R_FRAME_OK",
        "",
        4, // Width in bytes
        0x000002cc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_frame_ok
    },
    {
        "IEEE_R_CRC",
        "",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_crc
    },
    {
        "IEEE_R_ALIGN",
        "",
        4, // Width in bytes
        0x000002d4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_align
    },
    {
        "IEEE_R_MACERR",
        "",
        4, // Width in bytes
        0x000002d8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_macerr
    },
    {
        "IEEE_R_FDXFC",
        "",
        4, // Width in bytes
        0x000002dc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_fdxfc
    },
    {
        "IEEE_R_OCTETS_OK",
        "",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_octets_ok
    },
    {
        "ATCR",
        "ATCR command fields can trigger the corresponding events directly.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_enet_atcr
    },
    {
        "ATVR",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atvr
    },
    {
        "ATOFF",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atoff
    },
    {
        "ATPER",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atper
    },
    {
        "ATCOR",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atcor
    },
    {
        "ATINC",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_atinc
    },
    {
        "ATSTMP",
        "",
        4, // Width in bytes
        0x00000418, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_atstmp
    },
    {
        "TGSR",
        "",
        4, // Width in bytes
        0x00000604, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tgsr
    },
    {
        "TCSR0",
        "",
        4, // Width in bytes
        0x00000608, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tcsr0
    },
    {
        "TCCR0",
        "",
        4, // Width in bytes
        0x0000060c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr0
    },
    {
        "TCSR1",
        "",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tcsr1
    },
    {
        "TCCR1",
        "",
        4, // Width in bytes
        0x00000614, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr1
    },
    {
        "TCSR2",
        "",
        4, // Width in bytes
        0x00000618, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tcsr2
    },
    {
        "TCCR2",
        "",
        4, // Width in bytes
        0x0000061c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr2
    },
    {
        "TCSR3",
        "",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tcsr3
    },
    {
        "TCCR3",
        "",
        4, // Width in bytes
        0x00000624, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPIT
#endif

// Bitfields in register EPIT_CR.
static const field_t hw_epit_cr[] =
{
    {
        "EN",
        "This bit enables the EPIT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "EPIT enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCIEN",
        "Output compare interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLD",
        "Counter reload control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALAR",
        "Counter clock prescaler value.",
        4, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IOVW",
        "EPIT counter overwrite enable.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "This bit is used to keep the EPIT functional in debug mode.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "This read/write control bit enables the operation of the EPIT during w"
        "ait mode.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "EPIT stop mode enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM",
        "EPIT output mode.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Select clock source These bits determine which clock input is to be se"
        "lected for running the counter.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_SR.
static const field_t hw_epit_sr[] =
{
    {
        "OCIF",
        "Output compare interrupt flag.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_LR.
static const field_t hw_epit_lr[] =
{
    {
        "LOAD",
        "Load value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CMPR.
static const field_t hw_epit_cmpr[] =
{
    {
        "COMPARE",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CNR.
static const field_t hw_epit_cnr[] =
{
    {
        "COUNT",
        "Counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a EPIT module.
static const reg_t hw_epit[] =
{
    {
        "CR",
        "The EPIT control register (EPIT_CR) is used to configure the operating"
        " settings of the EPIT.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_epit_cr
    },
    {
        "SR",
        "The EPIT status register (EPIT_SR) has a single status bit for the out"
        "put compare event.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_sr
    },
    {
        "LR",
        "The EPIT load register (EPIT_LR) contains the value that is to be load"
        "ed into the counter when EPIT counter reaches zero if the RLD bit in E"
        "PIT_CR is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_lr
    },
    {
        "CMPR",
        "The EPIT compare register (EPIT_CMPR) holds the value that determines "
        "when a compare event is generated.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_cmpr
    },
    {
        "CNR",
        "The EPIT counter register (EPIT_CNR) contains the current count value "
        "and can be read at any time without disturbing the counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_epit_cnr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ESAI
#endif

// Bitfields in register ESAI_ETDR.
static const field_t hw_esai_etdr[] =
{
    {
        "ETDR",
        "ESAI Transmit Data Register.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ERDR.
static const field_t hw_esai_erdr[] =
{
    {
        "ERDR",
        "ESAI Receive Data Register.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ECR.
static const field_t hw_esai_ecr[] =
{
    {
        "ESAIEN",
        "ESAI Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERST",
        "ESAI Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERO",
        "EXTAL Receiver Out.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERI",
        "EXTAL Receiver In.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETO",
        "EXTAL Transmitter Out.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETI",
        "EXTAL Transmitter In.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ESR.
static const field_t hw_esai_esr[] =
{
    {
        "RD",
        "Receive Data.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RED",
        "Receive Even Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDE",
        "Receive Data Exception.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RLS",
        "Receive Last Slot.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TD",
        "Transmit Data.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TED",
        "Transmit Even Data.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDE",
        "Transmit Data Exception.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TLS",
        "Transmit Last Slot.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TFE",
        "Transmit FIFO Empty.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RFF",
        "Receive FIFO Full.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TINIT",
        "Transmit Initialization.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TFCR.
static const field_t hw_esai_tfcr[] =
{
    {
        "TFE",
        "Transmit FIFO Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFR",
        "Transmit FIFO Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE0",
        "Transmitter #0 FIFO Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE1",
        "Transmitter #1 FIFO Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE2",
        "Transmitter #2 FIFO Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE3",
        "Transmitter #3 FIFO Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE4",
        "Transmitter #4 FIFO Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE5",
        "Transmitter #5 FIFO Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFWM",
        "Transmit FIFO Watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWA",
        "Transmit Word Alignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIEN",
        "Transmitter Initialization Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TFSR.
static const field_t hw_esai_tfsr[] =
{
    {
        "TFCNT",
        "Transmit FIFO Counter.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NTFI",
        "Next Transmitter FIFO In.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NTFO",
        "Next Transmitter FIFO Out.",
        12, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RFCR.
static const field_t hw_esai_rfcr[] =
{
    {
        "RFE",
        "Receive FIFO Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFR",
        "Receive FIFO Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE0",
        "Receiver #0 FIFO Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE1",
        "Receiver #1 FIFO Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE2",
        "Receiver #2 FIFO Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE3",
        "Receiver #3 FIFO Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFWM",
        "Receive FIFO Watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWA",
        "Receive Word Alignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REXT",
        "Receive Extension.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RFSR.
static const field_t hw_esai_rfsr[] =
{
    {
        "RFCNT",
        "Receive FIFO Counter.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NRFO",
        "Next Receiver FIFO Out.",
        8, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NRFI",
        "Next Receiver FIFO In.",
        12, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX0.
static const field_t hw_esai_tx0[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX1.
static const field_t hw_esai_tx1[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX2.
static const field_t hw_esai_tx2[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX3.
static const field_t hw_esai_tx3[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX4.
static const field_t hw_esai_tx4[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX5.
static const field_t hw_esai_tx5[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TSR.
static const field_t hw_esai_tsr[] =
{
    {
        "TSR",
        "The write-only Transmit Slot Register (ESAI_TSR) is effectively a null"
        " data register that is used when the data is not to be transmitted in "
        "the available transmit time slot.",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX0.
static const field_t hw_esai_rx0[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full See"
        " ESAI Receive Shift Registers",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX1.
static const field_t hw_esai_rx1[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full See"
        " ESAI Receive Shift Registers",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX2.
static const field_t hw_esai_rx2[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full See"
        " ESAI Receive Shift Registers",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX3.
static const field_t hw_esai_rx3[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full See"
        " ESAI Receive Shift Registers",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_SAISR.
static const field_t hw_esai_saisr[] =
{
    {
        "IF0",
        "ESAI_SAISR Serial Input Flag 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IF1",
        "ESAI_SAISR Serial Inout Flag 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IF2",
        "ESAI_SAISR Serial Input Flag 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RFS",
        "ESAI_SAISR Receive Frame Sync Flag.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ROE",
        "ESAI_SAISR Receive Overrun Error Flag.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDF",
        "ESAI_SAISR Receive Data Register Full.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REDF",
        "ESAI_SAISR Receive Even-Data Register Full.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RODF",
        "ESAI_SAISR Receive Odd-Data Register Full.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TFS",
        "ESAI_SAISR Transmit Frame Sync Flag.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TUE",
        "ESAI_SAISR Transmit Underrun Error Flag.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDE",
        "ESAI_SAISR Transmit Data Register Empty.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEDE",
        "ESAI_SAISR Transmit Even-DataRegister Empty.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TODFE",
        "ESAI_SAISR Transmit Odd-Data Register Empty.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_SAICR.
static const field_t hw_esai_saicr[] =
{
    {
        "OF0",
        "ESAI_SAICR Serial Output Flag 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF1",
        "ESAI_SAICR Serial Output Flag 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2",
        "ESAI_SAICR Serial Output Flag 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYN",
        "ESAI_SAICR Synchronous Mode Selection.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEBE",
        "ESAI_SAICR Transmit External Buffer Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ALC",
        "ESAI_SAICR Alignment Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TCR.
static const field_t hw_esai_tcr[] =
{
    {
        "TE0",
        "ESAI_TCR ESAI Transmit 0 Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE1",
        "ESAI_TCR ESAI Transmit 1 Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE2",
        "ESAI_TCR ESAI Transmit 2 Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE3",
        "ESAI_TCR ESAI Transmit 3 Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE4",
        "ESAI_TCR ESAI Transmit 4 Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE5",
        "ESAI_TCR ESAI Transmit 5 Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSHFD",
        "ESAI_TCR Transmit Shift Direction.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWA",
        "ESAI_TCR Transmit Word Alignment Control.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMOD",
        "ESAI_TCR Transmit Network Mode Control (TMOD1-TMOD0).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSWS",
        "ESAI_TCR Tx Slot and Word Length Select (TSWS4-TSWS0).",
        10, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSL",
        "ESAI_TCR Transmit Frame Sync Length.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSR",
        "ESAI_TCR Transmit Frame Sync Relative Timing.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADC",
        "ESAI_TCR Transmit Zero Padding Control.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPR",
        "ESAI_TCR Transmit Section Personal Reset.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEIE",
        "ESAI_TCR Transmit Exception Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDIE",
        "ESAI_TCR Transmit Even Slot Data Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "ESAI_TCR Transmit Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TLIE",
        "ESAI_TCR Transmit Last Slot Interrupt Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TCCR.
static const field_t hw_esai_tccr[] =
{
    {
        "TPM",
        "ESAI_TCCR Transmit Prescale Modulus Select.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPSR",
        "ESAI_TCCR Transmit Prescaler Range.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDC",
        "ESAI_TCCR Tx Frame Rate Divider Control.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFP",
        "ESAI_TCCR Tx High Frequency Clock Divider.",
        14, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCKP",
        "ESAI_TCCR Transmit Clock Polarity.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSP",
        "ESAI_TCCR Transmit Frame Sync Polarity.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "THCKP",
        "ESAI_TCCR Transmit High Frequency Clock Polarity The Transmitter High "
        "Frequency Clock Polarity (THCKP) bit controls the polarity of the HCKT"
        ".",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCKD",
        "ESAI_TCCR Transmit Clock Source Direction.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSD",
        "ESAI_TCCR Transmit Frame Sync Signal Direction.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "THCKD",
        "ESAI_TCCR Transmit High Frequency Clock Direction.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RCR.
static const field_t hw_esai_rcr[] =
{
    {
        "RE0",
        "ESAI_RCR ESAI Receiver 0 Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE1",
        "ESAI_RCR ESAI Receiver 1 Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE2",
        "ESAI_RCR ESAI Receiver 2 Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE3",
        "ESAI_RCR ESAI Receiver 3 Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSHFD",
        "ESAI_RCR Receiver Shift Direction.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWA",
        "ESAI_RCR Receiver Word Alignment Control.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMOD",
        "ESAI_RCR Receiver Network Mode Control.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSWS",
        "ESAI_RCR Receiver Slot and Word Select.",
        10, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSL",
        "ESAI_RCR Receiver Frame Sync Length.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSR",
        "ESAI_RCR Receiver Frame Sync Relative Timing.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RPR",
        "ESAI_RCR Receiver Section Personal Reset.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REIE",
        "ESAI_RCR Receive Exception Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDIE",
        "ESAI_RCR Receive Even Slot Data Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RIE",
        "ESAI_RCR Receive Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLIE",
        "ESAI_RCR Receive Last Slot Interrupt Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RCCR.
static const field_t hw_esai_rccr[] =
{
    {
        "RPM",
        "ESAI_RCCR Receiver Prescale Modulus Select.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RPSR",
        "ESAI_RCCR Receiver Prescaler Range.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDC",
        "ESAI_RCCR Rx Frame Rate Divider Control.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFP",
        "ESAI_RCCR Rx High Frequency Clock Divider.",
        14, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCKP",
        "The Receiver Clock Polarity (RCKP) bit controls on which bit clock edg"
        "e data and frame sync are clocked out and latched in.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSP",
        "ESAI_RCCR Receiver Frame Sync Polarity.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RHCKP",
        "ESAI_RCCR Receiver High Frequency Clock Polarity.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCKD",
        "ESAI_RCCR Receiver Clock Source Direction.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSD",
        "ESAI_RCCR Receiver Frame Sync Signal Direction.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RHCKD",
        "ESAI_RCCR Receiver High Frequency Clock Direction.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TSMA.
static const field_t hw_esai_tsma[] =
{
    {
        "TS",
        "When bit number N in ESAI_TSMA is cleared, all the transmit data pins "
        "of the enabled transmitters are tri-stated during transmit time slot n"
        "umber N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TSMB.
static const field_t hw_esai_tsmb[] =
{
    {
        "TS",
        "When bit number N in ESAI_TSMB is cleared, all the transmit data pins "
        "of the enabled transmitters are tri-stated during transmit time slot n"
        "umber N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RSMA.
static const field_t hw_esai_rsma[] =
{
    {
        "RS",
        "When bit number N in the ESAI_RSMA register is cleared, the data from "
        "the enabled receivers input pins are shifted into their receive shift "
        "registers during slot number N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RSMB.
static const field_t hw_esai_rsmb[] =
{
    {
        "RS",
        "When bit number N in the ESAI_RSMB register is cleared, the data from "
        "the enabled receivers input pins are shifted into their receive shift "
        "registers during slot number N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_PRRC.
static const field_t hw_esai_prrc[] =
{
    {
        "PDC",
        "See .",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_PCRC.
static const field_t hw_esai_pcrc[] =
{
    {
        "PC",
        "See .",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ESAI module.
static const reg_t hw_esai[] =
{
    {
        "ETDR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_etdr
    },
    {
        "ERDR",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_erdr
    },
    {
        "ECR",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_esai_ecr
    },
    {
        "ESR",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        11, // Number of bitfields
        hw_esai_esr
    },
    {
        "TFCR",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_esai_tfcr
    },
    {
        "TFSR",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_esai_tfsr
    },
    {
        "RFCR",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_esai_rfcr
    },
    {
        "RFSR",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_esai_rfsr
    },
    {
        "TX0",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000080, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx0
    },
    {
        "TX1",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000084, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx1
    },
    {
        "TX2",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx2
    },
    {
        "TX3",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx3
    },
    {
        "TX4",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000090, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx4
    },
    {
        "TX5",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000094, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx5
    },
    {
        "TSR",
        "",
        4, // Width in bytes
        0x00000098, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tsr
    },
    {
        "RX0",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx0
    },
    {
        "RX1",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx1
    },
    {
        "RX2",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx2
    },
    {
        "RX3",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx3
    },
    {
        "SAISR",
        "The Status Register (ESAI_SAISR) is a read-only status register used b"
        "y the ARM Core to read the status and serial input flags of the ESAI.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_esai_saisr
    },
    {
        "SAICR",
        "The read/write Common Control Register (ESAI_SAICR) contains control b"
        "its for functions that affect both the receive and transmit sections o"
        "f the ESAI.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_esai_saicr
    },
    {
        "TCR",
        "The read/write Transmit Control Register (ESAI_TCR) controls the ESAI "
        "transmitter section.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_esai_tcr
    },
    {
        "TCCR",
        "The read/write Transmitter Clock Control Register (ESAI_TCCR) controls"
        " the ESAI transmitter clock generator bit and frame sync rates, the bi"
        "t clock and high frequency clock sources and the directions of the HCK"
        "T, FST and SCKT signals.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_esai_tccr
    },
    {
        "RCR",
        "The read/write Receive Control Register (ESAI_RCR) controls the ESAI r"
        "eceiver section.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_esai_rcr
    },
    {
        "RCCR",
        "The read/write Receiver Clock Control Register (ESAI_RCCR) controls th"
        "e ESAI receiver clock generator bit and frame sync rates, word length,"
        " and number of words per frame for the serial data.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_esai_rccr
    },
    {
        "TSMA",
        "The Transmit Slot Mask Register A together with Transmit Slot Mask Reg"
        "ister B (ESAI_TSMA and ESAI_TSMB) are two read/write registers used by"
        " the transmitters in network mode to determine for each slot whether t"
        "o transmit a data word and generate a transmitter empty condition (TDE"
        "=1), or to tri-state the transmitter data pins.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tsma
    },
    {
        "TSMB",
        "The Transmit Slot Mask Register B together with Transmit Slot Mask Reg"
        "ister A (ESAI_TSMA and ESAI_TSMB) are two read/write registers used by"
        " the transmitters in network mode to determine for each slot whether t"
        "o transmit a data word and generate a transmitter empty condition (TDE"
        "=1), or to tri-state the transmitter data pins.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tsmb
    },
    {
        "RSMA",
        "The Receive Slot Mask Register A together with Receive Slot Mask Regis"
        "ter B (ESAI_RSMA and ESAI_RSMB) are two read/write registers used by t"
        "he receiver in network mode to determine for each slot whether to rece"
        "ive a data word and generate a receiver full condition (RDF=1), or to "
        "ignore the received data.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_rsma
    },
    {
        "RSMB",
        "The Receive Slot Mask Register B together with Receive Slot Mask Regis"
        "ter A (ESAI_RSMA and ESAI_RSMB) are two read/write registers used by t"
        "he receiver in network mode to determine for each slot whether to rece"
        "ive a data word and generate a receiver full condition (RDF=1), or to "
        "ignore the received data.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_rsmb
    },
    {
        "PRRC",
        "There are two registers to control the ESAI personal reset status: Por"
        "t C Direction Register (ESAI_PRRC) and Port C Control Register (ESAI_P"
        "CRC).",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_prrc
    },
    {
        "PCRC",
        "The read/write 32-bit Port C Control Register (ESAI_PCRC) in conjuncti"
        "on with the Port C Direction Register (ESAI_PRRC) controls the functio"
        "nality of the ESAI personal reset state.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_pcrc
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FLEXCAN
#endif

// Bitfields in register FLEXCAN_MCR.
static const field_t hw_flexcan_mcr[] =
{
    {
        "MAXMB",
        "This 7-bit field defines the number of the last Message Buffers that w"
        "ill take part in the matching and arbitration processes.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDAM",
        "This 2-bit field identifies the format of the elements of the Rx FIFO "
        "filter table, as shown below.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AEN",
        "This bit is supplied for backwards compatibility reasons.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPRIO_EN",
        "This bit is provided for backwards compatibility reasons.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRMQ",
        "This bit indicates whether Rx matching process will be based either on"
        " individual masking and queue or on masking scheme with RXMGMASK, RX14"
        "MASK and RX15MASK, RXFGMASK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRX_DIS",
        "This bit defines whether FlexCAN is allowed to receive frames transmit"
        "ted by itself.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_SRC",
        "This bit defines whether the integrated low-pass filter is applied to "
        "protect the FLEXCAN_RX input from spurious wake up.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPM_ACK",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode or"
        " Stop Mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WRN_EN",
        "When asserted, this bit enables the generation of the TWRN_INT and RWR"
        "N_INT flags in the Error and Status Register.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLF_WAK",
        "This bit enables the Self Wake Up feature when FLEXCAN is in Stop Mode"
        ".",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUPV",
        "This bit configures some of the FLEXCAN registers to be either in Supe"
        "rvisor or User Mode.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ_ACK",
        "This read-only bit indicates that FLEXCAN is in Freeze Mode and its pr"
        "escaler is stopped.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SOFT_RST",
        "When this bit is asserted, FlexCAN resets its internal state machines "
        "and some of the memory mapped registers.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_MSK",
        "This bit enables the Wake Up Interrupt generation.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NOT_RDY",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode, S"
        "top Mode or Freeze Mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALT",
        "Assertion of this bit puts the FLEXCAN module into Freeze Mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "This bit controls whether the Rx FIFO feature is enabled or not.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ",
        "The FRZ bit specifies the FLEXCAN behavior when the HALT bit in the MC"
        "R Register is set or when Debug Mode is requested at ARM level.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MDIS",
        "This bit controls whether FLEXCAN is enabled or not.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CTRL1.
static const field_t hw_flexcan_ctrl1[] =
{
    {
        "PROP_SEG",
        "This 3-bit field defines the length of the Propagation Segment in the "
        "bit time.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOM",
        "This bit configures FLEXCAN to operate in Listen Only Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBUF",
        "This bit defines the ordering mechanism for Message Buffer transmissio"
        "n.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSYN",
        "This bit enables a mechanism that resets the free-running timer each t"
        "ime a message is received in Message Buffer 0.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_REC",
        "This bit defines how FLEXCAN recovers from Bus Off state.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMP",
        "This bit defines the sampling mode of CAN bits at the FLEXCAN_RX.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWRN_MSK",
        "This bit provides a mask for the Rx Warning Interrupt associated with "
        "the RWRN_INT flag in the Error and Status Register.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_MSK",
        "This bit provides a mask for the Tx Warning Interrupt associated with "
        "the TWRN_INT flag in the Error and Status Register.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPB",
        "This bit configures FlexCAN to operate in Loop-Back Mode.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_MSK",
        "This bit provides a mask for the Error Interrupt.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_MSK",
        "This bit provides a mask for the Bus Off Interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG2",
        "This 3-bit field defines the length of Phase Buffer Segment 2 in the b"
        "it time.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG1",
        "This 3-bit field defines the length of Phase Buffer Segment 1 in the b"
        "it time.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RJW",
        "This 2-bit field defines the maximum number of time quanta One time qu"
        "antum is equal to the Sclock period.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESDIV",
        "This 8-bit field defines the ratio between the PE clock frequency and "
        "the Serial Clock (Sclock) frequency.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_TIMER.
static const field_t hw_flexcan_timer[] =
{
    {
        "TIMER",
        "TIMER",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXMGMASK.
static const field_t hw_flexcan_rxmgmask[] =
{
    {
        "MG31_MG0",
        "These bits mask the Mailbox filter bits as shown in the figure above.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX14MASK.
static const field_t hw_flexcan_rx14mask[] =
{
    {
        "RX14M31_RX14M0",
        "These bits mask Mailbox 14 filter bits in the same fashion as RXMGMASK"
        " masks other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask R"
        "egister )",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX15MASK.
static const field_t hw_flexcan_rx15mask[] =
{
    {
        "RX15M31_RX15M0",
        "These bits mask Mailbox 15 filter bits in the same fashion as RXMGMASK"
        " masks other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask R"
        "egister ).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ECR.
static const field_t hw_flexcan_ecr[] =
{
    {
        "TX_ERR_COUNTER",
        "Tx_Err_Counter",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_ERR_COUNTER",
        "Rx_Err_Counter",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ESR1.
static const field_t hw_flexcan_esr1[] =
{
    {
        "WAK_INT",
        "When FLEXCAN is Stop Mode and a recessive to dominant transition is de"
        "tected on the CAN bus and if the WAK_MSK bit in the MCR Register is se"
        "t, an interrupt is generated to the ARM.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_INT",
        "This bit indicates that at least one of the Error Bits (bits 15-10) is"
        " set.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_INT",
        "This bit is set when FLEXCAN enters 'Bus Off' state.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX",
        "This bit indicates if FlexCAN is receiving a message.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FLT_CONF",
        "If the LOM bit in the Control Register is asserted, after some delay t"
        "hat depends on the CAN bit timing the FLT_CONF field will indicate \"E"
        "rror Passive\".",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX",
        "This bit indicates if FLEXCAN is transmitting a message.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE",
        "This bit indicates when CAN bus is in IDLE state.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " reception.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " transmission.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STF_ERR",
        "This bit indicates that a Stuffing Error has been detected.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FRM_ERR",
        "This bit indicates that a Form Error has been detected by the receiver"
        " node, i.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CRC_ERR",
        "This bit indicates that a CRC Error has been detected by the receiver "
        "node, i.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACK_ERR",
        "This bit indicates that an Acknowledge Error has been detected by the "
        "transmitter node, i.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT0_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT1_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the RWRN_INT bit is set when the"
        " RX_WRN flag transition from '0' to '1', meaning that the Rx error cou"
        "nters reached 96.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the TWRN_INT bit is set when the"
        " TX_WRN flag transition from '0' to '1', meaning that the Tx error cou"
        "nter reached 96.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNCH",
        "This read-only flag indicates whether the FlexCAN is synchronized to t"
        "he CAN bus and able to participate in the communication process.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK2.
static const field_t hw_flexcan_imask2[] =
{
    {
        "BUF63M_BUF32M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "32 to MB63) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK1.
static const field_t hw_flexcan_imask1[] =
{
    {
        "BUF31M_BUF0M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "0 to MB31) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG2.
static const field_t hw_flexcan_iflag2[] =
{
    {
        "BUF63I_BUF32I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB32 to MB63) in"
        "terrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG1.
static const field_t hw_flexcan_iflag1[] =
{
    {
        "BUF4I_BUF0I",
        "If the Rx FIFO is not enabled, these bits flag the interrupts for MB0 "
        "to MB4.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF5I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF6I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF7I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF31I_BUF8I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB8 to MB31) int"
        "errupt.",
        8, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CTRL2.
static const field_t hw_flexcan_ctrl2[] =
{
    {
        "EACEN",
        "This bit controls the comparison of IDE and RTR bits within Rx Mailbox"
        "es filters with their corresponding bits in the incoming frame by the "
        "matching process.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RRS",
        "If this bit is asserted Remote Request Frame is submitted to a matchin"
        "g process and stored in the corresponding Message Buffer in the same f"
        "ashion of a Data Frame.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MRP",
        "If this bit is set the matching process starts from the Mailboxes and "
        "if no match occurs the matching continues on the Rx FIFO.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TASD",
        "This 5-bit field indicates how many CAN bits the Tx arbitration proces"
        "s start point can be delayed from the first bit of CRC field on CAN bu"
        "s.",
        19, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "This 4-bit field defines the number of Rx FIFO filters according to .",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRMFRZ",
        "Enable unrestricted write access to FlexCAN memory in Freeze mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ESR2.
static const field_t hw_flexcan_esr2[] =
{
    {
        "IMB",
        "If ESR2[VPS] is asserted, this bit indicates whether there is any inac"
        "tive Mailbox (CODE field is either 0b1000 or 0b0000).",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VPS",
        "This bit indicates whether IMB and LPTM contents are currently valid o"
        "r not.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LPTM",
        "If ESR2[VPS] is asserted, his 7-bit field indicates the lowest number "
        "inactive Mailbox (refer to IMB bit description).",
        16, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CRCR.
static const field_t hw_flexcan_crcr[] =
{
    {
        "TXCRC",
        "This field indicates the CRC value of the last message transmitted.",
        0, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MBCRC",
        "This field indicates the number of the Mailbox corresponding to the va"
        "lue in TXCRC field.",
        16, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXFGMASK.
static const field_t hw_flexcan_rxfgmask[] =
{
    {
        "FGM31_FGM0",
        "These bits mask the ID Filter Table elements bits in a perfect alignme"
        "nt.RXFGMASKRx FIFO Global Mask Register shows in detail which FGM bits"
        " mask each IDAF field.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXFIR.
static const field_t hw_flexcan_rxfir[] =
{
    {
        "IDHIT",
        "This 9-bit field indicates which Identifier Acceptance Filter (see Rx "
        "FIFO StructureWhen the MCR[RFEN] bit is set, the memory area from $80 "
        "to $DC (which is normally occupied by MBs 0 to 5) is used by the recep"
        "tion FIFO engine.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXIMR0_RXIMR63.
static const field_t hw_flexcan_rximr0_rximr63[] =
{
    {
        "MI31_MI0",
        "These bits mask both Mailbox filter and Rx FIFO ID Filter Table elemen"
        "t in distinct ways.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_GFWR.
static const field_t hw_flexcan_gfwr[] =
{
    {
        "GFWR",
        "It determines the Glitch Filter Width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FLEXCAN module.
static const reg_t hw_flexcan[] =
{
    {
        "MCR",
        "This register defines global system configurations, such as the module"
        " operation mode (e.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_flexcan_mcr
    },
    {
        "CTRL1",
        "This register is defined for specific FLEXCAN control features related"
        " to the CAN bus, such as bit-rate, programmable sampling point within "
        "an Rx bit, Loop Back Mode, Listen Only Mode, Bus Off recovery behavior"
        " and interrupt enabling (Bus-Off, Error, Warning).",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_flexcan_ctrl1
    },
    {
        "TIMER",
        "This register represents a 16-bit free running counter that can be rea"
        "d and written by the ARM.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_timer
    },
    {
        "RXMGMASK",
        "RXMGMASK is provided for legacy support.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rxmgmask
    },
    {
        "RX14MASK",
        "RX14MASK is provided for legacy support, asserting the MCR[IRMQ] bit c"
        "auses the RX14MASK to have no effect on the module operation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx14mask
    },
    {
        "RX15MASK",
        "RX15MASK is provided for legacy support, asserting the MCR[IRMQ] bit c"
        "auses the RX15MASK Register to have no effect on the module operation.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx15mask
    },
    {
        "ECR",
        "This register has 2 8-bit fields reflecting the value of two FLEXCAN e"
        "rror counters: Transmit Error Counter (Tx_Err_Counter field) and Recei"
        "ve Error Counter (Rx_Err_Counter field).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_flexcan_ecr
    },
    {
        "ESR1",
        "This register reflects various error conditions, some general status o"
        "f the device and it is the source of four interrupts to the ARM.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_flexcan_esr1
    },
    {
        "IMASK2",
        "This register allows any number of a range of 32 Message Buffer Interr"
        "upts to be enabled or disabled.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask2
    },
    {
        "IMASK1",
        "This register allows to enable or disable any number of a range of 32 "
        "Message Buffer Interrupts.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask1
    },
    {
        "IFLAG2",
        "This register defines the flags for 32 Message Buffer interrupts.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_iflag2
    },
    {
        "IFLAG1",
        "This register defines the flags for 32 Message Buffer interrupts and F"
        "IFO interrupts.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_flexcan_iflag1
    },
    {
        "CTRL2",
        "This register contains control bits for CAN errors, FIFO features and "
        "mode selection.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexcan_ctrl2
    },
    {
        "ESR2",
        "This register reflects various interrupt flags and some general status"
        ".",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_flexcan_esr2
    },
    {
        "CRCR",
        "This register provides information about the CRC of transmitted messag"
        "es",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_flexcan_crcr
    },
    {
        "RXFGMASK",
        "If Rx FIFO is enabled RXFGMASK is used to mask the Rx FIFO ID Filter T"
        "able elements that do not have a corresponding RXIMR according to CTRL"
        "2[RFFN] field setting.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rxfgmask
    },
    {
        "RXFIR",
        "RXFIR provides information on Rx FIFO.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_flexcan_rxfir
    },
    {
        "RXIMR0_RXIMR63",
        "RXIMR are used as acceptance masks for ID filtering in Rx MBs and the "
        "Rx FIFO.",
        4, // Width in bytes
        0x00000880, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rximr0_rximr63
    },
    {
        "GFWR",
        "The Glitch Filter just takes effects when FLEXCAN enters the STOP mode"
        ".",
        4, // Width in bytes
        0x000009e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_gfwr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GIS
#endif

// Bitfields in register GIS_CTRL.
static const field_t hw_gis_ctrl[] =
{
    {
        "ENABLE",
        "Enable the block to process interrupts.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB_START",
        "Specifies which CSI FB finished and caused the first CSI interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_SEL",
        "Specifies which of the two LCDIF interfaces to use, which interrupt to"
        " monitor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_SEL",
        "Specifies which of the two CSI interfaces to use, which interrupt to m"
        "onitor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal GIS operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CTRL_SET.
static const field_t hw_gis_ctrl_set[] =
{
    {
        "ENABLE",
        "Enable the block to process interrupts.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB_START",
        "Specifies which CSI FB finished and caused the first CSI interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_SEL",
        "Specifies which of the two LCDIF interfaces to use, which interrupt to"
        " monitor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_SEL",
        "Specifies which of the two CSI interfaces to use, which interrupt to m"
        "onitor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal GIS operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CTRL_CLR.
static const field_t hw_gis_ctrl_clr[] =
{
    {
        "ENABLE",
        "Enable the block to process interrupts.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB_START",
        "Specifies which CSI FB finished and caused the first CSI interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_SEL",
        "Specifies which of the two LCDIF interfaces to use, which interrupt to"
        " monitor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_SEL",
        "Specifies which of the two CSI interfaces to use, which interrupt to m"
        "onitor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal GIS operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CTRL_TOG.
static const field_t hw_gis_ctrl_tog[] =
{
    {
        "ENABLE",
        "Enable the block to process interrupts.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB_START",
        "Specifies which CSI FB finished and caused the first CSI interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF_SEL",
        "Specifies which of the two LCDIF interfaces to use, which interrupt to"
        " monitor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_SEL",
        "Specifies which of the two CSI interfaces to use, which interrupt to m"
        "onitor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_IRQ_POLARITY",
        "This bit must be set to zero for normal operation.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_IRQ_POLARITY",
        "Specifies the polarity of the irq assertion level.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal GIS operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG0.
static const field_t hw_gis_config0[] =
{
    {
        "CH0_MAPPING",
        "Command channel0 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_MAPPING",
        "Command channel1 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_MAPPING",
        "Command channel2 assignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_NUM",
        "Number of valid commands to execute for this channel.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_MAPPING",
        "Command channel3 assignment.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_NUM",
        "Number of valid commands to execute for this channel.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG0_SET.
static const field_t hw_gis_config0_set[] =
{
    {
        "CH0_MAPPING",
        "Command channel0 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_MAPPING",
        "Command channel1 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_MAPPING",
        "Command channel2 assignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_NUM",
        "Number of valid commands to execute for this channel.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_MAPPING",
        "Command channel3 assignment.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_NUM",
        "Number of valid commands to execute for this channel.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG0_CLR.
static const field_t hw_gis_config0_clr[] =
{
    {
        "CH0_MAPPING",
        "Command channel0 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_MAPPING",
        "Command channel1 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_MAPPING",
        "Command channel2 assignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_NUM",
        "Number of valid commands to execute for this channel.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_MAPPING",
        "Command channel3 assignment.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_NUM",
        "Number of valid commands to execute for this channel.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG0_TOG.
static const field_t hw_gis_config0_tog[] =
{
    {
        "CH0_MAPPING",
        "Command channel0 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_MAPPING",
        "Command channel1 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_MAPPING",
        "Command channel2 assignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_NUM",
        "Number of valid commands to execute for this channel.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_MAPPING",
        "Command channel3 assignment.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_NUM",
        "Number of valid commands to execute for this channel.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG1.
static const field_t hw_gis_config1[] =
{
    {
        "CH4_MAPPING",
        "Command channel4 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_MAPPING",
        "Command channel5 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG1_SET.
static const field_t hw_gis_config1_set[] =
{
    {
        "CH4_MAPPING",
        "Command channel4 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_MAPPING",
        "Command channel5 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG1_CLR.
static const field_t hw_gis_config1_clr[] =
{
    {
        "CH4_MAPPING",
        "Command channel4 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_MAPPING",
        "Command channel5 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CONFIG1_TOG.
static const field_t hw_gis_config1_tog[] =
{
    {
        "CH4_MAPPING",
        "Command channel4 assignment.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_NUM",
        "Number of valid commands to execute for this channel.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_MAPPING",
        "Command channel5 assignment.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_NUM",
        "Number of valid commands to execute for this channel.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_FB0.
static const field_t hw_gis_fb0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_FB1.
static const field_t hw_gis_fb1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_PXP_FB0.
static const field_t hw_gis_pxp_fb0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_PXP_FB1.
static const field_t hw_gis_pxp_fb1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_CTRL.
static const field_t hw_gis_ch0_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_CTRL_SET.
static const field_t hw_gis_ch0_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_CTRL_CLR.
static const field_t hw_gis_ch0_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_CTRL_TOG.
static const field_t hw_gis_ch0_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR0.
static const field_t hw_gis_ch0_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR0_SET.
static const field_t hw_gis_ch0_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR0_CLR.
static const field_t hw_gis_ch0_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR0_TOG.
static const field_t hw_gis_ch0_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_DATA0.
static const field_t hw_gis_ch0_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR1.
static const field_t hw_gis_ch0_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR1_SET.
static const field_t hw_gis_ch0_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR1_CLR.
static const field_t hw_gis_ch0_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR1_TOG.
static const field_t hw_gis_ch0_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_DATA1.
static const field_t hw_gis_ch0_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR2.
static const field_t hw_gis_ch0_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR2_SET.
static const field_t hw_gis_ch0_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR2_CLR.
static const field_t hw_gis_ch0_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR2_TOG.
static const field_t hw_gis_ch0_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_DATA2.
static const field_t hw_gis_ch0_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR3.
static const field_t hw_gis_ch0_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR3_SET.
static const field_t hw_gis_ch0_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR3_CLR.
static const field_t hw_gis_ch0_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_ADDR3_TOG.
static const field_t hw_gis_ch0_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH0_DATA3.
static const field_t hw_gis_ch0_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_CTRL.
static const field_t hw_gis_ch1_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_CTRL_SET.
static const field_t hw_gis_ch1_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_CTRL_CLR.
static const field_t hw_gis_ch1_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_CTRL_TOG.
static const field_t hw_gis_ch1_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR0.
static const field_t hw_gis_ch1_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR0_SET.
static const field_t hw_gis_ch1_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR0_CLR.
static const field_t hw_gis_ch1_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR0_TOG.
static const field_t hw_gis_ch1_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_DATA0.
static const field_t hw_gis_ch1_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR1.
static const field_t hw_gis_ch1_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR1_SET.
static const field_t hw_gis_ch1_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR1_CLR.
static const field_t hw_gis_ch1_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR1_TOG.
static const field_t hw_gis_ch1_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_DATA1.
static const field_t hw_gis_ch1_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR2.
static const field_t hw_gis_ch1_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR2_SET.
static const field_t hw_gis_ch1_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR2_CLR.
static const field_t hw_gis_ch1_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR2_TOG.
static const field_t hw_gis_ch1_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_DATA2.
static const field_t hw_gis_ch1_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR3.
static const field_t hw_gis_ch1_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR3_SET.
static const field_t hw_gis_ch1_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR3_CLR.
static const field_t hw_gis_ch1_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_ADDR3_TOG.
static const field_t hw_gis_ch1_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH1_DATA3.
static const field_t hw_gis_ch1_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_CTRL.
static const field_t hw_gis_ch2_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_CTRL_SET.
static const field_t hw_gis_ch2_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_CTRL_CLR.
static const field_t hw_gis_ch2_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_CTRL_TOG.
static const field_t hw_gis_ch2_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR0.
static const field_t hw_gis_ch2_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR0_SET.
static const field_t hw_gis_ch2_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR0_CLR.
static const field_t hw_gis_ch2_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR0_TOG.
static const field_t hw_gis_ch2_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_DATA0.
static const field_t hw_gis_ch2_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR1.
static const field_t hw_gis_ch2_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR1_SET.
static const field_t hw_gis_ch2_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR1_CLR.
static const field_t hw_gis_ch2_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR1_TOG.
static const field_t hw_gis_ch2_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_DATA1.
static const field_t hw_gis_ch2_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR2.
static const field_t hw_gis_ch2_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR2_SET.
static const field_t hw_gis_ch2_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR2_CLR.
static const field_t hw_gis_ch2_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR2_TOG.
static const field_t hw_gis_ch2_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_DATA2.
static const field_t hw_gis_ch2_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR3.
static const field_t hw_gis_ch2_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR3_SET.
static const field_t hw_gis_ch2_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR3_CLR.
static const field_t hw_gis_ch2_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_ADDR3_TOG.
static const field_t hw_gis_ch2_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH2_DATA3.
static const field_t hw_gis_ch2_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_CTRL.
static const field_t hw_gis_ch3_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_CTRL_SET.
static const field_t hw_gis_ch3_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_CTRL_CLR.
static const field_t hw_gis_ch3_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_CTRL_TOG.
static const field_t hw_gis_ch3_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR0.
static const field_t hw_gis_ch3_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR0_SET.
static const field_t hw_gis_ch3_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR0_CLR.
static const field_t hw_gis_ch3_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR0_TOG.
static const field_t hw_gis_ch3_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_DATA0.
static const field_t hw_gis_ch3_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR1.
static const field_t hw_gis_ch3_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR1_SET.
static const field_t hw_gis_ch3_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR1_CLR.
static const field_t hw_gis_ch3_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR1_TOG.
static const field_t hw_gis_ch3_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_DATA1.
static const field_t hw_gis_ch3_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR2.
static const field_t hw_gis_ch3_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR2_SET.
static const field_t hw_gis_ch3_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR2_CLR.
static const field_t hw_gis_ch3_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR2_TOG.
static const field_t hw_gis_ch3_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_DATA2.
static const field_t hw_gis_ch3_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR3.
static const field_t hw_gis_ch3_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR3_SET.
static const field_t hw_gis_ch3_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR3_CLR.
static const field_t hw_gis_ch3_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_ADDR3_TOG.
static const field_t hw_gis_ch3_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH3_DATA3.
static const field_t hw_gis_ch3_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_CTRL.
static const field_t hw_gis_ch4_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_CTRL_SET.
static const field_t hw_gis_ch4_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_CTRL_CLR.
static const field_t hw_gis_ch4_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_CTRL_TOG.
static const field_t hw_gis_ch4_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR0.
static const field_t hw_gis_ch4_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR0_SET.
static const field_t hw_gis_ch4_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR0_CLR.
static const field_t hw_gis_ch4_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR0_TOG.
static const field_t hw_gis_ch4_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_DATA0.
static const field_t hw_gis_ch4_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR1.
static const field_t hw_gis_ch4_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR1_SET.
static const field_t hw_gis_ch4_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR1_CLR.
static const field_t hw_gis_ch4_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR1_TOG.
static const field_t hw_gis_ch4_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_DATA1.
static const field_t hw_gis_ch4_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR2.
static const field_t hw_gis_ch4_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR2_SET.
static const field_t hw_gis_ch4_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR2_CLR.
static const field_t hw_gis_ch4_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR2_TOG.
static const field_t hw_gis_ch4_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_DATA2.
static const field_t hw_gis_ch4_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR3.
static const field_t hw_gis_ch4_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR3_SET.
static const field_t hw_gis_ch4_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR3_CLR.
static const field_t hw_gis_ch4_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_ADDR3_TOG.
static const field_t hw_gis_ch4_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH4_DATA3.
static const field_t hw_gis_ch4_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_CTRL.
static const field_t hw_gis_ch5_ctrl[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_CTRL_SET.
static const field_t hw_gis_ch5_ctrl_set[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_CTRL_CLR.
static const field_t hw_gis_ch5_ctrl_clr[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_CTRL_TOG.
static const field_t hw_gis_ch5_ctrl_tog[] =
{
    {
        "CMD0_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD0_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD1_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD2_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_OPCODE",
        "This field specifies the opcode to go along with the address and data "
        "values for this command.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ALU",
        "Specifies the what logical or arithmetic operation for the ALU when co"
        "mbining the accumulator and the data bits.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMD3_ACC_NEG",
        "If the accumulator is used in the command this bit specifies if the ac"
        "cumulator value should be to negated before it is used in the command.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR0.
static const field_t hw_gis_ch5_addr0[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR0_SET.
static const field_t hw_gis_ch5_addr0_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR0_CLR.
static const field_t hw_gis_ch5_addr0_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR0_TOG.
static const field_t hw_gis_ch5_addr0_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_DATA0.
static const field_t hw_gis_ch5_data0[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR1.
static const field_t hw_gis_ch5_addr1[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR1_SET.
static const field_t hw_gis_ch5_addr1_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR1_CLR.
static const field_t hw_gis_ch5_addr1_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR1_TOG.
static const field_t hw_gis_ch5_addr1_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_DATA1.
static const field_t hw_gis_ch5_data1[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR2.
static const field_t hw_gis_ch5_addr2[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR2_SET.
static const field_t hw_gis_ch5_addr2_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR2_CLR.
static const field_t hw_gis_ch5_addr2_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR2_TOG.
static const field_t hw_gis_ch5_addr2_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_DATA2.
static const field_t hw_gis_ch5_data2[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR3.
static const field_t hw_gis_ch5_addr3[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR3_SET.
static const field_t hw_gis_ch5_addr3_set[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR3_CLR.
static const field_t hw_gis_ch5_addr3_clr[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_ADDR3_TOG.
static const field_t hw_gis_ch5_addr3_tog[] =
{
    {
        "ADDR",
        "32 bit address of command.",
        0, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI0_SEL",
        "This bit selects the CSI0 block as the target if this command will acc"
        "ess the bus.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI1_SEL",
        "This bit selects the CSI1 block as the target if this command will acc"
        "ess the bus.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PXP_SEL",
        "This bit selects the PXP block as the target if this command will acce"
        "ss the bus.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF0_SEL",
        "This bit selects the LCDIF0 block as the target if this command will a"
        "ccess the bus.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_SEL",
        "This bit selects the LCDIF1 block as the target if this command will a"
        "ccess the bus.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_CH5_DATA3.
static const field_t hw_gis_ch5_data3[] =
{
    {
        "DATA",
        "32 bit address of command.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_DEBUG0.
static const field_t hw_gis_debug0[] =
{
    {
        "CMD_STATE",
        "For debug purposes only.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAIN_STATE",
        "For debug purposes only.",
        8, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHANNEL_CUR",
        "For debug purposes only.",
        14, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMD_COUNTER",
        "For debug purposes only.",
        18, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMD_OPCODE",
        "For debug purposes only.",
        21, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_BUSY",
        "For debug purposes only.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_IRQ",
        "For debug purposes only.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CSI_IRQ",
        "For debug purposes only.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CSI_FB_REG",
        "For debug purposes only.",
        28, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_DEBUG1.
static const field_t hw_gis_debug1[] =
{
    {
        "CSI_FB",
        "For debug purposes only.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_OUT_FB",
        "For debug purposes only.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PXP_IN_FB",
        "For debug purposes only.",
        16, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LCDIF_FB",
        "For debug purposes only.",
        18, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GIS_VERSION.
static const field_t hw_gis_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GIS module.
static const reg_t hw_gis[] =
{
    {
        "CTRL",
        "The control register provides control for the overall block.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gis_ctrl
    },
    {
        "CTRL_SET",
        "The control register provides control for the overall block.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gis_ctrl_set
    },
    {
        "CTRL_CLR",
        "The control register provides control for the overall block.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gis_ctrl_clr
    },
    {
        "CTRL_TOG",
        "The control register provides control for the overall block.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gis_ctrl_tog
    },
    {
        "CONFIG0",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_gis_config0
    },
    {
        "CONFIG0_SET",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_gis_config0_set
    },
    {
        "CONFIG0_CLR",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_gis_config0_clr
    },
    {
        "CONFIG0_TOG",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_gis_config0_tog
    },
    {
        "CONFIG1",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gis_config1
    },
    {
        "CONFIG1_SET",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gis_config1_set
    },
    {
        "CONFIG1_CLR",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gis_config1_clr
    },
    {
        "CONFIG1_TOG",
        "This register provides configuration of the GIS channels.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gis_config1_tog
    },
    {
        "FB0",
        "Camera frame buffer address 0.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_fb0
    },
    {
        "FB1",
        "Camera frame buffer address 1.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_fb1
    },
    {
        "PXP_FB0",
        "PXP frame buffer address 0.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_pxp_fb0
    },
    {
        "PXP_FB1",
        "PXP frame buffer address 1.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_pxp_fb1
    },
    {
        "CH0_CTRL",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch0_ctrl
    },
    {
        "CH0_CTRL_SET",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch0_ctrl_set
    },
    {
        "CH0_CTRL_CLR",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch0_ctrl_clr
    },
    {
        "CH0_CTRL_TOG",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch0_ctrl_tog
    },
    {
        "CH0_ADDR0",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr0
    },
    {
        "CH0_ADDR0_SET",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr0_set
    },
    {
        "CH0_ADDR0_CLR",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr0_clr
    },
    {
        "CH0_ADDR0_TOG",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr0_tog
    },
    {
        "CH0_DATA0",
        "Data register for channel 0 command 0.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch0_data0
    },
    {
        "CH0_ADDR1",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr1
    },
    {
        "CH0_ADDR1_SET",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr1_set
    },
    {
        "CH0_ADDR1_CLR",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr1_clr
    },
    {
        "CH0_ADDR1_TOG",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr1_tog
    },
    {
        "CH0_DATA1",
        "Data register for channel 0 command 1.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch0_data1
    },
    {
        "CH0_ADDR2",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr2
    },
    {
        "CH0_ADDR2_SET",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr2_set
    },
    {
        "CH0_ADDR2_CLR",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr2_clr
    },
    {
        "CH0_ADDR2_TOG",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr2_tog
    },
    {
        "CH0_DATA2",
        "Data register for channel 0 command 2.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch0_data2
    },
    {
        "CH0_ADDR3",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr3
    },
    {
        "CH0_ADDR3_SET",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr3_set
    },
    {
        "CH0_ADDR3_CLR",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr3_clr
    },
    {
        "CH0_ADDR3_TOG",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch0_addr3_tog
    },
    {
        "CH0_DATA3",
        "Data register for channel 0 command 3.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch0_data3
    },
    {
        "CH1_CTRL",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch1_ctrl
    },
    {
        "CH1_CTRL_SET",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch1_ctrl_set
    },
    {
        "CH1_CTRL_CLR",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch1_ctrl_clr
    },
    {
        "CH1_CTRL_TOG",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch1_ctrl_tog
    },
    {
        "CH1_ADDR0",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr0
    },
    {
        "CH1_ADDR0_SET",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr0_set
    },
    {
        "CH1_ADDR0_CLR",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr0_clr
    },
    {
        "CH1_ADDR0_TOG",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr0_tog
    },
    {
        "CH1_DATA0",
        "Data register for channel 0 command 0.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch1_data0
    },
    {
        "CH1_ADDR1",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr1
    },
    {
        "CH1_ADDR1_SET",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr1_set
    },
    {
        "CH1_ADDR1_CLR",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr1_clr
    },
    {
        "CH1_ADDR1_TOG",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr1_tog
    },
    {
        "CH1_DATA1",
        "Data register for channel 0 command 1.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch1_data1
    },
    {
        "CH1_ADDR2",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr2
    },
    {
        "CH1_ADDR2_SET",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr2_set
    },
    {
        "CH1_ADDR2_CLR",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr2_clr
    },
    {
        "CH1_ADDR2_TOG",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr2_tog
    },
    {
        "CH1_DATA2",
        "Data register for channel 0 command 2.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch1_data2
    },
    {
        "CH1_ADDR3",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr3
    },
    {
        "CH1_ADDR3_SET",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr3_set
    },
    {
        "CH1_ADDR3_CLR",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr3_clr
    },
    {
        "CH1_ADDR3_TOG",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch1_addr3_tog
    },
    {
        "CH1_DATA3",
        "Data register for channel 0 command 3.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch1_data3
    },
    {
        "CH2_CTRL",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch2_ctrl
    },
    {
        "CH2_CTRL_SET",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000194, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch2_ctrl_set
    },
    {
        "CH2_CTRL_CLR",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000198, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch2_ctrl_clr
    },
    {
        "CH2_CTRL_TOG",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x0000019c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch2_ctrl_tog
    },
    {
        "CH2_ADDR0",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr0
    },
    {
        "CH2_ADDR0_SET",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000001a4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr0_set
    },
    {
        "CH2_ADDR0_CLR",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000001a8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr0_clr
    },
    {
        "CH2_ADDR0_TOG",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000001ac, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr0_tog
    },
    {
        "CH2_DATA0",
        "Data register for channel 0 command 0.",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch2_data0
    },
    {
        "CH2_ADDR1",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr1
    },
    {
        "CH2_ADDR1_SET",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000001c4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr1_set
    },
    {
        "CH2_ADDR1_CLR",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000001c8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr1_clr
    },
    {
        "CH2_ADDR1_TOG",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000001cc, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr1_tog
    },
    {
        "CH2_DATA1",
        "Data register for channel 0 command 1.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch2_data1
    },
    {
        "CH2_ADDR2",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr2
    },
    {
        "CH2_ADDR2_SET",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000001e4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr2_set
    },
    {
        "CH2_ADDR2_CLR",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000001e8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr2_clr
    },
    {
        "CH2_ADDR2_TOG",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x000001ec, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr2_tog
    },
    {
        "CH2_DATA2",
        "Data register for channel 0 command 2.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch2_data2
    },
    {
        "CH2_ADDR3",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr3
    },
    {
        "CH2_ADDR3_SET",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr3_set
    },
    {
        "CH2_ADDR3_CLR",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr3_clr
    },
    {
        "CH2_ADDR3_TOG",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch2_addr3_tog
    },
    {
        "CH2_DATA3",
        "Data register for channel 0 command 3.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch2_data3
    },
    {
        "CH3_CTRL",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch3_ctrl
    },
    {
        "CH3_CTRL_SET",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000224, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch3_ctrl_set
    },
    {
        "CH3_CTRL_CLR",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x00000228, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch3_ctrl_clr
    },
    {
        "CH3_CTRL_TOG",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x0000022c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch3_ctrl_tog
    },
    {
        "CH3_ADDR0",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr0
    },
    {
        "CH3_ADDR0_SET",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000234, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr0_set
    },
    {
        "CH3_ADDR0_CLR",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x00000238, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr0_clr
    },
    {
        "CH3_ADDR0_TOG",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x0000023c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr0_tog
    },
    {
        "CH3_DATA0",
        "Data register for channel 0 command 0.",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch3_data0
    },
    {
        "CH3_ADDR1",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr1
    },
    {
        "CH3_ADDR1_SET",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000254, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr1_set
    },
    {
        "CH3_ADDR1_CLR",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x00000258, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr1_clr
    },
    {
        "CH3_ADDR1_TOG",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x0000025c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr1_tog
    },
    {
        "CH3_DATA1",
        "Data register for channel 0 command 1.",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch3_data1
    },
    {
        "CH3_ADDR2",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr2
    },
    {
        "CH3_ADDR2_SET",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000274, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr2_set
    },
    {
        "CH3_ADDR2_CLR",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000278, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr2_clr
    },
    {
        "CH3_ADDR2_TOG",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x0000027c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr2_tog
    },
    {
        "CH3_DATA2",
        "Data register for channel 0 command 2.",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch3_data2
    },
    {
        "CH3_ADDR3",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr3
    },
    {
        "CH3_ADDR3_SET",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000294, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr3_set
    },
    {
        "CH3_ADDR3_CLR",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000298, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr3_clr
    },
    {
        "CH3_ADDR3_TOG",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x0000029c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch3_addr3_tog
    },
    {
        "CH3_DATA3",
        "Data register for channel 0 command 3.",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch3_data3
    },
    {
        "CH4_CTRL",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch4_ctrl
    },
    {
        "CH4_CTRL_SET",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x000002b4, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch4_ctrl_set
    },
    {
        "CH4_CTRL_CLR",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x000002b8, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch4_ctrl_clr
    },
    {
        "CH4_CTRL_TOG",
        "Control information for command channel 0.",
        4, // Width in bytes
        0x000002bc, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gis_ch4_ctrl_tog
    },
    {
        "CH4_ADDR0",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr0
    },
    {
        "CH4_ADDR0_SET",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000002c4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr0_set
    },
    {
        "CH4_ADDR0_CLR",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000002c8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr0_clr
    },
    {
        "CH4_ADDR0_TOG",
        "Address register for channel 0 command 0.",
        4, // Width in bytes
        0x000002cc, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr0_tog
    },
    {
        "CH4_DATA0",
        "Data register for channel 0 command 0.",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch4_data0
    },
    {
        "CH4_ADDR1",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr1
    },
    {
        "CH4_ADDR1_SET",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000002e4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr1_set
    },
    {
        "CH4_ADDR1_CLR",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000002e8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr1_clr
    },
    {
        "CH4_ADDR1_TOG",
        "Address register for channel 0 command 1.",
        4, // Width in bytes
        0x000002ec, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr1_tog
    },
    {
        "CH4_DATA1",
        "Data register for channel 0 command 1.",
        4, // Width in bytes
        0x000002f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch4_data1
    },
    {
        "CH4_ADDR2",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr2
    },
    {
        "CH4_ADDR2_SET",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000304, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr2_set
    },
    {
        "CH4_ADDR2_CLR",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x00000308, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr2_clr
    },
    {
        "CH4_ADDR2_TOG",
        "Address register for channel 0 command 2.",
        4, // Width in bytes
        0x0000030c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr2_tog
    },
    {
        "CH4_DATA2",
        "Data register for channel 0 command 2.",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gis_ch4_data2
    },
    {
        "CH4_ADDR3",
        "Address register for channel 0 command 3.",
        4, // Width in bytes
        0x00000320, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gis_ch4_addr3
    },
    {
        "CH4_ADDR3_SET",
        "Addre