// Copyright 2014 The ChromeOS IME Authors. All Rights Reserved.
// limitations under the License.
// See the License for the specific language governing permissions and
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// distributed under the License is distributed on an "AS-IS" BASIS,
// Unless required by applicable law or agreed to in writing, software
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// You may obtain a copy of the License at
// you may not use this file except in compliance with the License.
// Licensed under the Apache License, Version 2.0 (the "License");
//
goog.provide('i18n.input.chrome.message.Type');


/**
 * The message type.
 *
 * @enum {string}
 */
i18n.input.chrome.message.Type = {
  CANDIDATES_BACK: 'candidates_back',
  COMMIT_TEXT: 'commit_text',
  COMPLETION: 'completion',
  CONNECT: 'connect',
  CONTEXT_BLUR: 'context_blur',
  CONTEXT_FOCUS: 'context_focus',
  DATASOURCE_READY: 'datasource_ready',
  DISCONNECT: 'disconnect',
  DOUBLE_CLICK_ON_SPACE_KEY: 'double_click_on_space_key',
  EMOJI_SET_INPUTTOOL: 'emoji_set_inputtool',
  EMOJI_UNSET_INPUTTOOL: 'emoji_unset_inputtool',
  EXEC_ALL: 'exec_all',
  HWT_NETWORK_ERROR: 'hwt_network_error',
  HWT_PRIVACY_GOT_IT: 'hwt_privacy_got_it',
  HWT_PRIVACY_INFO: 'hwt_privacy_info',
  HWT_REQUEST: 'hwt_request',
  HWT_SET_INPUTTOOL: 'hwt_set_inputtool',
  HWT_UNSET_INPUTTOOL: 'hwt_unset_inputtool',
  KEY_CLICK: 'key_click',
  KEY_EVENT: 'key_event',
  OPTION_CHANGE: 'option_change',
  PREDICTION: 'prediction',
  SELECT_CANDIDATE: 'select_candidate',
  SEND_KEY_EVENT: 'send_key_event',
  SET_COMPOSITION: 'set_composition',
  SET_LANGUAGE: 'set_language',
  SURROUNDING_TEXT_CHANGED: 'surrounding_text_changed',
  SWITCH_KEYSET: 'switch_keyset',
  TOGGLE_LANGUAGE_STATE: 'toggle_language_state',
  UPDATE_SETTINGS: 'update_settings',
  VISIBILITY_CHANGE: 'visibility_change'
};



