// Copyright 2014 The ChromeOS IME Authors. All Rights Reserved.
// limitations under the License.
// See the License for the specific language governing permissions and
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// distributed under the License is distributed on an "AS-IS" BASIS,
// Unless required by applicable law or agreed to in writing, software
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// You may obtain a copy of the License at
// you may not use this file except in compliance with the License.
// Licensed under the Apache License, Version 2.0 (the "License");
//
goog.provide('i18n.input.chrome.message.Name');

/**
 * The message attribute name.
 *
 * @enum {string}
 */
i18n.input.chrome.message.Name = {
  ALT_KEY: 'altKey',
  CANDIDATE: 'candidate',
  CANDIDATES: 'candidates',
  CANDIDATE_ID: 'candidateID',
  CODE: 'code',
  CONTEXT_ID: 'contextID',
  CONTEXT_TYPE: 'contextType',
  CURSOR_VISIBLE: 'cursorVisible',
  CTRL_KEY: 'ctrlKey',
  CURSOR: 'cursor',
  ENGINE_ID: 'engineID',
  HEIGHT: 'height',
  ID: 'id',
  IS_EMOJI: 'isEmoji',
  IS_AUTOCORRECT: 'isAutoCorrect',
  KEY: 'key',
  KEYCODE: 'keyCode',
  KEYSET: 'keyset',
  KEY_DATA: 'keyData',
  LANGUAGE: 'language',
  MATCHED_LENGTHS: 'matchedLengths',
  MSG: 'msg',
  TYPE: 'type',
  OPTION_PREFIX: 'optionPrefix',
  OPTION_TYPE: 'optionType',
  PAGE_SIZE: 'pageSize',
  POSSIBILITIES: 'possibilities',
  PROPERTIES: 'properties',
  REQUEST_ID: 'requestId',
  SHIFT_KEY: 'shiftKey',
  SOURCE: 'source',
  SOURCES: 'sources',
  SPATIAL_DATA: 'spatialData',
  SCREEN: 'screen',
  STROKES: 'strokes',
  TEXT: 'text',
  VERTICAL: 'vertical',
  VISIBLE: 'visible',
  VISIBILITY: 'visibility',
  WIDTH: 'width'
};
