// Copyright 2014 The ChromeOS IME Authors. All Rights Reserved.
// limitations under the License.
// See the License for the specific language governing permissions and
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// distributed under the License is distributed on an "AS-IS" BASIS,
// Unless required by applicable law or agreed to in writing, software
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// You may obtain a copy of the License at
// you may not use this file except in compliance with the License.
// Licensed under the Apache License, Version 2.0 (the "License");
//
goog.provide('i18n.input.chrome.inputview.SpecNodeName');


/**
 * The node name in the specification.
 *
 * @enum {string}
 */
i18n.input.chrome.inputview.SpecNodeName = {
  ALIGN: 'align',
  CHARACTERS: 'characters',
  CHILDREN: 'children',
  CONDITION: 'condition',
  DIRECTION: 'direction',
  GIVE_WEIGHT_TO: 'giveWeightTo',
  HAS_ALTGR_KEY: 'hasAltGrKey',
  HEIGHT: 'height',
  HEIGHT_IN_WEIGHT: 'heightInWeight',
  HEIGHT_PERCENT: 'heightPercent',
  HINT_TEXT: 'hintText',
  ICON_CSS_CLASS: 'iconCssClass',
  ID: 'id',
  IS_GREY: 'isGrey',
  LAYOUT: 'layout',
  LAYOUT_ID: 'layoutID',
  HEIGHT_PERCENT_OF_WIDTH: 'heightPercentOfWidth',
  MARGIN_LEFT_PERCENT: 'marginLeftPercent',
  MARGIN_RIGHT_PERCENT: 'marginRightPercent',
  MINIMUM_HEIGHT: 'minimumHeight',
  MORE_KEYS: 'moreKeys',
  NO_SHIFT: 'noShift',
  NUMBER_ROW_WEIGHT: 'numberRowWeight',
  KEY_CODE: 'keyCode',
  KEY_LIST: 'keyList',
  MAPPING: 'mapping',
  NAME: 'name',
  ON_CONTEXT: 'onContext',
  PADDING: 'padding',
  RECORD: 'record',
  SHOW_MENU_KEY: 'showMenuKey',
  SUPPORT_STICKY: 'supportSticky',
  SPEC: 'spec',
  TEXT: 'text',
  TEXT_CSS_CLASS: 'textCssClass',
  TITLE: 'title',
  TYPE: 'type',
  TO_STATE: 'toState',
  TO_KEYSET: 'toKeyset',
  TO_KEYSET_NAME: 'toKeysetName',
  WIDTH: 'width',
  WIDTH_IN_WEIGHT: 'widthInWeight',
  WIDTH_PERCENT: 'widthPercent',
  IS_EMOTICON: 'isEmoticon',
  MORE_KEYS_SHIFT_OPERATION: 'moreKeysShiftOperation',
  ON_SHIFT: 'onShift'
};

