// Copyright 2014 The ChromeOS IME Authors. All Rights Reserved.
// limitations under the License.
// See the License for the specific language governing permissions and
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// distributed under the License is distributed on an "AS-IS" BASIS,
// Unless required by applicable law or agreed to in writing, software
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// You may obtain a copy of the License at
// you may not use this file except in compliance with the License.
// Licensed under the Apache License, Version 2.0 (the "License");
//

/**
 * @fileoverview Defines the class i18n.input.hwt.Css.
 * @author fengyuan@google.com (Feng Yuan)
 */
goog.provide('i18n.input.hwt.css');


/**
 * CSS used for handwriting input pad.
 *
 * @enum {string}
 */
i18n.input.hwt.css = {
  RTL: goog.getCssName('ita-hwt-rtl'),
  LTR: goog.getCssName('ita-hwt-ltr'),
  IME: goog.getCssName('ita-hwt-ime'),
  IME_HOVER: goog.getCssName('ita-hwt-ime-hover'),
  IME_OPAQUE: goog.getCssName('ita-hwt-ime-opaque'),
  IME_ST: goog.getCssName('ita-hwt-ime-st'),
  IME_INIT_OPAQUE: goog.getCssName('ita-hwt-ime-init-opaque'),
  CLOSE: goog.getCssName('ita-hwt-close'),
  GRIP: goog.getCssName('ita-hwt-grip'),
  GRIP_HOVER: goog.getCssName('ita-hwt-grip-hover'),
  CANVAS: goog.getCssName('ita-hwt-canvas'),
  CANDIDATES: goog.getCssName('ita-hwt-candidates'),
  CANDIDATE: goog.getCssName('ita-hwt-candidate'),
  CANDIDATE_HOVER: goog.getCssName('ita-hwt-candidate-hover'),
  SELECTED: goog.getCssName('ita-hwt-selected'),
  DISABLED: goog.getCssName('ita-hwt-disabled'),
  BUTTONS: goog.getCssName('ita-hwt-buttons'),
  DIVIDER: goog.getCssName('ita-hwt-divider'),
  BUTTON: goog.getCssName('ita-hwt-button'),
  BACKSPACE: goog.getCssName('ita-hwt-backspace'),
  BACKSPACE_IMG: goog.getCssName('ita-hwt-backspace-img'),
  SPACE: goog.getCssName('ita-hwt-space'),
  ENTER: goog.getCssName('ita-hwt-enter'),
  ENTER_IMG: goog.getCssName('ita-hwt-enter-img'),
  ENTER_IMG_DARK: goog.getCssName('ita-hwt-enter-img-dark'),
  ENTER_IMG_WHITE: goog.getCssName('ita-hwt-enter-img-white'),
  LANGUAGE: goog.getCssName('ita-hwt-language'),
  CLEAR_TIME: goog.getCssName('ita-hwt-clear-time'),
  INSERT_TIME: goog.getCssName('ita-hwt-insert-time'),
  REMOTE_SPRITE: goog.getCssName('ita-kd-img'),
  MAXIMIZED: goog.getCssName('ita-hwt-ime-full'),
  JFK_BUTTON: goog.getCssName('ita-hwt-jfk'),
  JFK_STANDARD: goog.getCssName('ita-hwt-jfk-standard'),
  JFK_ACTION: goog.getCssName('ita-hwt-jfk-action'),
  JFK_HOVER: goog.getCssName('ita-hwt-jfk-hover'),
  BUTTER_BAR: goog.getCssName('ita-hwt-butterbar'),
  SHOWN: goog.getCssName('shown')
};
