// Copyright 2014 The ChromeOS IME Authors. All Rights Reserved.
// limitations under the License.
// See the License for the specific language governing permissions and
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// distributed under the License is distributed on an "AS-IS" BASIS,
// Unless required by applicable law or agreed to in writing, software
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// You may obtain a copy of the License at
// you may not use this file except in compliance with the License.
// Licensed under the Apache License, Version 2.0 (the "License");
//
goog.provide('i18n.input.chrome.inputview.elements.ElementType');


/**
 * The element type.
 *
 * @enum {number}
 */
i18n.input.chrome.inputview.elements.ElementType = {
  CHARACTER: 0,
  FUNCTIONAL_KEY: 1,
  KEYBOARD: 2,
  LAYOUT_VIEW: 3,
  LINEAR_LAYOUT: 4,
  MODIFIER_KEY: 5,
  CHARACTER_KEY: 6,
  SOFT_KEY: 7,
  SOFT_KEY_VIEW: 8,
  VERTICAL_LAYOUT: 9,
  CANDIDATE_VIEW: 10,
  SPACE_KEY: 11,
  ENTER_KEY: 12,
  BACKSPACE_KEY: 13,
  TAB_KEY: 14,
  ARROW_UP: 15,
  ARROW_DOWN: 16,
  ARROW_LEFT: 17,
  ARROW_RIGHT: 18,
  HIDE_KEYBOARD_KEY: 19,
  ALTDATA_VIEW: 20,
  SWITCHER_KEY: 21,
  COMPACT_KEY: 22,
  CANVAS_VIEW: 23,
  HANDWRITING_LAYOUT: 24,
  MENU_VIEW: 25,
  MENU_KEY: 26,
  GLOBE_KEY: 27,
  BACK_BUTTON: 28,
  SHRINK_CANDIDATES: 29,
  EXPAND_CANDIDATES: 30,
  CANDIDATES_PAGE_UP: 31,
  CANDIDATES_PAGE_DOWN: 32,
  CANDIDATE: 33,
  EXPANDED_CANDIDATE_VIEW: 34,
  IME_SWITCH: 35,
  HWT_PRIVACY_GOT_IT: 36,
  MENU_ITEM: 37,
  EMOJI_KEY: 38,
  TAB_BAR_KEY: 39,
  EXTENDED_LAYOUT: 40,
  PAGE_INDICATOR: 41,
  EN_SWITCHER: 42
};

