/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by j/c/g/ipc/invalidation/common/proto_wrapper_generator
package com.google.ipc.invalidation.ticl.proto;

import com.google.ipc.invalidation.util.Bytes;
import com.google.ipc.invalidation.util.ProtoWrapper;
import com.google.ipc.invalidation.util.ProtoWrapper.ValidationException;
import com.google.ipc.invalidation.util.TextBuilder;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


public interface JavaClient {

  public static final class BatcherState extends ProtoWrapper {
    public static BatcherState create(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registration,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistration,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP> acknowledgement,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree> registrationSubtree,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.InitializeMessage initializeMessage,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage infoMessage) {
      return new BatcherState(registration, unregistration, acknowledgement, registrationSubtree, initializeMessage, infoMessage);
    }

    public static final BatcherState DEFAULT_INSTANCE = new BatcherState(null, null, null, null, null, null);

    private final long __hazzerBits;
    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registration;
    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistration;
    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP> acknowledgement;
    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree> registrationSubtree;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.InitializeMessage initializeMessage;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage infoMessage;

    private BatcherState(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registration,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistration,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP> acknowledgement,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree> registrationSubtree,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.InitializeMessage initializeMessage,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage infoMessage) {
      int hazzerBits = 0;
      this.registration = optional("registration", registration);
      this.unregistration = optional("unregistration", unregistration);
      this.acknowledgement = optional("acknowledgement", acknowledgement);
      this.registrationSubtree = optional("registration_subtree", registrationSubtree);
      this.initializeMessage = initializeMessage;
      if (infoMessage != null) {
        hazzerBits |= 0x1;
        this.infoMessage = infoMessage;
      } else {
        this.infoMessage = com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage.DEFAULT_INSTANCE;
      }
      this.__hazzerBits = hazzerBits;
    }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> getRegistration() { return registration; }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> getUnregistration() { return unregistration; }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP> getAcknowledgement() { return acknowledgement; }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree> getRegistrationSubtree() { return registrationSubtree; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.InitializeMessage getNullableInitializeMessage() { return initializeMessage; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage getInfoMessage() { return infoMessage; }
    public boolean hasInfoMessage() { return (0x1 & __hazzerBits) != 0; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof BatcherState)) { return false; }
      BatcherState other = (BatcherState) obj;
      return __hazzerBits == other.__hazzerBits
          && equals(registration, other.registration)
          && equals(unregistration, other.unregistration)
          && equals(acknowledgement, other.acknowledgement)
          && equals(registrationSubtree, other.registrationSubtree)
          && equals(initializeMessage, other.initializeMessage)
          && (!hasInfoMessage() || equals(infoMessage, other.infoMessage));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      result = result * 31 + registration.hashCode();
      result = result * 31 + unregistration.hashCode();
      result = result * 31 + acknowledgement.hashCode();
      result = result * 31 + registrationSubtree.hashCode();
      if (initializeMessage != null) {
        result = result * 31 + initializeMessage.hashCode();
      }
      if (hasInfoMessage()) {
        result = result * 31 + infoMessage.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<BatcherState:");
      builder.append(" registration=[").append(registration).append(']');
      builder.append(" unregistration=[").append(unregistration).append(']');
      builder.append(" acknowledgement=[").append(acknowledgement).append(']');
      builder.append(" registration_subtree=[").append(registrationSubtree).append(']');
      if (initializeMessage != null) {
        builder.append(" initialize_message=").append(initializeMessage);
      }
      if (hasInfoMessage()) {
        builder.append(" info_message=").append(infoMessage);
      }
      builder.append('>');
    }

    public static BatcherState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.BatcherState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static BatcherState fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.BatcherState message) {
      if (message == null) { return null; }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registration = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP>(message.registration.length);
      for (int i = 0; i < message.registration.length; i++) {
        registration.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.registration[i]));
      }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistration = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP>(message.unregistration.length);
      for (int i = 0; i < message.unregistration.length; i++) {
        unregistration.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.unregistration[i]));
      }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP> acknowledgement = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP>(message.acknowledgement.length);
      for (int i = 0; i < message.acknowledgement.length; i++) {
        acknowledgement.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP.fromMessageNano(message.acknowledgement[i]));
      }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree> registrationSubtree = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree>(message.registrationSubtree.length);
      for (int i = 0; i < message.registrationSubtree.length; i++) {
        registrationSubtree.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSubtree.fromMessageNano(message.registrationSubtree[i]));
      }
      return new BatcherState(registration,
          unregistration,
          acknowledgement,
          registrationSubtree,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.InitializeMessage.fromMessageNano(message.initializeMessage),
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.InfoMessage.fromMessageNano(message.infoMessage));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.BatcherState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.BatcherState msg = new com.google.protos.ipc.invalidation.NanoJavaClient.BatcherState();
      msg.registration = new com.google.protos.ipc.invalidation.NanoClientProtocol.ObjectIdP[registration.size()];
      for (int i = 0; i < msg.registration.length; i++) {
        msg.registration[i] = registration.get(i).toMessageNano();
      }
      msg.unregistration = new com.google.protos.ipc.invalidation.NanoClientProtocol.ObjectIdP[unregistration.size()];
      for (int i = 0; i < msg.unregistration.length; i++) {
        msg.unregistration[i] = unregistration.get(i).toMessageNano();
      }
      msg.acknowledgement = new com.google.protos.ipc.invalidation.NanoClientProtocol.InvalidationP[acknowledgement.size()];
      for (int i = 0; i < msg.acknowledgement.length; i++) {
        msg.acknowledgement[i] = acknowledgement.get(i).toMessageNano();
      }
      msg.registrationSubtree = new com.google.protos.ipc.invalidation.NanoClientProtocol.RegistrationSubtree[registrationSubtree.size()];
      for (int i = 0; i < msg.registrationSubtree.length; i++) {
        msg.registrationSubtree[i] = registrationSubtree.get(i).toMessageNano();
      }
      msg.initializeMessage = this.initializeMessage != null ? initializeMessage.toMessageNano() : null;
      msg.infoMessage = hasInfoMessage() ? infoMessage.toMessageNano() : null;
      return msg;
    }
  }

  public static final class ProtocolHandlerState extends ProtoWrapper {
    public static ProtocolHandlerState create(Integer messageId,
        Long lastKnownServerTimeMs,
        Long nextMessageSendTimeMs,
        com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState batcherState) {
      return new ProtocolHandlerState(messageId, lastKnownServerTimeMs, nextMessageSendTimeMs, batcherState);
    }

    public static final ProtocolHandlerState DEFAULT_INSTANCE = new ProtocolHandlerState(null, null, null, null);

    private final long __hazzerBits;
    private final int messageId;
    private final long lastKnownServerTimeMs;
    private final long nextMessageSendTimeMs;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState batcherState;

    private ProtocolHandlerState(Integer messageId,
        Long lastKnownServerTimeMs,
        Long nextMessageSendTimeMs,
        com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState batcherState) {
      int hazzerBits = 0;
      if (messageId != null) {
        hazzerBits |= 0x1;
        this.messageId = messageId;
      } else {
        this.messageId = 0;
      }
      if (lastKnownServerTimeMs != null) {
        hazzerBits |= 0x2;
        this.lastKnownServerTimeMs = lastKnownServerTimeMs;
      } else {
        this.lastKnownServerTimeMs = 0;
      }
      if (nextMessageSendTimeMs != null) {
        hazzerBits |= 0x4;
        this.nextMessageSendTimeMs = nextMessageSendTimeMs;
      } else {
        this.nextMessageSendTimeMs = 0;
      }
      if (batcherState != null) {
        hazzerBits |= 0x8;
        this.batcherState = batcherState;
      } else {
        this.batcherState = com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState.DEFAULT_INSTANCE;
      }
      this.__hazzerBits = hazzerBits;
    }

    public int getMessageId() { return messageId; }
    public boolean hasMessageId() { return (0x1 & __hazzerBits) != 0; }

    public long getLastKnownServerTimeMs() { return lastKnownServerTimeMs; }
    public boolean hasLastKnownServerTimeMs() { return (0x2 & __hazzerBits) != 0; }

    public long getNextMessageSendTimeMs() { return nextMessageSendTimeMs; }
    public boolean hasNextMessageSendTimeMs() { return (0x4 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState getBatcherState() { return batcherState; }
    public boolean hasBatcherState() { return (0x8 & __hazzerBits) != 0; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof ProtocolHandlerState)) { return false; }
      ProtocolHandlerState other = (ProtocolHandlerState) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasMessageId() || messageId == other.messageId)
          && (!hasLastKnownServerTimeMs() || lastKnownServerTimeMs == other.lastKnownServerTimeMs)
          && (!hasNextMessageSendTimeMs() || nextMessageSendTimeMs == other.nextMessageSendTimeMs)
          && (!hasBatcherState() || equals(batcherState, other.batcherState));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasMessageId()) {
        result = result * 31 + hash(messageId);
      }
      if (hasLastKnownServerTimeMs()) {
        result = result * 31 + hash(lastKnownServerTimeMs);
      }
      if (hasNextMessageSendTimeMs()) {
        result = result * 31 + hash(nextMessageSendTimeMs);
      }
      if (hasBatcherState()) {
        result = result * 31 + batcherState.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<ProtocolHandlerState:");
      if (hasMessageId()) {
        builder.append(" message_id=").append(messageId);
      }
      if (hasLastKnownServerTimeMs()) {
        builder.append(" last_known_server_time_ms=").append(lastKnownServerTimeMs);
      }
      if (hasNextMessageSendTimeMs()) {
        builder.append(" next_message_send_time_ms=").append(nextMessageSendTimeMs);
      }
      if (hasBatcherState()) {
        builder.append(" batcher_state=").append(batcherState);
      }
      builder.append('>');
    }

    public static ProtocolHandlerState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.ProtocolHandlerState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static ProtocolHandlerState fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.ProtocolHandlerState message) {
      if (message == null) { return null; }
      return new ProtocolHandlerState(message.messageId,
          message.lastKnownServerTimeMs,
          message.nextMessageSendTimeMs,
          com.google.ipc.invalidation.ticl.proto.JavaClient.BatcherState.fromMessageNano(message.batcherState));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.ProtocolHandlerState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.ProtocolHandlerState msg = new com.google.protos.ipc.invalidation.NanoJavaClient.ProtocolHandlerState();
      msg.messageId = hasMessageId() ? messageId : null;
      msg.lastKnownServerTimeMs = hasLastKnownServerTimeMs() ? lastKnownServerTimeMs : null;
      msg.nextMessageSendTimeMs = hasNextMessageSendTimeMs() ? nextMessageSendTimeMs : null;
      msg.batcherState = hasBatcherState() ? batcherState.toMessageNano() : null;
      return msg;
    }
  }

  public static final class RegistrationManagerStateP extends ProtoWrapper {
    public static RegistrationManagerStateP create(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSummary lastKnownServerSummary,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP> pendingOperations) {
      return new RegistrationManagerStateP(registrations, lastKnownServerSummary, pendingOperations);
    }

    public static final RegistrationManagerStateP DEFAULT_INSTANCE = new RegistrationManagerStateP(null, null, null);

    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSummary lastKnownServerSummary;
    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP> pendingOperations;

    private RegistrationManagerStateP(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSummary lastKnownServerSummary,
        Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP> pendingOperations) {
      this.registrations = optional("registrations", registrations);
      this.lastKnownServerSummary = lastKnownServerSummary;
      this.pendingOperations = optional("pending_operations", pendingOperations);
    }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> getRegistrations() { return registrations; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSummary getNullableLastKnownServerSummary() { return lastKnownServerSummary; }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP> getPendingOperations() { return pendingOperations; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof RegistrationManagerStateP)) { return false; }
      RegistrationManagerStateP other = (RegistrationManagerStateP) obj;
      return equals(registrations, other.registrations)
          && equals(lastKnownServerSummary, other.lastKnownServerSummary)
          && equals(pendingOperations, other.pendingOperations);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + registrations.hashCode();
      if (lastKnownServerSummary != null) {
        result = result * 31 + lastKnownServerSummary.hashCode();
      }
      result = result * 31 + pendingOperations.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<RegistrationManagerStateP:");
      builder.append(" registrations=[").append(registrations).append(']');
      if (lastKnownServerSummary != null) {
        builder.append(" last_known_server_summary=").append(lastKnownServerSummary);
      }
      builder.append(" pending_operations=[").append(pendingOperations).append(']');
      builder.append('>');
    }

    public static RegistrationManagerStateP parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.RegistrationManagerStateP(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static RegistrationManagerStateP fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.RegistrationManagerStateP message) {
      if (message == null) { return null; }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP>(message.registrations.length);
      for (int i = 0; i < message.registrations.length; i++) {
        registrations.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.registrations[i]));
      }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP> pendingOperations = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP>(message.pendingOperations.length);
      for (int i = 0; i < message.pendingOperations.length; i++) {
        pendingOperations.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationP.fromMessageNano(message.pendingOperations[i]));
      }
      return new RegistrationManagerStateP(registrations,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.RegistrationSummary.fromMessageNano(message.lastKnownServerSummary),
          pendingOperations);
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.RegistrationManagerStateP toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.RegistrationManagerStateP msg = new com.google.protos.ipc.invalidation.NanoJavaClient.RegistrationManagerStateP();
      msg.registrations = new com.google.protos.ipc.invalidation.NanoClientProtocol.ObjectIdP[registrations.size()];
      for (int i = 0; i < msg.registrations.length; i++) {
        msg.registrations[i] = registrations.get(i).toMessageNano();
      }
      msg.lastKnownServerSummary = this.lastKnownServerSummary != null ? lastKnownServerSummary.toMessageNano() : null;
      msg.pendingOperations = new com.google.protos.ipc.invalidation.NanoClientProtocol.RegistrationP[pendingOperations.size()];
      for (int i = 0; i < msg.pendingOperations.length; i++) {
        msg.pendingOperations[i] = pendingOperations.get(i).toMessageNano();
      }
      return msg;
    }
  }

  public static final class RecurringTaskState extends ProtoWrapper {
    public static RecurringTaskState create(Integer initialDelayMs,
        Integer timeoutDelayMs,
        Boolean scheduled,
        com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState backoffState) {
      return new RecurringTaskState(initialDelayMs, timeoutDelayMs, scheduled, backoffState);
    }

    public static final RecurringTaskState DEFAULT_INSTANCE = new RecurringTaskState(null, null, null, null);

    private final long __hazzerBits;
    private final int initialDelayMs;
    private final int timeoutDelayMs;
    private final boolean scheduled;
    private final com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState backoffState;

    private RecurringTaskState(Integer initialDelayMs,
        Integer timeoutDelayMs,
        Boolean scheduled,
        com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState backoffState) {
      int hazzerBits = 0;
      if (initialDelayMs != null) {
        hazzerBits |= 0x1;
        this.initialDelayMs = initialDelayMs;
      } else {
        this.initialDelayMs = 0;
      }
      if (timeoutDelayMs != null) {
        hazzerBits |= 0x2;
        this.timeoutDelayMs = timeoutDelayMs;
      } else {
        this.timeoutDelayMs = 0;
      }
      if (scheduled != null) {
        hazzerBits |= 0x4;
        this.scheduled = scheduled;
      } else {
        this.scheduled = false;
      }
      if (backoffState != null) {
        hazzerBits |= 0x8;
        this.backoffState = backoffState;
      } else {
        this.backoffState = com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState.DEFAULT_INSTANCE;
      }
      this.__hazzerBits = hazzerBits;
    }

    public int getInitialDelayMs() { return initialDelayMs; }
    public boolean hasInitialDelayMs() { return (0x1 & __hazzerBits) != 0; }

    public int getTimeoutDelayMs() { return timeoutDelayMs; }
    public boolean hasTimeoutDelayMs() { return (0x2 & __hazzerBits) != 0; }

    public boolean getScheduled() { return scheduled; }
    public boolean hasScheduled() { return (0x4 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState getBackoffState() { return backoffState; }
    public boolean hasBackoffState() { return (0x8 & __hazzerBits) != 0; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof RecurringTaskState)) { return false; }
      RecurringTaskState other = (RecurringTaskState) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasInitialDelayMs() || initialDelayMs == other.initialDelayMs)
          && (!hasTimeoutDelayMs() || timeoutDelayMs == other.timeoutDelayMs)
          && (!hasScheduled() || scheduled == other.scheduled)
          && (!hasBackoffState() || equals(backoffState, other.backoffState));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasInitialDelayMs()) {
        result = result * 31 + hash(initialDelayMs);
      }
      if (hasTimeoutDelayMs()) {
        result = result * 31 + hash(timeoutDelayMs);
      }
      if (hasScheduled()) {
        result = result * 31 + hash(scheduled);
      }
      if (hasBackoffState()) {
        result = result * 31 + backoffState.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<RecurringTaskState:");
      if (hasInitialDelayMs()) {
        builder.append(" initial_delay_ms=").append(initialDelayMs);
      }
      if (hasTimeoutDelayMs()) {
        builder.append(" timeout_delay_ms=").append(timeoutDelayMs);
      }
      if (hasScheduled()) {
        builder.append(" scheduled=").append(scheduled);
      }
      if (hasBackoffState()) {
        builder.append(" backoff_state=").append(backoffState);
      }
      builder.append('>');
    }

    public static RecurringTaskState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.RecurringTaskState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static RecurringTaskState fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.RecurringTaskState message) {
      if (message == null) { return null; }
      return new RecurringTaskState(message.initialDelayMs,
          message.timeoutDelayMs,
          message.scheduled,
          com.google.ipc.invalidation.ticl.proto.Client.ExponentialBackoffState.fromMessageNano(message.backoffState));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.RecurringTaskState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.RecurringTaskState msg = new com.google.protos.ipc.invalidation.NanoJavaClient.RecurringTaskState();
      msg.initialDelayMs = hasInitialDelayMs() ? initialDelayMs : null;
      msg.timeoutDelayMs = hasTimeoutDelayMs() ? timeoutDelayMs : null;
      msg.scheduled = hasScheduled() ? scheduled : null;
      msg.backoffState = hasBackoffState() ? backoffState.toMessageNano() : null;
      return msg;
    }
  }

  public static final class StatisticsState extends ProtoWrapper {
    public static StatisticsState create(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord> counter) {
      return new StatisticsState(counter);
    }

    public static final StatisticsState DEFAULT_INSTANCE = new StatisticsState(null);

    private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord> counter;

    private StatisticsState(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord> counter) {
      this.counter = optional("counter", counter);
    }

    public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord> getCounter() { return counter; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof StatisticsState)) { return false; }
      StatisticsState other = (StatisticsState) obj;
      return equals(counter, other.counter);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + counter.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<StatisticsState:");
      builder.append(" counter=[").append(counter).append(']');
      builder.append('>');
    }

    public static StatisticsState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.StatisticsState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static StatisticsState fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.StatisticsState message) {
      if (message == null) { return null; }
      List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord> counter = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord>(message.counter.length);
      for (int i = 0; i < message.counter.length; i++) {
        counter.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.PropertyRecord.fromMessageNano(message.counter[i]));
      }
      return new StatisticsState(counter);
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.StatisticsState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.StatisticsState msg = new com.google.protos.ipc.invalidation.NanoJavaClient.StatisticsState();
      msg.counter = new com.google.protos.ipc.invalidation.NanoClientProtocol.PropertyRecord[counter.size()];
      for (int i = 0; i < msg.counter.length; i++) {
        msg.counter[i] = counter.get(i).toMessageNano();
      }
      return msg;
    }
  }

  public static final class InvalidationClientState extends ProtoWrapper {
    public static final class Builder {
      public com.google.ipc.invalidation.ticl.proto.Client.RunStateP runState;
      public Bytes clientToken;
      public Bytes nonce;
      public Boolean shouldSendRegistrations;
      public Long lastMessageSendTimeMs;
      public Boolean isOnline;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState protocolHandlerState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP registrationManagerState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState acquireTokenTaskState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState regSyncHeartbeatTaskState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState persistentWriteTaskState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState heartbeatTaskState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState batchingTaskState;
      public com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState lastWrittenState;
      public com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState statisticsState;
      public Builder() {
      }

      public InvalidationClientState build() {
        return new InvalidationClientState(runState, clientToken, nonce, shouldSendRegistrations, lastMessageSendTimeMs, isOnline, protocolHandlerState, registrationManagerState, acquireTokenTaskState, regSyncHeartbeatTaskState, persistentWriteTaskState, heartbeatTaskState, batchingTaskState, lastWrittenState, statisticsState);
      }
    }

    public static InvalidationClientState create(com.google.ipc.invalidation.ticl.proto.Client.RunStateP runState,
        Bytes clientToken,
        Bytes nonce,
        Boolean shouldSendRegistrations,
        Long lastMessageSendTimeMs,
        Boolean isOnline,
        com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState protocolHandlerState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP registrationManagerState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState acquireTokenTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState regSyncHeartbeatTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState persistentWriteTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState heartbeatTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState batchingTaskState,
        com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState lastWrittenState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState statisticsState) {
      return new InvalidationClientState(runState, clientToken, nonce, shouldSendRegistrations, lastMessageSendTimeMs, isOnline, protocolHandlerState, registrationManagerState, acquireTokenTaskState, regSyncHeartbeatTaskState, persistentWriteTaskState, heartbeatTaskState, batchingTaskState, lastWrittenState, statisticsState);
    }

    public static final InvalidationClientState DEFAULT_INSTANCE = new InvalidationClientState(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);

    private final long __hazzerBits;
    private final com.google.ipc.invalidation.ticl.proto.Client.RunStateP runState;
    private final Bytes clientToken;
    private final Bytes nonce;
    private final boolean shouldSendRegistrations;
    private final long lastMessageSendTimeMs;
    private final boolean isOnline;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState protocolHandlerState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP registrationManagerState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState acquireTokenTaskState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState regSyncHeartbeatTaskState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState persistentWriteTaskState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState heartbeatTaskState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState batchingTaskState;
    private final com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState lastWrittenState;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState statisticsState;

    private InvalidationClientState(com.google.ipc.invalidation.ticl.proto.Client.RunStateP runState,
        Bytes clientToken,
        Bytes nonce,
        Boolean shouldSendRegistrations,
        Long lastMessageSendTimeMs,
        Boolean isOnline,
        com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState protocolHandlerState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP registrationManagerState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState acquireTokenTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState regSyncHeartbeatTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState persistentWriteTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState heartbeatTaskState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState batchingTaskState,
        com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState lastWrittenState,
        com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState statisticsState) {
      int hazzerBits = 0;
      if (runState != null) {
        hazzerBits |= 0x1;
        this.runState = runState;
      } else {
        this.runState = com.google.ipc.invalidation.ticl.proto.Client.RunStateP.DEFAULT_INSTANCE;
      }
      if (clientToken != null) {
        hazzerBits |= 0x2;
        this.clientToken = clientToken;
      } else {
        this.clientToken = Bytes.EMPTY_BYTES;
      }
      if (nonce != null) {
        hazzerBits |= 0x4;
        this.nonce = nonce;
      } else {
        this.nonce = Bytes.EMPTY_BYTES;
      }
      if (shouldSendRegistrations != null) {
        hazzerBits |= 0x8;
        this.shouldSendRegistrations = shouldSendRegistrations;
      } else {
        this.shouldSendRegistrations = false;
      }
      if (lastMessageSendTimeMs != null) {
        hazzerBits |= 0x10;
        this.lastMessageSendTimeMs = lastMessageSendTimeMs;
      } else {
        this.lastMessageSendTimeMs = 0;
      }
      if (isOnline != null) {
        hazzerBits |= 0x20;
        this.isOnline = isOnline;
      } else {
        this.isOnline = false;
      }
      if (protocolHandlerState != null) {
        hazzerBits |= 0x40;
        this.protocolHandlerState = protocolHandlerState;
      } else {
        this.protocolHandlerState = com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState.DEFAULT_INSTANCE;
      }
      if (registrationManagerState != null) {
        hazzerBits |= 0x80;
        this.registrationManagerState = registrationManagerState;
      } else {
        this.registrationManagerState = com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP.DEFAULT_INSTANCE;
      }
      if (acquireTokenTaskState != null) {
        hazzerBits |= 0x100;
        this.acquireTokenTaskState = acquireTokenTaskState;
      } else {
        this.acquireTokenTaskState = com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.DEFAULT_INSTANCE;
      }
      if (regSyncHeartbeatTaskState != null) {
        hazzerBits |= 0x200;
        this.regSyncHeartbeatTaskState = regSyncHeartbeatTaskState;
      } else {
        this.regSyncHeartbeatTaskState = com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.DEFAULT_INSTANCE;
      }
      if (persistentWriteTaskState != null) {
        hazzerBits |= 0x400;
        this.persistentWriteTaskState = persistentWriteTaskState;
      } else {
        this.persistentWriteTaskState = com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.DEFAULT_INSTANCE;
      }
      if (heartbeatTaskState != null) {
        hazzerBits |= 0x800;
        this.heartbeatTaskState = heartbeatTaskState;
      } else {
        this.heartbeatTaskState = com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.DEFAULT_INSTANCE;
      }
      if (batchingTaskState != null) {
        hazzerBits |= 0x1000;
        this.batchingTaskState = batchingTaskState;
      } else {
        this.batchingTaskState = com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.DEFAULT_INSTANCE;
      }
      if (lastWrittenState != null) {
        hazzerBits |= 0x2000;
        this.lastWrittenState = lastWrittenState;
      } else {
        this.lastWrittenState = com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState.DEFAULT_INSTANCE;
      }
      if (statisticsState != null) {
        hazzerBits |= 0x4000;
        this.statisticsState = statisticsState;
      } else {
        this.statisticsState = com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState.DEFAULT_INSTANCE;
      }
      this.__hazzerBits = hazzerBits;
    }

    public com.google.ipc.invalidation.ticl.proto.Client.RunStateP getRunState() { return runState; }
    public boolean hasRunState() { return (0x1 & __hazzerBits) != 0; }

    public Bytes getClientToken() { return clientToken; }
    public boolean hasClientToken() { return (0x2 & __hazzerBits) != 0; }

    public Bytes getNonce() { return nonce; }
    public boolean hasNonce() { return (0x4 & __hazzerBits) != 0; }

    public boolean getShouldSendRegistrations() { return shouldSendRegistrations; }
    public boolean hasShouldSendRegistrations() { return (0x8 & __hazzerBits) != 0; }

    public long getLastMessageSendTimeMs() { return lastMessageSendTimeMs; }
    public boolean hasLastMessageSendTimeMs() { return (0x10 & __hazzerBits) != 0; }

    public boolean getIsOnline() { return isOnline; }
    public boolean hasIsOnline() { return (0x20 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState getProtocolHandlerState() { return protocolHandlerState; }
    public boolean hasProtocolHandlerState() { return (0x40 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP getRegistrationManagerState() { return registrationManagerState; }
    public boolean hasRegistrationManagerState() { return (0x80 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState getAcquireTokenTaskState() { return acquireTokenTaskState; }
    public boolean hasAcquireTokenTaskState() { return (0x100 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState getRegSyncHeartbeatTaskState() { return regSyncHeartbeatTaskState; }
    public boolean hasRegSyncHeartbeatTaskState() { return (0x200 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState getPersistentWriteTaskState() { return persistentWriteTaskState; }
    public boolean hasPersistentWriteTaskState() { return (0x400 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState getHeartbeatTaskState() { return heartbeatTaskState; }
    public boolean hasHeartbeatTaskState() { return (0x800 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState getBatchingTaskState() { return batchingTaskState; }
    public boolean hasBatchingTaskState() { return (0x1000 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState getLastWrittenState() { return lastWrittenState; }
    public boolean hasLastWrittenState() { return (0x2000 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState getStatisticsState() { return statisticsState; }
    public boolean hasStatisticsState() { return (0x4000 & __hazzerBits) != 0; }

    public Builder toBuilder() {
      Builder builder = new Builder();
      if (hasRunState()) {
        builder.runState = runState;
      }
      if (hasClientToken()) {
        builder.clientToken = clientToken;
      }
      if (hasNonce()) {
        builder.nonce = nonce;
      }
      if (hasShouldSendRegistrations()) {
        builder.shouldSendRegistrations = shouldSendRegistrations;
      }
      if (hasLastMessageSendTimeMs()) {
        builder.lastMessageSendTimeMs = lastMessageSendTimeMs;
      }
      if (hasIsOnline()) {
        builder.isOnline = isOnline;
      }
      if (hasProtocolHandlerState()) {
        builder.protocolHandlerState = protocolHandlerState;
      }
      if (hasRegistrationManagerState()) {
        builder.registrationManagerState = registrationManagerState;
      }
      if (hasAcquireTokenTaskState()) {
        builder.acquireTokenTaskState = acquireTokenTaskState;
      }
      if (hasRegSyncHeartbeatTaskState()) {
        builder.regSyncHeartbeatTaskState = regSyncHeartbeatTaskState;
      }
      if (hasPersistentWriteTaskState()) {
        builder.persistentWriteTaskState = persistentWriteTaskState;
      }
      if (hasHeartbeatTaskState()) {
        builder.heartbeatTaskState = heartbeatTaskState;
      }
      if (hasBatchingTaskState()) {
        builder.batchingTaskState = batchingTaskState;
      }
      if (hasLastWrittenState()) {
        builder.lastWrittenState = lastWrittenState;
      }
      if (hasStatisticsState()) {
        builder.statisticsState = statisticsState;
      }
      return builder;
    }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof InvalidationClientState)) { return false; }
      InvalidationClientState other = (InvalidationClientState) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasRunState() || equals(runState, other.runState))
          && (!hasClientToken() || equals(clientToken, other.clientToken))
          && (!hasNonce() || equals(nonce, other.nonce))
          && (!hasShouldSendRegistrations() || shouldSendRegistrations == other.shouldSendRegistrations)
          && (!hasLastMessageSendTimeMs() || lastMessageSendTimeMs == other.lastMessageSendTimeMs)
          && (!hasIsOnline() || isOnline == other.isOnline)
          && (!hasProtocolHandlerState() || equals(protocolHandlerState, other.protocolHandlerState))
          && (!hasRegistrationManagerState() || equals(registrationManagerState, other.registrationManagerState))
          && (!hasAcquireTokenTaskState() || equals(acquireTokenTaskState, other.acquireTokenTaskState))
          && (!hasRegSyncHeartbeatTaskState() || equals(regSyncHeartbeatTaskState, other.regSyncHeartbeatTaskState))
          && (!hasPersistentWriteTaskState() || equals(persistentWriteTaskState, other.persistentWriteTaskState))
          && (!hasHeartbeatTaskState() || equals(heartbeatTaskState, other.heartbeatTaskState))
          && (!hasBatchingTaskState() || equals(batchingTaskState, other.batchingTaskState))
          && (!hasLastWrittenState() || equals(lastWrittenState, other.lastWrittenState))
          && (!hasStatisticsState() || equals(statisticsState, other.statisticsState));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasRunState()) {
        result = result * 31 + runState.hashCode();
      }
      if (hasClientToken()) {
        result = result * 31 + clientToken.hashCode();
      }
      if (hasNonce()) {
        result = result * 31 + nonce.hashCode();
      }
      if (hasShouldSendRegistrations()) {
        result = result * 31 + hash(shouldSendRegistrations);
      }
      if (hasLastMessageSendTimeMs()) {
        result = result * 31 + hash(lastMessageSendTimeMs);
      }
      if (hasIsOnline()) {
        result = result * 31 + hash(isOnline);
      }
      if (hasProtocolHandlerState()) {
        result = result * 31 + protocolHandlerState.hashCode();
      }
      if (hasRegistrationManagerState()) {
        result = result * 31 + registrationManagerState.hashCode();
      }
      if (hasAcquireTokenTaskState()) {
        result = result * 31 + acquireTokenTaskState.hashCode();
      }
      if (hasRegSyncHeartbeatTaskState()) {
        result = result * 31 + regSyncHeartbeatTaskState.hashCode();
      }
      if (hasPersistentWriteTaskState()) {
        result = result * 31 + persistentWriteTaskState.hashCode();
      }
      if (hasHeartbeatTaskState()) {
        result = result * 31 + heartbeatTaskState.hashCode();
      }
      if (hasBatchingTaskState()) {
        result = result * 31 + batchingTaskState.hashCode();
      }
      if (hasLastWrittenState()) {
        result = result * 31 + lastWrittenState.hashCode();
      }
      if (hasStatisticsState()) {
        result = result * 31 + statisticsState.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<InvalidationClientState:");
      if (hasRunState()) {
        builder.append(" run_state=").append(runState);
      }
      if (hasClientToken()) {
        builder.append(" client_token=").append(clientToken);
      }
      if (hasNonce()) {
        builder.append(" nonce=").append(nonce);
      }
      if (hasShouldSendRegistrations()) {
        builder.append(" should_send_registrations=").append(shouldSendRegistrations);
      }
      if (hasLastMessageSendTimeMs()) {
        builder.append(" last_message_send_time_ms=").append(lastMessageSendTimeMs);
      }
      if (hasIsOnline()) {
        builder.append(" is_online=").append(isOnline);
      }
      if (hasProtocolHandlerState()) {
        builder.append(" protocol_handler_state=").append(protocolHandlerState);
      }
      if (hasRegistrationManagerState()) {
        builder.append(" registration_manager_state=").append(registrationManagerState);
      }
      if (hasAcquireTokenTaskState()) {
        builder.append(" acquire_token_task_state=").append(acquireTokenTaskState);
      }
      if (hasRegSyncHeartbeatTaskState()) {
        builder.append(" reg_sync_heartbeat_task_state=").append(regSyncHeartbeatTaskState);
      }
      if (hasPersistentWriteTaskState()) {
        builder.append(" persistent_write_task_state=").append(persistentWriteTaskState);
      }
      if (hasHeartbeatTaskState()) {
        builder.append(" heartbeat_task_state=").append(heartbeatTaskState);
      }
      if (hasBatchingTaskState()) {
        builder.append(" batching_task_state=").append(batchingTaskState);
      }
      if (hasLastWrittenState()) {
        builder.append(" last_written_state=").append(lastWrittenState);
      }
      if (hasStatisticsState()) {
        builder.append(" statistics_state=").append(statisticsState);
      }
      builder.append('>');
    }

    public static InvalidationClientState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoJavaClient.InvalidationClientState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static InvalidationClientState fromMessageNano(com.google.protos.ipc.invalidation.NanoJavaClient.InvalidationClientState message) {
      if (message == null) { return null; }
      return new InvalidationClientState(com.google.ipc.invalidation.ticl.proto.Client.RunStateP.fromMessageNano(message.runState),
          Bytes.fromByteArray(message.clientToken),
          Bytes.fromByteArray(message.nonce),
          message.shouldSendRegistrations,
          message.lastMessageSendTimeMs,
          message.isOnline,
          com.google.ipc.invalidation.ticl.proto.JavaClient.ProtocolHandlerState.fromMessageNano(message.protocolHandlerState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RegistrationManagerStateP.fromMessageNano(message.registrationManagerState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.fromMessageNano(message.acquireTokenTaskState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.fromMessageNano(message.regSyncHeartbeatTaskState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.fromMessageNano(message.persistentWriteTaskState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.fromMessageNano(message.heartbeatTaskState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.RecurringTaskState.fromMessageNano(message.batchingTaskState),
          com.google.ipc.invalidation.ticl.proto.Client.PersistentTiclState.fromMessageNano(message.lastWrittenState),
          com.google.ipc.invalidation.ticl.proto.JavaClient.StatisticsState.fromMessageNano(message.statisticsState));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoJavaClient.InvalidationClientState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoJavaClient.InvalidationClientState msg = new com.google.protos.ipc.invalidation.NanoJavaClient.InvalidationClientState();
      msg.runState = hasRunState() ? runState.toMessageNano() : null;
      msg.clientToken = hasClientToken() ? clientToken.getByteArray() : null;
      msg.nonce = hasNonce() ? nonce.getByteArray() : null;
      msg.shouldSendRegistrations = hasShouldSendRegistrations() ? shouldSendRegistrations : null;
      msg.lastMessageSendTimeMs = hasLastMessageSendTimeMs() ? lastMessageSendTimeMs : null;
      msg.isOnline = hasIsOnline() ? isOnline : null;
      msg.protocolHandlerState = hasProtocolHandlerState() ? protocolHandlerState.toMessageNano() : null;
      msg.registrationManagerState = hasRegistrationManagerState() ? registrationManagerState.toMessageNano() : null;
      msg.acquireTokenTaskState = hasAcquireTokenTaskState() ? acquireTokenTaskState.toMessageNano() : null;
      msg.regSyncHeartbeatTaskState = hasRegSyncHeartbeatTaskState() ? regSyncHeartbeatTaskState.toMessageNano() : null;
      msg.persistentWriteTaskState = hasPersistentWriteTaskState() ? persistentWriteTaskState.toMessageNano() : null;
      msg.heartbeatTaskState = hasHeartbeatTaskState() ? heartbeatTaskState.toMessageNano() : null;
      msg.batchingTaskState = hasBatchingTaskState() ? batchingTaskState.toMessageNano() : null;
      msg.lastWrittenState = hasLastWrittenState() ? lastWrittenState.toMessageNano() : null;
      msg.statisticsState = hasStatisticsState() ? statisticsState.toMessageNano() : null;
      return msg;
    }
  }
}
