/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by j/c/g/ipc/invalidation/common/proto_wrapper_generator
package com.google.ipc.invalidation.ticl.proto;

import com.google.ipc.invalidation.util.Bytes;
import com.google.ipc.invalidation.util.ProtoWrapper;
import com.google.ipc.invalidation.util.ProtoWrapper.ValidationException;
import com.google.ipc.invalidation.util.TextBuilder;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


public interface AndroidService {

  public static final class ClientDowncall extends ProtoWrapper {
    public static final class StartDowncall extends ProtoWrapper {
      public static StartDowncall create() {
        return new StartDowncall();
      }

      public static final StartDowncall DEFAULT_INSTANCE = new StartDowncall();


      private StartDowncall() {
      }


      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof StartDowncall)) { return false; }
        StartDowncall other = (StartDowncall) obj;
        return true;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<StartDowncall:");
        builder.append('>');
      }

      public static StartDowncall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StartDowncall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static StartDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StartDowncall message) {
        if (message == null) { return null; }
        return new StartDowncall();
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StartDowncall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StartDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StartDowncall();
        return msg;
      }
    }
    public static final class StopDowncall extends ProtoWrapper {
      public static StopDowncall create() {
        return new StopDowncall();
      }

      public static final StopDowncall DEFAULT_INSTANCE = new StopDowncall();


      private StopDowncall() {
      }


      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof StopDowncall)) { return false; }
        StopDowncall other = (StopDowncall) obj;
        return true;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<StopDowncall:");
        builder.append('>');
      }

      public static StopDowncall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StopDowncall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static StopDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StopDowncall message) {
        if (message == null) { return null; }
        return new StopDowncall();
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StopDowncall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StopDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.StopDowncall();
        return msg;
      }
    }
    public static final class AckDowncall extends ProtoWrapper {
      public static AckDowncall create(Bytes ackHandle) {
        return new AckDowncall(ackHandle);
      }

      private final Bytes ackHandle;

      private AckDowncall(Bytes ackHandle) throws ValidationArgumentException {
        required("ack_handle", ackHandle);
        this.ackHandle = ackHandle;
      }

      public Bytes getAckHandle() { return ackHandle; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof AckDowncall)) { return false; }
        AckDowncall other = (AckDowncall) obj;
        return equals(ackHandle, other.ackHandle);
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + ackHandle.hashCode();
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<AckDowncall:");
        builder.append(" ack_handle=").append(ackHandle);
        builder.append('>');
      }

      public static AckDowncall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.AckDowncall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static AckDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.AckDowncall message) {
        if (message == null) { return null; }
        return new AckDowncall(Bytes.fromByteArray(message.ackHandle));
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.AckDowncall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.AckDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.AckDowncall();
        msg.ackHandle = ackHandle.getByteArray();
        return msg;
      }
    }
    public static final class RegistrationDowncall extends ProtoWrapper {
      public static RegistrationDowncall createWithRegistrations(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations) {
        return new RegistrationDowncall(registrations, null);
      }

      public static RegistrationDowncall createWithUnregistrations(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistrations) {
        return new RegistrationDowncall(null, unregistrations);
      }

      private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations;
      private final List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistrations;

      private RegistrationDowncall(Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations,
          Collection<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistrations) throws ValidationArgumentException {
        this.registrations = optional("registrations", registrations);
        this.unregistrations = optional("unregistrations", unregistrations);
        String existingOneOfField = null;
        if (!this.registrations.isEmpty()) {
          existingOneOfField = "registrations";
        }
        if (!this.unregistrations.isEmpty()) {
          if (existingOneOfField != null) {
            oneOfViolation(existingOneOfField, "unregistrations");
          }
          existingOneOfField = "unregistrations";
        }
        if (existingOneOfField == null) { oneOfViolation(); }
      }

      public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> getRegistrations() { return registrations; }

      public List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> getUnregistrations() { return unregistrations; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof RegistrationDowncall)) { return false; }
        RegistrationDowncall other = (RegistrationDowncall) obj;
        return equals(registrations, other.registrations)
            && equals(unregistrations, other.unregistrations);
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + registrations.hashCode();
        result = result * 31 + unregistrations.hashCode();
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<RegistrationDowncall:");
        builder.append(" registrations=[").append(registrations).append(']');
        builder.append(" unregistrations=[").append(unregistrations).append(']');
        builder.append('>');
      }

      public static RegistrationDowncall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.RegistrationDowncall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static RegistrationDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.RegistrationDowncall message) {
        if (message == null) { return null; }
        List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> registrations = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP>(message.registrations.length);
        for (int i = 0; i < message.registrations.length; i++) {
          registrations.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.registrations[i]));
        }
        List<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP> unregistrations = new ArrayList<com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP>(message.unregistrations.length);
        for (int i = 0; i < message.unregistrations.length; i++) {
          unregistrations.add(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.unregistrations[i]));
        }
        return new RegistrationDowncall(registrations,
            unregistrations);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.RegistrationDowncall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.RegistrationDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall.RegistrationDowncall();
        msg.registrations = new com.google.protos.ipc.invalidation.NanoClientProtocol.ObjectIdP[registrations.size()];
        for (int i = 0; i < msg.registrations.length; i++) {
          msg.registrations[i] = registrations.get(i).toMessageNano();
        }
        msg.unregistrations = new com.google.protos.ipc.invalidation.NanoClientProtocol.ObjectIdP[unregistrations.size()];
        for (int i = 0; i < msg.unregistrations.length; i++) {
          msg.unregistrations[i] = unregistrations.get(i).toMessageNano();
        }
        return msg;
      }
    }
    public static ClientDowncall createWithSerial(long serial,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version) {
      return new ClientDowncall(serial, version, null, null, null, null);
    }

    public static ClientDowncall createWithStart(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall start) {
      return new ClientDowncall(null, version, start, null, null, null);
    }

    public static ClientDowncall createWithStop(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall stop) {
      return new ClientDowncall(null, version, null, stop, null, null);
    }

    public static ClientDowncall createWithAck(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.AckDowncall ack) {
      return new ClientDowncall(null, version, null, null, ack, null);
    }

    public static ClientDowncall createWithRegistrations(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.RegistrationDowncall registrations) {
      return new ClientDowncall(null, version, null, null, null, registrations);
    }

    private final long __hazzerBits;
    private final long serial;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall start;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall stop;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.AckDowncall ack;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.RegistrationDowncall registrations;

    private ClientDowncall(Long serial,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall start,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall stop,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.AckDowncall ack,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.RegistrationDowncall registrations) throws ValidationArgumentException {
      int hazzerBits = 0;
      if (serial != null) {
        hazzerBits |= 0x1;
        this.serial = serial;
      } else {
        this.serial = 0;
      }
      required("version", version);
      this.version = version;
      if (start != null) {
        hazzerBits |= 0x2;
        this.start = start;
      } else {
        this.start = com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall.DEFAULT_INSTANCE;
      }
      if (stop != null) {
        hazzerBits |= 0x4;
        this.stop = stop;
      } else {
        this.stop = com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall.DEFAULT_INSTANCE;
      }
      this.ack = ack;
      this.registrations = registrations;
      this.__hazzerBits = hazzerBits;
      String existingOneOfField = null;
      if (hasStop()) {
        existingOneOfField = "stop";
      }
      if (hasStart()) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "start");
        }
        existingOneOfField = "start";
      }
      if (hasSerial()) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "serial");
        }
        existingOneOfField = "serial";
      }
      if (this.registrations != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "registrations");
        }
        existingOneOfField = "registrations";
      }
      if (this.ack != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "ack");
        }
        existingOneOfField = "ack";
      }
      if (existingOneOfField == null) { oneOfViolation(); }
    }

    public long getSerial() { return serial; }
    public boolean hasSerial() { return (0x1 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall getStart() { return start; }
    public boolean hasStart() { return (0x2 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall getStop() { return stop; }
    public boolean hasStop() { return (0x4 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.AckDowncall getNullableAck() { return ack; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.RegistrationDowncall getNullableRegistrations() { return registrations; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof ClientDowncall)) { return false; }
      ClientDowncall other = (ClientDowncall) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasSerial() || serial == other.serial)
          && equals(version, other.version)
          && (!hasStart() || equals(start, other.start))
          && (!hasStop() || equals(stop, other.stop))
          && equals(ack, other.ack)
          && equals(registrations, other.registrations);
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasSerial()) {
        result = result * 31 + hash(serial);
      }
      result = result * 31 + version.hashCode();
      if (hasStart()) {
        result = result * 31 + start.hashCode();
      }
      if (hasStop()) {
        result = result * 31 + stop.hashCode();
      }
      if (ack != null) {
        result = result * 31 + ack.hashCode();
      }
      if (registrations != null) {
        result = result * 31 + registrations.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<ClientDowncall:");
      if (hasSerial()) {
        builder.append(" serial=").append(serial);
      }
      builder.append(" version=").append(version);
      if (hasStart()) {
        builder.append(" start=").append(start);
      }
      if (hasStop()) {
        builder.append(" stop=").append(stop);
      }
      if (ack != null) {
        builder.append(" ack=").append(ack);
      }
      if (registrations != null) {
        builder.append(" registrations=").append(registrations);
      }
      builder.append('>');
    }

    public static ClientDowncall parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static ClientDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall message) {
      if (message == null) { return null; }
      return new ClientDowncall(message.serial,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StartDowncall.fromMessageNano(message.start),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.StopDowncall.fromMessageNano(message.stop),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.AckDowncall.fromMessageNano(message.ack),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ClientDowncall.RegistrationDowncall.fromMessageNano(message.registrations));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ClientDowncall();
      msg.serial = hasSerial() ? serial : null;
      msg.version = version.toMessageNano();
      msg.start = hasStart() ? start.toMessageNano() : null;
      msg.stop = hasStop() ? stop.toMessageNano() : null;
      msg.ack = this.ack != null ? ack.toMessageNano() : null;
      msg.registrations = this.registrations != null ? registrations.toMessageNano() : null;
      return msg;
    }
  }

  public static final class InternalDowncall extends ProtoWrapper {
    public static final class ServerMessage extends ProtoWrapper {
      public static ServerMessage create(Bytes data) {
        return new ServerMessage(data);
      }

      private final Bytes data;

      private ServerMessage(Bytes data) throws ValidationArgumentException {
        required("data", data);
        this.data = data;
      }

      public Bytes getData() { return data; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof ServerMessage)) { return false; }
        ServerMessage other = (ServerMessage) obj;
        return equals(data, other.data);
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + data.hashCode();
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<ServerMessage:");
        builder.append(" data=").append(data);
        builder.append('>');
      }

      public static ServerMessage parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.ServerMessage(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static ServerMessage fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.ServerMessage message) {
        if (message == null) { return null; }
        return new ServerMessage(Bytes.fromByteArray(message.data));
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.ServerMessage toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.ServerMessage msg = new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.ServerMessage();
        msg.data = data.getByteArray();
        return msg;
      }
    }
    public static final class NetworkStatus extends ProtoWrapper {
      public static NetworkStatus create(boolean isOnline) {
        return new NetworkStatus(isOnline);
      }

      private final boolean isOnline;

      private NetworkStatus(Boolean isOnline) throws ValidationArgumentException {
        required("is_online", isOnline);
        this.isOnline = isOnline;
      }

      public boolean getIsOnline() { return isOnline; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof NetworkStatus)) { return false; }
        NetworkStatus other = (NetworkStatus) obj;
        return isOnline == other.isOnline;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + hash(isOnline);
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<NetworkStatus:");
        builder.append(" is_online=").append(isOnline);
        builder.append('>');
      }

      public static NetworkStatus parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.NetworkStatus(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static NetworkStatus fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.NetworkStatus message) {
        if (message == null) { return null; }
        return new NetworkStatus(message.isOnline);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.NetworkStatus toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.NetworkStatus msg = new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.NetworkStatus();
        msg.isOnline = isOnline;
        return msg;
      }
    }
    public static final class CreateClient extends ProtoWrapper {
      public static CreateClient create(int clientType,
          Bytes clientName,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig,
          boolean skipStartForTest) {
        return new CreateClient(clientType, clientName, clientConfig, skipStartForTest);
      }

      private final int clientType;
      private final Bytes clientName;
      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig;
      private final boolean skipStartForTest;

      private CreateClient(Integer clientType,
          Bytes clientName,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig,
          Boolean skipStartForTest) throws ValidationArgumentException {
        required("client_type", clientType);
        this.clientType = clientType;
        required("client_name", clientName);
        this.clientName = clientName;
        required("client_config", clientConfig);
        this.clientConfig = clientConfig;
        required("skip_start_for_test", skipStartForTest);
        this.skipStartForTest = skipStartForTest;
      }

      public int getClientType() { return clientType; }

      public Bytes getClientName() { return clientName; }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP getClientConfig() { return clientConfig; }

      public boolean getSkipStartForTest() { return skipStartForTest; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof CreateClient)) { return false; }
        CreateClient other = (CreateClient) obj;
        return clientType == other.clientType
            && equals(clientName, other.clientName)
            && equals(clientConfig, other.clientConfig)
            && skipStartForTest == other.skipStartForTest;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + hash(clientType);
        result = result * 31 + clientName.hashCode();
        result = result * 31 + clientConfig.hashCode();
        result = result * 31 + hash(skipStartForTest);
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<CreateClient:");
        builder.append(" client_type=").append(clientType);
        builder.append(" client_name=").append(clientName);
        builder.append(" client_config=").append(clientConfig);
        builder.append(" skip_start_for_test=").append(skipStartForTest);
        builder.append('>');
      }

      public static CreateClient parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.CreateClient(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static CreateClient fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.CreateClient message) {
        if (message == null) { return null; }
        return new CreateClient(message.clientType,
            Bytes.fromByteArray(message.clientName),
            com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP.fromMessageNano(message.clientConfig),
            message.skipStartForTest);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.CreateClient toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.CreateClient msg = new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall.CreateClient();
        msg.clientType = clientType;
        msg.clientName = clientName.getByteArray();
        msg.clientConfig = clientConfig.toMessageNano();
        msg.skipStartForTest = skipStartForTest;
        return msg;
      }
    }
    public static InternalDowncall createWithServerMessage(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.ServerMessage serverMessage) {
      return new InternalDowncall(version, serverMessage, null, null, null);
    }

    public static InternalDowncall createWithNetworkStatus(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.NetworkStatus networkStatus) {
      return new InternalDowncall(version, null, networkStatus, null, null);
    }

    public static InternalDowncall createWithNetworkAddrChange(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        boolean networkAddrChange) {
      return new InternalDowncall(version, null, null, networkAddrChange, null);
    }

    public static InternalDowncall createWithCreateClient(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.CreateClient createClient) {
      return new InternalDowncall(version, null, null, null, createClient);
    }

    private final long __hazzerBits;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.ServerMessage serverMessage;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.NetworkStatus networkStatus;
    private final boolean networkAddrChange;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.CreateClient createClient;

    private InternalDowncall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.ServerMessage serverMessage,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.NetworkStatus networkStatus,
        Boolean networkAddrChange,
        com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.CreateClient createClient) throws ValidationArgumentException {
      int hazzerBits = 0;
      required("version", version);
      this.version = version;
      this.serverMessage = serverMessage;
      this.networkStatus = networkStatus;
      if (networkAddrChange != null) {
        hazzerBits |= 0x1;
        this.networkAddrChange = networkAddrChange;
      } else {
        this.networkAddrChange = false;
      }
      this.createClient = createClient;
      this.__hazzerBits = hazzerBits;
      String existingOneOfField = null;
      if (hasNetworkAddrChange()) {
        existingOneOfField = "network_addr_change";
      }
      if (this.networkStatus != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "network_status");
        }
        existingOneOfField = "network_status";
      }
      if (this.createClient != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "create_client");
        }
        existingOneOfField = "create_client";
      }
      if (this.serverMessage != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "server_message");
        }
        existingOneOfField = "server_message";
      }
      if (existingOneOfField == null) { oneOfViolation(); }
    }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.ServerMessage getNullableServerMessage() { return serverMessage; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.NetworkStatus getNullableNetworkStatus() { return networkStatus; }

    public boolean getNetworkAddrChange() { return networkAddrChange; }
    public boolean hasNetworkAddrChange() { return (0x1 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.CreateClient getNullableCreateClient() { return createClient; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof InternalDowncall)) { return false; }
      InternalDowncall other = (InternalDowncall) obj;
      return __hazzerBits == other.__hazzerBits
          && equals(version, other.version)
          && equals(serverMessage, other.serverMessage)
          && equals(networkStatus, other.networkStatus)
          && (!hasNetworkAddrChange() || networkAddrChange == other.networkAddrChange)
          && equals(createClient, other.createClient);
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      result = result * 31 + version.hashCode();
      if (serverMessage != null) {
        result = result * 31 + serverMessage.hashCode();
      }
      if (networkStatus != null) {
        result = result * 31 + networkStatus.hashCode();
      }
      if (hasNetworkAddrChange()) {
        result = result * 31 + hash(networkAddrChange);
      }
      if (createClient != null) {
        result = result * 31 + createClient.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<InternalDowncall:");
      builder.append(" version=").append(version);
      if (serverMessage != null) {
        builder.append(" server_message=").append(serverMessage);
      }
      if (networkStatus != null) {
        builder.append(" network_status=").append(networkStatus);
      }
      if (hasNetworkAddrChange()) {
        builder.append(" network_addr_change=").append(networkAddrChange);
      }
      if (createClient != null) {
        builder.append(" create_client=").append(createClient);
      }
      builder.append('>');
    }

    public static InternalDowncall parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static InternalDowncall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall message) {
      if (message == null) { return null; }
      return new InternalDowncall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.ServerMessage.fromMessageNano(message.serverMessage),
          com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.NetworkStatus.fromMessageNano(message.networkStatus),
          message.networkAddrChange,
          com.google.ipc.invalidation.ticl.proto.AndroidService.InternalDowncall.CreateClient.fromMessageNano(message.createClient));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.InternalDowncall();
      msg.version = version.toMessageNano();
      msg.serverMessage = this.serverMessage != null ? serverMessage.toMessageNano() : null;
      msg.networkStatus = this.networkStatus != null ? networkStatus.toMessageNano() : null;
      msg.networkAddrChange = hasNetworkAddrChange() ? networkAddrChange : null;
      msg.createClient = this.createClient != null ? createClient.toMessageNano() : null;
      return msg;
    }
  }

  public static final class ListenerUpcall extends ProtoWrapper {
    public static final class ReadyUpcall extends ProtoWrapper {
      public static ReadyUpcall create() {
        return new ReadyUpcall();
      }

      public static final ReadyUpcall DEFAULT_INSTANCE = new ReadyUpcall();


      private ReadyUpcall() {
      }


      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof ReadyUpcall)) { return false; }
        ReadyUpcall other = (ReadyUpcall) obj;
        return true;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<ReadyUpcall:");
        builder.append('>');
      }

      public static ReadyUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReadyUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static ReadyUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReadyUpcall message) {
        if (message == null) { return null; }
        return new ReadyUpcall();
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReadyUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReadyUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReadyUpcall();
        return msg;
      }
    }
    public static final class InvalidateUpcall extends ProtoWrapper {
      public static InvalidateUpcall createWithInvalidation(Bytes ackHandle,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP invalidation) {
        return new InvalidateUpcall(ackHandle, invalidation, null, null);
      }

      public static InvalidateUpcall createWithInvalidateUnknown(Bytes ackHandle,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP invalidateUnknown) {
        return new InvalidateUpcall(ackHandle, null, invalidateUnknown, null);
      }

      public static InvalidateUpcall createWithInvalidateAll(Bytes ackHandle,
          boolean invalidateAll) {
        return new InvalidateUpcall(ackHandle, null, null, invalidateAll);
      }

      private final long __hazzerBits;
      private final Bytes ackHandle;
      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP invalidation;
      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP invalidateUnknown;
      private final boolean invalidateAll;

      private InvalidateUpcall(Bytes ackHandle,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP invalidation,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP invalidateUnknown,
          Boolean invalidateAll) throws ValidationArgumentException {
        int hazzerBits = 0;
        required("ack_handle", ackHandle);
        this.ackHandle = ackHandle;
        this.invalidation = invalidation;
        this.invalidateUnknown = invalidateUnknown;
        if (invalidateAll != null) {
          hazzerBits |= 0x1;
          this.invalidateAll = invalidateAll;
        } else {
          this.invalidateAll = false;
        }
        this.__hazzerBits = hazzerBits;
        String existingOneOfField = null;
        if (this.invalidateUnknown != null) {
          existingOneOfField = "invalidate_unknown";
        }
        if (this.invalidation != null) {
          if (existingOneOfField != null) {
            oneOfViolation(existingOneOfField, "invalidation");
          }
          existingOneOfField = "invalidation";
        }
        if (hasInvalidateAll()) {
          if (existingOneOfField != null) {
            oneOfViolation(existingOneOfField, "invalidate_all");
          }
          existingOneOfField = "invalidate_all";
        }
        if (existingOneOfField == null) { oneOfViolation(); }
      }

      public Bytes getAckHandle() { return ackHandle; }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP getNullableInvalidation() { return invalidation; }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP getNullableInvalidateUnknown() { return invalidateUnknown; }

      public boolean getInvalidateAll() { return invalidateAll; }
      public boolean hasInvalidateAll() { return (0x1 & __hazzerBits) != 0; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof InvalidateUpcall)) { return false; }
        InvalidateUpcall other = (InvalidateUpcall) obj;
        return __hazzerBits == other.__hazzerBits
            && equals(ackHandle, other.ackHandle)
            && equals(invalidation, other.invalidation)
            && equals(invalidateUnknown, other.invalidateUnknown)
            && (!hasInvalidateAll() || invalidateAll == other.invalidateAll);
      }

      @Override protected int computeHashCode() {
        int result = hash(__hazzerBits);
        result = result * 31 + ackHandle.hashCode();
        if (invalidation != null) {
          result = result * 31 + invalidation.hashCode();
        }
        if (invalidateUnknown != null) {
          result = result * 31 + invalidateUnknown.hashCode();
        }
        if (hasInvalidateAll()) {
          result = result * 31 + hash(invalidateAll);
        }
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<InvalidateUpcall:");
        builder.append(" ack_handle=").append(ackHandle);
        if (invalidation != null) {
          builder.append(" invalidation=").append(invalidation);
        }
        if (invalidateUnknown != null) {
          builder.append(" invalidate_unknown=").append(invalidateUnknown);
        }
        if (hasInvalidateAll()) {
          builder.append(" invalidate_all=").append(invalidateAll);
        }
        builder.append('>');
      }

      public static InvalidateUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.InvalidateUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static InvalidateUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.InvalidateUpcall message) {
        if (message == null) { return null; }
        return new InvalidateUpcall(Bytes.fromByteArray(message.ackHandle),
            com.google.ipc.invalidation.ticl.proto.ClientProtocol.InvalidationP.fromMessageNano(message.invalidation),
            com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.invalidateUnknown),
            message.invalidateAll);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.InvalidateUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.InvalidateUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.InvalidateUpcall();
        msg.ackHandle = ackHandle.getByteArray();
        msg.invalidation = this.invalidation != null ? invalidation.toMessageNano() : null;
        msg.invalidateUnknown = this.invalidateUnknown != null ? invalidateUnknown.toMessageNano() : null;
        msg.invalidateAll = hasInvalidateAll() ? invalidateAll : null;
        return msg;
      }
    }
    public static final class RegistrationStatusUpcall extends ProtoWrapper {
      public static RegistrationStatusUpcall create(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId,
          boolean isRegistered) {
        return new RegistrationStatusUpcall(objectId, isRegistered);
      }

      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId;
      private final boolean isRegistered;

      private RegistrationStatusUpcall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId,
          Boolean isRegistered) throws ValidationArgumentException {
        required("object_id", objectId);
        this.objectId = objectId;
        required("is_registered", isRegistered);
        this.isRegistered = isRegistered;
      }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP getObjectId() { return objectId; }

      public boolean getIsRegistered() { return isRegistered; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof RegistrationStatusUpcall)) { return false; }
        RegistrationStatusUpcall other = (RegistrationStatusUpcall) obj;
        return equals(objectId, other.objectId)
            && isRegistered == other.isRegistered;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + objectId.hashCode();
        result = result * 31 + hash(isRegistered);
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<RegistrationStatusUpcall:");
        builder.append(" object_id=").append(objectId);
        builder.append(" is_registered=").append(isRegistered);
        builder.append('>');
      }

      public static RegistrationStatusUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationStatusUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static RegistrationStatusUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationStatusUpcall message) {
        if (message == null) { return null; }
        return new RegistrationStatusUpcall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.objectId),
            message.isRegistered);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationStatusUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationStatusUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationStatusUpcall();
        msg.objectId = objectId.toMessageNano();
        msg.isRegistered = isRegistered;
        return msg;
      }
    }
    public static final class RegistrationFailureUpcall extends ProtoWrapper {
      public static RegistrationFailureUpcall create(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId,
          boolean transient_,
          String message) {
        return new RegistrationFailureUpcall(objectId, transient_, message);
      }

      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId;
      private final boolean transient_;
      private final String message;

      private RegistrationFailureUpcall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP objectId,
          Boolean transient_,
          String message) throws ValidationArgumentException {
        required("object_id", objectId);
        this.objectId = objectId;
        required("transient", transient_);
        this.transient_ = transient_;
        required("message", message);
        this.message = message;
      }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP getObjectId() { return objectId; }

      public boolean getTransient() { return transient_; }

      public String getMessage() { return message; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof RegistrationFailureUpcall)) { return false; }
        RegistrationFailureUpcall other = (RegistrationFailureUpcall) obj;
        return equals(objectId, other.objectId)
            && transient_ == other.transient_
            && equals(message, other.message);
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + objectId.hashCode();
        result = result * 31 + hash(transient_);
        result = result * 31 + message.hashCode();
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<RegistrationFailureUpcall:");
        builder.append(" object_id=").append(objectId);
        builder.append(" transient=").append(transient_);
        builder.append(" message=").append(message);
        builder.append('>');
      }

      public static RegistrationFailureUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationFailureUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static RegistrationFailureUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationFailureUpcall message) {
        if (message == null) { return null; }
        return new RegistrationFailureUpcall(com.google.ipc.invalidation.ticl.proto.ClientProtocol.ObjectIdP.fromMessageNano(message.objectId),
            message.transient_,
            message.message);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationFailureUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationFailureUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.RegistrationFailureUpcall();
        msg.objectId = objectId.toMessageNano();
        msg.transient_ = transient_;
        msg.message = message;
        return msg;
      }
    }
    public static final class ReissueRegistrationsUpcall extends ProtoWrapper {
      public static ReissueRegistrationsUpcall create(Bytes prefix,
          int length) {
        return new ReissueRegistrationsUpcall(prefix, length);
      }

      private final Bytes prefix;
      private final int length;

      private ReissueRegistrationsUpcall(Bytes prefix,
          Integer length) throws ValidationArgumentException {
        required("prefix", prefix);
        this.prefix = prefix;
        required("length", length);
        this.length = length;
      }

      public Bytes getPrefix() { return prefix; }

      public int getLength() { return length; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof ReissueRegistrationsUpcall)) { return false; }
        ReissueRegistrationsUpcall other = (ReissueRegistrationsUpcall) obj;
        return equals(prefix, other.prefix)
            && length == other.length;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + prefix.hashCode();
        result = result * 31 + hash(length);
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<ReissueRegistrationsUpcall:");
        builder.append(" prefix=").append(prefix);
        builder.append(" length=").append(length);
        builder.append('>');
      }

      public static ReissueRegistrationsUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReissueRegistrationsUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static ReissueRegistrationsUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReissueRegistrationsUpcall message) {
        if (message == null) { return null; }
        return new ReissueRegistrationsUpcall(Bytes.fromByteArray(message.prefix),
            message.length);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReissueRegistrationsUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReissueRegistrationsUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ReissueRegistrationsUpcall();
        msg.prefix = prefix.getByteArray();
        msg.length = length;
        return msg;
      }
    }
    public static final class ErrorUpcall extends ProtoWrapper {
      public static ErrorUpcall create(int errorCode,
          String errorMessage,
          boolean isTransient) {
        return new ErrorUpcall(errorCode, errorMessage, isTransient);
      }

      private final int errorCode;
      private final String errorMessage;
      private final boolean isTransient;

      private ErrorUpcall(Integer errorCode,
          String errorMessage,
          Boolean isTransient) throws ValidationArgumentException {
        required("error_code", errorCode);
        this.errorCode = errorCode;
        required("error_message", errorMessage);
        this.errorMessage = errorMessage;
        required("is_transient", isTransient);
        this.isTransient = isTransient;
      }

      public int getErrorCode() { return errorCode; }

      public String getErrorMessage() { return errorMessage; }

      public boolean getIsTransient() { return isTransient; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof ErrorUpcall)) { return false; }
        ErrorUpcall other = (ErrorUpcall) obj;
        return errorCode == other.errorCode
            && equals(errorMessage, other.errorMessage)
            && isTransient == other.isTransient;
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + hash(errorCode);
        result = result * 31 + errorMessage.hashCode();
        result = result * 31 + hash(isTransient);
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<ErrorUpcall:");
        builder.append(" error_code=").append(errorCode);
        builder.append(" error_message=").append(errorMessage);
        builder.append(" is_transient=").append(isTransient);
        builder.append('>');
      }

      public static ErrorUpcall parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ErrorUpcall(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static ErrorUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ErrorUpcall message) {
        if (message == null) { return null; }
        return new ErrorUpcall(message.errorCode,
            message.errorMessage,
            message.isTransient);
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ErrorUpcall toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ErrorUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall.ErrorUpcall();
        msg.errorCode = errorCode;
        msg.errorMessage = errorMessage;
        msg.isTransient = isTransient;
        return msg;
      }
    }
    public static ListenerUpcall createWithSerial(long serial,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version) {
      return new ListenerUpcall(serial, version, null, null, null, null, null, null);
    }

    public static ListenerUpcall createWithReady(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall ready) {
      return new ListenerUpcall(null, version, ready, null, null, null, null, null);
    }

    public static ListenerUpcall createWithInvalidate(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.InvalidateUpcall invalidate) {
      return new ListenerUpcall(null, version, null, invalidate, null, null, null, null);
    }

    public static ListenerUpcall createWithRegistrationStatus(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationStatusUpcall registrationStatus) {
      return new ListenerUpcall(null, version, null, null, registrationStatus, null, null, null);
    }

    public static ListenerUpcall createWithRegistrationFailure(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationFailureUpcall registrationFailure) {
      return new ListenerUpcall(null, version, null, null, null, registrationFailure, null, null);
    }

    public static ListenerUpcall createWithReissueRegistrations(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReissueRegistrationsUpcall reissueRegistrations) {
      return new ListenerUpcall(null, version, null, null, null, null, reissueRegistrations, null);
    }

    public static ListenerUpcall createWithError(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ErrorUpcall error) {
      return new ListenerUpcall(null, version, null, null, null, null, null, error);
    }

    private final long __hazzerBits;
    private final long serial;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall ready;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.InvalidateUpcall invalidate;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationStatusUpcall registrationStatus;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationFailureUpcall registrationFailure;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReissueRegistrationsUpcall reissueRegistrations;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ErrorUpcall error;

    private ListenerUpcall(Long serial,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall ready,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.InvalidateUpcall invalidate,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationStatusUpcall registrationStatus,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationFailureUpcall registrationFailure,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReissueRegistrationsUpcall reissueRegistrations,
        com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ErrorUpcall error) throws ValidationArgumentException {
      int hazzerBits = 0;
      if (serial != null) {
        hazzerBits |= 0x1;
        this.serial = serial;
      } else {
        this.serial = 0;
      }
      required("version", version);
      this.version = version;
      if (ready != null) {
        hazzerBits |= 0x2;
        this.ready = ready;
      } else {
        this.ready = com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall.DEFAULT_INSTANCE;
      }
      this.invalidate = invalidate;
      this.registrationStatus = registrationStatus;
      this.registrationFailure = registrationFailure;
      this.reissueRegistrations = reissueRegistrations;
      this.error = error;
      this.__hazzerBits = hazzerBits;
      String existingOneOfField = null;
      if (this.reissueRegistrations != null) {
        existingOneOfField = "reissue_registrations";
      }
      if (hasSerial()) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "serial");
        }
        existingOneOfField = "serial";
      }
      if (this.registrationFailure != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "registration_failure");
        }
        existingOneOfField = "registration_failure";
      }
      if (hasReady()) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "ready");
        }
        existingOneOfField = "ready";
      }
      if (this.invalidate != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "invalidate");
        }
        existingOneOfField = "invalidate";
      }
      if (this.registrationStatus != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "registration_status");
        }
        existingOneOfField = "registration_status";
      }
      if (this.error != null) {
        if (existingOneOfField != null) {
          oneOfViolation(existingOneOfField, "error");
        }
        existingOneOfField = "error";
      }
      if (existingOneOfField == null) { oneOfViolation(); }
    }

    public long getSerial() { return serial; }
    public boolean hasSerial() { return (0x1 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall getReady() { return ready; }
    public boolean hasReady() { return (0x2 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.InvalidateUpcall getNullableInvalidate() { return invalidate; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationStatusUpcall getNullableRegistrationStatus() { return registrationStatus; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationFailureUpcall getNullableRegistrationFailure() { return registrationFailure; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReissueRegistrationsUpcall getNullableReissueRegistrations() { return reissueRegistrations; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ErrorUpcall getNullableError() { return error; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof ListenerUpcall)) { return false; }
      ListenerUpcall other = (ListenerUpcall) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasSerial() || serial == other.serial)
          && equals(version, other.version)
          && (!hasReady() || equals(ready, other.ready))
          && equals(invalidate, other.invalidate)
          && equals(registrationStatus, other.registrationStatus)
          && equals(registrationFailure, other.registrationFailure)
          && equals(reissueRegistrations, other.reissueRegistrations)
          && equals(error, other.error);
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasSerial()) {
        result = result * 31 + hash(serial);
      }
      result = result * 31 + version.hashCode();
      if (hasReady()) {
        result = result * 31 + ready.hashCode();
      }
      if (invalidate != null) {
        result = result * 31 + invalidate.hashCode();
      }
      if (registrationStatus != null) {
        result = result * 31 + registrationStatus.hashCode();
      }
      if (registrationFailure != null) {
        result = result * 31 + registrationFailure.hashCode();
      }
      if (reissueRegistrations != null) {
        result = result * 31 + reissueRegistrations.hashCode();
      }
      if (error != null) {
        result = result * 31 + error.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<ListenerUpcall:");
      if (hasSerial()) {
        builder.append(" serial=").append(serial);
      }
      builder.append(" version=").append(version);
      if (hasReady()) {
        builder.append(" ready=").append(ready);
      }
      if (invalidate != null) {
        builder.append(" invalidate=").append(invalidate);
      }
      if (registrationStatus != null) {
        builder.append(" registration_status=").append(registrationStatus);
      }
      if (registrationFailure != null) {
        builder.append(" registration_failure=").append(registrationFailure);
      }
      if (reissueRegistrations != null) {
        builder.append(" reissue_registrations=").append(reissueRegistrations);
      }
      if (error != null) {
        builder.append(" error=").append(error);
      }
      builder.append('>');
    }

    public static ListenerUpcall parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static ListenerUpcall fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall message) {
      if (message == null) { return null; }
      return new ListenerUpcall(message.serial,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReadyUpcall.fromMessageNano(message.ready),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.InvalidateUpcall.fromMessageNano(message.invalidate),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationStatusUpcall.fromMessageNano(message.registrationStatus),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.RegistrationFailureUpcall.fromMessageNano(message.registrationFailure),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ReissueRegistrationsUpcall.fromMessageNano(message.reissueRegistrations),
          com.google.ipc.invalidation.ticl.proto.AndroidService.ListenerUpcall.ErrorUpcall.fromMessageNano(message.error));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall msg = new com.google.protos.ipc.invalidation.NanoAndroidService.ListenerUpcall();
      msg.serial = hasSerial() ? serial : null;
      msg.version = version.toMessageNano();
      msg.ready = hasReady() ? ready.toMessageNano() : null;
      msg.invalidate = this.invalidate != null ? invalidate.toMessageNano() : null;
      msg.registrationStatus = this.registrationStatus != null ? registrationStatus.toMessageNano() : null;
      msg.registrationFailure = this.registrationFailure != null ? registrationFailure.toMessageNano() : null;
      msg.reissueRegistrations = this.reissueRegistrations != null ? reissueRegistrations.toMessageNano() : null;
      msg.error = this.error != null ? error.toMessageNano() : null;
      return msg;
    }
  }

  public static final class AndroidSchedulerEvent extends ProtoWrapper {
    public static AndroidSchedulerEvent create(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        String eventName,
        long ticlId) {
      return new AndroidSchedulerEvent(version, eventName, ticlId);
    }

    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final String eventName;
    private final long ticlId;

    private AndroidSchedulerEvent(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        String eventName,
        Long ticlId) throws ValidationArgumentException {
      required("version", version);
      this.version = version;
      required("event_name", eventName);
      this.eventName = eventName;
      required("ticl_id", ticlId);
      this.ticlId = ticlId;
    }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public String getEventName() { return eventName; }

    public long getTiclId() { return ticlId; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AndroidSchedulerEvent)) { return false; }
      AndroidSchedulerEvent other = (AndroidSchedulerEvent) obj;
      return equals(version, other.version)
          && equals(eventName, other.eventName)
          && ticlId == other.ticlId;
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + version.hashCode();
      result = result * 31 + eventName.hashCode();
      result = result * 31 + hash(ticlId);
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AndroidSchedulerEvent:");
      builder.append(" version=").append(version);
      builder.append(" event_name=").append(eventName);
      builder.append(" ticl_id=").append(ticlId);
      builder.append('>');
    }

    public static AndroidSchedulerEvent parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidSchedulerEvent(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AndroidSchedulerEvent fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.AndroidSchedulerEvent message) {
      if (message == null) { return null; }
      return new AndroidSchedulerEvent(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          message.eventName,
          message.ticlId);
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.AndroidSchedulerEvent toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.AndroidSchedulerEvent msg = new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidSchedulerEvent();
      msg.version = version.toMessageNano();
      msg.eventName = eventName;
      msg.ticlId = ticlId;
      return msg;
    }
  }

  public static final class AndroidNetworkSendRequest extends ProtoWrapper {
    public static AndroidNetworkSendRequest create(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        Bytes message) {
      return new AndroidNetworkSendRequest(version, message);
    }

    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final Bytes message;

    private AndroidNetworkSendRequest(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        Bytes message) throws ValidationArgumentException {
      required("version", version);
      this.version = version;
      required("message", message);
      this.message = message;
    }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public Bytes getMessage() { return message; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AndroidNetworkSendRequest)) { return false; }
      AndroidNetworkSendRequest other = (AndroidNetworkSendRequest) obj;
      return equals(version, other.version)
          && equals(message, other.message);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + version.hashCode();
      result = result * 31 + message.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AndroidNetworkSendRequest:");
      builder.append(" version=").append(version);
      builder.append(" message=").append(message);
      builder.append('>');
    }

    public static AndroidNetworkSendRequest parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidNetworkSendRequest(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AndroidNetworkSendRequest fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.AndroidNetworkSendRequest message) {
      if (message == null) { return null; }
      return new AndroidNetworkSendRequest(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          Bytes.fromByteArray(message.message));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.AndroidNetworkSendRequest toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.AndroidNetworkSendRequest msg = new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidNetworkSendRequest();
      msg.version = version.toMessageNano();
      msg.message = message.getByteArray();
      return msg;
    }
  }

  public static final class AndroidTiclState extends ProtoWrapper {
    public static final class Metadata extends ProtoWrapper {
      public static Metadata create(int clientType,
          Bytes clientName,
          long ticlId,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig) {
        return new Metadata(clientType, clientName, ticlId, clientConfig);
      }

      private final int clientType;
      private final Bytes clientName;
      private final long ticlId;
      private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig;

      private Metadata(Integer clientType,
          Bytes clientName,
          Long ticlId,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP clientConfig) throws ValidationArgumentException {
        required("client_type", clientType);
        this.clientType = clientType;
        required("client_name", clientName);
        this.clientName = clientName;
        required("ticl_id", ticlId);
        this.ticlId = ticlId;
        required("client_config", clientConfig);
        this.clientConfig = clientConfig;
      }

      public int getClientType() { return clientType; }

      public Bytes getClientName() { return clientName; }

      public long getTiclId() { return ticlId; }

      public com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP getClientConfig() { return clientConfig; }

      @Override public final boolean equals(Object obj) {
        if (this == obj) { return true; }
        if (!(obj instanceof Metadata)) { return false; }
        Metadata other = (Metadata) obj;
        return clientType == other.clientType
            && equals(clientName, other.clientName)
            && ticlId == other.ticlId
            && equals(clientConfig, other.clientConfig);
      }

      @Override protected int computeHashCode() {
        int result = 1;
        result = result * 31 + hash(clientType);
        result = result * 31 + clientName.hashCode();
        result = result * 31 + hash(ticlId);
        result = result * 31 + clientConfig.hashCode();
        return result;
      }

      @Override public void toCompactString(TextBuilder builder) {
        builder.append("<Metadata:");
        builder.append(" client_type=").append(clientType);
        builder.append(" client_name=").append(clientName);
        builder.append(" ticl_id=").append(ticlId);
        builder.append(" client_config=").append(clientConfig);
        builder.append('>');
      }

      public static Metadata parseFrom(byte[] data) throws ValidationException {
        try {
          return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState.Metadata(), data));
        } catch (InvalidProtocolBufferNanoException exception) {
          throw new ValidationException(exception);
        } catch (ValidationArgumentException exception) {
          throw new ValidationException(exception.getMessage());
        }
      }

      static Metadata fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState.Metadata message) {
        if (message == null) { return null; }
        return new Metadata(message.clientType,
            Bytes.fromByteArray(message.clientName),
            message.ticlId,
            com.google.ipc.invalidation.ticl.proto.ClientProtocol.ClientConfigP.fromMessageNano(message.clientConfig));
      }

      public byte[] toByteArray() {
        return MessageNano.toByteArray(toMessageNano());
      }

      com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState.Metadata toMessageNano() {
        com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState.Metadata msg = new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState.Metadata();
        msg.clientType = clientType;
        msg.clientName = clientName.getByteArray();
        msg.ticlId = ticlId;
        msg.clientConfig = clientConfig.toMessageNano();
        return msg;
      }
    }
    public static AndroidTiclState create(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.JavaClient.InvalidationClientState ticlState,
        com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.Metadata metadata) {
      return new AndroidTiclState(version, ticlState, metadata);
    }

    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version;
    private final com.google.ipc.invalidation.ticl.proto.JavaClient.InvalidationClientState ticlState;
    private final com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.Metadata metadata;

    private AndroidTiclState(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version version,
        com.google.ipc.invalidation.ticl.proto.JavaClient.InvalidationClientState ticlState,
        com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.Metadata metadata) throws ValidationArgumentException {
      required("version", version);
      this.version = version;
      required("ticl_state", ticlState);
      this.ticlState = ticlState;
      required("metadata", metadata);
      this.metadata = metadata;
    }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getVersion() { return version; }

    public com.google.ipc.invalidation.ticl.proto.JavaClient.InvalidationClientState getTiclState() { return ticlState; }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.Metadata getMetadata() { return metadata; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AndroidTiclState)) { return false; }
      AndroidTiclState other = (AndroidTiclState) obj;
      return equals(version, other.version)
          && equals(ticlState, other.ticlState)
          && equals(metadata, other.metadata);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + version.hashCode();
      result = result * 31 + ticlState.hashCode();
      result = result * 31 + metadata.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AndroidTiclState:");
      builder.append(" version=").append(version);
      builder.append(" ticl_state=").append(ticlState);
      builder.append(" metadata=").append(metadata);
      builder.append('>');
    }

    public static AndroidTiclState parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AndroidTiclState fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState message) {
      if (message == null) { return null; }
      return new AndroidTiclState(com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.version),
          com.google.ipc.invalidation.ticl.proto.JavaClient.InvalidationClientState.fromMessageNano(message.ticlState),
          com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.Metadata.fromMessageNano(message.metadata));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState msg = new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclState();
      msg.version = version.toMessageNano();
      msg.ticlState = ticlState.toMessageNano();
      msg.metadata = metadata.toMessageNano();
      return msg;
    }
  }

  public static final class AndroidTiclStateWithDigest extends ProtoWrapper {
    public static AndroidTiclStateWithDigest create(com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState state,
        Bytes digest) {
      return new AndroidTiclStateWithDigest(state, digest);
    }

    private final com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState state;
    private final Bytes digest;

    private AndroidTiclStateWithDigest(com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState state,
        Bytes digest) throws ValidationArgumentException {
      required("state", state);
      this.state = state;
      required("digest", digest);
      this.digest = digest;
    }

    public com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState getState() { return state; }

    public Bytes getDigest() { return digest; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AndroidTiclStateWithDigest)) { return false; }
      AndroidTiclStateWithDigest other = (AndroidTiclStateWithDigest) obj;
      return equals(state, other.state)
          && equals(digest, other.digest);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + state.hashCode();
      result = result * 31 + digest.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AndroidTiclStateWithDigest:");
      builder.append(" state=").append(state);
      builder.append(" digest=").append(digest);
      builder.append('>');
    }

    public static AndroidTiclStateWithDigest parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclStateWithDigest(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AndroidTiclStateWithDigest fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclStateWithDigest message) {
      if (message == null) { return null; }
      return new AndroidTiclStateWithDigest(com.google.ipc.invalidation.ticl.proto.AndroidService.AndroidTiclState.fromMessageNano(message.state),
          Bytes.fromByteArray(message.digest));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclStateWithDigest toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclStateWithDigest msg = new com.google.protos.ipc.invalidation.NanoAndroidService.AndroidTiclStateWithDigest();
      msg.state = state.toMessageNano();
      msg.digest = digest.getByteArray();
      return msg;
    }
  }
}
