/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by j/c/g/ipc/invalidation/common/proto_wrapper_generator
package com.google.ipc.invalidation.ticl.proto;

import com.google.ipc.invalidation.util.Bytes;
import com.google.ipc.invalidation.util.ProtoWrapper;
import com.google.ipc.invalidation.util.ProtoWrapper.ValidationException;
import com.google.ipc.invalidation.util.TextBuilder;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


public interface AndroidChannel {

  public static final class AndroidEndpointId extends ProtoWrapper {
    public static AndroidEndpointId create(String c2DmRegistrationId,
        String clientKey,
        String senderId,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version channelVersion,
        String packageName) {
      return new AndroidEndpointId(c2DmRegistrationId, clientKey, senderId, channelVersion, packageName);
    }

    public static final AndroidEndpointId DEFAULT_INSTANCE = new AndroidEndpointId(null, null, null, null, null);

    private final long __hazzerBits;
    private final String c2DmRegistrationId;
    private final String clientKey;
    private final String senderId;
    private final com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version channelVersion;
    private final String packageName;

    private AndroidEndpointId(String c2DmRegistrationId,
        String clientKey,
        String senderId,
        com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version channelVersion,
        String packageName) {
      int hazzerBits = 0;
      if (c2DmRegistrationId != null) {
        hazzerBits |= 0x1;
        this.c2DmRegistrationId = c2DmRegistrationId;
      } else {
        this.c2DmRegistrationId = "";
      }
      if (clientKey != null) {
        hazzerBits |= 0x2;
        this.clientKey = clientKey;
      } else {
        this.clientKey = "";
      }
      if (senderId != null) {
        hazzerBits |= 0x4;
        this.senderId = senderId;
      } else {
        this.senderId = "";
      }
      this.channelVersion = channelVersion;
      if (packageName != null) {
        hazzerBits |= 0x8;
        this.packageName = packageName;
      } else {
        this.packageName = "";
      }
      this.__hazzerBits = hazzerBits;
    }

    public String getC2DmRegistrationId() { return c2DmRegistrationId; }
    public boolean hasC2DmRegistrationId() { return (0x1 & __hazzerBits) != 0; }

    public String getClientKey() { return clientKey; }
    public boolean hasClientKey() { return (0x2 & __hazzerBits) != 0; }

    public String getSenderId() { return senderId; }
    public boolean hasSenderId() { return (0x4 & __hazzerBits) != 0; }

    public com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version getNullableChannelVersion() { return channelVersion; }

    public String getPackageName() { return packageName; }
    public boolean hasPackageName() { return (0x8 & __hazzerBits) != 0; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AndroidEndpointId)) { return false; }
      AndroidEndpointId other = (AndroidEndpointId) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasC2DmRegistrationId() || equals(c2DmRegistrationId, other.c2DmRegistrationId))
          && (!hasClientKey() || equals(clientKey, other.clientKey))
          && (!hasSenderId() || equals(senderId, other.senderId))
          && equals(channelVersion, other.channelVersion)
          && (!hasPackageName() || equals(packageName, other.packageName));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasC2DmRegistrationId()) {
        result = result * 31 + c2DmRegistrationId.hashCode();
      }
      if (hasClientKey()) {
        result = result * 31 + clientKey.hashCode();
      }
      if (hasSenderId()) {
        result = result * 31 + senderId.hashCode();
      }
      if (channelVersion != null) {
        result = result * 31 + channelVersion.hashCode();
      }
      if (hasPackageName()) {
        result = result * 31 + packageName.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AndroidEndpointId:");
      if (hasC2DmRegistrationId()) {
        builder.append(" c2dm_registration_id=").append(c2DmRegistrationId);
      }
      if (hasClientKey()) {
        builder.append(" client_key=").append(clientKey);
      }
      if (hasSenderId()) {
        builder.append(" sender_id=").append(senderId);
      }
      if (channelVersion != null) {
        builder.append(" channel_version=").append(channelVersion);
      }
      if (hasPackageName()) {
        builder.append(" package_name=").append(packageName);
      }
      builder.append('>');
    }

    public static AndroidEndpointId parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidChannel.AndroidEndpointId(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AndroidEndpointId fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidChannel.AndroidEndpointId message) {
      if (message == null) { return null; }
      return new AndroidEndpointId(message.c2DmRegistrationId,
          message.clientKey,
          message.senderId,
          com.google.ipc.invalidation.ticl.proto.ClientProtocol.Version.fromMessageNano(message.channelVersion),
          message.packageName);
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidChannel.AndroidEndpointId toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidChannel.AndroidEndpointId msg = new com.google.protos.ipc.invalidation.NanoAndroidChannel.AndroidEndpointId();
      msg.c2DmRegistrationId = hasC2DmRegistrationId() ? c2DmRegistrationId : null;
      msg.clientKey = hasClientKey() ? clientKey : null;
      msg.senderId = hasSenderId() ? senderId : null;
      msg.channelVersion = this.channelVersion != null ? channelVersion.toMessageNano() : null;
      msg.packageName = hasPackageName() ? packageName : null;
      return msg;
    }
  }

  public static final class AddressedAndroidMessage extends ProtoWrapper {
    public static AddressedAndroidMessage create(String clientKey,
        Bytes message) {
      return new AddressedAndroidMessage(clientKey, message);
    }

    public static final AddressedAndroidMessage DEFAULT_INSTANCE = new AddressedAndroidMessage(null, null);

    private final long __hazzerBits;
    private final String clientKey;
    private final Bytes message;

    private AddressedAndroidMessage(String clientKey,
        Bytes message) {
      int hazzerBits = 0;
      if (clientKey != null) {
        hazzerBits |= 0x1;
        this.clientKey = clientKey;
      } else {
        this.clientKey = "";
      }
      if (message != null) {
        hazzerBits |= 0x2;
        this.message = message;
      } else {
        this.message = Bytes.EMPTY_BYTES;
      }
      this.__hazzerBits = hazzerBits;
    }

    public String getClientKey() { return clientKey; }
    public boolean hasClientKey() { return (0x1 & __hazzerBits) != 0; }

    public Bytes getMessage() { return message; }
    public boolean hasMessage() { return (0x2 & __hazzerBits) != 0; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AddressedAndroidMessage)) { return false; }
      AddressedAndroidMessage other = (AddressedAndroidMessage) obj;
      return __hazzerBits == other.__hazzerBits
          && (!hasClientKey() || equals(clientKey, other.clientKey))
          && (!hasMessage() || equals(message, other.message));
    }

    @Override protected int computeHashCode() {
      int result = hash(__hazzerBits);
      if (hasClientKey()) {
        result = result * 31 + clientKey.hashCode();
      }
      if (hasMessage()) {
        result = result * 31 + message.hashCode();
      }
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AddressedAndroidMessage:");
      if (hasClientKey()) {
        builder.append(" client_key=").append(clientKey);
      }
      if (hasMessage()) {
        builder.append(" message=").append(message);
      }
      builder.append('>');
    }

    public static AddressedAndroidMessage parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AddressedAndroidMessage fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage message) {
      if (message == null) { return null; }
      return new AddressedAndroidMessage(message.clientKey,
          Bytes.fromByteArray(message.message));
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage msg = new com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage();
      msg.clientKey = hasClientKey() ? clientKey : null;
      msg.message = hasMessage() ? message.getByteArray() : null;
      return msg;
    }
  }

  public static final class AddressedAndroidMessageBatch extends ProtoWrapper {
    public static AddressedAndroidMessageBatch create(Collection<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage> addressedMessage) {
      return new AddressedAndroidMessageBatch(addressedMessage);
    }

    public static final AddressedAndroidMessageBatch DEFAULT_INSTANCE = new AddressedAndroidMessageBatch(null);

    private final List<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage> addressedMessage;

    private AddressedAndroidMessageBatch(Collection<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage> addressedMessage) {
      this.addressedMessage = optional("addressed_message", addressedMessage);
    }

    public List<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage> getAddressedMessage() { return addressedMessage; }

    @Override public final boolean equals(Object obj) {
      if (this == obj) { return true; }
      if (!(obj instanceof AddressedAndroidMessageBatch)) { return false; }
      AddressedAndroidMessageBatch other = (AddressedAndroidMessageBatch) obj;
      return equals(addressedMessage, other.addressedMessage);
    }

    @Override protected int computeHashCode() {
      int result = 1;
      result = result * 31 + addressedMessage.hashCode();
      return result;
    }

    @Override public void toCompactString(TextBuilder builder) {
      builder.append("<AddressedAndroidMessageBatch:");
      builder.append(" addressed_message=[").append(addressedMessage).append(']');
      builder.append('>');
    }

    public static AddressedAndroidMessageBatch parseFrom(byte[] data) throws ValidationException {
      try {
        return fromMessageNano(MessageNano.mergeFrom(new com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessageBatch(), data));
      } catch (InvalidProtocolBufferNanoException exception) {
        throw new ValidationException(exception);
      } catch (ValidationArgumentException exception) {
        throw new ValidationException(exception.getMessage());
      }
    }

    static AddressedAndroidMessageBatch fromMessageNano(com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessageBatch message) {
      if (message == null) { return null; }
      List<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage> addressedMessage = new ArrayList<com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage>(message.addressedMessage.length);
      for (int i = 0; i < message.addressedMessage.length; i++) {
        addressedMessage.add(com.google.ipc.invalidation.ticl.proto.AndroidChannel.AddressedAndroidMessage.fromMessageNano(message.addressedMessage[i]));
      }
      return new AddressedAndroidMessageBatch(addressedMessage);
    }

    public byte[] toByteArray() {
      return MessageNano.toByteArray(toMessageNano());
    }

    com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessageBatch toMessageNano() {
      com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessageBatch msg = new com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessageBatch();
      msg.addressedMessage = new com.google.protos.ipc.invalidation.NanoAndroidChannel.AddressedAndroidMessage[addressedMessage.size()];
      for (int i = 0; i < msg.addressedMessage.length; i++) {
        msg.addressedMessage[i] = addressedMessage.get(i).toMessageNano();
      }
      return msg;
    }
  }
  public interface MajorVersion {
    public static final int INITIAL = 0;
    public static final int BATCH = 1;
    public static final int DEFAULT = 0;
    public static final int MIN_SUPPORTED = 0;
    public static final int MAX_SUPPORTED = 1;
  }

}
