/*
 * Copyright (C) 2012 Google Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MediaEncryptedEvent_h
#define MediaEncryptedEvent_h

#include "modules/EventModules.h"

namespace blink {

class DOMArrayBuffer;

struct MediaEncryptedEventInit : public EventInit {
    MediaEncryptedEventInit();

    String initDataType;
    RefPtr<DOMArrayBuffer> initData;
};

class MediaEncryptedEvent final : public Event {
    DEFINE_WRAPPERTYPEINFO();
public:
    virtual ~MediaEncryptedEvent();

    static PassRefPtrWillBeRawPtr<MediaEncryptedEvent> create()
    {
        return adoptRefWillBeNoop(new MediaEncryptedEvent);
    }

    static PassRefPtrWillBeRawPtr<MediaEncryptedEvent> create(const AtomicString& type, const MediaEncryptedEventInit& initializer)
    {
        return adoptRefWillBeNoop(new MediaEncryptedEvent(type, initializer));
    }

    virtual const AtomicString& interfaceName() const override;

    String initDataType() const { return m_initDataType; }
    DOMArrayBuffer* initData() const { return m_initData.get(); }

    virtual void trace(Visitor*) override;

private:
    MediaEncryptedEvent();
    MediaEncryptedEvent(const AtomicString& type, const MediaEncryptedEventInit& initializer);

    String m_initDataType;
    RefPtr<DOMArrayBuffer> m_initData;
};

} // namespace blink

#endif // MediaEncryptedEvent_h
