// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#ifndef V8TestInterfaceNotScriptWrappable_h
#define V8TestInterfaceNotScriptWrappable_h

#include "bindings/core/v8/ScriptWrappable.h"
#include "bindings/core/v8/V8Binding.h"
#include "bindings/core/v8/V8DOMWrapper.h"
#include "bindings/core/v8/WrapperTypeInfo.h"
#include "bindings/tests/idls/core/TestInterfaceNotScriptWrappable.h"
#include "platform/heap/Handle.h"

namespace blink {

class V8TestInterfaceNotScriptWrappable {
public:
    static bool hasInstance(v8::Handle<v8::Value>, v8::Isolate*);
    static v8::Handle<v8::Object> findInstanceInPrototypeChain(v8::Handle<v8::Value>, v8::Isolate*);
    static v8::Handle<v8::FunctionTemplate> domTemplate(v8::Isolate*);
    static TestInterfaceNotScriptWrappable* toImpl(v8::Handle<v8::Object> object)
    {
        return blink::toScriptWrappableBase(object)->toImpl<TestInterfaceNotScriptWrappable>();
    }
    static TestInterfaceNotScriptWrappable* toImplWithTypeCheck(v8::Isolate*, v8::Handle<v8::Value>);
    static const WrapperTypeInfo wrapperTypeInfo;
    static void refObject(ScriptWrappableBase*);
    static void derefObject(ScriptWrappableBase*);
    static void trace(Visitor* visitor, ScriptWrappableBase* scriptWrappableBase)
    {
    }
    static const int internalFieldCount = v8DefaultWrapperInternalFieldCount + 0;
    static inline ScriptWrappableBase* toScriptWrappableBase(TestInterfaceNotScriptWrappable* impl)
    {
        return impl->toScriptWrappableBase();
    }
    static void installConditionallyEnabledProperties(v8::Handle<v8::Object>, v8::Isolate*) { }
    static void installConditionallyEnabledMethods(v8::Handle<v8::Object>, v8::Isolate*) { }
};

inline v8::Handle<v8::Value> toV8(TestInterfaceNotScriptWrappable* impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    ScriptWrappableBase* scriptWrappableBase = impl ? impl->toScriptWrappableBase() : 0;
    return toV8(scriptWrappableBase, creationContext, isolate, &V8TestInterfaceNotScriptWrappable::wrapperTypeInfo);
}

template<typename CallbackInfo>
inline void v8SetReturnValue(const CallbackInfo& callbackInfo, TestInterfaceNotScriptWrappable* impl)
{
    ScriptWrappableBase* scriptWrappableBase = impl ? impl->toScriptWrappableBase() : 0;
    return v8SetReturnValue(callbackInfo, scriptWrappableBase, &V8TestInterfaceNotScriptWrappable::wrapperTypeInfo);
}

template<typename CallbackInfo>
inline void v8SetReturnValueForMainWorld(const CallbackInfo& callbackInfo, TestInterfaceNotScriptWrappable* impl)
{
    ASSERT(DOMWrapperWorld::current(callbackInfo.GetIsolate()).isMainWorld());
    // Since |impl| is not ScriptWrappable, it doesn't matter much if it's the
    // main world or not.
    return v8SetReturnValue(callbackInfo, impl);
}

template<typename CallbackInfo, typename Wrappable>
inline void v8SetReturnValueFast(const CallbackInfo& callbackInfo, TestInterfaceNotScriptWrappable* impl, Wrappable*)
{
    // Since |impl| is not ScriptWrappable, it doesn't matter much if it's the
    // main world or not.
    return v8SetReturnValue(callbackInfo, impl);
}

} // namespace blink

#endif // V8TestInterfaceNotScriptWrappable_h
