// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#include "config.h"
#include "V8TestDictionary.h"

#include "bindings/core/v8/Dictionary.h"
#include "bindings/core/v8/ExceptionState.h"
#include "bindings/core/v8/ScriptValue.h"
#include "bindings/core/v8/V8Element.h"
#include "bindings/core/v8/V8TestInterface.h"
#include "bindings/core/v8/V8TestInterfaceGarbageCollected.h"
#include "bindings/core/v8/V8TestInterfaceWillBeGarbageCollected.h"

namespace blink {

void V8TestDictionary::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, TestDictionary& impl, ExceptionState& exceptionState)
{
    if (isUndefinedOrNull(v8Value))
        return;
    if (!v8Value->IsObject()) {
        exceptionState.throwTypeError("cannot convert to dictionary.");
        return;
    }

    // FIXME: Do not use Dictionary and DictionaryHelper
    // https://crbug.com/321462
    Dictionary dictionary(v8Value, isolate);
    // FIXME: Remove this v8::TryCatch once the code is switched from
    // Dictionary/DictionaryHelper to something that uses ExceptionState.
    v8::TryCatch block;
    bool booleanMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "booleanMember", booleanMember)) {
        impl.setBooleanMember(booleanMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    bool create;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "create", create)) {
        impl.setCreateMember(create);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    double doubleOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "doubleOrNullMember", doubleOrNullMember)) {
        impl.setDoubleOrNullMember(doubleOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RefPtrWillBeRawPtr<Element> elementOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "elementOrNullMember", elementOrNullMember)) {
        impl.setElementOrNullMember(elementOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    String enumMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "enumMember", enumMember)) {
        String string = enumMember;
        if (!(string == "foo" || string == "bar" || string == "baz")) {
            exceptionState.throwTypeError("member enumMember ('" + string + "') is not a valid enum value.");
            return;
        }
        impl.setEnumMember(enumMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    int longMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "longMember", longMember)) {
        impl.setLongMember(longMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    ScriptValue objectMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "objectMember", objectMember)) {
        if (!objectMember.isObject()) {
            exceptionState.throwTypeError("member objectMember is not an object.");
            return;
        }
        impl.setObjectMember(objectMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    ScriptValue objectOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "objectOrNullMember", objectOrNullMember)) {
        if (!objectOrNullMember.isObject()) {
            exceptionState.throwTypeError("member objectOrNullMember is not an object.");
            return;
        }
        impl.setObjectOrNullMember(objectOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    Vector<String> stringArrayMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "stringArrayMember", stringArrayMember)) {
        impl.setStringArrayMember(stringArrayMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    String stringMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "stringMember", stringMember)) {
        impl.setStringMember(stringMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    String stringOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "stringOrNullMember", stringOrNullMember)) {
        impl.setStringOrNullMember(stringOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    Vector<String> stringSequenceMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "stringSequenceMember", stringSequenceMember)) {
        impl.setStringSequenceMember(stringSequenceMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RawPtr<TestInterfaceGarbageCollected> testInterfaceGarbageCollectedMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceGarbageCollectedMember", testInterfaceGarbageCollectedMember)) {
        impl.setTestInterfaceGarbageCollectedMember(testInterfaceGarbageCollectedMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RawPtr<TestInterfaceGarbageCollected> testInterfaceGarbageCollectedOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceGarbageCollectedOrNullMember", testInterfaceGarbageCollectedOrNullMember)) {
        impl.setTestInterfaceGarbageCollectedOrNullMember(testInterfaceGarbageCollectedOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RefPtr<TestInterfaceImplementation> testInterfaceMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceMember", testInterfaceMember)) {
        impl.setTestInterfaceMember(testInterfaceMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RefPtr<TestInterfaceImplementation> testInterfaceOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceOrNullMember", testInterfaceOrNullMember)) {
        impl.setTestInterfaceOrNullMember(testInterfaceOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> testInterfaceWillBeGarbageCollectedMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceWillBeGarbageCollectedMember", testInterfaceWillBeGarbageCollectedMember)) {
        impl.setTestInterfaceWillBeGarbageCollectedMember(testInterfaceWillBeGarbageCollectedMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

    RefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> testInterfaceWillBeGarbageCollectedOrNullMember;
    if (DictionaryHelper::getWithUndefinedOrNullCheck(dictionary, "testInterfaceWillBeGarbageCollectedOrNullMember", testInterfaceWillBeGarbageCollectedOrNullMember)) {
        impl.setTestInterfaceWillBeGarbageCollectedOrNullMember(testInterfaceWillBeGarbageCollectedOrNullMember);
    } else if (block.HasCaught()) {
        exceptionState.rethrowV8Exception(block.Exception());
        return;
    }

}

v8::Handle<v8::Value> toV8(TestDictionary& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    v8::Handle<v8::Object> v8Object = v8::Object::New(isolate);
    if (impl.hasBooleanMember()) {
        v8Object->Set(v8String(isolate, "booleanMember"), v8Boolean(impl.booleanMember(), isolate));
    }

    if (impl.hasCreateMember()) {
        v8Object->Set(v8String(isolate, "create"), v8Boolean(impl.createMember(), isolate));
    }

    if (impl.hasDoubleOrNullMember()) {
        v8Object->Set(v8String(isolate, "doubleOrNullMember"), v8::Number::New(isolate, impl.doubleOrNullMember()));
    } else {
        v8Object->Set(v8String(isolate, "doubleOrNullMember"), v8::Null(isolate));
    }

    if (impl.hasElementOrNullMember()) {
        v8Object->Set(v8String(isolate, "elementOrNullMember"), toV8(impl.elementOrNullMember(), creationContext, isolate));
    }

    if (impl.hasEnumMember()) {
        v8Object->Set(v8String(isolate, "enumMember"), v8String(isolate, impl.enumMember()));
    } else {
        v8Object->Set(v8String(isolate, "enumMember"), v8String(isolate, String("foo")));
    }

    if (impl.hasLongMember()) {
        v8Object->Set(v8String(isolate, "longMember"), v8::Integer::New(isolate, impl.longMember()));
    } else {
        v8Object->Set(v8String(isolate, "longMember"), v8::Integer::New(isolate, 1));
    }

    if (impl.hasObjectMember()) {
        ASSERT(impl.objectMember().isObject());
        v8Object->Set(v8String(isolate, "objectMember"), impl.objectMember().v8Value());
    }

    if (impl.hasObjectOrNullMember()) {
        ASSERT(impl.objectOrNullMember().isObject());
        v8Object->Set(v8String(isolate, "objectOrNullMember"), impl.objectOrNullMember().v8Value());
    }

    if (impl.hasStringArrayMember()) {
        v8Object->Set(v8String(isolate, "stringArrayMember"), v8Array(impl.stringArrayMember(), creationContext, isolate));
    }

    if (impl.hasStringMember()) {
        v8Object->Set(v8String(isolate, "stringMember"), v8String(isolate, impl.stringMember()));
    }

    if (impl.hasStringOrNullMember()) {
        v8Object->Set(v8String(isolate, "stringOrNullMember"), v8String(isolate, impl.stringOrNullMember()));
    } else {
        v8Object->Set(v8String(isolate, "stringOrNullMember"), v8String(isolate, String("default string value")));
    }

    if (impl.hasStringSequenceMember()) {
        v8Object->Set(v8String(isolate, "stringSequenceMember"), v8Array(impl.stringSequenceMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceGarbageCollectedMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceGarbageCollectedMember"), toV8(impl.testInterfaceGarbageCollectedMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceGarbageCollectedOrNullMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceGarbageCollectedOrNullMember"), toV8(impl.testInterfaceGarbageCollectedOrNullMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceMember"), toV8(impl.testInterfaceMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceOrNullMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceOrNullMember"), toV8(impl.testInterfaceOrNullMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceWillBeGarbageCollectedMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceWillBeGarbageCollectedMember"), toV8(impl.testInterfaceWillBeGarbageCollectedMember(), creationContext, isolate));
    }

    if (impl.hasTestInterfaceWillBeGarbageCollectedOrNullMember()) {
        v8Object->Set(v8String(isolate, "testInterfaceWillBeGarbageCollectedOrNullMember"), toV8(impl.testInterfaceWillBeGarbageCollectedOrNullMember(), creationContext, isolate));
    }

    return v8Object;
}

} // namespace blink
