// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#include "config.h"
#include "bindings/core/v8/UnionTypesCore.h"

#include "bindings/core/v8/V8ArrayBuffer.h"
#include "bindings/core/v8/V8ArrayBufferView.h"
#include "bindings/core/v8/V8Node.h"
#include "bindings/core/v8/V8NodeList.h"
#include "bindings/core/v8/V8TestDictionary.h"
#include "bindings/core/v8/V8TestInterface.h"
#include "bindings/core/v8/V8TestInterfaceEmpty.h"
#include "bindings/core/v8/V8TestInterfaceGarbageCollected.h"
#include "bindings/core/v8/V8TestInterfaceWillBeGarbageCollected.h"
#include "bindings/tests/idls/core/TestImplements2.h"
#include "bindings/tests/idls/core/TestImplements3Implementation.h"
#include "bindings/tests/idls/core/TestPartialInterface.h"
#include "bindings/tests/idls/core/TestPartialInterfaceImplementation.h"
#include "core/dom/NameNodeList.h"
#include "core/dom/NodeList.h"
#include "core/dom/StaticNodeList.h"
#include "core/html/LabelsNodeList.h"

namespace blink {

BooleanOrStringOrUnrestrictedDouble::BooleanOrStringOrUnrestrictedDouble()
    : m_type(SpecificTypeNone)
{
}

bool BooleanOrStringOrUnrestrictedDouble::getAsBoolean() const
{
    ASSERT(isBoolean());
    return m_boolean;
}

void BooleanOrStringOrUnrestrictedDouble::setBoolean(bool value)
{
    ASSERT(isNull());
    m_boolean = value;
    m_type = SpecificTypeBoolean;
}

String BooleanOrStringOrUnrestrictedDouble::getAsString() const
{
    ASSERT(isString());
    return m_string;
}

void BooleanOrStringOrUnrestrictedDouble::setString(String value)
{
    ASSERT(isNull());
    m_string = value;
    m_type = SpecificTypeString;
}

double BooleanOrStringOrUnrestrictedDouble::getAsUnrestrictedDouble() const
{
    ASSERT(isUnrestrictedDouble());
    return m_unrestrictedDouble;
}

void BooleanOrStringOrUnrestrictedDouble::setUnrestrictedDouble(double value)
{
    ASSERT(isNull());
    m_unrestrictedDouble = value;
    m_type = SpecificTypeUnrestrictedDouble;
}

void V8BooleanOrStringOrUnrestrictedDouble::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, BooleanOrStringOrUnrestrictedDouble& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (v8Value->IsBoolean()) {
        impl.setBoolean(v8Value->ToBoolean()->Value());
        return;
    }

    if (v8Value->IsNumber()) {
        TONATIVE_VOID_EXCEPTIONSTATE(double, cppValue, toDouble(v8Value, exceptionState), exceptionState);
        impl.setUnrestrictedDouble(cppValue);
        return;
    }

    {
        TOSTRING_VOID_EXCEPTIONSTATE(V8StringResource<>, cppValue, v8Value, exceptionState);
        impl.setString(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(BooleanOrStringOrUnrestrictedDouble& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case BooleanOrStringOrUnrestrictedDouble::SpecificTypeNone:
        return v8::Null(isolate);
    case BooleanOrStringOrUnrestrictedDouble::SpecificTypeBoolean:
        return v8Boolean(impl.getAsBoolean(), isolate);
    case BooleanOrStringOrUnrestrictedDouble::SpecificTypeString:
        return v8String(isolate, impl.getAsString());
    case BooleanOrStringOrUnrestrictedDouble::SpecificTypeUnrestrictedDouble:
        return v8::Number::New(isolate, impl.getAsUnrestrictedDouble());
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

DoubleOrString::DoubleOrString()
    : m_type(SpecificTypeNone)
{
}

double DoubleOrString::getAsDouble() const
{
    ASSERT(isDouble());
    return m_double;
}

void DoubleOrString::setDouble(double value)
{
    ASSERT(isNull());
    m_double = value;
    m_type = SpecificTypeDouble;
}

String DoubleOrString::getAsString() const
{
    ASSERT(isString());
    return m_string;
}

void DoubleOrString::setString(String value)
{
    ASSERT(isNull());
    m_string = value;
    m_type = SpecificTypeString;
}

void V8DoubleOrString::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, DoubleOrString& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (v8Value->IsNumber()) {
        TONATIVE_VOID_EXCEPTIONSTATE(double, cppValue, toDouble(v8Value, exceptionState), exceptionState);
        impl.setDouble(cppValue);
        return;
    }

    {
        TOSTRING_VOID_EXCEPTIONSTATE(V8StringResource<>, cppValue, v8Value, exceptionState);
        impl.setString(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(DoubleOrString& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case DoubleOrString::SpecificTypeNone:
        return v8::Null(isolate);
    case DoubleOrString::SpecificTypeDouble:
        return v8::Number::New(isolate, impl.getAsDouble());
    case DoubleOrString::SpecificTypeString:
        return v8String(isolate, impl.getAsString());
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

NodeOrNodeList::NodeOrNodeList()
    : m_type(SpecificTypeNone)
{
}

PassRefPtrWillBeRawPtr<Node> NodeOrNodeList::getAsNode() const
{
    ASSERT(isNode());
    return m_node;
}

void NodeOrNodeList::setNode(PassRefPtrWillBeRawPtr<Node> value)
{
    ASSERT(isNull());
    m_node = value;
    m_type = SpecificTypeNode;
}

PassRefPtrWillBeRawPtr<NodeList> NodeOrNodeList::getAsNodeList() const
{
    ASSERT(isNodeList());
    return m_nodeList;
}

void NodeOrNodeList::setNodeList(PassRefPtrWillBeRawPtr<NodeList> value)
{
    ASSERT(isNull());
    m_nodeList = value;
    m_type = SpecificTypeNodeList;
}

void NodeOrNodeList::trace(Visitor* visitor)
{
    visitor->trace(m_node);
    visitor->trace(m_nodeList);
}

void V8NodeOrNodeList::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, NodeOrNodeList& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8Node::hasInstance(v8Value, isolate)) {
        RefPtrWillBeRawPtr<Node> cppValue = V8Node::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setNode(cppValue);
        return;
    }

    if (V8NodeList::hasInstance(v8Value, isolate)) {
        RefPtrWillBeRawPtr<NodeList> cppValue = V8NodeList::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setNodeList(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(NodeOrNodeList& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case NodeOrNodeList::SpecificTypeNone:
        return v8::Null(isolate);
    case NodeOrNodeList::SpecificTypeNode:
        return toV8(impl.getAsNode(), creationContext, isolate);
    case NodeOrNodeList::SpecificTypeNodeList:
        return toV8(impl.getAsNodeList(), creationContext, isolate);
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

StringOrArrayBufferOrArrayBufferView::StringOrArrayBufferOrArrayBufferView()
    : m_type(SpecificTypeNone)
{
}

String StringOrArrayBufferOrArrayBufferView::getAsString() const
{
    ASSERT(isString());
    return m_string;
}

void StringOrArrayBufferOrArrayBufferView::setString(String value)
{
    ASSERT(isNull());
    m_string = value;
    m_type = SpecificTypeString;
}

PassRefPtr<TestArrayBuffer> StringOrArrayBufferOrArrayBufferView::getAsArrayBuffer() const
{
    ASSERT(isArrayBuffer());
    return m_arrayBuffer;
}

void StringOrArrayBufferOrArrayBufferView::setArrayBuffer(PassRefPtr<TestArrayBuffer> value)
{
    ASSERT(isNull());
    m_arrayBuffer = value;
    m_type = SpecificTypeArrayBuffer;
}

PassRefPtr<TestArrayBufferView> StringOrArrayBufferOrArrayBufferView::getAsArrayBufferView() const
{
    ASSERT(isArrayBufferView());
    return m_arrayBufferView;
}

void StringOrArrayBufferOrArrayBufferView::setArrayBufferView(PassRefPtr<TestArrayBufferView> value)
{
    ASSERT(isNull());
    m_arrayBufferView = value;
    m_type = SpecificTypeArrayBufferView;
}

void V8StringOrArrayBufferOrArrayBufferView::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, StringOrArrayBufferOrArrayBufferView& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8ArrayBuffer::hasInstance(v8Value, isolate)) {
        RefPtr<TestArrayBuffer> cppValue = V8ArrayBuffer::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setArrayBuffer(cppValue);
        return;
    }

    if (V8ArrayBufferView::hasInstance(v8Value, isolate)) {
        RefPtr<TestArrayBufferView> cppValue = V8ArrayBufferView::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setArrayBufferView(cppValue);
        return;
    }

    {
        TOSTRING_VOID_EXCEPTIONSTATE(V8StringResource<>, cppValue, v8Value, exceptionState);
        impl.setString(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(StringOrArrayBufferOrArrayBufferView& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case StringOrArrayBufferOrArrayBufferView::SpecificTypeNone:
        return v8::Null(isolate);
    case StringOrArrayBufferOrArrayBufferView::SpecificTypeString:
        return v8String(isolate, impl.getAsString());
    case StringOrArrayBufferOrArrayBufferView::SpecificTypeArrayBuffer:
        return toV8(impl.getAsArrayBuffer(), creationContext, isolate);
    case StringOrArrayBufferOrArrayBufferView::SpecificTypeArrayBufferView:
        return toV8(impl.getAsArrayBufferView(), creationContext, isolate);
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

StringOrDouble::StringOrDouble()
    : m_type(SpecificTypeNone)
{
}

String StringOrDouble::getAsString() const
{
    ASSERT(isString());
    return m_string;
}

void StringOrDouble::setString(String value)
{
    ASSERT(isNull());
    m_string = value;
    m_type = SpecificTypeString;
}

double StringOrDouble::getAsDouble() const
{
    ASSERT(isDouble());
    return m_double;
}

void StringOrDouble::setDouble(double value)
{
    ASSERT(isNull());
    m_double = value;
    m_type = SpecificTypeDouble;
}

void V8StringOrDouble::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, StringOrDouble& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (v8Value->IsNumber()) {
        TONATIVE_VOID_EXCEPTIONSTATE(double, cppValue, toDouble(v8Value, exceptionState), exceptionState);
        impl.setDouble(cppValue);
        return;
    }

    {
        TOSTRING_VOID_EXCEPTIONSTATE(V8StringResource<>, cppValue, v8Value, exceptionState);
        impl.setString(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(StringOrDouble& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case StringOrDouble::SpecificTypeNone:
        return v8::Null(isolate);
    case StringOrDouble::SpecificTypeString:
        return v8String(isolate, impl.getAsString());
    case StringOrDouble::SpecificTypeDouble:
        return v8::Number::New(isolate, impl.getAsDouble());
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

TestInterfaceGarbageCollectedOrString::TestInterfaceGarbageCollectedOrString()
    : m_type(SpecificTypeNone)
{
}

RawPtr<TestInterfaceGarbageCollected> TestInterfaceGarbageCollectedOrString::getAsTestInterfaceGarbageCollected() const
{
    ASSERT(isTestInterfaceGarbageCollected());
    return m_testInterfaceGarbageCollected;
}

void TestInterfaceGarbageCollectedOrString::setTestInterfaceGarbageCollected(RawPtr<TestInterfaceGarbageCollected> value)
{
    ASSERT(isNull());
    m_testInterfaceGarbageCollected = value;
    m_type = SpecificTypeTestInterfaceGarbageCollected;
}

String TestInterfaceGarbageCollectedOrString::getAsString() const
{
    ASSERT(isString());
    return m_string;
}

void TestInterfaceGarbageCollectedOrString::setString(String value)
{
    ASSERT(isNull());
    m_string = value;
    m_type = SpecificTypeString;
}

void TestInterfaceGarbageCollectedOrString::trace(Visitor* visitor)
{
    visitor->trace(m_testInterfaceGarbageCollected);
}

void V8TestInterfaceGarbageCollectedOrString::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, TestInterfaceGarbageCollectedOrString& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8TestInterfaceGarbageCollected::hasInstance(v8Value, isolate)) {
        RawPtr<TestInterfaceGarbageCollected> cppValue = V8TestInterfaceGarbageCollected::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setTestInterfaceGarbageCollected(cppValue);
        return;
    }

    {
        TOSTRING_VOID_EXCEPTIONSTATE(V8StringResource<>, cppValue, v8Value, exceptionState);
        impl.setString(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(TestInterfaceGarbageCollectedOrString& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case TestInterfaceGarbageCollectedOrString::SpecificTypeNone:
        return v8::Null(isolate);
    case TestInterfaceGarbageCollectedOrString::SpecificTypeTestInterfaceGarbageCollected:
        return toV8(impl.getAsTestInterfaceGarbageCollected(), creationContext, isolate);
    case TestInterfaceGarbageCollectedOrString::SpecificTypeString:
        return v8String(isolate, impl.getAsString());
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

TestInterfaceOrLong::TestInterfaceOrLong()
    : m_type(SpecificTypeNone)
{
}

PassRefPtr<TestInterfaceImplementation> TestInterfaceOrLong::getAsTestInterface() const
{
    ASSERT(isTestInterface());
    return m_testInterface;
}

void TestInterfaceOrLong::setTestInterface(PassRefPtr<TestInterfaceImplementation> value)
{
    ASSERT(isNull());
    m_testInterface = value;
    m_type = SpecificTypeTestInterface;
}

int TestInterfaceOrLong::getAsLong() const
{
    ASSERT(isLong());
    return m_long;
}

void TestInterfaceOrLong::setLong(int value)
{
    ASSERT(isNull());
    m_long = value;
    m_type = SpecificTypeLong;
}

void V8TestInterfaceOrLong::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, TestInterfaceOrLong& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8TestInterface::hasInstance(v8Value, isolate)) {
        RefPtr<TestInterfaceImplementation> cppValue = V8TestInterface::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setTestInterface(cppValue);
        return;
    }

    if (v8Value->IsNumber()) {
        TONATIVE_VOID_EXCEPTIONSTATE(int, cppValue, toInt32(v8Value, exceptionState), exceptionState);
        impl.setLong(cppValue);
        return;
    }

    {
        TONATIVE_VOID_EXCEPTIONSTATE(int, cppValue, toInt32(v8Value, exceptionState), exceptionState);
        impl.setLong(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(TestInterfaceOrLong& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case TestInterfaceOrLong::SpecificTypeNone:
        return v8::Null(isolate);
    case TestInterfaceOrLong::SpecificTypeTestInterface:
        return toV8(impl.getAsTestInterface(), creationContext, isolate);
    case TestInterfaceOrLong::SpecificTypeLong:
        return v8::Integer::New(isolate, impl.getAsLong());
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

TestInterfaceOrTestInterfaceEmpty::TestInterfaceOrTestInterfaceEmpty()
    : m_type(SpecificTypeNone)
{
}

PassRefPtr<TestInterfaceImplementation> TestInterfaceOrTestInterfaceEmpty::getAsTestInterface() const
{
    ASSERT(isTestInterface());
    return m_testInterface;
}

void TestInterfaceOrTestInterfaceEmpty::setTestInterface(PassRefPtr<TestInterfaceImplementation> value)
{
    ASSERT(isNull());
    m_testInterface = value;
    m_type = SpecificTypeTestInterface;
}

PassRefPtr<TestInterfaceEmpty> TestInterfaceOrTestInterfaceEmpty::getAsTestInterfaceEmpty() const
{
    ASSERT(isTestInterfaceEmpty());
    return m_testInterfaceEmpty;
}

void TestInterfaceOrTestInterfaceEmpty::setTestInterfaceEmpty(PassRefPtr<TestInterfaceEmpty> value)
{
    ASSERT(isNull());
    m_testInterfaceEmpty = value;
    m_type = SpecificTypeTestInterfaceEmpty;
}

void V8TestInterfaceOrTestInterfaceEmpty::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, TestInterfaceOrTestInterfaceEmpty& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8TestInterface::hasInstance(v8Value, isolate)) {
        RefPtr<TestInterfaceImplementation> cppValue = V8TestInterface::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setTestInterface(cppValue);
        return;
    }

    if (V8TestInterfaceEmpty::hasInstance(v8Value, isolate)) {
        RefPtr<TestInterfaceEmpty> cppValue = V8TestInterfaceEmpty::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setTestInterfaceEmpty(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(TestInterfaceOrTestInterfaceEmpty& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case TestInterfaceOrTestInterfaceEmpty::SpecificTypeNone:
        return v8::Null(isolate);
    case TestInterfaceOrTestInterfaceEmpty::SpecificTypeTestInterface:
        return toV8(impl.getAsTestInterface(), creationContext, isolate);
    case TestInterfaceOrTestInterfaceEmpty::SpecificTypeTestInterfaceEmpty:
        return toV8(impl.getAsTestInterfaceEmpty(), creationContext, isolate);
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

TestInterfaceWillBeGarbageCollectedOrTestDictionary::TestInterfaceWillBeGarbageCollectedOrTestDictionary()
    : m_type(SpecificTypeNone)
{
}

PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> TestInterfaceWillBeGarbageCollectedOrTestDictionary::getAsTestInterfaceWillBeGarbageCollected() const
{
    ASSERT(isTestInterfaceWillBeGarbageCollected());
    return m_testInterfaceWillBeGarbageCollected;
}

void TestInterfaceWillBeGarbageCollectedOrTestDictionary::setTestInterfaceWillBeGarbageCollected(PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> value)
{
    ASSERT(isNull());
    m_testInterfaceWillBeGarbageCollected = value;
    m_type = SpecificTypeTestInterfaceWillBeGarbageCollected;
}

TestDictionary TestInterfaceWillBeGarbageCollectedOrTestDictionary::getAsTestDictionary() const
{
    ASSERT(isTestDictionary());
    return m_testDictionary;
}

void TestInterfaceWillBeGarbageCollectedOrTestDictionary::setTestDictionary(TestDictionary value)
{
    ASSERT(isNull());
    m_testDictionary = value;
    m_type = SpecificTypeTestDictionary;
}

void TestInterfaceWillBeGarbageCollectedOrTestDictionary::trace(Visitor* visitor)
{
    visitor->trace(m_testInterfaceWillBeGarbageCollected);
}

void V8TestInterfaceWillBeGarbageCollectedOrTestDictionary::toImpl(v8::Isolate* isolate, v8::Handle<v8::Value> v8Value, TestInterfaceWillBeGarbageCollectedOrTestDictionary& impl, ExceptionState& exceptionState)
{
    if (v8Value.IsEmpty())
        return;

    if (V8TestInterfaceWillBeGarbageCollected::hasInstance(v8Value, isolate)) {
        RefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> cppValue = V8TestInterfaceWillBeGarbageCollected::toImpl(v8::Handle<v8::Object>::Cast(v8Value));
        impl.setTestInterfaceWillBeGarbageCollected(cppValue);
        return;
    }

    if (isUndefinedOrNull(v8Value) || v8Value->IsObject()) {
        TestDictionary cppValue = V8TestDictionary::toImpl(isolate, v8Value, exceptionState);
        if (!exceptionState.hadException())
            impl.setTestDictionary(cppValue);
        return;
    }

    exceptionState.throwTypeError("Not a valid union member.");
}

v8::Handle<v8::Value> toV8(TestInterfaceWillBeGarbageCollectedOrTestDictionary& impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    switch (impl.m_type) {
    case TestInterfaceWillBeGarbageCollectedOrTestDictionary::SpecificTypeNone:
        return v8::Null(isolate);
    case TestInterfaceWillBeGarbageCollectedOrTestDictionary::SpecificTypeTestInterfaceWillBeGarbageCollected:
        return toV8(impl.getAsTestInterfaceWillBeGarbageCollected(), creationContext, isolate);
    case TestInterfaceWillBeGarbageCollectedOrTestDictionary::SpecificTypeTestDictionary:
        return toV8(impl.getAsTestDictionary(), creationContext, isolate);
    default:
        ASSERT_NOT_REACHED();
    }
    return v8::Handle<v8::Value>();
}

} // namespace blink
