// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#ifndef TestDictionary_h
#define TestDictionary_h

#include "bindings/core/v8/Nullable.h"
#include "bindings/core/v8/ScriptValue.h"
#include "bindings/tests/idls/core/TestInterfaceGarbageCollected.h"
#include "bindings/tests/idls/core/TestInterfaceImplementation.h"
#include "bindings/tests/idls/core/TestInterfaceWillBeGarbageCollected.h"
#include "core/dom/Element.h"
#include "platform/heap/Handle.h"
#include "wtf/Vector.h"
#include "wtf/text/WTFString.h"

namespace blink {

class TestDictionary final {
    ALLOW_ONLY_INLINE_ALLOCATION();
public:
    TestDictionary();

    bool hasBooleanMember() const { return !m_booleanMember.isNull(); }
    bool booleanMember() const { return m_booleanMember.get(); }
    void setBooleanMember(bool value) { m_booleanMember = value; }

    bool hasLongMember() const { return !m_longMember.isNull(); }
    int longMember() const { return m_longMember.get(); }
    void setLongMember(int value) { m_longMember = value; }

    bool hasStringMember() const { return !m_stringMember.isNull(); }
    String stringMember() const { return m_stringMember; }
    void setStringMember(String value) { m_stringMember = value; }

    bool hasTestInterfaceMember() const { return m_testInterfaceMember; }
    PassRefPtr<TestInterfaceImplementation> testInterfaceMember() const { return m_testInterfaceMember; }
    void setTestInterfaceMember(PassRefPtr<TestInterfaceImplementation> value) { m_testInterfaceMember = value; }

    bool hasDoubleOrNullMember() const { return !m_doubleOrNullMember.isNull(); }
    double doubleOrNullMember() const { return m_doubleOrNullMember.get(); }
    void setDoubleOrNullMember(double value) { m_doubleOrNullMember = value; }

    bool hasStringOrNullMember() const { return !m_stringOrNullMember.isNull(); }
    String stringOrNullMember() const { return m_stringOrNullMember; }
    void setStringOrNullMember(String value) { m_stringOrNullMember = value; }

    bool hasTestInterfaceOrNullMember() const { return m_testInterfaceOrNullMember; }
    PassRefPtr<TestInterfaceImplementation> testInterfaceOrNullMember() const { return m_testInterfaceOrNullMember; }
    void setTestInterfaceOrNullMember(PassRefPtr<TestInterfaceImplementation> value) { m_testInterfaceOrNullMember = value; }

    bool hasTestInterfaceGarbageCollectedMember() const { return m_testInterfaceGarbageCollectedMember; }
    RawPtr<TestInterfaceGarbageCollected> testInterfaceGarbageCollectedMember() const { return m_testInterfaceGarbageCollectedMember; }
    void setTestInterfaceGarbageCollectedMember(RawPtr<TestInterfaceGarbageCollected> value) { m_testInterfaceGarbageCollectedMember = value; }

    bool hasTestInterfaceGarbageCollectedOrNullMember() const { return m_testInterfaceGarbageCollectedOrNullMember; }
    RawPtr<TestInterfaceGarbageCollected> testInterfaceGarbageCollectedOrNullMember() const { return m_testInterfaceGarbageCollectedOrNullMember; }
    void setTestInterfaceGarbageCollectedOrNullMember(RawPtr<TestInterfaceGarbageCollected> value) { m_testInterfaceGarbageCollectedOrNullMember = value; }

    bool hasTestInterfaceWillBeGarbageCollectedMember() const { return m_testInterfaceWillBeGarbageCollectedMember; }
    PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> testInterfaceWillBeGarbageCollectedMember() const { return m_testInterfaceWillBeGarbageCollectedMember; }
    void setTestInterfaceWillBeGarbageCollectedMember(PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> value) { m_testInterfaceWillBeGarbageCollectedMember = value; }

    bool hasTestInterfaceWillBeGarbageCollectedOrNullMember() const { return m_testInterfaceWillBeGarbageCollectedOrNullMember; }
    PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> testInterfaceWillBeGarbageCollectedOrNullMember() const { return m_testInterfaceWillBeGarbageCollectedOrNullMember; }
    void setTestInterfaceWillBeGarbageCollectedOrNullMember(PassRefPtrWillBeRawPtr<TestInterfaceWillBeGarbageCollected> value) { m_testInterfaceWillBeGarbageCollectedOrNullMember = value; }

    bool hasStringArrayMember() const { return !m_stringArrayMember.isNull(); }
    const Vector<String>& stringArrayMember() const { return m_stringArrayMember.get(); }
    void setStringArrayMember(const Vector<String>& value) { m_stringArrayMember = value; }

    bool hasStringSequenceMember() const { return !m_stringSequenceMember.isNull(); }
    const Vector<String>& stringSequenceMember() const { return m_stringSequenceMember.get(); }
    void setStringSequenceMember(const Vector<String>& value) { m_stringSequenceMember = value; }

    bool hasEnumMember() const { return !m_enumMember.isNull(); }
    String enumMember() const { return m_enumMember; }
    void setEnumMember(String value) { m_enumMember = value; }

    bool hasElementOrNullMember() const { return m_elementOrNullMember; }
    PassRefPtrWillBeRawPtr<Element> elementOrNullMember() const { return m_elementOrNullMember; }
    void setElementOrNullMember(PassRefPtrWillBeRawPtr<Element> value) { m_elementOrNullMember = value; }

    bool hasObjectMember() const { return !(m_objectMember.isEmpty() || m_objectMember.isNull() || m_objectMember.isUndefined()); }
    ScriptValue objectMember() const { return m_objectMember; }
    void setObjectMember(ScriptValue value) { m_objectMember = value; }

    bool hasObjectOrNullMember() const { return !(m_objectOrNullMember.isEmpty() || m_objectOrNullMember.isNull() || m_objectOrNullMember.isUndefined()); }
    ScriptValue objectOrNullMember() const { return m_objectOrNullMember; }
    void setObjectOrNullMember(ScriptValue value) { m_objectOrNullMember = value; }

    bool hasCreateMember() const { return !m_createMember.isNull(); }
    bool createMember() const { return m_createMember.get(); }
    void setCreateMember(bool value) { m_createMember = value; }

    void trace(Visitor*);

private:
    Nullable<bool> m_booleanMember;
    Nullable<int> m_longMember;
    String m_stringMember;
    RefPtr<TestInterfaceImplementation> m_testInterfaceMember;
    Nullable<double> m_doubleOrNullMember;
    String m_stringOrNullMember;
    RefPtr<TestInterfaceImplementation> m_testInterfaceOrNullMember;
    Member<TestInterfaceGarbageCollected> m_testInterfaceGarbageCollectedMember;
    Member<TestInterfaceGarbageCollected> m_testInterfaceGarbageCollectedOrNullMember;
    RefPtrWillBeMember<TestInterfaceWillBeGarbageCollected> m_testInterfaceWillBeGarbageCollectedMember;
    RefPtrWillBeMember<TestInterfaceWillBeGarbageCollected> m_testInterfaceWillBeGarbageCollectedOrNullMember;
    Nullable<Vector<String> > m_stringArrayMember;
    Nullable<Vector<String> > m_stringSequenceMember;
    String m_enumMember;
    RefPtrWillBeMember<Element> m_elementOrNullMember;
    ScriptValue m_objectMember;
    ScriptValue m_objectOrNullMember;
    Nullable<bool> m_createMember;

    friend class V8TestDictionary;
};

} // namespace blink

#endif // TestDictionary_h
