/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.nano;

import com.google.protobuf.nano.MessageNano;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageNanoPrinter {
    private static final String INDENT = "  ";
    private static final int MAX_STRING_LEN = 200;

    private MessageNanoPrinter() {
    }

    public static <T extends MessageNano> String print(T message) {
        if (message == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        try {
            MessageNanoPrinter.print(null, message, new StringBuffer(), buf);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(e.getMessage());
            return string.length() != 0 ? "Error printing proto: ".concat(string) : new String("Error printing proto: ");
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(e.getMessage());
            return string.length() != 0 ? "Error printing proto: ".concat(string) : new String("Error printing proto: ");
        }
        return buf.toString();
    }

    private static void print(String identifier, Object object, StringBuffer indentBuf, StringBuffer buf) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            if (object instanceof MessageNano) {
                int origIndentBufLength = indentBuf.length();
                if (identifier != null) {
                    buf.append(indentBuf).append(MessageNanoPrinter.deCamelCaseify(identifier)).append(" <\n");
                    indentBuf.append(INDENT);
                }
                Class<?> clazz = object.getClass();
                for (Field field : clazz.getFields()) {
                    int modifiers = field.getModifiers();
                    String fieldName = field.getName();
                    if ((modifiers & 1) != 1 || (modifiers & 8) == 8 || fieldName.startsWith("_") || fieldName.endsWith("_")) continue;
                    Class<?> fieldType = field.getType();
                    Object value = field.get(object);
                    if (fieldType.isArray()) {
                        Class<?> arrayType = fieldType.getComponentType();
                        if (arrayType == Byte.TYPE) {
                            MessageNanoPrinter.print(fieldName, value, indentBuf, buf);
                            continue;
                        }
                        int len = value == null ? 0 : Array.getLength(value);
                        for (int i = 0; i < len; ++i) {
                            Object elem = Array.get(value, i);
                            MessageNanoPrinter.print(fieldName, elem, indentBuf, buf);
                        }
                        continue;
                    }
                    MessageNanoPrinter.print(fieldName, value, indentBuf, buf);
                }
                for (AccessibleObject accessibleObject : clazz.getMethods()) {
                    String name = ((Method)accessibleObject).getName();
                    if (!name.startsWith("set")) continue;
                    String subfieldName = name.substring(3);
                    Method hazzer = null;
                    try {
                        String string = String.valueOf(subfieldName);
                        hazzer = clazz.getMethod(string.length() != 0 ? "has".concat(string) : new String("has"), new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                    if (!((Boolean)hazzer.invoke(object, new Object[0])).booleanValue()) continue;
                    Method getter = null;
                    try {
                        String string = String.valueOf(subfieldName);
                        getter = clazz.getMethod(string.length() != 0 ? "get".concat(string) : new String("get"), new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                    MessageNanoPrinter.print(subfieldName, getter.invoke(object, new Object[0]), indentBuf, buf);
                }
                if (identifier != null) {
                    indentBuf.setLength(origIndentBufLength);
                    buf.append(indentBuf).append(">\n");
                }
            } else {
                identifier = MessageNanoPrinter.deCamelCaseify(identifier);
                buf.append(indentBuf).append(identifier).append(": ");
                if (object instanceof String) {
                    String stringMessage = MessageNanoPrinter.sanitizeString((String)object);
                    buf.append("\"").append(stringMessage).append("\"");
                } else if (object instanceof byte[]) {
                    MessageNanoPrinter.appendQuotedBytes((byte[])object, buf);
                } else {
                    buf.append(object);
                }
                buf.append("\n");
            }
        }
    }

    private static String deCamelCaseify(String identifier) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < identifier.length(); ++i) {
            char currentChar = identifier.charAt(i);
            if (i == 0) {
                out.append(Character.toLowerCase(currentChar));
                continue;
            }
            if (Character.isUpperCase(currentChar)) {
                out.append('_').append(Character.toLowerCase(currentChar));
                continue;
            }
            out.append(currentChar);
        }
        return out.toString();
    }

    private static String sanitizeString(String str) {
        if (!str.startsWith("http") && str.length() > 200) {
            str = String.valueOf(str.substring(0, 200)).concat("[...]");
        }
        return MessageNanoPrinter.escapeString(str);
    }

    private static String escapeString(String str) {
        int strLen = str.length();
        StringBuilder b = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char original = str.charAt(i);
            if (original >= ' ' && original <= '~' && original != '\"' && original != '\'') {
                b.append(original);
                continue;
            }
            b.append(String.format("\\u%04x", original));
        }
        return b.toString();
    }

    private static void appendQuotedBytes(byte[] bytes, StringBuffer builder) {
        if (bytes == null) {
            builder.append("\"\"");
            return;
        }
        builder.append('\"');
        for (int i = 0; i < bytes.length; ++i) {
            byte ch = bytes[i];
            if (ch == 92 || ch == 34) {
                builder.append('\\').append((char)ch);
                continue;
            }
            if (ch >= 32 && ch < 127) {
                builder.append((char)ch);
                continue;
            }
            builder.append(String.format("\\%03o", ch));
        }
        builder.append('\"');
    }
}

