/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.nano;

import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.Extension;
import com.google.protobuf.nano.UnknownFieldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldData {
    private Extension<?, ?> cachedExtension;
    private Object value;
    private List<UnknownFieldData> unknownFieldData;

    <T> FieldData(Extension<?, T> extension, T newValue) {
        this.cachedExtension = extension;
        this.value = newValue;
    }

    FieldData() {
        this.unknownFieldData = new ArrayList<UnknownFieldData>();
    }

    void addUnknownField(UnknownFieldData unknownField) {
        this.unknownFieldData.add(unknownField);
    }

    <T> T getValue(Extension<?, T> extension) {
        if (this.value != null) {
            if (this.cachedExtension != extension) {
                throw new IllegalStateException("Tried to getExtension with a differernt Extension.");
            }
        } else {
            this.cachedExtension = extension;
            this.value = extension.getValueFrom(this.unknownFieldData);
            this.unknownFieldData = null;
        }
        return (T)this.value;
    }

    <T> void setValue(Extension<?, T> extension, T newValue) {
        this.cachedExtension = extension;
        this.value = newValue;
        this.unknownFieldData = null;
    }

    int computeSerializedSize() {
        int size = 0;
        if (this.value != null) {
            size = this.cachedExtension.computeSerializedSize(this.value);
        } else {
            for (UnknownFieldData unknownField : this.unknownFieldData) {
                size += unknownField.computeSerializedSize();
            }
        }
        return size;
    }

    void writeTo(CodedOutputByteBufferNano output) throws IOException {
        if (this.value != null) {
            this.cachedExtension.writeTo(this.value, output);
        } else {
            for (UnknownFieldData unknownField : this.unknownFieldData) {
                unknownField.writeTo(output);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldData)) {
            return false;
        }
        FieldData other = (FieldData)o;
        if (this.value != null && other.value != null) {
            if (this.cachedExtension != other.cachedExtension) {
                return false;
            }
            if (!this.cachedExtension.clazz.isArray()) {
                return this.value.equals(other.value);
            }
            if (this.value instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])other.value);
            }
            if (this.value instanceof int[]) {
                return Arrays.equals((int[])this.value, (int[])other.value);
            }
            if (this.value instanceof long[]) {
                return Arrays.equals((long[])this.value, (long[])other.value);
            }
            if (this.value instanceof float[]) {
                return Arrays.equals((float[])this.value, (float[])other.value);
            }
            if (this.value instanceof double[]) {
                return Arrays.equals((double[])this.value, (double[])other.value);
            }
            if (this.value instanceof boolean[]) {
                return Arrays.equals((boolean[])this.value, (boolean[])other.value);
            }
            return Arrays.deepEquals((Object[])this.value, (Object[])other.value);
        }
        if (this.unknownFieldData != null && other.unknownFieldData != null) {
            return this.unknownFieldData.equals(other.unknownFieldData);
        }
        try {
            return Arrays.equals(this.toByteArray(), other.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        int result = 17;
        try {
            result = 31 * result + Arrays.hashCode(this.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private byte[] toByteArray() throws IOException {
        byte[] result = new byte[this.computeSerializedSize()];
        CodedOutputByteBufferNano output = CodedOutputByteBufferNano.newInstance(result);
        this.writeTo(output);
        return result;
    }
}

