/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import java.util.LinkedList;

public abstract class EventLoop {
    private Thread eventProcessor;
    private int threadPriority;
    private final LinkedList eventQueue = new LinkedList();
    private boolean isCoalesce;
    private volatile boolean isAlive = true;
    private volatile boolean isLIFO = false;

    public EventLoop() {
        this(5);
    }

    public EventLoop(int priority) {
        this.threadPriority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectEvent(Object event) {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (!this.isCoalesce || !this.eventQueue.contains(event)) {
                if (this.isLIFO) {
                    this.eventQueue.addFirst(event);
                } else {
                    this.eventQueue.addLast(event);
                }
                if (this.isAlive) {
                    this.startProcessor();
                }
            }
        }
    }

    public void setCoalesce(boolean b) {
        this.isCoalesce = b;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    public void setLIFO(boolean b) {
        this.isLIFO = b;
    }

    public boolean isLIFO() {
        return this.isLIFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.isAlive = true;
            this.startProcessor();
        }
    }

    public void stop() {
        this.isAlive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.clear();
        }
    }

    public void dispose() {
        this.stop();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessor() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.eventProcessor == null) {
                this.eventProcessor = new Thread(this + " Event Processor"){

                    @Override
                    public void run() {
                        EventLoop.this.processEvents();
                    }
                };
                try {
                    this.eventProcessor.setDaemon(false);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                try {
                    this.eventProcessor.setPriority(this.threadPriority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.eventProcessor.start();
            }
        }
    }

    protected abstract void processEvent(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (true) {
            Object event;
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                if (this.eventQueue.isEmpty() || !this.isAlive) {
                    this.eventProcessor = null;
                    return;
                }
                event = this.eventQueue.removeFirst();
            }
            try {
                this.processEvent(event);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

