/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.CachedPainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class QuaquaNativeButtonStateBorder
extends CachedPainter
implements Border,
VisualMargin {
    private OSXAquaPainter painter = new OSXAquaPainter();
    private Insets imageInsets;
    private Insets borderInsets;
    private static final int ARG_ACTIVE = 0;
    private static final int ARG_PRESSED = 1;
    private static final int ARG_DISABLED = 2;
    private static final int ARG_ROLLOVER = 3;
    private static final int ARG_SELECTED = 4;
    private static final int ARG_FOCUSED = 5;
    private static final int ARG_SIZE_VARIANT = 6;
    private static final int ARG_SEGPOS = 8;
    private static final int ARG_WIDGET = 11;
    private static final int ARG_TRAILING_SEPARATOR = 18;

    public QuaquaNativeButtonStateBorder(OSXAquaPainter.Widget widget) {
        this(widget, new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0));
    }

    public QuaquaNativeButtonStateBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
        super(12);
        this.painter.setWidget(widget);
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        OSXAquaPainter.Size size;
        OSXAquaPainter.State state;
        AbstractButton b = null;
        ButtonModel bm = null;
        Insets vm = this.getVisualMargin(c);
        x += vm.left;
        y += vm.top;
        width -= vm.left + vm.right;
        height -= vm.top + vm.bottom;
        if (c instanceof AbstractButton) {
            b = (AbstractButton)c;
            bm = b.getModel();
        }
        int args = 0;
        if (QuaquaUtilities.isOnActiveWindow(c)) {
            state = OSXAquaPainter.State.active;
            args |= 1;
        } else {
            state = OSXAquaPainter.State.inactive;
        }
        if (bm != null) {
            if (bm.isArmed() && bm.isPressed()) {
                state = OSXAquaPainter.State.pressed;
                args |= 2;
            }
            if (!bm.isEnabled()) {
                state = OSXAquaPainter.State.disabled;
                args |= 4;
            }
            if (bm.isRollover()) {
                state = OSXAquaPainter.State.rollover;
                args |= 8;
            }
        }
        this.painter.setState(state);
        int value = b == null ? 0 : (b.isSelected() ? 1 : 0);
        this.painter.setValueByKey(OSXAquaPainter.Key.value, value);
        args |= value << 4;
        boolean isFocused = QuaquaUtilities.isFocused(c);
        args |= isFocused ? 32 : 0;
        this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocused ? 1.0 : 0.0);
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                size = OSXAquaPainter.Size.regular;
                break;
            }
            case SMALL: {
                size = OSXAquaPainter.Size.small;
                break;
            }
            case MINI: {
                size = OSXAquaPainter.Size.mini;
            }
        }
        this.painter.setSize(size);
        this.paint(c, g, x, y, width, height, args |= size.getId() << 6);
    }

    @Override
    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        return new BufferedImage(w, h, 3);
    }

    @Override
    protected void paintToImage(Component c, Image img, int w, int h, Object args) {
        Graphics2D ig = (Graphics2D)img.getGraphics();
        ig.setColor(new Color(0, true));
        ig.setComposite(AlphaComposite.getInstance(2));
        ig.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
        ig.dispose();
        this.painter.paint((BufferedImage)img, this.imageInsets.left, this.imageInsets.top, w - this.imageInsets.left - this.imageInsets.right, h - this.imageInsets.top - this.imageInsets.bottom);
    }

    @Override
    protected void paintToImage(Component c, Graphics g, int w, int h, Object args) {
        BufferedImage img = (BufferedImage)this.createImage(c, (w / 32 + 1) * 32, (h / 32 + 1) * 32, null);
        this.paintToImage(c, img, w, h, args);
        g.drawImage(img, 0, 0, null);
        img.flush();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.borderInsets.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getVisualMargin(Component c) {
        Insets vm = null;
        if (c instanceof JComponent) {
            vm = (Insets)((JComponent)c).getClientProperty("Quaqua.Component.visualMargin");
        }
        return vm == null ? new Insets(0, 0, 0, 0) : (Insets)vm.clone();
    }

    public static class UIResource
    extends QuaquaNativeButtonStateBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(OSXAquaPainter.Widget widget) {
            super(widget);
        }

        public UIResource(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets) {
            super(widget, imageInsets, borderInsets);
        }
    }
}

