/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CompositeVisualMarginBorder
implements Border,
VisualMargin {
    private Border actualBorder;
    private Insets borderMargin;
    private boolean isTopFixed;
    private boolean isLeftFixed;
    private boolean isBottomFixed;
    private boolean isRightFixed;
    private String uiManagerPropertyName = "Component.visualMargin";
    private String propertyName = "Quaqua.Component.visualMargin";

    public CompositeVisualMarginBorder(Border actualBorder, int top, int left, int bottom, int right) {
        this(actualBorder, new Insets(top, left, bottom, right));
    }

    public CompositeVisualMarginBorder(Border actualBorder, int top, int left, int bottom, int right, boolean isTopFixed, boolean isLeftFixed, boolean isBottomFixed, boolean isRightFixed) {
        this(actualBorder, new Insets(top, left, bottom, right), isTopFixed, isLeftFixed, isBottomFixed, isRightFixed);
    }

    public CompositeVisualMarginBorder(Border actualBorder, Insets visualMargin) {
        this(actualBorder, visualMargin, false, false, false, false);
    }

    public CompositeVisualMarginBorder(Border actualBorder, Insets visualMargin, boolean isTopFixed, boolean isLeftFixed, boolean isBottomFixed, boolean isRightFixed) {
        this.actualBorder = actualBorder;
        this.borderMargin = visualMargin;
        this.isTopFixed = isTopFixed;
        this.isLeftFixed = isLeftFixed;
        this.isBottomFixed = isBottomFixed;
        this.isRightFixed = isRightFixed;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets vm = this.getVisualMargin(c, new Insets(0, 0, 0, 0));
        this.actualBorder.paintBorder(c, g, x + vm.left - this.borderMargin.left, y + vm.top - this.borderMargin.top, width - vm.left - vm.right + this.borderMargin.left + this.borderMargin.right, height - vm.top - vm.bottom + this.borderMargin.top + this.borderMargin.bottom);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets ins = this.getVisualMargin(c, insets);
        Insets bi = this.actualBorder.getBorderInsets(c);
        InsetsUtil.addTo(bi, ins);
        return ins;
    }

    @Override
    public final Insets getVisualMargin(Component c) {
        return this.getVisualMargin(c, new Insets(0, 0, 0, 0));
    }

    protected Insets getVisualMargin(Component c, Insets insets) {
        InsetsUtil.clear(insets);
        if (c instanceof JComponent) {
            Insets componentMargin = (Insets)((JComponent)c).getClientProperty(this.propertyName);
            if (componentMargin == null && this.propertyName != null) {
                componentMargin = UIManager.getInsets(this.uiManagerPropertyName);
            }
            if (componentMargin != null) {
                if (!this.isTopFixed) {
                    insets.top += componentMargin.top;
                }
                if (!this.isLeftFixed) {
                    insets.left += componentMargin.left;
                }
                if (!this.isBottomFixed) {
                    insets.bottom += componentMargin.bottom;
                }
                if (!this.isRightFixed) {
                    insets.right += componentMargin.right;
                }
            }
        }
        return insets;
    }
}

