/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.Methods;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class QuaquaTextComponentPopupHandler
extends MouseAdapter {
    private JPopupMenu popupMenu = new JPopupMenu();
    private AbstractAction cutAction = new DefaultEditorKit.CutAction();
    private AbstractAction copyAction;
    private AbstractAction pasteAction;

    public QuaquaTextComponentPopupHandler() {
        this.popupMenu.add(this.cutAction);
        this.copyAction = new DefaultEditorKit.CopyAction();
        this.popupMenu.add(this.copyAction);
        this.pasteAction = new DefaultEditorKit.PasteAction();
        this.popupMenu.add(this.pasteAction);
        this.cutAction.putValue("Name", UIManager.getString("TextComponent.cut"));
        this.copyAction.putValue("Name", UIManager.getString("TextComponent.copy"));
        this.pasteAction.putValue("Name", UIManager.getString("TextComponent.paste"));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    protected void showPopup(MouseEvent e) {
        JTextComponent src = (JTextComponent)e.getSource();
        boolean isFocusable = Methods.invokeGetter((Object)src, "isFocusable", true);
        if (src.getClientProperty("Quaqua.TextComponent.showPopup") != Boolean.FALSE && src.isEnabled() && isFocusable && Methods.invokeGetter((Object)src, "getComponentPopupMenu", null) == null) {
            this.cutAction.setEnabled(!(src instanceof JPasswordField) && src.getSelectionEnd() > src.getSelectionStart() && src.isEditable());
            this.copyAction.setEnabled(!(src instanceof JPasswordField) && src.getSelectionEnd() > src.getSelectionStart());
            this.pasteAction.setEnabled(src.isEditable());
            src.requestFocus();
            this.popupMenu.show(src, e.getX(), e.getY());
            e.consume();
        }
    }
}

