/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.AbstractFocusedPainter;
import ch.randelshofer.quaqua.border.ImageBevelBorder;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class QuaquaNativeScrollPaneBorder
extends VisualMarginBorder
implements UIResource {
    private static final int ARG_SMALL_SIZE = 32;
    private BufferedImage regularPainterImage;
    private BufferedImage smallPainterImage;
    private BufferedImage regularFocusImage;
    private BufferedImage smallFocusImage;
    private ImageBevelBorder regularIbb;
    private ImageBevelBorder smallIbb;
    private OSXAquaPainter painter = new OSXAquaPainter();
    private Insets imageInsets = new Insets(0, 0, 0, 0);
    private Insets borderInsets = new Insets(1, 1, 1, 1);

    @Override
    public void paintBorder(Component cc, Graphics g, int x, int y, int width, int height) {
        ImageBevelBorder ibb;
        BufferedImage focusImg;
        BufferedImage painterImg;
        int fixedYOffset;
        OSXAquaPainter.Size size;
        OSXAquaPainter.State state;
        boolean editable;
        JScrollPane sp;
        int args = 0;
        Component c = cc;
        if (c instanceof JScrollPane && (c = (sp = (JScrollPane)c).getViewport().getView()) == null) {
            c = sp;
        }
        JTextComponent b = c instanceof JTextComponent ? (JTextComponent)c : null;
        boolean bl = editable = b == null || b.isEditable();
        if (QuaquaUtilities.isOnActiveWindow(c)) {
            state = OSXAquaPainter.State.active;
            args |= 1;
        } else {
            state = OSXAquaPainter.State.inactive;
        }
        OSXAquaPainter.Widget widget = OSXAquaPainter.Widget.frameTextField;
        this.painter.setWidget(widget);
        if (!cc.isEnabled() || !editable) {
            state = OSXAquaPainter.State.disabled;
            args |= 4;
        }
        this.painter.setState(state);
        boolean isFocusedAndEditable = QuaquaUtilities.isFocused(c) && editable;
        args |= isFocusedAndEditable ? 16 : 0;
        this.painter.setValueByKey(OSXAquaPainter.Key.focused, isFocusedAndEditable ? 1.0 : 0.0);
        switch (QuaquaUtilities.getSizeVariant(c)) {
            default: {
                size = OSXAquaPainter.Size.regular;
                break;
            }
            case SMALL: {
                size = OSXAquaPainter.Size.small;
                args |= 0x20;
                break;
            }
            case MINI: {
                size = OSXAquaPainter.Size.small;
                args |= 0x20;
            }
        }
        this.painter.setSize(size);
        Insets vm = this.getVisualMargin(cc);
        int slack = 6;
        if ((args & 0x20) == 32) {
            int fixedWidth = 40 + slack * 2;
            int fixedHeight = 19 + slack * 2;
            fixedYOffset = 3;
            if (this.smallPainterImage == null) {
                this.smallPainterImage = new BufferedImage(fixedWidth, fixedHeight, 3);
            }
            painterImg = this.smallPainterImage;
            if (this.smallFocusImage == null) {
                this.smallFocusImage = new BufferedImage(fixedWidth, fixedHeight, 3);
            }
            focusImg = this.smallFocusImage;
            if (this.smallIbb == null) {
                BufferedImage ibbImg = new BufferedImage(fixedWidth, fixedHeight, 3);
                ibb = this.smallIbb = new ImageBevelBorder(ibbImg, new Insets(4 + slack, 4 + slack, 4 + slack, 4 + slack), new Insets(4 + slack, 4 + slack, 4 + slack, 4 + slack));
            } else {
                ibb = this.smallIbb;
            }
        } else {
            int fixedWidth = 40 + slack * 2;
            int fixedHeight = 22 + slack * 2;
            fixedYOffset = 3;
            if (this.regularPainterImage == null) {
                this.regularPainterImage = new BufferedImage(fixedWidth, fixedHeight, 3);
            }
            painterImg = this.regularPainterImage;
            if (this.regularFocusImage == null) {
                this.regularFocusImage = new BufferedImage(fixedWidth, fixedHeight, 3);
            }
            focusImg = this.regularFocusImage;
            if (this.regularIbb == null) {
                BufferedImage ibbImg = new BufferedImage(fixedWidth, fixedHeight, 3);
                ibb = this.regularIbb = new ImageBevelBorder(ibbImg, new Insets(8 + slack, 8 + slack, 8 + slack, 8 + slack), new Insets(8 + slack, 8 + slack, 8 + slack, 8 + slack));
            } else {
                ibb = this.regularIbb;
            }
        }
        BufferedImage ibbImg = (BufferedImage)ibb.getImage();
        Graphics2D pg = painterImg.createGraphics();
        pg.setColor(new Color(0, true));
        pg.setComposite(AlphaComposite.getInstance(2));
        pg.fillRect(0, 0, painterImg.getWidth(), painterImg.getHeight());
        pg.setComposite(AlphaComposite.getInstance(3));
        pg.dispose();
        this.painter.paint(painterImg, slack, fixedYOffset + slack, painterImg.getWidth() - 2 * slack, painterImg.getHeight() - 2 * slack);
        Graphics2D ibbg = ibbImg.createGraphics();
        ibbg.setColor(new Color(0, true));
        ibbg.setComposite(AlphaComposite.getInstance(2));
        ibbg.fillRect(0, 0, painterImg.getWidth(), painterImg.getHeight());
        ibbg.setComposite(AlphaComposite.getInstance(3));
        ibbg.drawImage((Image)painterImg, 0, 0, null);
        if (QuaquaUtilities.isFocused(c) && editable) {
            AbstractFocusedPainter.paintFocusRing(painterImg, focusImg, ibbg, 0, 0);
        }
        ibbg.dispose();
        ibb.paintBorder(c, g, x + this.imageInsets.left - slack + vm.left, y + this.imageInsets.top - slack + vm.top, width - this.imageInsets.left - this.imageInsets.right + 2 * slack - vm.left - vm.right, height - this.imageInsets.top - this.imageInsets.bottom + 2 * slack - vm.top - vm.bottom);
        ibbg.dispose();
        if (c instanceof JComponent) {
            Debug.paint(g, (JComponent)c, null);
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets ins = super.getBorderInsets(c, insets);
        InsetsUtil.addTo(this.borderInsets, ins);
        return ins;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

