/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.Timer;

public class QuaquaDefaultButtonAnimator {
    private static final HashSet<JButton> defaultButtons = new HashSet();
    private static final Timer timer = new Timer(30, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterator i = defaultButtons.iterator();
            while (i.hasNext()) {
                JButton b = (JButton)i.next();
                if (b.isDefaultButton() && QuaquaUtilities.isOnActiveWindow(b)) {
                    b.repaint();
                    continue;
                }
                i.remove();
            }
            if (defaultButtons.isEmpty()) {
                timer.stop();
            }
        }
    });

    public static void addDefaultButton(JButton b) {
        if (b.isDefaultButton() && QuaquaUtilities.isOnActiveWindow(b) && defaultButtons.add(b)) {
            timer.start();
        }
    }
}

