/*HEADER**********************************************************************
*
* Copyright 2014 Freescale Semiconductor, Inc.
*
* This software is owned or controlled by Freescale Semiconductor.
* Use of this software is governed by the Freescale MQX RTOS License
* distributed with this Material.
* See the MQX_RTOS_LICENSE file distributed for more details.
*
* Brief License Summary:
* This software is provided in source form for you to use free of charge,
* but it is not open source software. You are allowed to use this software
* but you cannot redistribute it or derivative works of it in source form.
* The software may be used only in connection with a product containing
* a Freescale microprocessor, microcontroller, or digital signal processor.
* See license agreement file for full license terms including other
* restrictions.
*****************************************************************************
*
* Comments:
*
*   The file contains definitions used in user program and/or in other
*   kernel modules to access GPIO pins
*
*
*END************************************************************************/
#ifndef __lwgpio_igpio_h__
#define __lwgpio_igpio_h__ 1

#define LWGPIO_PIN_VALID (0x80000000) /* Note: this is for backwards compatibility with GPIO driver only */

/* Pin field definitions */
#define LWGPIO_PIN_SHIFT (0)
#define LWGPIO_PIN_MASK  (0x1F << LWGPIO_PIN_SHIFT)

#define LWGPIO_PIN(x)    (((x) << LWGPIO_PIN_SHIFT) & LWGPIO_PIN_MASK)

/* Pin attributes */
#define LWGPIO_ATTR_BASE            (0x100)
#define LWGPIO_ATTR_SLEW_RATE       (LWGPIO_ATTR_BASE+1)
#define LWGPIO_ATTR_DRIVE_STRENGTH  (LWGPIO_ATTR_BASE+2)

/*attributes value*/
#define LWGPIO_AVAL_SLEW_RATE_FAST          (0)
#define LWGPIO_AVAL_SLEW_RATE_SLOW          (1)

#define LWGPIO_AVAL_DRIVE_STRENGTH_HIZ      (0)
#define LWGPIO_AVAL_DRIVE_STRENGTH_260_OHM  (1)
#define LWGPIO_AVAL_DRIVE_STRENGTH_130_OHM  (2)
#define LWGPIO_AVAL_DRIVE_STRENGTH_87_OHM   (3)
#define LWGPIO_AVAL_DRIVE_STRENGTH_65_OHM   (4)
#define LWGPIO_AVAL_DRIVE_STRENGTH_52_OHM   (5)
#define LWGPIO_AVAL_DRIVE_STRENGTH_43_OHM   (6)
#define LWGPIO_AVAL_DRIVE_STRENGTH_37_OHM   (7)

/* Port field definitions */
#define LWGPIO_PORT_SHIFT (5)
#define LWGPIO_PORT_MASK  (0xFF << LWGPIO_PORT_SHIFT)
#define LWGPIO_PORT(x)    (((x) << LWGPIO_PORT_SHIFT) & LWGPIO_PORT_MASK)
#define LWGPIO_PORT1      (LWGPIO_PORT(1) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT2      (LWGPIO_PORT(2) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT3      (LWGPIO_PORT(3) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT4      (LWGPIO_PORT(4) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT5      (LWGPIO_PORT(5) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT6      (LWGPIO_PORT(6) | LWGPIO_PIN_VALID)
#define LWGPIO_PORT7      (LWGPIO_PORT(7) | LWGPIO_PIN_VALID)

#define LWGPIO_PIN0       (0)
#define LWGPIO_PIN1       (1)
#define LWGPIO_PIN2       (2)
#define LWGPIO_PIN3       (3)
#define LWGPIO_PIN4       (4)
#define LWGPIO_PIN5       (5)
#define LWGPIO_PIN6       (6)
#define LWGPIO_PIN7       (7)
#define LWGPIO_PIN8       (8)
#define LWGPIO_PIN9       (9)
#define LWGPIO_PIN10      (10)
#define LWGPIO_PIN11      (11)
#define LWGPIO_PIN12      (12)
#define LWGPIO_PIN13      (13)
#define LWGPIO_PIN14      (14)
#define LWGPIO_PIN15      (15)
#define LWGPIO_PIN16      (16)
#define LWGPIO_PIN17      (17)
#define LWGPIO_PIN18      (18)
#define LWGPIO_PIN19      (19)
#define LWGPIO_PIN20      (20)
#define LWGPIO_PIN21      (21)
#define LWGPIO_PIN22      (22)
#define LWGPIO_PIN23      (23)
#define LWGPIO_PIN24      (24)
#define LWGPIO_PIN25      (25)
#define LWGPIO_PIN26      (26)
#define LWGPIO_PIN27      (27)
#define LWGPIO_PIN28      (28)
#define LWGPIO_PIN29      (29)
#define LWGPIO_PIN30      (30)
#define LWGPIO_PIN31      (31)

typedef struct {
    volatile uint32_t    *iomuxc_pad_reg;
    volatile uint32_t    *iomuxc_mux_reg;
    GPIO_MemMapPtr        gpio_ptr;
    uint32_t              pinmask; /* since struct holds one pin, pinmask will have only one bit set */
    uint32_t              flags;
} LWGPIO_STRUCT, * LWGPIO_STRUCT_PTR;

#define LWGPIO_MUX_PORT1_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT1_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN11_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN19_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN20_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN21_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN22_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN23_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN24_GPIO     (5)
#define LWGPIO_MUX_PORT1_PIN25_GPIO     (5)

#define LWGPIO_MUX_PORT2_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT2_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN11_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT2_PIN19_GPIO     (5)

#define LWGPIO_MUX_PORT3_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT3_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN11_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN19_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN20_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN21_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN22_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN23_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN24_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN25_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN26_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN27_GPIO     (5)
#define LWGPIO_MUX_PORT3_PIN28_GPIO     (5)

#define LWGPIO_MUX_PORT4_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT4_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN11_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN19_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN20_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN21_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN22_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN23_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN24_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN25_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN26_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN27_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN28_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN29_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN30_GPIO     (5)
#define LWGPIO_MUX_PORT4_PIN31_GPIO     (5)

#define LWGPIO_MUX_PORT5_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT5_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN11_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN19_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN20_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN21_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN22_GPIO     (5)
#define LWGPIO_MUX_PORT5_PIN23_GPIO     (5)

#define LWGPIO_MUX_PORT6_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN9_GPIO      (5)
#define LWGPIO_MUX_PORT6_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN11_GPIO     (5)
/* discontinuous */
#define LWGPIO_MUX_PORT6_PIN12_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN13_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN14_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN15_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN16_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN17_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN18_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN19_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN20_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN21_GPIO     (5)
#define LWGPIO_MUX_PORT6_PIN22_GPIO     (5)


#define LWGPIO_MUX_PORT7_PIN0_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN1_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN2_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN3_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN4_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN5_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN6_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN7_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN8_GPIO      (5)
#define LWGPIO_MUX_PORT7_PIN9_GPIO      (5)
/* discontinuous */
#define LWGPIO_MUX_PORT7_PIN10_GPIO     (5)
#define LWGPIO_MUX_PORT7_PIN11_GPIO     (5)


/* GPIO PIN definition */
#define LWGPIO_PIN_GPIO1_IO00       (LWGPIO_PORT1 | LWGPIO_PIN0)
#define LWGPIO_PIN_GPIO1_IO01       (LWGPIO_PORT1 | LWGPIO_PIN1)
#define LWGPIO_PIN_GPIO1_IO02       (LWGPIO_PORT1 | LWGPIO_PIN2)
#define LWGPIO_PIN_GPIO1_IO03       (LWGPIO_PORT1 | LWGPIO_PIN3)
#define LWGPIO_PIN_GPIO1_IO04       (LWGPIO_PORT1 | LWGPIO_PIN4)
#define LWGPIO_PIN_GPIO1_IO05       (LWGPIO_PORT1 | LWGPIO_PIN5)
#define LWGPIO_PIN_GPIO1_IO06       (LWGPIO_PORT1 | LWGPIO_PIN6)
#define LWGPIO_PIN_GPIO1_IO07       (LWGPIO_PORT1 | LWGPIO_PIN7)
#define LWGPIO_PIN_GPIO1_IO08       (LWGPIO_PORT1 | LWGPIO_PIN8)
#define LWGPIO_PIN_GPIO1_IO09       (LWGPIO_PORT1 | LWGPIO_PIN9)
#define LWGPIO_PIN_GPIO1_IO10       (LWGPIO_PORT1 | LWGPIO_PIN10)
#define LWGPIO_PIN_GPIO1_IO11       (LWGPIO_PORT1 | LWGPIO_PIN11)
#define LWGPIO_PIN_GPIO1_IO12       (LWGPIO_PORT1 | LWGPIO_PIN12)
#define LWGPIO_PIN_GPIO1_IO13       (LWGPIO_PORT1 | LWGPIO_PIN13)
#define LWGPIO_PIN_CSI_DATA00       (LWGPIO_PORT1 | LWGPIO_PIN14)
#define LWGPIO_PIN_CSI_DATA01       (LWGPIO_PORT1 | LWGPIO_PIN15)
#define LWGPIO_PIN_CSI_DATA02       (LWGPIO_PORT1 | LWGPIO_PIN16)
#define LWGPIO_PIN_CSI_DATA03       (LWGPIO_PORT1 | LWGPIO_PIN17)
#define LWGPIO_PIN_CSI_DATA04       (LWGPIO_PORT1 | LWGPIO_PIN18)
#define LWGPIO_PIN_CSI_DATA05       (LWGPIO_PORT1 | LWGPIO_PIN19)
#define LWGPIO_PIN_CSI_DATA06       (LWGPIO_PORT1 | LWGPIO_PIN20)
#define LWGPIO_PIN_CSI_DATA07       (LWGPIO_PORT1 | LWGPIO_PIN21)
#define LWGPIO_PIN_CSI_HSYNC        (LWGPIO_PORT1 | LWGPIO_PIN22)
#define LWGPIO_PIN_CSI_MCLK         (LWGPIO_PORT1 | LWGPIO_PIN23)
#define LWGPIO_PIN_CSI_PIXCLK       (LWGPIO_PORT1 | LWGPIO_PIN24)
#define LWGPIO_PIN_CSI_VSYNC        (LWGPIO_PORT1 | LWGPIO_PIN25)

#define LWGPIO_PIN_ENET1_COL        (LWGPIO_PORT2 | LWGPIO_PIN0)
#define LWGPIO_PIN_ENET1_CRS        (LWGPIO_PORT2 | LWGPIO_PIN1)
#define LWGPIO_PIN_ENET1_MDC        (LWGPIO_PORT2 | LWGPIO_PIN2)
#define LWGPIO_PIN_ENET1_MDIO       (LWGPIO_PORT2 | LWGPIO_PIN3)
#define LWGPIO_PIN_ENET1_RX_CLK     (LWGPIO_PORT2 | LWGPIO_PIN4)
#define LWGPIO_PIN_ENET1_TX_CLK     (LWGPIO_PORT2 | LWGPIO_PIN5)
#define LWGPIO_PIN_ENET2_COL        (LWGPIO_PORT2 | LWGPIO_PIN6)
#define LWGPIO_PIN_ENET2_CRS        (LWGPIO_PORT2 | LWGPIO_PIN7)
#define LWGPIO_PIN_ENET2_RX_CLK     (LWGPIO_PORT2 | LWGPIO_PIN8)
#define LWGPIO_PIN_ENET2_TX_CLK     (LWGPIO_PORT2 | LWGPIO_PIN9)
#define LWGPIO_PIN_KEY_COL0         (LWGPIO_PORT2 | LWGPIO_PIN10)
#define LWGPIO_PIN_KEY_COL1         (LWGPIO_PORT2 | LWGPIO_PIN11)
#define LWGPIO_PIN_KEY_COL2         (LWGPIO_PORT2 | LWGPIO_PIN12)
#define LWGPIO_PIN_KEY_COL3         (LWGPIO_PORT2 | LWGPIO_PIN13)
#define LWGPIO_PIN_KEY_COL4         (LWGPIO_PORT2 | LWGPIO_PIN14)
#define LWGPIO_PIN_KEY_ROW0         (LWGPIO_PORT2 | LWGPIO_PIN15)
#define LWGPIO_PIN_KEY_ROW1         (LWGPIO_PORT2 | LWGPIO_PIN16)
#define LWGPIO_PIN_KEY_ROW2         (LWGPIO_PORT2 | LWGPIO_PIN17)
#define LWGPIO_PIN_KEY_ROW3         (LWGPIO_PORT2 | LWGPIO_PIN18)
#define LWGPIO_PIN_KEY_ROW4         (LWGPIO_PORT2 | LWGPIO_PIN19)

#define LWGPIO_PIN_LCD1_CLK         (LWGPIO_PORT3 | LWGPIO_PIN0)
#define LWGPIO_PIN_LCD1_DATA00      (LWGPIO_PORT3 | LWGPIO_PIN1)
#define LWGPIO_PIN_LCD1_DATA01      (LWGPIO_PORT3 | LWGPIO_PIN2)
#define LWGPIO_PIN_LCD1_DATA02      (LWGPIO_PORT3 | LWGPIO_PIN3)
#define LWGPIO_PIN_LCD1_DATA03      (LWGPIO_PORT3 | LWGPIO_PIN4)
#define LWGPIO_PIN_LCD1_DATA04      (LWGPIO_PORT3 | LWGPIO_PIN5)
#define LWGPIO_PIN_LCD1_DATA05      (LWGPIO_PORT3 | LWGPIO_PIN6)
#define LWGPIO_PIN_LCD1_DATA06      (LWGPIO_PORT3 | LWGPIO_PIN7)
#define LWGPIO_PIN_LCD1_DATA07      (LWGPIO_PORT3 | LWGPIO_PIN8)
#define LWGPIO_PIN_LCD1_DATA08      (LWGPIO_PORT3 | LWGPIO_PIN9)
#define LWGPIO_PIN_LCD1_DATA09      (LWGPIO_PORT3 | LWGPIO_PIN10)
#define LWGPIO_PIN_LCD1_DATA10      (LWGPIO_PORT3 | LWGPIO_PIN11)
#define LWGPIO_PIN_LCD1_DATA11      (LWGPIO_PORT3 | LWGPIO_PIN12)
#define LWGPIO_PIN_LCD1_DATA12      (LWGPIO_PORT3 | LWGPIO_PIN13)
#define LWGPIO_PIN_LCD1_DATA13      (LWGPIO_PORT3 | LWGPIO_PIN14)
#define LWGPIO_PIN_LCD1_DATA14      (LWGPIO_PORT3 | LWGPIO_PIN15)
#define LWGPIO_PIN_LCD1_DATA15      (LWGPIO_PORT3 | LWGPIO_PIN16)
#define LWGPIO_PIN_LCD1_DATA16      (LWGPIO_PORT3 | LWGPIO_PIN17)
#define LWGPIO_PIN_LCD1_DATA17      (LWGPIO_PORT3 | LWGPIO_PIN18)
#define LWGPIO_PIN_LCD1_DATA18      (LWGPIO_PORT3 | LWGPIO_PIN19)
#define LWGPIO_PIN_LCD1_DATA19      (LWGPIO_PORT3 | LWGPIO_PIN20)
#define LWGPIO_PIN_LCD1_DATA20      (LWGPIO_PORT3 | LWGPIO_PIN21)
#define LWGPIO_PIN_LCD1_DATA21      (LWGPIO_PORT3 | LWGPIO_PIN22)
#define LWGPIO_PIN_LCD1_DATA22      (LWGPIO_PORT3 | LWGPIO_PIN23)
#define LWGPIO_PIN_LCD1_DATA23      (LWGPIO_PORT3 | LWGPIO_PIN24)
#define LWGPIO_PIN_LCD1_ENABLE      (LWGPIO_PORT3 | LWGPIO_PIN25)
#define LWGPIO_PIN_LCD1_HSYNC       (LWGPIO_PORT3 | LWGPIO_PIN26)
#define LWGPIO_PIN_LCD1_RESET       (LWGPIO_PORT3 | LWGPIO_PIN27)
#define LWGPIO_PIN_LCD1_VSYNC       (LWGPIO_PORT3 | LWGPIO_PIN28)

#define LWGPIO_PIN_NAND_ALE         (LWGPIO_PORT4 | LWGPIO_PIN0)
#define LWGPIO_PIN_NAND_CE0_B       (LWGPIO_PORT4 | LWGPIO_PIN1)
#define LWGPIO_PIN_NAND_CE1_B       (LWGPIO_PORT4 | LWGPIO_PIN2)
#define LWGPIO_PIN_NAND_CLE         (LWGPIO_PORT4 | LWGPIO_PIN3)
#define LWGPIO_PIN_NAND_DATA00      (LWGPIO_PORT4 | LWGPIO_PIN4)
#define LWGPIO_PIN_NAND_DATA01      (LWGPIO_PORT4 | LWGPIO_PIN5)
#define LWGPIO_PIN_NAND_DATA02      (LWGPIO_PORT4 | LWGPIO_PIN6)
#define LWGPIO_PIN_NAND_DATA03      (LWGPIO_PORT4 | LWGPIO_PIN7)
#define LWGPIO_PIN_NAND_DATA04      (LWGPIO_PORT4 | LWGPIO_PIN8)
#define LWGPIO_PIN_NAND_DATA05      (LWGPIO_PORT4 | LWGPIO_PIN9)
#define LWGPIO_PIN_NAND_DATA06      (LWGPIO_PORT4 | LWGPIO_PIN10)
#define LWGPIO_PIN_NAND_DATA07      (LWGPIO_PORT4 | LWGPIO_PIN11)
#define LWGPIO_PIN_NAND_RE_B        (LWGPIO_PORT4 | LWGPIO_PIN12)
#define LWGPIO_PIN_NAND_READY_B     (LWGPIO_PORT4 | LWGPIO_PIN13)
#define LWGPIO_PIN_NAND_WE_B        (LWGPIO_PORT4 | LWGPIO_PIN14)
#define LWGPIO_PIN_NAND_WP_B        (LWGPIO_PORT4 | LWGPIO_PIN15)
#define LWGPIO_PIN_QSPI1A_DATA0     (LWGPIO_PORT4 | LWGPIO_PIN16)
#define LWGPIO_PIN_QSPI1A_DATA1     (LWGPIO_PORT4 | LWGPIO_PIN17)
#define LWGPIO_PIN_QSPI1A_DATA2     (LWGPIO_PORT4 | LWGPIO_PIN18)
#define LWGPIO_PIN_QSPI1A_DATA3     (LWGPIO_PORT4 | LWGPIO_PIN19)
#define LWGPIO_PIN_QSPI1A_DQS       (LWGPIO_PORT4 | LWGPIO_PIN20)
#define LWGPIO_PIN_QSPI1A_SCLK      (LWGPIO_PORT4 | LWGPIO_PIN21)
#define LWGPIO_PIN_QSPI1A_SS0_B     (LWGPIO_PORT4 | LWGPIO_PIN22)
#define LWGPIO_PIN_QSPI1A_SS1_B     (LWGPIO_PORT4 | LWGPIO_PIN23)
#define LWGPIO_PIN_QSPI1B_DATA0     (LWGPIO_PORT4 | LWGPIO_PIN24)
#define LWGPIO_PIN_QSPI1B_DATA1     (LWGPIO_PORT4 | LWGPIO_PIN25)
#define LWGPIO_PIN_QSPI1B_DATA2     (LWGPIO_PORT4 | LWGPIO_PIN26)
#define LWGPIO_PIN_QSPI1B_DATA3     (LWGPIO_PORT4 | LWGPIO_PIN27)
#define LWGPIO_PIN_QSPI1B_DQS       (LWGPIO_PORT4 | LWGPIO_PIN28)
#define LWGPIO_PIN_QSPI1B_SCLK      (LWGPIO_PORT4 | LWGPIO_PIN29)
#define LWGPIO_PIN_QSPI1B_SS0_B     (LWGPIO_PORT4 | LWGPIO_PIN30)
#define LWGPIO_PIN_QSPI1B_SS1_B     (LWGPIO_PORT4 | LWGPIO_PIN31)

#define LWGPIO_PIN_RGMII1_RD0       (LWGPIO_PORT5 | LWGPIO_PIN0)
#define LWGPIO_PIN_RGMII1_RD1       (LWGPIO_PORT5 | LWGPIO_PIN1)
#define LWGPIO_PIN_RGMII1_RD2       (LWGPIO_PORT5 | LWGPIO_PIN2)
#define LWGPIO_PIN_RGMII1_RD3       (LWGPIO_PORT5 | LWGPIO_PIN3)
#define LWGPIO_PIN_RGMII1_RX_CTL    (LWGPIO_PORT5 | LWGPIO_PIN4)
#define LWGPIO_PIN_RGMII1_RXC       (LWGPIO_PORT5 | LWGPIO_PIN5)
#define LWGPIO_PIN_RGMII1_TD0       (LWGPIO_PORT5 | LWGPIO_PIN6)
#define LWGPIO_PIN_RGMII1_TD1       (LWGPIO_PORT5 | LWGPIO_PIN7)
#define LWGPIO_PIN_RGMII1_TD2       (LWGPIO_PORT5 | LWGPIO_PIN8)
#define LWGPIO_PIN_RGMII1_TD3       (LWGPIO_PORT5 | LWGPIO_PIN9)
#define LWGPIO_PIN_RGMII1_TX_CTL    (LWGPIO_PORT5 | LWGPIO_PIN10)
#define LWGPIO_PIN_RGMII1_TXC       (LWGPIO_PORT5 | LWGPIO_PIN11)
#define LWGPIO_PIN_RGMII2_RD0       (LWGPIO_PORT5 | LWGPIO_PIN12)
#define LWGPIO_PIN_RGMII2_RD1       (LWGPIO_PORT5 | LWGPIO_PIN13)
#define LWGPIO_PIN_RGMII2_RD2       (LWGPIO_PORT5 | LWGPIO_PIN14)
#define LWGPIO_PIN_RGMII2_RD3       (LWGPIO_PORT5 | LWGPIO_PIN15)
#define LWGPIO_PIN_RGMII2_RX_CTL    (LWGPIO_PORT5 | LWGPIO_PIN16)
#define LWGPIO_PIN_RGMII2_RXC       (LWGPIO_PORT5 | LWGPIO_PIN17)
#define LWGPIO_PIN_RGMII2_TD0       (LWGPIO_PORT5 | LWGPIO_PIN18)
#define LWGPIO_PIN_RGMII2_TD1       (LWGPIO_PORT5 | LWGPIO_PIN19)
#define LWGPIO_PIN_RGMII2_TD2       (LWGPIO_PORT5 | LWGPIO_PIN20)
#define LWGPIO_PIN_RGMII2_TD3       (LWGPIO_PORT5 | LWGPIO_PIN21)
#define LWGPIO_PIN_RGMII2_TX_CTL    (LWGPIO_PORT5 | LWGPIO_PIN22)
#define LWGPIO_PIN_RGMII2_TXC       (LWGPIO_PORT5 | LWGPIO_PIN23)

#define LWGPIO_PIN_SD1_CLK          (LWGPIO_PORT6 | LWGPIO_PIN0)
#define LWGPIO_PIN_SD1_CMD          (LWGPIO_PORT6 | LWGPIO_PIN1)
#define LWGPIO_PIN_SD1_DATA0        (LWGPIO_PORT6 | LWGPIO_PIN2)
#define LWGPIO_PIN_SD1_DATA1        (LWGPIO_PORT6 | LWGPIO_PIN3)
#define LWGPIO_PIN_SD1_DATA2        (LWGPIO_PORT6 | LWGPIO_PIN4)
#define LWGPIO_PIN_SD1_DATA3        (LWGPIO_PORT6 | LWGPIO_PIN5)
#define LWGPIO_PIN_SD2_CLK          (LWGPIO_PORT6 | LWGPIO_PIN6)
#define LWGPIO_PIN_SD2_CMD          (LWGPIO_PORT6 | LWGPIO_PIN7)
#define LWGPIO_PIN_SD2_DATA0        (LWGPIO_PORT6 | LWGPIO_PIN8)
#define LWGPIO_PIN_SD2_DATA1        (LWGPIO_PORT6 | LWGPIO_PIN9)
#define LWGPIO_PIN_SD2_DATA2        (LWGPIO_PORT6 | LWGPIO_PIN10)
#define LWGPIO_PIN_SD2_DATA3        (LWGPIO_PORT6 | LWGPIO_PIN11)

#define LWGPIO_PIN_SD3_CLK          (LWGPIO_PORT7 | LWGPIO_PIN0)
#define LWGPIO_PIN_SD3_CMD          (LWGPIO_PORT7 | LWGPIO_PIN1)
#define LWGPIO_PIN_SD3_DATA0        (LWGPIO_PORT7 | LWGPIO_PIN2)
#define LWGPIO_PIN_SD3_DATA1        (LWGPIO_PORT7 | LWGPIO_PIN3)
#define LWGPIO_PIN_SD3_DATA2        (LWGPIO_PORT7 | LWGPIO_PIN4)
#define LWGPIO_PIN_SD3_DATA3        (LWGPIO_PORT7 | LWGPIO_PIN5)
#define LWGPIO_PIN_SD3_DATA4        (LWGPIO_PORT7 | LWGPIO_PIN6)
#define LWGPIO_PIN_SD3_DATA5        (LWGPIO_PORT7 | LWGPIO_PIN7)
#define LWGPIO_PIN_SD3_DATA6        (LWGPIO_PORT7 | LWGPIO_PIN8)
#define LWGPIO_PIN_SD3_DATA7        (LWGPIO_PORT7 | LWGPIO_PIN9)

#define LWGPIO_PIN_SD4_CLK          (LWGPIO_PORT6 | LWGPIO_PIN12)
#define LWGPIO_PIN_SD4_CMD          (LWGPIO_PORT6 | LWGPIO_PIN13)
#define LWGPIO_PIN_SD4_DATA0        (LWGPIO_PORT6 | LWGPIO_PIN14)
#define LWGPIO_PIN_SD4_DATA1        (LWGPIO_PORT6 | LWGPIO_PIN15)
#define LWGPIO_PIN_SD4_DATA2        (LWGPIO_PORT6 | LWGPIO_PIN16)
#define LWGPIO_PIN_SD4_DATA3        (LWGPIO_PORT6 | LWGPIO_PIN17)
#define LWGPIO_PIN_SD4_DATA4        (LWGPIO_PORT6 | LWGPIO_PIN18)
#define LWGPIO_PIN_SD4_DATA5        (LWGPIO_PORT6 | LWGPIO_PIN19)
#define LWGPIO_PIN_SD4_DATA6        (LWGPIO_PORT6 | LWGPIO_PIN20)
#define LWGPIO_PIN_SD4_DATA7        (LWGPIO_PORT6 | LWGPIO_PIN21)
#define LWGPIO_PIN_SD4_RESET_B      (LWGPIO_PORT6 | LWGPIO_PIN22)

#define LWGPIO_PIN_USB_H_DATA       (LWGPIO_PORT7 | LWGPIO_PIN10)
#define LWGPIO_PIN_USB_H_STROBE     (LWGPIO_PORT7 | LWGPIO_PIN11)

/* GPIO MUX definition */
#define LWGPIO_MUX_GPIO1_IO00_GPIO       (LWGPIO_MUX_PORT1_PIN0_GPIO)
#define LWGPIO_MUX_GPIO1_IO01_GPIO       (LWGPIO_MUX_PORT1_PIN1_GPIO)
#define LWGPIO_MUX_GPIO1_IO02_GPIO       (LWGPIO_MUX_PORT1_PIN2_GPIO)
#define LWGPIO_MUX_GPIO1_IO03_GPIO       (LWGPIO_MUX_PORT1_PIN3_GPIO)
#define LWGPIO_MUX_GPIO1_IO04_GPIO       (LWGPIO_MUX_PORT1_PIN4_GPIO)
#define LWGPIO_MUX_GPIO1_IO05_GPIO       (LWGPIO_MUX_PORT1_PIN5_GPIO)
#define LWGPIO_MUX_GPIO1_IO06_GPIO       (LWGPIO_MUX_PORT1_PIN6_GPIO)
#define LWGPIO_MUX_GPIO1_IO07_GPIO       (LWGPIO_MUX_PORT1_PIN7_GPIO)
#define LWGPIO_MUX_GPIO1_IO08_GPIO       (LWGPIO_MUX_PORT1_PIN8_GPIO)
#define LWGPIO_MUX_GPIO1_IO09_GPIO       (LWGPIO_MUX_PORT1_PIN9_GPIO)
#define LWGPIO_MUX_GPIO1_IO10_GPIO       (LWGPIO_MUX_PORT1_PIN10_GPIO)
#define LWGPIO_MUX_GPIO1_IO11_GPIO       (LWGPIO_MUX_PORT1_PIN11_GPIO)
#define LWGPIO_MUX_GPIO1_IO12_GPIO       (LWGPIO_MUX_PORT1_PIN12_GPIO)
#define LWGPIO_MUX_GPIO1_IO13_GPIO       (LWGPIO_MUX_PORT1_PIN13_GPIO)
#define LWGPIO_MUX_CSI_DATA00_GPIO       (LWGPIO_MUX_PORT1_PIN14_GPIO)
#define LWGPIO_MUX_CSI_DATA01_GPIO       (LWGPIO_MUX_PORT1_PIN15_GPIO)
#define LWGPIO_MUX_CSI_DATA02_GPIO       (LWGPIO_MUX_PORT1_PIN16_GPIO)
#define LWGPIO_MUX_CSI_DATA03_GPIO       (LWGPIO_MUX_PORT1_PIN17_GPIO)
#define LWGPIO_MUX_CSI_DATA04_GPIO       (LWGPIO_MUX_PORT1_PIN18_GPIO)
#define LWGPIO_MUX_CSI_DATA05_GPIO       (LWGPIO_MUX_PORT1_PIN19_GPIO)
#define LWGPIO_MUX_CSI_DATA06_GPIO       (LWGPIO_MUX_PORT1_PIN20_GPIO)
#define LWGPIO_MUX_CSI_DATA07_GPIO       (LWGPIO_MUX_PORT1_PIN21_GPIO)
#define LWGPIO_MUX_CSI_HSYNC_GPIO        (LWGPIO_MUX_PORT1_PIN22_GPIO)
#define LWGPIO_MUX_CSI_MCLK_GPIO         (LWGPIO_MUX_PORT1_PIN23_GPIO)
#define LWGPIO_MUX_CSI_PIXCLK_GPIO       (LWGPIO_MUX_PORT1_PIN24_GPIO)
#define LWGPIO_MUX_CSI_VSYNC_GPIO        (LWGPIO_MUX_PORT1_PIN25_GPIO)

#define LWGPIO_MUX_ENET1_COL_GPIO        (LWGPIO_MUX_PORT2_PIN0_GPIO)
#define LWGPIO_MUX_ENET1_CRS_GPIO        (LWGPIO_MUX_PORT2_PIN1_GPIO)
#define LWGPIO_MUX_ENET1_MDC_GPIO        (LWGPIO_MUX_PORT2_PIN2_GPIO)
#define LWGPIO_MUX_ENET1_MDIO_GPIO       (LWGPIO_MUX_PORT2_PIN3_GPIO)
#define LWGPIO_MUX_ENET1_RX_CLK_GPIO     (LWGPIO_MUX_PORT2_PIN4_GPIO)
#define LWGPIO_MUX_ENET1_TX_CLK_GPIO     (LWGPIO_MUX_PORT2_PIN5_GPIO)
#define LWGPIO_MUX_ENET2_COL_GPIO        (LWGPIO_MUX_PORT2_PIN6_GPIO)
#define LWGPIO_MUX_ENET2_CRS_GPIO        (LWGPIO_MUX_PORT2_PIN7_GPIO)
#define LWGPIO_MUX_ENET2_RX_CLK_GPIO     (LWGPIO_MUX_PORT2_PIN8_GPIO)
#define LWGPIO_MUX_ENET2_TX_CLK_GPIO     (LWGPIO_MUX_PORT2_PIN9_GPIO)
#define LWGPIO_MUX_KEY_COL0_GPIO         (LWGPIO_MUX_PORT2_PIN10_GPIO)
#define LWGPIO_MUX_KEY_COL1_GPIO         (LWGPIO_MUX_PORT2_PIN11_GPIO)
#define LWGPIO_MUX_KEY_COL2_GPIO         (LWGPIO_MUX_PORT2_PIN12_GPIO)
#define LWGPIO_MUX_KEY_COL3_GPIO         (LWGPIO_MUX_PORT2_PIN13_GPIO)
#define LWGPIO_MUX_KEY_COL4_GPIO         (LWGPIO_MUX_PORT2_PIN14_GPIO)
#define LWGPIO_MUX_KEY_ROW0_GPIO         (LWGPIO_MUX_PORT2_PIN15_GPIO)
#define LWGPIO_MUX_KEY_ROW1_GPIO         (LWGPIO_MUX_PORT2_PIN16_GPIO)
#define LWGPIO_MUX_KEY_ROW2_GPIO         (LWGPIO_MUX_PORT2_PIN17_GPIO)
#define LWGPIO_MUX_KEY_ROW3_GPIO         (LWGPIO_MUX_PORT2_PIN18_GPIO)
#define LWGPIO_MUX_KEY_ROW4_GPIO         (LWGPIO_MUX_PORT2_PIN19_GPIO)

#define LWGPIO_MUX_LCD1_CLK_GPIO         (LWGPIO_MUX_PORT3_PIN0_GPIO)
#define LWGPIO_MUX_LCD1_DATA00_GPIO      (LWGPIO_MUX_PORT3_PIN1_GPIO)
#define LWGPIO_MUX_LCD1_DATA01_GPIO      (LWGPIO_MUX_PORT3_PIN2_GPIO)
#define LWGPIO_MUX_LCD1_DATA02_GPIO      (LWGPIO_MUX_PORT3_PIN3_GPIO)
#define LWGPIO_MUX_LCD1_DATA03_GPIO      (LWGPIO_MUX_PORT3_PIN4_GPIO)
#define LWGPIO_MUX_LCD1_DATA04_GPIO      (LWGPIO_MUX_PORT3_PIN5_GPIO)
#define LWGPIO_MUX_LCD1_DATA05_GPIO      (LWGPIO_MUX_PORT3_PIN6_GPIO)
#define LWGPIO_MUX_LCD1_DATA06_GPIO      (LWGPIO_MUX_PORT3_PIN7_GPIO)
#define LWGPIO_MUX_LCD1_DATA07_GPIO      (LWGPIO_MUX_PORT3_PIN8_GPIO)
#define LWGPIO_MUX_LCD1_DATA08_GPIO      (LWGPIO_MUX_PORT3_PIN9_GPIO)
#define LWGPIO_MUX_LCD1_DATA09_GPIO      (LWGPIO_MUX_PORT3_PIN10_GPIO)
#define LWGPIO_MUX_LCD1_DATA10_GPIO      (LWGPIO_MUX_PORT3_PIN11_GPIO)
#define LWGPIO_MUX_LCD1_DATA11_GPIO      (LWGPIO_MUX_PORT3_PIN12_GPIO)
#define LWGPIO_MUX_LCD1_DATA12_GPIO      (LWGPIO_MUX_PORT3_PIN13_GPIO)
#define LWGPIO_MUX_LCD1_DATA13_GPIO      (LWGPIO_MUX_PORT3_PIN14_GPIO)
#define LWGPIO_MUX_LCD1_DATA14_GPIO      (LWGPIO_MUX_PORT3_PIN15_GPIO)
#define LWGPIO_MUX_LCD1_DATA15_GPIO      (LWGPIO_MUX_PORT3_PIN16_GPIO)
#define LWGPIO_MUX_LCD1_DATA16_GPIO      (LWGPIO_MUX_PORT3_PIN17_GPIO)
#define LWGPIO_MUX_LCD1_DATA17_GPIO      (LWGPIO_MUX_PORT3_PIN18_GPIO)
#define LWGPIO_MUX_LCD1_DATA18_GPIO      (LWGPIO_MUX_PORT3_PIN19_GPIO)
#define LWGPIO_MUX_LCD1_DATA19_GPIO      (LWGPIO_MUX_PORT3_PIN20_GPIO)
#define LWGPIO_MUX_LCD1_DATA20_GPIO      (LWGPIO_MUX_PORT3_PIN21_GPIO)
#define LWGPIO_MUX_LCD1_DATA21_GPIO      (LWGPIO_MUX_PORT3_PIN22_GPIO)
#define LWGPIO_MUX_LCD1_DATA22_GPIO      (LWGPIO_MUX_PORT3_PIN23_GPIO)
#define LWGPIO_MUX_LCD1_DATA23_GPIO      (LWGPIO_MUX_PORT3_PIN24_GPIO)
#define LWGPIO_MUX_LCD1_ENABLE_GPIO      (LWGPIO_MUX_PORT3_PIN25_GPIO)
#define LWGPIO_MUX_LCD1_HSYNC_GPIO       (LWGPIO_MUX_PORT3_PIN26_GPIO)
#define LWGPIO_MUX_LCD1_RESET_GPIO       (LWGPIO_MUX_PORT3_PIN27_GPIO)
#define LWGPIO_MUX_LCD1_VSYNC_GPIO       (LWGPIO_MUX_PORT3_PIN28_GPIO)

#define LWGPIO_MUX_NAND_ALE_GPIO         (LWGPIO_MUX_PORT4_PIN0_GPIO)
#define LWGPIO_MUX_NAND_CE0_B_GPIO       (LWGPIO_MUX_PORT4_PIN1_GPIO)
#define LWGPIO_MUX_NAND_CE1_B_GPIO       (LWGPIO_MUX_PORT4_PIN2_GPIO)
#define LWGPIO_MUX_NAND_CLE_GPIO         (LWGPIO_MUX_PORT4_PIN3_GPIO)
#define LWGPIO_MUX_NAND_DATA00_GPIO      (LWGPIO_MUX_PORT4_PIN4_GPIO)
#define LWGPIO_MUX_NAND_DATA01_GPIO      (LWGPIO_MUX_PORT4_PIN5_GPIO)
#define LWGPIO_MUX_NAND_DATA02_GPIO      (LWGPIO_MUX_PORT4_PIN6_GPIO)
#define LWGPIO_MUX_NAND_DATA03_GPIO      (LWGPIO_MUX_PORT4_PIN7_GPIO)
#define LWGPIO_MUX_NAND_DATA04_GPIO      (LWGPIO_MUX_PORT4_PIN8_GPIO)
#define LWGPIO_MUX_NAND_DATA05_GPIO      (LWGPIO_MUX_PORT4_PIN9_GPIO)
#define LWGPIO_MUX_NAND_DATA06_GPIO      (LWGPIO_MUX_PORT4_PIN10_GPIO)
#define LWGPIO_MUX_NAND_DATA07_GPIO      (LWGPIO_MUX_PORT4_PIN11_GPIO)
#define LWGPIO_MUX_NAND_RE_B_GPIO        (LWGPIO_MUX_PORT4_PIN12_GPIO)
#define LWGPIO_MUX_NAND_READY_B_GPIO     (LWGPIO_MUX_PORT4_PIN13_GPIO)
#define LWGPIO_MUX_NAND_WE_B_GPIO        (LWGPIO_MUX_PORT4_PIN14_GPIO)
#define LWGPIO_MUX_NAND_WP_B_GPIO        (LWGPIO_MUX_PORT4_PIN15_GPIO)
#define LWGPIO_MUX_QSPI1A_DATA0_GPIO     (LWGPIO_MUX_PORT4_PIN16_GPIO)
#define LWGPIO_MUX_QSPI1A_DATA1_GPIO     (LWGPIO_MUX_PORT4_PIN17_GPIO)
#define LWGPIO_MUX_QSPI1A_DATA2_GPIO     (LWGPIO_MUX_PORT4_PIN18_GPIO)
#define LWGPIO_MUX_QSPI1A_DATA3_GPIO     (LWGPIO_MUX_PORT4_PIN19_GPIO)
#define LWGPIO_MUX_QSPI1A_DQS_GPIO       (LWGPIO_MUX_PORT4_PIN20_GPIO)
#define LWGPIO_MUX_QSPI1A_SCLK_GPIO      (LWGPIO_MUX_PORT4_PIN21_GPIO)
#define LWGPIO_MUX_QSPI1A_SS0_B_GPIO     (LWGPIO_MUX_PORT4_PIN22_GPIO)
#define LWGPIO_MUX_QSPI1A_SS1_B_GPIO     (LWGPIO_MUX_PORT4_PIN23_GPIO)
#define LWGPIO_MUX_QSPI1B_DATA0_GPIO     (LWGPIO_MUX_PORT4_PIN24_GPIO)
#define LWGPIO_MUX_QSPI1B_DATA1_GPIO     (LWGPIO_MUX_PORT4_PIN25_GPIO)
#define LWGPIO_MUX_QSPI1B_DATA2_GPIO     (LWGPIO_MUX_PORT4_PIN26_GPIO)
#define LWGPIO_MUX_QSPI1B_DATA3_GPIO     (LWGPIO_MUX_PORT4_PIN27_GPIO)
#define LWGPIO_MUX_QSPI1B_DQS_GPIO       (LWGPIO_MUX_PORT4_PIN28_GPIO)
#define LWGPIO_MUX_QSPI1B_SCLK_GPIO      (LWGPIO_MUX_PORT4_PIN29_GPIO)
#define LWGPIO_MUX_QSPI1B_SS0_B_GPIO     (LWGPIO_MUX_PORT4_PIN30_GPIO)
#define LWGPIO_MUX_QSPI1B_SS1_B_GPIO     (LWGPIO_MUX_PORT4_PIN31_GPIO)

#define LWGPIO_MUX_RGMII1_RD0_GPIO       (LWGPIO_MUX_PORT5_PIN0_GPIO)
#define LWGPIO_MUX_RGMII1_RD1_GPIO       (LWGPIO_MUX_PORT5_PIN1_GPIO)
#define LWGPIO_MUX_RGMII1_RD2_GPIO       (LWGPIO_MUX_PORT5_PIN2_GPIO)
#define LWGPIO_MUX_RGMII1_RD3_GPIO       (LWGPIO_MUX_PORT5_PIN3_GPIO)
#define LWGPIO_MUX_RGMII1_RX_CTL_GPIO    (LWGPIO_MUX_PORT5_PIN4_GPIO)
#define LWGPIO_MUX_RGMII1_RXC_GPIO       (LWGPIO_MUX_PORT5_PIN5_GPIO)
#define LWGPIO_MUX_RGMII1_TD0_GPIO       (LWGPIO_MUX_PORT5_PIN6_GPIO)
#define LWGPIO_MUX_RGMII1_TD1_GPIO       (LWGPIO_MUX_PORT5_PIN7_GPIO)
#define LWGPIO_MUX_RGMII1_TD2_GPIO       (LWGPIO_MUX_PORT5_PIN8_GPIO)
#define LWGPIO_MUX_RGMII1_TD3_GPIO       (LWGPIO_MUX_PORT5_PIN9_GPIO)
#define LWGPIO_MUX_RGMII1_TX_CTL_GPIO    (LWGPIO_MUX_PORT5_PIN10_GPIO)
#define LWGPIO_MUX_RGMII1_TXC_GPIO       (LWGPIO_MUX_PORT5_PIN11_GPIO)
#define LWGPIO_MUX_RGMII2_RD0_GPIO       (LWGPIO_MUX_PORT5_PIN12_GPIO)
#define LWGPIO_MUX_RGMII2_RD1_GPIO       (LWGPIO_MUX_PORT5_PIN13_GPIO)
#define LWGPIO_MUX_RGMII2_RD2_GPIO       (LWGPIO_MUX_PORT5_PIN14_GPIO)
#define LWGPIO_MUX_RGMII2_RD3_GPIO       (LWGPIO_MUX_PORT5_PIN15_GPIO)
#define LWGPIO_MUX_RGMII2_RX_CTL_GPIO    (LWGPIO_MUX_PORT5_PIN16_GPIO)
#define LWGPIO_MUX_RGMII2_RXC_GPIO       (LWGPIO_MUX_PORT5_PIN17_GPIO)
#define LWGPIO_MUX_RGMII2_TD0_GPIO       (LWGPIO_MUX_PORT5_PIN18_GPIO)
#define LWGPIO_MUX_RGMII2_TD1_GPIO       (LWGPIO_MUX_PORT5_PIN19_GPIO)
#define LWGPIO_MUX_RGMII2_TD2_GPIO       (LWGPIO_MUX_PORT5_PIN20_GPIO)
#define LWGPIO_MUX_RGMII2_TD3_GPIO       (LWGPIO_MUX_PORT5_PIN21_GPIO)
#define LWGPIO_MUX_RGMII2_TX_CTL_GPIO    (LWGPIO_MUX_PORT5_PIN22_GPIO)
#define LWGPIO_MUX_RGMII2_TXC_GPIO       (LWGPIO_MUX_PORT5_PIN23_GPIO)

#define LWGPIO_MUX_SD1_CLK_GPIO          (LWGPIO_MUX_PORT6_PIN0_GPIO)
#define LWGPIO_MUX_SD1_CMD_GPIO          (LWGPIO_MUX_PORT6_PIN1_GPIO)
#define LWGPIO_MUX_SD1_DATA0_GPIO        (LWGPIO_MUX_PORT6_PIN2_GPIO)
#define LWGPIO_MUX_SD1_DATA1_GPIO        (LWGPIO_MUX_PORT6_PIN3_GPIO)
#define LWGPIO_MUX_SD1_DATA2_GPIO        (LWGPIO_MUX_PORT6_PIN4_GPIO)
#define LWGPIO_MUX_SD1_DATA3_GPIO        (LWGPIO_MUX_PORT6_PIN5_GPIO)
#define LWGPIO_MUX_SD2_CLK_GPIO          (LWGPIO_MUX_PORT6_PIN6_GPIO)
#define LWGPIO_MUX_SD2_CMD_GPIO          (LWGPIO_MUX_PORT6_PIN7_GPIO)
#define LWGPIO_MUX_SD2_DATA0_GPIO        (LWGPIO_MUX_PORT6_PIN8_GPIO)
#define LWGPIO_MUX_SD2_DATA1_GPIO        (LWGPIO_MUX_PORT6_PIN9_GPIO)
#define LWGPIO_MUX_SD2_DATA2_GPIO        (LWGPIO_MUX_PORT6_PIN10_GPIO)
#define LWGPIO_MUX_SD2_DATA3_GPIO        (LWGPIO_MUX_PORT6_PIN11_GPIO)

#define LWGPIO_MUX_SD3_CLK_GPIO          (LWGPIO_MUX_PORT7_PIN0_GPIO)
#define LWGPIO_MUX_SD3_CMD_GPIO          (LWGPIO_MUX_PORT7_PIN1_GPIO)
#define LWGPIO_MUX_SD3_DATA0_GPIO        (LWGPIO_MUX_PORT7_PIN2_GPIO)
#define LWGPIO_MUX_SD3_DATA1_GPIO        (LWGPIO_MUX_PORT7_PIN3_GPIO)
#define LWGPIO_MUX_SD3_DATA2_GPIO        (LWGPIO_MUX_PORT7_PIN4_GPIO)
#define LWGPIO_MUX_SD3_DATA3_GPIO        (LWGPIO_MUX_PORT7_PIN5_GPIO)
#define LWGPIO_MUX_SD3_DATA4_GPIO        (LWGPIO_MUX_PORT7_PIN6_GPIO)
#define LWGPIO_MUX_SD3_DATA5_GPIO        (LWGPIO_MUX_PORT7_PIN7_GPIO)
#define LWGPIO_MUX_SD3_DATA6_GPIO        (LWGPIO_MUX_PORT7_PIN8_GPIO)
#define LWGPIO_MUX_SD3_DATA7_GPIO        (LWGPIO_MUX_PORT7_PIN9_GPIO)

#define LWGPIO_MUX_SD4_CLK_GPIO          (LWGPIO_MUX_PORT6_PIN12_GPIO)
#define LWGPIO_MUX_SD4_CMD_GPIO          (LWGPIO_MUX_PORT6_PIN13_GPIO)
#define LWGPIO_MUX_SD4_DATA0_GPIO        (LWGPIO_MUX_PORT6_PIN14_GPIO)
#define LWGPIO_MUX_SD4_DATA1_GPIO        (LWGPIO_MUX_PORT6_PIN15_GPIO)
#define LWGPIO_MUX_SD4_DATA2_GPIO        (LWGPIO_MUX_PORT6_PIN16_GPIO)
#define LWGPIO_MUX_SD4_DATA3_GPIO        (LWGPIO_MUX_PORT6_PIN17_GPIO)
#define LWGPIO_MUX_SD4_DATA4_GPIO        (LWGPIO_MUX_PORT6_PIN18_GPIO)
#define LWGPIO_MUX_SD4_DATA5_GPIO        (LWGPIO_MUX_PORT6_PIN19_GPIO)
#define LWGPIO_MUX_SD4_DATA6_GPIO        (LWGPIO_MUX_PORT6_PIN20_GPIO)
#define LWGPIO_MUX_SD4_DATA7_GPIO        (LWGPIO_MUX_PORT6_PIN21_GPIO)
#define LWGPIO_MUX_SD4_RESET_B_GPIO      (LWGPIO_MUX_PORT6_PIN22_GPIO)

#define LWGPIO_MUX_USB_H_DATA_GPIO       (LWGPIO_MUX_PORT7_PIN10_GPIO)
#define LWGPIO_MUX_USB_H_STROBE_GPIO     (LWGPIO_MUX_PORT7_PIN11_GPIO)

extern void _bsp_lock_lwgpio(uint32_t port);
extern void _bsp_unlock_lwgpio(uint32_t port);

#endif
