// Do not edit this file; automatically generated by build.py.
'use strict';

/*
 Licensed under the Apache License, Version 2.0 (the "License"):
          http://www.apache.org/licenses/LICENSE-2.0
*/
Blockly.Arduino=new Blockly.Generator("Arduino");Blockly.Arduino.StaticTyping=new Blockly.StaticTyping;Blockly.Arduino.addReservedWords("Blockly,setup,loop,if,else,for,switch,case,while,do,break,continue,return,goto,define,include,HIGH,LOW,INPUT,OUTPUT,INPUT_PULLUP,true,false,integer,constants,floating,point,void,boolean,char,unsigned,byte,int,word,long,float,double,string,String,array,static,volatile,const,sizeof,pinMode,digitalWrite,digitalRead,analogReference,analogRead,analogWrite,tone,noTone,shiftOut,shitIn,pulseIn,millis,micros,delay,delayMicroseconds,min,max,abs,constrain,map,pow,sqrt,sin,cos,tan,randomSeed,random,lowByte,highByte,bitRead,bitWrite,bitSet,bitClear,bit,attachInterrupt,detachInterrupt,interrupts,noInterrupts");
Blockly.Arduino.ORDER_ATOMIC=0;Blockly.Arduino.ORDER_UNARY_POSTFIX=1;Blockly.Arduino.ORDER_UNARY_PREFIX=2;Blockly.Arduino.ORDER_MULTIPLICATIVE=3;Blockly.Arduino.ORDER_ADDITIVE=4;Blockly.Arduino.ORDER_SHIFT=5;Blockly.Arduino.ORDER_RELATIONAL=6;Blockly.Arduino.ORDER_EQUALITY=7;Blockly.Arduino.ORDER_BITWISE_AND=8;Blockly.Arduino.ORDER_BITWISE_XOR=9;Blockly.Arduino.ORDER_BITWISE_OR=10;Blockly.Arduino.ORDER_LOGICAL_AND=11;Blockly.Arduino.ORDER_LOGICAL_OR=12;Blockly.Arduino.ORDER_CONDITIONAL=13;
Blockly.Arduino.ORDER_ASSIGNMENT=14;Blockly.Arduino.ORDER_NONE=99;Blockly.Arduino.PinTypes={INPUT:"INPUT",OUTPUT:"OUTPUT",PWM:"PWM",SERVO:"SERVO",STEPPER:"STEPPER",SERIAL:"SERIAL",I2C:"I2C/TWI",SPI:"SPI"};Blockly.Arduino.DEF_FUNC_NAME=Blockly.Arduino.FUNCTION_NAME_PLACEHOLDER_;
Blockly.Arduino.init=function(a){Blockly.Arduino.includes_=Object.create(null);Blockly.Arduino.definitions_=Object.create(null);Blockly.Arduino.codeFunctions_=Object.create(null);Blockly.Arduino.userFunctions_=Object.create(null);Blockly.Arduino.functionNames_=Object.create(null);Blockly.Arduino.setups_=Object.create(null);Blockly.Arduino.pins_=Object.create(null);Blockly.Arduino.variableDB_?Blockly.Arduino.variableDB_.reset():Blockly.Arduino.variableDB_=new Blockly.Names(Blockly.Arduino.RESERVED_WORDS_);
var b=Blockly.Arduino.StaticTyping.collectVarsWithTypes(a);Blockly.Arduino.StaticTyping.setProcedureArgs(a,b);a=[];for(var c in b)a.push(Blockly.Arduino.getArduinoType_(b[c])+" "+c+";");Blockly.Arduino.definitions_.variables=a.join("\n")};
Blockly.Arduino.finish=function(a){var b=[],c=[],d=[],e;for(e in Blockly.Arduino.includes_)b.push(Blockly.Arduino.includes_[e]);b.length&&b.push("\n");for(e in Blockly.Arduino.definitions_)c.push(Blockly.Arduino.definitions_[e]);c.length&&c.push("\n");for(e in Blockly.Arduino.codeFunctions_)d.push(Blockly.Arduino.codeFunctions_[e]);for(e in Blockly.Arduino.userFunctions_)d.push(Blockly.Arduino.userFunctions_[e]);d.length&&d.push("\n");var f=[""],g="";void 0!==Blockly.Arduino.setups_.userSetupCode&&
(g="\n"+Blockly.Arduino.setups_.userSetupCode,delete Blockly.Arduino.setups_.userSetupCode);for(e in Blockly.Arduino.setups_)f.push(Blockly.Arduino.setups_[e]);g&&f.push(g);delete Blockly.Arduino.includes_;delete Blockly.Arduino.definitions_;delete Blockly.Arduino.codeFunctions_;delete Blockly.Arduino.userFunctions_;delete Blockly.Arduino.functionNames_;delete Blockly.Arduino.setups_;delete Blockly.Arduino.pins_;Blockly.Arduino.variableDB_.reset();b=b.join("\n")+c.join("\n")+d.join("\n\n");f="void setup() {"+
f.join("\n  ")+"\n}\n\n";a="void loop() {\n  "+a.replace(/\n/g,"\n  ")+"\n}";return b+f+a};Blockly.Arduino.addInclude=function(a,b){void 0===Blockly.Arduino.includes_[a]&&(Blockly.Arduino.includes_[a]=b)};Blockly.Arduino.addDeclaration=function(a,b){void 0===Blockly.Arduino.definitions_[a]&&(Blockly.Arduino.definitions_[a]=b)};Blockly.Arduino.addSetup=function(a,b,c){c?Blockly.Arduino.setups_[a]=b:void 0===Blockly.Arduino.setups_[a]&&(Blockly.Arduino.setups_[a]=b)};
Blockly.Arduino.addFunction=function(a,b){if(void 0===Blockly.Arduino.codeFunctions_[a]){var c=Blockly.Arduino.variableDB_.getDistinctName(a,Blockly.Generator.NAME_TYPE);Blockly.Arduino.codeFunctions_[a]=b.replace(Blockly.Arduino.DEF_FUNC_NAME,c);Blockly.Arduino.functionNames_[a]=c}return Blockly.Arduino.functionNames_[a]};
Blockly.Arduino.reservePin=function(a,b,c,d){void 0!==Blockly.Arduino.pins_[b]?Blockly.Arduino.pins_[b]!=c?a.setWarningText("Pin "+b+" is needed for "+d+" as pin "+c+". Already used as "+Blockly.Arduino.pins_[b]+".",d):a.setWarningText(null,d):(Blockly.Arduino.pins_[b]=c,a.setWarningText(null,d))};Blockly.Arduino.scrubNakedValue=function(a){return a+";\n"};Blockly.Arduino.quote_=function(a){a=a.replace(/\\/g,"\\\\").replace(/\n/g,"\\\n").replace(/\$/g,"\\$").replace(/'/g,"\\'");return'"'+a+'"'};
Blockly.Arduino.scrub_=function(a,b){if(null===b)return"";var c="";if(!a.outputConnection||!a.outputConnection.targetConnection){var d=a.getCommentText();d&&(c+=this.prefixLines(d,"// ")+"\n");for(var e=0;e<a.inputList.length;e++)a.inputList[e].type==Blockly.INPUT_VALUE&&(d=a.inputList[e].connection.targetBlock())&&(d=this.allNestedComments(d))&&(c+=this.prefixLines(d,"// "))}e=a.nextConnection&&a.nextConnection.targetBlock();e=this.blockToCode(e);return c+b+e};
Blockly.Arduino.getArduinoType_=function(a){switch(a.typeName){case Blockly.Types.NUMBER.typeName:return"int";case Blockly.Types.DECIMAL.typeName:return"float";case Blockly.Types.TEXT.typeName:return"String";case Blockly.Types.CHARACTER.typeName:return"char";case Blockly.Types.BOOLEAN.typeName:return"boolean";case Blockly.Types.NULL.typeName:return"void";case Blockly.Types.UNDEF.typeName:return"undefined";case Blockly.Types.CHILD_BLOCK_MISSING.typeName:return"ChildBlockMissing";default:return"Invalid Blockly Type"}};
Blockly.Arduino.noGeneratorCodeInline=function(){return["",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.noGeneratorCodeLine=function(){return""};Blockly.Arduino.Boards={};Blockly.Arduino.Boards.generateDigitalIo=function(a,b){for(var c=[],d=a;d<b+1;d++)c.push([d.toString(),d.toString()]);return c};Blockly.Arduino.Boards.generateAnalogIo=function(a,b){for(var c=[],d=a;d<b+1;d++)c.push(["A"+d.toString(),"A"+d.toString()]);return c};
Blockly.Arduino.Boards.uno={name:"Arduino Uno",description:"Arduino Uno standard-compatible board",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,5),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,13).concat(Blockly.Arduino.Boards.generateAnalogIo(0,5)),pwmPins:[["3","3"],["5","5"],["6","6"],["9","9"],["10","10"],["11","11"]],serial:[["serial","Serial"]],serialPins:{serial:[["RX","0"],["TX","1"]]},serialSpeed:[["300","300"],["600","600"],["1200","1200"],["2400","2400"],["4800","4800"],
["9600","9600"],["14400","14400"],["19200","19200"],["28800","28800"],["31250","31250"],["38400","38400"],["57600","57600"],["115200","115200"]],spi:[["SPI","SPI"]],spiPins:{spi:[["MOSI","11"],["MISO","12"],["SCK","13"]]},spiClockDivide:[["2 (8MHz)","SPI_CLOCK_DIV2"],["4 (4MHz)","SPI_CLOCK_DIV4"],["8 (2MHz)","SPI_CLOCK_DIV8"],["16 (1MHz)","SPI_CLOCK_DIV16"],["32 (500KHz)","SPI_CLOCK_DIV32"],["64 (250KHz)","SPI_CLOCK_DIV64"],["128 (125KHz)","SPI_CLOCK_DIV128"]],i2c:[["I2C","Wire"]],i2cPins:{I2C:[["SDA",
"A4"],["SCL","A5"]]},i2cSpeed:[["100kHz","100000L"],["400kHz","400000L"]],builtinLed:[["BUILTIN_1","13"]],interrupt:[["interrupt0","2"],["interrupt1","3"]]};
Blockly.Arduino.Boards.duemilanove={name:"Arduino Duemilanove",description:"Arduino Duemilanove with ATmega168p or ATmega328p board",analogPins:Blockly.Arduino.Boards.uno.analogPins,digitalPins:Blockly.Arduino.Boards.uno.digitalPins,pwmPins:Blockly.Arduino.Boards.uno.pwmPins,serial:Blockly.Arduino.Boards.uno.serial,serialPins:Blockly.Arduino.Boards.uno.serialPins,serialSpeed:Blockly.Arduino.Boards.uno.serialSpeed,spi:Blockly.Arduino.Boards.uno.spi,spiPins:Blockly.Arduino.Boards.uno.spiPins,spiClockDivide:Blockly.Arduino.Boards.uno.spiClockDivide,
i2c:Blockly.Arduino.Boards.uno.i2c,i2cPins:Blockly.Arduino.Boards.uno.i2cPins,i2cSpeed:Blockly.Arduino.Boards.uno.i2cSpeed,builtinLed:Blockly.Arduino.Boards.uno.builtinLed,interrupt:Blockly.Arduino.Boards.uno.interrupt};Blockly.Arduino.Boards.duemilanove_168p=Blockly.Arduino.Boards.duemilanove;Blockly.Arduino.Boards.duemilanove_328p=Blockly.Arduino.Boards.duemilanove;
Blockly.Arduino.Boards.mega={name:"Arduino Mega",description:"Arduino Mega-compatible board",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,15),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,53),pwmPins:Blockly.Arduino.Boards.generateDigitalIo(2,13).concat(Blockly.Arduino.Boards.generateDigitalIo(44,46)),serial:[["serial","Serial"],["serial_1","Serial1"],["serial_2","Serial2"],["serial_3","Serial3"]],serialPins:{serial:[["TX","0"],["RX","1"]],serial1:[["TX","18"],["TX","19"]],serial2:[["TX",
"16"],["TX","17"]],serial3:[["TX","14"],["TX","15"]]},serialSpeed:Blockly.Arduino.Boards.uno.serialSpeed,spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","51"],["MISO","50"],["SCK","52"]]},spiClockDivide:Blockly.Arduino.Boards.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{I2C:[["SDA","20"],["SCL","21"]]},i2cSpeed:[["100kHz","100000L"],["400kHz","400000L"]],builtinLed:Blockly.Arduino.Boards.uno.builtinLed,interrupt:[["interrupt0","2"],["interrupt1","3"],["interrupt2","21"],["interrupt3","20"],["interrupt4",
"19"],["interrupt5","18"]]};
Blockly.Arduino.Boards.leonardo={description:"Arduino Leonardo-compatible board",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,5).concat([["A6","4"],["A7","6"],["A8","8"],["A9","9"],["A10","10"],["A11","12"]]),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,13).concat(Blockly.Arduino.Boards.generateAnalogIo(0,5)),pwmPins:Blockly.Arduino.Boards.uno.pwmPins.concat([["13","13"]]),serial:Blockly.Arduino.Boards.uno.serial,serialPins:Blockly.Arduino.Boards.uno.serialPins,serialSpeed:Blockly.Arduino.Boards.uno.serialSpeed,
spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","ICSP-4"],["MISO","ICSP-1"],["SCK","ICSP-3"]]},spiClockDivide:Blockly.Arduino.Boards.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{I2C:[["SDA","2"],["SCL","3"]]},i2cSpeed:Blockly.Arduino.Boards.uno.i2cSpeed,builtinLed:Blockly.Arduino.Boards.uno.builtinLed,interrupt:[["interrupt0","3"],["interrupt1","2"],["interrupt2","0"],["interrupt3","1"],["interrupt4","17"]]};Blockly.Arduino.Boards.yun=Blockly.Arduino.Boards.leonardo;
Blockly.Arduino.Boards.selected=Blockly.Arduino.Boards.uno;Blockly.Arduino.Boards.changeBoard=function(a,b){if(void 0===Blockly.Arduino.Boards[b])console.log("Tried to set non-existing Arduino board: "+b);else{Blockly.Arduino.Boards.selected=Blockly.Arduino.Boards[b];for(var c=a.getAllBlocks(),d=0;d<c.length;d++){var e=c[d].updateFields;e&&e.call(c[d])}}};
Blockly.Arduino.Boards.refreshBlockFieldDropdown=function(a,b,c){var d=a.getField(b);b=d.getValue();c=Blockly.Arduino.Boards.selected[c];d.menuGenerator_=c;for(var d=!1,e=0;e<c.length;e++)b==c[e][1]&&(d=!0);d?a.setWarningText(null,"bPin"):a.setWarningText("The old pin value "+b+" is no longer available.","bPin")};Blockly.Arduino.colour={};Blockly.Arduino.colour_picker=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_random=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_rgb=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_blend=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.IO={};Blockly.Arduino.io_digitalwrite=function(a){var b=a.getFieldValue("PIN"),c=Blockly.Arduino.valueToCode(a,"STATE",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Digital Write");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);return"digitalWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_digitalread=function(a){var b=a.getFieldValue("PIN");Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Digital Read");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);",!1);return["digitalRead("+b+")",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.io_builtin_led=function(a){var b=a.getFieldValue("BUILT_IN_LED"),c=Blockly.Arduino.valueToCode(a,"STATE",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Set LED");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);return"digitalWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_analogwrite=function(a){var b=a.getFieldValue("PIN"),c=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Analogue Write");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);0>c||255<c?a.setWarningText("The analogue value set must be between 0 and 255","pwm_value"):a.setWarningText(null,"pwm_value");return"analogWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_analogread=function(a){var b=a.getFieldValue("PIN");Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Analogue Read");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);",!1);return["analogRead("+b+")",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.io_highlow=function(a){return[a.getFieldValue("STATE"),Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.lists={};Blockly.Arduino.lists_create_empty=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_create_with=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_repeat=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_length=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_isEmpty=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_indexOf=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_getIndex=Blockly.Arduino.noGeneratorCodeInline;
Blockly.Arduino.lists_setIndex=Blockly.Arduino.noGeneratorCodeLine;Blockly.Arduino.logic={};Blockly.Arduino.controls_if=function(a){for(var b=0,c=Blockly.Arduino.valueToCode(a,"IF"+b,Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"+b),e="if ("+c+") {\n"+d+"}",b=1;b<=a.elseifCount_;b++)c=Blockly.Arduino.valueToCode(a,"IF"+b,Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"+b),e+=" else if ("+c+") {\n"+d+"}";a.elseCount_&&(d=Blockly.Arduino.statementToCode(a,"ELSE"),e+=" else {\n"+d+"}");return e+"\n"};
Blockly.Arduino.logic_compare=function(a){var b={EQ:"==",NEQ:"!=",LT:"<",LTE:"<=",GT:">",GTE:">="}[a.getFieldValue("OP")],c="=="==b||"!="==b?Blockly.Arduino.ORDER_EQUALITY:Blockly.Arduino.ORDER_RELATIONAL,d=Blockly.Arduino.valueToCode(a,"A",c)||"0";a=Blockly.Arduino.valueToCode(a,"B",c)||"0";return[d+" "+b+" "+a,c]};
Blockly.Arduino.logic_operation=function(a){var b="AND"==a.getFieldValue("OP")?"&&":"||",c="&&"==b?Blockly.Arduino.ORDER_LOGICAL_AND:Blockly.Arduino.ORDER_LOGICAL_OR,d=Blockly.Arduino.valueToCode(a,"A",c)||"false";a=Blockly.Arduino.valueToCode(a,"B",c)||"false";if(d||a){var e="&&"==b?"true":"false";d||(d=e);a||(a=e)}else a=d="false";return[d+" "+b+" "+a,c]};
Blockly.Arduino.logic_negate=function(a){var b=Blockly.Arduino.ORDER_UNARY_PREFIX;return["!"+(Blockly.Arduino.valueToCode(a,"BOOL",b)||"false"),b]};Blockly.Arduino.logic_boolean=function(a){return["TRUE"==a.getFieldValue("BOOL")?"true":"false",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.logic_null=function(a){return["NULL",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.logic_ternary=function(a){var b=Blockly.Arduino.valueToCode(a,"IF",Blockly.Arduino.ORDER_CONDITIONAL)||"false",c=Blockly.Arduino.valueToCode(a,"THEN",Blockly.Arduino.ORDER_CONDITIONAL)||"null";a=Blockly.Arduino.valueToCode(a,"ELSE",Blockly.Arduino.ORDER_CONDITIONAL)||"null";return[b+" ? "+c+" : "+a,Blockly.Arduino.ORDER_CONDITIONAL]};Blockly.Arduino.loops={};Blockly.Arduino.controls_repeat=function(a){var b=+a.getFieldValue("TIMES"),c=Blockly.Arduino.statementToCode(a,"DO"),c=Blockly.Arduino.addLoopTrap(c,a.id);a=Blockly.Arduino.variableDB_.getDistinctName("count",Blockly.Variables.NAME_TYPE);return"for (int "+a+" = 0; "+a+" < "+b+"; "+a+"++) {\n"+c+"}\n"};
Blockly.Arduino.controls_repeat_ext=function(a){var b=Blockly.Arduino.valueToCode(a,"TIMES",Blockly.Arduino.ORDER_ADDITIVE)||"0",c=Blockly.Arduino.statementToCode(a,"DO"),c=Blockly.Arduino.addLoopTrap(c,a.id);a="";var d=Blockly.Arduino.variableDB_.getDistinctName("count",Blockly.Variables.NAME_TYPE),e=b;b.match(/^\w+$/)||Blockly.isNumber(b)||(e=Blockly.Arduino.variableDB_.getDistinctName("repeat_end",Blockly.Variables.NAME_TYPE),a+="int "+e+" = "+b+";\n");return a+("for (int "+d+" = 0; "+d+" < "+
e+"; "+d+"++) {\n"+c+"}\n")};Blockly.Arduino.controls_whileUntil=function(a){var b="UNTIL"==a.getFieldValue("MODE"),c=Blockly.Arduino.valueToCode(a,"BOOL",b?Blockly.Arduino.ORDER_LOGICAL_OR:Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"),d=Blockly.Arduino.addLoopTrap(d,a.id);b&&(c.match(/^\w+$/)||(c="("+c+")"),c="!"+c);return"while ("+c+") {\n"+d+"}\n"};
Blockly.Arduino.controls_for=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE),c=Blockly.Arduino.valueToCode(a,"FROM",Blockly.Arduino.ORDER_ASSIGNMENT)||"0",d=Blockly.Arduino.valueToCode(a,"TO",Blockly.Arduino.ORDER_ASSIGNMENT)||"0",e=Blockly.Arduino.valueToCode(a,"BY",Blockly.Arduino.ORDER_ASSIGNMENT)||"1",f=Blockly.Arduino.statementToCode(a,"DO"),f=Blockly.Arduino.addLoopTrap(f,a.id);if(Blockly.isNumber(c)&&Blockly.isNumber(d)&&Blockly.isNumber(e)){var g=
parseFloat(c)<=parseFloat(d);a="for ("+b+" = "+c+"; "+b+(g?" <= ":" >= ")+d+"; "+b;b=Math.abs(parseFloat(e));a=(1==b?a+(g?"++":"--"):a+((g?" += ":" -= ")+b))+(") {\n"+f+"}\n")}else a="",g=c,c.match(/^\w+$/)||Blockly.isNumber(c)||(g=Blockly.Arduino.variableDB_.getDistinctName(b+"_start",Blockly.Variables.NAME_TYPE),a+="int "+g+" = "+c+";\n"),c=d,d.match(/^\w+$/)||Blockly.isNumber(d)||(c=Blockly.Arduino.variableDB_.getDistinctName(b+"_end",Blockly.Variables.NAME_TYPE),a+="int "+c+" = "+d+";\n"),d=Blockly.Arduino.variableDB_.getDistinctName(b+
"_inc",Blockly.Variables.NAME_TYPE),a+="int "+d+" = ",a=Blockly.isNumber(e)?a+(Math.abs(e)+";\n"):a+("abs("+e+");\n"),a+="if ("+g+" > "+c+") {\n",a+=Blockly.Arduino.INDENT+d+" = -"+d+";\n",a+="}\n",a+="for ("+b+" = "+g+";\n     "+d+" >= 0 ? "+b+" <= "+c+" : "+b+" >= "+c+";\n     "+b+" += "+d+") {\n"+f+"}\n";return a};
Blockly.Arduino.controls_forEach=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE),c=Blockly.Arduino.valueToCode(a,"LIST",Blockly.Arduino.ORDER_ASSIGNMENT)||"[]",d=Blockly.Arduino.statementToCode(a,"DO"),d=Blockly.Arduino.addLoopTrap(d,a.id);a=Blockly.Arduino.variableDB_.getDistinctName(b+"_index",Blockly.Variables.NAME_TYPE);d=Blockly.Arduino.INDENT+b+" = "+c+"["+a+"];\n"+d;return"for (int "+a+" in  "+c+") {\n"+d+"}\n"};
Blockly.Arduino.controls_flow_statements=function(a){switch(a.getFieldValue("FLOW")){case "BREAK":return"break;\n";case "CONTINUE":return"continue;\n"}throw"Unknown flow statement.";};Blockly.Arduino.map={};Blockly.Arduino.base_map=function(a){var b=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"DMAX",Blockly.Arduino.ORDER_ATOMIC)||"0";return["map("+b+", 0, 1024, 0, "+a+")",Blockly.Arduino.ORDER_NONE]};Blockly.Arduino.math={};Blockly.Arduino.math_number=function(a){a=parseFloat(a.getFieldValue("NUM"));Infinity==a?a="INFINITY":-Infinity==a&&(a="-INFINITY");return[a,Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.math_arithmetic=function(a){var b={ADD:[" + ",Blockly.Arduino.ORDER_ADDITIVE],MINUS:[" - ",Blockly.Arduino.ORDER_ADDITIVE],MULTIPLY:[" * ",Blockly.Arduino.ORDER_MULTIPLICATIVE],DIVIDE:[" / ",Blockly.Arduino.ORDER_MULTIPLICATIVE],POWER:[null,Blockly.Arduino.ORDER_NONE]}[a.getFieldValue("OP")],c=b[0],b=b[1],d=Blockly.Arduino.valueToCode(a,"A",b)||"0";a=Blockly.Arduino.valueToCode(a,"B",b)||"0";return c?[d+c+a,b]:["Math.pow("+d+", "+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.math_single=function(a){var b=a.getFieldValue("OP"),c;if("NEG"==b)return a=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_UNARY_PREFIX)||"0","-"==a[0]&&(a=" "+a),["-"+a,Blockly.Arduino.ORDER_UNARY_PREFIX];a="ABS"==b||"ROUND"==b.substring(0,5)?Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_UNARY_POSTFIX)||"0":"SIN"==b||"COS"==b||"TAN"==b?Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0":Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_NONE)||
"0";switch(b){case "ABS":c="abs("+a+")";break;case "ROOT":c="sqrt("+a+")";break;case "LN":c="log("+a+")";break;case "EXP":c="exp("+a+")";break;case "POW10":c="pow(10,"+a+")";break;case "ROUND":c="round("+a+")";break;case "ROUNDUP":c="ceil("+a+")";break;case "ROUNDDOWN":c="floor("+a+")";break;case "SIN":c="sin("+a+" / 180 * Math.PI)";break;case "COS":c="cos("+a+" / 180 * Math.PI)";break;case "TAN":c="tan("+a+" / 180 * Math.PI)"}if(c)return[c,Blockly.Arduino.ORDER_UNARY_POSTFIX];switch(b){case "LOG10":c=
"log("+a+") / log(10)";break;case "ASIN":c="asin("+a+") / M_PI * 180";break;case "ACOS":c="acos("+a+") / M_PI * 180";break;case "ATAN":c="atan("+a+") / M_PI * 180";break;default:throw"Unknown math operator: "+b;}return[c,Blockly.Arduino.ORDER_MULTIPLICATIVE]};
Blockly.Arduino.math_constant=function(a){return{PI:["M_PI",Blockly.Arduino.ORDER_UNARY_POSTFIX],E:["M_E",Blockly.Arduino.ORDER_UNARY_POSTFIX],GOLDEN_RATIO:["(1 + sqrt(5)) / 2",Blockly.Arduino.ORDER_MULTIPLICATIVE],SQRT2:["M_SQRT2",Blockly.Arduino.ORDER_UNARY_POSTFIX],SQRT1_2:["M_SQRT1_2",Blockly.Arduino.ORDER_UNARY_POSTFIX],INFINITY:["INFINITY",Blockly.Arduino.ORDER_ATOMIC]}[a.getFieldValue("CONSTANT")]};
Blockly.Arduino.math_number_property=function(a){var b=Blockly.Arduino.valueToCode(a,"NUMBER_TO_CHECK",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0",c=a.getFieldValue("PROPERTY"),d;if("PRIME"==c)return a=Blockly.Arduino.addFunction("mathIsPrime",["boolean "+Blockly.Arduino.DEF_FUNC_NAME+"(int n) {","  // https://en.wikipedia.org/wiki/Primality_test#Naive_methods\n  if (n == 2 || n == 3) {\n    return true;\n  }\n  // False if n is NaN, negative, is 1.\n  // And false if n is divisible by 2 or 3.\n  if (isnan(n) || (n <= 1) || (n == 1) || (n % 2 == 0) || (n % 3 == 0)) {\n    return false;\n  }\n  // Check all the numbers of form 6k +/- 1, up to sqrt(n).\n  for (int x = 6; x <= sqrt(n) + 1; x += 6) {\n    if (n % (x - 1) == 0 || n % (x + 1) == 0) {\n      return false;\n    }\n  }\n  return true;\n}"].join("\n")),
Blockly.Arduino.addInclude("math","#include <math.h>"),[a+"("+b+")",Blockly.Arduino.ORDER_UNARY_POSTFIX];switch(c){case "EVEN":d=b+" % 2 == 0";break;case "ODD":d=b+" % 2 == 1";break;case "WHOLE":Blockly.Arduino.addInclude("math","#include <math.h>");d="(floor("+b+") == "+b+")";break;case "POSITIVE":d=b+" > 0";break;case "NEGATIVE":d=b+" < 0";break;case "DIVISIBLE_BY":a=Blockly.Arduino.valueToCode(a,"DIVISOR",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0",d=b+" % "+a+" == 0"}return[d,Blockly.Arduino.ORDER_EQUALITY]};
Blockly.Arduino.math_change=function(a){var b=Blockly.Arduino.valueToCode(a,"DELTA",Blockly.Arduino.ORDER_ADDITIVE)||"0";return Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE)+" += "+b+";\n"};Blockly.Arduino.math_round=Blockly.Arduino.math_single;Blockly.Arduino.math_trig=Blockly.Arduino.math_single;
Blockly.Arduino.math_on_list=function(a){var b=a.getFieldValue("OP");a=Blockly.Arduino.valueToCode(a,"LIST",Blockly.Arduino.ORDER_NONE)||"[]";switch(b){case "SUM":var b=["num "+Blockly.Arduino.DEF_FUNC_NAME+"(List myList) {","  num sumVal = 0;","  myList.forEach((num entry) {sumVal += entry;});","  return sumVal;","}"],c=Blockly.Arduino.addFunction("mathListSum",b.join("\n")),b=c+"("+a+")";break;case "MIN":Blockly.Arduino.definitions_.math_min||(c=Blockly.Arduino.variableDB_.getDistinctName("math_min",
Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_min=c,b=[],b.push("num "+c+"(List myList) {"),b.push("  if (myList.isEmpty()) return null;"),b.push("  num minVal = myList[0];"),b.push("  myList.forEach((num entry) {minVal = Math.min(minVal, entry);});"),b.push("  return minVal;"),b.push("}"),Blockly.Arduino.definitions_.math_min=b.join("\n"));b=Blockly.Arduino.math_on_list.math_min+"("+a+")";break;case "MAX":Blockly.Arduino.definitions_.math_max||(c=Blockly.Arduino.variableDB_.getDistinctName("math_max",
Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_max=c,b=[],b.push("num "+c+"(List myList) {"),b.push("  if (myList.isEmpty()) return null;"),b.push("  num maxVal = myList[0];"),b.push("  myList.forEach((num entry) {maxVal = Math.max(maxVal, entry);});"),b.push("  return maxVal;"),b.push("}"),Blockly.Arduino.definitions_.math_max=b.join("\n"));b=Blockly.Arduino.math_on_list.math_max+"("+a+")";break;case "AVERAGE":Blockly.Arduino.definitions_.math_average||(c=Blockly.Arduino.variableDB_.getDistinctName("math_average",
Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_average=c,b=[],b.push("num "+c+"(List myList) {"),b.push("  // First filter list for numbers only."),b.push("  List localList = myList.filter((a) => a is num);"),b.push("  if (localList.isEmpty()) return null;"),b.push("  num sumVal = 0;"),b.push("  localList.forEach((num entry) {sumVal += entry;});"),b.push("  return sumVal / localList.length;"),b.push("}"),Blockly.Arduino.definitions_.math_average=b.join("\n"));b=Blockly.Arduino.math_on_list.math_average+
"("+a+")";break;case "MEDIAN":Blockly.Arduino.definitions_.math_median||(c=Blockly.Arduino.variableDB_.getDistinctName("math_median",Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_median=c,b=[],b.push("num "+c+"(List myList) {"),b.push("  // First filter list for numbers only, then sort, then return middle value"),b.push("  // or the average of two middle values if list has an even number of elements."),b.push("  List localList = myList.filter((a) => a is num);"),b.push("  if (localList.isEmpty()) return null;"),
b.push("  localList.sort((a, b) => (a - b));"),b.push("  int index = (localList.length / 2).toInt();"),b.push("  if (localList.length % 2 == 1) {"),b.push("    return localList[index];"),b.push("  } else {"),b.push("    return (localList[index - 1] + localList[index]) / 2;"),b.push("  }"),b.push("}"),Blockly.Arduino.definitions_.math_median=b.join("\n"));b=Blockly.Arduino.math_on_list.math_median+"("+a+")";break;case "MODE":Blockly.Arduino.definitions_.math_modes||(c=Blockly.Arduino.variableDB_.getDistinctName("math_modes",
Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_modes=c,b=[],b.push("List "+c+"(values) {"),b.push("  List modes = [];"),b.push("  List counts = [];"),b.push("  int maxCount = 0;"),b.push("  for (int i = 0; i < values.length; i++) {"),b.push("    var value = values[i];"),b.push("    bool found = false;"),b.push("    int thisCount;"),b.push("    for (int j = 0; j < counts.length; j++) {"),b.push("      if (counts[j][0] === value) {"),b.push("        thisCount = ++counts[j][1];"),b.push("        found = true;"),
b.push("        break;"),b.push("      }"),b.push("    }"),b.push("    if (!found) {"),b.push("      counts.add([value, 1]);"),b.push("      thisCount = 1;"),b.push("    }"),b.push("    maxCount = Math.max(thisCount, maxCount);"),b.push("  }"),b.push("  for (int j = 0; j < counts.length; j++) {"),b.push("    if (counts[j][1] == maxCount) {"),b.push("        modes.add(counts[j][0]);"),b.push("    }"),b.push("  }"),b.push("  return modes;"),b.push("}"),Blockly.Arduino.definitions_.math_modes=b.join("\n"));
b=Blockly.Arduino.math_on_list.math_modes+"("+a+")";break;case "STD_DEV":Blockly.Arduino.definitions_.math_standard_deviation||(c=Blockly.Arduino.variableDB_.getDistinctName("math_standard_deviation",Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_standard_deviation=c,b=[],b.push("num "+c+"(myList) {"),b.push("  // First filter list for numbers only."),b.push("  List numbers = myList.filter((a) => a is num);"),b.push("  if (numbers.isEmpty()) return null;"),b.push("  num n = numbers.length;"),
b.push("  num sum = 0;"),b.push("  numbers.forEach((x) => sum += x);"),b.push("  num mean = sum / n;"),b.push("  num sumSquare = 0;"),b.push("  numbers.forEach((x) => sumSquare += Math.pow(x - mean, 2));"),b.push("  return Math.sqrt(sumSquare / n);"),b.push("}"),Blockly.Arduino.definitions_.math_standard_deviation=b.join("\n"));b=Blockly.Arduino.math_on_list.math_standard_deviation+"("+a+")";break;case "RANDOM":Blockly.Arduino.definitions_.math_random_item||(c=Blockly.Arduino.variableDB_.getDistinctName("math_random_item",
Blockly.Generator.NAME_TYPE),Blockly.Arduino.math_on_list.math_random_item=c,b=[],b.push("Dynamic "+c+"(List myList) {"),b.push("  int x = (Math.random() * myList.length).floor().toInt();"),b.push("  return myList[x];"),b.push("}"),Blockly.Arduino.definitions_.math_random_item=b.join("\n"));b=Blockly.Arduino.math_on_list.math_random_item+"("+a+")";break;default:throw"Unknown operator: "+b;}return[b,Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.math_modulo=function(a){var b=Blockly.Arduino.valueToCode(a,"DIVIDEND",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0";a=Blockly.Arduino.valueToCode(a,"DIVISOR",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0";return[b+" % "+a,Blockly.Arduino.ORDER_MULTIPLICATIVE]};
Blockly.Arduino.math_constrain=function(a){var b=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_NONE)||"0",c=Blockly.Arduino.valueToCode(a,"LOW",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"HIGH",Blockly.Arduino.ORDER_NONE)||"0";return["("+b+" < "+c+" ? "+c+" : ( "+b+" > "+a+" ? "+a+" : "+b+"))",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.math_random_int=function(a){var b=Blockly.Arduino.valueToCode(a,"FROM",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"TO",Blockly.Arduino.ORDER_NONE)||"0";var c=Blockly.Arduino.variableDB_.getDistinctName("math_random_int",Blockly.Generator.NAME_TYPE);Blockly.Arduino.math_random_int.random_function=c;return[Blockly.Arduino.addFunction("mathRandomInt",["int "+Blockly.Arduino.DEF_FUNC_NAME+"(int min, int max) {","  if (min > max) {\n    // Swap min and max to ensure min is smaller.\n    int temp = min;\n    min = max;\n    max = temp;\n  }\n  return min + (rand() % (max - min + 1));\n}"].join("\n"))+
"("+b+", "+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.math_random_float=function(a){return["(rand() / RAND_MAX)",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.procedures={};
Blockly.Arduino.procedures_defreturn=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=Blockly.Arduino.statementToCode(a,"STACK");Blockly.Arduino.STATEMENT_PREFIX&&(c=Blockly.Arduino.prefixLines(Blockly.Arduino.STATEMENT_PREFIX.replace(/%1/g,"'"+a.id+"'"),Blockly.Arduino.INDENT)+c);Blockly.Arduino.INFINITE_LOOP_TRAP&&(c=Blockly.Arduino.INFINITE_LOOP_TRAP.replace(/%1/g,"'"+a.id+"'")+c);var d=Blockly.Arduino.valueToCode(a,"RETURN",Blockly.Arduino.ORDER_NONE)||
"";d&&(d="  return "+d+";\n");for(var e=[],f=0;f<a.arguments_.length;f++)e[f]=Blockly.Arduino.getArduinoType_(a.getArgType(a.arguments_[f]))+" "+Blockly.Arduino.variableDB_.getName(a.arguments_[f],Blockly.Variables.NAME_TYPE);f=Blockly.Types.NULL;a.getReturnType&&(f=a.getReturnType());f=Blockly.Arduino.getArduinoType_(f);c=f+" "+b+"("+e.join(", ")+") {\n"+c+d+"}";c=Blockly.Arduino.scrub_(a,c);Blockly.Arduino.userFunctions_[b]=c;return null};Blockly.Arduino.procedures_defnoreturn=Blockly.Arduino.procedures_defreturn;
Blockly.Arduino.procedures_callreturn=function(a){for(var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=[],d=0;d<a.arguments_.length;d++)c[d]=Blockly.Arduino.valueToCode(a,"ARG"+d,Blockly.Arduino.ORDER_NONE)||"null";return[b+"("+c.join(", ")+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.procedures_callnoreturn=function(a){for(var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=[],d=0;d<a.arguments_.length;d++)c[d]=Blockly.Arduino.valueToCode(a,"ARG"+d,Blockly.Arduino.ORDER_NONE)||"null";return b+"("+c.join(", ")+");\n"};
Blockly.Arduino.procedures_ifreturn=function(a){var b="if ("+(Blockly.Arduino.valueToCode(a,"CONDITION",Blockly.Arduino.ORDER_NONE)||"false")+") {\n";a.hasReturnValue_?(a=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_NONE)||"null",b+="  return "+a+";\n"):b+="  return;\n";return b+"}\n"};
Blockly.Arduino.arduino_functions=function(a){var b=Blockly.Arduino.statementToCode(a,"SETUP_FUNC");b&&Blockly.Arduino.addSetup("userSetupCode",b,!0);a=a.getInputTargetBlock("LOOP_FUNC");b=Blockly.Arduino.blockToCode(a);if(!goog.isString(b))throw'Expecting code from statement block "'+a.type+'".';return b};Blockly.Arduino.serial={};Blockly.Arduino.serial_print=function(a){var b=a.getFieldValue("SERIAL_ID"),c=Blockly.Arduino.valueToCode(a,"CONTENT",Blockly.Arduino.ORDER_ATOMIC)||"0";return"TRUE"==a.getFieldValue("NEW_LINE")?b+".println("+c+");\n":b+".print("+c+");\n"};Blockly.Arduino.serial_setup=function(a){var b=a.getFieldValue("SERIAL_ID");a=a.getFieldValue("SPEED");Blockly.Arduino.addSetup("serial_"+b,b+".begin("+a+");",!0);return""};Blockly.Arduino.servo={};Blockly.Arduino.servo_write=function(a){var b=a.getFieldValue("SERVO_PIN"),c=Blockly.Arduino.valueToCode(a,"SERVO_ANGLE",Blockly.Arduino.ORDER_ATOMIC)||"90",d="myServo"+b;Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.SERVO,"Servo Write");Blockly.Arduino.addInclude("servo","#include <Servo.h>");Blockly.Arduino.addDeclaration("servo_"+b,"Servo "+d+";");Blockly.Arduino.addSetup("servo_"+b,d+".attach("+b+");",!0);return d+".write("+c+");\n"};
Blockly.Arduino.servo_read=function(a){var b=a.getFieldValue("SERVO_PIN"),c="myServo"+b;Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.SERVO,"Servo Read");Blockly.Arduino.addInclude("servo","#include <Servo.h>");Blockly.Arduino.addDeclaration("servo_"+b,"Servo "+c+";");Blockly.Arduino.addSetup("servo_"+b,c+".attach("+b+");",!0);return[c+".read()",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.spi={};
Blockly.Arduino.spi_setup=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SHIFT_ORDER"),d=a.getFieldValue("SPI_CLOCK_DIVIDE");a=a.getFieldValue("SPI_MODE");Blockly.Arduino.addInclude("spi","#include <SPI.h>");Blockly.Arduino.addSetup("spi_order",b+".setBitOrder("+c+");",!0);Blockly.Arduino.addSetup("spi_mode",b+".setDataMode("+a+");",!0);Blockly.Arduino.addSetup("spi_div",b+".setClockDivider("+d+");",!0);Blockly.Arduino.addSetup("spi_begin",b+".begin();",!0);return""};
Blockly.Arduino.spi_transfer=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SS"),d=Blockly.Arduino.valueToCode(a,"SPI_DATA",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.addInclude("spi","#include <SPI.h>");Blockly.Arduino.addSetup("spi_begin",b+".begin();",!1);for(var e=0;e<Blockly.Arduino.Boards.selected.spiPins.length;e++)Blockly.Arduino.reservePin(a,Blockly.Arduino.Boards.selected.spiPins[e][1],Blockly.Arduino.PinTypes.SPI,"SPI "+Blockly.Arduino.Boards.selected.spiPins[e][0]);
"none"!==c&&(Blockly.Arduino.reservePin(a,c,Blockly.Arduino.PinTypes.OUTPUT,"SPI Slave pin"),Blockly.Arduino.addSetup("io_"+c,"pinMode("+c+", OUTPUT);",!1));a=[];"none"!==c&&a.push("digitalWrite("+c+", HIGH);");a.push(b+".transfer("+d+");");"none"!==c&&a.push("digitalWrite("+c+", LOW);");return a.join("\n")+"\n"};
Blockly.Arduino.spi_transfer_return=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SS"),d=Blockly.Arduino.valueToCode(a,"SPI_DATA",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.spi_transfer(a);return["none"===c?b+".transfer("+d+")":Blockly.Arduino.addFunction("spiReturnSlave"+c,["int "+Blockly.Arduino.DEF_FUNC_NAME+"() {","  int spiReturn = 0;","  digitalWrite("+c+", HIGH);","  spiReturn = "+b+".transfer("+d+");","  digitalWrite("+c+", LOW);","  return spiReturn;\n}"].join("\n"))+
"()",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.stepper={};
Blockly.Arduino.stepper_config=function(a){var b=a.getFieldValue("STEPPER_PIN1"),c=a.getFieldValue("STEPPER_PIN2"),d=Blockly.Arduino.PinTypes.STEPPER,e=a.getStepperSetupInstance(),f=Blockly.Arduino.valueToCode(a,"STEPPER_STEPS",Blockly.Arduino.ORDER_ATOMIC)||"360",g=Blockly.Arduino.valueToCode(a,"STEPPER_SPEED",Blockly.Arduino.ORDER_ATOMIC)||"90";Blockly.Arduino.reservePin(a,b,d,"Stepper");Blockly.Arduino.reservePin(a,c,d,"Stepper");Blockly.Arduino.addInclude("stepper","#include <Stepper.h>");Blockly.Arduino.addDeclaration("stepper_"+
e,"Stepper "+e+"("+f+", "+b+", "+c+");");Blockly.Arduino.addSetup("stepper_"+e,e+".setSpeed("+g+");",!0);return""};Blockly.Arduino.stepper_step=function(a){var b=a.getFieldValue("STEPPER_NAME");a=Blockly.Arduino.valueToCode(a,"STEPPER_STEPS",Blockly.Arduino.ORDER_ATOMIC)||"0";return b+".step("+a+");\n"};Blockly.Arduino.text={};Blockly.Arduino.text=function(a){return[Blockly.Arduino.quote_(a.getFieldValue("TEXT")),Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.text_join=function(a){var b;if(0==a.itemCount_)return['""',Blockly.Arduino.ORDER_ATOMIC];if(1==a.itemCount_)b="String("+(Blockly.Arduino.valueToCode(a,"ADD0",Blockly.Arduino.ORDER_UNARY_POSTFIX)||'""')+")";else{var c;b=[];for(var d=0;d<a.itemCount_;d++)c=Blockly.Arduino.valueToCode(a,"ADD"+d,Blockly.Arduino.ORDER_NONE),b[d]=""==c?'""':"String("+c+")";b=b.join(" + ")}return[b,Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_append=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_UNARY_POSTFIX);return b+" += "+(""==a?'""':"String("+a+")")+";\n"};Blockly.Arduino.text_length=function(a){return["String("+(Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_UNARY_POSTFIX)||'""')+").length()",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_isEmpty=function(a){var b=[];b.push("boolean "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {");b.push("  if (msg.length() == 0) {");b.push("    return true;");b.push("  } else {");b.push("    return false;");b.push("  }");b.push("}");b=Blockly.Arduino.addFunction("isStringEmpty",b.join("\n"));a=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_UNARY_POSTFIX);return[b+"("+(""==a?'""':"String("+a+")")+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_trim=function(a){Blockly.Arduino.text_trim.OPERATORS={LEFT:".trim()",RIGHT:".trim()",BOTH:".trim()"};var b=a.getFieldValue("MODE"),b=Blockly.Arduino.text_trim.OPERATORS[b];a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_UNARY_POSTFIX);return[(""==a?'""':"String("+a+")")+b,Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_print=function(a){var b=Blockly.Arduino.Boards.selected.serial[0][1];Blockly.Arduino.addSetup("serial_"+b,b+".begin(9600);",!1);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_NONE);return b+".print("+(""==a?'""':"String("+a+")")+");\n"};
Blockly.Arduino.text_prompt_ext=function(a){var b=Blockly.Arduino.Boards.selected.serial[0][1],c=a.getFieldValue("TYPE"),d=[],e=c==Blockly.Types.NUMBER.basicType;e?d.push("int "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {"):d.push("String "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {");d.push("  "+b+".println(msg);");d.push("  boolean stringComplete = false;");e?d.push("  int content = 0;"):d.push('  String content = "";');d.push("  while (stringComplete == false) {");d.push("    if ("+b+".available()) {");
e?(d.push("      content = "+b+".parseInt();"),d.push("      stringComplete = true;")):(d.push("      char readChar = (char)"+b+".read();"),d.push("      if (readChar == '\\n' || readChar == '\\r') {"),d.push("        stringComplete = true;"),d.push("      } else {"),d.push("        content += readChar;"),d.push("      }"));d.push("    }");d.push("  }");d.push("  // Empty incoming serial buffer");d.push("  while(Serial.available()) { Serial.read(); };");d.push("  return content;");d.push("}");c=Blockly.Arduino.addFunction("getUserInputPrompt"+
c,d.join("\n"));Blockly.Arduino.addSetup("serial_"+b,b+".begin(9600);",!1);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_NONE)||'""';return[c+"("+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_endString=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_indexOf=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_charAt=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_getSubstring=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_changeCase=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_prompt=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.time={};Blockly.Arduino.time_delay=function(a){return"delay("+(Blockly.Arduino.valueToCode(a,"DELAY_TIME_MILI",Blockly.Arduino.ORDER_ATOMIC)||"0")+");\n"};Blockly.Arduino.time_delaymicros=function(a){return"delayMicroseconds("+(Blockly.Arduino.valueToCode(a,"DELAY_TIME_MICRO",Blockly.Arduino.ORDER_ATOMIC)||"0")+");\n"};Blockly.Arduino.time_millis=function(a){return["millis()",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.time_micros=function(a){return["micros()",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.infinite_loop=function(a){return"while(true);\n"};Blockly.Arduino.variables={};Blockly.Arduino.variables_get=function(a){return[Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE),Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.variables_set=function(a){var b=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_ASSIGNMENT)||"0";return Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE)+" = "+b+";\n"};
Blockly.Arduino.variables_set_type=function(a){var b=Blockly.Arduino.valueToCode(a,"VARIABLE_SETTYPE_INPUT",Blockly.Arduino.ORDER_ASSIGNMENT)||"0";return["("+Blockly.Arduino.getArduinoType_(Blockly.Types[a.getFieldValue("VARIABLE_SETTYPE_TYPE")])+")("+b+")",Blockly.Arduino.ORDER_ATOMIC]};