/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.ext.base64.Base64;
import ch.randelshofer.quaqua.ext.nanoxml.XMLElement;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class BinaryPListParser {
    private static final boolean DEBUG = false;
    private static final long TIMER_INTERVAL_TIMEBASE = new GregorianCalendar(2001, 0, 1, 1, 0, 0).getTimeInMillis();
    private static DatatypeFactory datatypeFactory;
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList objectTable;
    private PosByteArrayInputStream pos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(File file) throws IOException {
        RandomAccessFile raf = null;
        byte[] buf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            int bpli = raf.readInt();
            int st00 = raf.readInt();
            if (bpli != 1651534953 || st00 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            raf.seek(raf.length() - 32L);
            this.offsetCount = (int)raf.readLong();
            this.refCount = (int)raf.readLong();
            this.objectCount = (int)raf.readLong();
            this.topLevelOffset = (int)raf.readLong();
            buf = new byte[this.topLevelOffset - 8];
            raf.seek(8L);
            raf.readFully(buf);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        this.objectTable = new ArrayList();
        FilterInputStream in = null;
        try {
            this.pos = new PosByteArrayInputStream(buf);
            in = new DataInputStream(this.pos);
            this.parseObjectTable((DataInputStream)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        XMLElement root = new XMLElement(new HashMap(), false, false);
        root.setName("plist");
        root.setAttribute("version", "1.0");
        this.convertObjectTableToXML(root, this.objectTable.get(0));
        return root;
    }

    private long getPosition() {
        return this.pos.getPos() + 8;
    }

    private void convertObjectTableToXML(XMLElement parent, Object object) {
        XMLElement elem = parent.createAnotherElement();
        if (object instanceof BPLDict) {
            BPLDict dict = (BPLDict)object;
            elem.setName("dict");
            for (int i = 0; i < dict.keyref.length; ++i) {
                XMLElement key = parent.createAnotherElement();
                key.setName("key");
                key.setContent(dict.getKey(i));
                elem.addChild(key);
                this.convertObjectTableToXML(elem, dict.getValue(i));
            }
        } else if (object instanceof BPLArray) {
            BPLArray arr = (BPLArray)object;
            elem.setName("array");
            for (int i = 0; i < arr.objref.length; ++i) {
                this.convertObjectTableToXML(elem, arr.getValue(i));
            }
        } else if (object instanceof String) {
            elem.setName("string");
            elem.setContent((String)object);
        } else if (object instanceof Integer) {
            elem.setName("integer");
            elem.setContent(object.toString());
        } else if (object instanceof Long) {
            elem.setName("integer");
            elem.setContent(object.toString());
        } else if (object instanceof Float) {
            elem.setName("real");
            elem.setContent(object.toString());
        } else if (object instanceof Double) {
            elem.setName("real");
            elem.setContent(object.toString());
        } else if (object instanceof Boolean) {
            elem.setName("boolean");
            elem.setContent(object.toString());
        } else if (object instanceof byte[]) {
            elem.setName("data");
            elem.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof XMLGregorianCalendar) {
            elem.setName("date");
            elem.setContent(((XMLGregorianCalendar)object).toXMLFormat() + "Z");
        } else if (object instanceof BPLUid) {
            elem.setName("UID");
            elem.setContent(Integer.toString(((BPLUid)object).getNumber()));
        } else {
            elem.setName("unsupported");
            elem.setContent(object.toString());
        }
        parent.addChild(elem);
    }

    private void parseObjectTable(DataInputStream in) throws IOException {
        int marker;
        while ((marker = in.read()) != -1) {
            block0 : switch ((marker & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(in, marker & 0xF);
                    break;
                }
                case 1: {
                    int count = 1 << (marker & 0xF);
                    this.parseInt(in, count);
                    break;
                }
                case 2: {
                    int count = 1 << (marker & 0xF);
                    this.parseReal(in, count);
                    break;
                }
                case 3: {
                    switch (marker & 0xF) {
                        case 3: {
                            this.parseDate(in);
                            break block0;
                        }
                    }
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 4: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseData(in, count);
                    break;
                }
                case 5: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseAsciiString(in, count);
                    break;
                }
                case 6: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseUnicodeString(in, count);
                    break;
                }
                case 7: {
                    return;
                }
                case 8: {
                    int count = (marker & 0xF) + 1;
                    this.parseUID(in, count);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 10: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(in, count);
                        break;
                    }
                    this.parseByteArray(in, count);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 13: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(in, count);
                        break;
                    }
                    this.parseByteDict(in, count);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
            }
        }
    }

    private int readCount(DataInputStream in) throws IOException {
        int marker = in.read();
        if (marker == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((marker & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(marker));
        }
        int count = 1 << (marker & 0xF);
        int value = 0;
        for (int i = 0; i < count; ++i) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            value = value << 8 | b;
        }
        return value;
    }

    private void parsePrimitive(DataInputStream in, int primitive) throws IOException {
        switch (primitive) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(primitive));
            }
        }
    }

    private void parseByteArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i = 0; i < count; ++i) {
            arr.objref[i] = in.readByte() & 0xFF;
            if (arr.objref[i] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseShortArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i = 0; i < count; ++i) {
            arr.objref[i] = in.readShort() & 0xFFFF;
            if (arr.objref[i] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseData(DataInputStream in, int count) throws IOException {
        byte[] data = new byte[count];
        in.readFully(data);
        this.objectTable.add(data);
    }

    private void parseByteDict(DataInputStream in, int count) throws IOException {
        int i;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i = 0; i < count; ++i) {
            dict.keyref[i] = in.readByte() & 0xFF;
        }
        for (i = 0; i < count; ++i) {
            dict.objref[i] = in.readByte() & 0xFF;
        }
        this.objectTable.add(dict);
    }

    private void parseShortDict(DataInputStream in, int count) throws IOException {
        int i;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i = 0; i < count; ++i) {
            dict.keyref[i] = in.readShort() & 0xFFFF;
        }
        for (i = 0; i < count; ++i) {
            dict.objref[i] = in.readShort() & 0xFFFF;
        }
        this.objectTable.add(dict);
    }

    private void parseAsciiString(DataInputStream in, int count) throws IOException {
        byte[] buf = new byte[count];
        in.readFully(buf);
        String str = new String(buf, "ASCII");
        this.objectTable.add(str);
    }

    private void parseUID(DataInputStream in, int count) throws IOException {
        if (count > 4) {
            throw new IOException("parseUID: unsupported byte count: " + count);
        }
        byte[] uid = new byte[count];
        in.readFully(uid);
        this.objectTable.add(new BPLUid(new BigInteger(uid).intValue()));
    }

    private void parseInt(DataInputStream in, int count) throws IOException {
        if (count > 8) {
            throw new IOException("parseInt: unsupported byte count: " + count);
        }
        long value = 0L;
        for (int i = 0; i < count; ++i) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            value = value << 8 | (long)b;
        }
        this.objectTable.add(value);
    }

    private void parseReal(DataInputStream in, int count) throws IOException {
        switch (count) {
            case 4: {
                this.objectTable.add(new Float(in.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(new Double(in.readDouble()));
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + count);
            }
        }
    }

    private void parseUnknown(DataInputStream in) throws IOException {
        in.skipBytes(1);
        this.objectTable.add("unknown");
    }

    private void parseDate(DataInputStream in) throws IOException {
        this.objectTable.add(BinaryPListParser.fromTimerInterval(in.readDouble()));
    }

    private void parseUnicodeString(DataInputStream in, int count) throws IOException {
        char[] buf = new char[count];
        for (int i = 0; i < count; ++i) {
            buf[i] = in.readChar();
        }
        String str = new String(buf);
        this.objectTable.add(str);
    }

    private static XMLGregorianCalendar fromTimerInterval(double timerInterval) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(TIMER_INTERVAL_TIMEBASE + (long)timerInterval * 1000L));
        XMLGregorianCalendar xmlgc = BinaryPListParser.getDatatypeFactory().newXMLGregorianCalendar(gc);
        xmlgc.setFractionalSecond(null);
        xmlgc.setTimezone(Integer.MIN_VALUE);
        return xmlgc;
    }

    private static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                InternalError ie = new InternalError("Can't create XML datatype factory.");
                ie.initCause(ex);
                throw ie;
            }
        }
        return datatypeFactory;
    }

    private static class PosByteArrayInputStream
    extends ByteArrayInputStream {
        public PosByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public int getPos() {
            return this.pos;
        }
    }

    private static class BPLDict {
        ArrayList objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int i) {
            return this.objectTable.get(this.keyref[i]).toString();
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BPLDict{");
            for (int i = 0; i < this.keyref.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.keyref[i] < 0 || this.keyref[i] >= this.objectTable.size()) {
                    buf.append("#" + this.keyref[i]);
                } else if (this.objectTable.get(this.keyref[i]) == this) {
                    buf.append("*" + this.keyref[i]);
                } else {
                    buf.append(this.objectTable.get(this.keyref[i]));
                }
                buf.append(":");
                if (this.objref[i] < 0 || this.objref[i] >= this.objectTable.size()) {
                    buf.append("#" + this.objref[i]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i]) == this) {
                    buf.append("*" + this.objref[i]);
                    continue;
                }
                buf.append(this.objectTable.get(this.objref[i]));
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private static class BPLArray {
        ArrayList objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Array{");
            for (int i = 0; i < this.objref.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.objectTable.size() > this.objref[i] && this.objectTable.get(this.objref[i]) != this) {
                    buf.append(this.objectTable.get(this.objref[i]));
                    continue;
                }
                buf.append("*" + this.objref[i]);
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private static class BPLUid {
        private final int number;

        public BPLUid(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

