/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther;

import ch.randelshofer.quaqua.jaguar.QuaquaJaguarTabbedPaneUI;
import ch.randelshofer.quaqua.panther.QuaquaPantherScrollTabbedPaneUI;
import ch.randelshofer.quaqua.util.NavigatableTabbedPaneUI;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;

public class QuaquaPantherTabbedPaneUI
extends TabbedPaneUI
implements NavigatableTabbedPaneUI {
    private JTabbedPane tabPane;
    private TabbedPaneUI currentUI;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaPantherTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        if (this.tabPane.getClientProperty("Quaqua.TabbedPane.tabLayoutPolicy") == null) {
            this.tabPane.putClientProperty("Quaqua.TabbedPane.tabLayoutPolicy", UIManager.get("TabbedPane.tabLayoutPolicy"));
            this.tabPane.setTabLayoutPolicy(UIManager.getInt("TabbedPane.tabLayoutPolicy"));
        }
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            QuaquaJaguarTabbedPaneUI qjtpui = (QuaquaJaguarTabbedPaneUI)QuaquaJaguarTabbedPaneUI.createUI(c);
            qjtpui.setPropertyPrefix("TabbedPane.wrap.");
            this.currentUI = qjtpui;
        } else {
            QuaquaPantherScrollTabbedPaneUI qptpui = (QuaquaPantherScrollTabbedPaneUI)QuaquaPantherScrollTabbedPaneUI.createUI(c);
            qptpui.setPropertyPrefix("TabbedPane.scroll.");
            this.currentUI = qptpui;
        }
        this.currentUI.installUI(c);
        this.tabPane.setRequestFocusEnabled(UIManager.getBoolean("TabbedPane.requestFocusEnabled"));
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        if (this.currentUI != null) {
            this.currentUI.uninstallUI(c);
        }
        this.tabPane = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        return this.currentUI.getTabBounds(pane, index);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return this.currentUI.getTabRunCount(pane);
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this.currentUI.tabForCoordinate(pane, x, y);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.currentUI.paint(g, c);
    }

    @Override
    public void navigateSelectedTab(int direction) {
        ((NavigatableTabbedPaneUI)((Object)this.currentUI)).navigateSelectedTab(direction);
    }

    @Override
    public Integer getIndexForMnemonic(int mnemonic) {
        return ((NavigatableTabbedPaneUI)((Object)this.currentUI)).getIndexForMnemonic(mnemonic);
    }

    @Override
    public boolean requestFocusForVisibleComponent() {
        return ((NavigatableTabbedPaneUI)((Object)this.currentUI)).requestFocusForVisibleComponent();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            if (name.equals("tabLayoutPolicy")) {
                QuaquaPantherTabbedPaneUI.this.uninstallUI(pane);
                QuaquaPantherTabbedPaneUI.this.installUI(pane);
            }
        }
    }
}

