/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import ch.randelshofer.quaqua.osx.JNILoader;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessControlException;

public class OSXApplication {
    private static final boolean DEBUG = true;
    private static volatile Boolean isNativeCodeAvailable;
    private static final int EXPECTED_NATIVE_CODE_VERSION = 2;
    private static final Object ICON_IMAGE_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            Class<OSXApplication> clazz = OSXApplication.class;
            // MONITORENTER : ch.randelshofer.quaqua.osx.OSXApplication.class
            if (isNativeCodeAvailable == null) {
                boolean success = false;
                try {
                    int nativeCodeVersion;
                    Toolkit.getDefaultToolkit().getSystemEventQueue();
                    String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                    if (value == null) {
                        value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                    }
                    if (value != null && value.equals("true")) {
                        success = true;
                    } else {
                        String osArch = System.getProperty("os.arch");
                        String[] libraryNames = osArch.equals("x86_64") ? new String[]{"quaqua64"} : new String[]{"quaqua64", "quaqua"};
                        for (String libraryName : libraryNames) {
                            try {
                                JNILoader.loadLibrary(libraryName);
                                success = true;
                                break;
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.err.println("Warning: " + OSXApplication.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                            catch (AccessControlException e) {
                                System.err.println("Warning: " + OSXApplication.class + " access controller denied loading library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                System.err.println("Warning: " + OSXApplication.class + " couldn't load library \"" + System.mapLibraryName(libraryName) + "\". " + e);
                                success = false;
                            }
                        }
                    }
                    if (success && (nativeCodeVersion = OSXApplication.nativeGetNativeCodeVersion()) != 2) {
                        System.err.println("Warning: " + OSXApplication.class + " can't use library libquaqua.jnilib. It has version " + nativeCodeVersion + " instead of " + 2);
                        success = false;
                    }
                }
                finally {
                    isNativeCodeAvailable = success;
                }
            }
            // MONITOREXIT : clazz
        }
        if (isNativeCodeAvailable != Boolean.TRUE) return false;
        return true;
    }

    private OSXApplication() {
    }

    public static void requestUserAttention(boolean requestCritical) {
        if (OSXApplication.isNativeCodeAvailable()) {
            OSXApplication.nativeRequestUserAttention(true);
        } else if (QuaquaManager.isOSX()) {
            try {
                Object app = Methods.invokeStatic("com.apple.cocoa.application.NSApplication", "sharedApplication");
                Methods.invoke(app, "requestUserAttention", app.getClass().getDeclaredField("UserAttentionRequestInformational").getInt(app));
            }
            catch (Throwable ex) {
                System.err.println("Quaqua Warning: Couldn't invoke NSApplication.requestUserAttention");
            }
        }
    }

    private static native void nativeRequestUserAttention(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getIconImage(int size) {
        BufferedImage image = null;
        if (OSXApplication.isNativeCodeAvailable()) {
            try {
                byte[] tiffData;
                Object object = ICON_IMAGE_LOCK;
                synchronized (object) {
                    tiffData = OSXApplication.nativeGetIconImage(size);
                }
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                image = Images.toBufferedImage(rImg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (image == null) {
            image = Images.toBufferedImage(Images.createImage(QuaquaIconFactory.class.getResource("/ch/randelshofer/quaqua/images/ApplicationIcon.png")));
        }
        if (image.getWidth() != size) {
            image = Images.toBufferedImage(image.getScaledInstance(size, size, 4));
        }
        return image;
    }

    private static synchronized native byte[] nativeGetIconImage(int var0);

    private static native int nativeGetNativeCodeVersion();

    static {
        ICON_IMAGE_LOCK = new Object();
    }
}

