/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.osx.OSXFile;
import java.io.File;

public class LinuxFileSystemView
extends QuaquaFileSystemView {
    private File computer = new File("computer:///");
    private File volumesFolder = new File("/");
    private File desktop = new File(System.getProperty("user.home") + "/Desktop");
    private File systemVolume = new File("/");
    private static final boolean DEBUG = false;

    @Override
    public File getComputer() {
        return this.computer;
    }

    @Override
    public File getSystemVolume() {
        return this.volumesFolder;
    }

    public File getDesktop() {
        return this.desktop;
    }

    @Override
    public File[] getRoots() {
        return new File[]{this.volumesFolder};
    }

    @Override
    public boolean isHiddenFile(File f) {
        if (f.isHidden()) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '.';
    }

    @Override
    public boolean isRoot(File f) {
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        if (f.equals(this.computer)) {
            return true;
        }
        File[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        File parentFile = dir.getParentFile();
        return parentFile == null || parentFile.equals(this.volumesFolder);
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public String getSystemDisplayName(File f) {
        if (f.equals(this.systemVolume)) {
            return "/";
        }
        if (OSXFile.canWorkWithAliases()) {
            return OSXFile.getDisplayName(f);
        }
        return this.target.getSystemDisplayName(f);
    }
}

