/*
** ###################################################################
**     Processor:           iMX6SX
**     Compilers:           Keil ARM C/C++ Compiler
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    IMX6SXRM, Rev C, 07/2014
**     Version:             rev. 1.2, 2014-10-29
**     Build:               b141029
**
**     Abstract:
**         This header file implements peripheral memory map for iMX6SX
**         processor.
**
**     Copyright (c) 1997 - 2014 Freescale Semiconductor, Inc.
**     All Rights Reserved.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2014-09-04)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file iMX6SX.h
 * @version 1.2
 * @date 2014-10-29
 * @brief Peripheral memory map for iMX6SX
 *
 * This header file implements peripheral memory map for iMX6SX processor.
 */


/* ----------------------------------------------------------------------------
   -- MCU activation
   ---------------------------------------------------------------------------- */

/* Prevention from multiple including the same memory map */
#if !defined(MCU_iMX6SX)  /* Check if memory map has not been already included */
#define MCU_iMX6SX

/* Check if another memory map has not been also included */
#if (defined(MCU_ACTIVE))
  #error iMX6SX memory map: There is already included another memory map. Only one memory map can be included.
#endif /* (defined(MCU_ACTIVE)) */
#define MCU_ACTIVE

#include <stdint.h>

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100u
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000u


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
typedef enum {
  INT_Initial_Stack_Pointer    = 0,                /**< Initial stack pointer */
  INT_Initial_Program_Counter  = 1,                /**< Initial program counter */
  INT_NMI                      = 2,                /**< Non-maskable interrupt */
  INT_Hard_Fault               = 3,                /**< Hard fault exception */
  INT_Mem_Manage_Fault         = 4,                /**< Memory Manage Fault */
  INT_Bus_Fault                = 5,                /**< Bus fault exception */
  INT_Usage_Fault              = 6,                /**< Usage fault exception */
  INT_Reserved7                = 7,                /**< Reserved interrupt 7 */
  INT_Reserved8                = 8,                /**< Reserved interrupt 8 */
  INT_Reserved9                = 9,                /**< Reserved interrupt 9 */
  INT_Reserved10               = 10,               /**< Reserved interrupt 10 */
  INT_SVCall                   = 11,               /**< A supervisor call exception */
  INT_DebugMonitor             = 12,               /**< Debug Monitor */
  INT_Reserved13               = 13,               /**< Reserved interrupt 13 */
  INT_PendableSrvReq           = 14,               /**< PendSV exception - request for system level service */
  INT_SysTick                  = 15,               /**< SysTick interrupt */
  INT_CORTEX_M4                = 16,               /**< Cache Controller interrupt */
  INT_DAP                      = 17,               /**< Debug Access Port interrupt request */
  INT_SDMA                     = 18,               /**< SDMA interrupt request from all channels */
  INT_Reserved19               = 19,               /**< Reserved */
  INT_SNVS_PMIC                = 20,               /**< PMIC power off request */
  INT_LCDIF1                   = 21,               /**< LCDIF1 Sync Interrupt */
  INT_LCDIF2                   = 22,               /**< LCDIF2 Sync Interrupt */
  INT_CSI1                     = 23,               /**< CMOS Sensor Interface interrupt request */
  INT_PXP                      = 24,               /**< PXP interrupt */
  INT_Reserved25               = 25,               /**< Reserved */
  INT_GPU                      = 26,               /**< GPU general interrupt request */
  INT_WDOG3                    = 27,               /**< WDOG3 interrupt request */
  INT_SEMA4_CP1                = 28,               /**< SEMA4 CP1 interrupt request */
  INT_APBH                     = 29,               /**< DMA Logical OR of APBH DMA channels 0-3 completion and error interrupts */
  INT_EIM                      = 30,               /**< EIM interrupt request */
  INT_BCH                      = 31,               /**< BCH operation complete interrupt */
  INT_GPMI                     = 32,               /**< GPMI operation timeout error interrupt */
  INT_UART6                    = 33,               /**< UART6 interrupt request */
  INT_eCSPI5                   = 34,               /**< eCSPI5 interrupt request */
  INT_SNVS_Consolidated        = 35,               /**< SNVS consolidated interrupt */
  INT_SNVS_Security            = 36,               /**< SNVS security interrupt */
  INT_CSU                      = 37,               /**< CSU interrupt request 1 */
  INT_uSDHC1                   = 38,               /**< uSDHC1 (Enhanced SDHC) interrupt request */
  INT_uSDHC2                   = 39,               /**< uSDHC2 (Enhanced SDHC) interrupt request */
  INT_uSDHC3                   = 40,               /**< uSDHC3 (Enhanced SDHC) interrupt request */
  INT_uSDHC4                   = 41,               /**< uSDHC4 (Enhanced SDHC) interrupt request */
  INT_UART1                    = 42,               /**< UART1 interrupt request */
  INT_UART2                    = 43,               /**< UART2 interrupt request */
  INT_UART3                    = 44,               /**< UART3 interrupt request */
  INT_UART4                    = 45,               /**< UART4 interrupt request */
  INT_UART5                    = 46,               /**< UART5 interrupt request */
  INT_eCSPI1                   = 47,               /**< eCSPI1 interrupt request */
  INT_eCSPI2                   = 48,               /**< eCSPI2 interrupt request */
  INT_eCSPI3                   = 49,               /**< eCSPI3 interrupt request */
  INT_eCSPI4                   = 50,               /**< eCSPI4 interrupt request */
  INT_I2C4                     = 51,               /**< I2C4 interrupt request */
  INT_I2C1                     = 52,               /**< I2C1 interrupt request */
  INT_I2C2                     = 53,               /**< I2C2 interrupt request */
  INT_I2C3                     = 54,               /**< I2C3 interrupt request */
  INT_RDC                      = 55,               /**< RDC interrupt request */
  INT_USB_HISC                 = 56,               /**< USB HISC Host interrupt request */
  INT_CSI2                     = 57,               /**< CSI interrupt */
  INT_USB_OTG2                 = 58,               /**< USB OTG 2 interrupt request */
  INT_USB_OTG1                 = 59,               /**< USB OTG 1 interrupt request */
  INT_USB_PHY_UTMI0            = 60,               /**< UTMI0 interrupt request */
  INT_USB_PHY_UTMI1            = 61,               /**< UTMI1 interrupt request */
  INT_SSI1                     = 62,               /**< SSI1 interrupt request */
  INT_SSI2                     = 63,               /**< SSI2 interrupt request */
  INT_SSI3                     = 64,               /**< SSI3 interrupt request */
  INT_TEMPMON                  = 65,               /**< Temperature Sensor (temp. greater than threshold) interrupt request */
  INT_ASRC                     = 66,               /**< ASRC interrupt request */
  INT_ESAI                     = 67,               /**< ESAI interrupt request */
  INT_SPDIF                    = 68,               /**< SPDIF Rx/Tx interrupt */
  INT_MLB_Error                = 69,               /**< MLB error interrupt request */
  INT_PMU_BrownOut             = 70,               /**< Brown-out event */
  INT_GPT                      = 71,               /**< Logical OR of GPT rollover interrupt line, input capture 1 & 2 lines, output compare 1, 2 & 3 interrupt lines */
  INT_EPIT1                    = 72,               /**< EPIT1 output compare interrupt */
  INT_EPIT2                    = 73,               /**< EPIT2 output compare interrupt */
  INT_GPIO1_INT7               = 74,               /**< INT7 interrupt request */
  INT_GPIO1_INT6               = 75,               /**< INT6 interrupt request */
  INT_GPIO1_INT5               = 76,               /**< INT5 interrupt request */
  INT_GPIO1_INT4               = 77,               /**< INT4 interrupt request */
  INT_GPIO1_INT3               = 78,               /**< INT3 interrupt request */
  INT_GPIO1_INT2               = 79,               /**< INT2 interrupt request */
  INT_GPIO1_INT1               = 80,               /**< INT1 interrupt request */
  INT_GPIO1_INT0               = 81,               /**< INT0 interrupt request */
  INT_GPIO1_Combined_0_15      = 82,               /**< Combined interrupt indication for GPIO1 signals 0 - 15 */
  INT_GPIO1_Combined_16_31     = 83,               /**< Combined interrupt indication for GPIO1 signals 16 - 31 */
  INT_GPIO2_Combined_0_15      = 84,               /**< Combined interrupt indication for GPIO2 signals 0 - 15 */
  INT_GPIO2_Combined_16_31     = 85,               /**< Combined interrupt indication for GPIO2 signals 16 - 31 */
  INT_GPIO3_Combined_0_15      = 86,               /**< Combined interrupt indication for GPIO3 signals 0 - 15 */
  INT_GPIO3_Combined_16_31     = 87,               /**< Combined interrupt indication for GPIO3 signals 16 - 31 */
  INT_GPIO4_Combined_0_15      = 88,               /**< Combined interrupt indication for GPIO4 signals 0 - 15 */
  INT_GPIO4_Combined_16_31     = 89,               /**< Combined interrupt indication for GPIO4 signals 16 - 31 */
  INT_GPIO5_Combined_0_15      = 90,               /**< Combined interrupt indication for GPIO5 signals 0 - 15 */
  INT_GPIO5_Combined_16_31     = 91,               /**< Combined interrupt indication for GPIO5 signals 16 - 31 */
  INT_GPIO6_Combined_0_15      = 92,               /**< Combined interrupt indication for GPIO6 signals 0 - 15 */
  INT_GPIO6_Combined_16_31     = 93,               /**< Combined interrupt indication for GPIO6 signals 16 - 31 */
  INT_GPIO7_Combined_0_15      = 94,               /**< Combined interrupt indication for GPIO7 signals 0 - 15 */
  INT_GPIO7_Combined_16_31     = 95,               /**< Combined interrupt indication for GPIO7 signals 16 - 31 */
  INT_WDOG1                    = 96,               /**< WDOG1 timer reset interrupt request */
  INT_WDOG2                    = 97,               /**< WDOG2 timer reset interrupt request */
  INT_KPP                      = 98,               /**< Key Pad interrupt request */
  INT_PWM1_PWM5                = 99,               /**< Cumulative interrupt line for PWM1/PWM5. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts */
  INT_PWM2_PWM6                = 100,              /**< Cumulative interrupt line for PWM2/PWM6. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts */
  INT_PWM3_PWM7                = 101,              /**< Cumulative interrupt line for PWM3/PWM7. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts */
  INT_PWM4_PWM8                = 102,              /**< Cumulative interrupt line for PWM4/PWM8. Logical OR of rollover, compare, and FIFO waterlevel crossing interrupts */
  INT_CCM1                     = 103,              /**< CCM interrupt request 1 */
  INT_CCM2                     = 104,              /**< CCM interrupt request 2 */
  INT_GPC                      = 105,              /**< GPC interrupt request 1 */
  INT_MU_A9                    = 106,              /**< Message unit interrupt to A9 core */
  INT_SRC                      = 107,              /**< SRC interrupt request */
  INT_CPU_L2                   = 108,              /**< L2 interrupt request */
  INT_CPU_Parity               = 109,              /**< Parity Check error interrupt request */
  INT_CPU_Perfomance           = 110,              /**< Performance Unit interrupt */
  INT_CPU_CTI_Trigger          = 111,              /**< CTI trigger outputs interrupt */
  INT_SRC_WDOG                 = 112,              /**< Combined CPU wdog interrupts (4x) out of SRC */
  INT_SAI1                     = 113,              /**< SAI1 interrupt request */
  INT_SAI2                     = 114,              /**< SAI2 interrupt request */
  INT_MU_M4                    = 115,              /**< Message unit Interrupt to M4 core */
  INT_ADC1                     = 116,              /**< ADC1 interrupt request */
  INT_ADC2                     = 117,              /**< ADC2 interrupt request */
  INT_ENET2                    = 118,              /**< ENET2 Interrupt Request */
  INT_ENET2_Timer              = 119,              /**< ENET2 1588 Timer interrupt [synchronous] request */
  INT_SJC                      = 120,              /**< SJC interrupt from General Purpose register */
  INT_CAAM0                    = 121,              /**< CAAM job ring 0 interrupt */
  INT_CAAM1                    = 122,              /**< CAAM job ring 1 interrupt */
  INT_QSPI1                    = 123,              /**< QSPI1 interrupt request */
  INT_TZASC                    = 124,              /**< TZASC (PL380) interrupt request */
  INT_QSPI2                    = 125,              /**< QSPI2 interrupt request */
  INT_FLEXCAN1                 = 126,              /**< FLEXCAN1 combined interrupt */
  INT_FLEXCAN2                 = 127,              /**< FLEXCAN2 combined interrupt */
  INT_Reserved128              = 128,              /**< Reserved */
  INT_Reserved129              = 129,              /**< Reserved */
  INT_CANFD1                   = 130,              /**< CANFD1 interrupt request */
  INT_CANFD2                   = 131,              /**< CANFD2 interrupt request */
  INT_SEMA4_CP0                = 132,              /**< SEMA4 CP0 interrupt request */
  INT_MLB_Channels_31_0        = 133,              /**< MLB Interrupt request for channels [31:0] */
  INT_ENET1                    = 134,              /**< ENET1 Interrupt Request */
  INT_ENET1_Timer              = 135,              /**< ENET1 1588 Timer interrupt [synchronous] request */
  INT_PCIe1                    = 136,              /**< PCIe interrupt request 1 */
  INT_PCIe2                    = 137,              /**< PCIe interrupt request 2 */
  INT_PCIe3                    = 138,              /**< PCIe interrupt request 3 */
  INT_PCIe4                    = 139,              /**< PCIe interrupt request 4 */
  INT_DCIC1                    = 140,              /**< DCIC1 interrupt request */
  INT_DCIC2                    = 141,              /**< DCIC2 interrupt request */
  INT_MLB_Channels_63_32       = 142,              /**< MLB Interrupt request for channels [63:32] */
  INT_PMU_BrownOutCore         = 143               /**< Brown out of core, gpu, and chip digital regulators occurred */
} IRQInterruptIndex;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Peripheral type defines
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_defines Peripheral type defines
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral ADC
 * @{
 */

/** ADC - Peripheral register structure */
typedef struct ADC_MemMap {
  uint32_t HC0;                                    /**< Control register for hardware triggers, offset: 0x0 */
  uint32_t HC1;                                    /**< Control register for hardware triggers, offset: 0x4 */
  uint32_t HS;                                     /**< Status register for HW triggers, offset: 0x8 */
  uint32_t R0;                                     /**< Data result register for HW triggers, offset: 0xC */
  uint32_t R1;                                     /**< Data result register for HW triggers, offset: 0x10 */
  uint32_t CFG;                                    /**< Configuration register, offset: 0x14 */
  uint32_t GC;                                     /**< General control register, offset: 0x18 */
  uint32_t GS;                                     /**< General status register, offset: 0x1C */
  uint32_t CV;                                     /**< Compare value register, offset: 0x20 */
  uint32_t OFS;                                    /**< Offset correction value register, offset: 0x24 */
  uint32_t CAL;                                    /**< Calibration value register, offset: 0x28 */
} volatile *ADC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register accessors */
#define ADC_HC0_REG(base)                        ((base)->HC0)
#define ADC_HC1_REG(base)                        ((base)->HC1)
#define ADC_HS_REG(base)                         ((base)->HS)
#define ADC_R0_REG(base)                         ((base)->R0)
#define ADC_R1_REG(base)                         ((base)->R1)
#define ADC_CFG_REG(base)                        ((base)->CFG)
#define ADC_GC_REG(base)                         ((base)->GC)
#define ADC_GS_REG(base)                         ((base)->GS)
#define ADC_CV_REG(base)                         ((base)->CV)
#define ADC_OFS_REG(base)                        ((base)->OFS)
#define ADC_CAL_REG(base)                        ((base)->CAL)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/* HC0 Bit Fields */
#define ADC_HC0_ADCH_MASK                        0x1Fu
#define ADC_HC0_ADCH_SHIFT                       0
#define ADC_HC0_ADCH(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_HC0_ADCH_SHIFT))&ADC_HC0_ADCH_MASK)
#define ADC_HC0_AIEN_MASK                        0x80u
#define ADC_HC0_AIEN_SHIFT                       7
/* HC1 Bit Fields */
#define ADC_HC1_ADCH_MASK                        0x1Fu
#define ADC_HC1_ADCH_SHIFT                       0
#define ADC_HC1_ADCH(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_HC1_ADCH_SHIFT))&ADC_HC1_ADCH_MASK)
#define ADC_HC1_AIEN_MASK                        0x80u
#define ADC_HC1_AIEN_SHIFT                       7
/* HS Bit Fields */
#define ADC_HS_COCO0_MASK                        0x1u
#define ADC_HS_COCO0_SHIFT                       0
#define ADC_HS_COCO1_MASK                        0x2u
#define ADC_HS_COCO1_SHIFT                       1
/* R0 Bit Fields */
#define ADC_R0_D_MASK                            0xFFFu
#define ADC_R0_D_SHIFT                           0
#define ADC_R0_D(x)                              (((uint32_t)(((uint32_t)(x))<<ADC_R0_D_SHIFT))&ADC_R0_D_MASK)
/* R1 Bit Fields */
#define ADC_R1_D_MASK                            0xFFFu
#define ADC_R1_D_SHIFT                           0
#define ADC_R1_D(x)                              (((uint32_t)(((uint32_t)(x))<<ADC_R1_D_SHIFT))&ADC_R1_D_MASK)
/* CFG Bit Fields */
#define ADC_CFG_ADICLK_MASK                      0x3u
#define ADC_CFG_ADICLK_SHIFT                     0
#define ADC_CFG_ADICLK(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG_ADICLK_SHIFT))&ADC_CFG_ADICLK_MASK)
#define ADC_CFG_MODE_MASK                        0xCu
#define ADC_CFG_MODE_SHIFT                       2
#define ADC_CFG_MODE(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_CFG_MODE_SHIFT))&ADC_CFG_MODE_MASK)
#define ADC_CFG_ADLSMP_MASK                      0x10u
#define ADC_CFG_ADLSMP_SHIFT                     4
#define ADC_CFG_ADIV_MASK                        0x60u
#define ADC_CFG_ADIV_SHIFT                       5
#define ADC_CFG_ADIV(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_CFG_ADIV_SHIFT))&ADC_CFG_ADIV_MASK)
#define ADC_CFG_ADLPC_MASK                       0x80u
#define ADC_CFG_ADLPC_SHIFT                      7
#define ADC_CFG_ADSTS_MASK                       0x300u
#define ADC_CFG_ADSTS_SHIFT                      8
#define ADC_CFG_ADSTS(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CFG_ADSTS_SHIFT))&ADC_CFG_ADSTS_MASK)
#define ADC_CFG_ADHSC_MASK                       0x400u
#define ADC_CFG_ADHSC_SHIFT                      10
#define ADC_CFG_REFSEL_MASK                      0x1800u
#define ADC_CFG_REFSEL_SHIFT                     11
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG_REFSEL_SHIFT))&ADC_CFG_REFSEL_MASK)
#define ADC_CFG_ADTRG_MASK                       0x2000u
#define ADC_CFG_ADTRG_SHIFT                      13
#define ADC_CFG_AVGS_MASK                        0xC000u
#define ADC_CFG_AVGS_SHIFT                       14
#define ADC_CFG_AVGS(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_CFG_AVGS_SHIFT))&ADC_CFG_AVGS_MASK)
#define ADC_CFG_OVWREN_MASK                      0x10000u
#define ADC_CFG_OVWREN_SHIFT                     16
/* GC Bit Fields */
#define ADC_GC_ADACKEN_MASK                      0x1u
#define ADC_GC_ADACKEN_SHIFT                     0
#define ADC_GC_DMAEN_MASK                        0x2u
#define ADC_GC_DMAEN_SHIFT                       1
#define ADC_GC_ACREN_MASK                        0x4u
#define ADC_GC_ACREN_SHIFT                       2
#define ADC_GC_ACFGT_MASK                        0x8u
#define ADC_GC_ACFGT_SHIFT                       3
#define ADC_GC_ACFE_MASK                         0x10u
#define ADC_GC_ACFE_SHIFT                        4
#define ADC_GC_AVGE_MASK                         0x20u
#define ADC_GC_AVGE_SHIFT                        5
#define ADC_GC_ADCO_MASK                         0x40u
#define ADC_GC_ADCO_SHIFT                        6
#define ADC_GC_CAL_MASK                          0x80u
#define ADC_GC_CAL_SHIFT                         7
/* GS Bit Fields */
#define ADC_GS_ADACT_MASK                        0x1u
#define ADC_GS_ADACT_SHIFT                       0
#define ADC_GS_CALF_MASK                         0x2u
#define ADC_GS_CALF_SHIFT                        1
#define ADC_GS_AWKST_MASK                        0x4u
#define ADC_GS_AWKST_SHIFT                       2
/* CV Bit Fields */
#define ADC_CV_CV1_MASK                          0xFFFu
#define ADC_CV_CV1_SHIFT                         0
#define ADC_CV_CV1(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV_CV1_SHIFT))&ADC_CV_CV1_MASK)
#define ADC_CV_CV2_MASK                          0xFFF0000u
#define ADC_CV_CV2_SHIFT                         16
#define ADC_CV_CV2(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV_CV2_SHIFT))&ADC_CV_CV2_MASK)
/* OFS Bit Fields */
#define ADC_OFS_OFS_MASK                         0xFFFu
#define ADC_OFS_OFS_SHIFT                        0
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x))<<ADC_OFS_OFS_SHIFT))&ADC_OFS_OFS_MASK)
#define ADC_OFS_SIGN_MASK                        0x1000u
#define ADC_OFS_SIGN_SHIFT                       12
/* CAL Bit Fields */
#define ADC_CAL_CAL_CODE_MASK                    0xFu
#define ADC_CAL_CAL_CODE_SHIFT                   0
#define ADC_CAL_CAL_CODE(x)                      (((uint32_t)(((uint32_t)(x))<<ADC_CAL_CAL_CODE_SHIFT))&ADC_CAL_CAL_CODE_MASK)

/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC1 base pointer */
#define ADC1_BASE_PTR                            ((ADC_MemMapPtr)0x42280000u)
/** Peripheral ADC2 base pointer */
#define ADC2_BASE_PTR                            ((ADC_MemMapPtr)0x42284000u)
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC1_BASE_PTR, ADC2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register instance definitions */
/* ADC1 */
#define ADC1_HC0                                 ADC_HC0_REG(ADC1_BASE_PTR)
#define ADC1_HC1                                 ADC_HC1_REG(ADC1_BASE_PTR)
#define ADC1_HS                                  ADC_HS_REG(ADC1_BASE_PTR)
#define ADC1_R0                                  ADC_R0_REG(ADC1_BASE_PTR)
#define ADC1_R1                                  ADC_R1_REG(ADC1_BASE_PTR)
#define ADC1_CFG                                 ADC_CFG_REG(ADC1_BASE_PTR)
#define ADC1_GC                                  ADC_GC_REG(ADC1_BASE_PTR)
#define ADC1_GS                                  ADC_GS_REG(ADC1_BASE_PTR)
#define ADC1_CV                                  ADC_CV_REG(ADC1_BASE_PTR)
#define ADC1_OFS                                 ADC_OFS_REG(ADC1_BASE_PTR)
#define ADC1_CAL                                 ADC_CAL_REG(ADC1_BASE_PTR)
/* ADC2 */
#define ADC2_HC0                                 ADC_HC0_REG(ADC2_BASE_PTR)
#define ADC2_HC1                                 ADC_HC1_REG(ADC2_BASE_PTR)
#define ADC2_HS                                  ADC_HS_REG(ADC2_BASE_PTR)
#define ADC2_R0                                  ADC_R0_REG(ADC2_BASE_PTR)
#define ADC2_R1                                  ADC_R1_REG(ADC2_BASE_PTR)
#define ADC2_CFG                                 ADC_CFG_REG(ADC2_BASE_PTR)
#define ADC2_GC                                  ADC_GC_REG(ADC2_BASE_PTR)
#define ADC2_GS                                  ADC_GS_REG(ADC2_BASE_PTR)
#define ADC2_CV                                  ADC_CV_REG(ADC2_BASE_PTR)
#define ADC2_OFS                                 ADC_OFS_REG(ADC2_BASE_PTR)
#define ADC2_CAL                                 ADC_CAL_REG(ADC2_BASE_PTR)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ADC_Peripheral */


/* ----------------------------------------------------------------------------
   -- AFE
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AFE_Peripheral AFE
 * @{
 */

/** AFE - Peripheral register structure */
typedef struct AFE_MemMap {
  uint32_t BLOCK_ID;                               /**< , offset: 0x0 */
  uint32_t PDBUF;                                  /**< Power Down Buffers, offset: 0x4 */
  uint32_t SWRST;                                  /**< Software Reset, offset: 0x8 */
  uint8_t RESERVED_0[12];
  uint32_t BGREG;                                  /**< Band Gap, offset: 0x18 */
  uint8_t RESERVED_1[996];
  uint32_t ACCESSAR_ID;                            /**< Accessar ID, offset: 0x400 */
  uint32_t PDADC;                                  /**< Power Down ADC, offset: 0x404 */
  uint32_t PDSARH;                                 /**< Power Down SAR High, offset: 0x408 */
  uint32_t PDSARL;                                 /**< Power Down SAR Low, offset: 0x40C */
  uint32_t PDADCRFH;                               /**< Power Down ADC Ref. High, offset: 0x410 */
  uint32_t PDADCRFL;                               /**< Power Down ADC Ref. Low, offset: 0x414 */
  uint8_t RESERVED_2[4];
  uint32_t ADCGN;                                  /**< ADC Gain, offset: 0x41C */
  uint8_t RESERVED_3[20];
  uint32_t REFTRIML;                               /**< ADC Ref Trim Low, offset: 0x434 */
  uint32_t REFTRIMH;                               /**< ADC Ref Trim High, offset: 0x438 */
  uint8_t RESERVED_4[16];
  uint32_t DACAMP;                                 /**< Clamp DAC Trim, offset: 0x44C */
  uint8_t RESERVED_5[4];
  uint32_t CLMPDAT;                                /**< Clamp DAC Data, offset: 0x454 */
  uint32_t CLMPAMP;                                /**< Clamp DAC Control, offset: 0x458 */
  uint32_t CLAMP;                                  /**< Clamp Control, offset: 0x45C */
  uint32_t INPBUF;                                 /**< Input Buffer, offset: 0x460 */
  uint32_t INPFLT;                                 /**< Analog Input Filter, offset: 0x464 */
  uint32_t ADCDGN;                                 /**< ADC Digital Gain, offset: 0x468 */
  uint32_t OFFDRV;                                 /**< Off-Chip Drive, offset: 0x46C */
  uint32_t INPCONFIG;                              /**< VADC INPUT CONFIG, offset: 0x470 */
  uint32_t PROGDELAY;                              /**< VADC PROG DELAY, offset: 0x474 */
  uint32_t ADCOMT;                                 /**< ADC COMPARATOR TIMING, offset: 0x478 */
  uint32_t ALGDELAY;                               /**< ALGORITHM DELAY, offset: 0x47C */
  uint8_t RESERVED_6[896];
  uint32_t ACC_ID;                                 /**< Acc ID, offset: 0x800 */
  uint32_t ACCSTA;                                 /**< ACC STATUS, offset: 0x804 */
  uint32_t ACCNOSLI;                               /**< ACC NUMBER OF SLICE, offset: 0x808 */
  uint32_t ACCCALCON;                              /**< ACC CALIBRATE CONTROL, offset: 0x80C */
  uint32_t BWEWRICTRL;                             /**< ACC BWE WRITE CONTROL, offset: 0x810 */
  uint32_t SELSLI;                                 /**< ACC SELECT SLICE, offset: 0x814 */
  uint32_t SELBYT;                                 /**< ACC SELECT BYTE, offset: 0x818 */
  uint8_t RESERVED_7[4];
  uint32_t REDVAL;                                 /**< ACC READ VALUE, offset: 0x820 */
  uint32_t WRIBYT;                                 /**< ACC WRITE BYTE, offset: 0x824 */
} volatile *AFE_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AFE - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AFE_Register_Accessor_Macros AFE - Register accessor macros
 * @{
 */


/* AFE - Register accessors */
#define AFE_BLOCK_ID_REG(base)                   ((base)->BLOCK_ID)
#define AFE_PDBUF_REG(base)                      ((base)->PDBUF)
#define AFE_SWRST_REG(base)                      ((base)->SWRST)
#define AFE_BGREG_REG(base)                      ((base)->BGREG)
#define AFE_ACCESSAR_ID_REG(base)                ((base)->ACCESSAR_ID)
#define AFE_PDADC_REG(base)                      ((base)->PDADC)
#define AFE_PDSARH_REG(base)                     ((base)->PDSARH)
#define AFE_PDSARL_REG(base)                     ((base)->PDSARL)
#define AFE_PDADCRFH_REG(base)                   ((base)->PDADCRFH)
#define AFE_PDADCRFL_REG(base)                   ((base)->PDADCRFL)
#define AFE_ADCGN_REG(base)                      ((base)->ADCGN)
#define AFE_REFTRIML_REG(base)                   ((base)->REFTRIML)
#define AFE_REFTRIMH_REG(base)                   ((base)->REFTRIMH)
#define AFE_DACAMP_REG(base)                     ((base)->DACAMP)
#define AFE_CLMPDAT_REG(base)                    ((base)->CLMPDAT)
#define AFE_CLMPAMP_REG(base)                    ((base)->CLMPAMP)
#define AFE_CLAMP_REG(base)                      ((base)->CLAMP)
#define AFE_INPBUF_REG(base)                     ((base)->INPBUF)
#define AFE_INPFLT_REG(base)                     ((base)->INPFLT)
#define AFE_ADCDGN_REG(base)                     ((base)->ADCDGN)
#define AFE_OFFDRV_REG(base)                     ((base)->OFFDRV)
#define AFE_INPCONFIG_REG(base)                  ((base)->INPCONFIG)
#define AFE_PROGDELAY_REG(base)                  ((base)->PROGDELAY)
#define AFE_ADCOMT_REG(base)                     ((base)->ADCOMT)
#define AFE_ALGDELAY_REG(base)                   ((base)->ALGDELAY)
#define AFE_ACC_ID_REG(base)                     ((base)->ACC_ID)
#define AFE_ACCSTA_REG(base)                     ((base)->ACCSTA)
#define AFE_ACCNOSLI_REG(base)                   ((base)->ACCNOSLI)
#define AFE_ACCCALCON_REG(base)                  ((base)->ACCCALCON)
#define AFE_BWEWRICTRL_REG(base)                 ((base)->BWEWRICTRL)
#define AFE_SELSLI_REG(base)                     ((base)->SELSLI)
#define AFE_SELBYT_REG(base)                     ((base)->SELBYT)
#define AFE_REDVAL_REG(base)                     ((base)->REDVAL)
#define AFE_WRIBYT_REG(base)                     ((base)->WRIBYT)

/*!
 * @}
 */ /* end of group AFE_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AFE Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AFE_Register_Masks AFE Register Masks
 * @{
 */

/* BLOCK_ID Bit Fields */
#define AFE_BLOCK_ID_BLOCK_ID_MASK               0xFFu
#define AFE_BLOCK_ID_BLOCK_ID_SHIFT              0
#define AFE_BLOCK_ID_BLOCK_ID(x)                 (((uint32_t)(((uint32_t)(x))<<AFE_BLOCK_ID_BLOCK_ID_SHIFT))&AFE_BLOCK_ID_BLOCK_ID_MASK)
/* PDBUF Bit Fields */
#define AFE_PDBUF_ACAFE_PD_N_MASK                0x1u
#define AFE_PDBUF_ACAFE_PD_N_SHIFT               0
#define AFE_PDBUF_BGR_BGR_PD_N_MASK              0x2u
#define AFE_PDBUF_BGR_BGR_PD_N_SHIFT             1
#define AFE_PDBUF_BGR_PD_N_MASK                  0x4u
#define AFE_PDBUF_BGR_PD_N_SHIFT                 2
#define AFE_PDBUF_TESTBUFFERS_PD_N_MASK          0x18u
#define AFE_PDBUF_TESTBUFFERS_PD_N_SHIFT         3
#define AFE_PDBUF_TESTBUFFERS_PD_N(x)            (((uint32_t)(((uint32_t)(x))<<AFE_PDBUF_TESTBUFFERS_PD_N_SHIFT))&AFE_PDBUF_TESTBUFFERS_PD_N_MASK)
/* SWRST Bit Fields */
#define AFE_SWRST_SYSCLK_SW_RST_N_MASK           0x1u
#define AFE_SWRST_SYSCLK_SW_RST_N_SHIFT          0
#define AFE_SWRST_ADC_PROC_CLK_SW_RST_N_MASK     0x2u
#define AFE_SWRST_ADC_PROC_CLK_SW_RST_N_SHIFT    1
#define AFE_SWRST_ACAFE_SW_RST_N_MASK            0x4u
#define AFE_SWRST_ACAFE_SW_RST_N_SHIFT           2
/* BGREG Bit Fields */
#define AFE_BGREG_BGR_TRIMLEVEL_MASK             0xFu
#define AFE_BGREG_BGR_TRIMLEVEL_SHIFT            0
#define AFE_BGREG_BGR_TRIMLEVEL(x)               (((uint32_t)(((uint32_t)(x))<<AFE_BGREG_BGR_TRIMLEVEL_SHIFT))&AFE_BGREG_BGR_TRIMLEVEL_MASK)
#define AFE_BGREG_BGR_EN_EXT_CURRENT_MASK        0x10u
#define AFE_BGREG_BGR_EN_EXT_CURRENT_SHIFT       4
/* ACCESSAR_ID Bit Fields */
#define AFE_ACCESSAR_ID_ACCESSAR_ID_MASK         0xFFu
#define AFE_ACCESSAR_ID_ACCESSAR_ID_SHIFT        0
#define AFE_ACCESSAR_ID_ACCESSAR_ID(x)           (((uint32_t)(((uint32_t)(x))<<AFE_ACCESSAR_ID_ACCESSAR_ID_SHIFT))&AFE_ACCESSAR_ID_ACCESSAR_ID_MASK)
/* PDADC Bit Fields */
#define AFE_PDADC_ACCESSAR_PD_N_MASK             0x1u
#define AFE_PDADC_ACCESSAR_PD_N_SHIFT            0
#define AFE_PDADC_DLYLOOP_PD_N_MASK              0x2u
#define AFE_PDADC_DLYLOOP_PD_N_SHIFT             1
#define AFE_PDADC_ADC_IREF_PD_N_MASK             0x4u
#define AFE_PDADC_ADC_IREF_PD_N_SHIFT            2
#define AFE_PDADC_CLAMP_PD_N_MASK                0x8u
#define AFE_PDADC_CLAMP_PD_N_SHIFT               3
/* PDSARH Bit Fields */
#define AFE_PDSARH_ADC_PD_N_MASK                 0x1u
#define AFE_PDSARH_ADC_PD_N_SHIFT                0
/* PDSARL Bit Fields */
#define AFE_PDSARL_ADC_PD_N_MASK                 0xFFu
#define AFE_PDSARL_ADC_PD_N_SHIFT                0
#define AFE_PDSARL_ADC_PD_N(x)                   (((uint32_t)(((uint32_t)(x))<<AFE_PDSARL_ADC_PD_N_SHIFT))&AFE_PDSARL_ADC_PD_N_MASK)
/* PDADCRFH Bit Fields */
#define AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N_MASK 0x1u
#define AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N_SHIFT 0
/* PDADCRFL Bit Fields */
#define AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N_MASK 0xFFu
#define AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N_SHIFT 0
#define AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N(x)  (((uint32_t)(((uint32_t)(x))<<AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N_SHIFT))&AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N_MASK)
/* ADCGN Bit Fields */
#define AFE_ADCGN_ADC_GAIN_MASK                  0xFu
#define AFE_ADCGN_ADC_GAIN_SHIFT                 0
#define AFE_ADCGN_ADC_GAIN(x)                    (((uint32_t)(((uint32_t)(x))<<AFE_ADCGN_ADC_GAIN_SHIFT))&AFE_ADCGN_ADC_GAIN_MASK)
/* REFTRIML Bit Fields */
#define AFE_REFTRIML_ADCREF_REFTRIM08_MASK       0x3u
#define AFE_REFTRIML_ADCREF_REFTRIM08_SHIFT      0
#define AFE_REFTRIML_ADCREF_REFTRIM08(x)         (((uint32_t)(((uint32_t)(x))<<AFE_REFTRIML_ADCREF_REFTRIM08_SHIFT))&AFE_REFTRIML_ADCREF_REFTRIM08_MASK)
#define AFE_REFTRIML_ADCREF_REFTRIM04_MASK       0xCu
#define AFE_REFTRIML_ADCREF_REFTRIM04_SHIFT      2
#define AFE_REFTRIML_ADCREF_REFTRIM04(x)         (((uint32_t)(((uint32_t)(x))<<AFE_REFTRIML_ADCREF_REFTRIM04_SHIFT))&AFE_REFTRIML_ADCREF_REFTRIM04_MASK)
#define AFE_REFTRIML_ADCREF_REFTRIM02_MASK       0x30u
#define AFE_REFTRIML_ADCREF_REFTRIM02_SHIFT      4
#define AFE_REFTRIML_ADCREF_REFTRIM02(x)         (((uint32_t)(((uint32_t)(x))<<AFE_REFTRIML_ADCREF_REFTRIM02_SHIFT))&AFE_REFTRIML_ADCREF_REFTRIM02_MASK)
#define AFE_REFTRIML_ADCREF_REFTRIMOP_MASK       0xC0u
#define AFE_REFTRIML_ADCREF_REFTRIMOP_SHIFT      6
#define AFE_REFTRIML_ADCREF_REFTRIMOP(x)         (((uint32_t)(((uint32_t)(x))<<AFE_REFTRIML_ADCREF_REFTRIMOP_SHIFT))&AFE_REFTRIML_ADCREF_REFTRIMOP_MASK)
/* REFTRIMH Bit Fields */
#define AFE_REFTRIMH_ADCREF_REFTRIM_MASK         0xFu
#define AFE_REFTRIMH_ADCREF_REFTRIM_SHIFT        0
#define AFE_REFTRIMH_ADCREF_REFTRIM(x)           (((uint32_t)(((uint32_t)(x))<<AFE_REFTRIMH_ADCREF_REFTRIM_SHIFT))&AFE_REFTRIMH_ADCREF_REFTRIM_MASK)
/* DACAMP Bit Fields */
#define AFE_DACAMP_CLAMPDAC_TRIM_MASK            0xFu
#define AFE_DACAMP_CLAMPDAC_TRIM_SHIFT           0
#define AFE_DACAMP_CLAMPDAC_TRIM(x)              (((uint32_t)(((uint32_t)(x))<<AFE_DACAMP_CLAMPDAC_TRIM_SHIFT))&AFE_DACAMP_CLAMPDAC_TRIM_MASK)
/* CLMPDAT Bit Fields */
#define AFE_CLMPDAT_CLAMPDAC_DATA_MASK           0xFFu
#define AFE_CLMPDAT_CLAMPDAC_DATA_SHIFT          0
#define AFE_CLMPDAT_CLAMPDAC_DATA(x)             (((uint32_t)(((uint32_t)(x))<<AFE_CLMPDAT_CLAMPDAC_DATA_SHIFT))&AFE_CLMPDAT_CLAMPDAC_DATA_MASK)
/* CLMPAMP Bit Fields */
#define AFE_CLMPAMP_CLAMP_DACDATA_EXTRA_MASK     0x7u
#define AFE_CLMPAMP_CLAMP_DACDATA_EXTRA_SHIFT    0
#define AFE_CLMPAMP_CLAMP_DACDATA_EXTRA(x)       (((uint32_t)(((uint32_t)(x))<<AFE_CLMPAMP_CLAMP_DACDATA_EXTRA_SHIFT))&AFE_CLMPAMP_CLAMP_DACDATA_EXTRA_MASK)
#define AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT_MASK    0x18u
#define AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT_SHIFT   3
#define AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT(x)      (((uint32_t)(((uint32_t)(x))<<AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT_SHIFT))&AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT_MASK)
#define AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE_MASK 0x20u
#define AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE_SHIFT 5
#define AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE_MASK 0x40u
#define AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE_SHIFT 6
/* CLAMP Bit Fields */
#define AFE_CLAMP_NCLAMP_POWERSAVE_MASK          0x1u
#define AFE_CLAMP_NCLAMP_POWERSAVE_SHIFT         0
#define AFE_CLAMP_CLAMP_VN_MASK                  0x2u
#define AFE_CLAMP_CLAMP_VN_SHIFT                 1
#define AFE_CLAMP_CLAMP_IPEN_REG_MASK            0x4u
#define AFE_CLAMP_CLAMP_IPEN_REG_SHIFT           2
#define AFE_CLAMP_CLAMP_INEN_REG_MASK            0x8u
#define AFE_CLAMP_CLAMP_INEN_REG_SHIFT           3
#define AFE_CLAMP_CLAMP_LOWCURRMODE_MASK         0x10u
#define AFE_CLAMP_CLAMP_LOWCURRMODE_SHIFT        4
#define AFE_CLAMP_DIV_PROC_CLK_MASK              0x20u
#define AFE_CLAMP_DIV_PROC_CLK_SHIFT             5
#define AFE_CLAMP_CLAMP_UP_DOWN_POLARITY_MASK    0x40u
#define AFE_CLAMP_CLAMP_UP_DOWN_POLARITY_SHIFT   6
#define AFE_CLAMP_CLAMP_PWN_MODE_MASK            0x80u
#define AFE_CLAMP_CLAMP_PWN_MODE_SHIFT           7
/* INPBUF Bit Fields */
#define AFE_INPBUF_BUFF_EN_RI_MASK               0x1u
#define AFE_INPBUF_BUFF_EN_RI_SHIFT              0
#define AFE_INPBUF_BUFF_EN_DI_MASK               0x2u
#define AFE_INPBUF_BUFF_EN_DI_SHIFT              1
#define AFE_INPBUF_BUFF_EN_CM_MASK               0x4u
#define AFE_INPBUF_BUFF_EN_CM_SHIFT              2
#define AFE_INPBUF_MUX_BUFFER_BP_EN_MASK         0x8u
#define AFE_INPBUF_MUX_BUFFER_BP_EN_SHIFT        3
#define AFE_INPBUF_MUX_BUFFER_15M_EN_MASK        0x10u
#define AFE_INPBUF_MUX_BUFFER_15M_EN_SHIFT       4
#define AFE_INPBUF_MUX_CLAMPEN_MASK              0x20u
#define AFE_INPBUF_MUX_CLAMPEN_SHIFT             5
/* INPFLT Bit Fields */
#define AFE_INPFLT_MUX_PDCURRENTMIRROR_MASK      0x1u
#define AFE_INPFLT_MUX_PDCURRENTMIRROR_SHIFT     0
#define AFE_INPFLT_MUX_FILTER_15M_EN_MASK        0x2u
#define AFE_INPFLT_MUX_FILTER_15M_EN_SHIFT       1
#define AFE_INPFLT_MUX_FILTERBYPASS_MASK         0x4u
#define AFE_INPFLT_MUX_FILTERBYPASS_SHIFT        2
/* ADCDGN Bit Fields */
#define AFE_ADCDGN_ADC_DIGITAL_GAIN_MASK         0x3Fu
#define AFE_ADCDGN_ADC_DIGITAL_GAIN_SHIFT        0
#define AFE_ADCDGN_ADC_DIGITAL_GAIN(x)           (((uint32_t)(((uint32_t)(x))<<AFE_ADCDGN_ADC_DIGITAL_GAIN_SHIFT))&AFE_ADCDGN_ADC_DIGITAL_GAIN_MASK)
#define AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS_MASK  0x40u
#define AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS_SHIFT 6
/* OFFDRV Bit Fields */
#define AFE_OFFDRV_ENOFFCHIPDRIVE_MASK           0x3u
#define AFE_OFFDRV_ENOFFCHIPDRIVE_SHIFT          0
#define AFE_OFFDRV_ENOFFCHIPDRIVE(x)             (((uint32_t)(((uint32_t)(x))<<AFE_OFFDRV_ENOFFCHIPDRIVE_SHIFT))&AFE_OFFDRV_ENOFFCHIPDRIVE_MASK)
#define AFE_OFFDRV_SH_TRIM_MASK                  0xCu
#define AFE_OFFDRV_SH_TRIM_SHIFT                 2
#define AFE_OFFDRV_SH_TRIM(x)                    (((uint32_t)(((uint32_t)(x))<<AFE_OFFDRV_SH_TRIM_SHIFT))&AFE_OFFDRV_SH_TRIM_MASK)
/* INPCONFIG Bit Fields */
#define AFE_INPCONFIG_INPUT_PULLDOWN_EN_MASK     0xFu
#define AFE_INPCONFIG_INPUT_PULLDOWN_EN_SHIFT    0
#define AFE_INPCONFIG_INPUT_PULLDOWN_EN(x)       (((uint32_t)(((uint32_t)(x))<<AFE_INPCONFIG_INPUT_PULLDOWN_EN_SHIFT))&AFE_INPCONFIG_INPUT_PULLDOWN_EN_MASK)
#define AFE_INPCONFIG_MUX_ENLF_MASK              0xF0u
#define AFE_INPCONFIG_MUX_ENLF_SHIFT             4
#define AFE_INPCONFIG_MUX_ENLF(x)                (((uint32_t)(((uint32_t)(x))<<AFE_INPCONFIG_MUX_ENLF_SHIFT))&AFE_INPCONFIG_MUX_ENLF_MASK)
/* PROGDELAY Bit Fields */
#define AFE_PROGDELAY_PROG_DELAY_MASK            0xFFu
#define AFE_PROGDELAY_PROG_DELAY_SHIFT           0
#define AFE_PROGDELAY_PROG_DELAY(x)              (((uint32_t)(((uint32_t)(x))<<AFE_PROGDELAY_PROG_DELAY_SHIFT))&AFE_PROGDELAY_PROG_DELAY_MASK)
/* ADCOMT Bit Fields */
#define AFE_ADCOMT_OVERRIDE_MASK                 0x1u
#define AFE_ADCOMT_OVERRIDE_SHIFT                0
#define AFE_ADCOMT_WAIT_TIME_MASK                0x3Eu
#define AFE_ADCOMT_WAIT_TIME_SHIFT               1
#define AFE_ADCOMT_WAIT_TIME(x)                  (((uint32_t)(((uint32_t)(x))<<AFE_ADCOMT_WAIT_TIME_SHIFT))&AFE_ADCOMT_WAIT_TIME_MASK)
#define AFE_ADCOMT_MEASURE_TIMING_MASK           0xC0u
#define AFE_ADCOMT_MEASURE_TIMING_SHIFT          6
#define AFE_ADCOMT_MEASURE_TIMING(x)             (((uint32_t)(((uint32_t)(x))<<AFE_ADCOMT_MEASURE_TIMING_SHIFT))&AFE_ADCOMT_MEASURE_TIMING_MASK)
/* ALGDELAY Bit Fields */
#define AFE_ALGDELAY_ALGORITHM_DELAY_MASK        0xFFu
#define AFE_ALGDELAY_ALGORITHM_DELAY_SHIFT       0
#define AFE_ALGDELAY_ALGORITHM_DELAY(x)          (((uint32_t)(((uint32_t)(x))<<AFE_ALGDELAY_ALGORITHM_DELAY_SHIFT))&AFE_ALGDELAY_ALGORITHM_DELAY_MASK)
/* ACC_ID Bit Fields */
#define AFE_ACC_ID_BLOCK_ID_MASK                 0xFFu
#define AFE_ACC_ID_BLOCK_ID_SHIFT                0
#define AFE_ACC_ID_BLOCK_ID(x)                   (((uint32_t)(((uint32_t)(x))<<AFE_ACC_ID_BLOCK_ID_SHIFT))&AFE_ACC_ID_BLOCK_ID_MASK)
/* ACCSTA Bit Fields */
#define AFE_ACCSTA_STATUS_MASK                   0x1Fu
#define AFE_ACCSTA_STATUS_SHIFT                  0
#define AFE_ACCSTA_STATUS(x)                     (((uint32_t)(((uint32_t)(x))<<AFE_ACCSTA_STATUS_SHIFT))&AFE_ACCSTA_STATUS_MASK)
/* ACCNOSLI Bit Fields */
#define AFE_ACCNOSLI_NO_OF_SLICES_MASK           0x3Fu
#define AFE_ACCNOSLI_NO_OF_SLICES_SHIFT          0
#define AFE_ACCNOSLI_NO_OF_SLICES(x)             (((uint32_t)(((uint32_t)(x))<<AFE_ACCNOSLI_NO_OF_SLICES_SHIFT))&AFE_ACCNOSLI_NO_OF_SLICES_MASK)
/* ACCCALCON Bit Fields */
#define AFE_ACCCALCON_CALIBRATE_START_MASK       0x1u
#define AFE_ACCCALCON_CALIBRATE_START_SHIFT      0
#define AFE_ACCCALCON_BYPASS_MASK                0x2u
#define AFE_ACCCALCON_BYPASS_SHIFT               1
#define AFE_ACCCALCON_BYPASS_CALIB_MASK          0x4u
#define AFE_ACCCALCON_BYPASS_CALIB_SHIFT         2
#define AFE_ACCCALCON_OFFSET_COMP_EN_MASK        0x8u
#define AFE_ACCCALCON_OFFSET_COMP_EN_SHIFT       3
#define AFE_ACCCALCON_ANA_OFFSET_COMP_EN_MASK    0x10u
#define AFE_ACCCALCON_ANA_OFFSET_COMP_EN_SHIFT   4
/* BWEWRICTRL Bit Fields */
#define AFE_BWEWRICTRL_BWE_CTRL_MASK             0x3u
#define AFE_BWEWRICTRL_BWE_CTRL_SHIFT            0
#define AFE_BWEWRICTRL_BWE_CTRL(x)               (((uint32_t)(((uint32_t)(x))<<AFE_BWEWRICTRL_BWE_CTRL_SHIFT))&AFE_BWEWRICTRL_BWE_CTRL_MASK)
#define AFE_BWEWRICTRL_BWE_WRITE_CTRL_MASK       0x4u
#define AFE_BWEWRICTRL_BWE_WRITE_CTRL_SHIFT      2
/* SELSLI Bit Fields */
#define AFE_SELSLI_SELECT_SLICE_MASK             0xFFu
#define AFE_SELSLI_SELECT_SLICE_SHIFT            0
#define AFE_SELSLI_SELECT_SLICE(x)               (((uint32_t)(((uint32_t)(x))<<AFE_SELSLI_SELECT_SLICE_SHIFT))&AFE_SELSLI_SELECT_SLICE_MASK)
/* SELBYT Bit Fields */
#define AFE_SELBYT_SELECT_BYTE_MASK              0xFFu
#define AFE_SELBYT_SELECT_BYTE_SHIFT             0
#define AFE_SELBYT_SELECT_BYTE(x)                (((uint32_t)(((uint32_t)(x))<<AFE_SELBYT_SELECT_BYTE_SHIFT))&AFE_SELBYT_SELECT_BYTE_MASK)
/* REDVAL Bit Fields */
#define AFE_REDVAL_READ_VALUE_MASK               0xFFu
#define AFE_REDVAL_READ_VALUE_SHIFT              0
#define AFE_REDVAL_READ_VALUE(x)                 (((uint32_t)(((uint32_t)(x))<<AFE_REDVAL_READ_VALUE_SHIFT))&AFE_REDVAL_READ_VALUE_MASK)
/* WRIBYT Bit Fields */
#define AFE_WRIBYT_WRITE_BYTE_MASK               0xFFu
#define AFE_WRIBYT_WRITE_BYTE_SHIFT              0
#define AFE_WRIBYT_WRITE_BYTE(x)                 (((uint32_t)(((uint32_t)(x))<<AFE_WRIBYT_WRITE_BYTE_SHIFT))&AFE_WRIBYT_WRITE_BYTE_MASK)

/*!
 * @}
 */ /* end of group AFE_Register_Masks */


/* AFE - Peripheral instance base addresses */
/** Peripheral AFE base pointer */
#define AFE_BASE_PTR                             ((AFE_MemMapPtr)0x42228000u)
/** Array initializer of AFE peripheral base pointers */
#define AFE_BASE_PTRS                            { AFE_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- AFE - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AFE_Register_Accessor_Macros AFE - Register accessor macros
 * @{
 */


/* AFE - Register instance definitions */
/* AFE */
#define AFE_BLOCK_ID                             AFE_BLOCK_ID_REG(AFE_BASE_PTR)
#define AFE_PDBUF                                AFE_PDBUF_REG(AFE_BASE_PTR)
#define AFE_SWRST                                AFE_SWRST_REG(AFE_BASE_PTR)
#define AFE_BGREG                                AFE_BGREG_REG(AFE_BASE_PTR)
#define AFE_ACCESSAR_ID                          AFE_ACCESSAR_ID_REG(AFE_BASE_PTR)
#define AFE_PDADC                                AFE_PDADC_REG(AFE_BASE_PTR)
#define AFE_PDSARH                               AFE_PDSARH_REG(AFE_BASE_PTR)
#define AFE_PDSARL                               AFE_PDSARL_REG(AFE_BASE_PTR)
#define AFE_PDADCRFH                             AFE_PDADCRFH_REG(AFE_BASE_PTR)
#define AFE_PDADCRFL                             AFE_PDADCRFL_REG(AFE_BASE_PTR)
#define AFE_ADCGN                                AFE_ADCGN_REG(AFE_BASE_PTR)
#define AFE_REFTRIML                             AFE_REFTRIML_REG(AFE_BASE_PTR)
#define AFE_REFTRIMH                             AFE_REFTRIMH_REG(AFE_BASE_PTR)
#define AFE_DACAMP                               AFE_DACAMP_REG(AFE_BASE_PTR)
#define AFE_CLMPDAT                              AFE_CLMPDAT_REG(AFE_BASE_PTR)
#define AFE_CLMPAMP                              AFE_CLMPAMP_REG(AFE_BASE_PTR)
#define AFE_CLAMP                                AFE_CLAMP_REG(AFE_BASE_PTR)
#define AFE_INPBUF                               AFE_INPBUF_REG(AFE_BASE_PTR)
#define AFE_INPFLT                               AFE_INPFLT_REG(AFE_BASE_PTR)
#define AFE_ADCDGN                               AFE_ADCDGN_REG(AFE_BASE_PTR)
#define AFE_OFFDRV                               AFE_OFFDRV_REG(AFE_BASE_PTR)
#define AFE_INPCONFIG                            AFE_INPCONFIG_REG(AFE_BASE_PTR)
#define AFE_PROGDELAY                            AFE_PROGDELAY_REG(AFE_BASE_PTR)
#define AFE_ADCOMT                               AFE_ADCOMT_REG(AFE_BASE_PTR)
#define AFE_ALGDELAY                             AFE_ALGDELAY_REG(AFE_BASE_PTR)
#define AFE_ACC_ID                               AFE_ACC_ID_REG(AFE_BASE_PTR)
#define AFE_ACCSTA                               AFE_ACCSTA_REG(AFE_BASE_PTR)
#define AFE_ACCNOSLI                             AFE_ACCNOSLI_REG(AFE_BASE_PTR)
#define AFE_ACCCALCON                            AFE_ACCCALCON_REG(AFE_BASE_PTR)
#define AFE_BWEWRICTRL                           AFE_BWEWRICTRL_REG(AFE_BASE_PTR)
#define AFE_SELSLI                               AFE_SELSLI_REG(AFE_BASE_PTR)
#define AFE_SELBYT                               AFE_SELBYT_REG(AFE_BASE_PTR)
#define AFE_REDVAL                               AFE_REDVAL_REG(AFE_BASE_PTR)
#define AFE_WRIBYT                               AFE_WRIBYT_REG(AFE_BASE_PTR)

/*!
 * @}
 */ /* end of group AFE_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AFE_Peripheral */


/* ----------------------------------------------------------------------------
   -- ASRC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Peripheral ASRC
 * @{
 */

/** ASRC - Peripheral register structure */
typedef struct ASRC_MemMap {
  uint32_t ASRCTR;                                 /**< ASRC Control Register, offset: 0x0 */
  uint32_t ASRIER;                                 /**< ASRC Interrupt Enable Register, offset: 0x4 */
  uint8_t RESERVED_0[4];
  uint32_t ASRCNCR;                                /**< ASRC Channel Number Configuration Register, offset: 0xC */
  uint32_t ASRCFG;                                 /**< ASRC Filter Configuration Status Register, offset: 0x10 */
  uint32_t ASRCSR;                                 /**< ASRC Clock Source Register, offset: 0x14 */
  uint32_t ASRCDR1;                                /**< ASRC Clock Divider Register 1, offset: 0x18 */
  uint32_t ASRCDR2;                                /**< ASRC Clock Divider Register 2, offset: 0x1C */
  uint32_t ASRSTR;                                 /**< ASRC Status Register, offset: 0x20 */
  uint8_t RESERVED_1[28];
  uint32_t ASRPMn[5];                              /**< ASRC Parameter Register n, array offset: 0x40, array step: 0x4 */
  uint32_t ASRTFR1;                                /**< ASRC ASRC Task Queue FIFO Register 1, offset: 0x54 */
  uint8_t RESERVED_2[4];
  uint32_t ASRCCR;                                 /**< ASRC Channel Counter Register, offset: 0x5C */
  struct {                                         /* offset: 0x60, array step: 0x8 */
    uint32_t ASRDI;                                  /**< ASRC Data Input Register for Pair x, array offset: 0x60, array step: 0x8 */
    uint32_t ASRDO;                                  /**< ASRC Data Output Register for Pair x, array offset: 0x64, array step: 0x8 */
  } ASRD[3];
  uint8_t RESERVED_3[8];
  uint32_t ASRIDRHA;                               /**< ASRC Ideal Ratio for Pair A-High Part, offset: 0x80 */
  uint32_t ASRIDRLA;                               /**< ASRC Ideal Ratio for Pair A -Low Part, offset: 0x84 */
  uint32_t ASRIDRHB;                               /**< ASRC Ideal Ratio for Pair B-High Part, offset: 0x88 */
  uint32_t ASRIDRLB;                               /**< ASRC Ideal Ratio for Pair B-Low Part, offset: 0x8C */
  uint32_t ASRIDRHC;                               /**< ASRC Ideal Ratio for Pair C-High Part, offset: 0x90 */
  uint32_t ASRIDRLC;                               /**< ASRC Ideal Ratio for Pair C-Low Part, offset: 0x94 */
  uint32_t ASR76K;                                 /**< ASRC 76kHz Period in terms of ASRC processing clock, offset: 0x98 */
  uint32_t ASR56K;                                 /**< ASRC 56kHz Period in terms of ASRC processing clock, offset: 0x9C */
  uint32_t ASRMCRA;                                /**< ASRC Misc Control Register for Pair A, offset: 0xA0 */
  uint32_t ASRFSTA;                                /**< ASRC FIFO Status Register for Pair A, offset: 0xA4 */
  uint32_t ASRMCRB;                                /**< ASRC Misc Control Register for Pair B, offset: 0xA8 */
  uint32_t ASRFSTB;                                /**< ASRC FIFO Status Register for Pair B, offset: 0xAC */
  uint32_t ASRMCRC;                                /**< ASRC Misc Control Register for Pair C, offset: 0xB0 */
  uint32_t ASRFSTC;                                /**< ASRC FIFO Status Register for Pair C, offset: 0xB4 */
  uint8_t RESERVED_4[8];
  uint32_t ASRMCR1[3];                             /**< ASRC Misc Control Register 1 for Pair X, array offset: 0xC0, array step: 0x4 */
} volatile *ASRC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ASRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Accessor_Macros ASRC - Register accessor macros
 * @{
 */


/* ASRC - Register accessors */
#define ASRC_ASRCTR_REG(base)                    ((base)->ASRCTR)
#define ASRC_ASRIER_REG(base)                    ((base)->ASRIER)
#define ASRC_ASRCNCR_REG(base)                   ((base)->ASRCNCR)
#define ASRC_ASRCFG_REG(base)                    ((base)->ASRCFG)
#define ASRC_ASRCSR_REG(base)                    ((base)->ASRCSR)
#define ASRC_ASRCDR1_REG(base)                   ((base)->ASRCDR1)
#define ASRC_ASRCDR2_REG(base)                   ((base)->ASRCDR2)
#define ASRC_ASRSTR_REG(base)                    ((base)->ASRSTR)
#define ASRC_ASRPMn_REG(base,index)              ((base)->ASRPMn[index])
#define ASRC_ASRTFR1_REG(base)                   ((base)->ASRTFR1)
#define ASRC_ASRCCR_REG(base)                    ((base)->ASRCCR)
#define ASRC_ASRDI_REG(base,index)               ((base)->ASRD[index].ASRDI)
#define ASRC_ASRDO_REG(base,index)               ((base)->ASRD[index].ASRDO)
#define ASRC_ASRIDRHA_REG(base)                  ((base)->ASRIDRHA)
#define ASRC_ASRIDRLA_REG(base)                  ((base)->ASRIDRLA)
#define ASRC_ASRIDRHB_REG(base)                  ((base)->ASRIDRHB)
#define ASRC_ASRIDRLB_REG(base)                  ((base)->ASRIDRLB)
#define ASRC_ASRIDRHC_REG(base)                  ((base)->ASRIDRHC)
#define ASRC_ASRIDRLC_REG(base)                  ((base)->ASRIDRLC)
#define ASRC_ASR76K_REG(base)                    ((base)->ASR76K)
#define ASRC_ASR56K_REG(base)                    ((base)->ASR56K)
#define ASRC_ASRMCRA_REG(base)                   ((base)->ASRMCRA)
#define ASRC_ASRFSTA_REG(base)                   ((base)->ASRFSTA)
#define ASRC_ASRMCRB_REG(base)                   ((base)->ASRMCRB)
#define ASRC_ASRFSTB_REG(base)                   ((base)->ASRFSTB)
#define ASRC_ASRMCRC_REG(base)                   ((base)->ASRMCRC)
#define ASRC_ASRFSTC_REG(base)                   ((base)->ASRFSTC)
#define ASRC_ASRMCR1_REG(base,index)             ((base)->ASRMCR1[index])

/*!
 * @}
 */ /* end of group ASRC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ASRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Masks ASRC Register Masks
 * @{
 */

/* ASRCTR Bit Fields */
#define ASRC_ASRCTR_ASRCEN_MASK                  0x1u
#define ASRC_ASRCTR_ASRCEN_SHIFT                 0
#define ASRC_ASRCTR_ASREA_MASK                   0x2u
#define ASRC_ASRCTR_ASREA_SHIFT                  1
#define ASRC_ASRCTR_ASREB_MASK                   0x4u
#define ASRC_ASRCTR_ASREB_SHIFT                  2
#define ASRC_ASRCTR_ASREC_MASK                   0x8u
#define ASRC_ASRCTR_ASREC_SHIFT                  3
#define ASRC_ASRCTR_SRST_MASK                    0x10u
#define ASRC_ASRCTR_SRST_SHIFT                   4
#define ASRC_ASRCTR_IDRA_MASK                    0x2000u
#define ASRC_ASRCTR_IDRA_SHIFT                   13
#define ASRC_ASRCTR_USRA_MASK                    0x4000u
#define ASRC_ASRCTR_USRA_SHIFT                   14
#define ASRC_ASRCTR_IDRB_MASK                    0x8000u
#define ASRC_ASRCTR_IDRB_SHIFT                   15
#define ASRC_ASRCTR_USRB_MASK                    0x10000u
#define ASRC_ASRCTR_USRB_SHIFT                   16
#define ASRC_ASRCTR_IDRC_MASK                    0x20000u
#define ASRC_ASRCTR_IDRC_SHIFT                   17
#define ASRC_ASRCTR_USRC_MASK                    0x40000u
#define ASRC_ASRCTR_USRC_SHIFT                   18
#define ASRC_ASRCTR_ATSA_MASK                    0x100000u
#define ASRC_ASRCTR_ATSA_SHIFT                   20
#define ASRC_ASRCTR_ATSB_MASK                    0x200000u
#define ASRC_ASRCTR_ATSB_SHIFT                   21
#define ASRC_ASRCTR_ATSC_MASK                    0x400000u
#define ASRC_ASRCTR_ATSC_SHIFT                   22
/* ASRIER Bit Fields */
#define ASRC_ASRIER_ADIEA_MASK                   0x1u
#define ASRC_ASRIER_ADIEA_SHIFT                  0
#define ASRC_ASRIER_ADIEB_MASK                   0x2u
#define ASRC_ASRIER_ADIEB_SHIFT                  1
#define ASRC_ASRIER_ADIEC_MASK                   0x4u
#define ASRC_ASRIER_ADIEC_SHIFT                  2
#define ASRC_ASRIER_ADOEA_MASK                   0x8u
#define ASRC_ASRIER_ADOEA_SHIFT                  3
#define ASRC_ASRIER_ADOEB_MASK                   0x10u
#define ASRC_ASRIER_ADOEB_SHIFT                  4
#define ASRC_ASRIER_ADOEC_MASK                   0x20u
#define ASRC_ASRIER_ADOEC_SHIFT                  5
#define ASRC_ASRIER_AOLIE_MASK                   0x40u
#define ASRC_ASRIER_AOLIE_SHIFT                  6
#define ASRC_ASRIER_AFPWE_MASK                   0x80u
#define ASRC_ASRIER_AFPWE_SHIFT                  7
/* ASRCNCR Bit Fields */
#define ASRC_ASRCNCR_ANCA_MASK                   0xFu
#define ASRC_ASRCNCR_ANCA_SHIFT                  0
#define ASRC_ASRCNCR_ANCA(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCNCR_ANCA_SHIFT))&ASRC_ASRCNCR_ANCA_MASK)
#define ASRC_ASRCNCR_ANCB_MASK                   0xF0u
#define ASRC_ASRCNCR_ANCB_SHIFT                  4
#define ASRC_ASRCNCR_ANCB(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCNCR_ANCB_SHIFT))&ASRC_ASRCNCR_ANCB_MASK)
#define ASRC_ASRCNCR_ANCC_MASK                   0xF00u
#define ASRC_ASRCNCR_ANCC_SHIFT                  8
#define ASRC_ASRCNCR_ANCC(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCNCR_ANCC_SHIFT))&ASRC_ASRCNCR_ANCC_MASK)
/* ASRCFG Bit Fields */
#define ASRC_ASRCFG_PREMODA_MASK                 0xC0u
#define ASRC_ASRCFG_PREMODA_SHIFT                6
#define ASRC_ASRCFG_PREMODA(x)                   (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_PREMODA_SHIFT))&ASRC_ASRCFG_PREMODA_MASK)
#define ASRC_ASRCFG_POSTMODA_MASK                0x300u
#define ASRC_ASRCFG_POSTMODA_SHIFT               8
#define ASRC_ASRCFG_POSTMODA(x)                  (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_POSTMODA_SHIFT))&ASRC_ASRCFG_POSTMODA_MASK)
#define ASRC_ASRCFG_PREMODB_MASK                 0xC00u
#define ASRC_ASRCFG_PREMODB_SHIFT                10
#define ASRC_ASRCFG_PREMODB(x)                   (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_PREMODB_SHIFT))&ASRC_ASRCFG_PREMODB_MASK)
#define ASRC_ASRCFG_POSTMODB_MASK                0x3000u
#define ASRC_ASRCFG_POSTMODB_SHIFT               12
#define ASRC_ASRCFG_POSTMODB(x)                  (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_POSTMODB_SHIFT))&ASRC_ASRCFG_POSTMODB_MASK)
#define ASRC_ASRCFG_PREMODC_MASK                 0xC000u
#define ASRC_ASRCFG_PREMODC_SHIFT                14
#define ASRC_ASRCFG_PREMODC(x)                   (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_PREMODC_SHIFT))&ASRC_ASRCFG_PREMODC_MASK)
#define ASRC_ASRCFG_POSTMODC_MASK                0x30000u
#define ASRC_ASRCFG_POSTMODC_SHIFT               16
#define ASRC_ASRCFG_POSTMODC(x)                  (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCFG_POSTMODC_SHIFT))&ASRC_ASRCFG_POSTMODC_MASK)
#define ASRC_ASRCFG_NDPRA_MASK                   0x40000u
#define ASRC_ASRCFG_NDPRA_SHIFT                  18
#define ASRC_ASRCFG_NDPRB_MASK                   0x80000u
#define ASRC_ASRCFG_NDPRB_SHIFT                  19
#define ASRC_ASRCFG_NDPRC_MASK                   0x100000u
#define ASRC_ASRCFG_NDPRC_SHIFT                  20
#define ASRC_ASRCFG_INIRQA_MASK                  0x200000u
#define ASRC_ASRCFG_INIRQA_SHIFT                 21
#define ASRC_ASRCFG_INIRQB_MASK                  0x400000u
#define ASRC_ASRCFG_INIRQB_SHIFT                 22
#define ASRC_ASRCFG_INIRQC_MASK                  0x800000u
#define ASRC_ASRCFG_INIRQC_SHIFT                 23
/* ASRCSR Bit Fields */
#define ASRC_ASRCSR_AICSA_MASK                   0xFu
#define ASRC_ASRCSR_AICSA_SHIFT                  0
#define ASRC_ASRCSR_AICSA(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AICSA_SHIFT))&ASRC_ASRCSR_AICSA_MASK)
#define ASRC_ASRCSR_AICSB_MASK                   0xF0u
#define ASRC_ASRCSR_AICSB_SHIFT                  4
#define ASRC_ASRCSR_AICSB(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AICSB_SHIFT))&ASRC_ASRCSR_AICSB_MASK)
#define ASRC_ASRCSR_AICSC_MASK                   0xF00u
#define ASRC_ASRCSR_AICSC_SHIFT                  8
#define ASRC_ASRCSR_AICSC(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AICSC_SHIFT))&ASRC_ASRCSR_AICSC_MASK)
#define ASRC_ASRCSR_AOCSA_MASK                   0xF000u
#define ASRC_ASRCSR_AOCSA_SHIFT                  12
#define ASRC_ASRCSR_AOCSA(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AOCSA_SHIFT))&ASRC_ASRCSR_AOCSA_MASK)
#define ASRC_ASRCSR_AOCSB_MASK                   0xF0000u
#define ASRC_ASRCSR_AOCSB_SHIFT                  16
#define ASRC_ASRCSR_AOCSB(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AOCSB_SHIFT))&ASRC_ASRCSR_AOCSB_MASK)
#define ASRC_ASRCSR_AOCSC_MASK                   0xF00000u
#define ASRC_ASRCSR_AOCSC_SHIFT                  20
#define ASRC_ASRCSR_AOCSC(x)                     (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCSR_AOCSC_SHIFT))&ASRC_ASRCSR_AOCSC_MASK)
/* ASRCDR1 Bit Fields */
#define ASRC_ASRCDR1_AICPA_MASK                  0x7u
#define ASRC_ASRCDR1_AICPA_SHIFT                 0
#define ASRC_ASRCDR1_AICPA(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AICPA_SHIFT))&ASRC_ASRCDR1_AICPA_MASK)
#define ASRC_ASRCDR1_AICDA_MASK                  0x38u
#define ASRC_ASRCDR1_AICDA_SHIFT                 3
#define ASRC_ASRCDR1_AICDA(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AICDA_SHIFT))&ASRC_ASRCDR1_AICDA_MASK)
#define ASRC_ASRCDR1_AICPB_MASK                  0x1C0u
#define ASRC_ASRCDR1_AICPB_SHIFT                 6
#define ASRC_ASRCDR1_AICPB(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AICPB_SHIFT))&ASRC_ASRCDR1_AICPB_MASK)
#define ASRC_ASRCDR1_AICDB_MASK                  0xE00u
#define ASRC_ASRCDR1_AICDB_SHIFT                 9
#define ASRC_ASRCDR1_AICDB(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AICDB_SHIFT))&ASRC_ASRCDR1_AICDB_MASK)
#define ASRC_ASRCDR1_AOCPA_MASK                  0x7000u
#define ASRC_ASRCDR1_AOCPA_SHIFT                 12
#define ASRC_ASRCDR1_AOCPA(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AOCPA_SHIFT))&ASRC_ASRCDR1_AOCPA_MASK)
#define ASRC_ASRCDR1_AOCDA_MASK                  0x38000u
#define ASRC_ASRCDR1_AOCDA_SHIFT                 15
#define ASRC_ASRCDR1_AOCDA(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AOCDA_SHIFT))&ASRC_ASRCDR1_AOCDA_MASK)
#define ASRC_ASRCDR1_AOCPB_MASK                  0x1C0000u
#define ASRC_ASRCDR1_AOCPB_SHIFT                 18
#define ASRC_ASRCDR1_AOCPB(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AOCPB_SHIFT))&ASRC_ASRCDR1_AOCPB_MASK)
#define ASRC_ASRCDR1_AOCDB_MASK                  0xE00000u
#define ASRC_ASRCDR1_AOCDB_SHIFT                 21
#define ASRC_ASRCDR1_AOCDB(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR1_AOCDB_SHIFT))&ASRC_ASRCDR1_AOCDB_MASK)
/* ASRCDR2 Bit Fields */
#define ASRC_ASRCDR2_AICPC_MASK                  0x7u
#define ASRC_ASRCDR2_AICPC_SHIFT                 0
#define ASRC_ASRCDR2_AICPC(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR2_AICPC_SHIFT))&ASRC_ASRCDR2_AICPC_MASK)
#define ASRC_ASRCDR2_AICDC_MASK                  0x38u
#define ASRC_ASRCDR2_AICDC_SHIFT                 3
#define ASRC_ASRCDR2_AICDC(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR2_AICDC_SHIFT))&ASRC_ASRCDR2_AICDC_MASK)
#define ASRC_ASRCDR2_AOCPC_MASK                  0x1C0u
#define ASRC_ASRCDR2_AOCPC_SHIFT                 6
#define ASRC_ASRCDR2_AOCPC(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR2_AOCPC_SHIFT))&ASRC_ASRCDR2_AOCPC_MASK)
#define ASRC_ASRCDR2_AOCDC_MASK                  0xE00u
#define ASRC_ASRCDR2_AOCDC_SHIFT                 9
#define ASRC_ASRCDR2_AOCDC(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCDR2_AOCDC_SHIFT))&ASRC_ASRCDR2_AOCDC_MASK)
/* ASRSTR Bit Fields */
#define ASRC_ASRSTR_AIDEA_MASK                   0x1u
#define ASRC_ASRSTR_AIDEA_SHIFT                  0
#define ASRC_ASRSTR_AIDEB_MASK                   0x2u
#define ASRC_ASRSTR_AIDEB_SHIFT                  1
#define ASRC_ASRSTR_AIDEC_MASK                   0x4u
#define ASRC_ASRSTR_AIDEC_SHIFT                  2
#define ASRC_ASRSTR_AODFA_MASK                   0x8u
#define ASRC_ASRSTR_AODFA_SHIFT                  3
#define ASRC_ASRSTR_AODFB_MASK                   0x10u
#define ASRC_ASRSTR_AODFB_SHIFT                  4
#define ASRC_ASRSTR_AODFC_MASK                   0x20u
#define ASRC_ASRSTR_AODFC_SHIFT                  5
#define ASRC_ASRSTR_AOLE_MASK                    0x40u
#define ASRC_ASRSTR_AOLE_SHIFT                   6
#define ASRC_ASRSTR_FPWT_MASK                    0x80u
#define ASRC_ASRSTR_FPWT_SHIFT                   7
#define ASRC_ASRSTR_AIDUA_MASK                   0x100u
#define ASRC_ASRSTR_AIDUA_SHIFT                  8
#define ASRC_ASRSTR_AIDUB_MASK                   0x200u
#define ASRC_ASRSTR_AIDUB_SHIFT                  9
#define ASRC_ASRSTR_AIDUC_MASK                   0x400u
#define ASRC_ASRSTR_AIDUC_SHIFT                  10
#define ASRC_ASRSTR_AODOA_MASK                   0x800u
#define ASRC_ASRSTR_AODOA_SHIFT                  11
#define ASRC_ASRSTR_AODOB_MASK                   0x1000u
#define ASRC_ASRSTR_AODOB_SHIFT                  12
#define ASRC_ASRSTR_AODOC_MASK                   0x2000u
#define ASRC_ASRSTR_AODOC_SHIFT                  13
#define ASRC_ASRSTR_AIOLA_MASK                   0x4000u
#define ASRC_ASRSTR_AIOLA_SHIFT                  14
#define ASRC_ASRSTR_AIOLB_MASK                   0x8000u
#define ASRC_ASRSTR_AIOLB_SHIFT                  15
#define ASRC_ASRSTR_AIOLC_MASK                   0x10000u
#define ASRC_ASRSTR_AIOLC_SHIFT                  16
#define ASRC_ASRSTR_AOOLA_MASK                   0x20000u
#define ASRC_ASRSTR_AOOLA_SHIFT                  17
#define ASRC_ASRSTR_AOOLB_MASK                   0x40000u
#define ASRC_ASRSTR_AOOLB_SHIFT                  18
#define ASRC_ASRSTR_AOOLC_MASK                   0x80000u
#define ASRC_ASRSTR_AOOLC_SHIFT                  19
#define ASRC_ASRSTR_ATQOL_MASK                   0x100000u
#define ASRC_ASRSTR_ATQOL_SHIFT                  20
#define ASRC_ASRSTR_DSLCNT_MASK                  0x200000u
#define ASRC_ASRSTR_DSLCNT_SHIFT                 21
/* ASRPMn Bit Fields */
#define ASRC_ASRPMn_PARAMETER_VALUE_MASK         0xFFFFFFu
#define ASRC_ASRPMn_PARAMETER_VALUE_SHIFT        0
#define ASRC_ASRPMn_PARAMETER_VALUE(x)           (((uint32_t)(((uint32_t)(x))<<ASRC_ASRPMn_PARAMETER_VALUE_SHIFT))&ASRC_ASRPMn_PARAMETER_VALUE_MASK)
/* ASRTFR1 Bit Fields */
#define ASRC_ASRTFR1_TF_BASE_MASK                0x1FC0u
#define ASRC_ASRTFR1_TF_BASE_SHIFT               6
#define ASRC_ASRTFR1_TF_BASE(x)                  (((uint32_t)(((uint32_t)(x))<<ASRC_ASRTFR1_TF_BASE_SHIFT))&ASRC_ASRTFR1_TF_BASE_MASK)
#define ASRC_ASRTFR1_TF_FILL_MASK                0xFE000u
#define ASRC_ASRTFR1_TF_FILL_SHIFT               13
#define ASRC_ASRTFR1_TF_FILL(x)                  (((uint32_t)(((uint32_t)(x))<<ASRC_ASRTFR1_TF_FILL_SHIFT))&ASRC_ASRTFR1_TF_FILL_MASK)
/* ASRCCR Bit Fields */
#define ASRC_ASRCCR_ACIA_MASK                    0xFu
#define ASRC_ASRCCR_ACIA_SHIFT                   0
#define ASRC_ASRCCR_ACIA(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACIA_SHIFT))&ASRC_ASRCCR_ACIA_MASK)
#define ASRC_ASRCCR_ACIB_MASK                    0xF0u
#define ASRC_ASRCCR_ACIB_SHIFT                   4
#define ASRC_ASRCCR_ACIB(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACIB_SHIFT))&ASRC_ASRCCR_ACIB_MASK)
#define ASRC_ASRCCR_ACIC_MASK                    0xF00u
#define ASRC_ASRCCR_ACIC_SHIFT                   8
#define ASRC_ASRCCR_ACIC(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACIC_SHIFT))&ASRC_ASRCCR_ACIC_MASK)
#define ASRC_ASRCCR_ACOA_MASK                    0xF000u
#define ASRC_ASRCCR_ACOA_SHIFT                   12
#define ASRC_ASRCCR_ACOA(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACOA_SHIFT))&ASRC_ASRCCR_ACOA_MASK)
#define ASRC_ASRCCR_ACOB_MASK                    0xF0000u
#define ASRC_ASRCCR_ACOB_SHIFT                   16
#define ASRC_ASRCCR_ACOB(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACOB_SHIFT))&ASRC_ASRCCR_ACOB_MASK)
#define ASRC_ASRCCR_ACOC_MASK                    0xF00000u
#define ASRC_ASRCCR_ACOC_SHIFT                   20
#define ASRC_ASRCCR_ACOC(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRCCR_ACOC_SHIFT))&ASRC_ASRCCR_ACOC_MASK)
/* ASRDI Bit Fields */
#define ASRC_ASRDI_DATA_MASK                     0xFFFFFFu
#define ASRC_ASRDI_DATA_SHIFT                    0
#define ASRC_ASRDI_DATA(x)                       (((uint32_t)(((uint32_t)(x))<<ASRC_ASRDI_DATA_SHIFT))&ASRC_ASRDI_DATA_MASK)
/* ASRDO Bit Fields */
#define ASRC_ASRDO_DATA_MASK                     0xFFFFFFu
#define ASRC_ASRDO_DATA_SHIFT                    0
#define ASRC_ASRDO_DATA(x)                       (((uint32_t)(((uint32_t)(x))<<ASRC_ASRDO_DATA_SHIFT))&ASRC_ASRDO_DATA_MASK)
/* ASRIDRHA Bit Fields */
#define ASRC_ASRIDRHA_IDRATIOA_MASK              0xFFu
#define ASRC_ASRIDRHA_IDRATIOA_SHIFT             0
#define ASRC_ASRIDRHA_IDRATIOA(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRHA_IDRATIOA_SHIFT))&ASRC_ASRIDRHA_IDRATIOA_MASK)
/* ASRIDRLA Bit Fields */
#define ASRC_ASRIDRLA_IDRATIOA_MASK              0xFFFFFFu
#define ASRC_ASRIDRLA_IDRATIOA_SHIFT             0
#define ASRC_ASRIDRLA_IDRATIOA(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRLA_IDRATIOA_SHIFT))&ASRC_ASRIDRLA_IDRATIOA_MASK)
/* ASRIDRHB Bit Fields */
#define ASRC_ASRIDRHB_IDRATIOB_MASK              0xFFu
#define ASRC_ASRIDRHB_IDRATIOB_SHIFT             0
#define ASRC_ASRIDRHB_IDRATIOB(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRHB_IDRATIOB_SHIFT))&ASRC_ASRIDRHB_IDRATIOB_MASK)
/* ASRIDRLB Bit Fields */
#define ASRC_ASRIDRLB_IDRATIOB_MASK              0xFFFFFFu
#define ASRC_ASRIDRLB_IDRATIOB_SHIFT             0
#define ASRC_ASRIDRLB_IDRATIOB(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRLB_IDRATIOB_SHIFT))&ASRC_ASRIDRLB_IDRATIOB_MASK)
/* ASRIDRHC Bit Fields */
#define ASRC_ASRIDRHC_IDRATIOC_MASK              0xFFu
#define ASRC_ASRIDRHC_IDRATIOC_SHIFT             0
#define ASRC_ASRIDRHC_IDRATIOC(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRHC_IDRATIOC_SHIFT))&ASRC_ASRIDRHC_IDRATIOC_MASK)
/* ASRIDRLC Bit Fields */
#define ASRC_ASRIDRLC_IDRATIOC_MASK              0xFFFFFFu
#define ASRC_ASRIDRLC_IDRATIOC_SHIFT             0
#define ASRC_ASRIDRLC_IDRATIOC(x)                (((uint32_t)(((uint32_t)(x))<<ASRC_ASRIDRLC_IDRATIOC_SHIFT))&ASRC_ASRIDRLC_IDRATIOC_MASK)
/* ASR76K Bit Fields */
#define ASRC_ASR76K_ASR76K_MASK                  0x1FFFFu
#define ASRC_ASR76K_ASR76K_SHIFT                 0
#define ASRC_ASR76K_ASR76K(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASR76K_ASR76K_SHIFT))&ASRC_ASR76K_ASR76K_MASK)
/* ASR56K Bit Fields */
#define ASRC_ASR56K_ASR56K_MASK                  0x1FFFFu
#define ASRC_ASR56K_ASR56K_SHIFT                 0
#define ASRC_ASR56K_ASR56K(x)                    (((uint32_t)(((uint32_t)(x))<<ASRC_ASR56K_ASR56K_SHIFT))&ASRC_ASR56K_ASR56K_MASK)
/* ASRMCRA Bit Fields */
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK      0x3Fu
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT     0
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA(x)        (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT))&ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK)
#define ASRC_ASRMCRA_RSYNOFA_MASK                0x400u
#define ASRC_ASRMCRA_RSYNOFA_SHIFT               10
#define ASRC_ASRMCRA_RSYNIFA_MASK                0x800u
#define ASRC_ASRMCRA_RSYNIFA_SHIFT               11
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK     0x3F000u
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT    12
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(x)       (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT))&ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK)
#define ASRC_ASRMCRA_BYPASSPOLYA_MASK            0x100000u
#define ASRC_ASRMCRA_BYPASSPOLYA_SHIFT           20
#define ASRC_ASRMCRA_BUFSTALLA_MASK              0x200000u
#define ASRC_ASRMCRA_BUFSTALLA_SHIFT             21
#define ASRC_ASRMCRA_EXTTHRSHA_MASK              0x400000u
#define ASRC_ASRMCRA_EXTTHRSHA_SHIFT             22
#define ASRC_ASRMCRA_ZEROBUFA_MASK               0x800000u
#define ASRC_ASRMCRA_ZEROBUFA_SHIFT              23
/* ASRFSTA Bit Fields */
#define ASRC_ASRFSTA_INFIFO_FILLA_MASK           0x7Fu
#define ASRC_ASRFSTA_INFIFO_FILLA_SHIFT          0
#define ASRC_ASRFSTA_INFIFO_FILLA(x)             (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTA_INFIFO_FILLA_SHIFT))&ASRC_ASRFSTA_INFIFO_FILLA_MASK)
#define ASRC_ASRFSTA_IAEA_MASK                   0x800u
#define ASRC_ASRFSTA_IAEA_SHIFT                  11
#define ASRC_ASRFSTA_OUTFIFO_FILLA_MASK          0x7F000u
#define ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT         12
#define ASRC_ASRFSTA_OUTFIFO_FILLA(x)            (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT))&ASRC_ASRFSTA_OUTFIFO_FILLA_MASK)
#define ASRC_ASRFSTA_OAFA_MASK                   0x800000u
#define ASRC_ASRFSTA_OAFA_SHIFT                  23
/* ASRMCRB Bit Fields */
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK      0x3Fu
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT     0
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB(x)        (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT))&ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK)
#define ASRC_ASRMCRB_RSYNOFB_MASK                0x400u
#define ASRC_ASRMCRB_RSYNOFB_SHIFT               10
#define ASRC_ASRMCRB_RSYNIFB_MASK                0x800u
#define ASRC_ASRMCRB_RSYNIFB_SHIFT               11
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK     0x3F000u
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT    12
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(x)       (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT))&ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK)
#define ASRC_ASRMCRB_BYPASSPOLYB_MASK            0x100000u
#define ASRC_ASRMCRB_BYPASSPOLYB_SHIFT           20
#define ASRC_ASRMCRB_BUFSTALLB_MASK              0x200000u
#define ASRC_ASRMCRB_BUFSTALLB_SHIFT             21
#define ASRC_ASRMCRB_EXTTHRSHB_MASK              0x400000u
#define ASRC_ASRMCRB_EXTTHRSHB_SHIFT             22
#define ASRC_ASRMCRB_ZEROBUFB_MASK               0x800000u
#define ASRC_ASRMCRB_ZEROBUFB_SHIFT              23
/* ASRFSTB Bit Fields */
#define ASRC_ASRFSTB_INFIFO_FILLB_MASK           0x7Fu
#define ASRC_ASRFSTB_INFIFO_FILLB_SHIFT          0
#define ASRC_ASRFSTB_INFIFO_FILLB(x)             (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTB_INFIFO_FILLB_SHIFT))&ASRC_ASRFSTB_INFIFO_FILLB_MASK)
#define ASRC_ASRFSTB_IAEB_MASK                   0x800u
#define ASRC_ASRFSTB_IAEB_SHIFT                  11
#define ASRC_ASRFSTB_OUTFIFO_FILLB_MASK          0x7F000u
#define ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT         12
#define ASRC_ASRFSTB_OUTFIFO_FILLB(x)            (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT))&ASRC_ASRFSTB_OUTFIFO_FILLB_MASK)
#define ASRC_ASRFSTB_OAFB_MASK                   0x800000u
#define ASRC_ASRFSTB_OAFB_SHIFT                  23
/* ASRMCRC Bit Fields */
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK      0x3Fu
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT     0
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC(x)        (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT))&ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK)
#define ASRC_ASRMCRC_RSYNOFC_MASK                0x400u
#define ASRC_ASRMCRC_RSYNOFC_SHIFT               10
#define ASRC_ASRMCRC_RSYNIFC_MASK                0x800u
#define ASRC_ASRMCRC_RSYNIFC_SHIFT               11
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK     0x3F000u
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT    12
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(x)       (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT))&ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK)
#define ASRC_ASRMCRC_BYPASSPOLYC_MASK            0x100000u
#define ASRC_ASRMCRC_BYPASSPOLYC_SHIFT           20
#define ASRC_ASRMCRC_BUFSTALLC_MASK              0x200000u
#define ASRC_ASRMCRC_BUFSTALLC_SHIFT             21
#define ASRC_ASRMCRC_EXTTHRSHC_MASK              0x400000u
#define ASRC_ASRMCRC_EXTTHRSHC_SHIFT             22
#define ASRC_ASRMCRC_ZEROBUFC_MASK               0x800000u
#define ASRC_ASRMCRC_ZEROBUFC_SHIFT              23
/* ASRFSTC Bit Fields */
#define ASRC_ASRFSTC_INFIFO_FILLC_MASK           0x7Fu
#define ASRC_ASRFSTC_INFIFO_FILLC_SHIFT          0
#define ASRC_ASRFSTC_INFIFO_FILLC(x)             (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTC_INFIFO_FILLC_SHIFT))&ASRC_ASRFSTC_INFIFO_FILLC_MASK)
#define ASRC_ASRFSTC_IAEC_MASK                   0x800u
#define ASRC_ASRFSTC_IAEC_SHIFT                  11
#define ASRC_ASRFSTC_OUTFIFO_FILLC_MASK          0x7F000u
#define ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT         12
#define ASRC_ASRFSTC_OUTFIFO_FILLC(x)            (((uint32_t)(((uint32_t)(x))<<ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT))&ASRC_ASRFSTC_OUTFIFO_FILLC_MASK)
#define ASRC_ASRFSTC_OAFC_MASK                   0x800000u
#define ASRC_ASRFSTC_OAFC_SHIFT                  23
/* ASRMCR1 Bit Fields */
#define ASRC_ASRMCR1_OW16_MASK                   0x1u
#define ASRC_ASRMCR1_OW16_SHIFT                  0
#define ASRC_ASRMCR1_OSGN_MASK                   0x2u
#define ASRC_ASRMCR1_OSGN_SHIFT                  1
#define ASRC_ASRMCR1_OMSB_MASK                   0x4u
#define ASRC_ASRMCR1_OMSB_SHIFT                  2
#define ASRC_ASRMCR1_IMSB_MASK                   0x100u
#define ASRC_ASRMCR1_IMSB_SHIFT                  8
#define ASRC_ASRMCR1_IWD_MASK                    0xE00u
#define ASRC_ASRMCR1_IWD_SHIFT                   9
#define ASRC_ASRMCR1_IWD(x)                      (((uint32_t)(((uint32_t)(x))<<ASRC_ASRMCR1_IWD_SHIFT))&ASRC_ASRMCR1_IWD_MASK)

/*!
 * @}
 */ /* end of group ASRC_Register_Masks */


/* ASRC - Peripheral instance base addresses */
/** Peripheral ASRC base pointer */
#define ASRC_BASE_PTR                            ((ASRC_MemMapPtr)0x42034000u)
/** Array initializer of ASRC peripheral base pointers */
#define ASRC_BASE_PTRS                           { ASRC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ASRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Accessor_Macros ASRC - Register accessor macros
 * @{
 */


/* ASRC - Register instance definitions */
/* ASRC */
#define ASRC_ASRCTR                              ASRC_ASRCTR_REG(ASRC_BASE_PTR)
#define ASRC_ASRIER                              ASRC_ASRIER_REG(ASRC_BASE_PTR)
#define ASRC_ASRCNCR                             ASRC_ASRCNCR_REG(ASRC_BASE_PTR)
#define ASRC_ASRCFG                              ASRC_ASRCFG_REG(ASRC_BASE_PTR)
#define ASRC_ASRCSR                              ASRC_ASRCSR_REG(ASRC_BASE_PTR)
#define ASRC_ASRCDR1                             ASRC_ASRCDR1_REG(ASRC_BASE_PTR)
#define ASRC_ASRCDR2                             ASRC_ASRCDR2_REG(ASRC_BASE_PTR)
#define ASRC_ASRSTR                              ASRC_ASRSTR_REG(ASRC_BASE_PTR)
#define ASRC_ASRPMn1                             ASRC_ASRPMn_REG(ASRC_BASE_PTR,0)
#define ASRC_ASRPMn2                             ASRC_ASRPMn_REG(ASRC_BASE_PTR,1)
#define ASRC_ASRPMn3                             ASRC_ASRPMn_REG(ASRC_BASE_PTR,2)
#define ASRC_ASRPMn4                             ASRC_ASRPMn_REG(ASRC_BASE_PTR,3)
#define ASRC_ASRPMn5                             ASRC_ASRPMn_REG(ASRC_BASE_PTR,4)
#define ASRC_ASRTFR1                             ASRC_ASRTFR1_REG(ASRC_BASE_PTR)
#define ASRC_ASRCCR                              ASRC_ASRCCR_REG(ASRC_BASE_PTR)
#define ASRC_ASRDIA                              ASRC_ASRDI_REG(ASRC_BASE_PTR,0)
#define ASRC_ASRDOA                              ASRC_ASRDO_REG(ASRC_BASE_PTR,0)
#define ASRC_ASRDIB                              ASRC_ASRDI_REG(ASRC_BASE_PTR,1)
#define ASRC_ASRDOB                              ASRC_ASRDO_REG(ASRC_BASE_PTR,1)
#define ASRC_ASRDIC                              ASRC_ASRDI_REG(ASRC_BASE_PTR,2)
#define ASRC_ASRDOC                              ASRC_ASRDO_REG(ASRC_BASE_PTR,2)
#define ASRC_ASRIDRHA                            ASRC_ASRIDRHA_REG(ASRC_BASE_PTR)
#define ASRC_ASRIDRLA                            ASRC_ASRIDRLA_REG(ASRC_BASE_PTR)
#define ASRC_ASRIDRHB                            ASRC_ASRIDRHB_REG(ASRC_BASE_PTR)
#define ASRC_ASRIDRLB                            ASRC_ASRIDRLB_REG(ASRC_BASE_PTR)
#define ASRC_ASRIDRHC                            ASRC_ASRIDRHC_REG(ASRC_BASE_PTR)
#define ASRC_ASRIDRLC                            ASRC_ASRIDRLC_REG(ASRC_BASE_PTR)
#define ASRC_ASR76K                              ASRC_ASR76K_REG(ASRC_BASE_PTR)
#define ASRC_ASR56K                              ASRC_ASR56K_REG(ASRC_BASE_PTR)
#define ASRC_ASRMCRA                             ASRC_ASRMCRA_REG(ASRC_BASE_PTR)
#define ASRC_ASRFSTA                             ASRC_ASRFSTA_REG(ASRC_BASE_PTR)
#define ASRC_ASRMCRB                             ASRC_ASRMCRB_REG(ASRC_BASE_PTR)
#define ASRC_ASRFSTB                             ASRC_ASRFSTB_REG(ASRC_BASE_PTR)
#define ASRC_ASRMCRC                             ASRC_ASRMCRC_REG(ASRC_BASE_PTR)
#define ASRC_ASRFSTC                             ASRC_ASRFSTC_REG(ASRC_BASE_PTR)
#define ASRC_ASRMCR1A                            ASRC_ASRMCR1_REG(ASRC_BASE_PTR,0)
#define ASRC_ASRMCR1B                            ASRC_ASRMCR1_REG(ASRC_BASE_PTR,1)
#define ASRC_ASRMCR1C                            ASRC_ASRMCR1_REG(ASRC_BASE_PTR,2)

/* ASRC - Register array accessors */
#define ASRC_ASRPMn(index)                       ASRC_ASRPMn_REG(ASRC_BASE_PTR,index)
#define ASRC_ASRDI(index)                        ASRC_ASRDI_REG(ASRC_BASE_PTR,index)
#define ASRC_ASRDO(index)                        ASRC_ASRDO_REG(ASRC_BASE_PTR,index)
#define ASRC_ASRMCR1(index)                      ASRC_ASRMCR1_REG(ASRC_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ASRC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ASRC_Peripheral */


/* ----------------------------------------------------------------------------
   -- AUDMUX
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDMUX_Peripheral AUDMUX
 * @{
 */

/** AUDMUX - Peripheral register structure */
typedef struct AUDMUX_MemMap {
  uint32_t PTCR1;                                  /**< Port Timing Control Register 1, offset: 0x0 */
  uint32_t PDCR1;                                  /**< Port Data Control Register 1, offset: 0x4 */
  uint32_t PTCR2;                                  /**< Port Timing Control Register 2, offset: 0x8 */
  uint32_t PDCR2;                                  /**< Port Data Control Register 2, offset: 0xC */
  uint32_t PTCR3;                                  /**< Port Timing Control Register 3, offset: 0x10 */
  uint32_t PDCR3;                                  /**< Port Data Control Register 3, offset: 0x14 */
  uint32_t PTCR4;                                  /**< Port Timing Control Register 4, offset: 0x18 */
  uint32_t PDCR4;                                  /**< Port Data Control Register 4, offset: 0x1C */
  uint32_t PTCR5;                                  /**< Port Timing Control Register 5, offset: 0x20 */
  uint32_t PDCR5;                                  /**< Port Data Control Register 5, offset: 0x24 */
  uint32_t PTCR6;                                  /**< Port Timing Control Register 6, offset: 0x28 */
  uint32_t PDCR6;                                  /**< Port Data Control Register 6, offset: 0x2C */
  uint32_t PTCR7;                                  /**< Port Timing Control Register 7, offset: 0x30 */
  uint32_t PDCR7;                                  /**< Port Data Control Register 7, offset: 0x34 */
} volatile *AUDMUX_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AUDMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDMUX_Register_Accessor_Macros AUDMUX - Register accessor macros
 * @{
 */


/* AUDMUX - Register accessors */
#define AUDMUX_PTCR1_REG(base)                   ((base)->PTCR1)
#define AUDMUX_PDCR1_REG(base)                   ((base)->PDCR1)
#define AUDMUX_PTCR2_REG(base)                   ((base)->PTCR2)
#define AUDMUX_PDCR2_REG(base)                   ((base)->PDCR2)
#define AUDMUX_PTCR3_REG(base)                   ((base)->PTCR3)
#define AUDMUX_PDCR3_REG(base)                   ((base)->PDCR3)
#define AUDMUX_PTCR4_REG(base)                   ((base)->PTCR4)
#define AUDMUX_PDCR4_REG(base)                   ((base)->PDCR4)
#define AUDMUX_PTCR5_REG(base)                   ((base)->PTCR5)
#define AUDMUX_PDCR5_REG(base)                   ((base)->PDCR5)
#define AUDMUX_PTCR6_REG(base)                   ((base)->PTCR6)
#define AUDMUX_PDCR6_REG(base)                   ((base)->PDCR6)
#define AUDMUX_PTCR7_REG(base)                   ((base)->PTCR7)
#define AUDMUX_PDCR7_REG(base)                   ((base)->PDCR7)

/*!
 * @}
 */ /* end of group AUDMUX_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AUDMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDMUX_Register_Masks AUDMUX Register Masks
 * @{
 */

/* PTCR1 Bit Fields */
#define AUDMUX_PTCR1_SYN_MASK                    0x800u
#define AUDMUX_PTCR1_SYN_SHIFT                   11
#define AUDMUX_PTCR1_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR1_RCSEL_SHIFT                 12
#define AUDMUX_PTCR1_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR1_RCSEL_SHIFT))&AUDMUX_PTCR1_RCSEL_MASK)
#define AUDMUX_PTCR1_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR1_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR1_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR1_RFSEL_SHIFT                 17
#define AUDMUX_PTCR1_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR1_RFSEL_SHIFT))&AUDMUX_PTCR1_RFSEL_MASK)
#define AUDMUX_PTCR1_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR1_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR1_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR1_TCSEL_SHIFT                 22
#define AUDMUX_PTCR1_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR1_TCSEL_SHIFT))&AUDMUX_PTCR1_TCSEL_MASK)
#define AUDMUX_PTCR1_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR1_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR1_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR1_TFSEL_SHIFT                 27
#define AUDMUX_PTCR1_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR1_TFSEL_SHIFT))&AUDMUX_PTCR1_TFSEL_MASK)
#define AUDMUX_PTCR1_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR1_TFS_DIR_SHIFT               31
/* PDCR1 Bit Fields */
#define AUDMUX_PDCR1_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR1_INMMASK_SHIFT               0
#define AUDMUX_PDCR1_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR1_INMMASK_SHIFT))&AUDMUX_PDCR1_INMMASK_MASK)
#define AUDMUX_PDCR1_MODE_MASK                   0x100u
#define AUDMUX_PDCR1_MODE_SHIFT                  8
#define AUDMUX_PDCR1_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR1_TXRXEN_SHIFT                12
#define AUDMUX_PDCR1_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR1_RXDSEL_SHIFT                13
#define AUDMUX_PDCR1_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR1_RXDSEL_SHIFT))&AUDMUX_PDCR1_RXDSEL_MASK)
/* PTCR2 Bit Fields */
#define AUDMUX_PTCR2_SYN_MASK                    0x800u
#define AUDMUX_PTCR2_SYN_SHIFT                   11
#define AUDMUX_PTCR2_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR2_RCSEL_SHIFT                 12
#define AUDMUX_PTCR2_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR2_RCSEL_SHIFT))&AUDMUX_PTCR2_RCSEL_MASK)
#define AUDMUX_PTCR2_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR2_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR2_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR2_RFSEL_SHIFT                 17
#define AUDMUX_PTCR2_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR2_RFSEL_SHIFT))&AUDMUX_PTCR2_RFSEL_MASK)
#define AUDMUX_PTCR2_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR2_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR2_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR2_TCSEL_SHIFT                 22
#define AUDMUX_PTCR2_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR2_TCSEL_SHIFT))&AUDMUX_PTCR2_TCSEL_MASK)
#define AUDMUX_PTCR2_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR2_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR2_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR2_TFSEL_SHIFT                 27
#define AUDMUX_PTCR2_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR2_TFSEL_SHIFT))&AUDMUX_PTCR2_TFSEL_MASK)
#define AUDMUX_PTCR2_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR2_TFS_DIR_SHIFT               31
/* PDCR2 Bit Fields */
#define AUDMUX_PDCR2_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR2_INMMASK_SHIFT               0
#define AUDMUX_PDCR2_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR2_INMMASK_SHIFT))&AUDMUX_PDCR2_INMMASK_MASK)
#define AUDMUX_PDCR2_MODE_MASK                   0x100u
#define AUDMUX_PDCR2_MODE_SHIFT                  8
#define AUDMUX_PDCR2_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR2_TXRXEN_SHIFT                12
#define AUDMUX_PDCR2_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR2_RXDSEL_SHIFT                13
#define AUDMUX_PDCR2_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR2_RXDSEL_SHIFT))&AUDMUX_PDCR2_RXDSEL_MASK)
/* PTCR3 Bit Fields */
#define AUDMUX_PTCR3_SYN_MASK                    0x800u
#define AUDMUX_PTCR3_SYN_SHIFT                   11
#define AUDMUX_PTCR3_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR3_RCSEL_SHIFT                 12
#define AUDMUX_PTCR3_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR3_RCSEL_SHIFT))&AUDMUX_PTCR3_RCSEL_MASK)
#define AUDMUX_PTCR3_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR3_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR3_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR3_RFSEL_SHIFT                 17
#define AUDMUX_PTCR3_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR3_RFSEL_SHIFT))&AUDMUX_PTCR3_RFSEL_MASK)
#define AUDMUX_PTCR3_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR3_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR3_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR3_TCSEL_SHIFT                 22
#define AUDMUX_PTCR3_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR3_TCSEL_SHIFT))&AUDMUX_PTCR3_TCSEL_MASK)
#define AUDMUX_PTCR3_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR3_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR3_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR3_TFSEL_SHIFT                 27
#define AUDMUX_PTCR3_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR3_TFSEL_SHIFT))&AUDMUX_PTCR3_TFSEL_MASK)
#define AUDMUX_PTCR3_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR3_TFS_DIR_SHIFT               31
/* PDCR3 Bit Fields */
#define AUDMUX_PDCR3_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR3_INMMASK_SHIFT               0
#define AUDMUX_PDCR3_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR3_INMMASK_SHIFT))&AUDMUX_PDCR3_INMMASK_MASK)
#define AUDMUX_PDCR3_MODE_MASK                   0x100u
#define AUDMUX_PDCR3_MODE_SHIFT                  8
#define AUDMUX_PDCR3_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR3_TXRXEN_SHIFT                12
#define AUDMUX_PDCR3_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR3_RXDSEL_SHIFT                13
#define AUDMUX_PDCR3_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR3_RXDSEL_SHIFT))&AUDMUX_PDCR3_RXDSEL_MASK)
/* PTCR4 Bit Fields */
#define AUDMUX_PTCR4_SYN_MASK                    0x800u
#define AUDMUX_PTCR4_SYN_SHIFT                   11
#define AUDMUX_PTCR4_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR4_RCSEL_SHIFT                 12
#define AUDMUX_PTCR4_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR4_RCSEL_SHIFT))&AUDMUX_PTCR4_RCSEL_MASK)
#define AUDMUX_PTCR4_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR4_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR4_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR4_RFSEL_SHIFT                 17
#define AUDMUX_PTCR4_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR4_RFSEL_SHIFT))&AUDMUX_PTCR4_RFSEL_MASK)
#define AUDMUX_PTCR4_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR4_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR4_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR4_TCSEL_SHIFT                 22
#define AUDMUX_PTCR4_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR4_TCSEL_SHIFT))&AUDMUX_PTCR4_TCSEL_MASK)
#define AUDMUX_PTCR4_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR4_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR4_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR4_TFSEL_SHIFT                 27
#define AUDMUX_PTCR4_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR4_TFSEL_SHIFT))&AUDMUX_PTCR4_TFSEL_MASK)
#define AUDMUX_PTCR4_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR4_TFS_DIR_SHIFT               31
/* PDCR4 Bit Fields */
#define AUDMUX_PDCR4_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR4_INMMASK_SHIFT               0
#define AUDMUX_PDCR4_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR4_INMMASK_SHIFT))&AUDMUX_PDCR4_INMMASK_MASK)
#define AUDMUX_PDCR4_MODE_MASK                   0x100u
#define AUDMUX_PDCR4_MODE_SHIFT                  8
#define AUDMUX_PDCR4_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR4_TXRXEN_SHIFT                12
#define AUDMUX_PDCR4_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR4_RXDSEL_SHIFT                13
#define AUDMUX_PDCR4_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR4_RXDSEL_SHIFT))&AUDMUX_PDCR4_RXDSEL_MASK)
/* PTCR5 Bit Fields */
#define AUDMUX_PTCR5_SYN_MASK                    0x800u
#define AUDMUX_PTCR5_SYN_SHIFT                   11
#define AUDMUX_PTCR5_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR5_RCSEL_SHIFT                 12
#define AUDMUX_PTCR5_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR5_RCSEL_SHIFT))&AUDMUX_PTCR5_RCSEL_MASK)
#define AUDMUX_PTCR5_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR5_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR5_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR5_RFSEL_SHIFT                 17
#define AUDMUX_PTCR5_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR5_RFSEL_SHIFT))&AUDMUX_PTCR5_RFSEL_MASK)
#define AUDMUX_PTCR5_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR5_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR5_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR5_TCSEL_SHIFT                 22
#define AUDMUX_PTCR5_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR5_TCSEL_SHIFT))&AUDMUX_PTCR5_TCSEL_MASK)
#define AUDMUX_PTCR5_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR5_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR5_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR5_TFSEL_SHIFT                 27
#define AUDMUX_PTCR5_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR5_TFSEL_SHIFT))&AUDMUX_PTCR5_TFSEL_MASK)
#define AUDMUX_PTCR5_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR5_TFS_DIR_SHIFT               31
/* PDCR5 Bit Fields */
#define AUDMUX_PDCR5_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR5_INMMASK_SHIFT               0
#define AUDMUX_PDCR5_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR5_INMMASK_SHIFT))&AUDMUX_PDCR5_INMMASK_MASK)
#define AUDMUX_PDCR5_MODE_MASK                   0x100u
#define AUDMUX_PDCR5_MODE_SHIFT                  8
#define AUDMUX_PDCR5_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR5_TXRXEN_SHIFT                12
#define AUDMUX_PDCR5_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR5_RXDSEL_SHIFT                13
#define AUDMUX_PDCR5_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR5_RXDSEL_SHIFT))&AUDMUX_PDCR5_RXDSEL_MASK)
/* PTCR6 Bit Fields */
#define AUDMUX_PTCR6_SYN_MASK                    0x800u
#define AUDMUX_PTCR6_SYN_SHIFT                   11
#define AUDMUX_PTCR6_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR6_RCSEL_SHIFT                 12
#define AUDMUX_PTCR6_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR6_RCSEL_SHIFT))&AUDMUX_PTCR6_RCSEL_MASK)
#define AUDMUX_PTCR6_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR6_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR6_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR6_RFSEL_SHIFT                 17
#define AUDMUX_PTCR6_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR6_RFSEL_SHIFT))&AUDMUX_PTCR6_RFSEL_MASK)
#define AUDMUX_PTCR6_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR6_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR6_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR6_TCSEL_SHIFT                 22
#define AUDMUX_PTCR6_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR6_TCSEL_SHIFT))&AUDMUX_PTCR6_TCSEL_MASK)
#define AUDMUX_PTCR6_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR6_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR6_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR6_TFSEL_SHIFT                 27
#define AUDMUX_PTCR6_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR6_TFSEL_SHIFT))&AUDMUX_PTCR6_TFSEL_MASK)
#define AUDMUX_PTCR6_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR6_TFS_DIR_SHIFT               31
/* PDCR6 Bit Fields */
#define AUDMUX_PDCR6_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR6_INMMASK_SHIFT               0
#define AUDMUX_PDCR6_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR6_INMMASK_SHIFT))&AUDMUX_PDCR6_INMMASK_MASK)
#define AUDMUX_PDCR6_MODE_MASK                   0x100u
#define AUDMUX_PDCR6_MODE_SHIFT                  8
#define AUDMUX_PDCR6_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR6_TXRXEN_SHIFT                12
#define AUDMUX_PDCR6_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR6_RXDSEL_SHIFT                13
#define AUDMUX_PDCR6_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR6_RXDSEL_SHIFT))&AUDMUX_PDCR6_RXDSEL_MASK)
/* PTCR7 Bit Fields */
#define AUDMUX_PTCR7_SYN_MASK                    0x800u
#define AUDMUX_PTCR7_SYN_SHIFT                   11
#define AUDMUX_PTCR7_RCSEL_MASK                  0xF000u
#define AUDMUX_PTCR7_RCSEL_SHIFT                 12
#define AUDMUX_PTCR7_RCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR7_RCSEL_SHIFT))&AUDMUX_PTCR7_RCSEL_MASK)
#define AUDMUX_PTCR7_RCLKDIR_MASK                0x10000u
#define AUDMUX_PTCR7_RCLKDIR_SHIFT               16
#define AUDMUX_PTCR7_RFSEL_MASK                  0x1E0000u
#define AUDMUX_PTCR7_RFSEL_SHIFT                 17
#define AUDMUX_PTCR7_RFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR7_RFSEL_SHIFT))&AUDMUX_PTCR7_RFSEL_MASK)
#define AUDMUX_PTCR7_RFS_DIR_MASK                0x200000u
#define AUDMUX_PTCR7_RFS_DIR_SHIFT               21
#define AUDMUX_PTCR7_TCSEL_MASK                  0x3C00000u
#define AUDMUX_PTCR7_TCSEL_SHIFT                 22
#define AUDMUX_PTCR7_TCSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR7_TCSEL_SHIFT))&AUDMUX_PTCR7_TCSEL_MASK)
#define AUDMUX_PTCR7_TCLKDIR_MASK                0x4000000u
#define AUDMUX_PTCR7_TCLKDIR_SHIFT               26
#define AUDMUX_PTCR7_TFSEL_MASK                  0x78000000u
#define AUDMUX_PTCR7_TFSEL_SHIFT                 27
#define AUDMUX_PTCR7_TFSEL(x)                    (((uint32_t)(((uint32_t)(x))<<AUDMUX_PTCR7_TFSEL_SHIFT))&AUDMUX_PTCR7_TFSEL_MASK)
#define AUDMUX_PTCR7_TFS_DIR_MASK                0x80000000u
#define AUDMUX_PTCR7_TFS_DIR_SHIFT               31
/* PDCR7 Bit Fields */
#define AUDMUX_PDCR7_INMMASK_MASK                0xFFu
#define AUDMUX_PDCR7_INMMASK_SHIFT               0
#define AUDMUX_PDCR7_INMMASK(x)                  (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR7_INMMASK_SHIFT))&AUDMUX_PDCR7_INMMASK_MASK)
#define AUDMUX_PDCR7_MODE_MASK                   0x100u
#define AUDMUX_PDCR7_MODE_SHIFT                  8
#define AUDMUX_PDCR7_TXRXEN_MASK                 0x1000u
#define AUDMUX_PDCR7_TXRXEN_SHIFT                12
#define AUDMUX_PDCR7_RXDSEL_MASK                 0xE000u
#define AUDMUX_PDCR7_RXDSEL_SHIFT                13
#define AUDMUX_PDCR7_RXDSEL(x)                   (((uint32_t)(((uint32_t)(x))<<AUDMUX_PDCR7_RXDSEL_SHIFT))&AUDMUX_PDCR7_RXDSEL_MASK)

/*!
 * @}
 */ /* end of group AUDMUX_Register_Masks */


/* AUDMUX - Peripheral instance base addresses */
/** Peripheral AUDMUX base pointer */
#define AUDMUX_BASE_PTR                          ((AUDMUX_MemMapPtr)0x421D8FFFu)
/** Array initializer of AUDMUX peripheral base pointers */
#define AUDMUX_BASE_PTRS                         { AUDMUX_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- AUDMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDMUX_Register_Accessor_Macros AUDMUX - Register accessor macros
 * @{
 */


/* AUDMUX - Register instance definitions */
/* AUDMUX */
#define AUDMUX_PTCR1                             AUDMUX_PTCR1_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR1                             AUDMUX_PDCR1_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR2                             AUDMUX_PTCR2_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR2                             AUDMUX_PDCR2_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR3                             AUDMUX_PTCR3_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR3                             AUDMUX_PDCR3_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR4                             AUDMUX_PTCR4_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR4                             AUDMUX_PDCR4_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR5                             AUDMUX_PTCR5_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR5                             AUDMUX_PDCR5_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR6                             AUDMUX_PTCR6_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR6                             AUDMUX_PDCR6_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PTCR7                             AUDMUX_PTCR7_REG(AUDMUX_BASE_PTR)
#define AUDMUX_PDCR7                             AUDMUX_PDCR7_REG(AUDMUX_BASE_PTR)

/*!
 * @}
 */ /* end of group AUDMUX_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AUDMUX_Peripheral */


/* ----------------------------------------------------------------------------
   -- BCH
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Peripheral BCH
 * @{
 */

/** BCH - Peripheral register structure */
typedef struct BCH_MemMap {
  uint32_t CTRL;                                   /**< Hardware BCH ECC Accelerator Control Register, offset: 0x0 */
  uint32_t CTRL_SET;                               /**< Hardware BCH ECC Accelerator Control Register, offset: 0x4 */
  uint32_t CTRL_CLR;                               /**< Hardware BCH ECC Accelerator Control Register, offset: 0x8 */
  uint32_t CTRL_TOG;                               /**< Hardware BCH ECC Accelerator Control Register, offset: 0xC */
  uint32_t STATUS0;                                /**< Hardware ECC Accelerator Status Register 0, offset: 0x10 */
  uint32_t STATUS0_SET;                            /**< Hardware ECC Accelerator Status Register 0, offset: 0x14 */
  uint32_t STATUS0_CLR;                            /**< Hardware ECC Accelerator Status Register 0, offset: 0x18 */
  uint32_t STATUS0_TOG;                            /**< Hardware ECC Accelerator Status Register 0, offset: 0x1C */
  uint32_t MODE;                                   /**< Hardware ECC Accelerator Mode Register, offset: 0x20 */
  uint32_t MODE_SET;                               /**< Hardware ECC Accelerator Mode Register, offset: 0x24 */
  uint32_t MODE_CLR;                               /**< Hardware ECC Accelerator Mode Register, offset: 0x28 */
  uint32_t MODE_TOG;                               /**< Hardware ECC Accelerator Mode Register, offset: 0x2C */
  uint32_t ENCODEPTR;                              /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x30 */
  uint32_t ENCODEPTR_SET;                          /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x34 */
  uint32_t ENCODEPTR_CLR;                          /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x38 */
  uint32_t ENCODEPTR_TOG;                          /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x3C */
  uint32_t DATAPTR;                                /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x40 */
  uint32_t DATAPTR_SET;                            /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x44 */
  uint32_t DATAPTR_CLR;                            /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x48 */
  uint32_t DATAPTR_TOG;                            /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x4C */
  uint32_t METAPTR;                                /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x50 */
  uint32_t METAPTR_SET;                            /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x54 */
  uint32_t METAPTR_CLR;                            /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x58 */
  uint32_t METAPTR_TOG;                            /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x5C */
  uint8_t RESERVED_0[16];
  uint32_t LAYOUTSELECT;                           /**< Hardware ECC Accelerator Layout Select Register, offset: 0x70 */
  uint32_t LAYOUTSELECT_SET;                       /**< Hardware ECC Accelerator Layout Select Register, offset: 0x74 */
  uint32_t LAYOUTSELECT_CLR;                       /**< Hardware ECC Accelerator Layout Select Register, offset: 0x78 */
  uint32_t LAYOUTSELECT_TOG;                       /**< Hardware ECC Accelerator Layout Select Register, offset: 0x7C */
  uint32_t FLASH0LAYOUT0;                          /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x80 */
  uint32_t FLASH0LAYOUT0_SET;                      /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x84 */
  uint32_t FLASH0LAYOUT0_CLR;                      /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x88 */
  uint32_t FLASH0LAYOUT0_TOG;                      /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x8C */
  uint32_t FLASH0LAYOUT1;                          /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x90 */
  uint32_t FLASH0LAYOUT1_SET;                      /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x94 */
  uint32_t FLASH0LAYOUT1_CLR;                      /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x98 */
  uint32_t FLASH0LAYOUT1_TOG;                      /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x9C */
  uint32_t FLASH1LAYOUT0;                          /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA0 */
  uint32_t FLASH1LAYOUT0_SET;                      /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA4 */
  uint32_t FLASH1LAYOUT0_CLR;                      /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA8 */
  uint32_t FLASH1LAYOUT0_TOG;                      /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xAC */
  uint32_t FLASH1LAYOUT1;                          /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB0 */
  uint32_t FLASH1LAYOUT1_SET;                      /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB4 */
  uint32_t FLASH1LAYOUT1_CLR;                      /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB8 */
  uint32_t FLASH1LAYOUT1_TOG;                      /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xBC */
  uint32_t FLASH2LAYOUT0;                          /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC0 */
  uint32_t FLASH2LAYOUT0_SET;                      /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC4 */
  uint32_t FLASH2LAYOUT0_CLR;                      /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC8 */
  uint32_t FLASH2LAYOUT0_TOG;                      /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xCC */
  uint32_t FLASH2LAYOUT1;                          /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD0 */
  uint32_t FLASH2LAYOUT1_SET;                      /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD4 */
  uint32_t FLASH2LAYOUT1_CLR;                      /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD8 */
  uint32_t FLASH2LAYOUT1_TOG;                      /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xDC */
  uint32_t FLASH3LAYOUT0;                          /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE0 */
  uint32_t FLASH3LAYOUT0_SET;                      /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE4 */
  uint32_t FLASH3LAYOUT0_CLR;                      /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE8 */
  uint32_t FLASH3LAYOUT0_TOG;                      /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xEC */
  uint32_t FLASH3LAYOUT1;                          /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF0 */
  uint32_t FLASH3LAYOUT1_SET;                      /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF4 */
  uint32_t FLASH3LAYOUT1_CLR;                      /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF8 */
  uint32_t FLASH3LAYOUT1_TOG;                      /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xFC */
  uint32_t DEBUG0;                                 /**< Hardware BCH ECC Debug Register0, offset: 0x100 */
  uint32_t DEBUG0_SET;                             /**< Hardware BCH ECC Debug Register0, offset: 0x104 */
  uint32_t DEBUG0_CLR;                             /**< Hardware BCH ECC Debug Register0, offset: 0x108 */
  uint32_t DEBUG0_TOG;                             /**< Hardware BCH ECC Debug Register0, offset: 0x10C */
  uint32_t DBGKESREAD;                             /**< KES Debug Read Register, offset: 0x110 */
  uint32_t DBGKESREAD_SET;                         /**< KES Debug Read Register, offset: 0x114 */
  uint32_t DBGKESREAD_CLR;                         /**< KES Debug Read Register, offset: 0x118 */
  uint32_t DBGKESREAD_TOG;                         /**< KES Debug Read Register, offset: 0x11C */
  uint32_t DBGCSFEREAD;                            /**< Chien Search Debug Read Register, offset: 0x120 */
  uint32_t DBGCSFEREAD_SET;                        /**< Chien Search Debug Read Register, offset: 0x124 */
  uint32_t DBGCSFEREAD_CLR;                        /**< Chien Search Debug Read Register, offset: 0x128 */
  uint32_t DBGCSFEREAD_TOG;                        /**< Chien Search Debug Read Register, offset: 0x12C */
  uint32_t DBGSYNDGENREAD;                         /**< Syndrome Generator Debug Read Register, offset: 0x130 */
  uint32_t DBGSYNDGENREAD_SET;                     /**< Syndrome Generator Debug Read Register, offset: 0x134 */
  uint32_t DBGSYNDGENREAD_CLR;                     /**< Syndrome Generator Debug Read Register, offset: 0x138 */
  uint32_t DBGSYNDGENREAD_TOG;                     /**< Syndrome Generator Debug Read Register, offset: 0x13C */
  uint32_t DBGAHBMREAD;                            /**< Bus Master and ECC Controller Debug Read Register, offset: 0x140 */
  uint32_t DBGAHBMREAD_SET;                        /**< Bus Master and ECC Controller Debug Read Register, offset: 0x144 */
  uint32_t DBGAHBMREAD_CLR;                        /**< Bus Master and ECC Controller Debug Read Register, offset: 0x148 */
  uint32_t DBGAHBMREAD_TOG;                        /**< Bus Master and ECC Controller Debug Read Register, offset: 0x14C */
  uint32_t BLOCKNAME;                              /**< Block Name Register, offset: 0x150 */
  uint32_t BLOCKNAME_SET;                          /**< Block Name Register, offset: 0x154 */
  uint32_t BLOCKNAME_CLR;                          /**< Block Name Register, offset: 0x158 */
  uint32_t BLOCKNAME_TOG;                          /**< Block Name Register, offset: 0x15C */
  uint32_t VERSION;                                /**< BCH Version Register, offset: 0x160 */
  uint32_t VERSION_SET;                            /**< BCH Version Register, offset: 0x164 */
  uint32_t VERSION_CLR;                            /**< BCH Version Register, offset: 0x168 */
  uint32_t VERSION_TOG;                            /**< BCH Version Register, offset: 0x16C */
} volatile *BCH_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- BCH - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Register_Accessor_Macros BCH - Register accessor macros
 * @{
 */


/* BCH - Register accessors */
#define BCH_CTRL_REG(base)                       ((base)->CTRL)
#define BCH_CTRL_SET_REG(base)                   ((base)->CTRL_SET)
#define BCH_CTRL_CLR_REG(base)                   ((base)->CTRL_CLR)
#define BCH_CTRL_TOG_REG(base)                   ((base)->CTRL_TOG)
#define BCH_STATUS0_REG(base)                    ((base)->STATUS0)
#define BCH_STATUS0_SET_REG(base)                ((base)->STATUS0_SET)
#define BCH_STATUS0_CLR_REG(base)                ((base)->STATUS0_CLR)
#define BCH_STATUS0_TOG_REG(base)                ((base)->STATUS0_TOG)
#define BCH_MODE_REG(base)                       ((base)->MODE)
#define BCH_MODE_SET_REG(base)                   ((base)->MODE_SET)
#define BCH_MODE_CLR_REG(base)                   ((base)->MODE_CLR)
#define BCH_MODE_TOG_REG(base)                   ((base)->MODE_TOG)
#define BCH_ENCODEPTR_REG(base)                  ((base)->ENCODEPTR)
#define BCH_ENCODEPTR_SET_REG(base)              ((base)->ENCODEPTR_SET)
#define BCH_ENCODEPTR_CLR_REG(base)              ((base)->ENCODEPTR_CLR)
#define BCH_ENCODEPTR_TOG_REG(base)              ((base)->ENCODEPTR_TOG)
#define BCH_DATAPTR_REG(base)                    ((base)->DATAPTR)
#define BCH_DATAPTR_SET_REG(base)                ((base)->DATAPTR_SET)
#define BCH_DATAPTR_CLR_REG(base)                ((base)->DATAPTR_CLR)
#define BCH_DATAPTR_TOG_REG(base)                ((base)->DATAPTR_TOG)
#define BCH_METAPTR_REG(base)                    ((base)->METAPTR)
#define BCH_METAPTR_SET_REG(base)                ((base)->METAPTR_SET)
#define BCH_METAPTR_CLR_REG(base)                ((base)->METAPTR_CLR)
#define BCH_METAPTR_TOG_REG(base)                ((base)->METAPTR_TOG)
#define BCH_LAYOUTSELECT_REG(base)               ((base)->LAYOUTSELECT)
#define BCH_LAYOUTSELECT_SET_REG(base)           ((base)->LAYOUTSELECT_SET)
#define BCH_LAYOUTSELECT_CLR_REG(base)           ((base)->LAYOUTSELECT_CLR)
#define BCH_LAYOUTSELECT_TOG_REG(base)           ((base)->LAYOUTSELECT_TOG)
#define BCH_FLASH0LAYOUT0_REG(base)              ((base)->FLASH0LAYOUT0)
#define BCH_FLASH0LAYOUT0_SET_REG(base)          ((base)->FLASH0LAYOUT0_SET)
#define BCH_FLASH0LAYOUT0_CLR_REG(base)          ((base)->FLASH0LAYOUT0_CLR)
#define BCH_FLASH0LAYOUT0_TOG_REG(base)          ((base)->FLASH0LAYOUT0_TOG)
#define BCH_FLASH0LAYOUT1_REG(base)              ((base)->FLASH0LAYOUT1)
#define BCH_FLASH0LAYOUT1_SET_REG(base)          ((base)->FLASH0LAYOUT1_SET)
#define BCH_FLASH0LAYOUT1_CLR_REG(base)          ((base)->FLASH0LAYOUT1_CLR)
#define BCH_FLASH0LAYOUT1_TOG_REG(base)          ((base)->FLASH0LAYOUT1_TOG)
#define BCH_FLASH1LAYOUT0_REG(base)              ((base)->FLASH1LAYOUT0)
#define BCH_FLASH1LAYOUT0_SET_REG(base)          ((base)->FLASH1LAYOUT0_SET)
#define BCH_FLASH1LAYOUT0_CLR_REG(base)          ((base)->FLASH1LAYOUT0_CLR)
#define BCH_FLASH1LAYOUT0_TOG_REG(base)          ((base)->FLASH1LAYOUT0_TOG)
#define BCH_FLASH1LAYOUT1_REG(base)              ((base)->FLASH1LAYOUT1)
#define BCH_FLASH1LAYOUT1_SET_REG(base)          ((base)->FLASH1LAYOUT1_SET)
#define BCH_FLASH1LAYOUT1_CLR_REG(base)          ((base)->FLASH1LAYOUT1_CLR)
#define BCH_FLASH1LAYOUT1_TOG_REG(base)          ((base)->FLASH1LAYOUT1_TOG)
#define BCH_FLASH2LAYOUT0_REG(base)              ((base)->FLASH2LAYOUT0)
#define BCH_FLASH2LAYOUT0_SET_REG(base)          ((base)->FLASH2LAYOUT0_SET)
#define BCH_FLASH2LAYOUT0_CLR_REG(base)          ((base)->FLASH2LAYOUT0_CLR)
#define BCH_FLASH2LAYOUT0_TOG_REG(base)          ((base)->FLASH2LAYOUT0_TOG)
#define BCH_FLASH2LAYOUT1_REG(base)              ((base)->FLASH2LAYOUT1)
#define BCH_FLASH2LAYOUT1_SET_REG(base)          ((base)->FLASH2LAYOUT1_SET)
#define BCH_FLASH2LAYOUT1_CLR_REG(base)          ((base)->FLASH2LAYOUT1_CLR)
#define BCH_FLASH2LAYOUT1_TOG_REG(base)          ((base)->FLASH2LAYOUT1_TOG)
#define BCH_FLASH3LAYOUT0_REG(base)              ((base)->FLASH3LAYOUT0)
#define BCH_FLASH3LAYOUT0_SET_REG(base)          ((base)->FLASH3LAYOUT0_SET)
#define BCH_FLASH3LAYOUT0_CLR_REG(base)          ((base)->FLASH3LAYOUT0_CLR)
#define BCH_FLASH3LAYOUT0_TOG_REG(base)          ((base)->FLASH3LAYOUT0_TOG)
#define BCH_FLASH3LAYOUT1_REG(base)              ((base)->FLASH3LAYOUT1)
#define BCH_FLASH3LAYOUT1_SET_REG(base)          ((base)->FLASH3LAYOUT1_SET)
#define BCH_FLASH3LAYOUT1_CLR_REG(base)          ((base)->FLASH3LAYOUT1_CLR)
#define BCH_FLASH3LAYOUT1_TOG_REG(base)          ((base)->FLASH3LAYOUT1_TOG)
#define BCH_DEBUG0_REG(base)                     ((base)->DEBUG0)
#define BCH_DEBUG0_SET_REG(base)                 ((base)->DEBUG0_SET)
#define BCH_DEBUG0_CLR_REG(base)                 ((base)->DEBUG0_CLR)
#define BCH_DEBUG0_TOG_REG(base)                 ((base)->DEBUG0_TOG)
#define BCH_DBGKESREAD_REG(base)                 ((base)->DBGKESREAD)
#define BCH_DBGKESREAD_SET_REG(base)             ((base)->DBGKESREAD_SET)
#define BCH_DBGKESREAD_CLR_REG(base)             ((base)->DBGKESREAD_CLR)
#define BCH_DBGKESREAD_TOG_REG(base)             ((base)->DBGKESREAD_TOG)
#define BCH_DBGCSFEREAD_REG(base)                ((base)->DBGCSFEREAD)
#define BCH_DBGCSFEREAD_SET_REG(base)            ((base)->DBGCSFEREAD_SET)
#define BCH_DBGCSFEREAD_CLR_REG(base)            ((base)->DBGCSFEREAD_CLR)
#define BCH_DBGCSFEREAD_TOG_REG(base)            ((base)->DBGCSFEREAD_TOG)
#define BCH_DBGSYNDGENREAD_REG(base)             ((base)->DBGSYNDGENREAD)
#define BCH_DBGSYNDGENREAD_SET_REG(base)         ((base)->DBGSYNDGENREAD_SET)
#define BCH_DBGSYNDGENREAD_CLR_REG(base)         ((base)->DBGSYNDGENREAD_CLR)
#define BCH_DBGSYNDGENREAD_TOG_REG(base)         ((base)->DBGSYNDGENREAD_TOG)
#define BCH_DBGAHBMREAD_REG(base)                ((base)->DBGAHBMREAD)
#define BCH_DBGAHBMREAD_SET_REG(base)            ((base)->DBGAHBMREAD_SET)
#define BCH_DBGAHBMREAD_CLR_REG(base)            ((base)->DBGAHBMREAD_CLR)
#define BCH_DBGAHBMREAD_TOG_REG(base)            ((base)->DBGAHBMREAD_TOG)
#define BCH_BLOCKNAME_REG(base)                  ((base)->BLOCKNAME)
#define BCH_BLOCKNAME_SET_REG(base)              ((base)->BLOCKNAME_SET)
#define BCH_BLOCKNAME_CLR_REG(base)              ((base)->BLOCKNAME_CLR)
#define BCH_BLOCKNAME_TOG_REG(base)              ((base)->BLOCKNAME_TOG)
#define BCH_VERSION_REG(base)                    ((base)->VERSION)
#define BCH_VERSION_SET_REG(base)                ((base)->VERSION_SET)
#define BCH_VERSION_CLR_REG(base)                ((base)->VERSION_CLR)
#define BCH_VERSION_TOG_REG(base)                ((base)->VERSION_TOG)

/*!
 * @}
 */ /* end of group BCH_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- BCH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Register_Masks BCH Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define BCH_CTRL_COMPLETE_IRQ_MASK               0x1u
#define BCH_CTRL_COMPLETE_IRQ_SHIFT              0
#define BCH_CTRL_RSVD0_MASK                      0x2u
#define BCH_CTRL_RSVD0_SHIFT                     1
#define BCH_CTRL_DEBUG_STALL_IRQ_MASK            0x4u
#define BCH_CTRL_DEBUG_STALL_IRQ_SHIFT           2
#define BCH_CTRL_BM_ERROR_IRQ_MASK               0x8u
#define BCH_CTRL_BM_ERROR_IRQ_SHIFT              3
#define BCH_CTRL_RSVD1_MASK                      0xF0u
#define BCH_CTRL_RSVD1_SHIFT                     4
#define BCH_CTRL_RSVD1(x)                        (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_RSVD1_SHIFT))&BCH_CTRL_RSVD1_MASK)
#define BCH_CTRL_COMPLETE_IRQ_EN_MASK            0x100u
#define BCH_CTRL_COMPLETE_IRQ_EN_SHIFT           8
#define BCH_CTRL_RSVD2_MASK                      0x200u
#define BCH_CTRL_RSVD2_SHIFT                     9
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_MASK         0x400u
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_SHIFT        10
#define BCH_CTRL_RSVD3_MASK                      0xF800u
#define BCH_CTRL_RSVD3_SHIFT                     11
#define BCH_CTRL_RSVD3(x)                        (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_RSVD3_SHIFT))&BCH_CTRL_RSVD3_MASK)
#define BCH_CTRL_M2M_ENABLE_MASK                 0x10000u
#define BCH_CTRL_M2M_ENABLE_SHIFT                16
#define BCH_CTRL_M2M_ENCODE_MASK                 0x20000u
#define BCH_CTRL_M2M_ENCODE_SHIFT                17
#define BCH_CTRL_M2M_LAYOUT_MASK                 0xC0000u
#define BCH_CTRL_M2M_LAYOUT_SHIFT                18
#define BCH_CTRL_M2M_LAYOUT(x)                   (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_M2M_LAYOUT_SHIFT))&BCH_CTRL_M2M_LAYOUT_MASK)
#define BCH_CTRL_RSVD4_MASK                      0x300000u
#define BCH_CTRL_RSVD4_SHIFT                     20
#define BCH_CTRL_RSVD4(x)                        (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_RSVD4_SHIFT))&BCH_CTRL_RSVD4_MASK)
#define BCH_CTRL_DEBUGSYNDROME_MASK              0x400000u
#define BCH_CTRL_DEBUGSYNDROME_SHIFT             22
#define BCH_CTRL_RSVD5_MASK                      0x3F800000u
#define BCH_CTRL_RSVD5_SHIFT                     23
#define BCH_CTRL_RSVD5(x)                        (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_RSVD5_SHIFT))&BCH_CTRL_RSVD5_MASK)
#define BCH_CTRL_CLKGATE_MASK                    0x40000000u
#define BCH_CTRL_CLKGATE_SHIFT                   30
#define BCH_CTRL_SFTRST_MASK                     0x80000000u
#define BCH_CTRL_SFTRST_SHIFT                    31
/* CTRL_SET Bit Fields */
#define BCH_CTRL_SET_COMPLETE_IRQ_MASK           0x1u
#define BCH_CTRL_SET_COMPLETE_IRQ_SHIFT          0
#define BCH_CTRL_SET_RSVD0_MASK                  0x2u
#define BCH_CTRL_SET_RSVD0_SHIFT                 1
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_MASK        0x4u
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_SHIFT       2
#define BCH_CTRL_SET_BM_ERROR_IRQ_MASK           0x8u
#define BCH_CTRL_SET_BM_ERROR_IRQ_SHIFT          3
#define BCH_CTRL_SET_RSVD1_MASK                  0xF0u
#define BCH_CTRL_SET_RSVD1_SHIFT                 4
#define BCH_CTRL_SET_RSVD1(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_SET_RSVD1_SHIFT))&BCH_CTRL_SET_RSVD1_MASK)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_MASK        0x100u
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_SHIFT       8
#define BCH_CTRL_SET_RSVD2_MASK                  0x200u
#define BCH_CTRL_SET_RSVD2_SHIFT                 9
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_MASK     0x400u
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_SHIFT    10
#define BCH_CTRL_SET_RSVD3_MASK                  0xF800u
#define BCH_CTRL_SET_RSVD3_SHIFT                 11
#define BCH_CTRL_SET_RSVD3(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_SET_RSVD3_SHIFT))&BCH_CTRL_SET_RSVD3_MASK)
#define BCH_CTRL_SET_M2M_ENABLE_MASK             0x10000u
#define BCH_CTRL_SET_M2M_ENABLE_SHIFT            16
#define BCH_CTRL_SET_M2M_ENCODE_MASK             0x20000u
#define BCH_CTRL_SET_M2M_ENCODE_SHIFT            17
#define BCH_CTRL_SET_M2M_LAYOUT_MASK             0xC0000u
#define BCH_CTRL_SET_M2M_LAYOUT_SHIFT            18
#define BCH_CTRL_SET_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_SET_M2M_LAYOUT_SHIFT))&BCH_CTRL_SET_M2M_LAYOUT_MASK)
#define BCH_CTRL_SET_RSVD4_MASK                  0x300000u
#define BCH_CTRL_SET_RSVD4_SHIFT                 20
#define BCH_CTRL_SET_RSVD4(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_SET_RSVD4_SHIFT))&BCH_CTRL_SET_RSVD4_MASK)
#define BCH_CTRL_SET_DEBUGSYNDROME_MASK          0x400000u
#define BCH_CTRL_SET_DEBUGSYNDROME_SHIFT         22
#define BCH_CTRL_SET_RSVD5_MASK                  0x3F800000u
#define BCH_CTRL_SET_RSVD5_SHIFT                 23
#define BCH_CTRL_SET_RSVD5(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_SET_RSVD5_SHIFT))&BCH_CTRL_SET_RSVD5_MASK)
#define BCH_CTRL_SET_CLKGATE_MASK                0x40000000u
#define BCH_CTRL_SET_CLKGATE_SHIFT               30
#define BCH_CTRL_SET_SFTRST_MASK                 0x80000000u
#define BCH_CTRL_SET_SFTRST_SHIFT                31
/* CTRL_CLR Bit Fields */
#define BCH_CTRL_CLR_COMPLETE_IRQ_MASK           0x1u
#define BCH_CTRL_CLR_COMPLETE_IRQ_SHIFT          0
#define BCH_CTRL_CLR_RSVD0_MASK                  0x2u
#define BCH_CTRL_CLR_RSVD0_SHIFT                 1
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_MASK        0x4u
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_SHIFT       2
#define BCH_CTRL_CLR_BM_ERROR_IRQ_MASK           0x8u
#define BCH_CTRL_CLR_BM_ERROR_IRQ_SHIFT          3
#define BCH_CTRL_CLR_RSVD1_MASK                  0xF0u
#define BCH_CTRL_CLR_RSVD1_SHIFT                 4
#define BCH_CTRL_CLR_RSVD1(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_CLR_RSVD1_SHIFT))&BCH_CTRL_CLR_RSVD1_MASK)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_MASK        0x100u
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_SHIFT       8
#define BCH_CTRL_CLR_RSVD2_MASK                  0x200u
#define BCH_CTRL_CLR_RSVD2_SHIFT                 9
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_MASK     0x400u
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_SHIFT    10
#define BCH_CTRL_CLR_RSVD3_MASK                  0xF800u
#define BCH_CTRL_CLR_RSVD3_SHIFT                 11
#define BCH_CTRL_CLR_RSVD3(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_CLR_RSVD3_SHIFT))&BCH_CTRL_CLR_RSVD3_MASK)
#define BCH_CTRL_CLR_M2M_ENABLE_MASK             0x10000u
#define BCH_CTRL_CLR_M2M_ENABLE_SHIFT            16
#define BCH_CTRL_CLR_M2M_ENCODE_MASK             0x20000u
#define BCH_CTRL_CLR_M2M_ENCODE_SHIFT            17
#define BCH_CTRL_CLR_M2M_LAYOUT_MASK             0xC0000u
#define BCH_CTRL_CLR_M2M_LAYOUT_SHIFT            18
#define BCH_CTRL_CLR_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_CLR_M2M_LAYOUT_SHIFT))&BCH_CTRL_CLR_M2M_LAYOUT_MASK)
#define BCH_CTRL_CLR_RSVD4_MASK                  0x300000u
#define BCH_CTRL_CLR_RSVD4_SHIFT                 20
#define BCH_CTRL_CLR_RSVD4(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_CLR_RSVD4_SHIFT))&BCH_CTRL_CLR_RSVD4_MASK)
#define BCH_CTRL_CLR_DEBUGSYNDROME_MASK          0x400000u
#define BCH_CTRL_CLR_DEBUGSYNDROME_SHIFT         22
#define BCH_CTRL_CLR_RSVD5_MASK                  0x3F800000u
#define BCH_CTRL_CLR_RSVD5_SHIFT                 23
#define BCH_CTRL_CLR_RSVD5(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_CLR_RSVD5_SHIFT))&BCH_CTRL_CLR_RSVD5_MASK)
#define BCH_CTRL_CLR_CLKGATE_MASK                0x40000000u
#define BCH_CTRL_CLR_CLKGATE_SHIFT               30
#define BCH_CTRL_CLR_SFTRST_MASK                 0x80000000u
#define BCH_CTRL_CLR_SFTRST_SHIFT                31
/* CTRL_TOG Bit Fields */
#define BCH_CTRL_TOG_COMPLETE_IRQ_MASK           0x1u
#define BCH_CTRL_TOG_COMPLETE_IRQ_SHIFT          0
#define BCH_CTRL_TOG_RSVD0_MASK                  0x2u
#define BCH_CTRL_TOG_RSVD0_SHIFT                 1
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_MASK        0x4u
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_SHIFT       2
#define BCH_CTRL_TOG_BM_ERROR_IRQ_MASK           0x8u
#define BCH_CTRL_TOG_BM_ERROR_IRQ_SHIFT          3
#define BCH_CTRL_TOG_RSVD1_MASK                  0xF0u
#define BCH_CTRL_TOG_RSVD1_SHIFT                 4
#define BCH_CTRL_TOG_RSVD1(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_TOG_RSVD1_SHIFT))&BCH_CTRL_TOG_RSVD1_MASK)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_MASK        0x100u
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_SHIFT       8
#define BCH_CTRL_TOG_RSVD2_MASK                  0x200u
#define BCH_CTRL_TOG_RSVD2_SHIFT                 9
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_MASK     0x400u
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_SHIFT    10
#define BCH_CTRL_TOG_RSVD3_MASK                  0xF800u
#define BCH_CTRL_TOG_RSVD3_SHIFT                 11
#define BCH_CTRL_TOG_RSVD3(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_TOG_RSVD3_SHIFT))&BCH_CTRL_TOG_RSVD3_MASK)
#define BCH_CTRL_TOG_M2M_ENABLE_MASK             0x10000u
#define BCH_CTRL_TOG_M2M_ENABLE_SHIFT            16
#define BCH_CTRL_TOG_M2M_ENCODE_MASK             0x20000u
#define BCH_CTRL_TOG_M2M_ENCODE_SHIFT            17
#define BCH_CTRL_TOG_M2M_LAYOUT_MASK             0xC0000u
#define BCH_CTRL_TOG_M2M_LAYOUT_SHIFT            18
#define BCH_CTRL_TOG_M2M_LAYOUT(x)               (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_TOG_M2M_LAYOUT_SHIFT))&BCH_CTRL_TOG_M2M_LAYOUT_MASK)
#define BCH_CTRL_TOG_RSVD4_MASK                  0x300000u
#define BCH_CTRL_TOG_RSVD4_SHIFT                 20
#define BCH_CTRL_TOG_RSVD4(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_TOG_RSVD4_SHIFT))&BCH_CTRL_TOG_RSVD4_MASK)
#define BCH_CTRL_TOG_DEBUGSYNDROME_MASK          0x400000u
#define BCH_CTRL_TOG_DEBUGSYNDROME_SHIFT         22
#define BCH_CTRL_TOG_RSVD5_MASK                  0x3F800000u
#define BCH_CTRL_TOG_RSVD5_SHIFT                 23
#define BCH_CTRL_TOG_RSVD5(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_CTRL_TOG_RSVD5_SHIFT))&BCH_CTRL_TOG_RSVD5_MASK)
#define BCH_CTRL_TOG_CLKGATE_MASK                0x40000000u
#define BCH_CTRL_TOG_CLKGATE_SHIFT               30
#define BCH_CTRL_TOG_SFTRST_MASK                 0x80000000u
#define BCH_CTRL_TOG_SFTRST_SHIFT                31
/* STATUS0 Bit Fields */
#define BCH_STATUS0_RSVD0_MASK                   0x3u
#define BCH_STATUS0_RSVD0_SHIFT                  0
#define BCH_STATUS0_RSVD0(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_RSVD0_SHIFT))&BCH_STATUS0_RSVD0_MASK)
#define BCH_STATUS0_UNCORRECTABLE_MASK           0x4u
#define BCH_STATUS0_UNCORRECTABLE_SHIFT          2
#define BCH_STATUS0_CORRECTED_MASK               0x8u
#define BCH_STATUS0_CORRECTED_SHIFT              3
#define BCH_STATUS0_ALLONES_MASK                 0x10u
#define BCH_STATUS0_ALLONES_SHIFT                4
#define BCH_STATUS0_RSVD1_MASK                   0xE0u
#define BCH_STATUS0_RSVD1_SHIFT                  5
#define BCH_STATUS0_RSVD1(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_RSVD1_SHIFT))&BCH_STATUS0_RSVD1_MASK)
#define BCH_STATUS0_STATUS_BLK0_MASK             0xFF00u
#define BCH_STATUS0_STATUS_BLK0_SHIFT            8
#define BCH_STATUS0_STATUS_BLK0(x)               (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_STATUS_BLK0_SHIFT))&BCH_STATUS0_STATUS_BLK0_MASK)
#define BCH_STATUS0_COMPLETED_CE_MASK            0xF0000u
#define BCH_STATUS0_COMPLETED_CE_SHIFT           16
#define BCH_STATUS0_COMPLETED_CE(x)              (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_COMPLETED_CE_SHIFT))&BCH_STATUS0_COMPLETED_CE_MASK)
#define BCH_STATUS0_HANDLE_MASK                  0xFFF00000u
#define BCH_STATUS0_HANDLE_SHIFT                 20
#define BCH_STATUS0_HANDLE(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_HANDLE_SHIFT))&BCH_STATUS0_HANDLE_MASK)
/* STATUS0_SET Bit Fields */
#define BCH_STATUS0_SET_RSVD0_MASK               0x3u
#define BCH_STATUS0_SET_RSVD0_SHIFT              0
#define BCH_STATUS0_SET_RSVD0(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_SET_RSVD0_SHIFT))&BCH_STATUS0_SET_RSVD0_MASK)
#define BCH_STATUS0_SET_UNCORRECTABLE_MASK       0x4u
#define BCH_STATUS0_SET_UNCORRECTABLE_SHIFT      2
#define BCH_STATUS0_SET_CORRECTED_MASK           0x8u
#define BCH_STATUS0_SET_CORRECTED_SHIFT          3
#define BCH_STATUS0_SET_ALLONES_MASK             0x10u
#define BCH_STATUS0_SET_ALLONES_SHIFT            4
#define BCH_STATUS0_SET_RSVD1_MASK               0xE0u
#define BCH_STATUS0_SET_RSVD1_SHIFT              5
#define BCH_STATUS0_SET_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_SET_RSVD1_SHIFT))&BCH_STATUS0_SET_RSVD1_MASK)
#define BCH_STATUS0_SET_STATUS_BLK0_MASK         0xFF00u
#define BCH_STATUS0_SET_STATUS_BLK0_SHIFT        8
#define BCH_STATUS0_SET_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_SET_STATUS_BLK0_SHIFT))&BCH_STATUS0_SET_STATUS_BLK0_MASK)
#define BCH_STATUS0_SET_COMPLETED_CE_MASK        0xF0000u
#define BCH_STATUS0_SET_COMPLETED_CE_SHIFT       16
#define BCH_STATUS0_SET_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_SET_COMPLETED_CE_SHIFT))&BCH_STATUS0_SET_COMPLETED_CE_MASK)
#define BCH_STATUS0_SET_HANDLE_MASK              0xFFF00000u
#define BCH_STATUS0_SET_HANDLE_SHIFT             20
#define BCH_STATUS0_SET_HANDLE(x)                (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_SET_HANDLE_SHIFT))&BCH_STATUS0_SET_HANDLE_MASK)
/* STATUS0_CLR Bit Fields */
#define BCH_STATUS0_CLR_RSVD0_MASK               0x3u
#define BCH_STATUS0_CLR_RSVD0_SHIFT              0
#define BCH_STATUS0_CLR_RSVD0(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_CLR_RSVD0_SHIFT))&BCH_STATUS0_CLR_RSVD0_MASK)
#define BCH_STATUS0_CLR_UNCORRECTABLE_MASK       0x4u
#define BCH_STATUS0_CLR_UNCORRECTABLE_SHIFT      2
#define BCH_STATUS0_CLR_CORRECTED_MASK           0x8u
#define BCH_STATUS0_CLR_CORRECTED_SHIFT          3
#define BCH_STATUS0_CLR_ALLONES_MASK             0x10u
#define BCH_STATUS0_CLR_ALLONES_SHIFT            4
#define BCH_STATUS0_CLR_RSVD1_MASK               0xE0u
#define BCH_STATUS0_CLR_RSVD1_SHIFT              5
#define BCH_STATUS0_CLR_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_CLR_RSVD1_SHIFT))&BCH_STATUS0_CLR_RSVD1_MASK)
#define BCH_STATUS0_CLR_STATUS_BLK0_MASK         0xFF00u
#define BCH_STATUS0_CLR_STATUS_BLK0_SHIFT        8
#define BCH_STATUS0_CLR_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_CLR_STATUS_BLK0_SHIFT))&BCH_STATUS0_CLR_STATUS_BLK0_MASK)
#define BCH_STATUS0_CLR_COMPLETED_CE_MASK        0xF0000u
#define BCH_STATUS0_CLR_COMPLETED_CE_SHIFT       16
#define BCH_STATUS0_CLR_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_CLR_COMPLETED_CE_SHIFT))&BCH_STATUS0_CLR_COMPLETED_CE_MASK)
#define BCH_STATUS0_CLR_HANDLE_MASK              0xFFF00000u
#define BCH_STATUS0_CLR_HANDLE_SHIFT             20
#define BCH_STATUS0_CLR_HANDLE(x)                (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_CLR_HANDLE_SHIFT))&BCH_STATUS0_CLR_HANDLE_MASK)
/* STATUS0_TOG Bit Fields */
#define BCH_STATUS0_TOG_RSVD0_MASK               0x3u
#define BCH_STATUS0_TOG_RSVD0_SHIFT              0
#define BCH_STATUS0_TOG_RSVD0(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_TOG_RSVD0_SHIFT))&BCH_STATUS0_TOG_RSVD0_MASK)
#define BCH_STATUS0_TOG_UNCORRECTABLE_MASK       0x4u
#define BCH_STATUS0_TOG_UNCORRECTABLE_SHIFT      2
#define BCH_STATUS0_TOG_CORRECTED_MASK           0x8u
#define BCH_STATUS0_TOG_CORRECTED_SHIFT          3
#define BCH_STATUS0_TOG_ALLONES_MASK             0x10u
#define BCH_STATUS0_TOG_ALLONES_SHIFT            4
#define BCH_STATUS0_TOG_RSVD1_MASK               0xE0u
#define BCH_STATUS0_TOG_RSVD1_SHIFT              5
#define BCH_STATUS0_TOG_RSVD1(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_TOG_RSVD1_SHIFT))&BCH_STATUS0_TOG_RSVD1_MASK)
#define BCH_STATUS0_TOG_STATUS_BLK0_MASK         0xFF00u
#define BCH_STATUS0_TOG_STATUS_BLK0_SHIFT        8
#define BCH_STATUS0_TOG_STATUS_BLK0(x)           (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_TOG_STATUS_BLK0_SHIFT))&BCH_STATUS0_TOG_STATUS_BLK0_MASK)
#define BCH_STATUS0_TOG_COMPLETED_CE_MASK        0xF0000u
#define BCH_STATUS0_TOG_COMPLETED_CE_SHIFT       16
#define BCH_STATUS0_TOG_COMPLETED_CE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_TOG_COMPLETED_CE_SHIFT))&BCH_STATUS0_TOG_COMPLETED_CE_MASK)
#define BCH_STATUS0_TOG_HANDLE_MASK              0xFFF00000u
#define BCH_STATUS0_TOG_HANDLE_SHIFT             20
#define BCH_STATUS0_TOG_HANDLE(x)                (((uint32_t)(((uint32_t)(x))<<BCH_STATUS0_TOG_HANDLE_SHIFT))&BCH_STATUS0_TOG_HANDLE_MASK)
/* MODE Bit Fields */
#define BCH_MODE_ERASE_THRESHOLD_MASK            0xFFu
#define BCH_MODE_ERASE_THRESHOLD_SHIFT           0
#define BCH_MODE_ERASE_THRESHOLD(x)              (((uint32_t)(((uint32_t)(x))<<BCH_MODE_ERASE_THRESHOLD_SHIFT))&BCH_MODE_ERASE_THRESHOLD_MASK)
#define BCH_MODE_RSVD_MASK                       0xFFFFFF00u
#define BCH_MODE_RSVD_SHIFT                      8
#define BCH_MODE_RSVD(x)                         (((uint32_t)(((uint32_t)(x))<<BCH_MODE_RSVD_SHIFT))&BCH_MODE_RSVD_MASK)
/* MODE_SET Bit Fields */
#define BCH_MODE_SET_ERASE_THRESHOLD_MASK        0xFFu
#define BCH_MODE_SET_ERASE_THRESHOLD_SHIFT       0
#define BCH_MODE_SET_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x))<<BCH_MODE_SET_ERASE_THRESHOLD_SHIFT))&BCH_MODE_SET_ERASE_THRESHOLD_MASK)
#define BCH_MODE_SET_RSVD_MASK                   0xFFFFFF00u
#define BCH_MODE_SET_RSVD_SHIFT                  8
#define BCH_MODE_SET_RSVD(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_MODE_SET_RSVD_SHIFT))&BCH_MODE_SET_RSVD_MASK)
/* MODE_CLR Bit Fields */
#define BCH_MODE_CLR_ERASE_THRESHOLD_MASK        0xFFu
#define BCH_MODE_CLR_ERASE_THRESHOLD_SHIFT       0
#define BCH_MODE_CLR_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x))<<BCH_MODE_CLR_ERASE_THRESHOLD_SHIFT))&BCH_MODE_CLR_ERASE_THRESHOLD_MASK)
#define BCH_MODE_CLR_RSVD_MASK                   0xFFFFFF00u
#define BCH_MODE_CLR_RSVD_SHIFT                  8
#define BCH_MODE_CLR_RSVD(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_MODE_CLR_RSVD_SHIFT))&BCH_MODE_CLR_RSVD_MASK)
/* MODE_TOG Bit Fields */
#define BCH_MODE_TOG_ERASE_THRESHOLD_MASK        0xFFu
#define BCH_MODE_TOG_ERASE_THRESHOLD_SHIFT       0
#define BCH_MODE_TOG_ERASE_THRESHOLD(x)          (((uint32_t)(((uint32_t)(x))<<BCH_MODE_TOG_ERASE_THRESHOLD_SHIFT))&BCH_MODE_TOG_ERASE_THRESHOLD_MASK)
#define BCH_MODE_TOG_RSVD_MASK                   0xFFFFFF00u
#define BCH_MODE_TOG_RSVD_SHIFT                  8
#define BCH_MODE_TOG_RSVD(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_MODE_TOG_RSVD_SHIFT))&BCH_MODE_TOG_RSVD_MASK)
/* ENCODEPTR Bit Fields */
#define BCH_ENCODEPTR_ADDR_MASK                  0xFFFFFFFFu
#define BCH_ENCODEPTR_ADDR_SHIFT                 0
#define BCH_ENCODEPTR_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_ENCODEPTR_ADDR_SHIFT))&BCH_ENCODEPTR_ADDR_MASK)
/* ENCODEPTR_SET Bit Fields */
#define BCH_ENCODEPTR_SET_ADDR_MASK              0xFFFFFFFFu
#define BCH_ENCODEPTR_SET_ADDR_SHIFT             0
#define BCH_ENCODEPTR_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<BCH_ENCODEPTR_SET_ADDR_SHIFT))&BCH_ENCODEPTR_SET_ADDR_MASK)
/* ENCODEPTR_CLR Bit Fields */
#define BCH_ENCODEPTR_CLR_ADDR_MASK              0xFFFFFFFFu
#define BCH_ENCODEPTR_CLR_ADDR_SHIFT             0
#define BCH_ENCODEPTR_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<BCH_ENCODEPTR_CLR_ADDR_SHIFT))&BCH_ENCODEPTR_CLR_ADDR_MASK)
/* ENCODEPTR_TOG Bit Fields */
#define BCH_ENCODEPTR_TOG_ADDR_MASK              0xFFFFFFFFu
#define BCH_ENCODEPTR_TOG_ADDR_SHIFT             0
#define BCH_ENCODEPTR_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<BCH_ENCODEPTR_TOG_ADDR_SHIFT))&BCH_ENCODEPTR_TOG_ADDR_MASK)
/* DATAPTR Bit Fields */
#define BCH_DATAPTR_ADDR_MASK                    0xFFFFFFFFu
#define BCH_DATAPTR_ADDR_SHIFT                   0
#define BCH_DATAPTR_ADDR(x)                      (((uint32_t)(((uint32_t)(x))<<BCH_DATAPTR_ADDR_SHIFT))&BCH_DATAPTR_ADDR_MASK)
/* DATAPTR_SET Bit Fields */
#define BCH_DATAPTR_SET_ADDR_MASK                0xFFFFFFFFu
#define BCH_DATAPTR_SET_ADDR_SHIFT               0
#define BCH_DATAPTR_SET_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DATAPTR_SET_ADDR_SHIFT))&BCH_DATAPTR_SET_ADDR_MASK)
/* DATAPTR_CLR Bit Fields */
#define BCH_DATAPTR_CLR_ADDR_MASK                0xFFFFFFFFu
#define BCH_DATAPTR_CLR_ADDR_SHIFT               0
#define BCH_DATAPTR_CLR_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DATAPTR_CLR_ADDR_SHIFT))&BCH_DATAPTR_CLR_ADDR_MASK)
/* DATAPTR_TOG Bit Fields */
#define BCH_DATAPTR_TOG_ADDR_MASK                0xFFFFFFFFu
#define BCH_DATAPTR_TOG_ADDR_SHIFT               0
#define BCH_DATAPTR_TOG_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DATAPTR_TOG_ADDR_SHIFT))&BCH_DATAPTR_TOG_ADDR_MASK)
/* METAPTR Bit Fields */
#define BCH_METAPTR_ADDR_MASK                    0xFFFFFFFFu
#define BCH_METAPTR_ADDR_SHIFT                   0
#define BCH_METAPTR_ADDR(x)                      (((uint32_t)(((uint32_t)(x))<<BCH_METAPTR_ADDR_SHIFT))&BCH_METAPTR_ADDR_MASK)
/* METAPTR_SET Bit Fields */
#define BCH_METAPTR_SET_ADDR_MASK                0xFFFFFFFFu
#define BCH_METAPTR_SET_ADDR_SHIFT               0
#define BCH_METAPTR_SET_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_METAPTR_SET_ADDR_SHIFT))&BCH_METAPTR_SET_ADDR_MASK)
/* METAPTR_CLR Bit Fields */
#define BCH_METAPTR_CLR_ADDR_MASK                0xFFFFFFFFu
#define BCH_METAPTR_CLR_ADDR_SHIFT               0
#define BCH_METAPTR_CLR_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_METAPTR_CLR_ADDR_SHIFT))&BCH_METAPTR_CLR_ADDR_MASK)
/* METAPTR_TOG Bit Fields */
#define BCH_METAPTR_TOG_ADDR_MASK                0xFFFFFFFFu
#define BCH_METAPTR_TOG_ADDR_SHIFT               0
#define BCH_METAPTR_TOG_ADDR(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_METAPTR_TOG_ADDR_SHIFT))&BCH_METAPTR_TOG_ADDR_MASK)
/* LAYOUTSELECT Bit Fields */
#define BCH_LAYOUTSELECT_CS0_SELECT_MASK         0x3u
#define BCH_LAYOUTSELECT_CS0_SELECT_SHIFT        0
#define BCH_LAYOUTSELECT_CS0_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS0_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS1_SELECT_MASK         0xCu
#define BCH_LAYOUTSELECT_CS1_SELECT_SHIFT        2
#define BCH_LAYOUTSELECT_CS1_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS1_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS2_SELECT_MASK         0x30u
#define BCH_LAYOUTSELECT_CS2_SELECT_SHIFT        4
#define BCH_LAYOUTSELECT_CS2_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS2_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS3_SELECT_MASK         0xC0u
#define BCH_LAYOUTSELECT_CS3_SELECT_SHIFT        6
#define BCH_LAYOUTSELECT_CS3_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS3_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS4_SELECT_MASK         0x300u
#define BCH_LAYOUTSELECT_CS4_SELECT_SHIFT        8
#define BCH_LAYOUTSELECT_CS4_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS4_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS5_SELECT_MASK         0xC00u
#define BCH_LAYOUTSELECT_CS5_SELECT_SHIFT        10
#define BCH_LAYOUTSELECT_CS5_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS5_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS6_SELECT_MASK         0x3000u
#define BCH_LAYOUTSELECT_CS6_SELECT_SHIFT        12
#define BCH_LAYOUTSELECT_CS6_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS6_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS7_SELECT_MASK         0xC000u
#define BCH_LAYOUTSELECT_CS7_SELECT_SHIFT        14
#define BCH_LAYOUTSELECT_CS7_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS7_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS8_SELECT_MASK         0x30000u
#define BCH_LAYOUTSELECT_CS8_SELECT_SHIFT        16
#define BCH_LAYOUTSELECT_CS8_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS8_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS9_SELECT_MASK         0xC0000u
#define BCH_LAYOUTSELECT_CS9_SELECT_SHIFT        18
#define BCH_LAYOUTSELECT_CS9_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS9_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS10_SELECT_MASK        0x300000u
#define BCH_LAYOUTSELECT_CS10_SELECT_SHIFT       20
#define BCH_LAYOUTSELECT_CS10_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS10_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS11_SELECT_MASK        0xC00000u
#define BCH_LAYOUTSELECT_CS11_SELECT_SHIFT       22
#define BCH_LAYOUTSELECT_CS11_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS11_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS12_SELECT_MASK        0x3000000u
#define BCH_LAYOUTSELECT_CS12_SELECT_SHIFT       24
#define BCH_LAYOUTSELECT_CS12_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS12_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS13_SELECT_MASK        0xC000000u
#define BCH_LAYOUTSELECT_CS13_SELECT_SHIFT       26
#define BCH_LAYOUTSELECT_CS13_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS13_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS14_SELECT_MASK        0x30000000u
#define BCH_LAYOUTSELECT_CS14_SELECT_SHIFT       28
#define BCH_LAYOUTSELECT_CS14_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS14_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS15_SELECT_MASK        0xC0000000u
#define BCH_LAYOUTSELECT_CS15_SELECT_SHIFT       30
#define BCH_LAYOUTSELECT_CS15_SELECT(x)          (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CS15_SELECT_SHIFT))&BCH_LAYOUTSELECT_CS15_SELECT_MASK)
/* LAYOUTSELECT_SET Bit Fields */
#define BCH_LAYOUTSELECT_SET_CS0_SELECT_MASK     0x3u
#define BCH_LAYOUTSELECT_SET_CS0_SELECT_SHIFT    0
#define BCH_LAYOUTSELECT_SET_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS0_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS1_SELECT_MASK     0xCu
#define BCH_LAYOUTSELECT_SET_CS1_SELECT_SHIFT    2
#define BCH_LAYOUTSELECT_SET_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS1_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS2_SELECT_MASK     0x30u
#define BCH_LAYOUTSELECT_SET_CS2_SELECT_SHIFT    4
#define BCH_LAYOUTSELECT_SET_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS2_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS3_SELECT_MASK     0xC0u
#define BCH_LAYOUTSELECT_SET_CS3_SELECT_SHIFT    6
#define BCH_LAYOUTSELECT_SET_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS3_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS4_SELECT_MASK     0x300u
#define BCH_LAYOUTSELECT_SET_CS4_SELECT_SHIFT    8
#define BCH_LAYOUTSELECT_SET_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS4_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS5_SELECT_MASK     0xC00u
#define BCH_LAYOUTSELECT_SET_CS5_SELECT_SHIFT    10
#define BCH_LAYOUTSELECT_SET_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS5_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS6_SELECT_MASK     0x3000u
#define BCH_LAYOUTSELECT_SET_CS6_SELECT_SHIFT    12
#define BCH_LAYOUTSELECT_SET_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS6_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS7_SELECT_MASK     0xC000u
#define BCH_LAYOUTSELECT_SET_CS7_SELECT_SHIFT    14
#define BCH_LAYOUTSELECT_SET_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS7_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS8_SELECT_MASK     0x30000u
#define BCH_LAYOUTSELECT_SET_CS8_SELECT_SHIFT    16
#define BCH_LAYOUTSELECT_SET_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS8_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS9_SELECT_MASK     0xC0000u
#define BCH_LAYOUTSELECT_SET_CS9_SELECT_SHIFT    18
#define BCH_LAYOUTSELECT_SET_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS9_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS10_SELECT_MASK    0x300000u
#define BCH_LAYOUTSELECT_SET_CS10_SELECT_SHIFT   20
#define BCH_LAYOUTSELECT_SET_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS10_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS11_SELECT_MASK    0xC00000u
#define BCH_LAYOUTSELECT_SET_CS11_SELECT_SHIFT   22
#define BCH_LAYOUTSELECT_SET_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS11_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS12_SELECT_MASK    0x3000000u
#define BCH_LAYOUTSELECT_SET_CS12_SELECT_SHIFT   24
#define BCH_LAYOUTSELECT_SET_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS12_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS13_SELECT_MASK    0xC000000u
#define BCH_LAYOUTSELECT_SET_CS13_SELECT_SHIFT   26
#define BCH_LAYOUTSELECT_SET_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS13_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS14_SELECT_MASK    0x30000000u
#define BCH_LAYOUTSELECT_SET_CS14_SELECT_SHIFT   28
#define BCH_LAYOUTSELECT_SET_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS14_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_SET_CS15_SELECT_MASK    0xC0000000u
#define BCH_LAYOUTSELECT_SET_CS15_SELECT_SHIFT   30
#define BCH_LAYOUTSELECT_SET_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_SET_CS15_SELECT_SHIFT))&BCH_LAYOUTSELECT_SET_CS15_SELECT_MASK)
/* LAYOUTSELECT_CLR Bit Fields */
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT_MASK     0x3u
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT_SHIFT    0
#define BCH_LAYOUTSELECT_CLR_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS0_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT_MASK     0xCu
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT_SHIFT    2
#define BCH_LAYOUTSELECT_CLR_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS1_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT_MASK     0x30u
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT_SHIFT    4
#define BCH_LAYOUTSELECT_CLR_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS2_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT_MASK     0xC0u
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT_SHIFT    6
#define BCH_LAYOUTSELECT_CLR_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS3_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT_MASK     0x300u
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT_SHIFT    8
#define BCH_LAYOUTSELECT_CLR_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS4_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT_MASK     0xC00u
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT_SHIFT    10
#define BCH_LAYOUTSELECT_CLR_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS5_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT_MASK     0x3000u
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT_SHIFT    12
#define BCH_LAYOUTSELECT_CLR_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS6_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT_MASK     0xC000u
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT_SHIFT    14
#define BCH_LAYOUTSELECT_CLR_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS7_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT_MASK     0x30000u
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT_SHIFT    16
#define BCH_LAYOUTSELECT_CLR_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS8_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT_MASK     0xC0000u
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT_SHIFT    18
#define BCH_LAYOUTSELECT_CLR_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS9_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT_MASK    0x300000u
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT_SHIFT   20
#define BCH_LAYOUTSELECT_CLR_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS10_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT_MASK    0xC00000u
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT_SHIFT   22
#define BCH_LAYOUTSELECT_CLR_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS11_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT_MASK    0x3000000u
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT_SHIFT   24
#define BCH_LAYOUTSELECT_CLR_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS12_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT_MASK    0xC000000u
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT_SHIFT   26
#define BCH_LAYOUTSELECT_CLR_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS13_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT_MASK    0x30000000u
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT_SHIFT   28
#define BCH_LAYOUTSELECT_CLR_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS14_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT_MASK    0xC0000000u
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT_SHIFT   30
#define BCH_LAYOUTSELECT_CLR_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_CLR_CS15_SELECT_SHIFT))&BCH_LAYOUTSELECT_CLR_CS15_SELECT_MASK)
/* LAYOUTSELECT_TOG Bit Fields */
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT_MASK     0x3u
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT_SHIFT    0
#define BCH_LAYOUTSELECT_TOG_CS0_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS0_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT_MASK     0xCu
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT_SHIFT    2
#define BCH_LAYOUTSELECT_TOG_CS1_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS1_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT_MASK     0x30u
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT_SHIFT    4
#define BCH_LAYOUTSELECT_TOG_CS2_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS2_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT_MASK     0xC0u
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT_SHIFT    6
#define BCH_LAYOUTSELECT_TOG_CS3_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS3_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT_MASK     0x300u
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT_SHIFT    8
#define BCH_LAYOUTSELECT_TOG_CS4_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS4_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT_MASK     0xC00u
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT_SHIFT    10
#define BCH_LAYOUTSELECT_TOG_CS5_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS5_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT_MASK     0x3000u
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT_SHIFT    12
#define BCH_LAYOUTSELECT_TOG_CS6_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS6_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT_MASK     0xC000u
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT_SHIFT    14
#define BCH_LAYOUTSELECT_TOG_CS7_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS7_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT_MASK     0x30000u
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT_SHIFT    16
#define BCH_LAYOUTSELECT_TOG_CS8_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS8_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT_MASK     0xC0000u
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT_SHIFT    18
#define BCH_LAYOUTSELECT_TOG_CS9_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS9_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT_MASK    0x300000u
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT_SHIFT   20
#define BCH_LAYOUTSELECT_TOG_CS10_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS10_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT_MASK    0xC00000u
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT_SHIFT   22
#define BCH_LAYOUTSELECT_TOG_CS11_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS11_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT_MASK    0x3000000u
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT_SHIFT   24
#define BCH_LAYOUTSELECT_TOG_CS12_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS12_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT_MASK    0xC000000u
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT_SHIFT   26
#define BCH_LAYOUTSELECT_TOG_CS13_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS13_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT_MASK    0x30000000u
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT_SHIFT   28
#define BCH_LAYOUTSELECT_TOG_CS14_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS14_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT_MASK    0xC0000000u
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT_SHIFT   30
#define BCH_LAYOUTSELECT_TOG_CS15_SELECT(x)      (((uint32_t)(((uint32_t)(x))<<BCH_LAYOUTSELECT_TOG_CS15_SELECT_SHIFT))&BCH_LAYOUTSELECT_TOG_CS15_SELECT_MASK)
/* FLASH0LAYOUT0 Bit Fields */
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK        0x3FFu
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT       0
#define BCH_FLASH0LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH0LAYOUT0_ECC0_MASK              0xF800u
#define BCH_FLASH0LAYOUT0_ECC0_SHIFT             11
#define BCH_FLASH0LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_ECC0_SHIFT))&BCH_FLASH0LAYOUT0_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_META_SIZE_MASK         0xFF0000u
#define BCH_FLASH0LAYOUT0_META_SIZE_SHIFT        16
#define BCH_FLASH0LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_META_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_NBLOCKS_MASK           0xFF000000u
#define BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT          24
#define BCH_FLASH0LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT))&BCH_FLASH0LAYOUT0_NBLOCKS_MASK)
/* FLASH0LAYOUT0_SET Bit Fields */
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT0_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT0_SET_ECC0_MASK          0xF800u
#define BCH_FLASH0LAYOUT0_SET_ECC0_SHIFT         11
#define BCH_FLASH0LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_SET_ECC0_SHIFT))&BCH_FLASH0LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_SET_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH0LAYOUT0_SET_META_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_SET_META_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS_SHIFT      24
#define BCH_FLASH0LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_SET_NBLOCKS_SHIFT))&BCH_FLASH0LAYOUT0_SET_NBLOCKS_MASK)
/* FLASH0LAYOUT0_CLR Bit Fields */
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT0_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT0_CLR_ECC0_MASK          0xF800u
#define BCH_FLASH0LAYOUT0_CLR_ECC0_SHIFT         11
#define BCH_FLASH0LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_CLR_ECC0_SHIFT))&BCH_FLASH0LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_CLR_META_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS_SHIFT      24
#define BCH_FLASH0LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_CLR_NBLOCKS_SHIFT))&BCH_FLASH0LAYOUT0_CLR_NBLOCKS_MASK)
/* FLASH0LAYOUT0_TOG Bit Fields */
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT0_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT0_TOG_ECC0_MASK          0xF800u
#define BCH_FLASH0LAYOUT0_TOG_ECC0_SHIFT         11
#define BCH_FLASH0LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_TOG_ECC0_SHIFT))&BCH_FLASH0LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_TOG_META_SIZE_SHIFT))&BCH_FLASH0LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS_SHIFT      24
#define BCH_FLASH0LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT0_TOG_NBLOCKS_SHIFT))&BCH_FLASH0LAYOUT0_TOG_NBLOCKS_MASK)
/* FLASH0LAYOUT1 Bit Fields */
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK        0x3FFu
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT       0
#define BCH_FLASH0LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH0LAYOUT1_ECCN_MASK              0xF800u
#define BCH_FLASH0LAYOUT1_ECCN_SHIFT             11
#define BCH_FLASH0LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_ECCN_SHIFT))&BCH_FLASH0LAYOUT1_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK         0xFFFF0000u
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT        16
#define BCH_FLASH0LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK)
/* FLASH0LAYOUT1_SET Bit Fields */
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT1_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT1_SET_ECCN_MASK          0xF800u
#define BCH_FLASH0LAYOUT1_SET_ECCN_SHIFT         11
#define BCH_FLASH0LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_SET_ECCN_SHIFT))&BCH_FLASH0LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_SET_PAGE_SIZE_MASK)
/* FLASH0LAYOUT1_CLR Bit Fields */
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT1_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT1_CLR_ECCN_MASK          0xF800u
#define BCH_FLASH0LAYOUT1_CLR_ECCN_SHIFT         11
#define BCH_FLASH0LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_CLR_ECCN_SHIFT))&BCH_FLASH0LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_CLR_PAGE_SIZE_MASK)
/* FLASH0LAYOUT1_TOG Bit Fields */
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_SHIFT   0
#define BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH0LAYOUT1_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH0LAYOUT1_TOG_ECCN_MASK          0xF800u
#define BCH_FLASH0LAYOUT1_TOG_ECCN_SHIFT         11
#define BCH_FLASH0LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_TOG_ECCN_SHIFT))&BCH_FLASH0LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_SHIFT    16
#define BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_SHIFT))&BCH_FLASH0LAYOUT1_TOG_PAGE_SIZE_MASK)
/* FLASH1LAYOUT0 Bit Fields */
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK        0x3FFu
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT       0
#define BCH_FLASH1LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH1LAYOUT0_ECC0_MASK              0xF800u
#define BCH_FLASH1LAYOUT0_ECC0_SHIFT             11
#define BCH_FLASH1LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_ECC0_SHIFT))&BCH_FLASH1LAYOUT0_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_META_SIZE_MASK         0xFF0000u
#define BCH_FLASH1LAYOUT0_META_SIZE_SHIFT        16
#define BCH_FLASH1LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_META_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_NBLOCKS_MASK           0xFF000000u
#define BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT          24
#define BCH_FLASH1LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT))&BCH_FLASH1LAYOUT0_NBLOCKS_MASK)
/* FLASH1LAYOUT0_SET Bit Fields */
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT0_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT0_SET_ECC0_MASK          0xF800u
#define BCH_FLASH1LAYOUT0_SET_ECC0_SHIFT         11
#define BCH_FLASH1LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_SET_ECC0_SHIFT))&BCH_FLASH1LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_SET_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH1LAYOUT0_SET_META_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_SET_META_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS_SHIFT      24
#define BCH_FLASH1LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_SET_NBLOCKS_SHIFT))&BCH_FLASH1LAYOUT0_SET_NBLOCKS_MASK)
/* FLASH1LAYOUT0_CLR Bit Fields */
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT0_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT0_CLR_ECC0_MASK          0xF800u
#define BCH_FLASH1LAYOUT0_CLR_ECC0_SHIFT         11
#define BCH_FLASH1LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_CLR_ECC0_SHIFT))&BCH_FLASH1LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_CLR_META_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS_SHIFT      24
#define BCH_FLASH1LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_CLR_NBLOCKS_SHIFT))&BCH_FLASH1LAYOUT0_CLR_NBLOCKS_MASK)
/* FLASH1LAYOUT0_TOG Bit Fields */
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT0_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT0_TOG_ECC0_MASK          0xF800u
#define BCH_FLASH1LAYOUT0_TOG_ECC0_SHIFT         11
#define BCH_FLASH1LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_TOG_ECC0_SHIFT))&BCH_FLASH1LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_TOG_META_SIZE_SHIFT))&BCH_FLASH1LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS_SHIFT      24
#define BCH_FLASH1LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT0_TOG_NBLOCKS_SHIFT))&BCH_FLASH1LAYOUT0_TOG_NBLOCKS_MASK)
/* FLASH1LAYOUT1 Bit Fields */
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK        0x3FFu
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT       0
#define BCH_FLASH1LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH1LAYOUT1_ECCN_MASK              0xF800u
#define BCH_FLASH1LAYOUT1_ECCN_SHIFT             11
#define BCH_FLASH1LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_ECCN_SHIFT))&BCH_FLASH1LAYOUT1_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK         0xFFFF0000u
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT        16
#define BCH_FLASH1LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK)
/* FLASH1LAYOUT1_SET Bit Fields */
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT1_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT1_SET_ECCN_MASK          0xF800u
#define BCH_FLASH1LAYOUT1_SET_ECCN_SHIFT         11
#define BCH_FLASH1LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_SET_ECCN_SHIFT))&BCH_FLASH1LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_SET_PAGE_SIZE_MASK)
/* FLASH1LAYOUT1_CLR Bit Fields */
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT1_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT1_CLR_ECCN_MASK          0xF800u
#define BCH_FLASH1LAYOUT1_CLR_ECCN_SHIFT         11
#define BCH_FLASH1LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_CLR_ECCN_SHIFT))&BCH_FLASH1LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_CLR_PAGE_SIZE_MASK)
/* FLASH1LAYOUT1_TOG Bit Fields */
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_SHIFT   0
#define BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH1LAYOUT1_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH1LAYOUT1_TOG_ECCN_MASK          0xF800u
#define BCH_FLASH1LAYOUT1_TOG_ECCN_SHIFT         11
#define BCH_FLASH1LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_TOG_ECCN_SHIFT))&BCH_FLASH1LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_SHIFT    16
#define BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_SHIFT))&BCH_FLASH1LAYOUT1_TOG_PAGE_SIZE_MASK)
/* FLASH2LAYOUT0 Bit Fields */
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK        0x3FFu
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT       0
#define BCH_FLASH2LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH2LAYOUT0_ECC0_MASK              0xF800u
#define BCH_FLASH2LAYOUT0_ECC0_SHIFT             11
#define BCH_FLASH2LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_ECC0_SHIFT))&BCH_FLASH2LAYOUT0_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_META_SIZE_MASK         0xFF0000u
#define BCH_FLASH2LAYOUT0_META_SIZE_SHIFT        16
#define BCH_FLASH2LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_META_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_NBLOCKS_MASK           0xFF000000u
#define BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT          24
#define BCH_FLASH2LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT))&BCH_FLASH2LAYOUT0_NBLOCKS_MASK)
/* FLASH2LAYOUT0_SET Bit Fields */
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT0_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT0_SET_ECC0_MASK          0xF800u
#define BCH_FLASH2LAYOUT0_SET_ECC0_SHIFT         11
#define BCH_FLASH2LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_SET_ECC0_SHIFT))&BCH_FLASH2LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_SET_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH2LAYOUT0_SET_META_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_SET_META_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS_SHIFT      24
#define BCH_FLASH2LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_SET_NBLOCKS_SHIFT))&BCH_FLASH2LAYOUT0_SET_NBLOCKS_MASK)
/* FLASH2LAYOUT0_CLR Bit Fields */
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT0_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT0_CLR_ECC0_MASK          0xF800u
#define BCH_FLASH2LAYOUT0_CLR_ECC0_SHIFT         11
#define BCH_FLASH2LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_CLR_ECC0_SHIFT))&BCH_FLASH2LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_CLR_META_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS_SHIFT      24
#define BCH_FLASH2LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_CLR_NBLOCKS_SHIFT))&BCH_FLASH2LAYOUT0_CLR_NBLOCKS_MASK)
/* FLASH2LAYOUT0_TOG Bit Fields */
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT0_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT0_TOG_ECC0_MASK          0xF800u
#define BCH_FLASH2LAYOUT0_TOG_ECC0_SHIFT         11
#define BCH_FLASH2LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_TOG_ECC0_SHIFT))&BCH_FLASH2LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_TOG_META_SIZE_SHIFT))&BCH_FLASH2LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS_SHIFT      24
#define BCH_FLASH2LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT0_TOG_NBLOCKS_SHIFT))&BCH_FLASH2LAYOUT0_TOG_NBLOCKS_MASK)
/* FLASH2LAYOUT1 Bit Fields */
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK        0x3FFu
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT       0
#define BCH_FLASH2LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH2LAYOUT1_ECCN_MASK              0xF800u
#define BCH_FLASH2LAYOUT1_ECCN_SHIFT             11
#define BCH_FLASH2LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_ECCN_SHIFT))&BCH_FLASH2LAYOUT1_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK         0xFFFF0000u
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT        16
#define BCH_FLASH2LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK)
/* FLASH2LAYOUT1_SET Bit Fields */
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT1_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT1_SET_ECCN_MASK          0xF800u
#define BCH_FLASH2LAYOUT1_SET_ECCN_SHIFT         11
#define BCH_FLASH2LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_SET_ECCN_SHIFT))&BCH_FLASH2LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_SET_PAGE_SIZE_MASK)
/* FLASH2LAYOUT1_CLR Bit Fields */
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT1_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT1_CLR_ECCN_MASK          0xF800u
#define BCH_FLASH2LAYOUT1_CLR_ECCN_SHIFT         11
#define BCH_FLASH2LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_CLR_ECCN_SHIFT))&BCH_FLASH2LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_CLR_PAGE_SIZE_MASK)
/* FLASH2LAYOUT1_TOG Bit Fields */
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_SHIFT   0
#define BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH2LAYOUT1_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH2LAYOUT1_TOG_ECCN_MASK          0xF800u
#define BCH_FLASH2LAYOUT1_TOG_ECCN_SHIFT         11
#define BCH_FLASH2LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_TOG_ECCN_SHIFT))&BCH_FLASH2LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_SHIFT    16
#define BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_SHIFT))&BCH_FLASH2LAYOUT1_TOG_PAGE_SIZE_MASK)
/* FLASH3LAYOUT0 Bit Fields */
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK        0x3FFu
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT       0
#define BCH_FLASH3LAYOUT0_DATA0_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH3LAYOUT0_ECC0_MASK              0xF800u
#define BCH_FLASH3LAYOUT0_ECC0_SHIFT             11
#define BCH_FLASH3LAYOUT0_ECC0(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_ECC0_SHIFT))&BCH_FLASH3LAYOUT0_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_META_SIZE_MASK         0xFF0000u
#define BCH_FLASH3LAYOUT0_META_SIZE_SHIFT        16
#define BCH_FLASH3LAYOUT0_META_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_META_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_NBLOCKS_MASK           0xFF000000u
#define BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT          24
#define BCH_FLASH3LAYOUT0_NBLOCKS(x)             (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT))&BCH_FLASH3LAYOUT0_NBLOCKS_MASK)
/* FLASH3LAYOUT0_SET Bit Fields */
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT0_SET_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_SET_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT0_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT0_SET_ECC0_MASK          0xF800u
#define BCH_FLASH3LAYOUT0_SET_ECC0_SHIFT         11
#define BCH_FLASH3LAYOUT0_SET_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_SET_ECC0_SHIFT))&BCH_FLASH3LAYOUT0_SET_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_SET_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH3LAYOUT0_SET_META_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT0_SET_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_SET_META_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_SET_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS_SHIFT      24
#define BCH_FLASH3LAYOUT0_SET_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_SET_NBLOCKS_SHIFT))&BCH_FLASH3LAYOUT0_SET_NBLOCKS_MASK)
/* FLASH3LAYOUT0_CLR Bit Fields */
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_CLR_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT0_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT0_CLR_ECC0_MASK          0xF800u
#define BCH_FLASH3LAYOUT0_CLR_ECC0_SHIFT         11
#define BCH_FLASH3LAYOUT0_CLR_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_CLR_ECC0_SHIFT))&BCH_FLASH3LAYOUT0_CLR_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT0_CLR_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_CLR_META_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_CLR_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS_SHIFT      24
#define BCH_FLASH3LAYOUT0_CLR_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_CLR_NBLOCKS_SHIFT))&BCH_FLASH3LAYOUT0_CLR_NBLOCKS_MASK)
/* FLASH3LAYOUT0_TOG Bit Fields */
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_TOG_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT0_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT0_TOG_ECC0_MASK          0xF800u
#define BCH_FLASH3LAYOUT0_TOG_ECC0_SHIFT         11
#define BCH_FLASH3LAYOUT0_TOG_ECC0(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_TOG_ECC0_SHIFT))&BCH_FLASH3LAYOUT0_TOG_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE_MASK     0xFF0000u
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT0_TOG_META_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_TOG_META_SIZE_SHIFT))&BCH_FLASH3LAYOUT0_TOG_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS_MASK       0xFF000000u
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS_SHIFT      24
#define BCH_FLASH3LAYOUT0_TOG_NBLOCKS(x)         (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT0_TOG_NBLOCKS_SHIFT))&BCH_FLASH3LAYOUT0_TOG_NBLOCKS_MASK)
/* FLASH3LAYOUT1 Bit Fields */
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK        0x3FFu
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT       0
#define BCH_FLASH3LAYOUT1_DATAN_SIZE(x)          (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_MASK     0x400u
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_SHIFT    10
#define BCH_FLASH3LAYOUT1_ECCN_MASK              0xF800u
#define BCH_FLASH3LAYOUT1_ECCN_SHIFT             11
#define BCH_FLASH3LAYOUT1_ECCN(x)                (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_ECCN_SHIFT))&BCH_FLASH3LAYOUT1_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK         0xFFFF0000u
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT        16
#define BCH_FLASH3LAYOUT1_PAGE_SIZE(x)           (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK)
/* FLASH3LAYOUT1_SET Bit Fields */
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT1_SET_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_SET_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT1_SET_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT1_SET_ECCN_MASK          0xF800u
#define BCH_FLASH3LAYOUT1_SET_ECCN_SHIFT         11
#define BCH_FLASH3LAYOUT1_SET_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_SET_ECCN_SHIFT))&BCH_FLASH3LAYOUT1_SET_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT1_SET_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_SET_PAGE_SIZE_MASK)
/* FLASH3LAYOUT1_CLR Bit Fields */
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_CLR_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT1_CLR_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT1_CLR_ECCN_MASK          0xF800u
#define BCH_FLASH3LAYOUT1_CLR_ECCN_SHIFT         11
#define BCH_FLASH3LAYOUT1_CLR_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_CLR_ECCN_SHIFT))&BCH_FLASH3LAYOUT1_CLR_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_CLR_PAGE_SIZE_MASK)
/* FLASH3LAYOUT1_TOG Bit Fields */
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_MASK    0x3FFu
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_SHIFT   0
#define BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE(x)      (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_TOG_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_MASK 0x400u
#define BCH_FLASH3LAYOUT1_TOG_GF13_0_GF14_1_SHIFT 10
#define BCH_FLASH3LAYOUT1_TOG_ECCN_MASK          0xF800u
#define BCH_FLASH3LAYOUT1_TOG_ECCN_SHIFT         11
#define BCH_FLASH3LAYOUT1_TOG_ECCN(x)            (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_TOG_ECCN_SHIFT))&BCH_FLASH3LAYOUT1_TOG_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_MASK     0xFFFF0000u
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_SHIFT    16
#define BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE(x)       (((uint32_t)(((uint32_t)(x))<<BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_SHIFT))&BCH_FLASH3LAYOUT1_TOG_PAGE_SIZE_MASK)
/* DEBUG0 Bit Fields */
#define BCH_DEBUG0_DEBUG_REG_SELECT_MASK         0x3Fu
#define BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT        0
#define BCH_DEBUG0_DEBUG_REG_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT))&BCH_DEBUG0_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_RSVD0_MASK                    0xC0u
#define BCH_DEBUG0_RSVD0_SHIFT                   6
#define BCH_DEBUG0_RSVD0(x)                      (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_RSVD0_SHIFT))&BCH_DEBUG0_RSVD0_MASK)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_MASK       0x100u
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_SHIFT      8
#define BCH_DEBUG0_KES_DEBUG_STALL_MASK          0x200u
#define BCH_DEBUG0_KES_DEBUG_STALL_SHIFT         9
#define BCH_DEBUG0_KES_DEBUG_STEP_MASK           0x400u
#define BCH_DEBUG0_KES_DEBUG_STEP_SHIFT          10
#define BCH_DEBUG0_KES_STANDALONE_MASK           0x800u
#define BCH_DEBUG0_KES_STANDALONE_SHIFT          11
#define BCH_DEBUG0_KES_DEBUG_KICK_MASK           0x1000u
#define BCH_DEBUG0_KES_DEBUG_KICK_SHIFT          12
#define BCH_DEBUG0_KES_DEBUG_MODE4K_MASK         0x2000u
#define BCH_DEBUG0_KES_DEBUG_MODE4K_SHIFT        13
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_MASK   0x4000u
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_SHIFT  14
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_MASK     0x8000u
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_SHIFT    15
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK 0x1FF0000u
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT 16
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x)  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT))&BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_RSVD1_MASK                    0xFE000000u
#define BCH_DEBUG0_RSVD1_SHIFT                   25
#define BCH_DEBUG0_RSVD1(x)                      (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_RSVD1_SHIFT))&BCH_DEBUG0_RSVD1_MASK)
/* DEBUG0_SET Bit Fields */
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK     0x3Fu
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT    0
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT))&BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_SET_RSVD0_MASK                0xC0u
#define BCH_DEBUG0_SET_RSVD0_SHIFT               6
#define BCH_DEBUG0_SET_RSVD0(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_SET_RSVD0_SHIFT))&BCH_DEBUG0_SET_RSVD0_MASK)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_MASK   0x100u
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_SHIFT  8
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_MASK      0x200u
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_SHIFT     9
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_MASK       0x400u
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_SHIFT      10
#define BCH_DEBUG0_SET_KES_STANDALONE_MASK       0x800u
#define BCH_DEBUG0_SET_KES_STANDALONE_SHIFT      11
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_MASK       0x1000u
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_SHIFT      12
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_MASK     0x2000u
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_SHIFT    13
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_MASK 0x4000u
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_SHIFT 14
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_MASK 0x8000u
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_SHIFT 15
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK 0x1FF0000u
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT 16
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT))&BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_SET_RSVD1_MASK                0xFE000000u
#define BCH_DEBUG0_SET_RSVD1_SHIFT               25
#define BCH_DEBUG0_SET_RSVD1(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_SET_RSVD1_SHIFT))&BCH_DEBUG0_SET_RSVD1_MASK)
/* DEBUG0_CLR Bit Fields */
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK     0x3Fu
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT    0
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT))&BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_CLR_RSVD0_MASK                0xC0u
#define BCH_DEBUG0_CLR_RSVD0_SHIFT               6
#define BCH_DEBUG0_CLR_RSVD0(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_CLR_RSVD0_SHIFT))&BCH_DEBUG0_CLR_RSVD0_MASK)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_MASK   0x100u
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_SHIFT  8
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_MASK      0x200u
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_SHIFT     9
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_MASK       0x400u
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_SHIFT      10
#define BCH_DEBUG0_CLR_KES_STANDALONE_MASK       0x800u
#define BCH_DEBUG0_CLR_KES_STANDALONE_SHIFT      11
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_MASK       0x1000u
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_SHIFT      12
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_MASK     0x2000u
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_SHIFT    13
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_MASK 0x4000u
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_SHIFT 14
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_MASK 0x8000u
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_SHIFT 15
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK 0x1FF0000u
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT 16
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT))&BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_CLR_RSVD1_MASK                0xFE000000u
#define BCH_DEBUG0_CLR_RSVD1_SHIFT               25
#define BCH_DEBUG0_CLR_RSVD1(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_CLR_RSVD1_SHIFT))&BCH_DEBUG0_CLR_RSVD1_MASK)
/* DEBUG0_TOG Bit Fields */
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK     0x3Fu
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT    0
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT))&BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_TOG_RSVD0_MASK                0xC0u
#define BCH_DEBUG0_TOG_RSVD0_SHIFT               6
#define BCH_DEBUG0_TOG_RSVD0(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_TOG_RSVD0_SHIFT))&BCH_DEBUG0_TOG_RSVD0_MASK)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_MASK   0x100u
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_SHIFT  8
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_MASK      0x200u
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_SHIFT     9
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_MASK       0x400u
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_SHIFT      10
#define BCH_DEBUG0_TOG_KES_STANDALONE_MASK       0x800u
#define BCH_DEBUG0_TOG_KES_STANDALONE_SHIFT      11
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_MASK       0x1000u
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_SHIFT      12
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_MASK     0x2000u
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_SHIFT    13
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_MASK 0x4000u
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_SHIFT 14
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_MASK 0x8000u
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_SHIFT 15
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK 0x1FF0000u
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT 16
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL(x) (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT))&BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_TOG_RSVD1_MASK                0xFE000000u
#define BCH_DEBUG0_TOG_RSVD1_SHIFT               25
#define BCH_DEBUG0_TOG_RSVD1(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_DEBUG0_TOG_RSVD1_SHIFT))&BCH_DEBUG0_TOG_RSVD1_MASK)
/* DBGKESREAD Bit Fields */
#define BCH_DBGKESREAD_VALUES_MASK               0xFFFFFFFFu
#define BCH_DBGKESREAD_VALUES_SHIFT              0
#define BCH_DBGKESREAD_VALUES(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_DBGKESREAD_VALUES_SHIFT))&BCH_DBGKESREAD_VALUES_MASK)
/* DBGKESREAD_SET Bit Fields */
#define BCH_DBGKESREAD_SET_VALUES_MASK           0xFFFFFFFFu
#define BCH_DBGKESREAD_SET_VALUES_SHIFT          0
#define BCH_DBGKESREAD_SET_VALUES(x)             (((uint32_t)(((uint32_t)(x))<<BCH_DBGKESREAD_SET_VALUES_SHIFT))&BCH_DBGKESREAD_SET_VALUES_MASK)
/* DBGKESREAD_CLR Bit Fields */
#define BCH_DBGKESREAD_CLR_VALUES_MASK           0xFFFFFFFFu
#define BCH_DBGKESREAD_CLR_VALUES_SHIFT          0
#define BCH_DBGKESREAD_CLR_VALUES(x)             (((uint32_t)(((uint32_t)(x))<<BCH_DBGKESREAD_CLR_VALUES_SHIFT))&BCH_DBGKESREAD_CLR_VALUES_MASK)
/* DBGKESREAD_TOG Bit Fields */
#define BCH_DBGKESREAD_TOG_VALUES_MASK           0xFFFFFFFFu
#define BCH_DBGKESREAD_TOG_VALUES_SHIFT          0
#define BCH_DBGKESREAD_TOG_VALUES(x)             (((uint32_t)(((uint32_t)(x))<<BCH_DBGKESREAD_TOG_VALUES_SHIFT))&BCH_DBGKESREAD_TOG_VALUES_MASK)
/* DBGCSFEREAD Bit Fields */
#define BCH_DBGCSFEREAD_VALUES_MASK              0xFFFFFFFFu
#define BCH_DBGCSFEREAD_VALUES_SHIFT             0
#define BCH_DBGCSFEREAD_VALUES(x)                (((uint32_t)(((uint32_t)(x))<<BCH_DBGCSFEREAD_VALUES_SHIFT))&BCH_DBGCSFEREAD_VALUES_MASK)
/* DBGCSFEREAD_SET Bit Fields */
#define BCH_DBGCSFEREAD_SET_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGCSFEREAD_SET_VALUES_SHIFT         0
#define BCH_DBGCSFEREAD_SET_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGCSFEREAD_SET_VALUES_SHIFT))&BCH_DBGCSFEREAD_SET_VALUES_MASK)
/* DBGCSFEREAD_CLR Bit Fields */
#define BCH_DBGCSFEREAD_CLR_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGCSFEREAD_CLR_VALUES_SHIFT         0
#define BCH_DBGCSFEREAD_CLR_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGCSFEREAD_CLR_VALUES_SHIFT))&BCH_DBGCSFEREAD_CLR_VALUES_MASK)
/* DBGCSFEREAD_TOG Bit Fields */
#define BCH_DBGCSFEREAD_TOG_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGCSFEREAD_TOG_VALUES_SHIFT         0
#define BCH_DBGCSFEREAD_TOG_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGCSFEREAD_TOG_VALUES_SHIFT))&BCH_DBGCSFEREAD_TOG_VALUES_MASK)
/* DBGSYNDGENREAD Bit Fields */
#define BCH_DBGSYNDGENREAD_VALUES_MASK           0xFFFFFFFFu
#define BCH_DBGSYNDGENREAD_VALUES_SHIFT          0
#define BCH_DBGSYNDGENREAD_VALUES(x)             (((uint32_t)(((uint32_t)(x))<<BCH_DBGSYNDGENREAD_VALUES_SHIFT))&BCH_DBGSYNDGENREAD_VALUES_MASK)
/* DBGSYNDGENREAD_SET Bit Fields */
#define BCH_DBGSYNDGENREAD_SET_VALUES_MASK       0xFFFFFFFFu
#define BCH_DBGSYNDGENREAD_SET_VALUES_SHIFT      0
#define BCH_DBGSYNDGENREAD_SET_VALUES(x)         (((uint32_t)(((uint32_t)(x))<<BCH_DBGSYNDGENREAD_SET_VALUES_SHIFT))&BCH_DBGSYNDGENREAD_SET_VALUES_MASK)
/* DBGSYNDGENREAD_CLR Bit Fields */
#define BCH_DBGSYNDGENREAD_CLR_VALUES_MASK       0xFFFFFFFFu
#define BCH_DBGSYNDGENREAD_CLR_VALUES_SHIFT      0
#define BCH_DBGSYNDGENREAD_CLR_VALUES(x)         (((uint32_t)(((uint32_t)(x))<<BCH_DBGSYNDGENREAD_CLR_VALUES_SHIFT))&BCH_DBGSYNDGENREAD_CLR_VALUES_MASK)
/* DBGSYNDGENREAD_TOG Bit Fields */
#define BCH_DBGSYNDGENREAD_TOG_VALUES_MASK       0xFFFFFFFFu
#define BCH_DBGSYNDGENREAD_TOG_VALUES_SHIFT      0
#define BCH_DBGSYNDGENREAD_TOG_VALUES(x)         (((uint32_t)(((uint32_t)(x))<<BCH_DBGSYNDGENREAD_TOG_VALUES_SHIFT))&BCH_DBGSYNDGENREAD_TOG_VALUES_MASK)
/* DBGAHBMREAD Bit Fields */
#define BCH_DBGAHBMREAD_VALUES_MASK              0xFFFFFFFFu
#define BCH_DBGAHBMREAD_VALUES_SHIFT             0
#define BCH_DBGAHBMREAD_VALUES(x)                (((uint32_t)(((uint32_t)(x))<<BCH_DBGAHBMREAD_VALUES_SHIFT))&BCH_DBGAHBMREAD_VALUES_MASK)
/* DBGAHBMREAD_SET Bit Fields */
#define BCH_DBGAHBMREAD_SET_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGAHBMREAD_SET_VALUES_SHIFT         0
#define BCH_DBGAHBMREAD_SET_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGAHBMREAD_SET_VALUES_SHIFT))&BCH_DBGAHBMREAD_SET_VALUES_MASK)
/* DBGAHBMREAD_CLR Bit Fields */
#define BCH_DBGAHBMREAD_CLR_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGAHBMREAD_CLR_VALUES_SHIFT         0
#define BCH_DBGAHBMREAD_CLR_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGAHBMREAD_CLR_VALUES_SHIFT))&BCH_DBGAHBMREAD_CLR_VALUES_MASK)
/* DBGAHBMREAD_TOG Bit Fields */
#define BCH_DBGAHBMREAD_TOG_VALUES_MASK          0xFFFFFFFFu
#define BCH_DBGAHBMREAD_TOG_VALUES_SHIFT         0
#define BCH_DBGAHBMREAD_TOG_VALUES(x)            (((uint32_t)(((uint32_t)(x))<<BCH_DBGAHBMREAD_TOG_VALUES_SHIFT))&BCH_DBGAHBMREAD_TOG_VALUES_MASK)
/* BLOCKNAME Bit Fields */
#define BCH_BLOCKNAME_NAME_MASK                  0xFFFFFFFFu
#define BCH_BLOCKNAME_NAME_SHIFT                 0
#define BCH_BLOCKNAME_NAME(x)                    (((uint32_t)(((uint32_t)(x))<<BCH_BLOCKNAME_NAME_SHIFT))&BCH_BLOCKNAME_NAME_MASK)
/* BLOCKNAME_SET Bit Fields */
#define BCH_BLOCKNAME_SET_NAME_MASK              0xFFFFFFFFu
#define BCH_BLOCKNAME_SET_NAME_SHIFT             0
#define BCH_BLOCKNAME_SET_NAME(x)                (((uint32_t)(((uint32_t)(x))<<BCH_BLOCKNAME_SET_NAME_SHIFT))&BCH_BLOCKNAME_SET_NAME_MASK)
/* BLOCKNAME_CLR Bit Fields */
#define BCH_BLOCKNAME_CLR_NAME_MASK              0xFFFFFFFFu
#define BCH_BLOCKNAME_CLR_NAME_SHIFT             0
#define BCH_BLOCKNAME_CLR_NAME(x)                (((uint32_t)(((uint32_t)(x))<<BCH_BLOCKNAME_CLR_NAME_SHIFT))&BCH_BLOCKNAME_CLR_NAME_MASK)
/* BLOCKNAME_TOG Bit Fields */
#define BCH_BLOCKNAME_TOG_NAME_MASK              0xFFFFFFFFu
#define BCH_BLOCKNAME_TOG_NAME_SHIFT             0
#define BCH_BLOCKNAME_TOG_NAME(x)                (((uint32_t)(((uint32_t)(x))<<BCH_BLOCKNAME_TOG_NAME_SHIFT))&BCH_BLOCKNAME_TOG_NAME_MASK)
/* VERSION Bit Fields */
#define BCH_VERSION_STEP_MASK                    0xFFFFu
#define BCH_VERSION_STEP_SHIFT                   0
#define BCH_VERSION_STEP(x)                      (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_STEP_SHIFT))&BCH_VERSION_STEP_MASK)
#define BCH_VERSION_MINOR_MASK                   0xFF0000u
#define BCH_VERSION_MINOR_SHIFT                  16
#define BCH_VERSION_MINOR(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_MINOR_SHIFT))&BCH_VERSION_MINOR_MASK)
#define BCH_VERSION_MAJOR_MASK                   0xFF000000u
#define BCH_VERSION_MAJOR_SHIFT                  24
#define BCH_VERSION_MAJOR(x)                     (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_MAJOR_SHIFT))&BCH_VERSION_MAJOR_MASK)
/* VERSION_SET Bit Fields */
#define BCH_VERSION_SET_STEP_MASK                0xFFFFu
#define BCH_VERSION_SET_STEP_SHIFT               0
#define BCH_VERSION_SET_STEP(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_SET_STEP_SHIFT))&BCH_VERSION_SET_STEP_MASK)
#define BCH_VERSION_SET_MINOR_MASK               0xFF0000u
#define BCH_VERSION_SET_MINOR_SHIFT              16
#define BCH_VERSION_SET_MINOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_SET_MINOR_SHIFT))&BCH_VERSION_SET_MINOR_MASK)
#define BCH_VERSION_SET_MAJOR_MASK               0xFF000000u
#define BCH_VERSION_SET_MAJOR_SHIFT              24
#define BCH_VERSION_SET_MAJOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_SET_MAJOR_SHIFT))&BCH_VERSION_SET_MAJOR_MASK)
/* VERSION_CLR Bit Fields */
#define BCH_VERSION_CLR_STEP_MASK                0xFFFFu
#define BCH_VERSION_CLR_STEP_SHIFT               0
#define BCH_VERSION_CLR_STEP(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_CLR_STEP_SHIFT))&BCH_VERSION_CLR_STEP_MASK)
#define BCH_VERSION_CLR_MINOR_MASK               0xFF0000u
#define BCH_VERSION_CLR_MINOR_SHIFT              16
#define BCH_VERSION_CLR_MINOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_CLR_MINOR_SHIFT))&BCH_VERSION_CLR_MINOR_MASK)
#define BCH_VERSION_CLR_MAJOR_MASK               0xFF000000u
#define BCH_VERSION_CLR_MAJOR_SHIFT              24
#define BCH_VERSION_CLR_MAJOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_CLR_MAJOR_SHIFT))&BCH_VERSION_CLR_MAJOR_MASK)
/* VERSION_TOG Bit Fields */
#define BCH_VERSION_TOG_STEP_MASK                0xFFFFu
#define BCH_VERSION_TOG_STEP_SHIFT               0
#define BCH_VERSION_TOG_STEP(x)                  (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_TOG_STEP_SHIFT))&BCH_VERSION_TOG_STEP_MASK)
#define BCH_VERSION_TOG_MINOR_MASK               0xFF0000u
#define BCH_VERSION_TOG_MINOR_SHIFT              16
#define BCH_VERSION_TOG_MINOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_TOG_MINOR_SHIFT))&BCH_VERSION_TOG_MINOR_MASK)
#define BCH_VERSION_TOG_MAJOR_MASK               0xFF000000u
#define BCH_VERSION_TOG_MAJOR_SHIFT              24
#define BCH_VERSION_TOG_MAJOR(x)                 (((uint32_t)(((uint32_t)(x))<<BCH_VERSION_TOG_MAJOR_SHIFT))&BCH_VERSION_TOG_MAJOR_MASK)

/*!
 * @}
 */ /* end of group BCH_Register_Masks */


/* BCH - Peripheral instance base addresses */
/** Peripheral BCH base pointer */
#define BCH_BASE_PTR                             ((BCH_MemMapPtr)0x41808000u)
/** Array initializer of BCH peripheral base pointers */
#define BCH_BASE_PTRS                            { BCH_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- BCH - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Register_Accessor_Macros BCH - Register accessor macros
 * @{
 */


/* BCH - Register instance definitions */
/* BCH */
#define BCH_CTRL                                 BCH_CTRL_REG(BCH_BASE_PTR)
#define BCH_CTRL_SET                             BCH_CTRL_SET_REG(BCH_BASE_PTR)
#define BCH_CTRL_CLR                             BCH_CTRL_CLR_REG(BCH_BASE_PTR)
#define BCH_CTRL_TOG                             BCH_CTRL_TOG_REG(BCH_BASE_PTR)
#define BCH_STATUS0                              BCH_STATUS0_REG(BCH_BASE_PTR)
#define BCH_STATUS0_SET                          BCH_STATUS0_SET_REG(BCH_BASE_PTR)
#define BCH_STATUS0_CLR                          BCH_STATUS0_CLR_REG(BCH_BASE_PTR)
#define BCH_STATUS0_TOG                          BCH_STATUS0_TOG_REG(BCH_BASE_PTR)
#define BCH_MODE                                 BCH_MODE_REG(BCH_BASE_PTR)
#define BCH_MODE_SET                             BCH_MODE_SET_REG(BCH_BASE_PTR)
#define BCH_MODE_CLR                             BCH_MODE_CLR_REG(BCH_BASE_PTR)
#define BCH_MODE_TOG                             BCH_MODE_TOG_REG(BCH_BASE_PTR)
#define BCH_ENCODEPTR                            BCH_ENCODEPTR_REG(BCH_BASE_PTR)
#define BCH_ENCODEPTR_SET                        BCH_ENCODEPTR_SET_REG(BCH_BASE_PTR)
#define BCH_ENCODEPTR_CLR                        BCH_ENCODEPTR_CLR_REG(BCH_BASE_PTR)
#define BCH_ENCODEPTR_TOG                        BCH_ENCODEPTR_TOG_REG(BCH_BASE_PTR)
#define BCH_DATAPTR                              BCH_DATAPTR_REG(BCH_BASE_PTR)
#define BCH_DATAPTR_SET                          BCH_DATAPTR_SET_REG(BCH_BASE_PTR)
#define BCH_DATAPTR_CLR                          BCH_DATAPTR_CLR_REG(BCH_BASE_PTR)
#define BCH_DATAPTR_TOG                          BCH_DATAPTR_TOG_REG(BCH_BASE_PTR)
#define BCH_METAPTR                              BCH_METAPTR_REG(BCH_BASE_PTR)
#define BCH_METAPTR_SET                          BCH_METAPTR_SET_REG(BCH_BASE_PTR)
#define BCH_METAPTR_CLR                          BCH_METAPTR_CLR_REG(BCH_BASE_PTR)
#define BCH_METAPTR_TOG                          BCH_METAPTR_TOG_REG(BCH_BASE_PTR)
#define BCH_LAYOUTSELECT                         BCH_LAYOUTSELECT_REG(BCH_BASE_PTR)
#define BCH_LAYOUTSELECT_SET                     BCH_LAYOUTSELECT_SET_REG(BCH_BASE_PTR)
#define BCH_LAYOUTSELECT_CLR                     BCH_LAYOUTSELECT_CLR_REG(BCH_BASE_PTR)
#define BCH_LAYOUTSELECT_TOG                     BCH_LAYOUTSELECT_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT0                        BCH_FLASH0LAYOUT0_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT0_SET                    BCH_FLASH0LAYOUT0_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT0_CLR                    BCH_FLASH0LAYOUT0_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT0_TOG                    BCH_FLASH0LAYOUT0_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT1                        BCH_FLASH0LAYOUT1_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT1_SET                    BCH_FLASH0LAYOUT1_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT1_CLR                    BCH_FLASH0LAYOUT1_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH0LAYOUT1_TOG                    BCH_FLASH0LAYOUT1_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT0                        BCH_FLASH1LAYOUT0_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT0_SET                    BCH_FLASH1LAYOUT0_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT0_CLR                    BCH_FLASH1LAYOUT0_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT0_TOG                    BCH_FLASH1LAYOUT0_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT1                        BCH_FLASH1LAYOUT1_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT1_SET                    BCH_FLASH1LAYOUT1_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT1_CLR                    BCH_FLASH1LAYOUT1_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH1LAYOUT1_TOG                    BCH_FLASH1LAYOUT1_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT0                        BCH_FLASH2LAYOUT0_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT0_SET                    BCH_FLASH2LAYOUT0_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT0_CLR                    BCH_FLASH2LAYOUT0_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT0_TOG                    BCH_FLASH2LAYOUT0_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT1                        BCH_FLASH2LAYOUT1_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT1_SET                    BCH_FLASH2LAYOUT1_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT1_CLR                    BCH_FLASH2LAYOUT1_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH2LAYOUT1_TOG                    BCH_FLASH2LAYOUT1_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT0                        BCH_FLASH3LAYOUT0_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT0_SET                    BCH_FLASH3LAYOUT0_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT0_CLR                    BCH_FLASH3LAYOUT0_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT0_TOG                    BCH_FLASH3LAYOUT0_TOG_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT1                        BCH_FLASH3LAYOUT1_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT1_SET                    BCH_FLASH3LAYOUT1_SET_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT1_CLR                    BCH_FLASH3LAYOUT1_CLR_REG(BCH_BASE_PTR)
#define BCH_FLASH3LAYOUT1_TOG                    BCH_FLASH3LAYOUT1_TOG_REG(BCH_BASE_PTR)
#define BCH_DEBUG0                               BCH_DEBUG0_REG(BCH_BASE_PTR)
#define BCH_DEBUG0_SET                           BCH_DEBUG0_SET_REG(BCH_BASE_PTR)
#define BCH_DEBUG0_CLR                           BCH_DEBUG0_CLR_REG(BCH_BASE_PTR)
#define BCH_DEBUG0_TOG                           BCH_DEBUG0_TOG_REG(BCH_BASE_PTR)
#define BCH_DBGKESREAD                           BCH_DBGKESREAD_REG(BCH_BASE_PTR)
#define BCH_DBGKESREAD_SET                       BCH_DBGKESREAD_SET_REG(BCH_BASE_PTR)
#define BCH_DBGKESREAD_CLR                       BCH_DBGKESREAD_CLR_REG(BCH_BASE_PTR)
#define BCH_DBGKESREAD_TOG                       BCH_DBGKESREAD_TOG_REG(BCH_BASE_PTR)
#define BCH_DBGCSFEREAD                          BCH_DBGCSFEREAD_REG(BCH_BASE_PTR)
#define BCH_DBGCSFEREAD_SET                      BCH_DBGCSFEREAD_SET_REG(BCH_BASE_PTR)
#define BCH_DBGCSFEREAD_CLR                      BCH_DBGCSFEREAD_CLR_REG(BCH_BASE_PTR)
#define BCH_DBGCSFEREAD_TOG                      BCH_DBGCSFEREAD_TOG_REG(BCH_BASE_PTR)
#define BCH_DBGSYNDGENREAD                       BCH_DBGSYNDGENREAD_REG(BCH_BASE_PTR)
#define BCH_DBGSYNDGENREAD_SET                   BCH_DBGSYNDGENREAD_SET_REG(BCH_BASE_PTR)
#define BCH_DBGSYNDGENREAD_CLR                   BCH_DBGSYNDGENREAD_CLR_REG(BCH_BASE_PTR)
#define BCH_DBGSYNDGENREAD_TOG                   BCH_DBGSYNDGENREAD_TOG_REG(BCH_BASE_PTR)
#define BCH_DBGAHBMREAD                          BCH_DBGAHBMREAD_REG(BCH_BASE_PTR)
#define BCH_DBGAHBMREAD_SET                      BCH_DBGAHBMREAD_SET_REG(BCH_BASE_PTR)
#define BCH_DBGAHBMREAD_CLR                      BCH_DBGAHBMREAD_CLR_REG(BCH_BASE_PTR)
#define BCH_DBGAHBMREAD_TOG                      BCH_DBGAHBMREAD_TOG_REG(BCH_BASE_PTR)
#define BCH_BLOCKNAME                            BCH_BLOCKNAME_REG(BCH_BASE_PTR)
#define BCH_BLOCKNAME_SET                        BCH_BLOCKNAME_SET_REG(BCH_BASE_PTR)
#define BCH_BLOCKNAME_CLR                        BCH_BLOCKNAME_CLR_REG(BCH_BASE_PTR)
#define BCH_BLOCKNAME_TOG                        BCH_BLOCKNAME_TOG_REG(BCH_BASE_PTR)
#define BCH_VERSION                              BCH_VERSION_REG(BCH_BASE_PTR)
#define BCH_VERSION_SET                          BCH_VERSION_SET_REG(BCH_BASE_PTR)
#define BCH_VERSION_CLR                          BCH_VERSION_CLR_REG(BCH_BASE_PTR)
#define BCH_VERSION_TOG                          BCH_VERSION_TOG_REG(BCH_BASE_PTR)

/*!
 * @}
 */ /* end of group BCH_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group BCH_Peripheral */


/* ----------------------------------------------------------------------------
   -- CAN
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral CAN
 * @{
 */

/** CAN - Peripheral register structure */
typedef struct CAN_MemMap {
  uint32_t MCR;                                    /**< Module Configuration Register, offset: 0x0 */
  uint32_t CTRL1;                                  /**< Control 1 Register, offset: 0x4 */
  uint32_t TIMER;                                  /**< Free Running Timer Register, offset: 0x8 */
  uint8_t RESERVED_0[4];
  uint32_t RXMGMASK;                               /**< Rx Mailboxes Global Mask Register, offset: 0x10 */
  uint32_t RX14MASK;                               /**< Rx Buffer 14 Mask Register, offset: 0x14 */
  uint32_t RX15MASK;                               /**< Rx Buffer 15 Mask Register, offset: 0x18 */
  uint32_t ECR;                                    /**< Error Counter Register, offset: 0x1C */
  uint32_t ESR1;                                   /**< Error and Status 1 Register, offset: 0x20 */
  uint32_t IMASK2;                                 /**< Interrupt Masks 2 Register, offset: 0x24 */
  uint32_t IMASK1;                                 /**< Interrupt Masks 1 Register, offset: 0x28 */
  uint32_t IFLAG2;                                 /**< Interrupt Flags 2 Register, offset: 0x2C */
  uint32_t IFLAG1;                                 /**< Interrupt Flags 1 Register, offset: 0x30 */
  uint32_t CTRL2;                                  /**< Control 2 Register, offset: 0x34 */
  uint32_t ESR2;                                   /**< Error and Status 2 Register, offset: 0x38 */
  uint8_t RESERVED_1[8];
  uint32_t CRCR;                                   /**< CRC Register, offset: 0x44 */
  uint32_t RXFGMASK;                               /**< Rx FIFO Global Mask Register, offset: 0x48 */
  uint32_t RXFIR;                                  /**< Rx FIFO Information Register, offset: 0x4C */
  uint8_t RESERVED_2[48];
  struct {                                         /* offset: 0x80, array step: 0x10 */
    uint32_t CS;                                     /**< Message Buffer 0 CS Register..Message Buffer 63 CS Register, array offset: 0x80, array step: 0x10 */
    uint32_t ID;                                     /**< Message Buffer 0 ID Register..Message Buffer 63 ID Register, array offset: 0x84, array step: 0x10 */
    uint32_t WORD0;                                  /**< Message Buffer 0 WORD0 Register..Message Buffer 63 WORD0 Register, array offset: 0x88, array step: 0x10 */
    uint32_t WORD1;                                  /**< Message Buffer 0 WORD1 Register..Message Buffer 63 WORD1 Register, array offset: 0x8C, array step: 0x10 */
  } MB[64];
  uint8_t RESERVED_3[1024];
  uint32_t RXIMR[64];                              /**< RXIMR, array offset: 0x880, array step: 0x4 */
  uint8_t RESERVED_4[96];
  uint32_t GFWR;                                   /**< Glitch Filter Width Registers, offset: 0x9E0 */
} volatile *CAN_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CAN - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Accessor_Macros CAN - Register accessor macros
 * @{
 */


/* CAN - Register accessors */
#define CAN_MCR_REG(base)                        ((base)->MCR)
#define CAN_CTRL1_REG(base)                      ((base)->CTRL1)
#define CAN_TIMER_REG(base)                      ((base)->TIMER)
#define CAN_RXMGMASK_REG(base)                   ((base)->RXMGMASK)
#define CAN_RX14MASK_REG(base)                   ((base)->RX14MASK)
#define CAN_RX15MASK_REG(base)                   ((base)->RX15MASK)
#define CAN_ECR_REG(base)                        ((base)->ECR)
#define CAN_ESR1_REG(base)                       ((base)->ESR1)
#define CAN_IMASK2_REG(base)                     ((base)->IMASK2)
#define CAN_IMASK1_REG(base)                     ((base)->IMASK1)
#define CAN_IFLAG2_REG(base)                     ((base)->IFLAG2)
#define CAN_IFLAG1_REG(base)                     ((base)->IFLAG1)
#define CAN_CTRL2_REG(base)                      ((base)->CTRL2)
#define CAN_ESR2_REG(base)                       ((base)->ESR2)
#define CAN_CRCR_REG(base)                       ((base)->CRCR)
#define CAN_RXFGMASK_REG(base)                   ((base)->RXFGMASK)
#define CAN_RXFIR_REG(base)                      ((base)->RXFIR)
#define CAN_CS_REG(base,index)                   ((base)->MB[index].CS)
#define CAN_ID_REG(base,index)                   ((base)->MB[index].ID)
#define CAN_WORD0_REG(base,index)                ((base)->MB[index].WORD0)
#define CAN_WORD1_REG(base,index)                ((base)->MB[index].WORD1)
#define CAN_RXIMR_REG(base,index)                ((base)->RXIMR[index])
#define CAN_GFWR_REG(base)                       ((base)->GFWR)

/*!
 * @}
 */ /* end of group CAN_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/* MCR Bit Fields */
#define CAN_MCR_MAXMB_MASK                       0x7Fu
#define CAN_MCR_MAXMB_SHIFT                      0
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_MCR_MAXMB_SHIFT))&CAN_MCR_MAXMB_MASK)
#define CAN_MCR_IDAM_MASK                        0x300u
#define CAN_MCR_IDAM_SHIFT                       8
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_MCR_IDAM_SHIFT))&CAN_MCR_IDAM_MASK)
#define CAN_MCR_AEN_MASK                         0x1000u
#define CAN_MCR_AEN_SHIFT                        12
#define CAN_MCR_LPRIO_EN_MASK                    0x2000u
#define CAN_MCR_LPRIO_EN_SHIFT                   13
#define CAN_MCR_IRMQ_MASK                        0x10000u
#define CAN_MCR_IRMQ_SHIFT                       16
#define CAN_MCR_SRX_DIS_MASK                     0x20000u
#define CAN_MCR_SRX_DIS_SHIFT                    17
#define CAN_MCR_WAK_SRC_MASK                     0x80000u
#define CAN_MCR_WAK_SRC_SHIFT                    19
#define CAN_MCR_LPM_ACK_MASK                     0x100000u
#define CAN_MCR_LPM_ACK_SHIFT                    20
#define CAN_MCR_WRN_EN_MASK                      0x200000u
#define CAN_MCR_WRN_EN_SHIFT                     21
#define CAN_MCR_SLF_WAK_MASK                     0x400000u
#define CAN_MCR_SLF_WAK_SHIFT                    22
#define CAN_MCR_SUPV_MASK                        0x800000u
#define CAN_MCR_SUPV_SHIFT                       23
#define CAN_MCR_FRZ_ACK_MASK                     0x1000000u
#define CAN_MCR_FRZ_ACK_SHIFT                    24
#define CAN_MCR_SOFT_RST_MASK                    0x2000000u
#define CAN_MCR_SOFT_RST_SHIFT                   25
#define CAN_MCR_WAK_MSK_MASK                     0x4000000u
#define CAN_MCR_WAK_MSK_SHIFT                    26
#define CAN_MCR_NOT_RDY_MASK                     0x8000000u
#define CAN_MCR_NOT_RDY_SHIFT                    27
#define CAN_MCR_HALT_MASK                        0x10000000u
#define CAN_MCR_HALT_SHIFT                       28
#define CAN_MCR_RFEN_MASK                        0x20000000u
#define CAN_MCR_RFEN_SHIFT                       29
#define CAN_MCR_FRZ_MASK                         0x40000000u
#define CAN_MCR_FRZ_SHIFT                        30
#define CAN_MCR_MDIS_MASK                        0x80000000u
#define CAN_MCR_MDIS_SHIFT                       31
/* CTRL1 Bit Fields */
#define CAN_CTRL1_PROP_SEG_MASK                  0x7u
#define CAN_CTRL1_PROP_SEG_SHIFT                 0
#define CAN_CTRL1_PROP_SEG(x)                    (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PROP_SEG_SHIFT))&CAN_CTRL1_PROP_SEG_MASK)
#define CAN_CTRL1_LOM_MASK                       0x8u
#define CAN_CTRL1_LOM_SHIFT                      3
#define CAN_CTRL1_LBUF_MASK                      0x10u
#define CAN_CTRL1_LBUF_SHIFT                     4
#define CAN_CTRL1_TSYN_MASK                      0x20u
#define CAN_CTRL1_TSYN_SHIFT                     5
#define CAN_CTRL1_BOFF_REC_MASK                  0x40u
#define CAN_CTRL1_BOFF_REC_SHIFT                 6
#define CAN_CTRL1_SMP_MASK                       0x80u
#define CAN_CTRL1_SMP_SHIFT                      7
#define CAN_CTRL1_RWRN_MSK_MASK                  0x400u
#define CAN_CTRL1_RWRN_MSK_SHIFT                 10
#define CAN_CTRL1_TWRN_MSK_MASK                  0x800u
#define CAN_CTRL1_TWRN_MSK_SHIFT                 11
#define CAN_CTRL1_LPB_MASK                       0x1000u
#define CAN_CTRL1_LPB_SHIFT                      12
#define CAN_CTRL1_ERR_MSK_MASK                   0x4000u
#define CAN_CTRL1_ERR_MSK_SHIFT                  14
#define CAN_CTRL1_BOFF_MSK_MASK                  0x8000u
#define CAN_CTRL1_BOFF_MSK_SHIFT                 15
#define CAN_CTRL1_PSEG2_MASK                     0x70000u
#define CAN_CTRL1_PSEG2_SHIFT                    16
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PSEG2_SHIFT))&CAN_CTRL1_PSEG2_MASK)
#define CAN_CTRL1_PSEG1_MASK                     0x380000u
#define CAN_CTRL1_PSEG1_SHIFT                    19
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PSEG1_SHIFT))&CAN_CTRL1_PSEG1_MASK)
#define CAN_CTRL1_RJW_MASK                       0xC00000u
#define CAN_CTRL1_RJW_SHIFT                      22
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_RJW_SHIFT))&CAN_CTRL1_RJW_MASK)
#define CAN_CTRL1_PRESDIV_MASK                   0xFF000000u
#define CAN_CTRL1_PRESDIV_SHIFT                  24
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CTRL1_PRESDIV_SHIFT))&CAN_CTRL1_PRESDIV_MASK)
/* TIMER Bit Fields */
#define CAN_TIMER_TIMER_MASK                     0xFFFFu
#define CAN_TIMER_TIMER_SHIFT                    0
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_TIMER_TIMER_SHIFT))&CAN_TIMER_TIMER_MASK)
/* RXMGMASK Bit Fields */
#define CAN_RXMGMASK_MG31_MG0_MASK               0xFFFFFFFFu
#define CAN_RXMGMASK_MG31_MG0_SHIFT              0
#define CAN_RXMGMASK_MG31_MG0(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_RXMGMASK_MG31_MG0_SHIFT))&CAN_RXMGMASK_MG31_MG0_MASK)
/* RX14MASK Bit Fields */
#define CAN_RX14MASK_RX14M31_RX14M0_MASK         0xFFFFFFFFu
#define CAN_RX14MASK_RX14M31_RX14M0_SHIFT        0
#define CAN_RX14MASK_RX14M31_RX14M0(x)           (((uint32_t)(((uint32_t)(x))<<CAN_RX14MASK_RX14M31_RX14M0_SHIFT))&CAN_RX14MASK_RX14M31_RX14M0_MASK)
/* RX15MASK Bit Fields */
#define CAN_RX15MASK_RX15M31_RX15M0_MASK         0xFFFFFFFFu
#define CAN_RX15MASK_RX15M31_RX15M0_SHIFT        0
#define CAN_RX15MASK_RX15M31_RX15M0(x)           (((uint32_t)(((uint32_t)(x))<<CAN_RX15MASK_RX15M31_RX15M0_SHIFT))&CAN_RX15MASK_RX15M31_RX15M0_MASK)
/* ECR Bit Fields */
#define CAN_ECR_Tx_Err_Counter_MASK              0xFFu
#define CAN_ECR_Tx_Err_Counter_SHIFT             0
#define CAN_ECR_Tx_Err_Counter(x)                (((uint32_t)(((uint32_t)(x))<<CAN_ECR_Tx_Err_Counter_SHIFT))&CAN_ECR_Tx_Err_Counter_MASK)
#define CAN_ECR_Rx_Err_Counter_MASK              0xFF00u
#define CAN_ECR_Rx_Err_Counter_SHIFT             8
#define CAN_ECR_Rx_Err_Counter(x)                (((uint32_t)(((uint32_t)(x))<<CAN_ECR_Rx_Err_Counter_SHIFT))&CAN_ECR_Rx_Err_Counter_MASK)
/* ESR1 Bit Fields */
#define CAN_ESR1_WAK_INT_MASK                    0x1u
#define CAN_ESR1_WAK_INT_SHIFT                   0
#define CAN_ESR1_ERR_INT_MASK                    0x2u
#define CAN_ESR1_ERR_INT_SHIFT                   1
#define CAN_ESR1_BOFF_INT_MASK                   0x4u
#define CAN_ESR1_BOFF_INT_SHIFT                  2
#define CAN_ESR1_RX_MASK                         0x8u
#define CAN_ESR1_RX_SHIFT                        3
#define CAN_ESR1_FLT_CONF_MASK                   0x30u
#define CAN_ESR1_FLT_CONF_SHIFT                  4
#define CAN_ESR1_FLT_CONF(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_ESR1_FLT_CONF_SHIFT))&CAN_ESR1_FLT_CONF_MASK)
#define CAN_ESR1_TX_MASK                         0x40u
#define CAN_ESR1_TX_SHIFT                        6
#define CAN_ESR1_IDLE_MASK                       0x80u
#define CAN_ESR1_IDLE_SHIFT                      7
#define CAN_ESR1_RX_WRN_MASK                     0x100u
#define CAN_ESR1_RX_WRN_SHIFT                    8
#define CAN_ESR1_TX_WRN_MASK                     0x200u
#define CAN_ESR1_TX_WRN_SHIFT                    9
#define CAN_ESR1_STF_ERR_MASK                    0x400u
#define CAN_ESR1_STF_ERR_SHIFT                   10
#define CAN_ESR1_FRM_ERR_MASK                    0x800u
#define CAN_ESR1_FRM_ERR_SHIFT                   11
#define CAN_ESR1_CRC_ERR_MASK                    0x1000u
#define CAN_ESR1_CRC_ERR_SHIFT                   12
#define CAN_ESR1_ACK_ERR_MASK                    0x2000u
#define CAN_ESR1_ACK_ERR_SHIFT                   13
#define CAN_ESR1_BIT0_ERR_MASK                   0x4000u
#define CAN_ESR1_BIT0_ERR_SHIFT                  14
#define CAN_ESR1_BIT1_ERR_MASK                   0x8000u
#define CAN_ESR1_BIT1_ERR_SHIFT                  15
#define CAN_ESR1_RWRN_INT_MASK                   0x10000u
#define CAN_ESR1_RWRN_INT_SHIFT                  16
#define CAN_ESR1_TWRN_INT_MASK                   0x20000u
#define CAN_ESR1_TWRN_INT_SHIFT                  17
#define CAN_ESR1_SYNCH_MASK                      0x40000u
#define CAN_ESR1_SYNCH_SHIFT                     18
/* IMASK2 Bit Fields */
#define CAN_IMASK2_BUF63M_BUF32M_MASK            0xFFFFFFFFu
#define CAN_IMASK2_BUF63M_BUF32M_SHIFT           0
#define CAN_IMASK2_BUF63M_BUF32M(x)              (((uint32_t)(((uint32_t)(x))<<CAN_IMASK2_BUF63M_BUF32M_SHIFT))&CAN_IMASK2_BUF63M_BUF32M_MASK)
/* IMASK1 Bit Fields */
#define CAN_IMASK1_BUF31M_BUF0M_MASK             0xFFFFFFFFu
#define CAN_IMASK1_BUF31M_BUF0M_SHIFT            0
#define CAN_IMASK1_BUF31M_BUF0M(x)               (((uint32_t)(((uint32_t)(x))<<CAN_IMASK1_BUF31M_BUF0M_SHIFT))&CAN_IMASK1_BUF31M_BUF0M_MASK)
/* IFLAG2 Bit Fields */
#define CAN_IFLAG2_BUF63I_BUF32I_MASK            0xFFFFFFFFu
#define CAN_IFLAG2_BUF63I_BUF32I_SHIFT           0
#define CAN_IFLAG2_BUF63I_BUF32I(x)              (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG2_BUF63I_BUF32I_SHIFT))&CAN_IFLAG2_BUF63I_BUF32I_MASK)
/* IFLAG1 Bit Fields */
#define CAN_IFLAG1_BUF4I_BUF0I_MASK              0x1Fu
#define CAN_IFLAG1_BUF4I_BUF0I_SHIFT             0
#define CAN_IFLAG1_BUF4I_BUF0I(x)                (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF4I_BUF0I_SHIFT))&CAN_IFLAG1_BUF4I_BUF0I_MASK)
#define CAN_IFLAG1_BUF5I_MASK                    0x20u
#define CAN_IFLAG1_BUF5I_SHIFT                   5
#define CAN_IFLAG1_BUF6I_MASK                    0x40u
#define CAN_IFLAG1_BUF6I_SHIFT                   6
#define CAN_IFLAG1_BUF7I_MASK                    0x80u
#define CAN_IFLAG1_BUF7I_SHIFT                   7
#define CAN_IFLAG1_BUF31I_BUF8I_MASK             0xFFFFFF00u
#define CAN_IFLAG1_BUF31I_BUF8I_SHIFT            8
#define CAN_IFLAG1_BUF31I_BUF8I(x)               (((uint32_t)(((uint32_t)(x))<<CAN_IFLAG1_BUF31I_BUF8I_SHIFT))&CAN_IFLAG1_BUF31I_BUF8I_MASK)
/* CTRL2 Bit Fields */
#define CAN_CTRL2_EACEN_MASK                     0x10000u
#define CAN_CTRL2_EACEN_SHIFT                    16
#define CAN_CTRL2_RRS_MASK                       0x20000u
#define CAN_CTRL2_RRS_SHIFT                      17
#define CAN_CTRL2_MRP_MASK                       0x40000u
#define CAN_CTRL2_MRP_SHIFT                      18
#define CAN_CTRL2_TASD_MASK                      0xF80000u
#define CAN_CTRL2_TASD_SHIFT                     19
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_TASD_SHIFT))&CAN_CTRL2_TASD_MASK)
#define CAN_CTRL2_RFEN_MASK                      0xF000000u
#define CAN_CTRL2_RFEN_SHIFT                     24
#define CAN_CTRL2_RFEN(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CTRL2_RFEN_SHIFT))&CAN_CTRL2_RFEN_MASK)
#define CAN_CTRL2_WRMFRZ_MASK                    0x10000000u
#define CAN_CTRL2_WRMFRZ_SHIFT                   28
/* ESR2 Bit Fields */
#define CAN_ESR2_IMB_MASK                        0x2000u
#define CAN_ESR2_IMB_SHIFT                       13
#define CAN_ESR2_VPS_MASK                        0x4000u
#define CAN_ESR2_VPS_SHIFT                       14
#define CAN_ESR2_LPTM_MASK                       0x7F0000u
#define CAN_ESR2_LPTM_SHIFT                      16
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_ESR2_LPTM_SHIFT))&CAN_ESR2_LPTM_MASK)
/* CRCR Bit Fields */
#define CAN_CRCR_TXCRC_MASK                      0x7FFFu
#define CAN_CRCR_TXCRC_SHIFT                     0
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CRCR_TXCRC_SHIFT))&CAN_CRCR_TXCRC_MASK)
#define CAN_CRCR_MBCRC_MASK                      0x7F0000u
#define CAN_CRCR_MBCRC_SHIFT                     16
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x))<<CAN_CRCR_MBCRC_SHIFT))&CAN_CRCR_MBCRC_MASK)
/* RXFGMASK Bit Fields */
#define CAN_RXFGMASK_FGM31_FGM0_MASK             0xFFFFFFFFu
#define CAN_RXFGMASK_FGM31_FGM0_SHIFT            0
#define CAN_RXFGMASK_FGM31_FGM0(x)               (((uint32_t)(((uint32_t)(x))<<CAN_RXFGMASK_FGM31_FGM0_SHIFT))&CAN_RXFGMASK_FGM31_FGM0_MASK)
/* RXFIR Bit Fields */
#define CAN_RXFIR_IDHIT_MASK                     0x1FFu
#define CAN_RXFIR_IDHIT_SHIFT                    0
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x))<<CAN_RXFIR_IDHIT_SHIFT))&CAN_RXFIR_IDHIT_MASK)
/* CS Bit Fields */
#define CAN_CS_TIME_STAMP_MASK                   0xFFFFu
#define CAN_CS_TIME_STAMP_SHIFT                  0
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x))<<CAN_CS_TIME_STAMP_SHIFT))&CAN_CS_TIME_STAMP_MASK)
#define CAN_CS_DLC_MASK                          0xF0000u
#define CAN_CS_DLC_SHIFT                         16
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_CS_DLC_SHIFT))&CAN_CS_DLC_MASK)
#define CAN_CS_RTR_MASK                          0x100000u
#define CAN_CS_RTR_SHIFT                         20
#define CAN_CS_IDE_MASK                          0x200000u
#define CAN_CS_IDE_SHIFT                         21
#define CAN_CS_SRR_MASK                          0x400000u
#define CAN_CS_SRR_SHIFT                         22
#define CAN_CS_CODE_MASK                         0xF000000u
#define CAN_CS_CODE_SHIFT                        24
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_CS_CODE_SHIFT))&CAN_CS_CODE_MASK)
/* ID Bit Fields */
#define CAN_ID_EXT_MASK                          0x3FFFFu
#define CAN_ID_EXT_SHIFT                         0
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_ID_EXT_SHIFT))&CAN_ID_EXT_MASK)
#define CAN_ID_STD_MASK                          0x1FFC0000u
#define CAN_ID_STD_SHIFT                         18
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x))<<CAN_ID_STD_SHIFT))&CAN_ID_STD_MASK)
#define CAN_ID_PRIO_MASK                         0xE0000000u
#define CAN_ID_PRIO_SHIFT                        29
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x))<<CAN_ID_PRIO_SHIFT))&CAN_ID_PRIO_MASK)
/* WORD0 Bit Fields */
#define CAN_WORD0_DATA_BYTE_3_MASK               0xFFu
#define CAN_WORD0_DATA_BYTE_3_SHIFT              0
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_3_SHIFT))&CAN_WORD0_DATA_BYTE_3_MASK)
#define CAN_WORD0_DATA_BYTE_2_MASK               0xFF00u
#define CAN_WORD0_DATA_BYTE_2_SHIFT              8
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_2_SHIFT))&CAN_WORD0_DATA_BYTE_2_MASK)
#define CAN_WORD0_DATA_BYTE_1_MASK               0xFF0000u
#define CAN_WORD0_DATA_BYTE_1_SHIFT              16
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_1_SHIFT))&CAN_WORD0_DATA_BYTE_1_MASK)
#define CAN_WORD0_DATA_BYTE_0_MASK               0xFF000000u
#define CAN_WORD0_DATA_BYTE_0_SHIFT              24
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD0_DATA_BYTE_0_SHIFT))&CAN_WORD0_DATA_BYTE_0_MASK)
/* WORD1 Bit Fields */
#define CAN_WORD1_DATA_BYTE_7_MASK               0xFFu
#define CAN_WORD1_DATA_BYTE_7_SHIFT              0
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_7_SHIFT))&CAN_WORD1_DATA_BYTE_7_MASK)
#define CAN_WORD1_DATA_BYTE_6_MASK               0xFF00u
#define CAN_WORD1_DATA_BYTE_6_SHIFT              8
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_6_SHIFT))&CAN_WORD1_DATA_BYTE_6_MASK)
#define CAN_WORD1_DATA_BYTE_5_MASK               0xFF0000u
#define CAN_WORD1_DATA_BYTE_5_SHIFT              16
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_5_SHIFT))&CAN_WORD1_DATA_BYTE_5_MASK)
#define CAN_WORD1_DATA_BYTE_4_MASK               0xFF000000u
#define CAN_WORD1_DATA_BYTE_4_SHIFT              24
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x))<<CAN_WORD1_DATA_BYTE_4_SHIFT))&CAN_WORD1_DATA_BYTE_4_MASK)
/* RXIMR Bit Fields */
#define CAN_RXIMR_MI_MASK                        0xFFFFFFFFu
#define CAN_RXIMR_MI_SHIFT                       0
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x))<<CAN_RXIMR_MI_SHIFT))&CAN_RXIMR_MI_MASK)
/* GFWR Bit Fields */
#define CAN_GFWR_GFWR_MASK                       0xFFu
#define CAN_GFWR_GFWR_SHIFT                      0
#define CAN_GFWR_GFWR(x)                         (((uint32_t)(((uint32_t)(x))<<CAN_GFWR_GFWR_SHIFT))&CAN_GFWR_GFWR_MASK)

/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
/** Peripheral CAN1 base pointer */
#define CAN1_BASE_PTR                            ((CAN_MemMapPtr)0x42090000u)
/** Peripheral CAN2 base pointer */
#define CAN2_BASE_PTR                            ((CAN_MemMapPtr)0x42094000u)
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                            { CAN1_BASE_PTR, CAN2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CAN - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Accessor_Macros CAN - Register accessor macros
 * @{
 */


/* CAN - Register instance definitions */
/* CAN1 */
#define CAN1_MCR                                 CAN_MCR_REG(CAN1_BASE_PTR)
#define CAN1_CTRL1                               CAN_CTRL1_REG(CAN1_BASE_PTR)
#define CAN1_TIMER                               CAN_TIMER_REG(CAN1_BASE_PTR)
#define CAN1_RXMGMASK                            CAN_RXMGMASK_REG(CAN1_BASE_PTR)
#define CAN1_RX14MASK                            CAN_RX14MASK_REG(CAN1_BASE_PTR)
#define CAN1_RX15MASK                            CAN_RX15MASK_REG(CAN1_BASE_PTR)
#define CAN1_ECR                                 CAN_ECR_REG(CAN1_BASE_PTR)
#define CAN1_ESR1                                CAN_ESR1_REG(CAN1_BASE_PTR)
#define CAN1_IMASK2                              CAN_IMASK2_REG(CAN1_BASE_PTR)
#define CAN1_IMASK1                              CAN_IMASK1_REG(CAN1_BASE_PTR)
#define CAN1_IFLAG2                              CAN_IFLAG2_REG(CAN1_BASE_PTR)
#define CAN1_IFLAG1                              CAN_IFLAG1_REG(CAN1_BASE_PTR)
#define CAN1_CTRL2                               CAN_CTRL2_REG(CAN1_BASE_PTR)
#define CAN1_ESR2                                CAN_ESR2_REG(CAN1_BASE_PTR)
#define CAN1_CRCR                                CAN_CRCR_REG(CAN1_BASE_PTR)
#define CAN1_RXFGMASK                            CAN_RXFGMASK_REG(CAN1_BASE_PTR)
#define CAN1_RXFIR                               CAN_RXFIR_REG(CAN1_BASE_PTR)
#define CAN1_CS0                                 CAN_CS_REG(CAN1_BASE_PTR,0)
#define CAN1_ID0                                 CAN_ID_REG(CAN1_BASE_PTR,0)
#define CAN1_WORD00                              CAN_WORD0_REG(CAN1_BASE_PTR,0)
#define CAN1_WORD10                              CAN_WORD1_REG(CAN1_BASE_PTR,0)
#define CAN1_CS1                                 CAN_CS_REG(CAN1_BASE_PTR,1)
#define CAN1_ID1                                 CAN_ID_REG(CAN1_BASE_PTR,1)
#define CAN1_WORD01                              CAN_WORD0_REG(CAN1_BASE_PTR,1)
#define CAN1_WORD11                              CAN_WORD1_REG(CAN1_BASE_PTR,1)
#define CAN1_CS2                                 CAN_CS_REG(CAN1_BASE_PTR,2)
#define CAN1_ID2                                 CAN_ID_REG(CAN1_BASE_PTR,2)
#define CAN1_WORD02                              CAN_WORD0_REG(CAN1_BASE_PTR,2)
#define CAN1_WORD12                              CAN_WORD1_REG(CAN1_BASE_PTR,2)
#define CAN1_CS3                                 CAN_CS_REG(CAN1_BASE_PTR,3)
#define CAN1_ID3                                 CAN_ID_REG(CAN1_BASE_PTR,3)
#define CAN1_WORD03                              CAN_WORD0_REG(CAN1_BASE_PTR,3)
#define CAN1_WORD13                              CAN_WORD1_REG(CAN1_BASE_PTR,3)
#define CAN1_CS4                                 CAN_CS_REG(CAN1_BASE_PTR,4)
#define CAN1_ID4                                 CAN_ID_REG(CAN1_BASE_PTR,4)
#define CAN1_WORD04                              CAN_WORD0_REG(CAN1_BASE_PTR,4)
#define CAN1_WORD14                              CAN_WORD1_REG(CAN1_BASE_PTR,4)
#define CAN1_CS5                                 CAN_CS_REG(CAN1_BASE_PTR,5)
#define CAN1_ID5                                 CAN_ID_REG(CAN1_BASE_PTR,5)
#define CAN1_WORD05                              CAN_WORD0_REG(CAN1_BASE_PTR,5)
#define CAN1_WORD15                              CAN_WORD1_REG(CAN1_BASE_PTR,5)
#define CAN1_CS6                                 CAN_CS_REG(CAN1_BASE_PTR,6)
#define CAN1_ID6                                 CAN_ID_REG(CAN1_BASE_PTR,6)
#define CAN1_WORD06                              CAN_WORD0_REG(CAN1_BASE_PTR,6)
#define CAN1_WORD16                              CAN_WORD1_REG(CAN1_BASE_PTR,6)
#define CAN1_CS7                                 CAN_CS_REG(CAN1_BASE_PTR,7)
#define CAN1_ID7                                 CAN_ID_REG(CAN1_BASE_PTR,7)
#define CAN1_WORD07                              CAN_WORD0_REG(CAN1_BASE_PTR,7)
#define CAN1_WORD17                              CAN_WORD1_REG(CAN1_BASE_PTR,7)
#define CAN1_CS8                                 CAN_CS_REG(CAN1_BASE_PTR,8)
#define CAN1_ID8                                 CAN_ID_REG(CAN1_BASE_PTR,8)
#define CAN1_WORD08                              CAN_WORD0_REG(CAN1_BASE_PTR,8)
#define CAN1_WORD18                              CAN_WORD1_REG(CAN1_BASE_PTR,8)
#define CAN1_CS9                                 CAN_CS_REG(CAN1_BASE_PTR,9)
#define CAN1_ID9                                 CAN_ID_REG(CAN1_BASE_PTR,9)
#define CAN1_WORD09                              CAN_WORD0_REG(CAN1_BASE_PTR,9)
#define CAN1_WORD19                              CAN_WORD1_REG(CAN1_BASE_PTR,9)
#define CAN1_CS10                                CAN_CS_REG(CAN1_BASE_PTR,10)
#define CAN1_ID10                                CAN_ID_REG(CAN1_BASE_PTR,10)
#define CAN1_WORD010                             CAN_WORD0_REG(CAN1_BASE_PTR,10)
#define CAN1_WORD110                             CAN_WORD1_REG(CAN1_BASE_PTR,10)
#define CAN1_CS11                                CAN_CS_REG(CAN1_BASE_PTR,11)
#define CAN1_ID11                                CAN_ID_REG(CAN1_BASE_PTR,11)
#define CAN1_WORD011                             CAN_WORD0_REG(CAN1_BASE_PTR,11)
#define CAN1_WORD111                             CAN_WORD1_REG(CAN1_BASE_PTR,11)
#define CAN1_CS12                                CAN_CS_REG(CAN1_BASE_PTR,12)
#define CAN1_ID12                                CAN_ID_REG(CAN1_BASE_PTR,12)
#define CAN1_WORD012                             CAN_WORD0_REG(CAN1_BASE_PTR,12)
#define CAN1_WORD112                             CAN_WORD1_REG(CAN1_BASE_PTR,12)
#define CAN1_CS13                                CAN_CS_REG(CAN1_BASE_PTR,13)
#define CAN1_ID13                                CAN_ID_REG(CAN1_BASE_PTR,13)
#define CAN1_WORD013                             CAN_WORD0_REG(CAN1_BASE_PTR,13)
#define CAN1_WORD113                             CAN_WORD1_REG(CAN1_BASE_PTR,13)
#define CAN1_CS14                                CAN_CS_REG(CAN1_BASE_PTR,14)
#define CAN1_ID14                                CAN_ID_REG(CAN1_BASE_PTR,14)
#define CAN1_WORD014                             CAN_WORD0_REG(CAN1_BASE_PTR,14)
#define CAN1_WORD114                             CAN_WORD1_REG(CAN1_BASE_PTR,14)
#define CAN1_CS15                                CAN_CS_REG(CAN1_BASE_PTR,15)
#define CAN1_ID15                                CAN_ID_REG(CAN1_BASE_PTR,15)
#define CAN1_WORD015                             CAN_WORD0_REG(CAN1_BASE_PTR,15)
#define CAN1_WORD115                             CAN_WORD1_REG(CAN1_BASE_PTR,15)
#define CAN1_CS16                                CAN_CS_REG(CAN1_BASE_PTR,16)
#define CAN1_ID16                                CAN_ID_REG(CAN1_BASE_PTR,16)
#define CAN1_WORD016                             CAN_WORD0_REG(CAN1_BASE_PTR,16)
#define CAN1_WORD116                             CAN_WORD1_REG(CAN1_BASE_PTR,16)
#define CAN1_CS17                                CAN_CS_REG(CAN1_BASE_PTR,17)
#define CAN1_ID17                                CAN_ID_REG(CAN1_BASE_PTR,17)
#define CAN1_WORD017                             CAN_WORD0_REG(CAN1_BASE_PTR,17)
#define CAN1_WORD117                             CAN_WORD1_REG(CAN1_BASE_PTR,17)
#define CAN1_CS18                                CAN_CS_REG(CAN1_BASE_PTR,18)
#define CAN1_ID18                                CAN_ID_REG(CAN1_BASE_PTR,18)
#define CAN1_WORD018                             CAN_WORD0_REG(CAN1_BASE_PTR,18)
#define CAN1_WORD118                             CAN_WORD1_REG(CAN1_BASE_PTR,18)
#define CAN1_CS19                                CAN_CS_REG(CAN1_BASE_PTR,19)
#define CAN1_ID19                                CAN_ID_REG(CAN1_BASE_PTR,19)
#define CAN1_WORD019                             CAN_WORD0_REG(CAN1_BASE_PTR,19)
#define CAN1_WORD119                             CAN_WORD1_REG(CAN1_BASE_PTR,19)
#define CAN1_CS20                                CAN_CS_REG(CAN1_BASE_PTR,20)
#define CAN1_ID20                                CAN_ID_REG(CAN1_BASE_PTR,20)
#define CAN1_WORD020                             CAN_WORD0_REG(CAN1_BASE_PTR,20)
#define CAN1_WORD120                             CAN_WORD1_REG(CAN1_BASE_PTR,20)
#define CAN1_CS21                                CAN_CS_REG(CAN1_BASE_PTR,21)
#define CAN1_ID21                                CAN_ID_REG(CAN1_BASE_PTR,21)
#define CAN1_WORD021                             CAN_WORD0_REG(CAN1_BASE_PTR,21)
#define CAN1_WORD121                             CAN_WORD1_REG(CAN1_BASE_PTR,21)
#define CAN1_CS22                                CAN_CS_REG(CAN1_BASE_PTR,22)
#define CAN1_ID22                                CAN_ID_REG(CAN1_BASE_PTR,22)
#define CAN1_WORD022                             CAN_WORD0_REG(CAN1_BASE_PTR,22)
#define CAN1_WORD122                             CAN_WORD1_REG(CAN1_BASE_PTR,22)
#define CAN1_CS23                                CAN_CS_REG(CAN1_BASE_PTR,23)
#define CAN1_ID23                                CAN_ID_REG(CAN1_BASE_PTR,23)
#define CAN1_WORD023                             CAN_WORD0_REG(CAN1_BASE_PTR,23)
#define CAN1_WORD123                             CAN_WORD1_REG(CAN1_BASE_PTR,23)
#define CAN1_CS24                                CAN_CS_REG(CAN1_BASE_PTR,24)
#define CAN1_ID24                                CAN_ID_REG(CAN1_BASE_PTR,24)
#define CAN1_WORD024                             CAN_WORD0_REG(CAN1_BASE_PTR,24)
#define CAN1_WORD124                             CAN_WORD1_REG(CAN1_BASE_PTR,24)
#define CAN1_CS25                                CAN_CS_REG(CAN1_BASE_PTR,25)
#define CAN1_ID25                                CAN_ID_REG(CAN1_BASE_PTR,25)
#define CAN1_WORD025                             CAN_WORD0_REG(CAN1_BASE_PTR,25)
#define CAN1_WORD125                             CAN_WORD1_REG(CAN1_BASE_PTR,25)
#define CAN1_CS26                                CAN_CS_REG(CAN1_BASE_PTR,26)
#define CAN1_ID26                                CAN_ID_REG(CAN1_BASE_PTR,26)
#define CAN1_WORD026                             CAN_WORD0_REG(CAN1_BASE_PTR,26)
#define CAN1_WORD126                             CAN_WORD1_REG(CAN1_BASE_PTR,26)
#define CAN1_CS27                                CAN_CS_REG(CAN1_BASE_PTR,27)
#define CAN1_ID27                                CAN_ID_REG(CAN1_BASE_PTR,27)
#define CAN1_WORD027                             CAN_WORD0_REG(CAN1_BASE_PTR,27)
#define CAN1_WORD127                             CAN_WORD1_REG(CAN1_BASE_PTR,27)
#define CAN1_CS28                                CAN_CS_REG(CAN1_BASE_PTR,28)
#define CAN1_ID28                                CAN_ID_REG(CAN1_BASE_PTR,28)
#define CAN1_WORD028                             CAN_WORD0_REG(CAN1_BASE_PTR,28)
#define CAN1_WORD128                             CAN_WORD1_REG(CAN1_BASE_PTR,28)
#define CAN1_CS29                                CAN_CS_REG(CAN1_BASE_PTR,29)
#define CAN1_ID29                                CAN_ID_REG(CAN1_BASE_PTR,29)
#define CAN1_WORD029                             CAN_WORD0_REG(CAN1_BASE_PTR,29)
#define CAN1_WORD129                             CAN_WORD1_REG(CAN1_BASE_PTR,29)
#define CAN1_CS30                                CAN_CS_REG(CAN1_BASE_PTR,30)
#define CAN1_ID30                                CAN_ID_REG(CAN1_BASE_PTR,30)
#define CAN1_WORD030                             CAN_WORD0_REG(CAN1_BASE_PTR,30)
#define CAN1_WORD130                             CAN_WORD1_REG(CAN1_BASE_PTR,30)
#define CAN1_CS31                                CAN_CS_REG(CAN1_BASE_PTR,31)
#define CAN1_ID31                                CAN_ID_REG(CAN1_BASE_PTR,31)
#define CAN1_WORD031                             CAN_WORD0_REG(CAN1_BASE_PTR,31)
#define CAN1_WORD131                             CAN_WORD1_REG(CAN1_BASE_PTR,31)
#define CAN1_CS32                                CAN_CS_REG(CAN1_BASE_PTR,32)
#define CAN1_ID32                                CAN_ID_REG(CAN1_BASE_PTR,32)
#define CAN1_WORD032                             CAN_WORD0_REG(CAN1_BASE_PTR,32)
#define CAN1_WORD132                             CAN_WORD1_REG(CAN1_BASE_PTR,32)
#define CAN1_CS33                                CAN_CS_REG(CAN1_BASE_PTR,33)
#define CAN1_ID33                                CAN_ID_REG(CAN1_BASE_PTR,33)
#define CAN1_WORD033                             CAN_WORD0_REG(CAN1_BASE_PTR,33)
#define CAN1_WORD133                             CAN_WORD1_REG(CAN1_BASE_PTR,33)
#define CAN1_CS34                                CAN_CS_REG(CAN1_BASE_PTR,34)
#define CAN1_ID34                                CAN_ID_REG(CAN1_BASE_PTR,34)
#define CAN1_WORD034                             CAN_WORD0_REG(CAN1_BASE_PTR,34)
#define CAN1_WORD134                             CAN_WORD1_REG(CAN1_BASE_PTR,34)
#define CAN1_CS35                                CAN_CS_REG(CAN1_BASE_PTR,35)
#define CAN1_ID35                                CAN_ID_REG(CAN1_BASE_PTR,35)
#define CAN1_WORD035                             CAN_WORD0_REG(CAN1_BASE_PTR,35)
#define CAN1_WORD135                             CAN_WORD1_REG(CAN1_BASE_PTR,35)
#define CAN1_CS36                                CAN_CS_REG(CAN1_BASE_PTR,36)
#define CAN1_ID36                                CAN_ID_REG(CAN1_BASE_PTR,36)
#define CAN1_WORD036                             CAN_WORD0_REG(CAN1_BASE_PTR,36)
#define CAN1_WORD136                             CAN_WORD1_REG(CAN1_BASE_PTR,36)
#define CAN1_CS37                                CAN_CS_REG(CAN1_BASE_PTR,37)
#define CAN1_ID37                                CAN_ID_REG(CAN1_BASE_PTR,37)
#define CAN1_WORD037                             CAN_WORD0_REG(CAN1_BASE_PTR,37)
#define CAN1_WORD137                             CAN_WORD1_REG(CAN1_BASE_PTR,37)
#define CAN1_CS38                                CAN_CS_REG(CAN1_BASE_PTR,38)
#define CAN1_ID38                                CAN_ID_REG(CAN1_BASE_PTR,38)
#define CAN1_WORD038                             CAN_WORD0_REG(CAN1_BASE_PTR,38)
#define CAN1_WORD138                             CAN_WORD1_REG(CAN1_BASE_PTR,38)
#define CAN1_CS39                                CAN_CS_REG(CAN1_BASE_PTR,39)
#define CAN1_ID39                                CAN_ID_REG(CAN1_BASE_PTR,39)
#define CAN1_WORD039                             CAN_WORD0_REG(CAN1_BASE_PTR,39)
#define CAN1_WORD139                             CAN_WORD1_REG(CAN1_BASE_PTR,39)
#define CAN1_CS40                                CAN_CS_REG(CAN1_BASE_PTR,40)
#define CAN1_ID40                                CAN_ID_REG(CAN1_BASE_PTR,40)
#define CAN1_WORD040                             CAN_WORD0_REG(CAN1_BASE_PTR,40)
#define CAN1_WORD140                             CAN_WORD1_REG(CAN1_BASE_PTR,40)
#define CAN1_CS41                                CAN_CS_REG(CAN1_BASE_PTR,41)
#define CAN1_ID41                                CAN_ID_REG(CAN1_BASE_PTR,41)
#define CAN1_WORD041                             CAN_WORD0_REG(CAN1_BASE_PTR,41)
#define CAN1_WORD141                             CAN_WORD1_REG(CAN1_BASE_PTR,41)
#define CAN1_CS42                                CAN_CS_REG(CAN1_BASE_PTR,42)
#define CAN1_ID42                                CAN_ID_REG(CAN1_BASE_PTR,42)
#define CAN1_WORD042                             CAN_WORD0_REG(CAN1_BASE_PTR,42)
#define CAN1_WORD142                             CAN_WORD1_REG(CAN1_BASE_PTR,42)
#define CAN1_CS43                                CAN_CS_REG(CAN1_BASE_PTR,43)
#define CAN1_ID43                                CAN_ID_REG(CAN1_BASE_PTR,43)
#define CAN1_WORD043                             CAN_WORD0_REG(CAN1_BASE_PTR,43)
#define CAN1_WORD143                             CAN_WORD1_REG(CAN1_BASE_PTR,43)
#define CAN1_CS44                                CAN_CS_REG(CAN1_BASE_PTR,44)
#define CAN1_ID44                                CAN_ID_REG(CAN1_BASE_PTR,44)
#define CAN1_WORD044                             CAN_WORD0_REG(CAN1_BASE_PTR,44)
#define CAN1_WORD144                             CAN_WORD1_REG(CAN1_BASE_PTR,44)
#define CAN1_CS45                                CAN_CS_REG(CAN1_BASE_PTR,45)
#define CAN1_ID45                                CAN_ID_REG(CAN1_BASE_PTR,45)
#define CAN1_WORD045                             CAN_WORD0_REG(CAN1_BASE_PTR,45)
#define CAN1_WORD145                             CAN_WORD1_REG(CAN1_BASE_PTR,45)
#define CAN1_CS46                                CAN_CS_REG(CAN1_BASE_PTR,46)
#define CAN1_ID46                                CAN_ID_REG(CAN1_BASE_PTR,46)
#define CAN1_WORD046                             CAN_WORD0_REG(CAN1_BASE_PTR,46)
#define CAN1_WORD146                             CAN_WORD1_REG(CAN1_BASE_PTR,46)
#define CAN1_CS47                                CAN_CS_REG(CAN1_BASE_PTR,47)
#define CAN1_ID47                                CAN_ID_REG(CAN1_BASE_PTR,47)
#define CAN1_WORD047                             CAN_WORD0_REG(CAN1_BASE_PTR,47)
#define CAN1_WORD147                             CAN_WORD1_REG(CAN1_BASE_PTR,47)
#define CAN1_CS48                                CAN_CS_REG(CAN1_BASE_PTR,48)
#define CAN1_ID48                                CAN_ID_REG(CAN1_BASE_PTR,48)
#define CAN1_WORD048                             CAN_WORD0_REG(CAN1_BASE_PTR,48)
#define CAN1_WORD148                             CAN_WORD1_REG(CAN1_BASE_PTR,48)
#define CAN1_CS49                                CAN_CS_REG(CAN1_BASE_PTR,49)
#define CAN1_ID49                                CAN_ID_REG(CAN1_BASE_PTR,49)
#define CAN1_WORD049                             CAN_WORD0_REG(CAN1_BASE_PTR,49)
#define CAN1_WORD149                             CAN_WORD1_REG(CAN1_BASE_PTR,49)
#define CAN1_CS50                                CAN_CS_REG(CAN1_BASE_PTR,50)
#define CAN1_ID50                                CAN_ID_REG(CAN1_BASE_PTR,50)
#define CAN1_WORD050                             CAN_WORD0_REG(CAN1_BASE_PTR,50)
#define CAN1_WORD150                             CAN_WORD1_REG(CAN1_BASE_PTR,50)
#define CAN1_CS51                                CAN_CS_REG(CAN1_BASE_PTR,51)
#define CAN1_ID51                                CAN_ID_REG(CAN1_BASE_PTR,51)
#define CAN1_WORD051                             CAN_WORD0_REG(CAN1_BASE_PTR,51)
#define CAN1_WORD151                             CAN_WORD1_REG(CAN1_BASE_PTR,51)
#define CAN1_CS52                                CAN_CS_REG(CAN1_BASE_PTR,52)
#define CAN1_ID52                                CAN_ID_REG(CAN1_BASE_PTR,52)
#define CAN1_WORD052                             CAN_WORD0_REG(CAN1_BASE_PTR,52)
#define CAN1_WORD152                             CAN_WORD1_REG(CAN1_BASE_PTR,52)
#define CAN1_CS53                                CAN_CS_REG(CAN1_BASE_PTR,53)
#define CAN1_ID53                                CAN_ID_REG(CAN1_BASE_PTR,53)
#define CAN1_WORD053                             CAN_WORD0_REG(CAN1_BASE_PTR,53)
#define CAN1_WORD153                             CAN_WORD1_REG(CAN1_BASE_PTR,53)
#define CAN1_CS54                                CAN_CS_REG(CAN1_BASE_PTR,54)
#define CAN1_ID54                                CAN_ID_REG(CAN1_BASE_PTR,54)
#define CAN1_WORD054                             CAN_WORD0_REG(CAN1_BASE_PTR,54)
#define CAN1_WORD154                             CAN_WORD1_REG(CAN1_BASE_PTR,54)
#define CAN1_CS55                                CAN_CS_REG(CAN1_BASE_PTR,55)
#define CAN1_ID55                                CAN_ID_REG(CAN1_BASE_PTR,55)
#define CAN1_WORD055                             CAN_WORD0_REG(CAN1_BASE_PTR,55)
#define CAN1_WORD155                             CAN_WORD1_REG(CAN1_BASE_PTR,55)
#define CAN1_CS56                                CAN_CS_REG(CAN1_BASE_PTR,56)
#define CAN1_ID56                                CAN_ID_REG(CAN1_BASE_PTR,56)
#define CAN1_WORD056                             CAN_WORD0_REG(CAN1_BASE_PTR,56)
#define CAN1_WORD156                             CAN_WORD1_REG(CAN1_BASE_PTR,56)
#define CAN1_CS57                                CAN_CS_REG(CAN1_BASE_PTR,57)
#define CAN1_ID57                                CAN_ID_REG(CAN1_BASE_PTR,57)
#define CAN1_WORD057                             CAN_WORD0_REG(CAN1_BASE_PTR,57)
#define CAN1_WORD157                             CAN_WORD1_REG(CAN1_BASE_PTR,57)
#define CAN1_CS58                                CAN_CS_REG(CAN1_BASE_PTR,58)
#define CAN1_ID58                                CAN_ID_REG(CAN1_BASE_PTR,58)
#define CAN1_WORD058                             CAN_WORD0_REG(CAN1_BASE_PTR,58)
#define CAN1_WORD158                             CAN_WORD1_REG(CAN1_BASE_PTR,58)
#define CAN1_CS59                                CAN_CS_REG(CAN1_BASE_PTR,59)
#define CAN1_ID59                                CAN_ID_REG(CAN1_BASE_PTR,59)
#define CAN1_WORD059                             CAN_WORD0_REG(CAN1_BASE_PTR,59)
#define CAN1_WORD159                             CAN_WORD1_REG(CAN1_BASE_PTR,59)
#define CAN1_CS60                                CAN_CS_REG(CAN1_BASE_PTR,60)
#define CAN1_ID60                                CAN_ID_REG(CAN1_BASE_PTR,60)
#define CAN1_WORD060                             CAN_WORD0_REG(CAN1_BASE_PTR,60)
#define CAN1_WORD160                             CAN_WORD1_REG(CAN1_BASE_PTR,60)
#define CAN1_CS61                                CAN_CS_REG(CAN1_BASE_PTR,61)
#define CAN1_ID61                                CAN_ID_REG(CAN1_BASE_PTR,61)
#define CAN1_WORD061                             CAN_WORD0_REG(CAN1_BASE_PTR,61)
#define CAN1_WORD161                             CAN_WORD1_REG(CAN1_BASE_PTR,61)
#define CAN1_CS62                                CAN_CS_REG(CAN1_BASE_PTR,62)
#define CAN1_ID62                                CAN_ID_REG(CAN1_BASE_PTR,62)
#define CAN1_WORD062                             CAN_WORD0_REG(CAN1_BASE_PTR,62)
#define CAN1_WORD162                             CAN_WORD1_REG(CAN1_BASE_PTR,62)
#define CAN1_CS63                                CAN_CS_REG(CAN1_BASE_PTR,63)
#define CAN1_ID63                                CAN_ID_REG(CAN1_BASE_PTR,63)
#define CAN1_WORD063                             CAN_WORD0_REG(CAN1_BASE_PTR,63)
#define CAN1_WORD163                             CAN_WORD1_REG(CAN1_BASE_PTR,63)
#define CAN1_RXIMR0                              CAN_RXIMR_REG(CAN1_BASE_PTR,0)
#define CAN1_RXIMR1                              CAN_RXIMR_REG(CAN1_BASE_PTR,1)
#define CAN1_RXIMR2                              CAN_RXIMR_REG(CAN1_BASE_PTR,2)
#define CAN1_RXIMR3                              CAN_RXIMR_REG(CAN1_BASE_PTR,3)
#define CAN1_RXIMR4                              CAN_RXIMR_REG(CAN1_BASE_PTR,4)
#define CAN1_RXIMR5                              CAN_RXIMR_REG(CAN1_BASE_PTR,5)
#define CAN1_RXIMR6                              CAN_RXIMR_REG(CAN1_BASE_PTR,6)
#define CAN1_RXIMR7                              CAN_RXIMR_REG(CAN1_BASE_PTR,7)
#define CAN1_RXIMR8                              CAN_RXIMR_REG(CAN1_BASE_PTR,8)
#define CAN1_RXIMR9                              CAN_RXIMR_REG(CAN1_BASE_PTR,9)
#define CAN1_RXIMR10                             CAN_RXIMR_REG(CAN1_BASE_PTR,10)
#define CAN1_RXIMR11                             CAN_RXIMR_REG(CAN1_BASE_PTR,11)
#define CAN1_RXIMR12                             CAN_RXIMR_REG(CAN1_BASE_PTR,12)
#define CAN1_RXIMR13                             CAN_RXIMR_REG(CAN1_BASE_PTR,13)
#define CAN1_RXIMR14                             CAN_RXIMR_REG(CAN1_BASE_PTR,14)
#define CAN1_RXIMR15                             CAN_RXIMR_REG(CAN1_BASE_PTR,15)
#define CAN1_RXIMR16                             CAN_RXIMR_REG(CAN1_BASE_PTR,16)
#define CAN1_RXIMR17                             CAN_RXIMR_REG(CAN1_BASE_PTR,17)
#define CAN1_RXIMR18                             CAN_RXIMR_REG(CAN1_BASE_PTR,18)
#define CAN1_RXIMR19                             CAN_RXIMR_REG(CAN1_BASE_PTR,19)
#define CAN1_RXIMR20                             CAN_RXIMR_REG(CAN1_BASE_PTR,20)
#define CAN1_RXIMR21                             CAN_RXIMR_REG(CAN1_BASE_PTR,21)
#define CAN1_RXIMR22                             CAN_RXIMR_REG(CAN1_BASE_PTR,22)
#define CAN1_RXIMR23                             CAN_RXIMR_REG(CAN1_BASE_PTR,23)
#define CAN1_RXIMR24                             CAN_RXIMR_REG(CAN1_BASE_PTR,24)
#define CAN1_RXIMR25                             CAN_RXIMR_REG(CAN1_BASE_PTR,25)
#define CAN1_RXIMR26                             CAN_RXIMR_REG(CAN1_BASE_PTR,26)
#define CAN1_RXIMR27                             CAN_RXIMR_REG(CAN1_BASE_PTR,27)
#define CAN1_RXIMR28                             CAN_RXIMR_REG(CAN1_BASE_PTR,28)
#define CAN1_RXIMR29                             CAN_RXIMR_REG(CAN1_BASE_PTR,29)
#define CAN1_RXIMR30                             CAN_RXIMR_REG(CAN1_BASE_PTR,30)
#define CAN1_RXIMR31                             CAN_RXIMR_REG(CAN1_BASE_PTR,31)
#define CAN1_RXIMR32                             CAN_RXIMR_REG(CAN1_BASE_PTR,32)
#define CAN1_RXIMR33                             CAN_RXIMR_REG(CAN1_BASE_PTR,33)
#define CAN1_RXIMR34                             CAN_RXIMR_REG(CAN1_BASE_PTR,34)
#define CAN1_RXIMR35                             CAN_RXIMR_REG(CAN1_BASE_PTR,35)
#define CAN1_RXIMR36                             CAN_RXIMR_REG(CAN1_BASE_PTR,36)
#define CAN1_RXIMR37                             CAN_RXIMR_REG(CAN1_BASE_PTR,37)
#define CAN1_RXIMR38                             CAN_RXIMR_REG(CAN1_BASE_PTR,38)
#define CAN1_RXIMR39                             CAN_RXIMR_REG(CAN1_BASE_PTR,39)
#define CAN1_RXIMR40                             CAN_RXIMR_REG(CAN1_BASE_PTR,40)
#define CAN1_RXIMR41                             CAN_RXIMR_REG(CAN1_BASE_PTR,41)
#define CAN1_RXIMR42                             CAN_RXIMR_REG(CAN1_BASE_PTR,42)
#define CAN1_RXIMR43                             CAN_RXIMR_REG(CAN1_BASE_PTR,43)
#define CAN1_RXIMR44                             CAN_RXIMR_REG(CAN1_BASE_PTR,44)
#define CAN1_RXIMR45                             CAN_RXIMR_REG(CAN1_BASE_PTR,45)
#define CAN1_RXIMR46                             CAN_RXIMR_REG(CAN1_BASE_PTR,46)
#define CAN1_RXIMR47                             CAN_RXIMR_REG(CAN1_BASE_PTR,47)
#define CAN1_RXIMR48                             CAN_RXIMR_REG(CAN1_BASE_PTR,48)
#define CAN1_RXIMR49                             CAN_RXIMR_REG(CAN1_BASE_PTR,49)
#define CAN1_RXIMR50                             CAN_RXIMR_REG(CAN1_BASE_PTR,50)
#define CAN1_RXIMR51                             CAN_RXIMR_REG(CAN1_BASE_PTR,51)
#define CAN1_RXIMR52                             CAN_RXIMR_REG(CAN1_BASE_PTR,52)
#define CAN1_RXIMR53                             CAN_RXIMR_REG(CAN1_BASE_PTR,53)
#define CAN1_RXIMR54                             CAN_RXIMR_REG(CAN1_BASE_PTR,54)
#define CAN1_RXIMR55                             CAN_RXIMR_REG(CAN1_BASE_PTR,55)
#define CAN1_RXIMR56                             CAN_RXIMR_REG(CAN1_BASE_PTR,56)
#define CAN1_RXIMR57                             CAN_RXIMR_REG(CAN1_BASE_PTR,57)
#define CAN1_RXIMR58                             CAN_RXIMR_REG(CAN1_BASE_PTR,58)
#define CAN1_RXIMR59                             CAN_RXIMR_REG(CAN1_BASE_PTR,59)
#define CAN1_RXIMR60                             CAN_RXIMR_REG(CAN1_BASE_PTR,60)
#define CAN1_RXIMR61                             CAN_RXIMR_REG(CAN1_BASE_PTR,61)
#define CAN1_RXIMR62                             CAN_RXIMR_REG(CAN1_BASE_PTR,62)
#define CAN1_RXIMR63                             CAN_RXIMR_REG(CAN1_BASE_PTR,63)
#define CAN1_GFWR                                CAN_GFWR_REG(CAN1_BASE_PTR)
/* CAN2 */
#define CAN2_MCR                                 CAN_MCR_REG(CAN2_BASE_PTR)
#define CAN2_CTRL1                               CAN_CTRL1_REG(CAN2_BASE_PTR)
#define CAN2_TIMER                               CAN_TIMER_REG(CAN2_BASE_PTR)
#define CAN2_RXMGMASK                            CAN_RXMGMASK_REG(CAN2_BASE_PTR)
#define CAN2_RX14MASK                            CAN_RX14MASK_REG(CAN2_BASE_PTR)
#define CAN2_RX15MASK                            CAN_RX15MASK_REG(CAN2_BASE_PTR)
#define CAN2_ECR                                 CAN_ECR_REG(CAN2_BASE_PTR)
#define CAN2_ESR1                                CAN_ESR1_REG(CAN2_BASE_PTR)
#define CAN2_IMASK2                              CAN_IMASK2_REG(CAN2_BASE_PTR)
#define CAN2_IMASK1                              CAN_IMASK1_REG(CAN2_BASE_PTR)
#define CAN2_IFLAG2                              CAN_IFLAG2_REG(CAN2_BASE_PTR)
#define CAN2_IFLAG1                              CAN_IFLAG1_REG(CAN2_BASE_PTR)
#define CAN2_CTRL2                               CAN_CTRL2_REG(CAN2_BASE_PTR)
#define CAN2_ESR2                                CAN_ESR2_REG(CAN2_BASE_PTR)
#define CAN2_CRCR                                CAN_CRCR_REG(CAN2_BASE_PTR)
#define CAN2_RXFGMASK                            CAN_RXFGMASK_REG(CAN2_BASE_PTR)
#define CAN2_RXFIR                               CAN_RXFIR_REG(CAN2_BASE_PTR)
#define CAN2_CS0                                 CAN_CS_REG(CAN2_BASE_PTR,0)
#define CAN2_ID0                                 CAN_ID_REG(CAN2_BASE_PTR,0)
#define CAN2_WORD00                              CAN_WORD0_REG(CAN2_BASE_PTR,0)
#define CAN2_WORD10                              CAN_WORD1_REG(CAN2_BASE_PTR,0)
#define CAN2_CS1                                 CAN_CS_REG(CAN2_BASE_PTR,1)
#define CAN2_ID1                                 CAN_ID_REG(CAN2_BASE_PTR,1)
#define CAN2_WORD01                              CAN_WORD0_REG(CAN2_BASE_PTR,1)
#define CAN2_WORD11                              CAN_WORD1_REG(CAN2_BASE_PTR,1)
#define CAN2_CS2                                 CAN_CS_REG(CAN2_BASE_PTR,2)
#define CAN2_ID2                                 CAN_ID_REG(CAN2_BASE_PTR,2)
#define CAN2_WORD02                              CAN_WORD0_REG(CAN2_BASE_PTR,2)
#define CAN2_WORD12                              CAN_WORD1_REG(CAN2_BASE_PTR,2)
#define CAN2_CS3                                 CAN_CS_REG(CAN2_BASE_PTR,3)
#define CAN2_ID3                                 CAN_ID_REG(CAN2_BASE_PTR,3)
#define CAN2_WORD03                              CAN_WORD0_REG(CAN2_BASE_PTR,3)
#define CAN2_WORD13                              CAN_WORD1_REG(CAN2_BASE_PTR,3)
#define CAN2_CS4                                 CAN_CS_REG(CAN2_BASE_PTR,4)
#define CAN2_ID4                                 CAN_ID_REG(CAN2_BASE_PTR,4)
#define CAN2_WORD04                              CAN_WORD0_REG(CAN2_BASE_PTR,4)
#define CAN2_WORD14                              CAN_WORD1_REG(CAN2_BASE_PTR,4)
#define CAN2_CS5                                 CAN_CS_REG(CAN2_BASE_PTR,5)
#define CAN2_ID5                                 CAN_ID_REG(CAN2_BASE_PTR,5)
#define CAN2_WORD05                              CAN_WORD0_REG(CAN2_BASE_PTR,5)
#define CAN2_WORD15                              CAN_WORD1_REG(CAN2_BASE_PTR,5)
#define CAN2_CS6                                 CAN_CS_REG(CAN2_BASE_PTR,6)
#define CAN2_ID6                                 CAN_ID_REG(CAN2_BASE_PTR,6)
#define CAN2_WORD06                              CAN_WORD0_REG(CAN2_BASE_PTR,6)
#define CAN2_WORD16                              CAN_WORD1_REG(CAN2_BASE_PTR,6)
#define CAN2_CS7                                 CAN_CS_REG(CAN2_BASE_PTR,7)
#define CAN2_ID7                                 CAN_ID_REG(CAN2_BASE_PTR,7)
#define CAN2_WORD07                              CAN_WORD0_REG(CAN2_BASE_PTR,7)
#define CAN2_WORD17                              CAN_WORD1_REG(CAN2_BASE_PTR,7)
#define CAN2_CS8                                 CAN_CS_REG(CAN2_BASE_PTR,8)
#define CAN2_ID8                                 CAN_ID_REG(CAN2_BASE_PTR,8)
#define CAN2_WORD08                              CAN_WORD0_REG(CAN2_BASE_PTR,8)
#define CAN2_WORD18                              CAN_WORD1_REG(CAN2_BASE_PTR,8)
#define CAN2_CS9                                 CAN_CS_REG(CAN2_BASE_PTR,9)
#define CAN2_ID9                                 CAN_ID_REG(CAN2_BASE_PTR,9)
#define CAN2_WORD09                              CAN_WORD0_REG(CAN2_BASE_PTR,9)
#define CAN2_WORD19                              CAN_WORD1_REG(CAN2_BASE_PTR,9)
#define CAN2_CS10                                CAN_CS_REG(CAN2_BASE_PTR,10)
#define CAN2_ID10                                CAN_ID_REG(CAN2_BASE_PTR,10)
#define CAN2_WORD010                             CAN_WORD0_REG(CAN2_BASE_PTR,10)
#define CAN2_WORD110                             CAN_WORD1_REG(CAN2_BASE_PTR,10)
#define CAN2_CS11                                CAN_CS_REG(CAN2_BASE_PTR,11)
#define CAN2_ID11                                CAN_ID_REG(CAN2_BASE_PTR,11)
#define CAN2_WORD011                             CAN_WORD0_REG(CAN2_BASE_PTR,11)
#define CAN2_WORD111                             CAN_WORD1_REG(CAN2_BASE_PTR,11)
#define CAN2_CS12                                CAN_CS_REG(CAN2_BASE_PTR,12)
#define CAN2_ID12                                CAN_ID_REG(CAN2_BASE_PTR,12)
#define CAN2_WORD012                             CAN_WORD0_REG(CAN2_BASE_PTR,12)
#define CAN2_WORD112                             CAN_WORD1_REG(CAN2_BASE_PTR,12)
#define CAN2_CS13                                CAN_CS_REG(CAN2_BASE_PTR,13)
#define CAN2_ID13                                CAN_ID_REG(CAN2_BASE_PTR,13)
#define CAN2_WORD013                             CAN_WORD0_REG(CAN2_BASE_PTR,13)
#define CAN2_WORD113                             CAN_WORD1_REG(CAN2_BASE_PTR,13)
#define CAN2_CS14                                CAN_CS_REG(CAN2_BASE_PTR,14)
#define CAN2_ID14                                CAN_ID_REG(CAN2_BASE_PTR,14)
#define CAN2_WORD014                             CAN_WORD0_REG(CAN2_BASE_PTR,14)
#define CAN2_WORD114                             CAN_WORD1_REG(CAN2_BASE_PTR,14)
#define CAN2_CS15                                CAN_CS_REG(CAN2_BASE_PTR,15)
#define CAN2_ID15                                CAN_ID_REG(CAN2_BASE_PTR,15)
#define CAN2_WORD015                             CAN_WORD0_REG(CAN2_BASE_PTR,15)
#define CAN2_WORD115                             CAN_WORD1_REG(CAN2_BASE_PTR,15)
#define CAN2_CS16                                CAN_CS_REG(CAN2_BASE_PTR,16)
#define CAN2_ID16                                CAN_ID_REG(CAN2_BASE_PTR,16)
#define CAN2_WORD016                             CAN_WORD0_REG(CAN2_BASE_PTR,16)
#define CAN2_WORD116                             CAN_WORD1_REG(CAN2_BASE_PTR,16)
#define CAN2_CS17                                CAN_CS_REG(CAN2_BASE_PTR,17)
#define CAN2_ID17                                CAN_ID_REG(CAN2_BASE_PTR,17)
#define CAN2_WORD017                             CAN_WORD0_REG(CAN2_BASE_PTR,17)
#define CAN2_WORD117                             CAN_WORD1_REG(CAN2_BASE_PTR,17)
#define CAN2_CS18                                CAN_CS_REG(CAN2_BASE_PTR,18)
#define CAN2_ID18                                CAN_ID_REG(CAN2_BASE_PTR,18)
#define CAN2_WORD018                             CAN_WORD0_REG(CAN2_BASE_PTR,18)
#define CAN2_WORD118                             CAN_WORD1_REG(CAN2_BASE_PTR,18)
#define CAN2_CS19                                CAN_CS_REG(CAN2_BASE_PTR,19)
#define CAN2_ID19                                CAN_ID_REG(CAN2_BASE_PTR,19)
#define CAN2_WORD019                             CAN_WORD0_REG(CAN2_BASE_PTR,19)
#define CAN2_WORD119                             CAN_WORD1_REG(CAN2_BASE_PTR,19)
#define CAN2_CS20                                CAN_CS_REG(CAN2_BASE_PTR,20)
#define CAN2_ID20                                CAN_ID_REG(CAN2_BASE_PTR,20)
#define CAN2_WORD020                             CAN_WORD0_REG(CAN2_BASE_PTR,20)
#define CAN2_WORD120                             CAN_WORD1_REG(CAN2_BASE_PTR,20)
#define CAN2_CS21                                CAN_CS_REG(CAN2_BASE_PTR,21)
#define CAN2_ID21                                CAN_ID_REG(CAN2_BASE_PTR,21)
#define CAN2_WORD021                             CAN_WORD0_REG(CAN2_BASE_PTR,21)
#define CAN2_WORD121                             CAN_WORD1_REG(CAN2_BASE_PTR,21)
#define CAN2_CS22                                CAN_CS_REG(CAN2_BASE_PTR,22)
#define CAN2_ID22                                CAN_ID_REG(CAN2_BASE_PTR,22)
#define CAN2_WORD022                             CAN_WORD0_REG(CAN2_BASE_PTR,22)
#define CAN2_WORD122                             CAN_WORD1_REG(CAN2_BASE_PTR,22)
#define CAN2_CS23                                CAN_CS_REG(CAN2_BASE_PTR,23)
#define CAN2_ID23                                CAN_ID_REG(CAN2_BASE_PTR,23)
#define CAN2_WORD023                             CAN_WORD0_REG(CAN2_BASE_PTR,23)
#define CAN2_WORD123                             CAN_WORD1_REG(CAN2_BASE_PTR,23)
#define CAN2_CS24                                CAN_CS_REG(CAN2_BASE_PTR,24)
#define CAN2_ID24                                CAN_ID_REG(CAN2_BASE_PTR,24)
#define CAN2_WORD024                             CAN_WORD0_REG(CAN2_BASE_PTR,24)
#define CAN2_WORD124                             CAN_WORD1_REG(CAN2_BASE_PTR,24)
#define CAN2_CS25                                CAN_CS_REG(CAN2_BASE_PTR,25)
#define CAN2_ID25                                CAN_ID_REG(CAN2_BASE_PTR,25)
#define CAN2_WORD025                             CAN_WORD0_REG(CAN2_BASE_PTR,25)
#define CAN2_WORD125                             CAN_WORD1_REG(CAN2_BASE_PTR,25)
#define CAN2_CS26                                CAN_CS_REG(CAN2_BASE_PTR,26)
#define CAN2_ID26                                CAN_ID_REG(CAN2_BASE_PTR,26)
#define CAN2_WORD026                             CAN_WORD0_REG(CAN2_BASE_PTR,26)
#define CAN2_WORD126                             CAN_WORD1_REG(CAN2_BASE_PTR,26)
#define CAN2_CS27                                CAN_CS_REG(CAN2_BASE_PTR,27)
#define CAN2_ID27                                CAN_ID_REG(CAN2_BASE_PTR,27)
#define CAN2_WORD027                             CAN_WORD0_REG(CAN2_BASE_PTR,27)
#define CAN2_WORD127                             CAN_WORD1_REG(CAN2_BASE_PTR,27)
#define CAN2_CS28                                CAN_CS_REG(CAN2_BASE_PTR,28)
#define CAN2_ID28                                CAN_ID_REG(CAN2_BASE_PTR,28)
#define CAN2_WORD028                             CAN_WORD0_REG(CAN2_BASE_PTR,28)
#define CAN2_WORD128                             CAN_WORD1_REG(CAN2_BASE_PTR,28)
#define CAN2_CS29                                CAN_CS_REG(CAN2_BASE_PTR,29)
#define CAN2_ID29                                CAN_ID_REG(CAN2_BASE_PTR,29)
#define CAN2_WORD029                             CAN_WORD0_REG(CAN2_BASE_PTR,29)
#define CAN2_WORD129                             CAN_WORD1_REG(CAN2_BASE_PTR,29)
#define CAN2_CS30                                CAN_CS_REG(CAN2_BASE_PTR,30)
#define CAN2_ID30                                CAN_ID_REG(CAN2_BASE_PTR,30)
#define CAN2_WORD030                             CAN_WORD0_REG(CAN2_BASE_PTR,30)
#define CAN2_WORD130                             CAN_WORD1_REG(CAN2_BASE_PTR,30)
#define CAN2_CS31                                CAN_CS_REG(CAN2_BASE_PTR,31)
#define CAN2_ID31                                CAN_ID_REG(CAN2_BASE_PTR,31)
#define CAN2_WORD031                             CAN_WORD0_REG(CAN2_BASE_PTR,31)
#define CAN2_WORD131                             CAN_WORD1_REG(CAN2_BASE_PTR,31)
#define CAN2_CS32                                CAN_CS_REG(CAN2_BASE_PTR,32)
#define CAN2_ID32                                CAN_ID_REG(CAN2_BASE_PTR,32)
#define CAN2_WORD032                             CAN_WORD0_REG(CAN2_BASE_PTR,32)
#define CAN2_WORD132                             CAN_WORD1_REG(CAN2_BASE_PTR,32)
#define CAN2_CS33                                CAN_CS_REG(CAN2_BASE_PTR,33)
#define CAN2_ID33                                CAN_ID_REG(CAN2_BASE_PTR,33)
#define CAN2_WORD033                             CAN_WORD0_REG(CAN2_BASE_PTR,33)
#define CAN2_WORD133                             CAN_WORD1_REG(CAN2_BASE_PTR,33)
#define CAN2_CS34                                CAN_CS_REG(CAN2_BASE_PTR,34)
#define CAN2_ID34                                CAN_ID_REG(CAN2_BASE_PTR,34)
#define CAN2_WORD034                             CAN_WORD0_REG(CAN2_BASE_PTR,34)
#define CAN2_WORD134                             CAN_WORD1_REG(CAN2_BASE_PTR,34)
#define CAN2_CS35                                CAN_CS_REG(CAN2_BASE_PTR,35)
#define CAN2_ID35                                CAN_ID_REG(CAN2_BASE_PTR,35)
#define CAN2_WORD035                             CAN_WORD0_REG(CAN2_BASE_PTR,35)
#define CAN2_WORD135                             CAN_WORD1_REG(CAN2_BASE_PTR,35)
#define CAN2_CS36                                CAN_CS_REG(CAN2_BASE_PTR,36)
#define CAN2_ID36                                CAN_ID_REG(CAN2_BASE_PTR,36)
#define CAN2_WORD036                             CAN_WORD0_REG(CAN2_BASE_PTR,36)
#define CAN2_WORD136                             CAN_WORD1_REG(CAN2_BASE_PTR,36)
#define CAN2_CS37                                CAN_CS_REG(CAN2_BASE_PTR,37)
#define CAN2_ID37                                CAN_ID_REG(CAN2_BASE_PTR,37)
#define CAN2_WORD037                             CAN_WORD0_REG(CAN2_BASE_PTR,37)
#define CAN2_WORD137                             CAN_WORD1_REG(CAN2_BASE_PTR,37)
#define CAN2_CS38                                CAN_CS_REG(CAN2_BASE_PTR,38)
#define CAN2_ID38                                CAN_ID_REG(CAN2_BASE_PTR,38)
#define CAN2_WORD038                             CAN_WORD0_REG(CAN2_BASE_PTR,38)
#define CAN2_WORD138                             CAN_WORD1_REG(CAN2_BASE_PTR,38)
#define CAN2_CS39                                CAN_CS_REG(CAN2_BASE_PTR,39)
#define CAN2_ID39                                CAN_ID_REG(CAN2_BASE_PTR,39)
#define CAN2_WORD039                             CAN_WORD0_REG(CAN2_BASE_PTR,39)
#define CAN2_WORD139                             CAN_WORD1_REG(CAN2_BASE_PTR,39)
#define CAN2_CS40                                CAN_CS_REG(CAN2_BASE_PTR,40)
#define CAN2_ID40                                CAN_ID_REG(CAN2_BASE_PTR,40)
#define CAN2_WORD040                             CAN_WORD0_REG(CAN2_BASE_PTR,40)
#define CAN2_WORD140                             CAN_WORD1_REG(CAN2_BASE_PTR,40)
#define CAN2_CS41                                CAN_CS_REG(CAN2_BASE_PTR,41)
#define CAN2_ID41                                CAN_ID_REG(CAN2_BASE_PTR,41)
#define CAN2_WORD041                             CAN_WORD0_REG(CAN2_BASE_PTR,41)
#define CAN2_WORD141                             CAN_WORD1_REG(CAN2_BASE_PTR,41)
#define CAN2_CS42                                CAN_CS_REG(CAN2_BASE_PTR,42)
#define CAN2_ID42                                CAN_ID_REG(CAN2_BASE_PTR,42)
#define CAN2_WORD042                             CAN_WORD0_REG(CAN2_BASE_PTR,42)
#define CAN2_WORD142                             CAN_WORD1_REG(CAN2_BASE_PTR,42)
#define CAN2_CS43                                CAN_CS_REG(CAN2_BASE_PTR,43)
#define CAN2_ID43                                CAN_ID_REG(CAN2_BASE_PTR,43)
#define CAN2_WORD043                             CAN_WORD0_REG(CAN2_BASE_PTR,43)
#define CAN2_WORD143                             CAN_WORD1_REG(CAN2_BASE_PTR,43)
#define CAN2_CS44                                CAN_CS_REG(CAN2_BASE_PTR,44)
#define CAN2_ID44                                CAN_ID_REG(CAN2_BASE_PTR,44)
#define CAN2_WORD044                             CAN_WORD0_REG(CAN2_BASE_PTR,44)
#define CAN2_WORD144                             CAN_WORD1_REG(CAN2_BASE_PTR,44)
#define CAN2_CS45                                CAN_CS_REG(CAN2_BASE_PTR,45)
#define CAN2_ID45                                CAN_ID_REG(CAN2_BASE_PTR,45)
#define CAN2_WORD045                             CAN_WORD0_REG(CAN2_BASE_PTR,45)
#define CAN2_WORD145                             CAN_WORD1_REG(CAN2_BASE_PTR,45)
#define CAN2_CS46                                CAN_CS_REG(CAN2_BASE_PTR,46)
#define CAN2_ID46                                CAN_ID_REG(CAN2_BASE_PTR,46)
#define CAN2_WORD046                             CAN_WORD0_REG(CAN2_BASE_PTR,46)
#define CAN2_WORD146                             CAN_WORD1_REG(CAN2_BASE_PTR,46)
#define CAN2_CS47                                CAN_CS_REG(CAN2_BASE_PTR,47)
#define CAN2_ID47                                CAN_ID_REG(CAN2_BASE_PTR,47)
#define CAN2_WORD047                             CAN_WORD0_REG(CAN2_BASE_PTR,47)
#define CAN2_WORD147                             CAN_WORD1_REG(CAN2_BASE_PTR,47)
#define CAN2_CS48                                CAN_CS_REG(CAN2_BASE_PTR,48)
#define CAN2_ID48                                CAN_ID_REG(CAN2_BASE_PTR,48)
#define CAN2_WORD048                             CAN_WORD0_REG(CAN2_BASE_PTR,48)
#define CAN2_WORD148                             CAN_WORD1_REG(CAN2_BASE_PTR,48)
#define CAN2_CS49                                CAN_CS_REG(CAN2_BASE_PTR,49)
#define CAN2_ID49                                CAN_ID_REG(CAN2_BASE_PTR,49)
#define CAN2_WORD049                             CAN_WORD0_REG(CAN2_BASE_PTR,49)
#define CAN2_WORD149                             CAN_WORD1_REG(CAN2_BASE_PTR,49)
#define CAN2_CS50                                CAN_CS_REG(CAN2_BASE_PTR,50)
#define CAN2_ID50                                CAN_ID_REG(CAN2_BASE_PTR,50)
#define CAN2_WORD050                             CAN_WORD0_REG(CAN2_BASE_PTR,50)
#define CAN2_WORD150                             CAN_WORD1_REG(CAN2_BASE_PTR,50)
#define CAN2_CS51                                CAN_CS_REG(CAN2_BASE_PTR,51)
#define CAN2_ID51                                CAN_ID_REG(CAN2_BASE_PTR,51)
#define CAN2_WORD051                             CAN_WORD0_REG(CAN2_BASE_PTR,51)
#define CAN2_WORD151                             CAN_WORD1_REG(CAN2_BASE_PTR,51)
#define CAN2_CS52                                CAN_CS_REG(CAN2_BASE_PTR,52)
#define CAN2_ID52                                CAN_ID_REG(CAN2_BASE_PTR,52)
#define CAN2_WORD052                             CAN_WORD0_REG(CAN2_BASE_PTR,52)
#define CAN2_WORD152                             CAN_WORD1_REG(CAN2_BASE_PTR,52)
#define CAN2_CS53                                CAN_CS_REG(CAN2_BASE_PTR,53)
#define CAN2_ID53                                CAN_ID_REG(CAN2_BASE_PTR,53)
#define CAN2_WORD053                             CAN_WORD0_REG(CAN2_BASE_PTR,53)
#define CAN2_WORD153                             CAN_WORD1_REG(CAN2_BASE_PTR,53)
#define CAN2_CS54                                CAN_CS_REG(CAN2_BASE_PTR,54)
#define CAN2_ID54                                CAN_ID_REG(CAN2_BASE_PTR,54)
#define CAN2_WORD054                             CAN_WORD0_REG(CAN2_BASE_PTR,54)
#define CAN2_WORD154                             CAN_WORD1_REG(CAN2_BASE_PTR,54)
#define CAN2_CS55                                CAN_CS_REG(CAN2_BASE_PTR,55)
#define CAN2_ID55                                CAN_ID_REG(CAN2_BASE_PTR,55)
#define CAN2_WORD055                             CAN_WORD0_REG(CAN2_BASE_PTR,55)
#define CAN2_WORD155                             CAN_WORD1_REG(CAN2_BASE_PTR,55)
#define CAN2_CS56                                CAN_CS_REG(CAN2_BASE_PTR,56)
#define CAN2_ID56                                CAN_ID_REG(CAN2_BASE_PTR,56)
#define CAN2_WORD056                             CAN_WORD0_REG(CAN2_BASE_PTR,56)
#define CAN2_WORD156                             CAN_WORD1_REG(CAN2_BASE_PTR,56)
#define CAN2_CS57                                CAN_CS_REG(CAN2_BASE_PTR,57)
#define CAN2_ID57                                CAN_ID_REG(CAN2_BASE_PTR,57)
#define CAN2_WORD057                             CAN_WORD0_REG(CAN2_BASE_PTR,57)
#define CAN2_WORD157                             CAN_WORD1_REG(CAN2_BASE_PTR,57)
#define CAN2_CS58                                CAN_CS_REG(CAN2_BASE_PTR,58)
#define CAN2_ID58                                CAN_ID_REG(CAN2_BASE_PTR,58)
#define CAN2_WORD058                             CAN_WORD0_REG(CAN2_BASE_PTR,58)
#define CAN2_WORD158                             CAN_WORD1_REG(CAN2_BASE_PTR,58)
#define CAN2_CS59                                CAN_CS_REG(CAN2_BASE_PTR,59)
#define CAN2_ID59                                CAN_ID_REG(CAN2_BASE_PTR,59)
#define CAN2_WORD059                             CAN_WORD0_REG(CAN2_BASE_PTR,59)
#define CAN2_WORD159                             CAN_WORD1_REG(CAN2_BASE_PTR,59)
#define CAN2_CS60                                CAN_CS_REG(CAN2_BASE_PTR,60)
#define CAN2_ID60                                CAN_ID_REG(CAN2_BASE_PTR,60)
#define CAN2_WORD060                             CAN_WORD0_REG(CAN2_BASE_PTR,60)
#define CAN2_WORD160                             CAN_WORD1_REG(CAN2_BASE_PTR,60)
#define CAN2_CS61                                CAN_CS_REG(CAN2_BASE_PTR,61)
#define CAN2_ID61                                CAN_ID_REG(CAN2_BASE_PTR,61)
#define CAN2_WORD061                             CAN_WORD0_REG(CAN2_BASE_PTR,61)
#define CAN2_WORD161                             CAN_WORD1_REG(CAN2_BASE_PTR,61)
#define CAN2_CS62                                CAN_CS_REG(CAN2_BASE_PTR,62)
#define CAN2_ID62                                CAN_ID_REG(CAN2_BASE_PTR,62)
#define CAN2_WORD062                             CAN_WORD0_REG(CAN2_BASE_PTR,62)
#define CAN2_WORD162                             CAN_WORD1_REG(CAN2_BASE_PTR,62)
#define CAN2_CS63                                CAN_CS_REG(CAN2_BASE_PTR,63)
#define CAN2_ID63                                CAN_ID_REG(CAN2_BASE_PTR,63)
#define CAN2_WORD063                             CAN_WORD0_REG(CAN2_BASE_PTR,63)
#define CAN2_WORD163                             CAN_WORD1_REG(CAN2_BASE_PTR,63)
#define CAN2_RXIMR0                              CAN_RXIMR_REG(CAN2_BASE_PTR,0)
#define CAN2_RXIMR1                              CAN_RXIMR_REG(CAN2_BASE_PTR,1)
#define CAN2_RXIMR2                              CAN_RXIMR_REG(CAN2_BASE_PTR,2)
#define CAN2_RXIMR3                              CAN_RXIMR_REG(CAN2_BASE_PTR,3)
#define CAN2_RXIMR4                              CAN_RXIMR_REG(CAN2_BASE_PTR,4)
#define CAN2_RXIMR5                              CAN_RXIMR_REG(CAN2_BASE_PTR,5)
#define CAN2_RXIMR6                              CAN_RXIMR_REG(CAN2_BASE_PTR,6)
#define CAN2_RXIMR7                              CAN_RXIMR_REG(CAN2_BASE_PTR,7)
#define CAN2_RXIMR8                              CAN_RXIMR_REG(CAN2_BASE_PTR,8)
#define CAN2_RXIMR9                              CAN_RXIMR_REG(CAN2_BASE_PTR,9)
#define CAN2_RXIMR10                             CAN_RXIMR_REG(CAN2_BASE_PTR,10)
#define CAN2_RXIMR11                             CAN_RXIMR_REG(CAN2_BASE_PTR,11)
#define CAN2_RXIMR12                             CAN_RXIMR_REG(CAN2_BASE_PTR,12)
#define CAN2_RXIMR13                             CAN_RXIMR_REG(CAN2_BASE_PTR,13)
#define CAN2_RXIMR14                             CAN_RXIMR_REG(CAN2_BASE_PTR,14)
#define CAN2_RXIMR15                             CAN_RXIMR_REG(CAN2_BASE_PTR,15)
#define CAN2_RXIMR16                             CAN_RXIMR_REG(CAN2_BASE_PTR,16)
#define CAN2_RXIMR17                             CAN_RXIMR_REG(CAN2_BASE_PTR,17)
#define CAN2_RXIMR18                             CAN_RXIMR_REG(CAN2_BASE_PTR,18)
#define CAN2_RXIMR19                             CAN_RXIMR_REG(CAN2_BASE_PTR,19)
#define CAN2_RXIMR20                             CAN_RXIMR_REG(CAN2_BASE_PTR,20)
#define CAN2_RXIMR21                             CAN_RXIMR_REG(CAN2_BASE_PTR,21)
#define CAN2_RXIMR22                             CAN_RXIMR_REG(CAN2_BASE_PTR,22)
#define CAN2_RXIMR23                             CAN_RXIMR_REG(CAN2_BASE_PTR,23)
#define CAN2_RXIMR24                             CAN_RXIMR_REG(CAN2_BASE_PTR,24)
#define CAN2_RXIMR25                             CAN_RXIMR_REG(CAN2_BASE_PTR,25)
#define CAN2_RXIMR26                             CAN_RXIMR_REG(CAN2_BASE_PTR,26)
#define CAN2_RXIMR27                             CAN_RXIMR_REG(CAN2_BASE_PTR,27)
#define CAN2_RXIMR28                             CAN_RXIMR_REG(CAN2_BASE_PTR,28)
#define CAN2_RXIMR29                             CAN_RXIMR_REG(CAN2_BASE_PTR,29)
#define CAN2_RXIMR30                             CAN_RXIMR_REG(CAN2_BASE_PTR,30)
#define CAN2_RXIMR31                             CAN_RXIMR_REG(CAN2_BASE_PTR,31)
#define CAN2_RXIMR32                             CAN_RXIMR_REG(CAN2_BASE_PTR,32)
#define CAN2_RXIMR33                             CAN_RXIMR_REG(CAN2_BASE_PTR,33)
#define CAN2_RXIMR34                             CAN_RXIMR_REG(CAN2_BASE_PTR,34)
#define CAN2_RXIMR35                             CAN_RXIMR_REG(CAN2_BASE_PTR,35)
#define CAN2_RXIMR36                             CAN_RXIMR_REG(CAN2_BASE_PTR,36)
#define CAN2_RXIMR37                             CAN_RXIMR_REG(CAN2_BASE_PTR,37)
#define CAN2_RXIMR38                             CAN_RXIMR_REG(CAN2_BASE_PTR,38)
#define CAN2_RXIMR39                             CAN_RXIMR_REG(CAN2_BASE_PTR,39)
#define CAN2_RXIMR40                             CAN_RXIMR_REG(CAN2_BASE_PTR,40)
#define CAN2_RXIMR41                             CAN_RXIMR_REG(CAN2_BASE_PTR,41)
#define CAN2_RXIMR42                             CAN_RXIMR_REG(CAN2_BASE_PTR,42)
#define CAN2_RXIMR43                             CAN_RXIMR_REG(CAN2_BASE_PTR,43)
#define CAN2_RXIMR44                             CAN_RXIMR_REG(CAN2_BASE_PTR,44)
#define CAN2_RXIMR45                             CAN_RXIMR_REG(CAN2_BASE_PTR,45)
#define CAN2_RXIMR46                             CAN_RXIMR_REG(CAN2_BASE_PTR,46)
#define CAN2_RXIMR47                             CAN_RXIMR_REG(CAN2_BASE_PTR,47)
#define CAN2_RXIMR48                             CAN_RXIMR_REG(CAN2_BASE_PTR,48)
#define CAN2_RXIMR49                             CAN_RXIMR_REG(CAN2_BASE_PTR,49)
#define CAN2_RXIMR50                             CAN_RXIMR_REG(CAN2_BASE_PTR,50)
#define CAN2_RXIMR51                             CAN_RXIMR_REG(CAN2_BASE_PTR,51)
#define CAN2_RXIMR52                             CAN_RXIMR_REG(CAN2_BASE_PTR,52)
#define CAN2_RXIMR53                             CAN_RXIMR_REG(CAN2_BASE_PTR,53)
#define CAN2_RXIMR54                             CAN_RXIMR_REG(CAN2_BASE_PTR,54)
#define CAN2_RXIMR55                             CAN_RXIMR_REG(CAN2_BASE_PTR,55)
#define CAN2_RXIMR56                             CAN_RXIMR_REG(CAN2_BASE_PTR,56)
#define CAN2_RXIMR57                             CAN_RXIMR_REG(CAN2_BASE_PTR,57)
#define CAN2_RXIMR58                             CAN_RXIMR_REG(CAN2_BASE_PTR,58)
#define CAN2_RXIMR59                             CAN_RXIMR_REG(CAN2_BASE_PTR,59)
#define CAN2_RXIMR60                             CAN_RXIMR_REG(CAN2_BASE_PTR,60)
#define CAN2_RXIMR61                             CAN_RXIMR_REG(CAN2_BASE_PTR,61)
#define CAN2_RXIMR62                             CAN_RXIMR_REG(CAN2_BASE_PTR,62)
#define CAN2_RXIMR63                             CAN_RXIMR_REG(CAN2_BASE_PTR,63)
#define CAN2_GFWR                                CAN_GFWR_REG(CAN2_BASE_PTR)

/* CAN - Register array accessors */
#define CAN1_CS(index)                           CAN_CS_REG(CAN1_BASE_PTR,index)
#define CAN2_CS(index)                           CAN_CS_REG(CAN2_BASE_PTR,index)
#define CAN1_ID(index)                           CAN_ID_REG(CAN1_BASE_PTR,index)
#define CAN2_ID(index)                           CAN_ID_REG(CAN2_BASE_PTR,index)
#define CAN1_WORD0(index)                        CAN_WORD0_REG(CAN1_BASE_PTR,index)
#define CAN2_WORD0(index)                        CAN_WORD0_REG(CAN2_BASE_PTR,index)
#define CAN1_WORD1(index)                        CAN_WORD1_REG(CAN1_BASE_PTR,index)
#define CAN2_WORD1(index)                        CAN_WORD1_REG(CAN2_BASE_PTR,index)
#define CAN1_RXIMR(index)                        CAN_RXIMR_REG(CAN1_BASE_PTR,index)
#define CAN2_RXIMR(index)                        CAN_RXIMR_REG(CAN2_BASE_PTR,index)

/*!
 * @}
 */ /* end of group CAN_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CAN_Peripheral */


/* ----------------------------------------------------------------------------
   -- CCM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Peripheral CCM
 * @{
 */

/** CCM - Peripheral register structure */
typedef struct CCM_MemMap {
  uint32_t CCR;                                    /**< CCM Control Register, offset: 0x0 */
  uint32_t CCDR;                                   /**< CCM Control Divider Register, offset: 0x4 */
  uint32_t CSR;                                    /**< CCM Status Register, offset: 0x8 */
  uint32_t CCSR;                                   /**< CCM Clock Switcher Register, offset: 0xC */
  uint32_t CACRR;                                  /**< CCM Arm Clock Root Register, offset: 0x10 */
  uint32_t CBCDR;                                  /**< CCM Bus Clock Divider Register, offset: 0x14 */
  uint32_t CBCMR;                                  /**< CCM Bus Clock Multiplexer Register, offset: 0x18 */
  uint32_t CSCMR1;                                 /**< CCM Serial Clock Multiplexer Register 1, offset: 0x1C */
  uint32_t CSCMR2;                                 /**< CCM Serial Clock Multiplexer Register 2, offset: 0x20 */
  uint32_t CSCDR1;                                 /**< CCM Serial Clock Divider Register 1, offset: 0x24 */
  uint32_t CS1CDR;                                 /**< CCM SSI1 Clock Divider Register, offset: 0x28 */
  uint32_t CS2CDR;                                 /**< CCM SSI2 Clock Divider Register, offset: 0x2C */
  uint32_t CDCDR;                                  /**< CCM D1 Clock Divider Register, offset: 0x30 */
  uint32_t CHSCCDR;                                /**< CCM HSC Clock Divider Register, offset: 0x34 */
  uint32_t CSCDR2;                                 /**< CCM Serial Clock Divider Register 2, offset: 0x38 */
  uint32_t CSCDR3;                                 /**< CCM Serial Clock Divider Register 3, offset: 0x3C */
  uint8_t RESERVED_0[4];
  uint32_t CWDR;                                   /**< CCM Wakeup Detector Register, offset: 0x44 */
  uint32_t CDHIPR;                                 /**< CCM Divider Handshake In-Process Register, offset: 0x48 */
  uint8_t RESERVED_1[8];
  uint32_t CLPCR;                                  /**< CCM Low Power Control Register, offset: 0x54 */
  uint32_t CISR;                                   /**< CCM Interrupt Status Register, offset: 0x58 */
  uint32_t CIMR;                                   /**< CCM Interrupt Mask Register, offset: 0x5C */
  uint32_t CCOSR;                                  /**< CCM Clock Output Source Register, offset: 0x60 */
  uint32_t CGPR;                                   /**< CCM General Purpose Register, offset: 0x64 */
  uint32_t CCGR0;                                  /**< CCM Clock Gating Register 0, offset: 0x68 */
  uint32_t CCGR1;                                  /**< CCM Clock Gating Register 1, offset: 0x6C */
  uint32_t CCGR2;                                  /**< CCM Clock Gating Register 2, offset: 0x70 */
  uint32_t CCGR3;                                  /**< CCM Clock Gating Register 3, offset: 0x74 */
  uint32_t CCGR4;                                  /**< CCM Clock Gating Register 4, offset: 0x78 */
  uint32_t CCGR5;                                  /**< CCM Clock Gating Register 5, offset: 0x7C */
  uint32_t CCGR6;                                  /**< CCM Clock Gating Register 6, offset: 0x80 */
  uint8_t RESERVED_2[4];
  uint32_t CMEOR;                                  /**< CCM Module Enable Overide Register, offset: 0x88 */
} volatile *CCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Register_Accessor_Macros CCM - Register accessor macros
 * @{
 */


/* CCM - Register accessors */
#define CCM_CCR_REG(base)                        ((base)->CCR)
#define CCM_CCDR_REG(base)                       ((base)->CCDR)
#define CCM_CSR_REG(base)                        ((base)->CSR)
#define CCM_CCSR_REG(base)                       ((base)->CCSR)
#define CCM_CACRR_REG(base)                      ((base)->CACRR)
#define CCM_CBCDR_REG(base)                      ((base)->CBCDR)
#define CCM_CBCMR_REG(base)                      ((base)->CBCMR)
#define CCM_CSCMR1_REG(base)                     ((base)->CSCMR1)
#define CCM_CSCMR2_REG(base)                     ((base)->CSCMR2)
#define CCM_CSCDR1_REG(base)                     ((base)->CSCDR1)
#define CCM_CS1CDR_REG(base)                     ((base)->CS1CDR)
#define CCM_CS2CDR_REG(base)                     ((base)->CS2CDR)
#define CCM_CDCDR_REG(base)                      ((base)->CDCDR)
#define CCM_CHSCCDR_REG(base)                    ((base)->CHSCCDR)
#define CCM_CSCDR2_REG(base)                     ((base)->CSCDR2)
#define CCM_CSCDR3_REG(base)                     ((base)->CSCDR3)
#define CCM_CWDR_REG(base)                       ((base)->CWDR)
#define CCM_CDHIPR_REG(base)                     ((base)->CDHIPR)
#define CCM_CLPCR_REG(base)                      ((base)->CLPCR)
#define CCM_CISR_REG(base)                       ((base)->CISR)
#define CCM_CIMR_REG(base)                       ((base)->CIMR)
#define CCM_CCOSR_REG(base)                      ((base)->CCOSR)
#define CCM_CGPR_REG(base)                       ((base)->CGPR)
#define CCM_CCGR0_REG(base)                      ((base)->CCGR0)
#define CCM_CCGR1_REG(base)                      ((base)->CCGR1)
#define CCM_CCGR2_REG(base)                      ((base)->CCGR2)
#define CCM_CCGR3_REG(base)                      ((base)->CCGR3)
#define CCM_CCGR4_REG(base)                      ((base)->CCGR4)
#define CCM_CCGR5_REG(base)                      ((base)->CCGR5)
#define CCM_CCGR6_REG(base)                      ((base)->CCGR6)
#define CCM_CMEOR_REG(base)                      ((base)->CMEOR)

/*!
 * @}
 */ /* end of group CCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Register_Masks CCM Register Masks
 * @{
 */

/* CCR Bit Fields */
#define CCM_CCR_OSCNT_MASK                       0x7Fu
#define CCM_CCR_OSCNT_SHIFT                      0
#define CCM_CCR_OSCNT(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCR_OSCNT_SHIFT))&CCM_CCR_OSCNT_MASK)
#define CCM_CCR_COSC_EN_MASK                     0x1000u
#define CCM_CCR_COSC_EN_SHIFT                    12
#define CCM_CCR_REG_BYPASS_COUNT_MASK            0x7E00000u
#define CCM_CCR_REG_BYPASS_COUNT_SHIFT           21
#define CCM_CCR_REG_BYPASS_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CCR_REG_BYPASS_COUNT_SHIFT))&CCM_CCR_REG_BYPASS_COUNT_MASK)
#define CCM_CCR_RBC_EN_MASK                      0x8000000u
#define CCM_CCR_RBC_EN_SHIFT                     27
/* CCDR Bit Fields */
#define CCM_CCDR_mmdc_mask_MASK                  0x10000u
#define CCM_CCDR_mmdc_mask_SHIFT                 16
/* CSR Bit Fields */
#define CCM_CSR_REF_EN_B_MASK                    0x1u
#define CCM_CSR_REF_EN_B_SHIFT                   0
#define CCM_CSR_cosc_ready_MASK                  0x20u
#define CCM_CSR_cosc_ready_SHIFT                 5
/* CCSR Bit Fields */
#define CCM_CCSR_pll3_sw_clk_sel_MASK            0x1u
#define CCM_CCSR_pll3_sw_clk_sel_SHIFT           0
#define CCM_CCSR_pll1_sw_clk_sel_MASK            0x4u
#define CCM_CCSR_pll1_sw_clk_sel_SHIFT           2
#define CCM_CCSR_step_sel_MASK                   0x100u
#define CCM_CCSR_step_sel_SHIFT                  8
/* CACRR Bit Fields */
#define CCM_CACRR_arm_podf_MASK                  0x7u
#define CCM_CACRR_arm_podf_SHIFT                 0
#define CCM_CACRR_arm_podf(x)                    (((uint32_t)(((uint32_t)(x))<<CCM_CACRR_arm_podf_SHIFT))&CCM_CACRR_arm_podf_MASK)
/* CBCDR Bit Fields */
#define CCM_CBCDR_periph2_clk2_podf_MASK         0x7u
#define CCM_CBCDR_periph2_clk2_podf_SHIFT        0
#define CCM_CBCDR_periph2_clk2_podf(x)           (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_periph2_clk2_podf_SHIFT))&CCM_CBCDR_periph2_clk2_podf_MASK)
#define CCM_CBCDR_fabric_mmdc_podf_MASK          0x38u
#define CCM_CBCDR_fabric_mmdc_podf_SHIFT         3
#define CCM_CBCDR_fabric_mmdc_podf(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_fabric_mmdc_podf_SHIFT))&CCM_CBCDR_fabric_mmdc_podf_MASK)
#define CCM_CBCDR_ocram_clk_sel_MASK             0x40u
#define CCM_CBCDR_ocram_clk_sel_SHIFT            6
#define CCM_CBCDR_ocram_alt_clk_sel_MASK         0x80u
#define CCM_CBCDR_ocram_alt_clk_sel_SHIFT        7
#define CCM_CBCDR_ipg_podf_MASK                  0x300u
#define CCM_CBCDR_ipg_podf_SHIFT                 8
#define CCM_CBCDR_ipg_podf(x)                    (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_ipg_podf_SHIFT))&CCM_CBCDR_ipg_podf_MASK)
#define CCM_CBCDR_ahb_podf_MASK                  0x1C00u
#define CCM_CBCDR_ahb_podf_SHIFT                 10
#define CCM_CBCDR_ahb_podf(x)                    (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_ahb_podf_SHIFT))&CCM_CBCDR_ahb_podf_MASK)
#define CCM_CBCDR_ocram_podf_MASK                0x70000u
#define CCM_CBCDR_ocram_podf_SHIFT               16
#define CCM_CBCDR_ocram_podf(x)                  (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_ocram_podf_SHIFT))&CCM_CBCDR_ocram_podf_MASK)
#define CCM_CBCDR_periph_clk_sel_MASK            0x2000000u
#define CCM_CBCDR_periph_clk_sel_SHIFT           25
#define CCM_CBCDR_periph2_clk_sel_MASK           0x4000000u
#define CCM_CBCDR_periph2_clk_sel_SHIFT          26
#define CCM_CBCDR_periph_clk2_podf_MASK          0x38000000u
#define CCM_CBCDR_periph_clk2_podf_SHIFT         27
#define CCM_CBCDR_periph_clk2_podf(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CBCDR_periph_clk2_podf_SHIFT))&CCM_CBCDR_periph_clk2_podf_MASK)
/* CBCMR Bit Fields */
#define CCM_CBCMR_gpu_core_sel_MASK              0x30u
#define CCM_CBCMR_gpu_core_sel_SHIFT             4
#define CCM_CBCMR_gpu_core_sel(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_gpu_core_sel_SHIFT))&CCM_CBCMR_gpu_core_sel_MASK)
#define CCM_CBCMR_gpu_axi_sel_MASK               0x300u
#define CCM_CBCMR_gpu_axi_sel_SHIFT              8
#define CCM_CBCMR_gpu_axi_sel(x)                 (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_gpu_axi_sel_SHIFT))&CCM_CBCMR_gpu_axi_sel_MASK)
#define CCM_CBCMR_pcie_axi_clk_sel_MASK          0x400u
#define CCM_CBCMR_pcie_axi_clk_sel_SHIFT         10
#define CCM_CBCMR_periph_clk2_sel_MASK           0x3000u
#define CCM_CBCMR_periph_clk2_sel_SHIFT          12
#define CCM_CBCMR_periph_clk2_sel(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_periph_clk2_sel_SHIFT))&CCM_CBCMR_periph_clk2_sel_MASK)
#define CCM_CBCMR_pre_periph_clk_sel_MASK        0xC0000u
#define CCM_CBCMR_pre_periph_clk_sel_SHIFT       18
#define CCM_CBCMR_pre_periph_clk_sel(x)          (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_pre_periph_clk_sel_SHIFT))&CCM_CBCMR_pre_periph_clk_sel_MASK)
#define CCM_CBCMR_periph2_clk2_sel_MASK          0x100000u
#define CCM_CBCMR_periph2_clk2_sel_SHIFT         20
#define CCM_CBCMR_pre_periph2_clk_sel_MASK       0x600000u
#define CCM_CBCMR_pre_periph2_clk_sel_SHIFT      21
#define CCM_CBCMR_pre_periph2_clk_sel(x)         (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_pre_periph2_clk_sel_SHIFT))&CCM_CBCMR_pre_periph2_clk_sel_MASK)
#define CCM_CBCMR_lcdif1_podf_MASK               0x3800000u
#define CCM_CBCMR_lcdif1_podf_SHIFT              23
#define CCM_CBCMR_lcdif1_podf(x)                 (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_lcdif1_podf_SHIFT))&CCM_CBCMR_lcdif1_podf_MASK)
#define CCM_CBCMR_gpu_axi_podf_MASK              0x1C000000u
#define CCM_CBCMR_gpu_axi_podf_SHIFT             26
#define CCM_CBCMR_gpu_axi_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_gpu_axi_podf_SHIFT))&CCM_CBCMR_gpu_axi_podf_MASK)
#define CCM_CBCMR_gpu_core_podf_MASK             0xE0000000u
#define CCM_CBCMR_gpu_core_podf_SHIFT            29
#define CCM_CBCMR_gpu_core_podf(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CBCMR_gpu_core_podf_SHIFT))&CCM_CBCMR_gpu_core_podf_MASK)
/* CSCMR1 Bit Fields */
#define CCM_CSCMR1_perclk_podf_MASK              0x3Fu
#define CCM_CSCMR1_perclk_podf_SHIFT             0
#define CCM_CSCMR1_perclk_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_perclk_podf_SHIFT))&CCM_CSCMR1_perclk_podf_MASK)
#define CCM_CSCMR1_perclk_clk_sel_MASK           0x40u
#define CCM_CSCMR1_perclk_clk_sel_SHIFT          6
#define CCM_CSCMR1_qspi1_sel_MASK                0x380u
#define CCM_CSCMR1_qspi1_sel_SHIFT               7
#define CCM_CSCMR1_qspi1_sel(x)                  (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_qspi1_sel_SHIFT))&CCM_CSCMR1_qspi1_sel_MASK)
#define CCM_CSCMR1_ssi1_clk_sel_MASK             0xC00u
#define CCM_CSCMR1_ssi1_clk_sel_SHIFT            10
#define CCM_CSCMR1_ssi1_clk_sel(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_ssi1_clk_sel_SHIFT))&CCM_CSCMR1_ssi1_clk_sel_MASK)
#define CCM_CSCMR1_ssi2_clk_sel_MASK             0x3000u
#define CCM_CSCMR1_ssi2_clk_sel_SHIFT            12
#define CCM_CSCMR1_ssi2_clk_sel(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_ssi2_clk_sel_SHIFT))&CCM_CSCMR1_ssi2_clk_sel_MASK)
#define CCM_CSCMR1_ssi3_clk_sel_MASK             0xC000u
#define CCM_CSCMR1_ssi3_clk_sel_SHIFT            14
#define CCM_CSCMR1_ssi3_clk_sel(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_ssi3_clk_sel_SHIFT))&CCM_CSCMR1_ssi3_clk_sel_MASK)
#define CCM_CSCMR1_usdhc1_clk_sel_MASK           0x10000u
#define CCM_CSCMR1_usdhc1_clk_sel_SHIFT          16
#define CCM_CSCMR1_usdhc2_clk_sel_MASK           0x20000u
#define CCM_CSCMR1_usdhc2_clk_sel_SHIFT          17
#define CCM_CSCMR1_usdhc3_clk_sel_MASK           0x40000u
#define CCM_CSCMR1_usdhc3_clk_sel_SHIFT          18
#define CCM_CSCMR1_usdhc4_clk_sel_MASK           0x80000u
#define CCM_CSCMR1_usdhc4_clk_sel_SHIFT          19
#define CCM_CSCMR1_lcdif2_podf_MASK              0x700000u
#define CCM_CSCMR1_lcdif2_podf_SHIFT             20
#define CCM_CSCMR1_lcdif2_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_lcdif2_podf_SHIFT))&CCM_CSCMR1_lcdif2_podf_MASK)
#define CCM_CSCMR1_aclk_eim_slow_podf_MASK       0x3800000u
#define CCM_CSCMR1_aclk_eim_slow_podf_SHIFT      23
#define CCM_CSCMR1_aclk_eim_slow_podf(x)         (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_aclk_eim_slow_podf_SHIFT))&CCM_CSCMR1_aclk_eim_slow_podf_MASK)
#define CCM_CSCMR1_qspi1_podf_MASK               0x1C000000u
#define CCM_CSCMR1_qspi1_podf_SHIFT              26
#define CCM_CSCMR1_qspi1_podf(x)                 (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_qspi1_podf_SHIFT))&CCM_CSCMR1_qspi1_podf_MASK)
#define CCM_CSCMR1_aclk_eim_slow_sel_MASK        0x60000000u
#define CCM_CSCMR1_aclk_eim_slow_sel_SHIFT       29
#define CCM_CSCMR1_aclk_eim_slow_sel(x)          (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR1_aclk_eim_slow_sel_SHIFT))&CCM_CSCMR1_aclk_eim_slow_sel_MASK)
/* CSCMR2 Bit Fields */
#define CCM_CSCMR2_can_clk_podf_MASK             0xFCu
#define CCM_CSCMR2_can_clk_podf_SHIFT            2
#define CCM_CSCMR2_can_clk_podf(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_can_clk_podf_SHIFT))&CCM_CSCMR2_can_clk_podf_MASK)
#define CCM_CSCMR2_can_clk_sel_MASK              0x300u
#define CCM_CSCMR2_can_clk_sel_SHIFT             8
#define CCM_CSCMR2_can_clk_sel(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_can_clk_sel_SHIFT))&CCM_CSCMR2_can_clk_sel_MASK)
#define CCM_CSCMR2_ldb_di0_div_MASK              0x400u
#define CCM_CSCMR2_ldb_di0_div_SHIFT             10
#define CCM_CSCMR2_ldb_di1_div_MASK              0x800u
#define CCM_CSCMR2_ldb_di1_div_SHIFT             11
#define CCM_CSCMR2_esai_clk_sel_MASK             0x180000u
#define CCM_CSCMR2_esai_clk_sel_SHIFT            19
#define CCM_CSCMR2_esai_clk_sel(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_esai_clk_sel_SHIFT))&CCM_CSCMR2_esai_clk_sel_MASK)
#define CCM_CSCMR2_vid_clk_sel_MASK              0xE00000u
#define CCM_CSCMR2_vid_clk_sel_SHIFT             21
#define CCM_CSCMR2_vid_clk_sel(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_vid_clk_sel_SHIFT))&CCM_CSCMR2_vid_clk_sel_MASK)
#define CCM_CSCMR2_vid_clk_pre_podf_MASK         0x3000000u
#define CCM_CSCMR2_vid_clk_pre_podf_SHIFT        24
#define CCM_CSCMR2_vid_clk_pre_podf(x)           (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_vid_clk_pre_podf_SHIFT))&CCM_CSCMR2_vid_clk_pre_podf_MASK)
#define CCM_CSCMR2_vid_clk_podf_MASK             0x1C000000u
#define CCM_CSCMR2_vid_clk_podf_SHIFT            26
#define CCM_CSCMR2_vid_clk_podf(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCMR2_vid_clk_podf_SHIFT))&CCM_CSCMR2_vid_clk_podf_MASK)
/* CSCDR1 Bit Fields */
#define CCM_CSCDR1_uart_clk_podf_MASK            0x3Fu
#define CCM_CSCDR1_uart_clk_podf_SHIFT           0
#define CCM_CSCDR1_uart_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR1_uart_clk_podf_SHIFT))&CCM_CSCDR1_uart_clk_podf_MASK)
#define CCM_CSCDR1_uart_clk_sel_MASK             0x40u
#define CCM_CSCDR1_uart_clk_sel_SHIFT            6
#define CCM_CSCDR1_usdhc1_podf_MASK              0x3800u
#define CCM_CSCDR1_usdhc1_podf_SHIFT             11
#define CCM_CSCDR1_usdhc1_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR1_usdhc1_podf_SHIFT))&CCM_CSCDR1_usdhc1_podf_MASK)
#define CCM_CSCDR1_usdhc2_podf_MASK              0x70000u
#define CCM_CSCDR1_usdhc2_podf_SHIFT             16
#define CCM_CSCDR1_usdhc2_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR1_usdhc2_podf_SHIFT))&CCM_CSCDR1_usdhc2_podf_MASK)
#define CCM_CSCDR1_usdhc3_podf_MASK              0x380000u
#define CCM_CSCDR1_usdhc3_podf_SHIFT             19
#define CCM_CSCDR1_usdhc3_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR1_usdhc3_podf_SHIFT))&CCM_CSCDR1_usdhc3_podf_MASK)
#define CCM_CSCDR1_usdhc4_podf_MASK              0x1C00000u
#define CCM_CSCDR1_usdhc4_podf_SHIFT             22
#define CCM_CSCDR1_usdhc4_podf(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR1_usdhc4_podf_SHIFT))&CCM_CSCDR1_usdhc4_podf_MASK)
/* CS1CDR Bit Fields */
#define CCM_CS1CDR_ssi1_clk_podf_MASK            0x3Fu
#define CCM_CS1CDR_ssi1_clk_podf_SHIFT           0
#define CCM_CS1CDR_ssi1_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_ssi1_clk_podf_SHIFT))&CCM_CS1CDR_ssi1_clk_podf_MASK)
#define CCM_CS1CDR_ssi1_clk_pred_MASK            0x1C0u
#define CCM_CS1CDR_ssi1_clk_pred_SHIFT           6
#define CCM_CS1CDR_ssi1_clk_pred(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_ssi1_clk_pred_SHIFT))&CCM_CS1CDR_ssi1_clk_pred_MASK)
#define CCM_CS1CDR_esai_clk_pred_MASK            0xE00u
#define CCM_CS1CDR_esai_clk_pred_SHIFT           9
#define CCM_CS1CDR_esai_clk_pred(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_esai_clk_pred_SHIFT))&CCM_CS1CDR_esai_clk_pred_MASK)
#define CCM_CS1CDR_ssi3_clk_podf_MASK            0x3F0000u
#define CCM_CS1CDR_ssi3_clk_podf_SHIFT           16
#define CCM_CS1CDR_ssi3_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_ssi3_clk_podf_SHIFT))&CCM_CS1CDR_ssi3_clk_podf_MASK)
#define CCM_CS1CDR_ssi3_clk_pred_MASK            0x1C00000u
#define CCM_CS1CDR_ssi3_clk_pred_SHIFT           22
#define CCM_CS1CDR_ssi3_clk_pred(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_ssi3_clk_pred_SHIFT))&CCM_CS1CDR_ssi3_clk_pred_MASK)
#define CCM_CS1CDR_esai_clk_podf_MASK            0xE000000u
#define CCM_CS1CDR_esai_clk_podf_SHIFT           25
#define CCM_CS1CDR_esai_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS1CDR_esai_clk_podf_SHIFT))&CCM_CS1CDR_esai_clk_podf_MASK)
/* CS2CDR Bit Fields */
#define CCM_CS2CDR_ssi2_clk_podf_MASK            0x3Fu
#define CCM_CS2CDR_ssi2_clk_podf_SHIFT           0
#define CCM_CS2CDR_ssi2_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_ssi2_clk_podf_SHIFT))&CCM_CS2CDR_ssi2_clk_podf_MASK)
#define CCM_CS2CDR_ssi2_clk_pred_MASK            0x1C0u
#define CCM_CS2CDR_ssi2_clk_pred_SHIFT           6
#define CCM_CS2CDR_ssi2_clk_pred(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_ssi2_clk_pred_SHIFT))&CCM_CS2CDR_ssi2_clk_pred_MASK)
#define CCM_CS2CDR_ldb_di0_clk_sel_MASK          0xE00u
#define CCM_CS2CDR_ldb_di0_clk_sel_SHIFT         9
#define CCM_CS2CDR_ldb_di0_clk_sel(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_ldb_di0_clk_sel_SHIFT))&CCM_CS2CDR_ldb_di0_clk_sel_MASK)
#define CCM_CS2CDR_ldb_di1_clk_sel_MASK          0x7000u
#define CCM_CS2CDR_ldb_di1_clk_sel_SHIFT         12
#define CCM_CS2CDR_ldb_di1_clk_sel(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_ldb_di1_clk_sel_SHIFT))&CCM_CS2CDR_ldb_di1_clk_sel_MASK)
#define CCM_CS2CDR_qspi2_clk_sel_MASK            0x38000u
#define CCM_CS2CDR_qspi2_clk_sel_SHIFT           15
#define CCM_CS2CDR_qspi2_clk_sel(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_qspi2_clk_sel_SHIFT))&CCM_CS2CDR_qspi2_clk_sel_MASK)
#define CCM_CS2CDR_qspi2_clk_pred_MASK           0x1C0000u
#define CCM_CS2CDR_qspi2_clk_pred_SHIFT          18
#define CCM_CS2CDR_qspi2_clk_pred(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_qspi2_clk_pred_SHIFT))&CCM_CS2CDR_qspi2_clk_pred_MASK)
#define CCM_CS2CDR_qspi2_clk_podf_MASK           0x7E00000u
#define CCM_CS2CDR_qspi2_clk_podf_SHIFT          21
#define CCM_CS2CDR_qspi2_clk_podf(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CS2CDR_qspi2_clk_podf_SHIFT))&CCM_CS2CDR_qspi2_clk_podf_MASK)
/* CDCDR Bit Fields */
#define CCM_CDCDR_audio_clk_sel_MASK             0x180u
#define CCM_CDCDR_audio_clk_sel_SHIFT            7
#define CCM_CDCDR_audio_clk_sel(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_audio_clk_sel_SHIFT))&CCM_CDCDR_audio_clk_sel_MASK)
#define CCM_CDCDR_audio_clk_podf_MASK            0xE00u
#define CCM_CDCDR_audio_clk_podf_SHIFT           9
#define CCM_CDCDR_audio_clk_podf(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_audio_clk_podf_SHIFT))&CCM_CDCDR_audio_clk_podf_MASK)
#define CCM_CDCDR_audio_clk_pred_MASK            0x7000u
#define CCM_CDCDR_audio_clk_pred_SHIFT           12
#define CCM_CDCDR_audio_clk_pred(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_audio_clk_pred_SHIFT))&CCM_CDCDR_audio_clk_pred_MASK)
#define CCM_CDCDR_spdif0_clk_sel_MASK            0x300000u
#define CCM_CDCDR_spdif0_clk_sel_SHIFT           20
#define CCM_CDCDR_spdif0_clk_sel(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_spdif0_clk_sel_SHIFT))&CCM_CDCDR_spdif0_clk_sel_MASK)
#define CCM_CDCDR_spdif0_clk_podf_MASK           0x1C00000u
#define CCM_CDCDR_spdif0_clk_podf_SHIFT          22
#define CCM_CDCDR_spdif0_clk_podf(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_spdif0_clk_podf_SHIFT))&CCM_CDCDR_spdif0_clk_podf_MASK)
#define CCM_CDCDR_spdif0_clk_pred_MASK           0xE000000u
#define CCM_CDCDR_spdif0_clk_pred_SHIFT          25
#define CCM_CDCDR_spdif0_clk_pred(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CDCDR_spdif0_clk_pred_SHIFT))&CCM_CDCDR_spdif0_clk_pred_MASK)
/* CHSCCDR Bit Fields */
#define CCM_CHSCCDR_m4_clk_sel_MASK              0x7u
#define CCM_CHSCCDR_m4_clk_sel_SHIFT             0
#define CCM_CHSCCDR_m4_clk_sel(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_m4_clk_sel_SHIFT))&CCM_CHSCCDR_m4_clk_sel_MASK)
#define CCM_CHSCCDR_m4_podf_MASK                 0x38u
#define CCM_CHSCCDR_m4_podf_SHIFT                3
#define CCM_CHSCCDR_m4_podf(x)                   (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_m4_podf_SHIFT))&CCM_CHSCCDR_m4_podf_MASK)
#define CCM_CHSCCDR_m4_pre_clk_sel_MASK          0x1C0u
#define CCM_CHSCCDR_m4_pre_clk_sel_SHIFT         6
#define CCM_CHSCCDR_m4_pre_clk_sel(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_m4_pre_clk_sel_SHIFT))&CCM_CHSCCDR_m4_pre_clk_sel_MASK)
#define CCM_CHSCCDR_enet_clk_sel_MASK            0xE00u
#define CCM_CHSCCDR_enet_clk_sel_SHIFT           9
#define CCM_CHSCCDR_enet_clk_sel(x)              (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_enet_clk_sel_SHIFT))&CCM_CHSCCDR_enet_clk_sel_MASK)
#define CCM_CHSCCDR_enet_podf_MASK               0x7000u
#define CCM_CHSCCDR_enet_podf_SHIFT              12
#define CCM_CHSCCDR_enet_podf(x)                 (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_enet_podf_SHIFT))&CCM_CHSCCDR_enet_podf_MASK)
#define CCM_CHSCCDR_enet_pre_clk_sel_MASK        0x38000u
#define CCM_CHSCCDR_enet_pre_clk_sel_SHIFT       15
#define CCM_CHSCCDR_enet_pre_clk_sel(x)          (((uint32_t)(((uint32_t)(x))<<CCM_CHSCCDR_enet_pre_clk_sel_SHIFT))&CCM_CHSCCDR_enet_pre_clk_sel_MASK)
/* CSCDR2 Bit Fields */
#define CCM_CSCDR2_lcdif2_clk_sel_MASK           0x7u
#define CCM_CSCDR2_lcdif2_clk_sel_SHIFT          0
#define CCM_CSCDR2_lcdif2_clk_sel(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif2_clk_sel_SHIFT))&CCM_CSCDR2_lcdif2_clk_sel_MASK)
#define CCM_CSCDR2_lcdif2_pred_MASK              0x38u
#define CCM_CSCDR2_lcdif2_pred_SHIFT             3
#define CCM_CSCDR2_lcdif2_pred(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif2_pred_SHIFT))&CCM_CSCDR2_lcdif2_pred_MASK)
#define CCM_CSCDR2_lcdif2_pre_clk_sel_MASK       0x1C0u
#define CCM_CSCDR2_lcdif2_pre_clk_sel_SHIFT      6
#define CCM_CSCDR2_lcdif2_pre_clk_sel(x)         (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif2_pre_clk_sel_SHIFT))&CCM_CSCDR2_lcdif2_pre_clk_sel_MASK)
#define CCM_CSCDR2_lcdif1_clk_sel_MASK           0xE00u
#define CCM_CSCDR2_lcdif1_clk_sel_SHIFT          9
#define CCM_CSCDR2_lcdif1_clk_sel(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif1_clk_sel_SHIFT))&CCM_CSCDR2_lcdif1_clk_sel_MASK)
#define CCM_CSCDR2_lcdif1_pred_MASK              0x7000u
#define CCM_CSCDR2_lcdif1_pred_SHIFT             12
#define CCM_CSCDR2_lcdif1_pred(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif1_pred_SHIFT))&CCM_CSCDR2_lcdif1_pred_MASK)
#define CCM_CSCDR2_lcdif1_pre_clk_sel_MASK       0x38000u
#define CCM_CSCDR2_lcdif1_pre_clk_sel_SHIFT      15
#define CCM_CSCDR2_lcdif1_pre_clk_sel(x)         (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_lcdif1_pre_clk_sel_SHIFT))&CCM_CSCDR2_lcdif1_pre_clk_sel_MASK)
#define CCM_CSCDR2_ecspi_clk_sel_MASK            0x40000u
#define CCM_CSCDR2_ecspi_clk_sel_SHIFT           18
#define CCM_CSCDR2_ecspi_clk_podf_MASK           0x1F80000u
#define CCM_CSCDR2_ecspi_clk_podf_SHIFT          19
#define CCM_CSCDR2_ecspi_clk_podf(x)             (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR2_ecspi_clk_podf_SHIFT))&CCM_CSCDR2_ecspi_clk_podf_MASK)
/* CSCDR3 Bit Fields */
#define CCM_CSCDR3_csi_clk_sel_MASK              0x600u
#define CCM_CSCDR3_csi_clk_sel_SHIFT             9
#define CCM_CSCDR3_csi_clk_sel(x)                (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR3_csi_clk_sel_SHIFT))&CCM_CSCDR3_csi_clk_sel_MASK)
#define CCM_CSCDR3_csi_podf_MASK                 0x3800u
#define CCM_CSCDR3_csi_podf_SHIFT                11
#define CCM_CSCDR3_csi_podf(x)                   (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR3_csi_podf_SHIFT))&CCM_CSCDR3_csi_podf_MASK)
#define CCM_CSCDR3_display_clk_sel_MASK          0xC000u
#define CCM_CSCDR3_display_clk_sel_SHIFT         14
#define CCM_CSCDR3_display_clk_sel(x)            (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR3_display_clk_sel_SHIFT))&CCM_CSCDR3_display_clk_sel_MASK)
#define CCM_CSCDR3_display_podf_MASK             0x70000u
#define CCM_CSCDR3_display_podf_SHIFT            16
#define CCM_CSCDR3_display_podf(x)               (((uint32_t)(((uint32_t)(x))<<CCM_CSCDR3_display_podf_SHIFT))&CCM_CSCDR3_display_podf_MASK)
/* CDHIPR Bit Fields */
#define CCM_CDHIPR_ocram_podf_busy_MASK          0x1u
#define CCM_CDHIPR_ocram_podf_busy_SHIFT         0
#define CCM_CDHIPR_ahb_podf_busy_MASK            0x2u
#define CCM_CDHIPR_ahb_podf_busy_SHIFT           1
#define CCM_CDHIPR_mmdc_podf_busy_MASK           0x4u
#define CCM_CDHIPR_mmdc_podf_busy_SHIFT          2
#define CCM_CDHIPR_periph2_clk_sel_busy_MASK     0x8u
#define CCM_CDHIPR_periph2_clk_sel_busy_SHIFT    3
#define CCM_CDHIPR_periph_clk_sel_busy_MASK      0x20u
#define CCM_CDHIPR_periph_clk_sel_busy_SHIFT     5
#define CCM_CDHIPR_arm_podf_busy_MASK            0x10000u
#define CCM_CDHIPR_arm_podf_busy_SHIFT           16
/* CLPCR Bit Fields */
#define CCM_CLPCR_LPM_MASK                       0x3u
#define CCM_CLPCR_LPM_SHIFT                      0
#define CCM_CLPCR_LPM(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CLPCR_LPM_SHIFT))&CCM_CLPCR_LPM_MASK)
#define CCM_CLPCR_ARM_clk_dis_on_lpm_MASK        0x20u
#define CCM_CLPCR_ARM_clk_dis_on_lpm_SHIFT       5
#define CCM_CLPCR_SBYOS_MASK                     0x40u
#define CCM_CLPCR_SBYOS_SHIFT                    6
#define CCM_CLPCR_dis_ref_osc_MASK               0x80u
#define CCM_CLPCR_dis_ref_osc_SHIFT              7
#define CCM_CLPCR_VSTBY_MASK                     0x100u
#define CCM_CLPCR_VSTBY_SHIFT                    8
#define CCM_CLPCR_stby_count_MASK                0x600u
#define CCM_CLPCR_stby_count_SHIFT               9
#define CCM_CLPCR_stby_count(x)                  (((uint32_t)(((uint32_t)(x))<<CCM_CLPCR_stby_count_SHIFT))&CCM_CLPCR_stby_count_MASK)
#define CCM_CLPCR_cosc_pwrdown_MASK              0x800u
#define CCM_CLPCR_cosc_pwrdown_SHIFT             11
#define CCM_CLPCR_bypass_mmdc_lpm_hs_MASK        0x200000u
#define CCM_CLPCR_bypass_mmdc_lpm_hs_SHIFT       21
#define CCM_CLPCR_mask_core0_wfi_MASK            0x400000u
#define CCM_CLPCR_mask_core0_wfi_SHIFT           22
#define CCM_CLPCR_mask_scu_idle_MASK             0x4000000u
#define CCM_CLPCR_mask_scu_idle_SHIFT            26
#define CCM_CLPCR_mask_l2cc_idle_MASK            0x8000000u
#define CCM_CLPCR_mask_l2cc_idle_SHIFT           27
/* CISR Bit Fields */
#define CCM_CISR_lrf_pll_MASK                    0x1u
#define CCM_CISR_lrf_pll_SHIFT                   0
#define CCM_CISR_cosc_ready_MASK                 0x40u
#define CCM_CISR_cosc_ready_SHIFT                6
#define CCM_CISR_ocram_podf_loaded_MASK          0x20000u
#define CCM_CISR_ocram_podf_loaded_SHIFT         17
#define CCM_CISR_periph2_clk_sel_loaded_MASK     0x80000u
#define CCM_CISR_periph2_clk_sel_loaded_SHIFT    19
#define CCM_CISR_ahb_podf_loaded_MASK            0x100000u
#define CCM_CISR_ahb_podf_loaded_SHIFT           20
#define CCM_CISR_mmdc_podf_loaded_MASK           0x200000u
#define CCM_CISR_mmdc_podf_loaded_SHIFT          21
#define CCM_CISR_periph_clk_sel_loaded_MASK      0x400000u
#define CCM_CISR_periph_clk_sel_loaded_SHIFT     22
#define CCM_CISR_arm_podf_loaded_MASK            0x4000000u
#define CCM_CISR_arm_podf_loaded_SHIFT           26
/* CIMR Bit Fields */
#define CCM_CIMR_mask_lrf_pll_MASK               0x1u
#define CCM_CIMR_mask_lrf_pll_SHIFT              0
#define CCM_CIMR_mask_cosc_ready_MASK            0x40u
#define CCM_CIMR_mask_cosc_ready_SHIFT           6
#define CCM_CIMR_mask_ocram_podf_loaded_MASK     0x20000u
#define CCM_CIMR_mask_ocram_podf_loaded_SHIFT    17
#define CCM_CIMR_mask_periph2_clk_sel_loaded_MASK 0x80000u
#define CCM_CIMR_mask_periph2_clk_sel_loaded_SHIFT 19
#define CCM_CIMR_mask_ahb_podf_loaded_MASK       0x100000u
#define CCM_CIMR_mask_ahb_podf_loaded_SHIFT      20
#define CCM_CIMR_mask_mmdc_podf_loaded_MASK      0x200000u
#define CCM_CIMR_mask_mmdc_podf_loaded_SHIFT     21
#define CCM_CIMR_mask_periph_clk_sel_loaded_MASK 0x400000u
#define CCM_CIMR_mask_periph_clk_sel_loaded_SHIFT 22
#define CCM_CIMR_arm_podf_loaded_MASK            0x4000000u
#define CCM_CIMR_arm_podf_loaded_SHIFT           26
/* CCOSR Bit Fields */
#define CCM_CCOSR_CLKO_SEL_MASK                  0xFu
#define CCM_CCOSR_CLKO_SEL_SHIFT                 0
#define CCM_CCOSR_CLKO_SEL(x)                    (((uint32_t)(((uint32_t)(x))<<CCM_CCOSR_CLKO_SEL_SHIFT))&CCM_CCOSR_CLKO_SEL_MASK)
#define CCM_CCOSR_CLKO1_DIV_MASK                 0x70u
#define CCM_CCOSR_CLKO1_DIV_SHIFT                4
#define CCM_CCOSR_CLKO1_DIV(x)                   (((uint32_t)(((uint32_t)(x))<<CCM_CCOSR_CLKO1_DIV_SHIFT))&CCM_CCOSR_CLKO1_DIV_MASK)
#define CCM_CCOSR_CLKO1_EN_MASK                  0x80u
#define CCM_CCOSR_CLKO1_EN_SHIFT                 7
#define CCM_CCOSR_CLK_OUT_SEL_MASK               0x100u
#define CCM_CCOSR_CLK_OUT_SEL_SHIFT              8
#define CCM_CCOSR_CLKO2_SEL_MASK                 0x1F0000u
#define CCM_CCOSR_CLKO2_SEL_SHIFT                16
#define CCM_CCOSR_CLKO2_SEL(x)                   (((uint32_t)(((uint32_t)(x))<<CCM_CCOSR_CLKO2_SEL_SHIFT))&CCM_CCOSR_CLKO2_SEL_MASK)
#define CCM_CCOSR_CLKO2_DIV_MASK                 0xE00000u
#define CCM_CCOSR_CLKO2_DIV_SHIFT                21
#define CCM_CCOSR_CLKO2_DIV(x)                   (((uint32_t)(((uint32_t)(x))<<CCM_CCOSR_CLKO2_DIV_SHIFT))&CCM_CCOSR_CLKO2_DIV_MASK)
#define CCM_CCOSR_CLKO2_EN_MASK                  0x1000000u
#define CCM_CCOSR_CLKO2_EN_SHIFT                 24
/* CGPR Bit Fields */
#define CCM_CGPR_pmic_delay_scaler_MASK          0x1u
#define CCM_CGPR_pmic_delay_scaler_SHIFT         0
#define CCM_CGPR_mmdc_ext_clk_dis_MASK           0x4u
#define CCM_CGPR_mmdc_ext_clk_dis_SHIFT          2
#define CCM_CGPR_efuse_prog_supply_gate_MASK     0x10u
#define CCM_CGPR_efuse_prog_supply_gate_SHIFT    4
#define CCM_CGPR_FPL_MASK                        0x10000u
#define CCM_CGPR_FPL_SHIFT                       16
#define CCM_CGPR_INT_MEM_CLK_LPM_MASK            0x20000u
#define CCM_CGPR_INT_MEM_CLK_LPM_SHIFT           17
/* CCGR0 Bit Fields */
#define CCM_CCGR0_CG0_MASK                       0x3u
#define CCM_CCGR0_CG0_SHIFT                      0
#define CCM_CCGR0_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG0_SHIFT))&CCM_CCGR0_CG0_MASK)
#define CCM_CCGR0_CG1_MASK                       0xCu
#define CCM_CCGR0_CG1_SHIFT                      2
#define CCM_CCGR0_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG1_SHIFT))&CCM_CCGR0_CG1_MASK)
#define CCM_CCGR0_CG2_MASK                       0x30u
#define CCM_CCGR0_CG2_SHIFT                      4
#define CCM_CCGR0_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG2_SHIFT))&CCM_CCGR0_CG2_MASK)
#define CCM_CCGR0_CG3_MASK                       0xC0u
#define CCM_CCGR0_CG3_SHIFT                      6
#define CCM_CCGR0_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG3_SHIFT))&CCM_CCGR0_CG3_MASK)
#define CCM_CCGR0_CG4_MASK                       0x300u
#define CCM_CCGR0_CG4_SHIFT                      8
#define CCM_CCGR0_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG4_SHIFT))&CCM_CCGR0_CG4_MASK)
#define CCM_CCGR0_CG5_MASK                       0xC00u
#define CCM_CCGR0_CG5_SHIFT                      10
#define CCM_CCGR0_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG5_SHIFT))&CCM_CCGR0_CG5_MASK)
#define CCM_CCGR0_CG6_MASK                       0x3000u
#define CCM_CCGR0_CG6_SHIFT                      12
#define CCM_CCGR0_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG6_SHIFT))&CCM_CCGR0_CG6_MASK)
#define CCM_CCGR0_CG7_MASK                       0xC000u
#define CCM_CCGR0_CG7_SHIFT                      14
#define CCM_CCGR0_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG7_SHIFT))&CCM_CCGR0_CG7_MASK)
#define CCM_CCGR0_CG8_MASK                       0x30000u
#define CCM_CCGR0_CG8_SHIFT                      16
#define CCM_CCGR0_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG8_SHIFT))&CCM_CCGR0_CG8_MASK)
#define CCM_CCGR0_CG9_MASK                       0xC0000u
#define CCM_CCGR0_CG9_SHIFT                      18
#define CCM_CCGR0_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG9_SHIFT))&CCM_CCGR0_CG9_MASK)
#define CCM_CCGR0_CG10_MASK                      0x300000u
#define CCM_CCGR0_CG10_SHIFT                     20
#define CCM_CCGR0_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG10_SHIFT))&CCM_CCGR0_CG10_MASK)
#define CCM_CCGR0_CG11_MASK                      0xC00000u
#define CCM_CCGR0_CG11_SHIFT                     22
#define CCM_CCGR0_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG11_SHIFT))&CCM_CCGR0_CG11_MASK)
#define CCM_CCGR0_CG12_MASK                      0x3000000u
#define CCM_CCGR0_CG12_SHIFT                     24
#define CCM_CCGR0_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG12_SHIFT))&CCM_CCGR0_CG12_MASK)
#define CCM_CCGR0_CG13_MASK                      0xC000000u
#define CCM_CCGR0_CG13_SHIFT                     26
#define CCM_CCGR0_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG13_SHIFT))&CCM_CCGR0_CG13_MASK)
#define CCM_CCGR0_CG14_MASK                      0x30000000u
#define CCM_CCGR0_CG14_SHIFT                     28
#define CCM_CCGR0_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG14_SHIFT))&CCM_CCGR0_CG14_MASK)
#define CCM_CCGR0_CG15_MASK                      0xC0000000u
#define CCM_CCGR0_CG15_SHIFT                     30
#define CCM_CCGR0_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR0_CG15_SHIFT))&CCM_CCGR0_CG15_MASK)
/* CCGR1 Bit Fields */
#define CCM_CCGR1_CG0_MASK                       0x3u
#define CCM_CCGR1_CG0_SHIFT                      0
#define CCM_CCGR1_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG0_SHIFT))&CCM_CCGR1_CG0_MASK)
#define CCM_CCGR1_CG1_MASK                       0xCu
#define CCM_CCGR1_CG1_SHIFT                      2
#define CCM_CCGR1_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG1_SHIFT))&CCM_CCGR1_CG1_MASK)
#define CCM_CCGR1_CG2_MASK                       0x30u
#define CCM_CCGR1_CG2_SHIFT                      4
#define CCM_CCGR1_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG2_SHIFT))&CCM_CCGR1_CG2_MASK)
#define CCM_CCGR1_CG3_MASK                       0xC0u
#define CCM_CCGR1_CG3_SHIFT                      6
#define CCM_CCGR1_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG3_SHIFT))&CCM_CCGR1_CG3_MASK)
#define CCM_CCGR1_CG4_MASK                       0x300u
#define CCM_CCGR1_CG4_SHIFT                      8
#define CCM_CCGR1_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG4_SHIFT))&CCM_CCGR1_CG4_MASK)
#define CCM_CCGR1_CG5_MASK                       0xC00u
#define CCM_CCGR1_CG5_SHIFT                      10
#define CCM_CCGR1_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG5_SHIFT))&CCM_CCGR1_CG5_MASK)
#define CCM_CCGR1_CG6_MASK                       0x3000u
#define CCM_CCGR1_CG6_SHIFT                      12
#define CCM_CCGR1_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG6_SHIFT))&CCM_CCGR1_CG6_MASK)
#define CCM_CCGR1_CG7_MASK                       0xC000u
#define CCM_CCGR1_CG7_SHIFT                      14
#define CCM_CCGR1_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG7_SHIFT))&CCM_CCGR1_CG7_MASK)
#define CCM_CCGR1_CG8_MASK                       0x30000u
#define CCM_CCGR1_CG8_SHIFT                      16
#define CCM_CCGR1_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG8_SHIFT))&CCM_CCGR1_CG8_MASK)
#define CCM_CCGR1_CG9_MASK                       0xC0000u
#define CCM_CCGR1_CG9_SHIFT                      18
#define CCM_CCGR1_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG9_SHIFT))&CCM_CCGR1_CG9_MASK)
#define CCM_CCGR1_CG10_MASK                      0x300000u
#define CCM_CCGR1_CG10_SHIFT                     20
#define CCM_CCGR1_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG10_SHIFT))&CCM_CCGR1_CG10_MASK)
#define CCM_CCGR1_CG11_MASK                      0xC00000u
#define CCM_CCGR1_CG11_SHIFT                     22
#define CCM_CCGR1_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG11_SHIFT))&CCM_CCGR1_CG11_MASK)
#define CCM_CCGR1_CG12_MASK                      0x3000000u
#define CCM_CCGR1_CG12_SHIFT                     24
#define CCM_CCGR1_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG12_SHIFT))&CCM_CCGR1_CG12_MASK)
#define CCM_CCGR1_CG13_MASK                      0xC000000u
#define CCM_CCGR1_CG13_SHIFT                     26
#define CCM_CCGR1_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG13_SHIFT))&CCM_CCGR1_CG13_MASK)
#define CCM_CCGR1_CG14_MASK                      0x30000000u
#define CCM_CCGR1_CG14_SHIFT                     28
#define CCM_CCGR1_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG14_SHIFT))&CCM_CCGR1_CG14_MASK)
#define CCM_CCGR1_CG15_MASK                      0xC0000000u
#define CCM_CCGR1_CG15_SHIFT                     30
#define CCM_CCGR1_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR1_CG15_SHIFT))&CCM_CCGR1_CG15_MASK)
/* CCGR2 Bit Fields */
#define CCM_CCGR2_CG0_MASK                       0x3u
#define CCM_CCGR2_CG0_SHIFT                      0
#define CCM_CCGR2_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG0_SHIFT))&CCM_CCGR2_CG0_MASK)
#define CCM_CCGR2_CG1_MASK                       0xCu
#define CCM_CCGR2_CG1_SHIFT                      2
#define CCM_CCGR2_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG1_SHIFT))&CCM_CCGR2_CG1_MASK)
#define CCM_CCGR2_CG2_MASK                       0x30u
#define CCM_CCGR2_CG2_SHIFT                      4
#define CCM_CCGR2_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG2_SHIFT))&CCM_CCGR2_CG2_MASK)
#define CCM_CCGR2_CG3_MASK                       0xC0u
#define CCM_CCGR2_CG3_SHIFT                      6
#define CCM_CCGR2_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG3_SHIFT))&CCM_CCGR2_CG3_MASK)
#define CCM_CCGR2_CG4_MASK                       0x300u
#define CCM_CCGR2_CG4_SHIFT                      8
#define CCM_CCGR2_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG4_SHIFT))&CCM_CCGR2_CG4_MASK)
#define CCM_CCGR2_CG5_MASK                       0xC00u
#define CCM_CCGR2_CG5_SHIFT                      10
#define CCM_CCGR2_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG5_SHIFT))&CCM_CCGR2_CG5_MASK)
#define CCM_CCGR2_CG6_MASK                       0x3000u
#define CCM_CCGR2_CG6_SHIFT                      12
#define CCM_CCGR2_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG6_SHIFT))&CCM_CCGR2_CG6_MASK)
#define CCM_CCGR2_CG7_MASK                       0xC000u
#define CCM_CCGR2_CG7_SHIFT                      14
#define CCM_CCGR2_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG7_SHIFT))&CCM_CCGR2_CG7_MASK)
#define CCM_CCGR2_CG8_MASK                       0x30000u
#define CCM_CCGR2_CG8_SHIFT                      16
#define CCM_CCGR2_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG8_SHIFT))&CCM_CCGR2_CG8_MASK)
#define CCM_CCGR2_CG9_MASK                       0xC0000u
#define CCM_CCGR2_CG9_SHIFT                      18
#define CCM_CCGR2_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG9_SHIFT))&CCM_CCGR2_CG9_MASK)
#define CCM_CCGR2_CG10_MASK                      0x300000u
#define CCM_CCGR2_CG10_SHIFT                     20
#define CCM_CCGR2_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG10_SHIFT))&CCM_CCGR2_CG10_MASK)
#define CCM_CCGR2_CG11_MASK                      0xC00000u
#define CCM_CCGR2_CG11_SHIFT                     22
#define CCM_CCGR2_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG11_SHIFT))&CCM_CCGR2_CG11_MASK)
#define CCM_CCGR2_CG12_MASK                      0x3000000u
#define CCM_CCGR2_CG12_SHIFT                     24
#define CCM_CCGR2_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG12_SHIFT))&CCM_CCGR2_CG12_MASK)
#define CCM_CCGR2_CG13_MASK                      0xC000000u
#define CCM_CCGR2_CG13_SHIFT                     26
#define CCM_CCGR2_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG13_SHIFT))&CCM_CCGR2_CG13_MASK)
#define CCM_CCGR2_CG14_MASK                      0x30000000u
#define CCM_CCGR2_CG14_SHIFT                     28
#define CCM_CCGR2_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG14_SHIFT))&CCM_CCGR2_CG14_MASK)
#define CCM_CCGR2_CG15_MASK                      0xC0000000u
#define CCM_CCGR2_CG15_SHIFT                     30
#define CCM_CCGR2_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR2_CG15_SHIFT))&CCM_CCGR2_CG15_MASK)
/* CCGR3 Bit Fields */
#define CCM_CCGR3_CG0_MASK                       0x3u
#define CCM_CCGR3_CG0_SHIFT                      0
#define CCM_CCGR3_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG0_SHIFT))&CCM_CCGR3_CG0_MASK)
#define CCM_CCGR3_CG1_MASK                       0xCu
#define CCM_CCGR3_CG1_SHIFT                      2
#define CCM_CCGR3_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG1_SHIFT))&CCM_CCGR3_CG1_MASK)
#define CCM_CCGR3_CG2_MASK                       0x30u
#define CCM_CCGR3_CG2_SHIFT                      4
#define CCM_CCGR3_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG2_SHIFT))&CCM_CCGR3_CG2_MASK)
#define CCM_CCGR3_CG3_MASK                       0xC0u
#define CCM_CCGR3_CG3_SHIFT                      6
#define CCM_CCGR3_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG3_SHIFT))&CCM_CCGR3_CG3_MASK)
#define CCM_CCGR3_CG4_MASK                       0x300u
#define CCM_CCGR3_CG4_SHIFT                      8
#define CCM_CCGR3_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG4_SHIFT))&CCM_CCGR3_CG4_MASK)
#define CCM_CCGR3_CG5_MASK                       0xC00u
#define CCM_CCGR3_CG5_SHIFT                      10
#define CCM_CCGR3_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG5_SHIFT))&CCM_CCGR3_CG5_MASK)
#define CCM_CCGR3_CG6_MASK                       0x3000u
#define CCM_CCGR3_CG6_SHIFT                      12
#define CCM_CCGR3_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG6_SHIFT))&CCM_CCGR3_CG6_MASK)
#define CCM_CCGR3_CG7_MASK                       0xC000u
#define CCM_CCGR3_CG7_SHIFT                      14
#define CCM_CCGR3_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG7_SHIFT))&CCM_CCGR3_CG7_MASK)
#define CCM_CCGR3_CG8_MASK                       0x30000u
#define CCM_CCGR3_CG8_SHIFT                      16
#define CCM_CCGR3_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG8_SHIFT))&CCM_CCGR3_CG8_MASK)
#define CCM_CCGR3_CG9_MASK                       0xC0000u
#define CCM_CCGR3_CG9_SHIFT                      18
#define CCM_CCGR3_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG9_SHIFT))&CCM_CCGR3_CG9_MASK)
#define CCM_CCGR3_CG10_MASK                      0x300000u
#define CCM_CCGR3_CG10_SHIFT                     20
#define CCM_CCGR3_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG10_SHIFT))&CCM_CCGR3_CG10_MASK)
#define CCM_CCGR3_CG11_MASK                      0xC00000u
#define CCM_CCGR3_CG11_SHIFT                     22
#define CCM_CCGR3_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG11_SHIFT))&CCM_CCGR3_CG11_MASK)
#define CCM_CCGR3_CG12_MASK                      0x3000000u
#define CCM_CCGR3_CG12_SHIFT                     24
#define CCM_CCGR3_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG12_SHIFT))&CCM_CCGR3_CG12_MASK)
#define CCM_CCGR3_CG13_MASK                      0xC000000u
#define CCM_CCGR3_CG13_SHIFT                     26
#define CCM_CCGR3_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG13_SHIFT))&CCM_CCGR3_CG13_MASK)
#define CCM_CCGR3_CG14_MASK                      0x30000000u
#define CCM_CCGR3_CG14_SHIFT                     28
#define CCM_CCGR3_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG14_SHIFT))&CCM_CCGR3_CG14_MASK)
#define CCM_CCGR3_CG15_MASK                      0xC0000000u
#define CCM_CCGR3_CG15_SHIFT                     30
#define CCM_CCGR3_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR3_CG15_SHIFT))&CCM_CCGR3_CG15_MASK)
/* CCGR4 Bit Fields */
#define CCM_CCGR4_CG0_MASK                       0x3u
#define CCM_CCGR4_CG0_SHIFT                      0
#define CCM_CCGR4_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG0_SHIFT))&CCM_CCGR4_CG0_MASK)
#define CCM_CCGR4_CG1_MASK                       0xCu
#define CCM_CCGR4_CG1_SHIFT                      2
#define CCM_CCGR4_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG1_SHIFT))&CCM_CCGR4_CG1_MASK)
#define CCM_CCGR4_CG2_MASK                       0x30u
#define CCM_CCGR4_CG2_SHIFT                      4
#define CCM_CCGR4_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG2_SHIFT))&CCM_CCGR4_CG2_MASK)
#define CCM_CCGR4_CG3_MASK                       0xC0u
#define CCM_CCGR4_CG3_SHIFT                      6
#define CCM_CCGR4_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG3_SHIFT))&CCM_CCGR4_CG3_MASK)
#define CCM_CCGR4_CG4_MASK                       0x300u
#define CCM_CCGR4_CG4_SHIFT                      8
#define CCM_CCGR4_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG4_SHIFT))&CCM_CCGR4_CG4_MASK)
#define CCM_CCGR4_CG5_MASK                       0xC00u
#define CCM_CCGR4_CG5_SHIFT                      10
#define CCM_CCGR4_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG5_SHIFT))&CCM_CCGR4_CG5_MASK)
#define CCM_CCGR4_CG6_MASK                       0x3000u
#define CCM_CCGR4_CG6_SHIFT                      12
#define CCM_CCGR4_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG6_SHIFT))&CCM_CCGR4_CG6_MASK)
#define CCM_CCGR4_CG7_MASK                       0xC000u
#define CCM_CCGR4_CG7_SHIFT                      14
#define CCM_CCGR4_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG7_SHIFT))&CCM_CCGR4_CG7_MASK)
#define CCM_CCGR4_CG8_MASK                       0x30000u
#define CCM_CCGR4_CG8_SHIFT                      16
#define CCM_CCGR4_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG8_SHIFT))&CCM_CCGR4_CG8_MASK)
#define CCM_CCGR4_CG9_MASK                       0xC0000u
#define CCM_CCGR4_CG9_SHIFT                      18
#define CCM_CCGR4_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG9_SHIFT))&CCM_CCGR4_CG9_MASK)
#define CCM_CCGR4_CG10_MASK                      0x300000u
#define CCM_CCGR4_CG10_SHIFT                     20
#define CCM_CCGR4_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG10_SHIFT))&CCM_CCGR4_CG10_MASK)
#define CCM_CCGR4_CG11_MASK                      0xC00000u
#define CCM_CCGR4_CG11_SHIFT                     22
#define CCM_CCGR4_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG11_SHIFT))&CCM_CCGR4_CG11_MASK)
#define CCM_CCGR4_CG12_MASK                      0x3000000u
#define CCM_CCGR4_CG12_SHIFT                     24
#define CCM_CCGR4_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG12_SHIFT))&CCM_CCGR4_CG12_MASK)
#define CCM_CCGR4_CG13_MASK                      0xC000000u
#define CCM_CCGR4_CG13_SHIFT                     26
#define CCM_CCGR4_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG13_SHIFT))&CCM_CCGR4_CG13_MASK)
#define CCM_CCGR4_CG14_MASK                      0x30000000u
#define CCM_CCGR4_CG14_SHIFT                     28
#define CCM_CCGR4_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG14_SHIFT))&CCM_CCGR4_CG14_MASK)
#define CCM_CCGR4_CG15_MASK                      0xC0000000u
#define CCM_CCGR4_CG15_SHIFT                     30
#define CCM_CCGR4_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR4_CG15_SHIFT))&CCM_CCGR4_CG15_MASK)
/* CCGR5 Bit Fields */
#define CCM_CCGR5_CG0_MASK                       0x3u
#define CCM_CCGR5_CG0_SHIFT                      0
#define CCM_CCGR5_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG0_SHIFT))&CCM_CCGR5_CG0_MASK)
#define CCM_CCGR5_CG1_MASK                       0xCu
#define CCM_CCGR5_CG1_SHIFT                      2
#define CCM_CCGR5_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG1_SHIFT))&CCM_CCGR5_CG1_MASK)
#define CCM_CCGR5_CG2_MASK                       0x30u
#define CCM_CCGR5_CG2_SHIFT                      4
#define CCM_CCGR5_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG2_SHIFT))&CCM_CCGR5_CG2_MASK)
#define CCM_CCGR5_CG3_MASK                       0xC0u
#define CCM_CCGR5_CG3_SHIFT                      6
#define CCM_CCGR5_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG3_SHIFT))&CCM_CCGR5_CG3_MASK)
#define CCM_CCGR5_CG4_MASK                       0x300u
#define CCM_CCGR5_CG4_SHIFT                      8
#define CCM_CCGR5_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG4_SHIFT))&CCM_CCGR5_CG4_MASK)
#define CCM_CCGR5_CG5_MASK                       0xC00u
#define CCM_CCGR5_CG5_SHIFT                      10
#define CCM_CCGR5_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG5_SHIFT))&CCM_CCGR5_CG5_MASK)
#define CCM_CCGR5_CG6_MASK                       0x3000u
#define CCM_CCGR5_CG6_SHIFT                      12
#define CCM_CCGR5_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG6_SHIFT))&CCM_CCGR5_CG6_MASK)
#define CCM_CCGR5_CG7_MASK                       0xC000u
#define CCM_CCGR5_CG7_SHIFT                      14
#define CCM_CCGR5_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG7_SHIFT))&CCM_CCGR5_CG7_MASK)
#define CCM_CCGR5_CG8_MASK                       0x30000u
#define CCM_CCGR5_CG8_SHIFT                      16
#define CCM_CCGR5_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG8_SHIFT))&CCM_CCGR5_CG8_MASK)
#define CCM_CCGR5_CG9_MASK                       0xC0000u
#define CCM_CCGR5_CG9_SHIFT                      18
#define CCM_CCGR5_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG9_SHIFT))&CCM_CCGR5_CG9_MASK)
#define CCM_CCGR5_CG10_MASK                      0x300000u
#define CCM_CCGR5_CG10_SHIFT                     20
#define CCM_CCGR5_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG10_SHIFT))&CCM_CCGR5_CG10_MASK)
#define CCM_CCGR5_CG11_MASK                      0xC00000u
#define CCM_CCGR5_CG11_SHIFT                     22
#define CCM_CCGR5_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG11_SHIFT))&CCM_CCGR5_CG11_MASK)
#define CCM_CCGR5_CG12_MASK                      0x3000000u
#define CCM_CCGR5_CG12_SHIFT                     24
#define CCM_CCGR5_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG12_SHIFT))&CCM_CCGR5_CG12_MASK)
#define CCM_CCGR5_CG13_MASK                      0xC000000u
#define CCM_CCGR5_CG13_SHIFT                     26
#define CCM_CCGR5_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG13_SHIFT))&CCM_CCGR5_CG13_MASK)
#define CCM_CCGR5_CG14_MASK                      0x30000000u
#define CCM_CCGR5_CG14_SHIFT                     28
#define CCM_CCGR5_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG14_SHIFT))&CCM_CCGR5_CG14_MASK)
#define CCM_CCGR5_CG15_MASK                      0xC0000000u
#define CCM_CCGR5_CG15_SHIFT                     30
#define CCM_CCGR5_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR5_CG15_SHIFT))&CCM_CCGR5_CG15_MASK)
/* CCGR6 Bit Fields */
#define CCM_CCGR6_CG0_MASK                       0x3u
#define CCM_CCGR6_CG0_SHIFT                      0
#define CCM_CCGR6_CG0(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG0_SHIFT))&CCM_CCGR6_CG0_MASK)
#define CCM_CCGR6_CG1_MASK                       0xCu
#define CCM_CCGR6_CG1_SHIFT                      2
#define CCM_CCGR6_CG1(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG1_SHIFT))&CCM_CCGR6_CG1_MASK)
#define CCM_CCGR6_CG2_MASK                       0x30u
#define CCM_CCGR6_CG2_SHIFT                      4
#define CCM_CCGR6_CG2(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG2_SHIFT))&CCM_CCGR6_CG2_MASK)
#define CCM_CCGR6_CG3_MASK                       0xC0u
#define CCM_CCGR6_CG3_SHIFT                      6
#define CCM_CCGR6_CG3(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG3_SHIFT))&CCM_CCGR6_CG3_MASK)
#define CCM_CCGR6_CG4_MASK                       0x300u
#define CCM_CCGR6_CG4_SHIFT                      8
#define CCM_CCGR6_CG4(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG4_SHIFT))&CCM_CCGR6_CG4_MASK)
#define CCM_CCGR6_CG5_MASK                       0xC00u
#define CCM_CCGR6_CG5_SHIFT                      10
#define CCM_CCGR6_CG5(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG5_SHIFT))&CCM_CCGR6_CG5_MASK)
#define CCM_CCGR6_CG6_MASK                       0x3000u
#define CCM_CCGR6_CG6_SHIFT                      12
#define CCM_CCGR6_CG6(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG6_SHIFT))&CCM_CCGR6_CG6_MASK)
#define CCM_CCGR6_CG7_MASK                       0xC000u
#define CCM_CCGR6_CG7_SHIFT                      14
#define CCM_CCGR6_CG7(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG7_SHIFT))&CCM_CCGR6_CG7_MASK)
#define CCM_CCGR6_CG8_MASK                       0x30000u
#define CCM_CCGR6_CG8_SHIFT                      16
#define CCM_CCGR6_CG8(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG8_SHIFT))&CCM_CCGR6_CG8_MASK)
#define CCM_CCGR6_CG9_MASK                       0xC0000u
#define CCM_CCGR6_CG9_SHIFT                      18
#define CCM_CCGR6_CG9(x)                         (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG9_SHIFT))&CCM_CCGR6_CG9_MASK)
#define CCM_CCGR6_CG10_MASK                      0x300000u
#define CCM_CCGR6_CG10_SHIFT                     20
#define CCM_CCGR6_CG10(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG10_SHIFT))&CCM_CCGR6_CG10_MASK)
#define CCM_CCGR6_CG11_MASK                      0xC00000u
#define CCM_CCGR6_CG11_SHIFT                     22
#define CCM_CCGR6_CG11(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG11_SHIFT))&CCM_CCGR6_CG11_MASK)
#define CCM_CCGR6_CG12_MASK                      0x3000000u
#define CCM_CCGR6_CG12_SHIFT                     24
#define CCM_CCGR6_CG12(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG12_SHIFT))&CCM_CCGR6_CG12_MASK)
#define CCM_CCGR6_CG13_MASK                      0xC000000u
#define CCM_CCGR6_CG13_SHIFT                     26
#define CCM_CCGR6_CG13(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG13_SHIFT))&CCM_CCGR6_CG13_MASK)
#define CCM_CCGR6_CG14_MASK                      0x30000000u
#define CCM_CCGR6_CG14_SHIFT                     28
#define CCM_CCGR6_CG14(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG14_SHIFT))&CCM_CCGR6_CG14_MASK)
#define CCM_CCGR6_CG15_MASK                      0xC0000000u
#define CCM_CCGR6_CG15_SHIFT                     30
#define CCM_CCGR6_CG15(x)                        (((uint32_t)(((uint32_t)(x))<<CCM_CCGR6_CG15_SHIFT))&CCM_CCGR6_CG15_MASK)
/* CMEOR Bit Fields */
#define CCM_CMEOR_mod_en_ov_gpt_MASK             0x20u
#define CCM_CMEOR_mod_en_ov_gpt_SHIFT            5
#define CCM_CMEOR_mod_en_ov_epit_MASK            0x40u
#define CCM_CMEOR_mod_en_ov_epit_SHIFT           6
#define CCM_CMEOR_mod_en_usdhc_MASK              0x80u
#define CCM_CMEOR_mod_en_usdhc_SHIFT             7
#define CCM_CMEOR_mod_en_ov_gpu_MASK             0x400u
#define CCM_CMEOR_mod_en_ov_gpu_SHIFT            10
#define CCM_CMEOR_mod_en_ov_can2_cpi_MASK        0x10000000u
#define CCM_CMEOR_mod_en_ov_can2_cpi_SHIFT       28
#define CCM_CMEOR_mod_en_ov_can1_cpi_MASK        0x40000000u
#define CCM_CMEOR_mod_en_ov_can1_cpi_SHIFT       30

/*!
 * @}
 */ /* end of group CCM_Register_Masks */


/* CCM - Peripheral instance base addresses */
/** Peripheral CCM base pointer */
#define CCM_BASE_PTR                             ((CCM_MemMapPtr)0x420C4000u)
/** Array initializer of CCM peripheral base pointers */
#define CCM_BASE_PTRS                            { CCM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Register_Accessor_Macros CCM - Register accessor macros
 * @{
 */


/* CCM - Register instance definitions */
/* CCM */
#define CCM_CCR                                  CCM_CCR_REG(CCM_BASE_PTR)
#define CCM_CCDR                                 CCM_CCDR_REG(CCM_BASE_PTR)
#define CCM_CSR                                  CCM_CSR_REG(CCM_BASE_PTR)
#define CCM_CCSR                                 CCM_CCSR_REG(CCM_BASE_PTR)
#define CCM_CACRR                                CCM_CACRR_REG(CCM_BASE_PTR)
#define CCM_CBCDR                                CCM_CBCDR_REG(CCM_BASE_PTR)
#define CCM_CBCMR                                CCM_CBCMR_REG(CCM_BASE_PTR)
#define CCM_CSCMR1                               CCM_CSCMR1_REG(CCM_BASE_PTR)
#define CCM_CSCMR2                               CCM_CSCMR2_REG(CCM_BASE_PTR)
#define CCM_CSCDR1                               CCM_CSCDR1_REG(CCM_BASE_PTR)
#define CCM_CS1CDR                               CCM_CS1CDR_REG(CCM_BASE_PTR)
#define CCM_CS2CDR                               CCM_CS2CDR_REG(CCM_BASE_PTR)
#define CCM_CDCDR                                CCM_CDCDR_REG(CCM_BASE_PTR)
#define CCM_CHSCCDR                              CCM_CHSCCDR_REG(CCM_BASE_PTR)
#define CCM_CSCDR2                               CCM_CSCDR2_REG(CCM_BASE_PTR)
#define CCM_CSCDR3                               CCM_CSCDR3_REG(CCM_BASE_PTR)
#define CCM_CWDR                                 CCM_CWDR_REG(CCM_BASE_PTR)
#define CCM_CDHIPR                               CCM_CDHIPR_REG(CCM_BASE_PTR)
#define CCM_CLPCR                                CCM_CLPCR_REG(CCM_BASE_PTR)
#define CCM_CISR                                 CCM_CISR_REG(CCM_BASE_PTR)
#define CCM_CIMR                                 CCM_CIMR_REG(CCM_BASE_PTR)
#define CCM_CCOSR                                CCM_CCOSR_REG(CCM_BASE_PTR)
#define CCM_CGPR                                 CCM_CGPR_REG(CCM_BASE_PTR)
#define CCM_CCGR0                                CCM_CCGR0_REG(CCM_BASE_PTR)
#define CCM_CCGR1                                CCM_CCGR1_REG(CCM_BASE_PTR)
#define CCM_CCGR2                                CCM_CCGR2_REG(CCM_BASE_PTR)
#define CCM_CCGR3                                CCM_CCGR3_REG(CCM_BASE_PTR)
#define CCM_CCGR4                                CCM_CCGR4_REG(CCM_BASE_PTR)
#define CCM_CCGR5                                CCM_CCGR5_REG(CCM_BASE_PTR)
#define CCM_CCGR6                                CCM_CCGR6_REG(CCM_BASE_PTR)
#define CCM_CMEOR                                CCM_CMEOR_REG(CCM_BASE_PTR)

/*!
 * @}
 */ /* end of group CCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CCM_Peripheral */


/* ----------------------------------------------------------------------------
   -- CCM_ANALOG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Peripheral CCM_ANALOG
 * @{
 */

/** CCM_ANALOG - Peripheral register structure */
typedef struct CCM_ANALOG_MemMap {
  uint32_t PLL_ARM;                                /**< Analog ARM PLL control Register, offset: 0x0 */
  uint32_t PLL_ARM_SET;                            /**< Analog ARM PLL control Register, offset: 0x4 */
  uint32_t PLL_ARM_CLR;                            /**< Analog ARM PLL control Register, offset: 0x8 */
  uint32_t PLL_ARM_TOG;                            /**< Analog ARM PLL control Register, offset: 0xC */
  uint32_t PLL_USB1;                               /**< Analog USB1 480MHz PLL Control Register, offset: 0x10 */
  uint32_t PLL_USB1_SET;                           /**< Analog USB1 480MHz PLL Control Register, offset: 0x14 */
  uint32_t PLL_USB1_CLR;                           /**< Analog USB1 480MHz PLL Control Register, offset: 0x18 */
  uint32_t PLL_USB1_TOG;                           /**< Analog USB1 480MHz PLL Control Register, offset: 0x1C */
  uint32_t PLL_USB2;                               /**< Analog USB2 480MHz PLL Control Register, offset: 0x20 */
  uint32_t PLL_USB2_SET;                           /**< Analog USB2 480MHz PLL Control Register, offset: 0x24 */
  uint32_t PLL_USB2_CLR;                           /**< Analog USB2 480MHz PLL Control Register, offset: 0x28 */
  uint32_t PLL_USB2_TOG;                           /**< Analog USB2 480MHz PLL Control Register, offset: 0x2C */
  uint32_t PLL_SYS;                                /**< Analog System PLL Control Register, offset: 0x30 */
  uint32_t PLL_SYS_SET;                            /**< Analog System PLL Control Register, offset: 0x34 */
  uint32_t PLL_SYS_CLR;                            /**< Analog System PLL Control Register, offset: 0x38 */
  uint32_t PLL_SYS_TOG;                            /**< Analog System PLL Control Register, offset: 0x3C */
  uint32_t PLL_SYS_SS;                             /**< 528MHz System PLL Spread Spectrum Register, offset: 0x40 */
  uint8_t RESERVED_0[44];
  uint32_t PLL_AUDIO;                              /**< Analog Audio PLL control Register, offset: 0x70 */
  uint32_t PLL_AUDIO_SET;                          /**< Analog Audio PLL control Register, offset: 0x74 */
  uint32_t PLL_AUDIO_CLR;                          /**< Analog Audio PLL control Register, offset: 0x78 */
  uint32_t PLL_AUDIO_TOG;                          /**< Analog Audio PLL control Register, offset: 0x7C */
  uint32_t PLL_AUDIO_NUM;                          /**< Numerator of Audio PLL Fractional Loop Divider Register, offset: 0x80 */
  uint8_t RESERVED_1[12];
  uint32_t PLL_AUDIO_DENOM;                        /**< Denominator of Audio PLL Fractional Loop Divider Register, offset: 0x90 */
  uint8_t RESERVED_2[12];
  uint32_t PLL_VIDEO;                              /**< Analog Video PLL control Register, offset: 0xA0 */
  uint32_t PLL_VIDEO_SET;                          /**< Analog Video PLL control Register, offset: 0xA4 */
  uint32_t PLL_VIDEO_CLR;                          /**< Analog Video PLL control Register, offset: 0xA8 */
  uint32_t PLL_VIDEO_TOG;                          /**< Analog Video PLL control Register, offset: 0xAC */
  uint32_t PLL_VIDEO_NUM;                          /**< Numerator of Video PLL Fractional Loop Divider Register, offset: 0xB0 */
  uint8_t RESERVED_3[12];
  uint32_t PLL_VIDEO_DENOM;                        /**< Denominator of Video PLL Fractional Loop Divider Register, offset: 0xC0 */
  uint8_t RESERVED_4[28];
  uint32_t PLL_ENET;                               /**< Analog ENET PLL Control Register, offset: 0xE0 */
  uint32_t PLL_ENET_SET;                           /**< Analog ENET PLL Control Register, offset: 0xE4 */
  uint32_t PLL_ENET_CLR;                           /**< Analog ENET PLL Control Register, offset: 0xE8 */
  uint32_t PLL_ENET_TOG;                           /**< Analog ENET PLL Control Register, offset: 0xEC */
  uint32_t PFD_480;                                /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF0 */
  uint32_t PFD_480_SET;                            /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF4 */
  uint32_t PFD_480_CLR;                            /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xF8 */
  uint32_t PFD_480_TOG;                            /**< 480MHz Clock (PLL3) Phase Fractional Divider Control Register, offset: 0xFC */
  uint32_t PFD_528;                                /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x100 */
  uint32_t PFD_528_SET;                            /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x104 */
  uint32_t PFD_528_CLR;                            /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x108 */
  uint32_t PFD_528_TOG;                            /**< 528MHz Clock (PLL2) Phase Fractional Divider Control Register, offset: 0x10C */
  uint8_t RESERVED_5[64];
  uint32_t MISC0;                                  /**< Miscellaneous Register 0, offset: 0x150 */
  uint32_t MISC0_SET;                              /**< Miscellaneous Register 0, offset: 0x154 */
  uint32_t MISC0_CLR;                              /**< Miscellaneous Register 0, offset: 0x158 */
  uint32_t MISC0_TOG;                              /**< Miscellaneous Register 0, offset: 0x15C */
  uint32_t MISC1;                                  /**< Miscellaneous Register 1, offset: 0x160 */
  uint32_t MISC1_SET;                              /**< Miscellaneous Register 1, offset: 0x164 */
  uint32_t MISC1_CLR;                              /**< Miscellaneous Register 1, offset: 0x168 */
  uint32_t MISC1_TOG;                              /**< Miscellaneous Register 1, offset: 0x16C */
  uint32_t MISC2;                                  /**< Miscellaneous Register 2, offset: 0x170 */
  uint32_t MISC2_SET;                              /**< Miscellaneous Register 2, offset: 0x174 */
  uint32_t MISC2_CLR;                              /**< Miscellaneous Register 2, offset: 0x178 */
  uint32_t MISC2_TOG;                              /**< Miscellaneous Register 2, offset: 0x17C */
} volatile *CCM_ANALOG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CCM_ANALOG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Register_Accessor_Macros CCM_ANALOG - Register accessor macros
 * @{
 */


/* CCM_ANALOG - Register accessors */
#define CCM_ANALOG_PLL_ARM_REG(base)             ((base)->PLL_ARM)
#define CCM_ANALOG_PLL_ARM_SET_REG(base)         ((base)->PLL_ARM_SET)
#define CCM_ANALOG_PLL_ARM_CLR_REG(base)         ((base)->PLL_ARM_CLR)
#define CCM_ANALOG_PLL_ARM_TOG_REG(base)         ((base)->PLL_ARM_TOG)
#define CCM_ANALOG_PLL_USB1_REG(base)            ((base)->PLL_USB1)
#define CCM_ANALOG_PLL_USB1_SET_REG(base)        ((base)->PLL_USB1_SET)
#define CCM_ANALOG_PLL_USB1_CLR_REG(base)        ((base)->PLL_USB1_CLR)
#define CCM_ANALOG_PLL_USB1_TOG_REG(base)        ((base)->PLL_USB1_TOG)
#define CCM_ANALOG_PLL_USB2_REG(base)            ((base)->PLL_USB2)
#define CCM_ANALOG_PLL_USB2_SET_REG(base)        ((base)->PLL_USB2_SET)
#define CCM_ANALOG_PLL_USB2_CLR_REG(base)        ((base)->PLL_USB2_CLR)
#define CCM_ANALOG_PLL_USB2_TOG_REG(base)        ((base)->PLL_USB2_TOG)
#define CCM_ANALOG_PLL_SYS_REG(base)             ((base)->PLL_SYS)
#define CCM_ANALOG_PLL_SYS_SET_REG(base)         ((base)->PLL_SYS_SET)
#define CCM_ANALOG_PLL_SYS_CLR_REG(base)         ((base)->PLL_SYS_CLR)
#define CCM_ANALOG_PLL_SYS_TOG_REG(base)         ((base)->PLL_SYS_TOG)
#define CCM_ANALOG_PLL_SYS_SS_REG(base)          ((base)->PLL_SYS_SS)
#define CCM_ANALOG_PLL_AUDIO_REG(base)           ((base)->PLL_AUDIO)
#define CCM_ANALOG_PLL_AUDIO_SET_REG(base)       ((base)->PLL_AUDIO_SET)
#define CCM_ANALOG_PLL_AUDIO_CLR_REG(base)       ((base)->PLL_AUDIO_CLR)
#define CCM_ANALOG_PLL_AUDIO_TOG_REG(base)       ((base)->PLL_AUDIO_TOG)
#define CCM_ANALOG_PLL_AUDIO_NUM_REG(base)       ((base)->PLL_AUDIO_NUM)
#define CCM_ANALOG_PLL_AUDIO_DENOM_REG(base)     ((base)->PLL_AUDIO_DENOM)
#define CCM_ANALOG_PLL_VIDEO_REG(base)           ((base)->PLL_VIDEO)
#define CCM_ANALOG_PLL_VIDEO_SET_REG(base)       ((base)->PLL_VIDEO_SET)
#define CCM_ANALOG_PLL_VIDEO_CLR_REG(base)       ((base)->PLL_VIDEO_CLR)
#define CCM_ANALOG_PLL_VIDEO_TOG_REG(base)       ((base)->PLL_VIDEO_TOG)
#define CCM_ANALOG_PLL_VIDEO_NUM_REG(base)       ((base)->PLL_VIDEO_NUM)
#define CCM_ANALOG_PLL_VIDEO_DENOM_REG(base)     ((base)->PLL_VIDEO_DENOM)
#define CCM_ANALOG_PLL_ENET_REG(base)            ((base)->PLL_ENET)
#define CCM_ANALOG_PLL_ENET_SET_REG(base)        ((base)->PLL_ENET_SET)
#define CCM_ANALOG_PLL_ENET_CLR_REG(base)        ((base)->PLL_ENET_CLR)
#define CCM_ANALOG_PLL_ENET_TOG_REG(base)        ((base)->PLL_ENET_TOG)
#define CCM_ANALOG_PFD_480_REG(base)             ((base)->PFD_480)
#define CCM_ANALOG_PFD_480_SET_REG(base)         ((base)->PFD_480_SET)
#define CCM_ANALOG_PFD_480_CLR_REG(base)         ((base)->PFD_480_CLR)
#define CCM_ANALOG_PFD_480_TOG_REG(base)         ((base)->PFD_480_TOG)
#define CCM_ANALOG_PFD_528_REG(base)             ((base)->PFD_528)
#define CCM_ANALOG_PFD_528_SET_REG(base)         ((base)->PFD_528_SET)
#define CCM_ANALOG_PFD_528_CLR_REG(base)         ((base)->PFD_528_CLR)
#define CCM_ANALOG_PFD_528_TOG_REG(base)         ((base)->PFD_528_TOG)
#define CCM_ANALOG_MISC0_REG(base)               ((base)->MISC0)
#define CCM_ANALOG_MISC0_SET_REG(base)           ((base)->MISC0_SET)
#define CCM_ANALOG_MISC0_CLR_REG(base)           ((base)->MISC0_CLR)
#define CCM_ANALOG_MISC0_TOG_REG(base)           ((base)->MISC0_TOG)
#define CCM_ANALOG_MISC1_REG(base)               ((base)->MISC1)
#define CCM_ANALOG_MISC1_SET_REG(base)           ((base)->MISC1_SET)
#define CCM_ANALOG_MISC1_CLR_REG(base)           ((base)->MISC1_CLR)
#define CCM_ANALOG_MISC1_TOG_REG(base)           ((base)->MISC1_TOG)
#define CCM_ANALOG_MISC2_REG(base)               ((base)->MISC2)
#define CCM_ANALOG_MISC2_SET_REG(base)           ((base)->MISC2_SET)
#define CCM_ANALOG_MISC2_CLR_REG(base)           ((base)->MISC2_CLR)
#define CCM_ANALOG_MISC2_TOG_REG(base)           ((base)->MISC2_TOG)

/*!
 * @}
 */ /* end of group CCM_ANALOG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CCM_ANALOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Register_Masks CCM_ANALOG Register Masks
 * @{
 */

/* PLL_ARM Bit Fields */
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_MASK       0x7Fu
#define CCM_ANALOG_PLL_ARM_DIV_SELECT_SHIFT      0
#define CCM_ANALOG_PLL_ARM_DIV_SELECT(x)         (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ARM_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_POWERDOWN_MASK        0x1000u
#define CCM_ANALOG_PLL_ARM_POWERDOWN_SHIFT       12
#define CCM_ANALOG_PLL_ARM_ENABLE_MASK           0x2000u
#define CCM_ANALOG_PLL_ARM_ENABLE_SHIFT          13
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_MASK   0xC000u
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_SHIFT  14
#define CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_BYPASS_MASK           0x10000u
#define CCM_ANALOG_PLL_ARM_BYPASS_SHIFT          16
#define CCM_ANALOG_PLL_ARM_LVDS_SEL_MASK         0x20000u
#define CCM_ANALOG_PLL_ARM_LVDS_SEL_SHIFT        17
#define CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL_MASK   0x40000u
#define CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL_SHIFT  18
#define CCM_ANALOG_PLL_ARM_PLL_SEL_MASK          0x80000u
#define CCM_ANALOG_PLL_ARM_PLL_SEL_SHIFT         19
#define CCM_ANALOG_PLL_ARM_LOCK_MASK             0x80000000u
#define CCM_ANALOG_PLL_ARM_LOCK_SHIFT            31
/* PLL_ARM_SET Bit Fields */
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_MASK   0x7Fu
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_ARM_SET_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ARM_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_SET_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_ARM_SET_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_ARM_SET_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_ARM_SET_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ARM_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_ARM_SET_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_ARM_SET_LVDS_SEL_MASK     0x20000u
#define CCM_ANALOG_PLL_ARM_SET_LVDS_SEL_SHIFT    17
#define CCM_ANALOG_PLL_ARM_SET_LVDS_24MHZ_SEL_MASK 0x40000u
#define CCM_ANALOG_PLL_ARM_SET_LVDS_24MHZ_SEL_SHIFT 18
#define CCM_ANALOG_PLL_ARM_SET_PLL_SEL_MASK      0x80000u
#define CCM_ANALOG_PLL_ARM_SET_PLL_SEL_SHIFT     19
#define CCM_ANALOG_PLL_ARM_SET_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_ARM_SET_LOCK_SHIFT        31
/* PLL_ARM_CLR Bit Fields */
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_MASK   0x7Fu
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ARM_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_ARM_CLR_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_ARM_CLR_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_ARM_CLR_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ARM_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_ARM_CLR_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_ARM_CLR_LVDS_SEL_MASK     0x20000u
#define CCM_ANALOG_PLL_ARM_CLR_LVDS_SEL_SHIFT    17
#define CCM_ANALOG_PLL_ARM_CLR_LVDS_24MHZ_SEL_MASK 0x40000u
#define CCM_ANALOG_PLL_ARM_CLR_LVDS_24MHZ_SEL_SHIFT 18
#define CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_MASK      0x80000u
#define CCM_ANALOG_PLL_ARM_CLR_PLL_SEL_SHIFT     19
#define CCM_ANALOG_PLL_ARM_CLR_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_ARM_CLR_LOCK_SHIFT        31
/* PLL_ARM_TOG Bit Fields */
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_MASK   0x7Fu
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ARM_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_ARM_TOG_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_ARM_TOG_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_ARM_TOG_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ARM_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_ARM_TOG_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_ARM_TOG_LVDS_SEL_MASK     0x20000u
#define CCM_ANALOG_PLL_ARM_TOG_LVDS_SEL_SHIFT    17
#define CCM_ANALOG_PLL_ARM_TOG_LVDS_24MHZ_SEL_MASK 0x40000u
#define CCM_ANALOG_PLL_ARM_TOG_LVDS_24MHZ_SEL_SHIFT 18
#define CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_MASK      0x80000u
#define CCM_ANALOG_PLL_ARM_TOG_PLL_SEL_SHIFT     19
#define CCM_ANALOG_PLL_ARM_TOG_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_ARM_TOG_LOCK_SHIFT        31
/* PLL_USB1 Bit Fields */
#define CCM_ANALOG_PLL_USB1_DIV_SELECT_MASK      0x3u
#define CCM_ANALOG_PLL_USB1_DIV_SELECT_SHIFT     0
#define CCM_ANALOG_PLL_USB1_DIV_SELECT(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_EN_USB_CLKS_MASK     0x40u
#define CCM_ANALOG_PLL_USB1_EN_USB_CLKS_SHIFT    6
#define CCM_ANALOG_PLL_USB1_POWER_MASK           0x1000u
#define CCM_ANALOG_PLL_USB1_POWER_SHIFT          12
#define CCM_ANALOG_PLL_USB1_ENABLE_MASK          0x2000u
#define CCM_ANALOG_PLL_USB1_ENABLE_SHIFT         13
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_MASK  0xC000u
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_BYPASS_MASK          0x10000u
#define CCM_ANALOG_PLL_USB1_BYPASS_SHIFT         16
#define CCM_ANALOG_PLL_USB1_LOCK_MASK            0x80000000u
#define CCM_ANALOG_PLL_USB1_LOCK_SHIFT           31
/* PLL_USB1_SET Bit Fields */
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB1_SET_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB1_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB1_SET_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB1_SET_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB1_SET_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB1_SET_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB1_SET_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB1_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB1_SET_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB1_SET_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB1_SET_LOCK_SHIFT       31
/* PLL_USB1_CLR Bit Fields */
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB1_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB1_CLR_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB1_CLR_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB1_CLR_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB1_CLR_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB1_CLR_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB1_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB1_CLR_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB1_CLR_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB1_CLR_LOCK_SHIFT       31
/* PLL_USB1_TOG Bit Fields */
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB1_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB1_TOG_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB1_TOG_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB1_TOG_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB1_TOG_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB1_TOG_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB1_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB1_TOG_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB1_TOG_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB1_TOG_LOCK_SHIFT       31
/* PLL_USB2 Bit Fields */
#define CCM_ANALOG_PLL_USB2_DIV_SELECT_MASK      0x3u
#define CCM_ANALOG_PLL_USB2_DIV_SELECT_SHIFT     0
#define CCM_ANALOG_PLL_USB2_DIV_SELECT(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB2_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_EN_USB_CLKS_MASK     0x40u
#define CCM_ANALOG_PLL_USB2_EN_USB_CLKS_SHIFT    6
#define CCM_ANALOG_PLL_USB2_POWER_MASK           0x1000u
#define CCM_ANALOG_PLL_USB2_POWER_SHIFT          12
#define CCM_ANALOG_PLL_USB2_ENABLE_MASK          0x2000u
#define CCM_ANALOG_PLL_USB2_ENABLE_SHIFT         13
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_MASK  0xC000u
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_BYPASS_MASK          0x10000u
#define CCM_ANALOG_PLL_USB2_BYPASS_SHIFT         16
#define CCM_ANALOG_PLL_USB2_LOCK_MASK            0x80000000u
#define CCM_ANALOG_PLL_USB2_LOCK_SHIFT           31
/* PLL_USB2_SET Bit Fields */
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB2_SET_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB2_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB2_SET_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB2_SET_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB2_SET_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB2_SET_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB2_SET_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB2_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB2_SET_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB2_SET_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB2_SET_LOCK_SHIFT       31
/* PLL_USB2_CLR Bit Fields */
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB2_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB2_CLR_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB2_CLR_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB2_CLR_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB2_CLR_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB2_CLR_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB2_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB2_CLR_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB2_CLR_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB2_CLR_LOCK_SHIFT       31
/* PLL_USB2_TOG Bit Fields */
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_MASK  0x3u
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_USB2_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_MASK 0x40u
#define CCM_ANALOG_PLL_USB2_TOG_EN_USB_CLKS_SHIFT 6
#define CCM_ANALOG_PLL_USB2_TOG_POWER_MASK       0x1000u
#define CCM_ANALOG_PLL_USB2_TOG_POWER_SHIFT      12
#define CCM_ANALOG_PLL_USB2_TOG_ENABLE_MASK      0x2000u
#define CCM_ANALOG_PLL_USB2_TOG_ENABLE_SHIFT     13
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_USB2_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_USB2_TOG_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_USB2_TOG_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_USB2_TOG_LOCK_SHIFT       31
/* PLL_SYS Bit Fields */
#define CCM_ANALOG_PLL_SYS_DIV_SELECT_MASK       0x1u
#define CCM_ANALOG_PLL_SYS_DIV_SELECT_SHIFT      0
#define CCM_ANALOG_PLL_SYS_POWERDOWN_MASK        0x1000u
#define CCM_ANALOG_PLL_SYS_POWERDOWN_SHIFT       12
#define CCM_ANALOG_PLL_SYS_ENABLE_MASK           0x2000u
#define CCM_ANALOG_PLL_SYS_ENABLE_SHIFT          13
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_MASK   0xC000u
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_SHIFT  14
#define CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_BYPASS_MASK           0x10000u
#define CCM_ANALOG_PLL_SYS_BYPASS_SHIFT          16
#define CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_MASK    0x40000u
#define CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN_SHIFT   18
#define CCM_ANALOG_PLL_SYS_LOCK_MASK             0x80000000u
#define CCM_ANALOG_PLL_SYS_LOCK_SHIFT            31
/* PLL_SYS_SET Bit Fields */
#define CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_MASK   0x1u
#define CCM_ANALOG_PLL_SYS_SET_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_SYS_SET_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_SYS_SET_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_SYS_SET_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_SYS_SET_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_SYS_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_SYS_SET_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_SYS_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_SYS_SET_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_SYS_SET_LOCK_SHIFT        31
/* PLL_SYS_CLR Bit Fields */
#define CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_MASK   0x1u
#define CCM_ANALOG_PLL_SYS_CLR_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_SYS_CLR_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_SYS_CLR_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_SYS_CLR_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_SYS_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_SYS_CLR_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_SYS_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_SYS_CLR_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_SYS_CLR_LOCK_SHIFT        31
/* PLL_SYS_TOG Bit Fields */
#define CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_MASK   0x1u
#define CCM_ANALOG_PLL_SYS_TOG_DIV_SELECT_SHIFT  0
#define CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_MASK    0x1000u
#define CCM_ANALOG_PLL_SYS_TOG_POWERDOWN_SHIFT   12
#define CCM_ANALOG_PLL_SYS_TOG_ENABLE_MASK       0x2000u
#define CCM_ANALOG_PLL_SYS_TOG_ENABLE_SHIFT      13
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_SYS_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_MASK       0x10000u
#define CCM_ANALOG_PLL_SYS_TOG_BYPASS_SHIFT      16
#define CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_SYS_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_SYS_TOG_LOCK_MASK         0x80000000u
#define CCM_ANALOG_PLL_SYS_TOG_LOCK_SHIFT        31
/* PLL_SYS_SS Bit Fields */
#define CCM_ANALOG_PLL_SYS_SS_STEP_MASK          0x7FFFu
#define CCM_ANALOG_PLL_SYS_SS_STEP_SHIFT         0
#define CCM_ANALOG_PLL_SYS_SS_STEP(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_SS_STEP_SHIFT))&CCM_ANALOG_PLL_SYS_SS_STEP_MASK)
#define CCM_ANALOG_PLL_SYS_SS_ENABLE_MASK        0x8000u
#define CCM_ANALOG_PLL_SYS_SS_ENABLE_SHIFT       15
#define CCM_ANALOG_PLL_SYS_SS_STOP_MASK          0xFFFF0000u
#define CCM_ANALOG_PLL_SYS_SS_STOP_SHIFT         16
#define CCM_ANALOG_PLL_SYS_SS_STOP(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_SYS_SS_STOP_SHIFT))&CCM_ANALOG_PLL_SYS_SS_STOP_MASK)
/* PLL_AUDIO Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK     0x7Fu
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT    0
#define CCM_ANALOG_PLL_AUDIO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_MASK      0x1000u
#define CCM_ANALOG_PLL_AUDIO_POWERDOWN_SHIFT     12
#define CCM_ANALOG_PLL_AUDIO_ENABLE_MASK         0x2000u
#define CCM_ANALOG_PLL_AUDIO_ENABLE_SHIFT        13
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_BYPASS_MASK         0x10000u
#define CCM_ANALOG_PLL_AUDIO_BYPASS_SHIFT        16
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_MASK  0x40000u
#define CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_LOCK_MASK           0x80000000u
#define CCM_ANALOG_PLL_AUDIO_LOCK_SHIFT          31
/* PLL_AUDIO_SET Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_SET_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_AUDIO_SET_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_SET_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_SET_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_SET_LOCK_SHIFT      31
/* PLL_AUDIO_CLR Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_CLR_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_AUDIO_CLR_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_CLR_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_CLR_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_CLR_LOCK_SHIFT      31
/* PLL_AUDIO_TOG Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_AUDIO_TOG_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_AUDIO_TOG_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_AUDIO_TOG_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_AUDIO_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_AUDIO_TOG_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_AUDIO_TOG_LOCK_SHIFT      31
/* PLL_AUDIO_NUM Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_NUM_A_MASK          0x3FFFFFFFu
#define CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT         0
#define CCM_ANALOG_PLL_AUDIO_NUM_A(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_NUM_A_SHIFT))&CCM_ANALOG_PLL_AUDIO_NUM_A_MASK)
/* PLL_AUDIO_DENOM Bit Fields */
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK        0x3FFFFFFFu
#define CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT       0
#define CCM_ANALOG_PLL_AUDIO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_AUDIO_DENOM_B_SHIFT))&CCM_ANALOG_PLL_AUDIO_DENOM_B_MASK)
/* PLL_VIDEO Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK     0x7Fu
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT    0
#define CCM_ANALOG_PLL_VIDEO_DIV_SELECT(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_MASK      0x1000u
#define CCM_ANALOG_PLL_VIDEO_POWERDOWN_SHIFT     12
#define CCM_ANALOG_PLL_VIDEO_ENABLE_MASK         0x2000u
#define CCM_ANALOG_PLL_VIDEO_ENABLE_SHIFT        13
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_BYPASS_MASK         0x10000u
#define CCM_ANALOG_PLL_VIDEO_BYPASS_SHIFT        16
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_MASK  0x40000u
#define CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_LOCK_MASK           0x80000000u
#define CCM_ANALOG_PLL_VIDEO_LOCK_SHIFT          31
/* PLL_VIDEO_SET Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_SET_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_VIDEO_SET_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_SET_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_SET_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_SET_LOCK_SHIFT      31
/* PLL_VIDEO_CLR Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_CLR_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_VIDEO_CLR_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_CLR_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_CLR_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_CLR_LOCK_SHIFT      31
/* PLL_VIDEO_TOG Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK 0x7Fu
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_MASK  0x1000u
#define CCM_ANALOG_PLL_VIDEO_TOG_POWERDOWN_SHIFT 12
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_MASK     0x2000u
#define CCM_ANALOG_PLL_VIDEO_TOG_ENABLE_SHIFT    13
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_MASK     0x10000u
#define CCM_ANALOG_PLL_VIDEO_TOG_BYPASS_SHIFT    16
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_VIDEO_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_MASK 0x180000u
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_SHIFT 19
#define CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_VIDEO_TOG_POST_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_MASK       0x80000000u
#define CCM_ANALOG_PLL_VIDEO_TOG_LOCK_SHIFT      31
/* PLL_VIDEO_NUM Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_NUM_A_MASK          0x3FFFFFFFu
#define CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT         0
#define CCM_ANALOG_PLL_VIDEO_NUM_A(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_NUM_A_SHIFT))&CCM_ANALOG_PLL_VIDEO_NUM_A_MASK)
/* PLL_VIDEO_DENOM Bit Fields */
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK        0x3FFFFFFFu
#define CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT       0
#define CCM_ANALOG_PLL_VIDEO_DENOM_B(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_VIDEO_DENOM_B_SHIFT))&CCM_ANALOG_PLL_VIDEO_DENOM_B_MASK)
/* PLL_ENET Bit Fields */
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_MASK 0x3u
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_MASK 0xCu
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_SHIFT 2
#define CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT(x)  (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_POWERDOWN_MASK       0x1000u
#define CCM_ANALOG_PLL_ENET_POWERDOWN_SHIFT      12
#define CCM_ANALOG_PLL_ENET_ENET1_125M_EN_MASK   0x2000u
#define CCM_ANALOG_PLL_ENET_ENET1_125M_EN_SHIFT  13
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_MASK  0xC000u
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_BYPASS_MASK          0x10000u
#define CCM_ANALOG_PLL_ENET_BYPASS_SHIFT         16
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_MASK   0x40000u
#define CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN_SHIFT  18
#define CCM_ANALOG_PLL_ENET_ENABLE_125M_MASK     0x80000u
#define CCM_ANALOG_PLL_ENET_ENABLE_125M_SHIFT    19
#define CCM_ANALOG_PLL_ENET_ENET2_125M_EN_MASK   0x100000u
#define CCM_ANALOG_PLL_ENET_ENET2_125M_EN_SHIFT  20
#define CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_MASK 0x200000u
#define CCM_ANALOG_PLL_ENET_ENET_25M_REF_EN_SHIFT 21
#define CCM_ANALOG_PLL_ENET_LOCK_MASK            0x80000000u
#define CCM_ANALOG_PLL_ENET_LOCK_SHIFT           31
/* PLL_ENET_SET Bit Fields */
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_MASK 0x3u
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_SET_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_MASK 0xCu
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_SHIFT 2
#define CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_SET_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_SET_POWERDOWN_MASK   0x1000u
#define CCM_ANALOG_PLL_ENET_SET_POWERDOWN_SHIFT  12
#define CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_MASK 0x2000u
#define CCM_ANALOG_PLL_ENET_SET_ENET1_125M_EN_SHIFT 13
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ENET_SET_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_ENET_SET_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_ENET_SET_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_MASK 0x80000u
#define CCM_ANALOG_PLL_ENET_SET_ENABLE_125M_SHIFT 19
#define CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_MASK 0x100000u
#define CCM_ANALOG_PLL_ENET_SET_ENET2_125M_EN_SHIFT 20
#define CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_MASK 0x200000u
#define CCM_ANALOG_PLL_ENET_SET_ENET_25M_REF_EN_SHIFT 21
#define CCM_ANALOG_PLL_ENET_SET_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_ENET_SET_LOCK_SHIFT       31
/* PLL_ENET_CLR Bit Fields */
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_MASK 0x3u
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_CLR_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_MASK 0xCu
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_SHIFT 2
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_CLR_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_MASK   0x1000u
#define CCM_ANALOG_PLL_ENET_CLR_POWERDOWN_SHIFT  12
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_MASK 0x2000u
#define CCM_ANALOG_PLL_ENET_CLR_ENET1_125M_EN_SHIFT 13
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ENET_CLR_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_ENET_CLR_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_ENET_CLR_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_MASK 0x80000u
#define CCM_ANALOG_PLL_ENET_CLR_ENABLE_125M_SHIFT 19
#define CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_MASK 0x100000u
#define CCM_ANALOG_PLL_ENET_CLR_ENET2_125M_EN_SHIFT 20
#define CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_MASK 0x200000u
#define CCM_ANALOG_PLL_ENET_CLR_ENET_25M_REF_EN_SHIFT 21
#define CCM_ANALOG_PLL_ENET_CLR_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_ENET_CLR_LOCK_SHIFT       31
/* PLL_ENET_TOG Bit Fields */
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_MASK 0x3u
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_SHIFT 0
#define CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_TOG_ENET0_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_MASK 0xCu
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_SHIFT 2
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_SHIFT))&CCM_ANALOG_PLL_ENET_TOG_ENET1_DIV_SELECT_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_MASK   0x1000u
#define CCM_ANALOG_PLL_ENET_TOG_POWERDOWN_SHIFT  12
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_MASK 0x2000u
#define CCM_ANALOG_PLL_ENET_TOG_ENET1_125M_EN_SHIFT 13
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_MASK 0xC000u
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_SHIFT 14
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_SHIFT))&CCM_ANALOG_PLL_ENET_TOG_BYPASS_CLK_SRC_MASK)
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_MASK      0x10000u
#define CCM_ANALOG_PLL_ENET_TOG_BYPASS_SHIFT     16
#define CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_MASK 0x40000u
#define CCM_ANALOG_PLL_ENET_TOG_PFD_OFFSET_EN_SHIFT 18
#define CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_MASK 0x80000u
#define CCM_ANALOG_PLL_ENET_TOG_ENABLE_125M_SHIFT 19
#define CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_MASK 0x100000u
#define CCM_ANALOG_PLL_ENET_TOG_ENET2_125M_EN_SHIFT 20
#define CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_MASK 0x200000u
#define CCM_ANALOG_PLL_ENET_TOG_ENET_25M_REF_EN_SHIFT 21
#define CCM_ANALOG_PLL_ENET_TOG_LOCK_MASK        0x80000000u
#define CCM_ANALOG_PLL_ENET_TOG_LOCK_SHIFT       31
/* PFD_480 Bit Fields */
#define CCM_ANALOG_PFD_480_PFD0_FRAC_MASK        0x3Fu
#define CCM_ANALOG_PFD_480_PFD0_FRAC_SHIFT       0
#define CCM_ANALOG_PFD_480_PFD0_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_480_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD0_STABLE_MASK      0x40u
#define CCM_ANALOG_PFD_480_PFD0_STABLE_SHIFT     6
#define CCM_ANALOG_PFD_480_PFD0_CLKGATE_MASK     0x80u
#define CCM_ANALOG_PFD_480_PFD0_CLKGATE_SHIFT    7
#define CCM_ANALOG_PFD_480_PFD1_FRAC_MASK        0x3F00u
#define CCM_ANALOG_PFD_480_PFD1_FRAC_SHIFT       8
#define CCM_ANALOG_PFD_480_PFD1_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_480_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD1_STABLE_MASK      0x4000u
#define CCM_ANALOG_PFD_480_PFD1_STABLE_SHIFT     14
#define CCM_ANALOG_PFD_480_PFD1_CLKGATE_MASK     0x8000u
#define CCM_ANALOG_PFD_480_PFD1_CLKGATE_SHIFT    15
#define CCM_ANALOG_PFD_480_PFD2_FRAC_MASK        0x3F0000u
#define CCM_ANALOG_PFD_480_PFD2_FRAC_SHIFT       16
#define CCM_ANALOG_PFD_480_PFD2_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_480_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD2_STABLE_MASK      0x400000u
#define CCM_ANALOG_PFD_480_PFD2_STABLE_SHIFT     22
#define CCM_ANALOG_PFD_480_PFD2_CLKGATE_MASK     0x800000u
#define CCM_ANALOG_PFD_480_PFD2_CLKGATE_SHIFT    23
#define CCM_ANALOG_PFD_480_PFD3_FRAC_MASK        0x3F000000u
#define CCM_ANALOG_PFD_480_PFD3_FRAC_SHIFT       24
#define CCM_ANALOG_PFD_480_PFD3_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_480_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_PFD3_STABLE_MASK      0x40000000u
#define CCM_ANALOG_PFD_480_PFD3_STABLE_SHIFT     30
#define CCM_ANALOG_PFD_480_PFD3_CLKGATE_MASK     0x80000000u
#define CCM_ANALOG_PFD_480_PFD3_CLKGATE_SHIFT    31
/* PFD_480_SET Bit Fields */
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_480_SET_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_SET_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_480_SET_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_480_SET_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_480_SET_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_480_SET_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_SET_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_480_SET_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_480_SET_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_480_SET_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_480_SET_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_SET_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_480_SET_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_480_SET_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_480_SET_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_480_SET_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_SET_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_480_SET_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_SET_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_480_SET_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_480_SET_PFD3_CLKGATE_SHIFT 31
/* PFD_480_CLR Bit Fields */
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_480_CLR_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_480_CLR_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_480_CLR_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_480_CLR_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_480_CLR_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_480_CLR_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_480_CLR_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_480_CLR_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_480_CLR_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_480_CLR_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_480_CLR_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_480_CLR_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_480_CLR_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_480_CLR_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_480_CLR_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_480_CLR_PFD3_CLKGATE_SHIFT 31
/* PFD_480_TOG Bit Fields */
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_480_TOG_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_480_TOG_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_480_TOG_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_480_TOG_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_480_TOG_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_480_TOG_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_480_TOG_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_480_TOG_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_480_TOG_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_480_TOG_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_480_TOG_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_480_TOG_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_480_TOG_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_480_TOG_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_480_TOG_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_480_TOG_PFD3_CLKGATE_SHIFT 31
/* PFD_528 Bit Fields */
#define CCM_ANALOG_PFD_528_PFD0_FRAC_MASK        0x3Fu
#define CCM_ANALOG_PFD_528_PFD0_FRAC_SHIFT       0
#define CCM_ANALOG_PFD_528_PFD0_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_528_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD0_STABLE_MASK      0x40u
#define CCM_ANALOG_PFD_528_PFD0_STABLE_SHIFT     6
#define CCM_ANALOG_PFD_528_PFD0_CLKGATE_MASK     0x80u
#define CCM_ANALOG_PFD_528_PFD0_CLKGATE_SHIFT    7
#define CCM_ANALOG_PFD_528_PFD1_FRAC_MASK        0x3F00u
#define CCM_ANALOG_PFD_528_PFD1_FRAC_SHIFT       8
#define CCM_ANALOG_PFD_528_PFD1_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_528_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD1_STABLE_MASK      0x4000u
#define CCM_ANALOG_PFD_528_PFD1_STABLE_SHIFT     14
#define CCM_ANALOG_PFD_528_PFD1_CLKGATE_MASK     0x8000u
#define CCM_ANALOG_PFD_528_PFD1_CLKGATE_SHIFT    15
#define CCM_ANALOG_PFD_528_PFD2_FRAC_MASK        0x3F0000u
#define CCM_ANALOG_PFD_528_PFD2_FRAC_SHIFT       16
#define CCM_ANALOG_PFD_528_PFD2_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_528_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD2_STABLE_MASK      0x400000u
#define CCM_ANALOG_PFD_528_PFD2_STABLE_SHIFT     22
#define CCM_ANALOG_PFD_528_PFD2_CLKGATE_MASK     0x800000u
#define CCM_ANALOG_PFD_528_PFD2_CLKGATE_SHIFT    23
#define CCM_ANALOG_PFD_528_PFD3_FRAC_MASK        0x3F000000u
#define CCM_ANALOG_PFD_528_PFD3_FRAC_SHIFT       24
#define CCM_ANALOG_PFD_528_PFD3_FRAC(x)          (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_528_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_PFD3_STABLE_MASK      0x40000000u
#define CCM_ANALOG_PFD_528_PFD3_STABLE_SHIFT     30
#define CCM_ANALOG_PFD_528_PFD3_CLKGATE_MASK     0x80000000u
#define CCM_ANALOG_PFD_528_PFD3_CLKGATE_SHIFT    31
/* PFD_528_SET Bit Fields */
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_528_SET_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_SET_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_528_SET_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_528_SET_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_528_SET_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_528_SET_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_SET_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_528_SET_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_528_SET_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_528_SET_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_528_SET_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_SET_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_528_SET_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_528_SET_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_528_SET_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_528_SET_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_SET_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_528_SET_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_SET_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_528_SET_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_528_SET_PFD3_CLKGATE_SHIFT 31
/* PFD_528_CLR Bit Fields */
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_528_CLR_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_528_CLR_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_528_CLR_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_528_CLR_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_528_CLR_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_528_CLR_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_528_CLR_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_528_CLR_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_528_CLR_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_528_CLR_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_528_CLR_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_528_CLR_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_528_CLR_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_528_CLR_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_528_CLR_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_528_CLR_PFD3_CLKGATE_SHIFT 31
/* PFD_528_TOG Bit Fields */
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_MASK    0x3Fu
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_SHIFT   0
#define CCM_ANALOG_PFD_528_TOG_PFD0_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_SHIFT))&CCM_ANALOG_PFD_528_TOG_PFD0_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_MASK  0x40u
#define CCM_ANALOG_PFD_528_TOG_PFD0_STABLE_SHIFT 6
#define CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_MASK 0x80u
#define CCM_ANALOG_PFD_528_TOG_PFD0_CLKGATE_SHIFT 7
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_MASK    0x3F00u
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_SHIFT   8
#define CCM_ANALOG_PFD_528_TOG_PFD1_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_SHIFT))&CCM_ANALOG_PFD_528_TOG_PFD1_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_MASK  0x4000u
#define CCM_ANALOG_PFD_528_TOG_PFD1_STABLE_SHIFT 14
#define CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_MASK 0x8000u
#define CCM_ANALOG_PFD_528_TOG_PFD1_CLKGATE_SHIFT 15
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_MASK    0x3F0000u
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_SHIFT   16
#define CCM_ANALOG_PFD_528_TOG_PFD2_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_SHIFT))&CCM_ANALOG_PFD_528_TOG_PFD2_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_MASK  0x400000u
#define CCM_ANALOG_PFD_528_TOG_PFD2_STABLE_SHIFT 22
#define CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_MASK 0x800000u
#define CCM_ANALOG_PFD_528_TOG_PFD2_CLKGATE_SHIFT 23
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_MASK    0x3F000000u
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_SHIFT   24
#define CCM_ANALOG_PFD_528_TOG_PFD3_FRAC(x)      (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_SHIFT))&CCM_ANALOG_PFD_528_TOG_PFD3_FRAC_MASK)
#define CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_MASK  0x40000000u
#define CCM_ANALOG_PFD_528_TOG_PFD3_STABLE_SHIFT 30
#define CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_MASK 0x80000000u
#define CCM_ANALOG_PFD_528_TOG_PFD3_CLKGATE_SHIFT 31
/* MISC0 Bit Fields */
#define CCM_ANALOG_MISC0_REFTOP_PWD_MASK         0x1u
#define CCM_ANALOG_MISC0_REFTOP_PWD_SHIFT        0
#define CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_MASK 0x8u
#define CCM_ANALOG_MISC0_REFTOP_SELFBIASOFF_SHIFT 3
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ_MASK      0x70u
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ_SHIFT     4
#define CCM_ANALOG_MISC0_REFTOP_VBGADJ(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_REFTOP_VBGADJ_SHIFT))&CCM_ANALOG_MISC0_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_REFTOP_VBGUP_MASK       0x80u
#define CCM_ANALOG_MISC0_REFTOP_VBGUP_SHIFT      7
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG_MASK   0xC00u
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG_SHIFT  10
#define CCM_ANALOG_MISC0_STOP_MODE_CONFIG(x)     (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_STOP_MODE_CONFIG_SHIFT))&CCM_ANALOG_MISC0_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_RTC_RINGOSC_EN_MASK     0x1000u
#define CCM_ANALOG_MISC0_RTC_RINGOSC_EN_SHIFT    12
#define CCM_ANALOG_MISC0_OSC_I_MASK              0x6000u
#define CCM_ANALOG_MISC0_OSC_I_SHIFT             13
#define CCM_ANALOG_MISC0_OSC_I(x)                (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_OSC_I_SHIFT))&CCM_ANALOG_MISC0_OSC_I_MASK)
#define CCM_ANALOG_MISC0_OSC_XTALOK_MASK         0x8000u
#define CCM_ANALOG_MISC0_OSC_XTALOK_SHIFT        15
#define CCM_ANALOG_MISC0_OSC_XTALOK_EN_MASK      0x10000u
#define CCM_ANALOG_MISC0_OSC_XTALOK_EN_SHIFT     16
#define CCM_ANALOG_MISC0_CLKGATE_CTRL_MASK       0x2000000u
#define CCM_ANALOG_MISC0_CLKGATE_CTRL_SHIFT      25
#define CCM_ANALOG_MISC0_CLKGATE_DELAY_MASK      0x1C000000u
#define CCM_ANALOG_MISC0_CLKGATE_DELAY_SHIFT     26
#define CCM_ANALOG_MISC0_CLKGATE_DELAY(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_CLKGATE_DELAY_SHIFT))&CCM_ANALOG_MISC0_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_MASK    0x20000000u
#define CCM_ANALOG_MISC0_RTC_XTAL_SOURCE_SHIFT   29
#define CCM_ANALOG_MISC0_XTAL_24M_PWD_MASK       0x40000000u
#define CCM_ANALOG_MISC0_XTAL_24M_PWD_SHIFT      30
#define CCM_ANALOG_MISC0_VID_PLL_PREDIV_MASK     0x80000000u
#define CCM_ANALOG_MISC0_VID_PLL_PREDIV_SHIFT    31
/* MISC0_SET Bit Fields */
#define CCM_ANALOG_MISC0_SET_REFTOP_PWD_MASK     0x1u
#define CCM_ANALOG_MISC0_SET_REFTOP_PWD_SHIFT    0
#define CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_MASK 0x8u
#define CCM_ANALOG_MISC0_SET_REFTOP_SELFBIASOFF_SHIFT 3
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_MASK  0x70u
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_SHIFT 4
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_SHIFT))&CCM_ANALOG_MISC0_SET_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_MASK   0x80u
#define CCM_ANALOG_MISC0_SET_REFTOP_VBGUP_SHIFT  7
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_MASK 0xC00u
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_SHIFT 10
#define CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_SHIFT))&CCM_ANALOG_MISC0_SET_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_SET_RTC_RINGOSC_EN_MASK 0x1000u
#define CCM_ANALOG_MISC0_SET_RTC_RINGOSC_EN_SHIFT 12
#define CCM_ANALOG_MISC0_SET_OSC_I_MASK          0x6000u
#define CCM_ANALOG_MISC0_SET_OSC_I_SHIFT         13
#define CCM_ANALOG_MISC0_SET_OSC_I(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_SET_OSC_I_SHIFT))&CCM_ANALOG_MISC0_SET_OSC_I_MASK)
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_MASK     0x8000u
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_SHIFT    15
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_MASK  0x10000u
#define CCM_ANALOG_MISC0_SET_OSC_XTALOK_EN_SHIFT 16
#define CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_MASK   0x2000000u
#define CCM_ANALOG_MISC0_SET_CLKGATE_CTRL_SHIFT  25
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_MASK  0x1C000000u
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_SHIFT 26
#define CCM_ANALOG_MISC0_SET_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_SHIFT))&CCM_ANALOG_MISC0_SET_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_MASK 0x20000000u
#define CCM_ANALOG_MISC0_SET_RTC_XTAL_SOURCE_SHIFT 29
#define CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_MASK   0x40000000u
#define CCM_ANALOG_MISC0_SET_XTAL_24M_PWD_SHIFT  30
#define CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_MASK 0x80000000u
#define CCM_ANALOG_MISC0_SET_VID_PLL_PREDIV_SHIFT 31
/* MISC0_CLR Bit Fields */
#define CCM_ANALOG_MISC0_CLR_REFTOP_PWD_MASK     0x1u
#define CCM_ANALOG_MISC0_CLR_REFTOP_PWD_SHIFT    0
#define CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_MASK 0x8u
#define CCM_ANALOG_MISC0_CLR_REFTOP_SELFBIASOFF_SHIFT 3
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_MASK  0x70u
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_SHIFT 4
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_SHIFT))&CCM_ANALOG_MISC0_CLR_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_MASK   0x80u
#define CCM_ANALOG_MISC0_CLR_REFTOP_VBGUP_SHIFT  7
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_MASK 0xC00u
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_SHIFT 10
#define CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_SHIFT))&CCM_ANALOG_MISC0_CLR_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_CLR_RTC_RINGOSC_EN_MASK 0x1000u
#define CCM_ANALOG_MISC0_CLR_RTC_RINGOSC_EN_SHIFT 12
#define CCM_ANALOG_MISC0_CLR_OSC_I_MASK          0x6000u
#define CCM_ANALOG_MISC0_CLR_OSC_I_SHIFT         13
#define CCM_ANALOG_MISC0_CLR_OSC_I(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_CLR_OSC_I_SHIFT))&CCM_ANALOG_MISC0_CLR_OSC_I_MASK)
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_MASK     0x8000u
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_SHIFT    15
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_MASK  0x10000u
#define CCM_ANALOG_MISC0_CLR_OSC_XTALOK_EN_SHIFT 16
#define CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_MASK   0x2000000u
#define CCM_ANALOG_MISC0_CLR_CLKGATE_CTRL_SHIFT  25
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_MASK  0x1C000000u
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_SHIFT 26
#define CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_SHIFT))&CCM_ANALOG_MISC0_CLR_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_MASK 0x20000000u
#define CCM_ANALOG_MISC0_CLR_RTC_XTAL_SOURCE_SHIFT 29
#define CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_MASK   0x40000000u
#define CCM_ANALOG_MISC0_CLR_XTAL_24M_PWD_SHIFT  30
#define CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_MASK 0x80000000u
#define CCM_ANALOG_MISC0_CLR_VID_PLL_PREDIV_SHIFT 31
/* MISC0_TOG Bit Fields */
#define CCM_ANALOG_MISC0_TOG_REFTOP_PWD_MASK     0x1u
#define CCM_ANALOG_MISC0_TOG_REFTOP_PWD_SHIFT    0
#define CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_MASK 0x8u
#define CCM_ANALOG_MISC0_TOG_REFTOP_SELFBIASOFF_SHIFT 3
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_MASK  0x70u
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_SHIFT 4
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_SHIFT))&CCM_ANALOG_MISC0_TOG_REFTOP_VBGADJ_MASK)
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_MASK   0x80u
#define CCM_ANALOG_MISC0_TOG_REFTOP_VBGUP_SHIFT  7
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_MASK 0xC00u
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_SHIFT 10
#define CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG(x) (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_SHIFT))&CCM_ANALOG_MISC0_TOG_STOP_MODE_CONFIG_MASK)
#define CCM_ANALOG_MISC0_TOG_RTC_RINGOSC_EN_MASK 0x1000u
#define CCM_ANALOG_MISC0_TOG_RTC_RINGOSC_EN_SHIFT 12
#define CCM_ANALOG_MISC0_TOG_OSC_I_MASK          0x6000u
#define CCM_ANALOG_MISC0_TOG_OSC_I_SHIFT         13
#define CCM_ANALOG_MISC0_TOG_OSC_I(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_TOG_OSC_I_SHIFT))&CCM_ANALOG_MISC0_TOG_OSC_I_MASK)
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_MASK     0x8000u
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_SHIFT    15
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_MASK  0x10000u
#define CCM_ANALOG_MISC0_TOG_OSC_XTALOK_EN_SHIFT 16
#define CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_MASK   0x2000000u
#define CCM_ANALOG_MISC0_TOG_CLKGATE_CTRL_SHIFT  25
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_MASK  0x1C000000u
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_SHIFT 26
#define CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_SHIFT))&CCM_ANALOG_MISC0_TOG_CLKGATE_DELAY_MASK)
#define CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_MASK 0x20000000u
#define CCM_ANALOG_MISC0_TOG_RTC_XTAL_SOURCE_SHIFT 29
#define CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_MASK   0x40000000u
#define CCM_ANALOG_MISC0_TOG_XTAL_24M_PWD_SHIFT  30
#define CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_MASK 0x80000000u
#define CCM_ANALOG_MISC0_TOG_VID_PLL_PREDIV_SHIFT 31
/* MISC1 Bit Fields */
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL_MASK      0x1Fu
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL_SHIFT     0
#define CCM_ANALOG_MISC1_LVDS1_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_LVDS2_CLK_SEL_MASK      0x3E0u
#define CCM_ANALOG_MISC1_LVDS2_CLK_SEL_SHIFT     5
#define CCM_ANALOG_MISC1_LVDS2_CLK_SEL(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_LVDS2_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_LVDS2_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_LVDSCLK1_OBEN_MASK      0x400u
#define CCM_ANALOG_MISC1_LVDSCLK1_OBEN_SHIFT     10
#define CCM_ANALOG_MISC1_LVDSCLK2_OBEN_MASK      0x800u
#define CCM_ANALOG_MISC1_LVDSCLK2_OBEN_SHIFT     11
#define CCM_ANALOG_MISC1_LVDSCLK1_IBEN_MASK      0x1000u
#define CCM_ANALOG_MISC1_LVDSCLK1_IBEN_SHIFT     12
#define CCM_ANALOG_MISC1_LVDSCLK2_IBEN_MASK      0x2000u
#define CCM_ANALOG_MISC1_LVDSCLK2_IBEN_SHIFT     13
#define CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_MASK 0x10000u
#define CCM_ANALOG_MISC1_PFD_480_AUTOGATE_EN_SHIFT 16
#define CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_MASK 0x20000u
#define CCM_ANALOG_MISC1_PFD_528_AUTOGATE_EN_SHIFT 17
#define CCM_ANALOG_MISC1_IRQ_TEMPPANIC_MASK      0x8000000u
#define CCM_ANALOG_MISC1_IRQ_TEMPPANIC_SHIFT     27
#define CCM_ANALOG_MISC1_IRQ_TEMPLOW_MASK        0x10000000u
#define CCM_ANALOG_MISC1_IRQ_TEMPLOW_SHIFT       28
#define CCM_ANALOG_MISC1_IRQ_TEMPHIGH_MASK       0x20000000u
#define CCM_ANALOG_MISC1_IRQ_TEMPHIGH_SHIFT      29
#define CCM_ANALOG_MISC1_IRQ_ANA_BO_MASK         0x40000000u
#define CCM_ANALOG_MISC1_IRQ_ANA_BO_SHIFT        30
#define CCM_ANALOG_MISC1_IRQ_DIG_BO_MASK         0x80000000u
#define CCM_ANALOG_MISC1_IRQ_DIG_BO_SHIFT        31
/* MISC1_SET Bit Fields */
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_MASK  0x1Fu
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_SET_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_SET_LVDS2_CLK_SEL_MASK  0x3E0u
#define CCM_ANALOG_MISC1_SET_LVDS2_CLK_SEL_SHIFT 5
#define CCM_ANALOG_MISC1_SET_LVDS2_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_SET_LVDS2_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_SET_LVDS2_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_MASK  0x400u
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_OBEN_SHIFT 10
#define CCM_ANALOG_MISC1_SET_LVDSCLK2_OBEN_MASK  0x800u
#define CCM_ANALOG_MISC1_SET_LVDSCLK2_OBEN_SHIFT 11
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_MASK  0x1000u
#define CCM_ANALOG_MISC1_SET_LVDSCLK1_IBEN_SHIFT 12
#define CCM_ANALOG_MISC1_SET_LVDSCLK2_IBEN_MASK  0x2000u
#define CCM_ANALOG_MISC1_SET_LVDSCLK2_IBEN_SHIFT 13
#define CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_MASK 0x10000u
#define CCM_ANALOG_MISC1_SET_PFD_480_AUTOGATE_EN_SHIFT 16
#define CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_MASK 0x20000u
#define CCM_ANALOG_MISC1_SET_PFD_528_AUTOGATE_EN_SHIFT 17
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_MASK  0x8000000u
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPPANIC_SHIFT 27
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_MASK    0x10000000u
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPLOW_SHIFT   28
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_MASK   0x20000000u
#define CCM_ANALOG_MISC1_SET_IRQ_TEMPHIGH_SHIFT  29
#define CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_MASK     0x40000000u
#define CCM_ANALOG_MISC1_SET_IRQ_ANA_BO_SHIFT    30
#define CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_MASK     0x80000000u
#define CCM_ANALOG_MISC1_SET_IRQ_DIG_BO_SHIFT    31
/* MISC1_CLR Bit Fields */
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_MASK  0x1Fu
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_CLR_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_CLR_LVDS2_CLK_SEL_MASK  0x3E0u
#define CCM_ANALOG_MISC1_CLR_LVDS2_CLK_SEL_SHIFT 5
#define CCM_ANALOG_MISC1_CLR_LVDS2_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_CLR_LVDS2_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_CLR_LVDS2_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_MASK  0x400u
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_OBEN_SHIFT 10
#define CCM_ANALOG_MISC1_CLR_LVDSCLK2_OBEN_MASK  0x800u
#define CCM_ANALOG_MISC1_CLR_LVDSCLK2_OBEN_SHIFT 11
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_MASK  0x1000u
#define CCM_ANALOG_MISC1_CLR_LVDSCLK1_IBEN_SHIFT 12
#define CCM_ANALOG_MISC1_CLR_LVDSCLK2_IBEN_MASK  0x2000u
#define CCM_ANALOG_MISC1_CLR_LVDSCLK2_IBEN_SHIFT 13
#define CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_MASK 0x10000u
#define CCM_ANALOG_MISC1_CLR_PFD_480_AUTOGATE_EN_SHIFT 16
#define CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_MASK 0x20000u
#define CCM_ANALOG_MISC1_CLR_PFD_528_AUTOGATE_EN_SHIFT 17
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_MASK  0x8000000u
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPPANIC_SHIFT 27
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_MASK    0x10000000u
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPLOW_SHIFT   28
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_MASK   0x20000000u
#define CCM_ANALOG_MISC1_CLR_IRQ_TEMPHIGH_SHIFT  29
#define CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_MASK     0x40000000u
#define CCM_ANALOG_MISC1_CLR_IRQ_ANA_BO_SHIFT    30
#define CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_MASK     0x80000000u
#define CCM_ANALOG_MISC1_CLR_IRQ_DIG_BO_SHIFT    31
/* MISC1_TOG Bit Fields */
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_MASK  0x1Fu
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_SHIFT 0
#define CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_TOG_LVDS1_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_TOG_LVDS2_CLK_SEL_MASK  0x3E0u
#define CCM_ANALOG_MISC1_TOG_LVDS2_CLK_SEL_SHIFT 5
#define CCM_ANALOG_MISC1_TOG_LVDS2_CLK_SEL(x)    (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC1_TOG_LVDS2_CLK_SEL_SHIFT))&CCM_ANALOG_MISC1_TOG_LVDS2_CLK_SEL_MASK)
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_MASK  0x400u
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_OBEN_SHIFT 10
#define CCM_ANALOG_MISC1_TOG_LVDSCLK2_OBEN_MASK  0x800u
#define CCM_ANALOG_MISC1_TOG_LVDSCLK2_OBEN_SHIFT 11
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_MASK  0x1000u
#define CCM_ANALOG_MISC1_TOG_LVDSCLK1_IBEN_SHIFT 12
#define CCM_ANALOG_MISC1_TOG_LVDSCLK2_IBEN_MASK  0x2000u
#define CCM_ANALOG_MISC1_TOG_LVDSCLK2_IBEN_SHIFT 13
#define CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_MASK 0x10000u
#define CCM_ANALOG_MISC1_TOG_PFD_480_AUTOGATE_EN_SHIFT 16
#define CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_MASK 0x20000u
#define CCM_ANALOG_MISC1_TOG_PFD_528_AUTOGATE_EN_SHIFT 17
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_MASK  0x8000000u
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPPANIC_SHIFT 27
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_MASK    0x10000000u
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPLOW_SHIFT   28
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_MASK   0x20000000u
#define CCM_ANALOG_MISC1_TOG_IRQ_TEMPHIGH_SHIFT  29
#define CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_MASK     0x40000000u
#define CCM_ANALOG_MISC1_TOG_IRQ_ANA_BO_SHIFT    30
#define CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_MASK     0x80000000u
#define CCM_ANALOG_MISC1_TOG_IRQ_DIG_BO_SHIFT    31
/* MISC2 Bit Fields */
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET_MASK     0x7u
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET_SHIFT    0
#define CCM_ANALOG_MISC2_REG0_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG0_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG0_BO_STATUS_MASK     0x8u
#define CCM_ANALOG_MISC2_REG0_BO_STATUS_SHIFT    3
#define CCM_ANALOG_MISC2_REG0_ENABLE_BO_MASK     0x20u
#define CCM_ANALOG_MISC2_REG0_ENABLE_BO_SHIFT    5
#define CCM_ANALOG_MISC2_PLL3_disable_MASK       0x80u
#define CCM_ANALOG_MISC2_PLL3_disable_SHIFT      7
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET_MASK     0x700u
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET_SHIFT    8
#define CCM_ANALOG_MISC2_REG1_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG1_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG1_BO_STATUS_MASK     0x800u
#define CCM_ANALOG_MISC2_REG1_BO_STATUS_SHIFT    11
#define CCM_ANALOG_MISC2_REG1_ENABLE_BO_MASK     0x2000u
#define CCM_ANALOG_MISC2_REG1_ENABLE_BO_SHIFT    13
#define CCM_ANALOG_MISC2_AUDIO_DIV_LSB_MASK      0x8000u
#define CCM_ANALOG_MISC2_AUDIO_DIV_LSB_SHIFT     15
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET_MASK     0x70000u
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET_SHIFT    16
#define CCM_ANALOG_MISC2_REG2_BO_OFFSET(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG2_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_REG2_BO_STATUS_MASK     0x80000u
#define CCM_ANALOG_MISC2_REG2_BO_STATUS_SHIFT    19
#define CCM_ANALOG_MISC2_REG2_ENABLE_BO_MASK     0x200000u
#define CCM_ANALOG_MISC2_REG2_ENABLE_BO_SHIFT    21
#define CCM_ANALOG_MISC2_REG2_OK_MASK            0x400000u
#define CCM_ANALOG_MISC2_REG2_OK_SHIFT           22
#define CCM_ANALOG_MISC2_AUDIO_DIV_MSB_MASK      0x800000u
#define CCM_ANALOG_MISC2_AUDIO_DIV_MSB_SHIFT     23
#define CCM_ANALOG_MISC2_REG0_STEP_TIME_MASK     0x3000000u
#define CCM_ANALOG_MISC2_REG0_STEP_TIME_SHIFT    24
#define CCM_ANALOG_MISC2_REG0_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG0_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_REG1_STEP_TIME_MASK     0xC000000u
#define CCM_ANALOG_MISC2_REG1_STEP_TIME_SHIFT    26
#define CCM_ANALOG_MISC2_REG1_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG1_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_REG2_STEP_TIME_MASK     0x30000000u
#define CCM_ANALOG_MISC2_REG2_STEP_TIME_SHIFT    28
#define CCM_ANALOG_MISC2_REG2_STEP_TIME(x)       (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_REG2_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_VIDEO_DIV_MASK          0xC0000000u
#define CCM_ANALOG_MISC2_VIDEO_DIV_SHIFT         30
#define CCM_ANALOG_MISC2_VIDEO_DIV(x)            (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_VIDEO_DIV_SHIFT))&CCM_ANALOG_MISC2_VIDEO_DIV_MASK)
/* MISC2_SET Bit Fields */
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_MASK 0x7u
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_SHIFT 0
#define CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_SET_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_MASK 0x8u
#define CCM_ANALOG_MISC2_SET_REG0_BO_STATUS_SHIFT 3
#define CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_MASK 0x20u
#define CCM_ANALOG_MISC2_SET_REG0_ENABLE_BO_SHIFT 5
#define CCM_ANALOG_MISC2_SET_PLL3_disable_MASK   0x80u
#define CCM_ANALOG_MISC2_SET_PLL3_disable_SHIFT  7
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_MASK 0x700u
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_SHIFT 8
#define CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_SET_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_MASK 0x800u
#define CCM_ANALOG_MISC2_SET_REG1_BO_STATUS_SHIFT 11
#define CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_MASK 0x2000u
#define CCM_ANALOG_MISC2_SET_REG1_ENABLE_BO_SHIFT 13
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_MASK  0x8000u
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_LSB_SHIFT 15
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_MASK 0x70000u
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_SHIFT 16
#define CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_SET_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_MASK 0x80000u
#define CCM_ANALOG_MISC2_SET_REG2_BO_STATUS_SHIFT 19
#define CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_MASK 0x200000u
#define CCM_ANALOG_MISC2_SET_REG2_ENABLE_BO_SHIFT 21
#define CCM_ANALOG_MISC2_SET_REG2_OK_MASK        0x400000u
#define CCM_ANALOG_MISC2_SET_REG2_OK_SHIFT       22
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_MASK  0x800000u
#define CCM_ANALOG_MISC2_SET_AUDIO_DIV_MSB_SHIFT 23
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_MASK 0x3000000u
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_SHIFT 24
#define CCM_ANALOG_MISC2_SET_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_SET_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_MASK 0xC000000u
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_SHIFT 26
#define CCM_ANALOG_MISC2_SET_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_SET_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_MASK 0x30000000u
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_SHIFT 28
#define CCM_ANALOG_MISC2_SET_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_SET_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV_MASK      0xC0000000u
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV_SHIFT     30
#define CCM_ANALOG_MISC2_SET_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_SET_VIDEO_DIV_SHIFT))&CCM_ANALOG_MISC2_SET_VIDEO_DIV_MASK)
/* MISC2_CLR Bit Fields */
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_MASK 0x7u
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_SHIFT 0
#define CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_CLR_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_MASK 0x8u
#define CCM_ANALOG_MISC2_CLR_REG0_BO_STATUS_SHIFT 3
#define CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_MASK 0x20u
#define CCM_ANALOG_MISC2_CLR_REG0_ENABLE_BO_SHIFT 5
#define CCM_ANALOG_MISC2_CLR_PLL3_disable_MASK   0x80u
#define CCM_ANALOG_MISC2_CLR_PLL3_disable_SHIFT  7
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_MASK 0x700u
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_SHIFT 8
#define CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_CLR_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_MASK 0x800u
#define CCM_ANALOG_MISC2_CLR_REG1_BO_STATUS_SHIFT 11
#define CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_MASK 0x2000u
#define CCM_ANALOG_MISC2_CLR_REG1_ENABLE_BO_SHIFT 13
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_MASK  0x8000u
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_LSB_SHIFT 15
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_MASK 0x70000u
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_SHIFT 16
#define CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_CLR_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_MASK 0x80000u
#define CCM_ANALOG_MISC2_CLR_REG2_BO_STATUS_SHIFT 19
#define CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_MASK 0x200000u
#define CCM_ANALOG_MISC2_CLR_REG2_ENABLE_BO_SHIFT 21
#define CCM_ANALOG_MISC2_CLR_REG2_OK_MASK        0x400000u
#define CCM_ANALOG_MISC2_CLR_REG2_OK_SHIFT       22
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_MASK  0x800000u
#define CCM_ANALOG_MISC2_CLR_AUDIO_DIV_MSB_SHIFT 23
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_MASK 0x3000000u
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_SHIFT 24
#define CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_CLR_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_MASK 0xC000000u
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_SHIFT 26
#define CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_CLR_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_MASK 0x30000000u
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_SHIFT 28
#define CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_CLR_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV_MASK      0xC0000000u
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV_SHIFT     30
#define CCM_ANALOG_MISC2_CLR_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_CLR_VIDEO_DIV_SHIFT))&CCM_ANALOG_MISC2_CLR_VIDEO_DIV_MASK)
/* MISC2_TOG Bit Fields */
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_MASK 0x7u
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_SHIFT 0
#define CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_TOG_REG0_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_MASK 0x8u
#define CCM_ANALOG_MISC2_TOG_REG0_BO_STATUS_SHIFT 3
#define CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_MASK 0x20u
#define CCM_ANALOG_MISC2_TOG_REG0_ENABLE_BO_SHIFT 5
#define CCM_ANALOG_MISC2_TOG_PLL3_disable_MASK   0x80u
#define CCM_ANALOG_MISC2_TOG_PLL3_disable_SHIFT  7
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_MASK 0x700u
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_SHIFT 8
#define CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_TOG_REG1_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_MASK 0x800u
#define CCM_ANALOG_MISC2_TOG_REG1_BO_STATUS_SHIFT 11
#define CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_MASK 0x2000u
#define CCM_ANALOG_MISC2_TOG_REG1_ENABLE_BO_SHIFT 13
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_MASK  0x8000u
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_LSB_SHIFT 15
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_MASK 0x70000u
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_SHIFT 16
#define CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_SHIFT))&CCM_ANALOG_MISC2_TOG_REG2_BO_OFFSET_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_MASK 0x80000u
#define CCM_ANALOG_MISC2_TOG_REG2_BO_STATUS_SHIFT 19
#define CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_MASK 0x200000u
#define CCM_ANALOG_MISC2_TOG_REG2_ENABLE_BO_SHIFT 21
#define CCM_ANALOG_MISC2_TOG_REG2_OK_MASK        0x400000u
#define CCM_ANALOG_MISC2_TOG_REG2_OK_SHIFT       22
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_MASK  0x800000u
#define CCM_ANALOG_MISC2_TOG_AUDIO_DIV_MSB_SHIFT 23
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_MASK 0x3000000u
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_SHIFT 24
#define CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_TOG_REG0_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_MASK 0xC000000u
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_SHIFT 26
#define CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_TOG_REG1_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_MASK 0x30000000u
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_SHIFT 28
#define CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME(x)   (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_SHIFT))&CCM_ANALOG_MISC2_TOG_REG2_STEP_TIME_MASK)
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV_MASK      0xC0000000u
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV_SHIFT     30
#define CCM_ANALOG_MISC2_TOG_VIDEO_DIV(x)        (((uint32_t)(((uint32_t)(x))<<CCM_ANALOG_MISC2_TOG_VIDEO_DIV_SHIFT))&CCM_ANALOG_MISC2_TOG_VIDEO_DIV_MASK)

/*!
 * @}
 */ /* end of group CCM_ANALOG_Register_Masks */


/* CCM_ANALOG - Peripheral instance base addresses */
/** Peripheral CCM_ANALOG base pointer */
#define CCM_ANALOG_BASE_PTR                      ((CCM_ANALOG_MemMapPtr)0x420C8000u)
/** Array initializer of CCM_ANALOG peripheral base pointers */
#define CCM_ANALOG_BASE_PTRS                     { CCM_ANALOG_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CCM_ANALOG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Register_Accessor_Macros CCM_ANALOG - Register accessor macros
 * @{
 */


/* CCM_ANALOG - Register instance definitions */
/* CCM_ANALOG */
#define CCM_ANALOG_PLL_ARM                       CCM_ANALOG_PLL_ARM_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ARM_SET                   CCM_ANALOG_PLL_ARM_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ARM_CLR                   CCM_ANALOG_PLL_ARM_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ARM_TOG                   CCM_ANALOG_PLL_ARM_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB1                      CCM_ANALOG_PLL_USB1_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB1_SET                  CCM_ANALOG_PLL_USB1_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB1_CLR                  CCM_ANALOG_PLL_USB1_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB1_TOG                  CCM_ANALOG_PLL_USB1_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB2                      CCM_ANALOG_PLL_USB2_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB2_SET                  CCM_ANALOG_PLL_USB2_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB2_CLR                  CCM_ANALOG_PLL_USB2_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_USB2_TOG                  CCM_ANALOG_PLL_USB2_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_SYS                       CCM_ANALOG_PLL_SYS_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_SYS_SET                   CCM_ANALOG_PLL_SYS_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_SYS_CLR                   CCM_ANALOG_PLL_SYS_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_SYS_TOG                   CCM_ANALOG_PLL_SYS_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_SYS_SS                    CCM_ANALOG_PLL_SYS_SS_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO                     CCM_ANALOG_PLL_AUDIO_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO_SET                 CCM_ANALOG_PLL_AUDIO_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO_CLR                 CCM_ANALOG_PLL_AUDIO_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO_TOG                 CCM_ANALOG_PLL_AUDIO_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO_NUM                 CCM_ANALOG_PLL_AUDIO_NUM_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_AUDIO_DENOM               CCM_ANALOG_PLL_AUDIO_DENOM_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO                     CCM_ANALOG_PLL_VIDEO_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO_SET                 CCM_ANALOG_PLL_VIDEO_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO_CLR                 CCM_ANALOG_PLL_VIDEO_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO_TOG                 CCM_ANALOG_PLL_VIDEO_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO_NUM                 CCM_ANALOG_PLL_VIDEO_NUM_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_VIDEO_DENOM               CCM_ANALOG_PLL_VIDEO_DENOM_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ENET                      CCM_ANALOG_PLL_ENET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ENET_SET                  CCM_ANALOG_PLL_ENET_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ENET_CLR                  CCM_ANALOG_PLL_ENET_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PLL_ENET_TOG                  CCM_ANALOG_PLL_ENET_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_480                       CCM_ANALOG_PFD_480_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_480_SET                   CCM_ANALOG_PFD_480_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_480_CLR                   CCM_ANALOG_PFD_480_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_480_TOG                   CCM_ANALOG_PFD_480_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_528                       CCM_ANALOG_PFD_528_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_528_SET                   CCM_ANALOG_PFD_528_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_528_CLR                   CCM_ANALOG_PFD_528_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_PFD_528_TOG                   CCM_ANALOG_PFD_528_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC0                         CCM_ANALOG_MISC0_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC0_SET                     CCM_ANALOG_MISC0_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC0_CLR                     CCM_ANALOG_MISC0_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC0_TOG                     CCM_ANALOG_MISC0_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC1                         CCM_ANALOG_MISC1_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC1_SET                     CCM_ANALOG_MISC1_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC1_CLR                     CCM_ANALOG_MISC1_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC1_TOG                     CCM_ANALOG_MISC1_TOG_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC2                         CCM_ANALOG_MISC2_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC2_SET                     CCM_ANALOG_MISC2_SET_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC2_CLR                     CCM_ANALOG_MISC2_CLR_REG(CCM_ANALOG_BASE_PTR)
#define CCM_ANALOG_MISC2_TOG                     CCM_ANALOG_MISC2_TOG_REG(CCM_ANALOG_BASE_PTR)

/*!
 * @}
 */ /* end of group CCM_ANALOG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CCM_ANALOG_Peripheral */


/* ----------------------------------------------------------------------------
   -- CSI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Peripheral CSI
 * @{
 */

/** CSI - Peripheral register structure */
typedef struct CSI_MemMap {
  uint32_t CSICR1;                                 /**< CSI Control Register 1, offset: 0x0 */
  uint32_t CSICR2;                                 /**< CSI Control Register 2, offset: 0x4 */
  uint32_t CSICR3;                                 /**< CSI Control Register 3, offset: 0x8 */
  uint32_t CSISTATFIFO;                            /**< CSI Statistic FIFO Register, offset: 0xC */
  uint32_t CSIRFIFO;                               /**< CSI RX FIFO Register, offset: 0x10 */
  uint32_t CSIRXCNT;                               /**< CSI RX Count Register, offset: 0x14 */
  uint32_t CSISR;                                  /**< CSI Status Register, offset: 0x18 */
  uint8_t RESERVED_0[4];
  uint32_t CSIDMASA_STATFIFO;                      /**< CSI DMA Start Address Register - for STATFIFO, offset: 0x20 */
  uint32_t CSIDMATS_STATFIFO;                      /**< CSI DMA Transfer Size Register - for STATFIFO, offset: 0x24 */
  uint32_t CSIDMASA_FB1;                           /**< CSI DMA Start Address Register - for Frame Buffer1, offset: 0x28 */
  uint32_t CSIDMASA_FB2;                           /**< CSI DMA Transfer Size Register - for Frame Buffer2, offset: 0x2C */
  uint32_t CSIFBUF_PARA;                           /**< CSI Frame Buffer Parameter Register, offset: 0x30 */
  uint32_t CSIIMAG_PARA;                           /**< CSI Image Parameter Register, offset: 0x34 */
  uint8_t RESERVED_1[16];
  uint32_t CSICR18;                                /**< CSI Control Register 18, offset: 0x48 */
  uint32_t CSICR19;                                /**< CSI Control Register 19, offset: 0x4C */
} volatile *CSI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Register_Accessor_Macros CSI - Register accessor macros
 * @{
 */


/* CSI - Register accessors */
#define CSI_CSICR1_REG(base)                     ((base)->CSICR1)
#define CSI_CSICR2_REG(base)                     ((base)->CSICR2)
#define CSI_CSICR3_REG(base)                     ((base)->CSICR3)
#define CSI_CSISTATFIFO_REG(base)                ((base)->CSISTATFIFO)
#define CSI_CSIRFIFO_REG(base)                   ((base)->CSIRFIFO)
#define CSI_CSIRXCNT_REG(base)                   ((base)->CSIRXCNT)
#define CSI_CSISR_REG(base)                      ((base)->CSISR)
#define CSI_CSIDMASA_STATFIFO_REG(base)          ((base)->CSIDMASA_STATFIFO)
#define CSI_CSIDMATS_STATFIFO_REG(base)          ((base)->CSIDMATS_STATFIFO)
#define CSI_CSIDMASA_FB1_REG(base)               ((base)->CSIDMASA_FB1)
#define CSI_CSIDMASA_FB2_REG(base)               ((base)->CSIDMASA_FB2)
#define CSI_CSIFBUF_PARA_REG(base)               ((base)->CSIFBUF_PARA)
#define CSI_CSIIMAG_PARA_REG(base)               ((base)->CSIIMAG_PARA)
#define CSI_CSICR18_REG(base)                    ((base)->CSICR18)
#define CSI_CSICR19_REG(base)                    ((base)->CSICR19)

/*!
 * @}
 */ /* end of group CSI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CSI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Register_Masks CSI Register Masks
 * @{
 */

/* CSICR1 Bit Fields */
#define CSI_CSICR1_PIXEL_BIT_MASK                0x1u
#define CSI_CSICR1_PIXEL_BIT_SHIFT               0
#define CSI_CSICR1_REDGE_MASK                    0x2u
#define CSI_CSICR1_REDGE_SHIFT                   1
#define CSI_CSICR1_INV_PCLK_MASK                 0x4u
#define CSI_CSICR1_INV_PCLK_SHIFT                2
#define CSI_CSICR1_INV_DATA_MASK                 0x8u
#define CSI_CSICR1_INV_DATA_SHIFT                3
#define CSI_CSICR1_GCLK_MODE_MASK                0x10u
#define CSI_CSICR1_GCLK_MODE_SHIFT               4
#define CSI_CSICR1_CLR_RXFIFO_MASK               0x20u
#define CSI_CSICR1_CLR_RXFIFO_SHIFT              5
#define CSI_CSICR1_CLR_STATFIFO_MASK             0x40u
#define CSI_CSICR1_CLR_STATFIFO_SHIFT            6
#define CSI_CSICR1_PACK_DIR_MASK                 0x80u
#define CSI_CSICR1_PACK_DIR_SHIFT                7
#define CSI_CSICR1_FCC_MASK                      0x100u
#define CSI_CSICR1_FCC_SHIFT                     8
#define CSI_CSICR1_CCIR_EN_MASK                  0x400u
#define CSI_CSICR1_CCIR_EN_SHIFT                 10
#define CSI_CSICR1_HSYNC_POL_MASK                0x800u
#define CSI_CSICR1_HSYNC_POL_SHIFT               11
#define CSI_CSICR1_SOF_INTEN_MASK                0x10000u
#define CSI_CSICR1_SOF_INTEN_SHIFT               16
#define CSI_CSICR1_SOF_POL_MASK                  0x20000u
#define CSI_CSICR1_SOF_POL_SHIFT                 17
#define CSI_CSICR1_RXFF_INTEN_MASK               0x40000u
#define CSI_CSICR1_RXFF_INTEN_SHIFT              18
#define CSI_CSICR1_FB1_DMA_DONE_INTEN_MASK       0x80000u
#define CSI_CSICR1_FB1_DMA_DONE_INTEN_SHIFT      19
#define CSI_CSICR1_FB2_DMA_DONE_INTEN_MASK       0x100000u
#define CSI_CSICR1_FB2_DMA_DONE_INTEN_SHIFT      20
#define CSI_CSICR1_STATFF_INTEN_MASK             0x200000u
#define CSI_CSICR1_STATFF_INTEN_SHIFT            21
#define CSI_CSICR1_SFF_DMA_DONE_INTEN_MASK       0x400000u
#define CSI_CSICR1_SFF_DMA_DONE_INTEN_SHIFT      22
#define CSI_CSICR1_RF_OR_INTEN_MASK              0x1000000u
#define CSI_CSICR1_RF_OR_INTEN_SHIFT             24
#define CSI_CSICR1_SF_OR_INTEN_MASK              0x2000000u
#define CSI_CSICR1_SF_OR_INTEN_SHIFT             25
#define CSI_CSICR1_COF_INT_EN_MASK               0x4000000u
#define CSI_CSICR1_COF_INT_EN_SHIFT              26
#define CSI_CSICR1_VIDEO_MODE_MASK               0x8000000u
#define CSI_CSICR1_VIDEO_MODE_SHIFT              27
#define CSI_CSICR1_PrP_IF_EN_MASK                0x10000000u
#define CSI_CSICR1_PrP_IF_EN_SHIFT               28
#define CSI_CSICR1_EOF_INT_EN_MASK               0x20000000u
#define CSI_CSICR1_EOF_INT_EN_SHIFT              29
#define CSI_CSICR1_EXT_VSYNC_MASK                0x40000000u
#define CSI_CSICR1_EXT_VSYNC_SHIFT               30
#define CSI_CSICR1_SWAP16_EN_MASK                0x80000000u
#define CSI_CSICR1_SWAP16_EN_SHIFT               31
/* CSICR2 Bit Fields */
#define CSI_CSICR2_HSC_MASK                      0xFFu
#define CSI_CSICR2_HSC_SHIFT                     0
#define CSI_CSICR2_HSC(x)                        (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_HSC_SHIFT))&CSI_CSICR2_HSC_MASK)
#define CSI_CSICR2_VSC_MASK                      0xFF00u
#define CSI_CSICR2_VSC_SHIFT                     8
#define CSI_CSICR2_VSC(x)                        (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_VSC_SHIFT))&CSI_CSICR2_VSC_MASK)
#define CSI_CSICR2_LVRM_MASK                     0x70000u
#define CSI_CSICR2_LVRM_SHIFT                    16
#define CSI_CSICR2_LVRM(x)                       (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_LVRM_SHIFT))&CSI_CSICR2_LVRM_MASK)
#define CSI_CSICR2_BTS_MASK                      0x180000u
#define CSI_CSICR2_BTS_SHIFT                     19
#define CSI_CSICR2_BTS(x)                        (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_BTS_SHIFT))&CSI_CSICR2_BTS_MASK)
#define CSI_CSICR2_SCE_MASK                      0x800000u
#define CSI_CSICR2_SCE_SHIFT                     23
#define CSI_CSICR2_AFS_MASK                      0x3000000u
#define CSI_CSICR2_AFS_SHIFT                     24
#define CSI_CSICR2_AFS(x)                        (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_AFS_SHIFT))&CSI_CSICR2_AFS_MASK)
#define CSI_CSICR2_DRM_MASK                      0x4000000u
#define CSI_CSICR2_DRM_SHIFT                     26
#define CSI_CSICR2_DMA_BURST_TYPE_SFF_MASK       0x30000000u
#define CSI_CSICR2_DMA_BURST_TYPE_SFF_SHIFT      28
#define CSI_CSICR2_DMA_BURST_TYPE_SFF(x)         (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_DMA_BURST_TYPE_SFF_SHIFT))&CSI_CSICR2_DMA_BURST_TYPE_SFF_MASK)
#define CSI_CSICR2_DMA_BURST_TYPE_RFF_MASK       0xC0000000u
#define CSI_CSICR2_DMA_BURST_TYPE_RFF_SHIFT      30
#define CSI_CSICR2_DMA_BURST_TYPE_RFF(x)         (((uint32_t)(((uint32_t)(x))<<CSI_CSICR2_DMA_BURST_TYPE_RFF_SHIFT))&CSI_CSICR2_DMA_BURST_TYPE_RFF_MASK)
/* CSICR3 Bit Fields */
#define CSI_CSICR3_ECC_AUTO_EN_MASK              0x1u
#define CSI_CSICR3_ECC_AUTO_EN_SHIFT             0
#define CSI_CSICR3_ECC_INT_EN_MASK               0x2u
#define CSI_CSICR3_ECC_INT_EN_SHIFT              1
#define CSI_CSICR3_ZERO_PACK_EN_MASK             0x4u
#define CSI_CSICR3_ZERO_PACK_EN_SHIFT            2
#define CSI_CSICR3_TWO_8BIT_SENSOR_MASK          0x8u
#define CSI_CSICR3_TWO_8BIT_SENSOR_SHIFT         3
#define CSI_CSICR3_RxFF_LEVEL_MASK               0x70u
#define CSI_CSICR3_RxFF_LEVEL_SHIFT              4
#define CSI_CSICR3_RxFF_LEVEL(x)                 (((uint32_t)(((uint32_t)(x))<<CSI_CSICR3_RxFF_LEVEL_SHIFT))&CSI_CSICR3_RxFF_LEVEL_MASK)
#define CSI_CSICR3_HRESP_ERR_EN_MASK             0x80u
#define CSI_CSICR3_HRESP_ERR_EN_SHIFT            7
#define CSI_CSICR3_STATFF_LEVEL_MASK             0x700u
#define CSI_CSICR3_STATFF_LEVEL_SHIFT            8
#define CSI_CSICR3_STATFF_LEVEL(x)               (((uint32_t)(((uint32_t)(x))<<CSI_CSICR3_STATFF_LEVEL_SHIFT))&CSI_CSICR3_STATFF_LEVEL_MASK)
#define CSI_CSICR3_DMA_REQ_EN_SFF_MASK           0x800u
#define CSI_CSICR3_DMA_REQ_EN_SFF_SHIFT          11
#define CSI_CSICR3_DMA_REQ_EN_RFF_MASK           0x1000u
#define CSI_CSICR3_DMA_REQ_EN_RFF_SHIFT          12
#define CSI_CSICR3_DMA_REFLASH_SFF_MASK          0x2000u
#define CSI_CSICR3_DMA_REFLASH_SFF_SHIFT         13
#define CSI_CSICR3_DMA_REFLASH_RFF_MASK          0x4000u
#define CSI_CSICR3_DMA_REFLASH_RFF_SHIFT         14
#define CSI_CSICR3_FRMCNT_RST_MASK               0x8000u
#define CSI_CSICR3_FRMCNT_RST_SHIFT              15
#define CSI_CSICR3_FRMCNT_MASK                   0xFFFF0000u
#define CSI_CSICR3_FRMCNT_SHIFT                  16
#define CSI_CSICR3_FRMCNT(x)                     (((uint32_t)(((uint32_t)(x))<<CSI_CSICR3_FRMCNT_SHIFT))&CSI_CSICR3_FRMCNT_MASK)
/* CSISTATFIFO Bit Fields */
#define CSI_CSISTATFIFO_STAT_MASK                0xFFFFFFFFu
#define CSI_CSISTATFIFO_STAT_SHIFT               0
#define CSI_CSISTATFIFO_STAT(x)                  (((uint32_t)(((uint32_t)(x))<<CSI_CSISTATFIFO_STAT_SHIFT))&CSI_CSISTATFIFO_STAT_MASK)
/* CSIRFIFO Bit Fields */
#define CSI_CSIRFIFO_IMAGE_MASK                  0xFFFFFFFFu
#define CSI_CSIRFIFO_IMAGE_SHIFT                 0
#define CSI_CSIRFIFO_IMAGE(x)                    (((uint32_t)(((uint32_t)(x))<<CSI_CSIRFIFO_IMAGE_SHIFT))&CSI_CSIRFIFO_IMAGE_MASK)
/* CSIRXCNT Bit Fields */
#define CSI_CSIRXCNT_RXCNT_MASK                  0x3FFFFFu
#define CSI_CSIRXCNT_RXCNT_SHIFT                 0
#define CSI_CSIRXCNT_RXCNT(x)                    (((uint32_t)(((uint32_t)(x))<<CSI_CSIRXCNT_RXCNT_SHIFT))&CSI_CSIRXCNT_RXCNT_MASK)
/* CSISR Bit Fields */
#define CSI_CSISR_DRDY_MASK                      0x1u
#define CSI_CSISR_DRDY_SHIFT                     0
#define CSI_CSISR_ECC_INT_MASK                   0x2u
#define CSI_CSISR_ECC_INT_SHIFT                  1
#define CSI_CSISR_HRESP_ERR_INT_MASK             0x80u
#define CSI_CSISR_HRESP_ERR_INT_SHIFT            7
#define CSI_CSISR_COF_INT_MASK                   0x2000u
#define CSI_CSISR_COF_INT_SHIFT                  13
#define CSI_CSISR_F1_INT_MASK                    0x4000u
#define CSI_CSISR_F1_INT_SHIFT                   14
#define CSI_CSISR_F2_INT_MASK                    0x8000u
#define CSI_CSISR_F2_INT_SHIFT                   15
#define CSI_CSISR_SOF_INT_MASK                   0x10000u
#define CSI_CSISR_SOF_INT_SHIFT                  16
#define CSI_CSISR_EOF_INT_MASK                   0x20000u
#define CSI_CSISR_EOF_INT_SHIFT                  17
#define CSI_CSISR_RxFF_INT_MASK                  0x40000u
#define CSI_CSISR_RxFF_INT_SHIFT                 18
#define CSI_CSISR_DMA_TSF_DONE_FB1_MASK          0x80000u
#define CSI_CSISR_DMA_TSF_DONE_FB1_SHIFT         19
#define CSI_CSISR_DMA_TSF_DONE_FB2_MASK          0x100000u
#define CSI_CSISR_DMA_TSF_DONE_FB2_SHIFT         20
#define CSI_CSISR_STATFF_INT_MASK                0x200000u
#define CSI_CSISR_STATFF_INT_SHIFT               21
#define CSI_CSISR_DMA_TSF_DONE_SFF_MASK          0x400000u
#define CSI_CSISR_DMA_TSF_DONE_SFF_SHIFT         22
#define CSI_CSISR_RF_OR_INT_MASK                 0x1000000u
#define CSI_CSISR_RF_OR_INT_SHIFT                24
#define CSI_CSISR_SF_OR_INT_MASK                 0x2000000u
#define CSI_CSISR_SF_OR_INT_SHIFT                25
#define CSI_CSISR_DMA_FIELD1_DONE_MASK           0x4000000u
#define CSI_CSISR_DMA_FIELD1_DONE_SHIFT          26
#define CSI_CSISR_DMA_FIELD0_DONE_MASK           0x8000000u
#define CSI_CSISR_DMA_FIELD0_DONE_SHIFT          27
#define CSI_CSISR_BASEADDR_CHHANGE_ERROR_MASK    0x10000000u
#define CSI_CSISR_BASEADDR_CHHANGE_ERROR_SHIFT   28
/* CSIDMASA_STATFIFO Bit Fields */
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_MASK 0xFFFFFFFCu
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_SHIFT 2
#define CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(x) (((uint32_t)(((uint32_t)(x))<<CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_SHIFT))&CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF_MASK)
/* CSIDMATS_STATFIFO Bit Fields */
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_MASK 0xFFFFFFFFu
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_SHIFT 0
#define CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF(x) (((uint32_t)(((uint32_t)(x))<<CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_SHIFT))&CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF_MASK)
/* CSIDMASA_FB1 Bit Fields */
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_MASK 0xFFFFFFFCu
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_SHIFT 2
#define CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(x)   (((uint32_t)(((uint32_t)(x))<<CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_SHIFT))&CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1_MASK)
/* CSIDMASA_FB2 Bit Fields */
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_MASK 0xFFFFFFFCu
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_SHIFT 2
#define CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(x)   (((uint32_t)(((uint32_t)(x))<<CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_SHIFT))&CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2_MASK)
/* CSIFBUF_PARA Bit Fields */
#define CSI_CSIFBUF_PARA_FBUF_STRIDE_MASK        0xFFFFu
#define CSI_CSIFBUF_PARA_FBUF_STRIDE_SHIFT       0
#define CSI_CSIFBUF_PARA_FBUF_STRIDE(x)          (((uint32_t)(((uint32_t)(x))<<CSI_CSIFBUF_PARA_FBUF_STRIDE_SHIFT))&CSI_CSIFBUF_PARA_FBUF_STRIDE_MASK)
/* CSIIMAG_PARA Bit Fields */
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT_MASK       0xFFFFu
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT_SHIFT      0
#define CSI_CSIIMAG_PARA_IMAGE_HEIGHT(x)         (((uint32_t)(((uint32_t)(x))<<CSI_CSIIMAG_PARA_IMAGE_HEIGHT_SHIFT))&CSI_CSIIMAG_PARA_IMAGE_HEIGHT_MASK)
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH_MASK        0xFFFF0000u
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH_SHIFT       16
#define CSI_CSIIMAG_PARA_IMAGE_WIDTH(x)          (((uint32_t)(((uint32_t)(x))<<CSI_CSIIMAG_PARA_IMAGE_WIDTH_SHIFT))&CSI_CSIIMAG_PARA_IMAGE_WIDTH_MASK)
/* CSICR18 Bit Fields */
#define CSI_CSICR18_NTSC_EN_MASK                 0x1u
#define CSI_CSICR18_NTSC_EN_SHIFT                0
#define CSI_CSICR18_TVDECODER_IN_EN_MASK         0x2u
#define CSI_CSICR18_TVDECODER_IN_EN_SHIFT        1
#define CSI_CSICR18_DEINTERLACE_EN_MASK          0x4u
#define CSI_CSICR18_DEINTERLACE_EN_SHIFT         2
#define CSI_CSICR18_PARALLEL24_EN_MASK           0x8u
#define CSI_CSICR18_PARALLEL24_EN_SHIFT          3
#define CSI_CSICR18_BASEADDR_SWITCH_EN_MASK      0x10u
#define CSI_CSICR18_BASEADDR_SWITCH_EN_SHIFT     4
#define CSI_CSICR18_BASEADDR_SWITCH_SEL_MASK     0x20u
#define CSI_CSICR18_BASEADDR_SWITCH_SEL_SHIFT    5
#define CSI_CSICR18_FIELD0_DONE_IE_MASK          0x40u
#define CSI_CSICR18_FIELD0_DONE_IE_SHIFT         6
#define CSI_CSICR18_DMA_FIELD1_DONE_IE_MASK      0x80u
#define CSI_CSICR18_DMA_FIELD1_DONE_IE_SHIFT     7
#define CSI_CSICR18_LAST_DMA_REQ_SEL_MASK        0x100u
#define CSI_CSICR18_LAST_DMA_REQ_SEL_SHIFT       8
#define CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_MASK 0x200u
#define CSI_CSICR18_BASEADDR_CHANGE_ERROR_IE_SHIFT 9
#define CSI_CSICR18_RGB888A_FORMAT_SEL_MASK      0x400u
#define CSI_CSICR18_RGB888A_FORMAT_SEL_SHIFT     10
#define CSI_CSICR18_AHB_HPROT_MASK               0xF000u
#define CSI_CSICR18_AHB_HPROT_SHIFT              12
#define CSI_CSICR18_AHB_HPROT(x)                 (((uint32_t)(((uint32_t)(x))<<CSI_CSICR18_AHB_HPROT_SHIFT))&CSI_CSICR18_AHB_HPROT_MASK)
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_MASK  0x30000u
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_SHIFT 16
#define CSI_CSICR18_CSI_LCDIF_BUFFER_LINES(x)    (((uint32_t)(((uint32_t)(x))<<CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_SHIFT))&CSI_CSICR18_CSI_LCDIF_BUFFER_LINES_MASK)
#define CSI_CSICR18_MASK_OPTION_MASK             0xC0000u
#define CSI_CSICR18_MASK_OPTION_SHIFT            18
#define CSI_CSICR18_MASK_OPTION(x)               (((uint32_t)(((uint32_t)(x))<<CSI_CSICR18_MASK_OPTION_SHIFT))&CSI_CSICR18_MASK_OPTION_MASK)
#define CSI_CSICR18_CSI_ENABLE_MASK              0x80000000u
#define CSI_CSICR18_CSI_ENABLE_SHIFT             31
/* CSICR19 Bit Fields */
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_MASK 0xFFu
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_SHIFT 0
#define CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL(x) (((uint32_t)(((uint32_t)(x))<<CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_SHIFT))&CSI_CSICR19_DMA_RFIFO_HIGHEST_FIFO_LEVEL_MASK)

/*!
 * @}
 */ /* end of group CSI_Register_Masks */


/* CSI - Peripheral instance base addresses */
/** Peripheral CSI1 base pointer */
#define CSI1_BASE_PTR                            ((CSI_MemMapPtr)0x42214000u)
/** Peripheral CSI2 base pointer */
#define CSI2_BASE_PTR                            ((CSI_MemMapPtr)0x4221C000u)
/** Array initializer of CSI peripheral base pointers */
#define CSI_BASE_PTRS                            { CSI1_BASE_PTR, CSI2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSI_Register_Accessor_Macros CSI - Register accessor macros
 * @{
 */


/* CSI - Register instance definitions */
/* CSI1 */
#define CSI1_CSICR1                              CSI_CSICR1_REG(CSI1_BASE_PTR)
#define CSI1_CSICR2                              CSI_CSICR2_REG(CSI1_BASE_PTR)
#define CSI1_CSICR3                              CSI_CSICR3_REG(CSI1_BASE_PTR)
#define CSI1_CSISTATFIFO                         CSI_CSISTATFIFO_REG(CSI1_BASE_PTR)
#define CSI1_CSIRFIFO                            CSI_CSIRFIFO_REG(CSI1_BASE_PTR)
#define CSI1_CSIRXCNT                            CSI_CSIRXCNT_REG(CSI1_BASE_PTR)
#define CSI1_CSISR                               CSI_CSISR_REG(CSI1_BASE_PTR)
#define CSI1_CSIDMASA_STATFIFO                   CSI_CSIDMASA_STATFIFO_REG(CSI1_BASE_PTR)
#define CSI1_CSIDMATS_STATFIFO                   CSI_CSIDMATS_STATFIFO_REG(CSI1_BASE_PTR)
#define CSI1_CSIDMASA_FB1                        CSI_CSIDMASA_FB1_REG(CSI1_BASE_PTR)
#define CSI1_CSIDMASA_FB2                        CSI_CSIDMASA_FB2_REG(CSI1_BASE_PTR)
#define CSI1_CSIFBUF_PARA                        CSI_CSIFBUF_PARA_REG(CSI1_BASE_PTR)
#define CSI1_CSIIMAG_PARA                        CSI_CSIIMAG_PARA_REG(CSI1_BASE_PTR)
#define CSI1_CSICR18                             CSI_CSICR18_REG(CSI1_BASE_PTR)
#define CSI1_CSICR19                             CSI_CSICR19_REG(CSI1_BASE_PTR)
/* CSI2 */
#define CSI2_CSICR1                              CSI_CSICR1_REG(CSI2_BASE_PTR)
#define CSI2_CSICR2                              CSI_CSICR2_REG(CSI2_BASE_PTR)
#define CSI2_CSICR3                              CSI_CSICR3_REG(CSI2_BASE_PTR)
#define CSI2_CSISTATFIFO                         CSI_CSISTATFIFO_REG(CSI2_BASE_PTR)
#define CSI2_CSIRFIFO                            CSI_CSIRFIFO_REG(CSI2_BASE_PTR)
#define CSI2_CSIRXCNT                            CSI_CSIRXCNT_REG(CSI2_BASE_PTR)
#define CSI2_CSISR                               CSI_CSISR_REG(CSI2_BASE_PTR)
#define CSI2_CSIDMASA_STATFIFO                   CSI_CSIDMASA_STATFIFO_REG(CSI2_BASE_PTR)
#define CSI2_CSIDMATS_STATFIFO                   CSI_CSIDMATS_STATFIFO_REG(CSI2_BASE_PTR)
#define CSI2_CSIDMASA_FB1                        CSI_CSIDMASA_FB1_REG(CSI2_BASE_PTR)
#define CSI2_CSIDMASA_FB2                        CSI_CSIDMASA_FB2_REG(CSI2_BASE_PTR)
#define CSI2_CSIFBUF_PARA                        CSI_CSIFBUF_PARA_REG(CSI2_BASE_PTR)
#define CSI2_CSIIMAG_PARA                        CSI_CSIIMAG_PARA_REG(CSI2_BASE_PTR)
#define CSI2_CSICR18                             CSI_CSICR18_REG(CSI2_BASE_PTR)
#define CSI2_CSICR19                             CSI_CSICR19_REG(CSI2_BASE_PTR)

/*!
 * @}
 */ /* end of group CSI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CSI_Peripheral */


/* ----------------------------------------------------------------------------
   -- DCIC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCIC_Peripheral DCIC
 * @{
 */

/** DCIC - Peripheral register structure */
typedef struct DCIC_MemMap {
  uint32_t DCICC;                                  /**< DCIC Control Register, offset: 0x0 */
  uint32_t DCICIC;                                 /**< DCIC Interrupt Control Register, offset: 0x4 */
  uint32_t DCICS;                                  /**< DCIC Status Register, offset: 0x8 */
  uint8_t RESERVED_0[4];
  uint32_t DCICRC;                                 /**< DCIC ROI Config Register m, offset: 0x10 */
  uint32_t DCICRS;                                 /**< DCIC ROI Size Register m, offset: 0x14 */
  uint32_t DCICRRS;                                /**< DCIC ROI Reference Signature Register m, offset: 0x18 */
  uint32_t DCICRCS;                                /**< DCIC ROI Calculated Signature m, offset: 0x1C */
} volatile *DCIC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DCIC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCIC_Register_Accessor_Macros DCIC - Register accessor macros
 * @{
 */


/* DCIC - Register accessors */
#define DCIC_DCICC_REG(base)                     ((base)->DCICC)
#define DCIC_DCICIC_REG(base)                    ((base)->DCICIC)
#define DCIC_DCICS_REG(base)                     ((base)->DCICS)
#define DCIC_DCICRC_REG(base)                    ((base)->DCICRC)
#define DCIC_DCICRS_REG(base)                    ((base)->DCICRS)
#define DCIC_DCICRRS_REG(base)                   ((base)->DCICRRS)
#define DCIC_DCICRCS_REG(base)                   ((base)->DCICRCS)

/*!
 * @}
 */ /* end of group DCIC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DCIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCIC_Register_Masks DCIC Register Masks
 * @{
 */

/* DCICC Bit Fields */
#define DCIC_DCICC_IC_EN_MASK                    0x1u
#define DCIC_DCICC_IC_EN_SHIFT                   0
#define DCIC_DCICC_DE_POL_MASK                   0x10u
#define DCIC_DCICC_DE_POL_SHIFT                  4
#define DCIC_DCICC_HSYNC_POL_MASK                0x20u
#define DCIC_DCICC_HSYNC_POL_SHIFT               5
#define DCIC_DCICC_VSYNC_POL_MASK                0x40u
#define DCIC_DCICC_VSYNC_POL_SHIFT               6
#define DCIC_DCICC_CLK_POL_MASK                  0x80u
#define DCIC_DCICC_CLK_POL_SHIFT                 7
/* DCICIC Bit Fields */
#define DCIC_DCICIC_EI_MASK_MASK                 0x1u
#define DCIC_DCICIC_EI_MASK_SHIFT                0
#define DCIC_DCICIC_FI_MASK_MASK                 0x2u
#define DCIC_DCICIC_FI_MASK_SHIFT                1
#define DCIC_DCICIC_FREEZE_MASK_MASK             0x8u
#define DCIC_DCICIC_FREEZE_MASK_SHIFT            3
#define DCIC_DCICIC_EXT_SIG_EN_MASK              0x10000u
#define DCIC_DCICIC_EXT_SIG_EN_SHIFT             16
/* DCICS Bit Fields */
#define DCIC_DCICS_ROI_MATCH_STAT_MASK           0xFFFFu
#define DCIC_DCICS_ROI_MATCH_STAT_SHIFT          0
#define DCIC_DCICS_ROI_MATCH_STAT(x)             (((uint32_t)(((uint32_t)(x))<<DCIC_DCICS_ROI_MATCH_STAT_SHIFT))&DCIC_DCICS_ROI_MATCH_STAT_MASK)
#define DCIC_DCICS_EI_STAT_MASK                  0x10000u
#define DCIC_DCICS_EI_STAT_SHIFT                 16
#define DCIC_DCICS_FI_STAT_MASK                  0x20000u
#define DCIC_DCICS_FI_STAT_SHIFT                 17
/* DCICRC Bit Fields */
#define DCIC_DCICRC_START_OFFSET_X_MASK          0x1FFFu
#define DCIC_DCICRC_START_OFFSET_X_SHIFT         0
#define DCIC_DCICRC_START_OFFSET_X(x)            (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRC_START_OFFSET_X_SHIFT))&DCIC_DCICRC_START_OFFSET_X_MASK)
#define DCIC_DCICRC_START_OFFSET_Y_MASK          0xFFF0000u
#define DCIC_DCICRC_START_OFFSET_Y_SHIFT         16
#define DCIC_DCICRC_START_OFFSET_Y(x)            (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRC_START_OFFSET_Y_SHIFT))&DCIC_DCICRC_START_OFFSET_Y_MASK)
#define DCIC_DCICRC_ROI_FREEZE_MASK              0x40000000u
#define DCIC_DCICRC_ROI_FREEZE_SHIFT             30
#define DCIC_DCICRC_ROI_EN_MASK                  0x80000000u
#define DCIC_DCICRC_ROI_EN_SHIFT                 31
/* DCICRS Bit Fields */
#define DCIC_DCICRS_END_OFFSET_X_MASK            0x1FFFu
#define DCIC_DCICRS_END_OFFSET_X_SHIFT           0
#define DCIC_DCICRS_END_OFFSET_X(x)              (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRS_END_OFFSET_X_SHIFT))&DCIC_DCICRS_END_OFFSET_X_MASK)
#define DCIC_DCICRS_END_OFFSET_Y_MASK            0xFFF0000u
#define DCIC_DCICRS_END_OFFSET_Y_SHIFT           16
#define DCIC_DCICRS_END_OFFSET_Y(x)              (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRS_END_OFFSET_Y_SHIFT))&DCIC_DCICRS_END_OFFSET_Y_MASK)
/* DCICRRS Bit Fields */
#define DCIC_DCICRRS_REFERENCE_SIGNATURE_MASK    0xFFFFFFFFu
#define DCIC_DCICRRS_REFERENCE_SIGNATURE_SHIFT   0
#define DCIC_DCICRRS_REFERENCE_SIGNATURE(x)      (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRRS_REFERENCE_SIGNATURE_SHIFT))&DCIC_DCICRRS_REFERENCE_SIGNATURE_MASK)
/* DCICRCS Bit Fields */
#define DCIC_DCICRCS_CALCULATED_SIGNATURE_MASK   0xFFFFFFFFu
#define DCIC_DCICRCS_CALCULATED_SIGNATURE_SHIFT  0
#define DCIC_DCICRCS_CALCULATED_SIGNATURE(x)     (((uint32_t)(((uint32_t)(x))<<DCIC_DCICRCS_CALCULATED_SIGNATURE_SHIFT))&DCIC_DCICRCS_CALCULATED_SIGNATURE_MASK)

/*!
 * @}
 */ /* end of group DCIC_Register_Masks */


/* DCIC - Peripheral instance base addresses */
/** Peripheral DCIC1 base pointer */
#define DCIC1_BASE_PTR                           ((DCIC_MemMapPtr)0x4220C000u)
/** Peripheral DCIC2 base pointer */
#define DCIC2_BASE_PTR                           ((DCIC_MemMapPtr)0x42210000u)
/** Array initializer of DCIC peripheral base pointers */
#define DCIC_BASE_PTRS                           { DCIC1_BASE_PTR, DCIC2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DCIC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCIC_Register_Accessor_Macros DCIC - Register accessor macros
 * @{
 */


/* DCIC - Register instance definitions */
/* DCIC1 */
#define DCIC1_DCICC                              DCIC_DCICC_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICIC                             DCIC_DCICIC_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICS                              DCIC_DCICS_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICRC                             DCIC_DCICRC_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICRS                             DCIC_DCICRS_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICRRS                            DCIC_DCICRRS_REG(DCIC1_BASE_PTR)
#define DCIC1_DCICRCS                            DCIC_DCICRCS_REG(DCIC1_BASE_PTR)
/* DCIC2 */
#define DCIC2_DCICC                              DCIC_DCICC_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICIC                             DCIC_DCICIC_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICS                              DCIC_DCICS_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICRC                             DCIC_DCICRC_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICRS                             DCIC_DCICRS_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICRRS                            DCIC_DCICRRS_REG(DCIC2_BASE_PTR)
#define DCIC2_DCICRCS                            DCIC_DCICRCS_REG(DCIC2_BASE_PTR)

/*!
 * @}
 */ /* end of group DCIC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DCIC_Peripheral */


/* ----------------------------------------------------------------------------
   -- DVFSC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DVFSC_Peripheral DVFSC
 * @{
 */

/** DVFSC - Peripheral register structure */
typedef struct DVFSC_MemMap {
  uint32_t THRS;                                   /**< DVFS Thresholds, offset: 0x0 */
  uint32_t COUN;                                   /**< DVFS Counters thresholds, offset: 0x4 */
  uint32_t SIG1;                                   /**< DVFS general purpose bits weight, offset: 0x8 */
  uint32_t DVFSSIG0;                               /**< DVFS general purpose bits weight, offset: 0xC */
  uint32_t DVFSGPC0;                               /**< DVFS general purpose bit 0 weight counter, offset: 0x10 */
  uint32_t DVFSGPC1;                               /**< DVFS general purpose bit 1 weight counter, offset: 0x14 */
  uint32_t DVFSGPBT;                               /**< DVFS general purpose bits enables, offset: 0x18 */
  uint32_t DVFSEMAC;                               /**< DVFS EMAC settings, offset: 0x1C */
  uint32_t CNTR;                                   /**< DVFS Control, offset: 0x20 */
  uint32_t DVFSLTR0_0;                             /**< DVFS Load Tracking Register 0, portion 0, offset: 0x24 */
  uint32_t DVFSLTR0_1;                             /**< DVFS Load Tracking Register 0, portion 1, offset: 0x28 */
  uint32_t DVFSLTR1_0;                             /**< DVFS Load Tracking Register 1, portion 0, offset: 0x2C */
  uint32_t DVFSLTR1_1;                             /**< DVFS Load Tracking Register 3, portion 1, offset: 0x30 */
  uint32_t DVFSPT0;                                /**< DVFS pattern 0 length, offset: 0x34 */
  uint32_t DVFSPT1;                                /**< DVFS pattern 1 length, offset: 0x38 */
  uint32_t DVFSPT2;                                /**< DVFS pattern 2 length, offset: 0x3C */
  uint32_t DVFSPT3;                                /**< DVFS pattern 3 length, offset: 0x40 */
} volatile *DVFSC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DVFSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DVFSC_Register_Accessor_Macros DVFSC - Register accessor macros
 * @{
 */


/* DVFSC - Register accessors */
#define DVFSC_THRS_REG(base)                     ((base)->THRS)
#define DVFSC_COUN_REG(base)                     ((base)->COUN)
#define DVFSC_SIG1_REG(base)                     ((base)->SIG1)
#define DVFSC_DVFSSIG0_REG(base)                 ((base)->DVFSSIG0)
#define DVFSC_DVFSGPC0_REG(base)                 ((base)->DVFSGPC0)
#define DVFSC_DVFSGPC1_REG(base)                 ((base)->DVFSGPC1)
#define DVFSC_DVFSGPBT_REG(base)                 ((base)->DVFSGPBT)
#define DVFSC_DVFSEMAC_REG(base)                 ((base)->DVFSEMAC)
#define DVFSC_CNTR_REG(base)                     ((base)->CNTR)
#define DVFSC_DVFSLTR0_0_REG(base)               ((base)->DVFSLTR0_0)
#define DVFSC_DVFSLTR0_1_REG(base)               ((base)->DVFSLTR0_1)
#define DVFSC_DVFSLTR1_0_REG(base)               ((base)->DVFSLTR1_0)
#define DVFSC_DVFSLTR1_1_REG(base)               ((base)->DVFSLTR1_1)
#define DVFSC_DVFSPT0_REG(base)                  ((base)->DVFSPT0)
#define DVFSC_DVFSPT1_REG(base)                  ((base)->DVFSPT1)
#define DVFSC_DVFSPT2_REG(base)                  ((base)->DVFSPT2)
#define DVFSC_DVFSPT3_REG(base)                  ((base)->DVFSPT3)

/*!
 * @}
 */ /* end of group DVFSC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DVFSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DVFSC_Register_Masks DVFSC Register Masks
 * @{
 */

/* THRS Bit Fields */
#define DVFSC_THRS_PNCTHR_MASK                   0x3Fu
#define DVFSC_THRS_PNCTHR_SHIFT                  0
#define DVFSC_THRS_PNCTHR(x)                     (((uint32_t)(((uint32_t)(x))<<DVFSC_THRS_PNCTHR_SHIFT))&DVFSC_THRS_PNCTHR_MASK)
#define DVFSC_THRS_DWTHR_MASK                    0x3F0000u
#define DVFSC_THRS_DWTHR_SHIFT                   16
#define DVFSC_THRS_DWTHR(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_THRS_DWTHR_SHIFT))&DVFSC_THRS_DWTHR_MASK)
#define DVFSC_THRS_UPTHR_MASK                    0xFC00000u
#define DVFSC_THRS_UPTHR_SHIFT                   22
#define DVFSC_THRS_UPTHR(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_THRS_UPTHR_SHIFT))&DVFSC_THRS_UPTHR_MASK)
/* COUN Bit Fields */
#define DVFSC_COUN_UPCNT_MASK                    0xFFu
#define DVFSC_COUN_UPCNT_SHIFT                   0
#define DVFSC_COUN_UPCNT(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_COUN_UPCNT_SHIFT))&DVFSC_COUN_UPCNT_MASK)
#define DVFSC_COUN_DN_CNT_MASK                   0xFF0000u
#define DVFSC_COUN_DN_CNT_SHIFT                  16
#define DVFSC_COUN_DN_CNT(x)                     (((uint32_t)(((uint32_t)(x))<<DVFSC_COUN_DN_CNT_SHIFT))&DVFSC_COUN_DN_CNT_MASK)
/* SIG1 Bit Fields */
#define DVFSC_SIG1_WSW6_MASK                     0x1Cu
#define DVFSC_SIG1_WSW6_SHIFT                    2
#define DVFSC_SIG1_WSW6(x)                       (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW6_SHIFT))&DVFSC_SIG1_WSW6_MASK)
#define DVFSC_SIG1_WSW7_MASK                     0xE0u
#define DVFSC_SIG1_WSW7_SHIFT                    5
#define DVFSC_SIG1_WSW7(x)                       (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW7_SHIFT))&DVFSC_SIG1_WSW7_MASK)
#define DVFSC_SIG1_WSW8_MASK                     0x700u
#define DVFSC_SIG1_WSW8_SHIFT                    8
#define DVFSC_SIG1_WSW8(x)                       (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW8_SHIFT))&DVFSC_SIG1_WSW8_MASK)
#define DVFSC_SIG1_WSW9_MASK                     0x3800u
#define DVFSC_SIG1_WSW9_SHIFT                    11
#define DVFSC_SIG1_WSW9(x)                       (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW9_SHIFT))&DVFSC_SIG1_WSW9_MASK)
#define DVFSC_SIG1_WSW10_MASK                    0x1C000u
#define DVFSC_SIG1_WSW10_SHIFT                   14
#define DVFSC_SIG1_WSW10(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW10_SHIFT))&DVFSC_SIG1_WSW10_MASK)
#define DVFSC_SIG1_WSW11_MASK                    0xE0000u
#define DVFSC_SIG1_WSW11_SHIFT                   17
#define DVFSC_SIG1_WSW11(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW11_SHIFT))&DVFSC_SIG1_WSW11_MASK)
#define DVFSC_SIG1_WSW12_MASK                    0x700000u
#define DVFSC_SIG1_WSW12_SHIFT                   20
#define DVFSC_SIG1_WSW12(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW12_SHIFT))&DVFSC_SIG1_WSW12_MASK)
#define DVFSC_SIG1_WSW13_MASK                    0x3800000u
#define DVFSC_SIG1_WSW13_SHIFT                   23
#define DVFSC_SIG1_WSW13(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW13_SHIFT))&DVFSC_SIG1_WSW13_MASK)
#define DVFSC_SIG1_WSW14_MASK                    0x1C000000u
#define DVFSC_SIG1_WSW14_SHIFT                   26
#define DVFSC_SIG1_WSW14(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW14_SHIFT))&DVFSC_SIG1_WSW14_MASK)
#define DVFSC_SIG1_WSW15_MASK                    0xE0000000u
#define DVFSC_SIG1_WSW15_SHIFT                   29
#define DVFSC_SIG1_WSW15(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_SIG1_WSW15_SHIFT))&DVFSC_SIG1_WSW15_MASK)
/* DVFSSIG0 Bit Fields */
#define DVFSC_DVFSSIG0_WSW0_MASK                 0x3Fu
#define DVFSC_DVFSSIG0_WSW0_SHIFT                0
#define DVFSC_DVFSSIG0_WSW0(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW0_SHIFT))&DVFSC_DVFSSIG0_WSW0_MASK)
#define DVFSC_DVFSSIG0_WSW1_MASK                 0xFC0u
#define DVFSC_DVFSSIG0_WSW1_SHIFT                6
#define DVFSC_DVFSSIG0_WSW1(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW1_SHIFT))&DVFSC_DVFSSIG0_WSW1_MASK)
#define DVFSC_DVFSSIG0_WSW2_MASK                 0x700000u
#define DVFSC_DVFSSIG0_WSW2_SHIFT                20
#define DVFSC_DVFSSIG0_WSW2(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW2_SHIFT))&DVFSC_DVFSSIG0_WSW2_MASK)
#define DVFSC_DVFSSIG0_WSW3_MASK                 0x3800000u
#define DVFSC_DVFSSIG0_WSW3_SHIFT                23
#define DVFSC_DVFSSIG0_WSW3(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW3_SHIFT))&DVFSC_DVFSSIG0_WSW3_MASK)
#define DVFSC_DVFSSIG0_WSW4_MASK                 0x1C000000u
#define DVFSC_DVFSSIG0_WSW4_SHIFT                26
#define DVFSC_DVFSSIG0_WSW4(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW4_SHIFT))&DVFSC_DVFSSIG0_WSW4_MASK)
#define DVFSC_DVFSSIG0_WSW5_MASK                 0xE0000000u
#define DVFSC_DVFSSIG0_WSW5_SHIFT                29
#define DVFSC_DVFSSIG0_WSW5(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSSIG0_WSW5_SHIFT))&DVFSC_DVFSSIG0_WSW5_MASK)
/* DVFSGPC0 Bit Fields */
#define DVFSC_DVFSGPC0_GPBC0_MASK                0x1FFFFu
#define DVFSC_DVFSGPC0_GPBC0_SHIFT               0
#define DVFSC_DVFSGPC0_GPBC0(x)                  (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSGPC0_GPBC0_SHIFT))&DVFSC_DVFSGPC0_GPBC0_MASK)
#define DVFSC_DVFSGPC0_C0ACT_MASK                0x40000000u
#define DVFSC_DVFSGPC0_C0ACT_SHIFT               30
#define DVFSC_DVFSGPC0_C0STRT_MASK               0x80000000u
#define DVFSC_DVFSGPC0_C0STRT_SHIFT              31
/* DVFSGPC1 Bit Fields */
#define DVFSC_DVFSGPC1_GPBC1_MASK                0x1FFFFu
#define DVFSC_DVFSGPC1_GPBC1_SHIFT               0
#define DVFSC_DVFSGPC1_GPBC1(x)                  (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSGPC1_GPBC1_SHIFT))&DVFSC_DVFSGPC1_GPBC1_MASK)
#define DVFSC_DVFSGPC1_C1ACT_MASK                0x40000000u
#define DVFSC_DVFSGPC1_C1ACT_SHIFT               30
#define DVFSC_DVFSGPC1_C1STRT_MASK               0x80000000u
#define DVFSC_DVFSGPC1_C1STRT_SHIFT              31
/* DVFSGPBT Bit Fields */
#define DVFSC_DVFSGPBT_GPB0_MASK                 0x1u
#define DVFSC_DVFSGPBT_GPB0_SHIFT                0
#define DVFSC_DVFSGPBT_GPB1_MASK                 0x2u
#define DVFSC_DVFSGPBT_GPB1_SHIFT                1
#define DVFSC_DVFSGPBT_GPB2_MASK                 0x4u
#define DVFSC_DVFSGPBT_GPB2_SHIFT                2
#define DVFSC_DVFSGPBT_GPB3_MASK                 0x8u
#define DVFSC_DVFSGPBT_GPB3_SHIFT                3
#define DVFSC_DVFSGPBT_GPB4_MASK                 0x10u
#define DVFSC_DVFSGPBT_GPB4_SHIFT                4
#define DVFSC_DVFSGPBT_GPB5_MASK                 0x20u
#define DVFSC_DVFSGPBT_GPB5_SHIFT                5
#define DVFSC_DVFSGPBT_GPB6_MASK                 0x40u
#define DVFSC_DVFSGPBT_GPB6_SHIFT                6
#define DVFSC_DVFSGPBT_GPB7_MASK                 0x80u
#define DVFSC_DVFSGPBT_GPB7_SHIFT                7
#define DVFSC_DVFSGPBT_GPB8_MASK                 0x100u
#define DVFSC_DVFSGPBT_GPB8_SHIFT                8
#define DVFSC_DVFSGPBT_GPB9_MASK                 0x200u
#define DVFSC_DVFSGPBT_GPB9_SHIFT                9
#define DVFSC_DVFSGPBT_GPB10_MASK                0x400u
#define DVFSC_DVFSGPBT_GPB10_SHIFT               10
#define DVFSC_DVFSGPBT_GPB11_MASK                0x800u
#define DVFSC_DVFSGPBT_GPB11_SHIFT               11
#define DVFSC_DVFSGPBT_GPB12_MASK                0x1000u
#define DVFSC_DVFSGPBT_GPB12_SHIFT               12
#define DVFSC_DVFSGPBT_GPB13_MASK                0x2000u
#define DVFSC_DVFSGPBT_GPB13_SHIFT               13
#define DVFSC_DVFSGPBT_GPB14_MASK                0x4000u
#define DVFSC_DVFSGPBT_GPB14_SHIFT               14
#define DVFSC_DVFSGPBT_GPB15_MASK                0x8000u
#define DVFSC_DVFSGPBT_GPB15_SHIFT               15
/* DVFSEMAC Bit Fields */
#define DVFSC_DVFSEMAC_EMAC_MASK                 0x1FFu
#define DVFSC_DVFSEMAC_EMAC_SHIFT                0
#define DVFSC_DVFSEMAC_EMAC(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSEMAC_EMAC_SHIFT))&DVFSC_DVFSEMAC_EMAC_MASK)
#define DVFSC_DVFSEMAC_DVFEN0_MASK               0x200u
#define DVFSC_DVFSEMAC_DVFEN0_SHIFT              9
#define DVFSC_DVFSEMAC_FSVAI0_MASK               0x30000u
#define DVFSC_DVFSEMAC_FSVAI0_SHIFT              16
#define DVFSC_DVFSEMAC_FSVAI0(x)                 (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSEMAC_FSVAI0_SHIFT))&DVFSC_DVFSEMAC_FSVAI0_MASK)
#define DVFSC_DVFSEMAC_WFIM0_MASK                0x1000000u
#define DVFSC_DVFSEMAC_WFIM0_SHIFT               24
/* CNTR Bit Fields */
#define DVFSC_CNTR_LTBRSR_MASK                   0x18u
#define DVFSC_CNTR_LTBRSR_SHIFT                  3
#define DVFSC_CNTR_LTBRSR(x)                     (((uint32_t)(((uint32_t)(x))<<DVFSC_CNTR_LTBRSR_SHIFT))&DVFSC_CNTR_LTBRSR_MASK)
#define DVFSC_CNTR_LTBRSH_MASK                   0x20u
#define DVFSC_CNTR_LTBRSH_SHIFT                  5
#define DVFSC_CNTR_PFUS_MASK                     0x1C0u
#define DVFSC_CNTR_PFUS_SHIFT                    6
#define DVFSC_CNTR_PFUS(x)                       (((uint32_t)(((uint32_t)(x))<<DVFSC_CNTR_PFUS_SHIFT))&DVFSC_CNTR_PFUS_MASK)
#define DVFSC_CNTR_PFUE_MASK                     0x200u
#define DVFSC_CNTR_PFUE_SHIFT                    9
#define DVFSC_CNTR_DIV_RATIO_MASK                0x1F800u
#define DVFSC_CNTR_DIV_RATIO_SHIFT               11
#define DVFSC_CNTR_DIV_RATIO(x)                  (((uint32_t)(((uint32_t)(x))<<DVFSC_CNTR_DIV_RATIO_SHIFT))&DVFSC_CNTR_DIV_RATIO_MASK)
#define DVFSC_CNTR_MINF_MASK                     0x20000u
#define DVFSC_CNTR_MINF_SHIFT                    17
#define DVFSC_CNTR_MAXF_MASK                     0x40000u
#define DVFSC_CNTR_MAXF_SHIFT                    18
#define DVFSC_CNTR_FSVAI_MASK                    0x300000u
#define DVFSC_CNTR_FSVAI_SHIFT                   20
#define DVFSC_CNTR_FSVAI(x)                      (((uint32_t)(((uint32_t)(x))<<DVFSC_CNTR_FSVAI_SHIFT))&DVFSC_CNTR_FSVAI_MASK)
#define DVFSC_CNTR_FSVAIM_MASK                   0x400000u
#define DVFSC_CNTR_FSVAIM_SHIFT                  22
#define DVFSC_CNTR_PIRQS_MASK                    0x800000u
#define DVFSC_CNTR_PIRQS_SHIFT                   23
#define DVFSC_CNTR_DVFIS_MASK                    0x1000000u
#define DVFSC_CNTR_DVFIS_SHIFT                   24
#define DVFSC_CNTR_LBFL0_MASK                    0x2000000u
#define DVFSC_CNTR_LBFL0_SHIFT                   25
#define DVFSC_CNTR_LBFL1_MASK                    0x4000000u
#define DVFSC_CNTR_LBFL1_SHIFT                   26
#define DVFSC_CNTR_LBMI_MASK                     0x8000000u
#define DVFSC_CNTR_LBMI_SHIFT                    27
#define DVFSC_CNTR_DVFEV_MASK                    0x10000000u
#define DVFSC_CNTR_DVFEV_SHIFT                   28
#define DVFSC_CNTR_DIV3CK_MASK                   0xE0000000u
#define DVFSC_CNTR_DIV3CK_SHIFT                  29
#define DVFSC_CNTR_DIV3CK(x)                     (((uint32_t)(((uint32_t)(x))<<DVFSC_CNTR_DIV3CK_SHIFT))&DVFSC_CNTR_DIV3CK_MASK)
/* DVFSLTR0_0 Bit Fields */
#define DVFSC_DVFSLTR0_0_LTS0_0_MASK             0xFu
#define DVFSC_DVFSLTR0_0_LTS0_0_SHIFT            0
#define DVFSC_DVFSLTR0_0_LTS0_0(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_0_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_0_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_1_MASK             0xF0u
#define DVFSC_DVFSLTR0_0_LTS0_1_SHIFT            4
#define DVFSC_DVFSLTR0_0_LTS0_1(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_1_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_1_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_2_MASK             0xF00u
#define DVFSC_DVFSLTR0_0_LTS0_2_SHIFT            8
#define DVFSC_DVFSLTR0_0_LTS0_2(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_2_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_2_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_3_MASK             0xF000u
#define DVFSC_DVFSLTR0_0_LTS0_3_SHIFT            12
#define DVFSC_DVFSLTR0_0_LTS0_3(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_3_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_3_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_4_MASK             0xF0000u
#define DVFSC_DVFSLTR0_0_LTS0_4_SHIFT            16
#define DVFSC_DVFSLTR0_0_LTS0_4(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_4_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_4_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_5_MASK             0xF00000u
#define DVFSC_DVFSLTR0_0_LTS0_5_SHIFT            20
#define DVFSC_DVFSLTR0_0_LTS0_5(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_5_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_5_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_6_MASK             0xF000000u
#define DVFSC_DVFSLTR0_0_LTS0_6_SHIFT            24
#define DVFSC_DVFSLTR0_0_LTS0_6(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_6_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_6_MASK)
#define DVFSC_DVFSLTR0_0_LTS0_7_MASK             0xF0000000u
#define DVFSC_DVFSLTR0_0_LTS0_7_SHIFT            28
#define DVFSC_DVFSLTR0_0_LTS0_7(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_0_LTS0_7_SHIFT))&DVFSC_DVFSLTR0_0_LTS0_7_MASK)
/* DVFSLTR0_1 Bit Fields */
#define DVFSC_DVFSLTR0_1_LTS0_8_MASK             0xFu
#define DVFSC_DVFSLTR0_1_LTS0_8_SHIFT            0
#define DVFSC_DVFSLTR0_1_LTS0_8(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_8_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_8_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_9_MASK             0xF0u
#define DVFSC_DVFSLTR0_1_LTS0_9_SHIFT            4
#define DVFSC_DVFSLTR0_1_LTS0_9(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_9_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_9_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_10_MASK            0xF00u
#define DVFSC_DVFSLTR0_1_LTS0_10_SHIFT           8
#define DVFSC_DVFSLTR0_1_LTS0_10(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_10_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_10_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_11_MASK            0xF000u
#define DVFSC_DVFSLTR0_1_LTS0_11_SHIFT           12
#define DVFSC_DVFSLTR0_1_LTS0_11(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_11_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_11_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_12_MASK            0xF0000u
#define DVFSC_DVFSLTR0_1_LTS0_12_SHIFT           16
#define DVFSC_DVFSLTR0_1_LTS0_12(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_12_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_12_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_13_MASK            0xF00000u
#define DVFSC_DVFSLTR0_1_LTS0_13_SHIFT           20
#define DVFSC_DVFSLTR0_1_LTS0_13(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_13_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_13_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_14_MASK            0xF000000u
#define DVFSC_DVFSLTR0_1_LTS0_14_SHIFT           24
#define DVFSC_DVFSLTR0_1_LTS0_14(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_14_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_14_MASK)
#define DVFSC_DVFSLTR0_1_LTS0_15_MASK            0xF0000000u
#define DVFSC_DVFSLTR0_1_LTS0_15_SHIFT           28
#define DVFSC_DVFSLTR0_1_LTS0_15(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR0_1_LTS0_15_SHIFT))&DVFSC_DVFSLTR0_1_LTS0_15_MASK)
/* DVFSLTR1_0 Bit Fields */
#define DVFSC_DVFSLTR1_0_LTS1_0_MASK             0xFu
#define DVFSC_DVFSLTR1_0_LTS1_0_SHIFT            0
#define DVFSC_DVFSLTR1_0_LTS1_0(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_0_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_0_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_1_MASK             0xF0u
#define DVFSC_DVFSLTR1_0_LTS1_1_SHIFT            4
#define DVFSC_DVFSLTR1_0_LTS1_1(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_1_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_1_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_2_MASK             0xF00u
#define DVFSC_DVFSLTR1_0_LTS1_2_SHIFT            8
#define DVFSC_DVFSLTR1_0_LTS1_2(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_2_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_2_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_3_MASK             0xF000u
#define DVFSC_DVFSLTR1_0_LTS1_3_SHIFT            12
#define DVFSC_DVFSLTR1_0_LTS1_3(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_3_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_3_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_4_MASK             0xF0000u
#define DVFSC_DVFSLTR1_0_LTS1_4_SHIFT            16
#define DVFSC_DVFSLTR1_0_LTS1_4(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_4_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_4_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_5_MASK             0xF00000u
#define DVFSC_DVFSLTR1_0_LTS1_5_SHIFT            20
#define DVFSC_DVFSLTR1_0_LTS1_5(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_5_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_5_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_6_MASK             0xF000000u
#define DVFSC_DVFSLTR1_0_LTS1_6_SHIFT            24
#define DVFSC_DVFSLTR1_0_LTS1_6(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_6_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_6_MASK)
#define DVFSC_DVFSLTR1_0_LTS1_7_MASK             0xF0000000u
#define DVFSC_DVFSLTR1_0_LTS1_7_SHIFT            28
#define DVFSC_DVFSLTR1_0_LTS1_7(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_0_LTS1_7_SHIFT))&DVFSC_DVFSLTR1_0_LTS1_7_MASK)
/* DVFSLTR1_1 Bit Fields */
#define DVFSC_DVFSLTR1_1_LTS1_8_MASK             0xFu
#define DVFSC_DVFSLTR1_1_LTS1_8_SHIFT            0
#define DVFSC_DVFSLTR1_1_LTS1_8(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_8_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_8_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_9_MASK             0xF0u
#define DVFSC_DVFSLTR1_1_LTS1_9_SHIFT            4
#define DVFSC_DVFSLTR1_1_LTS1_9(x)               (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_9_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_9_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_10_MASK            0xF00u
#define DVFSC_DVFSLTR1_1_LTS1_10_SHIFT           8
#define DVFSC_DVFSLTR1_1_LTS1_10(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_10_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_10_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_11_MASK            0xF000u
#define DVFSC_DVFSLTR1_1_LTS1_11_SHIFT           12
#define DVFSC_DVFSLTR1_1_LTS1_11(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_11_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_11_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_12_MASK            0xF0000u
#define DVFSC_DVFSLTR1_1_LTS1_12_SHIFT           16
#define DVFSC_DVFSLTR1_1_LTS1_12(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_12_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_12_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_13_MASK            0xF00000u
#define DVFSC_DVFSLTR1_1_LTS1_13_SHIFT           20
#define DVFSC_DVFSLTR1_1_LTS1_13(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_13_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_13_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_14_MASK            0xF000000u
#define DVFSC_DVFSLTR1_1_LTS1_14_SHIFT           24
#define DVFSC_DVFSLTR1_1_LTS1_14(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_14_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_14_MASK)
#define DVFSC_DVFSLTR1_1_LTS1_15_MASK            0xF0000000u
#define DVFSC_DVFSLTR1_1_LTS1_15_SHIFT           28
#define DVFSC_DVFSLTR1_1_LTS1_15(x)              (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSLTR1_1_LTS1_15_SHIFT))&DVFSC_DVFSLTR1_1_LTS1_15_MASK)
/* DVFSPT0 Bit Fields */
#define DVFSC_DVFSPT0_FPTN0_MASK                 0x1FFFFu
#define DVFSC_DVFSPT0_FPTN0_SHIFT                0
#define DVFSC_DVFSPT0_FPTN0(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSPT0_FPTN0_SHIFT))&DVFSC_DVFSPT0_FPTN0_MASK)
#define DVFSC_DVFSPT0_PT0A_MASK                  0x20000u
#define DVFSC_DVFSPT0_PT0A_SHIFT                 17
/* DVFSPT1 Bit Fields */
#define DVFSC_DVFSPT1_FPTN1_MASK                 0x1FFFFu
#define DVFSC_DVFSPT1_FPTN1_SHIFT                0
#define DVFSC_DVFSPT1_FPTN1(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSPT1_FPTN1_SHIFT))&DVFSC_DVFSPT1_FPTN1_MASK)
#define DVFSC_DVFSPT1_PT1A_MASK                  0x20000u
#define DVFSC_DVFSPT1_PT1A_SHIFT                 17
/* DVFSPT2 Bit Fields */
#define DVFSC_DVFSPT2_FPTN2_MASK                 0x1FFFFu
#define DVFSC_DVFSPT2_FPTN2_SHIFT                0
#define DVFSC_DVFSPT2_FPTN2(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSPT2_FPTN2_SHIFT))&DVFSC_DVFSPT2_FPTN2_MASK)
#define DVFSC_DVFSPT2_PT2A_MASK                  0x20000u
#define DVFSC_DVFSPT2_PT2A_SHIFT                 17
#define DVFSC_DVFSPT2_P2THR_MASK                 0xFC000000u
#define DVFSC_DVFSPT2_P2THR_SHIFT                26
#define DVFSC_DVFSPT2_P2THR(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSPT2_P2THR_SHIFT))&DVFSC_DVFSPT2_P2THR_MASK)
/* DVFSPT3 Bit Fields */
#define DVFSC_DVFSPT3_FPTN3_MASK                 0x1FFFFu
#define DVFSC_DVFSPT3_FPTN3_SHIFT                0
#define DVFSC_DVFSPT3_FPTN3(x)                   (((uint32_t)(((uint32_t)(x))<<DVFSC_DVFSPT3_FPTN3_SHIFT))&DVFSC_DVFSPT3_FPTN3_MASK)
#define DVFSC_DVFSPT3_PT3A_MASK                  0x20000u
#define DVFSC_DVFSPT3_PT3A_SHIFT                 17

/*!
 * @}
 */ /* end of group DVFSC_Register_Masks */


/* DVFSC - Peripheral instance base addresses */
/** Peripheral DVFSC base pointer */
#define DVFSC_BASE_PTR                           ((DVFSC_MemMapPtr)0x420DC180u)
/** Array initializer of DVFSC peripheral base pointers */
#define DVFSC_BASE_PTRS                          { DVFSC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DVFSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DVFSC_Register_Accessor_Macros DVFSC - Register accessor macros
 * @{
 */


/* DVFSC - Register instance definitions */
/* DVFSC */
#define DVFSC_THRS                               DVFSC_THRS_REG(DVFSC_BASE_PTR)
#define DVFSC_COUN                               DVFSC_COUN_REG(DVFSC_BASE_PTR)
#define DVFSC_SIG1                               DVFSC_SIG1_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSSIG0                           DVFSC_DVFSSIG0_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSGPC0                           DVFSC_DVFSGPC0_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSGPC1                           DVFSC_DVFSGPC1_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSGPBT                           DVFSC_DVFSGPBT_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSEMAC                           DVFSC_DVFSEMAC_REG(DVFSC_BASE_PTR)
#define DVFSC_CNTR                               DVFSC_CNTR_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSLTR0_0                         DVFSC_DVFSLTR0_0_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSLTR0_1                         DVFSC_DVFSLTR0_1_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSLTR1_0                         DVFSC_DVFSLTR1_0_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSLTR1_1                         DVFSC_DVFSLTR1_1_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSPT0                            DVFSC_DVFSPT0_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSPT1                            DVFSC_DVFSPT1_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSPT2                            DVFSC_DVFSPT2_REG(DVFSC_BASE_PTR)
#define DVFSC_DVFSPT3                            DVFSC_DVFSPT3_REG(DVFSC_BASE_PTR)

/*!
 * @}
 */ /* end of group DVFSC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DVFSC_Peripheral */


/* ----------------------------------------------------------------------------
   -- DWT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Peripheral DWT
 * @{
 */

/** DWT - Peripheral register structure */
typedef struct DWT_MemMap {
  uint32_t CTRL;                                   /**< Control Register, offset: 0x0 */
  uint32_t CYCCNT;                                 /**< Cycle Count Register, offset: 0x4 */
  uint32_t CPICNT;                                 /**< CPI Count Register, offset: 0x8 */
  uint32_t EXCCNT;                                 /**< Exception Overhead Count Register, offset: 0xC */
  uint32_t SLEEPCNT;                               /**< Sleep Count Register, offset: 0x10 */
  uint32_t LSUCNT;                                 /**< LSU Count Register, offset: 0x14 */
  uint32_t FOLDCNT;                                /**< Folded-instruction Count Register, offset: 0x18 */
  uint32_t PCSR;                                   /**< Program Counter Sample Register, offset: 0x1C */
  struct {                                         /* offset: 0x20, array step: 0x10 */
    uint32_t COMP;                                   /**< Comparator Register 0..Comparator Register 3, array offset: 0x20, array step: 0x10 */
    uint32_t MASK;                                   /**< Mask Register 0..Mask Register 3, array offset: 0x24, array step: 0x10 */
    uint32_t FUNCTION;                               /**< Function Register 0..Function Register 3, array offset: 0x28, array step: 0x10 */
    uint8_t RESERVED_0[4];
  } COMPARATOR[4];
  uint8_t RESERVED_0[3952];
  uint32_t PID4;                                   /**< Peripheral Identification Register 4., offset: 0xFD0 */
  uint32_t PID5;                                   /**< Peripheral Identification Register 5., offset: 0xFD4 */
  uint32_t PID6;                                   /**< Peripheral Identification Register 6., offset: 0xFD8 */
  uint32_t PID7;                                   /**< Peripheral Identification Register 7., offset: 0xFDC */
  uint32_t PID0;                                   /**< Peripheral Identification Register 0., offset: 0xFE0 */
  uint32_t PID1;                                   /**< Peripheral Identification Register 1., offset: 0xFE4 */
  uint32_t PID2;                                   /**< Peripheral Identification Register 2., offset: 0xFE8 */
  uint32_t PID3;                                   /**< Peripheral Identification Register 3., offset: 0xFEC */
  uint32_t CID0;                                   /**< Component Identification Register 0., offset: 0xFF0 */
  uint32_t CID1;                                   /**< Component Identification Register 1., offset: 0xFF4 */
  uint32_t CID2;                                   /**< Component Identification Register 2., offset: 0xFF8 */
  uint32_t CID3;                                   /**< Component Identification Register 3., offset: 0xFFC */
} volatile *DWT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Accessor_Macros DWT - Register accessor macros
 * @{
 */


/* DWT - Register accessors */
#define DWT_CTRL_REG(base)                       ((base)->CTRL)
#define DWT_CYCCNT_REG(base)                     ((base)->CYCCNT)
#define DWT_CPICNT_REG(base)                     ((base)->CPICNT)
#define DWT_EXCCNT_REG(base)                     ((base)->EXCCNT)
#define DWT_SLEEPCNT_REG(base)                   ((base)->SLEEPCNT)
#define DWT_LSUCNT_REG(base)                     ((base)->LSUCNT)
#define DWT_FOLDCNT_REG(base)                    ((base)->FOLDCNT)
#define DWT_PCSR_REG(base)                       ((base)->PCSR)
#define DWT_COMP_REG(base,index)                 ((base)->COMPARATOR[index].COMP)
#define DWT_MASK_REG(base,index)                 ((base)->COMPARATOR[index].MASK)
#define DWT_FUNCTION_REG(base,index)             ((base)->COMPARATOR[index].FUNCTION)
#define DWT_PID4_REG(base)                       ((base)->PID4)
#define DWT_PID5_REG(base)                       ((base)->PID5)
#define DWT_PID6_REG(base)                       ((base)->PID6)
#define DWT_PID7_REG(base)                       ((base)->PID7)
#define DWT_PID0_REG(base)                       ((base)->PID0)
#define DWT_PID1_REG(base)                       ((base)->PID1)
#define DWT_PID2_REG(base)                       ((base)->PID2)
#define DWT_PID3_REG(base)                       ((base)->PID3)
#define DWT_CID0_REG(base)                       ((base)->CID0)
#define DWT_CID1_REG(base)                       ((base)->CID1)
#define DWT_CID2_REG(base)                       ((base)->CID2)
#define DWT_CID3_REG(base)                       ((base)->CID3)

/*!
 * @}
 */ /* end of group DWT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DWT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Masks DWT Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group DWT_Register_Masks */


/* DWT - Peripheral instance base addresses */
/** Peripheral DWT base pointer */
#define DWT_BASE_PTR                             ((DWT_MemMapPtr)0xE0001000u)
/** Array initializer of DWT peripheral base pointers */
#define DWT_BASE_PTRS                            { DWT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Accessor_Macros DWT - Register accessor macros
 * @{
 */


/* DWT - Register instance definitions */
/* DWT */
#define DWT_CTRL                                 DWT_CTRL_REG(DWT_BASE_PTR)
#define DWT_CYCCNT                               DWT_CYCCNT_REG(DWT_BASE_PTR)
#define DWT_CPICNT                               DWT_CPICNT_REG(DWT_BASE_PTR)
#define DWT_EXCCNT                               DWT_EXCCNT_REG(DWT_BASE_PTR)
#define DWT_SLEEPCNT                             DWT_SLEEPCNT_REG(DWT_BASE_PTR)
#define DWT_LSUCNT                               DWT_LSUCNT_REG(DWT_BASE_PTR)
#define DWT_FOLDCNT                              DWT_FOLDCNT_REG(DWT_BASE_PTR)
#define DWT_PCSR                                 DWT_PCSR_REG(DWT_BASE_PTR)
#define DWT_COMP0                                DWT_COMP_REG(DWT_BASE_PTR,0)
#define DWT_MASK0                                DWT_MASK_REG(DWT_BASE_PTR,0)
#define DWT_FUNCTION0                            DWT_FUNCTION_REG(DWT_BASE_PTR,0)
#define DWT_COMP1                                DWT_COMP_REG(DWT_BASE_PTR,1)
#define DWT_MASK1                                DWT_MASK_REG(DWT_BASE_PTR,1)
#define DWT_FUNCTION1                            DWT_FUNCTION_REG(DWT_BASE_PTR,1)
#define DWT_COMP2                                DWT_COMP_REG(DWT_BASE_PTR,2)
#define DWT_MASK2                                DWT_MASK_REG(DWT_BASE_PTR,2)
#define DWT_FUNCTION2                            DWT_FUNCTION_REG(DWT_BASE_PTR,2)
#define DWT_COMP3                                DWT_COMP_REG(DWT_BASE_PTR,3)
#define DWT_MASK3                                DWT_MASK_REG(DWT_BASE_PTR,3)
#define DWT_FUNCTION3                            DWT_FUNCTION_REG(DWT_BASE_PTR,3)
#define DWT_PID4                                 DWT_PID4_REG(DWT_BASE_PTR)
#define DWT_PID5                                 DWT_PID5_REG(DWT_BASE_PTR)
#define DWT_PID6                                 DWT_PID6_REG(DWT_BASE_PTR)
#define DWT_PID7                                 DWT_PID7_REG(DWT_BASE_PTR)
#define DWT_PID0                                 DWT_PID0_REG(DWT_BASE_PTR)
#define DWT_PID1                                 DWT_PID1_REG(DWT_BASE_PTR)
#define DWT_PID2                                 DWT_PID2_REG(DWT_BASE_PTR)
#define DWT_PID3                                 DWT_PID3_REG(DWT_BASE_PTR)
#define DWT_CID0                                 DWT_CID0_REG(DWT_BASE_PTR)
#define DWT_CID1                                 DWT_CID1_REG(DWT_BASE_PTR)
#define DWT_CID2                                 DWT_CID2_REG(DWT_BASE_PTR)
#define DWT_CID3                                 DWT_CID3_REG(DWT_BASE_PTR)

/* DWT - Register array accessors */
#define DWT_COMP(index)                          DWT_COMP_REG(DWT_BASE_PTR,index)
#define DWT_MASK(index)                          DWT_MASK_REG(DWT_BASE_PTR,index)
#define DWT_FUNCTION(index)                      DWT_FUNCTION_REG(DWT_BASE_PTR,index)

/*!
 * @}
 */ /* end of group DWT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DWT_Peripheral */


/* ----------------------------------------------------------------------------
   -- ECSPI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Peripheral ECSPI
 * @{
 */

/** ECSPI - Peripheral register structure */
typedef struct ECSPI_MemMap {
  uint32_t RXDATA;                                 /**< Receive Data Register, offset: 0x0 */
  uint32_t TXDATA;                                 /**< Transmit Data Register, offset: 0x4 */
  uint32_t CONREG;                                 /**< Control Register, offset: 0x8 */
  uint32_t CONFIGREG;                              /**< Config Register, offset: 0xC */
  uint32_t INTREG;                                 /**< Interrupt Control Register, offset: 0x10 */
  uint32_t DMAREG;                                 /**< DMA Control Register, offset: 0x14 */
  uint32_t STATREG;                                /**< Status Register, offset: 0x18 */
  uint32_t PERIODREG;                              /**< Sample Period Control Register, offset: 0x1C */
  uint32_t TESTREG;                                /**< Test Control Register, offset: 0x20 */
  uint8_t RESERVED_0[28];
  uint32_t MSGDATA;                                /**< Message Data Register, offset: 0x40 */
} volatile *ECSPI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ECSPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Register_Accessor_Macros ECSPI - Register accessor macros
 * @{
 */


/* ECSPI - Register accessors */
#define ECSPI_RXDATA_REG(base)                   ((base)->RXDATA)
#define ECSPI_TXDATA_REG(base)                   ((base)->TXDATA)
#define ECSPI_CONREG_REG(base)                   ((base)->CONREG)
#define ECSPI_CONFIGREG_REG(base)                ((base)->CONFIGREG)
#define ECSPI_INTREG_REG(base)                   ((base)->INTREG)
#define ECSPI_DMAREG_REG(base)                   ((base)->DMAREG)
#define ECSPI_STATREG_REG(base)                  ((base)->STATREG)
#define ECSPI_PERIODREG_REG(base)                ((base)->PERIODREG)
#define ECSPI_TESTREG_REG(base)                  ((base)->TESTREG)
#define ECSPI_MSGDATA_REG(base)                  ((base)->MSGDATA)

/*!
 * @}
 */ /* end of group ECSPI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ECSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Register_Masks ECSPI Register Masks
 * @{
 */

/* RXDATA Bit Fields */
#define ECSPI_RXDATA_ECSPI_RXDATA_MASK           0xFFFFFFFFu
#define ECSPI_RXDATA_ECSPI_RXDATA_SHIFT          0
#define ECSPI_RXDATA_ECSPI_RXDATA(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_RXDATA_ECSPI_RXDATA_SHIFT))&ECSPI_RXDATA_ECSPI_RXDATA_MASK)
/* TXDATA Bit Fields */
#define ECSPI_TXDATA_ECSPI_TXDATA_MASK           0xFFFFFFFFu
#define ECSPI_TXDATA_ECSPI_TXDATA_SHIFT          0
#define ECSPI_TXDATA_ECSPI_TXDATA(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_TXDATA_ECSPI_TXDATA_SHIFT))&ECSPI_TXDATA_ECSPI_TXDATA_MASK)
/* CONREG Bit Fields */
#define ECSPI_CONREG_EN_MASK                     0x1u
#define ECSPI_CONREG_EN_SHIFT                    0
#define ECSPI_CONREG_HT_MASK                     0x2u
#define ECSPI_CONREG_HT_SHIFT                    1
#define ECSPI_CONREG_XCH_MASK                    0x4u
#define ECSPI_CONREG_XCH_SHIFT                   2
#define ECSPI_CONREG_SMC_MASK                    0x8u
#define ECSPI_CONREG_SMC_SHIFT                   3
#define ECSPI_CONREG_CHANNEL_MODE_MASK           0xF0u
#define ECSPI_CONREG_CHANNEL_MODE_SHIFT          4
#define ECSPI_CONREG_CHANNEL_MODE(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_CHANNEL_MODE_SHIFT))&ECSPI_CONREG_CHANNEL_MODE_MASK)
#define ECSPI_CONREG_POST_DIVIDER_MASK           0xF00u
#define ECSPI_CONREG_POST_DIVIDER_SHIFT          8
#define ECSPI_CONREG_POST_DIVIDER(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_POST_DIVIDER_SHIFT))&ECSPI_CONREG_POST_DIVIDER_MASK)
#define ECSPI_CONREG_PRE_DIVIDER_MASK            0xF000u
#define ECSPI_CONREG_PRE_DIVIDER_SHIFT           12
#define ECSPI_CONREG_PRE_DIVIDER(x)              (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_PRE_DIVIDER_SHIFT))&ECSPI_CONREG_PRE_DIVIDER_MASK)
#define ECSPI_CONREG_DRCTL_MASK                  0x30000u
#define ECSPI_CONREG_DRCTL_SHIFT                 16
#define ECSPI_CONREG_DRCTL(x)                    (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_DRCTL_SHIFT))&ECSPI_CONREG_DRCTL_MASK)
#define ECSPI_CONREG_CHANNEL_SELECT_MASK         0xC0000u
#define ECSPI_CONREG_CHANNEL_SELECT_SHIFT        18
#define ECSPI_CONREG_CHANNEL_SELECT(x)           (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_CHANNEL_SELECT_SHIFT))&ECSPI_CONREG_CHANNEL_SELECT_MASK)
#define ECSPI_CONREG_BURST_LENGTH_MASK           0xFFF00000u
#define ECSPI_CONREG_BURST_LENGTH_SHIFT          20
#define ECSPI_CONREG_BURST_LENGTH(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_CONREG_BURST_LENGTH_SHIFT))&ECSPI_CONREG_BURST_LENGTH_MASK)
/* CONFIGREG Bit Fields */
#define ECSPI_CONFIGREG_SCLK_PHA_MASK            0xFu
#define ECSPI_CONFIGREG_SCLK_PHA_SHIFT           0
#define ECSPI_CONFIGREG_SCLK_PHA(x)              (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_SCLK_PHA_SHIFT))&ECSPI_CONFIGREG_SCLK_PHA_MASK)
#define ECSPI_CONFIGREG_SCLK_POL_MASK            0xF0u
#define ECSPI_CONFIGREG_SCLK_POL_SHIFT           4
#define ECSPI_CONFIGREG_SCLK_POL(x)              (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_SCLK_POL_SHIFT))&ECSPI_CONFIGREG_SCLK_POL_MASK)
#define ECSPI_CONFIGREG_SS_CTL_MASK              0xF00u
#define ECSPI_CONFIGREG_SS_CTL_SHIFT             8
#define ECSPI_CONFIGREG_SS_CTL(x)                (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_SS_CTL_SHIFT))&ECSPI_CONFIGREG_SS_CTL_MASK)
#define ECSPI_CONFIGREG_SS_POL_MASK              0xF000u
#define ECSPI_CONFIGREG_SS_POL_SHIFT             12
#define ECSPI_CONFIGREG_SS_POL(x)                (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_SS_POL_SHIFT))&ECSPI_CONFIGREG_SS_POL_MASK)
#define ECSPI_CONFIGREG_DATA_CTL_MASK            0xF0000u
#define ECSPI_CONFIGREG_DATA_CTL_SHIFT           16
#define ECSPI_CONFIGREG_DATA_CTL(x)              (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_DATA_CTL_SHIFT))&ECSPI_CONFIGREG_DATA_CTL_MASK)
#define ECSPI_CONFIGREG_SCLK_CTL_MASK            0xF00000u
#define ECSPI_CONFIGREG_SCLK_CTL_SHIFT           20
#define ECSPI_CONFIGREG_SCLK_CTL(x)              (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_SCLK_CTL_SHIFT))&ECSPI_CONFIGREG_SCLK_CTL_MASK)
#define ECSPI_CONFIGREG_HT_LENGTH_MASK           0x1F000000u
#define ECSPI_CONFIGREG_HT_LENGTH_SHIFT          24
#define ECSPI_CONFIGREG_HT_LENGTH(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_CONFIGREG_HT_LENGTH_SHIFT))&ECSPI_CONFIGREG_HT_LENGTH_MASK)
/* INTREG Bit Fields */
#define ECSPI_INTREG_TEEN_MASK                   0x1u
#define ECSPI_INTREG_TEEN_SHIFT                  0
#define ECSPI_INTREG_TDREN_MASK                  0x2u
#define ECSPI_INTREG_TDREN_SHIFT                 1
#define ECSPI_INTREG_TFEN_MASK                   0x4u
#define ECSPI_INTREG_TFEN_SHIFT                  2
#define ECSPI_INTREG_RREN_MASK                   0x8u
#define ECSPI_INTREG_RREN_SHIFT                  3
#define ECSPI_INTREG_RDREN_MASK                  0x10u
#define ECSPI_INTREG_RDREN_SHIFT                 4
#define ECSPI_INTREG_RFEN_MASK                   0x20u
#define ECSPI_INTREG_RFEN_SHIFT                  5
#define ECSPI_INTREG_ROEN_MASK                   0x40u
#define ECSPI_INTREG_ROEN_SHIFT                  6
#define ECSPI_INTREG_TCEN_MASK                   0x80u
#define ECSPI_INTREG_TCEN_SHIFT                  7
/* DMAREG Bit Fields */
#define ECSPI_DMAREG_TX_THRESHOLD_MASK           0x3Fu
#define ECSPI_DMAREG_TX_THRESHOLD_SHIFT          0
#define ECSPI_DMAREG_TX_THRESHOLD(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_DMAREG_TX_THRESHOLD_SHIFT))&ECSPI_DMAREG_TX_THRESHOLD_MASK)
#define ECSPI_DMAREG_TEDEN_MASK                  0x80u
#define ECSPI_DMAREG_TEDEN_SHIFT                 7
#define ECSPI_DMAREG_RX_THRESHOLD_MASK           0x3F0000u
#define ECSPI_DMAREG_RX_THRESHOLD_SHIFT          16
#define ECSPI_DMAREG_RX_THRESHOLD(x)             (((uint32_t)(((uint32_t)(x))<<ECSPI_DMAREG_RX_THRESHOLD_SHIFT))&ECSPI_DMAREG_RX_THRESHOLD_MASK)
#define ECSPI_DMAREG_RXDEN_MASK                  0x800000u
#define ECSPI_DMAREG_RXDEN_SHIFT                 23
#define ECSPI_DMAREG_RX_DMA_LENGTH_MASK          0x3F000000u
#define ECSPI_DMAREG_RX_DMA_LENGTH_SHIFT         24
#define ECSPI_DMAREG_RX_DMA_LENGTH(x)            (((uint32_t)(((uint32_t)(x))<<ECSPI_DMAREG_RX_DMA_LENGTH_SHIFT))&ECSPI_DMAREG_RX_DMA_LENGTH_MASK)
#define ECSPI_DMAREG_RXTDEN_MASK                 0x80000000u
#define ECSPI_DMAREG_RXTDEN_SHIFT                31
/* STATREG Bit Fields */
#define ECSPI_STATREG_TE_MASK                    0x1u
#define ECSPI_STATREG_TE_SHIFT                   0
#define ECSPI_STATREG_TDR_MASK                   0x2u
#define ECSPI_STATREG_TDR_SHIFT                  1
#define ECSPI_STATREG_TF_MASK                    0x4u
#define ECSPI_STATREG_TF_SHIFT                   2
#define ECSPI_STATREG_RR_MASK                    0x8u
#define ECSPI_STATREG_RR_SHIFT                   3
#define ECSPI_STATREG_RDR_MASK                   0x10u
#define ECSPI_STATREG_RDR_SHIFT                  4
#define ECSPI_STATREG_RF_MASK                    0x20u
#define ECSPI_STATREG_RF_SHIFT                   5
#define ECSPI_STATREG_RO_MASK                    0x40u
#define ECSPI_STATREG_RO_SHIFT                   6
#define ECSPI_STATREG_TC_MASK                    0x80u
#define ECSPI_STATREG_TC_SHIFT                   7
/* PERIODREG Bit Fields */
#define ECSPI_PERIODREG_SAMPLE_PERIOD_MASK       0x7FFFu
#define ECSPI_PERIODREG_SAMPLE_PERIOD_SHIFT      0
#define ECSPI_PERIODREG_SAMPLE_PERIOD(x)         (((uint32_t)(((uint32_t)(x))<<ECSPI_PERIODREG_SAMPLE_PERIOD_SHIFT))&ECSPI_PERIODREG_SAMPLE_PERIOD_MASK)
#define ECSPI_PERIODREG_CSRC_MASK                0x8000u
#define ECSPI_PERIODREG_CSRC_SHIFT               15
#define ECSPI_PERIODREG_CSD_CTL_MASK             0x3F0000u
#define ECSPI_PERIODREG_CSD_CTL_SHIFT            16
#define ECSPI_PERIODREG_CSD_CTL(x)               (((uint32_t)(((uint32_t)(x))<<ECSPI_PERIODREG_CSD_CTL_SHIFT))&ECSPI_PERIODREG_CSD_CTL_MASK)
/* TESTREG Bit Fields */
#define ECSPI_TESTREG_TXCNT_MASK                 0x7Fu
#define ECSPI_TESTREG_TXCNT_SHIFT                0
#define ECSPI_TESTREG_TXCNT(x)                   (((uint32_t)(((uint32_t)(x))<<ECSPI_TESTREG_TXCNT_SHIFT))&ECSPI_TESTREG_TXCNT_MASK)
#define ECSPI_TESTREG_RXCNT_MASK                 0x7F00u
#define ECSPI_TESTREG_RXCNT_SHIFT                8
#define ECSPI_TESTREG_RXCNT(x)                   (((uint32_t)(((uint32_t)(x))<<ECSPI_TESTREG_RXCNT_SHIFT))&ECSPI_TESTREG_RXCNT_MASK)
#define ECSPI_TESTREG_LBC_MASK                   0x80000000u
#define ECSPI_TESTREG_LBC_SHIFT                  31
/* MSGDATA Bit Fields */
#define ECSPI_MSGDATA_ECSPI_MSGDATA_MASK         0xFFFFFFFFu
#define ECSPI_MSGDATA_ECSPI_MSGDATA_SHIFT        0
#define ECSPI_MSGDATA_ECSPI_MSGDATA(x)           (((uint32_t)(((uint32_t)(x))<<ECSPI_MSGDATA_ECSPI_MSGDATA_SHIFT))&ECSPI_MSGDATA_ECSPI_MSGDATA_MASK)

/*!
 * @}
 */ /* end of group ECSPI_Register_Masks */


/* ECSPI - Peripheral instance base addresses */
/** Peripheral ECSPI1 base pointer */
#define ECSPI1_BASE_PTR                          ((ECSPI_MemMapPtr)0x42008000u)
/** Peripheral ECSPI2 base pointer */
#define ECSPI2_BASE_PTR                          ((ECSPI_MemMapPtr)0x4200C000u)
/** Peripheral ECSPI3 base pointer */
#define ECSPI3_BASE_PTR                          ((ECSPI_MemMapPtr)0x42010000u)
/** Peripheral ECSPI4 base pointer */
#define ECSPI4_BASE_PTR                          ((ECSPI_MemMapPtr)0x42014000u)
/** Peripheral ECSPI5 base pointer */
#define ECSPI5_BASE_PTR                          ((ECSPI_MemMapPtr)0x4228C000u)
/** Array initializer of ECSPI peripheral base pointers */
#define ECSPI_BASE_PTRS                          { ECSPI1_BASE_PTR, ECSPI2_BASE_PTR, ECSPI3_BASE_PTR, ECSPI4_BASE_PTR, ECSPI5_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ECSPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECSPI_Register_Accessor_Macros ECSPI - Register accessor macros
 * @{
 */


/* ECSPI - Register instance definitions */
/* ECSPI1 */
#define ECSPI1_RXDATA                            ECSPI_RXDATA_REG(ECSPI1_BASE_PTR)
#define ECSPI1_TXDATA                            ECSPI_TXDATA_REG(ECSPI1_BASE_PTR)
#define ECSPI1_CONREG                            ECSPI_CONREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_CONFIGREG                         ECSPI_CONFIGREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_INTREG                            ECSPI_INTREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_DMAREG                            ECSPI_DMAREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_STATREG                           ECSPI_STATREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_PERIODREG                         ECSPI_PERIODREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_TESTREG                           ECSPI_TESTREG_REG(ECSPI1_BASE_PTR)
#define ECSPI1_MSGDATA                           ECSPI_MSGDATA_REG(ECSPI1_BASE_PTR)
/* ECSPI2 */
#define ECSPI2_RXDATA                            ECSPI_RXDATA_REG(ECSPI2_BASE_PTR)
#define ECSPI2_TXDATA                            ECSPI_TXDATA_REG(ECSPI2_BASE_PTR)
#define ECSPI2_CONREG                            ECSPI_CONREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_CONFIGREG                         ECSPI_CONFIGREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_INTREG                            ECSPI_INTREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_DMAREG                            ECSPI_DMAREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_STATREG                           ECSPI_STATREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_PERIODREG                         ECSPI_PERIODREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_TESTREG                           ECSPI_TESTREG_REG(ECSPI2_BASE_PTR)
#define ECSPI2_MSGDATA                           ECSPI_MSGDATA_REG(ECSPI2_BASE_PTR)
/* ECSPI3 */
#define ECSPI3_RXDATA                            ECSPI_RXDATA_REG(ECSPI3_BASE_PTR)
#define ECSPI3_TXDATA                            ECSPI_TXDATA_REG(ECSPI3_BASE_PTR)
#define ECSPI3_CONREG                            ECSPI_CONREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_CONFIGREG                         ECSPI_CONFIGREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_INTREG                            ECSPI_INTREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_DMAREG                            ECSPI_DMAREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_STATREG                           ECSPI_STATREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_PERIODREG                         ECSPI_PERIODREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_TESTREG                           ECSPI_TESTREG_REG(ECSPI3_BASE_PTR)
#define ECSPI3_MSGDATA                           ECSPI_MSGDATA_REG(ECSPI3_BASE_PTR)
/* ECSPI4 */
#define ECSPI4_RXDATA                            ECSPI_RXDATA_REG(ECSPI4_BASE_PTR)
#define ECSPI4_TXDATA                            ECSPI_TXDATA_REG(ECSPI4_BASE_PTR)
#define ECSPI4_CONREG                            ECSPI_CONREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_CONFIGREG                         ECSPI_CONFIGREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_INTREG                            ECSPI_INTREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_DMAREG                            ECSPI_DMAREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_STATREG                           ECSPI_STATREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_PERIODREG                         ECSPI_PERIODREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_TESTREG                           ECSPI_TESTREG_REG(ECSPI4_BASE_PTR)
#define ECSPI4_MSGDATA                           ECSPI_MSGDATA_REG(ECSPI4_BASE_PTR)
/* ECSPI5 */
#define ECSPI5_RXDATA                            ECSPI_RXDATA_REG(ECSPI5_BASE_PTR)
#define ECSPI5_TXDATA                            ECSPI_TXDATA_REG(ECSPI5_BASE_PTR)
#define ECSPI5_CONREG                            ECSPI_CONREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_CONFIGREG                         ECSPI_CONFIGREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_INTREG                            ECSPI_INTREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_DMAREG                            ECSPI_DMAREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_STATREG                           ECSPI_STATREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_PERIODREG                         ECSPI_PERIODREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_TESTREG                           ECSPI_TESTREG_REG(ECSPI5_BASE_PTR)
#define ECSPI5_MSGDATA                           ECSPI_MSGDATA_REG(ECSPI5_BASE_PTR)

/*!
 * @}
 */ /* end of group ECSPI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ECSPI_Peripheral */


/* ----------------------------------------------------------------------------
   -- ECT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECT_Peripheral ECT
 * @{
 */

/** ECT - Peripheral register structure */
typedef struct ECT_MemMap {
  uint32_t CONTROL;                                /**< CTI Control Register, offset: 0x0 */
  uint32_t STATUS;                                 /**< CTI Status Register, offset: 0x4 */
  uint32_t LOCK;                                   /**< CTI Lock Enable Register, offset: 0x8 */
  uint32_t PROTECTION;                             /**< CTI Protection Enable Register, offset: 0xC */
  uint32_t INTACK;                                 /**< CTI Interrupt Acknowledge Register, offset: 0x10 */
  uint32_t APPSET;                                 /**< CTI Application Trigger Set Register, offset: 0x14 */
  uint32_t APPCLEAR;                               /**< CTI Application Trigger Clear Register, offset: 0x18 */
  uint32_t APPPULSE;                               /**< CTI Application Pulse Register, offset: 0x1C */
  uint32_t INEN0;                                  /**< CTI Trigger to Channel Enable Register 0, offset: 0x20 */
  uint32_t INEN1;                                  /**< CTI Trigger to Channel Enable Register 1, offset: 0x24 */
  uint32_t INEN2;                                  /**< CTI Trigger to Channel Enable Register 2, offset: 0x28 */
  uint32_t INEN3;                                  /**< CTI Trigger to Channel Enable Register 3, offset: 0x2C */
  uint32_t INEN4;                                  /**< CTI Trigger to Channel Enable Register 4, offset: 0x30 */
  uint32_t INEN5;                                  /**< CTI Trigger to Channel Enable Register 5, offset: 0x34 */
  uint32_t INEN6;                                  /**< CTI Trigger to Channel Enable Register 6, offset: 0x38 */
  uint32_t INEN7;                                  /**< CTI Trigger to Channel Enable Register 7, offset: 0x3C */
  uint8_t RESERVED_0[96];
  uint32_t OUTEN0;                                 /**< CTI Channel to Trigger Enable Register 0, offset: 0xA0 */
  uint32_t OUTEN1;                                 /**< CTI Channel to Trigger Enable Register 1, offset: 0xA4 */
  uint32_t OUTEN2;                                 /**< CTI Channel to Trigger Enable Register 2, offset: 0xA8 */
  uint32_t OUTEN3;                                 /**< CTI Channel to Trigger Enable Register 3, offset: 0xAC */
  uint32_t OUTEN4;                                 /**< CTI Channel to Trigger Enable Register 4, offset: 0xB0 */
  uint32_t OUTEN5;                                 /**< CTI Channel to Trigger Enable Register 5, offset: 0xB4 */
  uint32_t OUTEN6;                                 /**< CTI Channel to Trigger Enable Register 6, offset: 0xB8 */
  uint32_t OUTEN7;                                 /**< CTI Channel to Trigger Enable Register 7, offset: 0xBC */
  uint8_t RESERVED_1[112];
  uint32_t TRIGINSTATUS;                           /**< CTI Trigger In Status Register, offset: 0x130 */
  uint32_t TRIGOUTSTATUS;                          /**< CTI Trigger Out Status Register, offset: 0x134 */
  uint32_t CHINSTATUS;                             /**< CTI Channel In Status Register, offset: 0x138 */
  uint32_t CHOUTSTATUS;                            /**< CTI Channel Out Status Register, offset: 0x13C */
  uint8_t RESERVED_2[3744];
  uint32_t PERIPHID0;                              /**< Peripheral Identification Register 0, offset: 0xFE0 */
  uint32_t PERIPHID1;                              /**< Peripheral Identification Register 1, offset: 0xFE4 */
  uint32_t PERIPHID2;                              /**< Peripheral Identification Register 2, offset: 0xFE8 */
  uint32_t PERIPHID3;                              /**< Peripheral Identification Register 3, offset: 0xFEC */
  uint32_t PCELLID0;                               /**< Identification Register 0, offset: 0xFF0 */
  uint32_t PCELLID1;                               /**< Identification Register 1, offset: 0xFF4 */
  uint32_t PCELLID2;                               /**< Identification Register 2, offset: 0xFF8 */
  uint32_t PCELLID3;                               /**< Identification Register 3, offset: 0xFFC */
} volatile *ECT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ECT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECT_Register_Accessor_Macros ECT - Register accessor macros
 * @{
 */


/* ECT - Register accessors */
#define ECT_CONTROL_REG(base)                    ((base)->CONTROL)
#define ECT_STATUS_REG(base)                     ((base)->STATUS)
#define ECT_LOCK_REG(base)                       ((base)->LOCK)
#define ECT_PROTECTION_REG(base)                 ((base)->PROTECTION)
#define ECT_INTACK_REG(base)                     ((base)->INTACK)
#define ECT_APPSET_REG(base)                     ((base)->APPSET)
#define ECT_APPCLEAR_REG(base)                   ((base)->APPCLEAR)
#define ECT_APPPULSE_REG(base)                   ((base)->APPPULSE)
#define ECT_INEN0_REG(base)                      ((base)->INEN0)
#define ECT_INEN1_REG(base)                      ((base)->INEN1)
#define ECT_INEN2_REG(base)                      ((base)->INEN2)
#define ECT_INEN3_REG(base)                      ((base)->INEN3)
#define ECT_INEN4_REG(base)                      ((base)->INEN4)
#define ECT_INEN5_REG(base)                      ((base)->INEN5)
#define ECT_INEN6_REG(base)                      ((base)->INEN6)
#define ECT_INEN7_REG(base)                      ((base)->INEN7)
#define ECT_OUTEN0_REG(base)                     ((base)->OUTEN0)
#define ECT_OUTEN1_REG(base)                     ((base)->OUTEN1)
#define ECT_OUTEN2_REG(base)                     ((base)->OUTEN2)
#define ECT_OUTEN3_REG(base)                     ((base)->OUTEN3)
#define ECT_OUTEN4_REG(base)                     ((base)->OUTEN4)
#define ECT_OUTEN5_REG(base)                     ((base)->OUTEN5)
#define ECT_OUTEN6_REG(base)                     ((base)->OUTEN6)
#define ECT_OUTEN7_REG(base)                     ((base)->OUTEN7)
#define ECT_TRIGINSTATUS_REG(base)               ((base)->TRIGINSTATUS)
#define ECT_TRIGOUTSTATUS_REG(base)              ((base)->TRIGOUTSTATUS)
#define ECT_CHINSTATUS_REG(base)                 ((base)->CHINSTATUS)
#define ECT_CHOUTSTATUS_REG(base)                ((base)->CHOUTSTATUS)
#define ECT_PERIPHID0_REG(base)                  ((base)->PERIPHID0)
#define ECT_PERIPHID1_REG(base)                  ((base)->PERIPHID1)
#define ECT_PERIPHID2_REG(base)                  ((base)->PERIPHID2)
#define ECT_PERIPHID3_REG(base)                  ((base)->PERIPHID3)
#define ECT_PCELLID0_REG(base)                   ((base)->PCELLID0)
#define ECT_PCELLID1_REG(base)                   ((base)->PCELLID1)
#define ECT_PCELLID2_REG(base)                   ((base)->PCELLID2)
#define ECT_PCELLID3_REG(base)                   ((base)->PCELLID3)

/*!
 * @}
 */ /* end of group ECT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ECT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECT_Register_Masks ECT Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group ECT_Register_Masks */


/* ECT - Peripheral instance base addresses */
/** Peripheral CTI base pointer */
#define CTI_BASE_PTR                             ((ECT_MemMapPtr)0xE0044000u)
/** Array initializer of ECT peripheral base pointers */
#define ECT_BASE_PTRS                            { CTI_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ECT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ECT_Register_Accessor_Macros ECT - Register accessor macros
 * @{
 */


/* ECT - Register instance definitions */
/* CTI */
#define CTI_CONTROL                              ECT_CONTROL_REG(CTI_BASE_PTR)
#define CTI_STATUS                               ECT_STATUS_REG(CTI_BASE_PTR)
#define CTI_LOCK                                 ECT_LOCK_REG(CTI_BASE_PTR)
#define CTI_PROTECTION                           ECT_PROTECTION_REG(CTI_BASE_PTR)
#define CTI_INTACK                               ECT_INTACK_REG(CTI_BASE_PTR)
#define CTI_APPSET                               ECT_APPSET_REG(CTI_BASE_PTR)
#define CTI_APPCLEAR                             ECT_APPCLEAR_REG(CTI_BASE_PTR)
#define CTI_APPPULSE                             ECT_APPPULSE_REG(CTI_BASE_PTR)
#define CTI_INEN0                                ECT_INEN0_REG(CTI_BASE_PTR)
#define CTI_INEN1                                ECT_INEN1_REG(CTI_BASE_PTR)
#define CTI_INEN2                                ECT_INEN2_REG(CTI_BASE_PTR)
#define CTI_INEN3                                ECT_INEN3_REG(CTI_BASE_PTR)
#define CTI_INEN4                                ECT_INEN4_REG(CTI_BASE_PTR)
#define CTI_INEN5                                ECT_INEN5_REG(CTI_BASE_PTR)
#define CTI_INEN6                                ECT_INEN6_REG(CTI_BASE_PTR)
#define CTI_INEN7                                ECT_INEN7_REG(CTI_BASE_PTR)
#define CTI_OUTEN0                               ECT_OUTEN0_REG(CTI_BASE_PTR)
#define CTI_OUTEN1                               ECT_OUTEN1_REG(CTI_BASE_PTR)
#define CTI_OUTEN2                               ECT_OUTEN2_REG(CTI_BASE_PTR)
#define CTI_OUTEN3                               ECT_OUTEN3_REG(CTI_BASE_PTR)
#define CTI_OUTEN4                               ECT_OUTEN4_REG(CTI_BASE_PTR)
#define CTI_OUTEN5                               ECT_OUTEN5_REG(CTI_BASE_PTR)
#define CTI_OUTEN6                               ECT_OUTEN6_REG(CTI_BASE_PTR)
#define CTI_OUTEN7                               ECT_OUTEN7_REG(CTI_BASE_PTR)
#define CTI_TRIGINSTATUS                         ECT_TRIGINSTATUS_REG(CTI_BASE_PTR)
#define CTI_TRIGOUTSTATUS                        ECT_TRIGOUTSTATUS_REG(CTI_BASE_PTR)
#define CTI_CHINSTATUS                           ECT_CHINSTATUS_REG(CTI_BASE_PTR)
#define CTI_CHOUTSTATUS                          ECT_CHOUTSTATUS_REG(CTI_BASE_PTR)
#define CTI_PERIPHID0                            ECT_PERIPHID0_REG(CTI_BASE_PTR)
#define CTI_PERIPHID1                            ECT_PERIPHID1_REG(CTI_BASE_PTR)
#define CTI_PERIPHID2                            ECT_PERIPHID2_REG(CTI_BASE_PTR)
#define CTI_PERIPHID3                            ECT_PERIPHID3_REG(CTI_BASE_PTR)
#define CTI_PCELLID0                             ECT_PCELLID0_REG(CTI_BASE_PTR)
#define CTI_PCELLID1                             ECT_PCELLID1_REG(CTI_BASE_PTR)
#define CTI_PCELLID2                             ECT_PCELLID2_REG(CTI_BASE_PTR)
#define CTI_PCELLID3                             ECT_PCELLID3_REG(CTI_BASE_PTR)

/*!
 * @}
 */ /* end of group ECT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ECT_Peripheral */


/* ----------------------------------------------------------------------------
   -- EIM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Peripheral EIM
 * @{
 */

/** EIM - Peripheral register structure */
typedef struct EIM_MemMap {
  struct {                                         /* offset: 0x0, array step: 0x18 */
    uint32_t CSGCR1;                                 /**< Chip Select n General Configuration Register 1, array offset: 0x0, array step: 0x18 */
    uint32_t CSGCR2;                                 /**< Chip Select n General Configuration Register 2, array offset: 0x4, array step: 0x18 */
    uint32_t CSRCR1;                                 /**< Chip Select n Read Configuration Register 1, array offset: 0x8, array step: 0x18 */
    uint32_t CSRCR2;                                 /**< Chip Select n Read Configuration Register 2, array offset: 0xC, array step: 0x18 */
    uint32_t CSWCR1;                                 /**< Chip Select n Write Configuration Register 1, array offset: 0x10, array step: 0x18 */
    uint32_t CSWCR2;                                 /**< Chip Select n Write Configuration Register 2, array offset: 0x14, array step: 0x18 */
  } CSxCR[6];
  uint32_t WCR;                                    /**< EIM Configuration Register, offset: 0x90 */
  uint32_t DCR;                                    /**< DLL Control Register, offset: 0x94 */
  uint32_t DSR;                                    /**< DLL Status Register, offset: 0x98 */
  uint32_t WIAR;                                   /**< EIM IP Access Register, offset: 0x9C */
  uint32_t EAR;                                    /**< Error Address Register, offset: 0xA0 */
} volatile *EIM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- EIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Accessor_Macros EIM - Register accessor macros
 * @{
 */


/* EIM - Register accessors */
#define EIM_CSGCR1_REG(base,index)               ((base)->CSxCR[index].CSGCR1)
#define EIM_CSGCR2_REG(base,index)               ((base)->CSxCR[index].CSGCR2)
#define EIM_CSRCR1_REG(base,index)               ((base)->CSxCR[index].CSRCR1)
#define EIM_CSRCR2_REG(base,index)               ((base)->CSxCR[index].CSRCR2)
#define EIM_CSWCR1_REG(base,index)               ((base)->CSxCR[index].CSWCR1)
#define EIM_CSWCR2_REG(base,index)               ((base)->CSxCR[index].CSWCR2)
#define EIM_WCR_REG(base)                        ((base)->WCR)
#define EIM_DCR_REG(base)                        ((base)->DCR)
#define EIM_DSR_REG(base)                        ((base)->DSR)
#define EIM_WIAR_REG(base)                       ((base)->WIAR)
#define EIM_EAR_REG(base)                        ((base)->EAR)

/*!
 * @}
 */ /* end of group EIM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- EIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Masks EIM Register Masks
 * @{
 */

/* CSGCR1 Bit Fields */
#define EIM_CSGCR1_CSEN_MASK                     0x1u
#define EIM_CSGCR1_CSEN_SHIFT                    0
#define EIM_CSGCR1_SWR_MASK                      0x2u
#define EIM_CSGCR1_SWR_SHIFT                     1
#define EIM_CSGCR1_SRD_MASK                      0x4u
#define EIM_CSGCR1_SRD_SHIFT                     2
#define EIM_CSGCR1_MUM_MASK                      0x8u
#define EIM_CSGCR1_MUM_SHIFT                     3
#define EIM_CSGCR1_WFL_MASK                      0x10u
#define EIM_CSGCR1_WFL_SHIFT                     4
#define EIM_CSGCR1_RFL_MASK                      0x20u
#define EIM_CSGCR1_RFL_SHIFT                     5
#define EIM_CSGCR1_CRE_MASK                      0x40u
#define EIM_CSGCR1_CRE_SHIFT                     6
#define EIM_CSGCR1_CREP_MASK                     0x80u
#define EIM_CSGCR1_CREP_SHIFT                    7
#define EIM_CSGCR1_BL_MASK                       0x700u
#define EIM_CSGCR1_BL_SHIFT                      8
#define EIM_CSGCR1_BL(x)                         (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_BL_SHIFT))&EIM_CSGCR1_BL_MASK)
#define EIM_CSGCR1_WC_MASK                       0x800u
#define EIM_CSGCR1_WC_SHIFT                      11
#define EIM_CSGCR1_BCD_MASK                      0x3000u
#define EIM_CSGCR1_BCD_SHIFT                     12
#define EIM_CSGCR1_BCD(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_BCD_SHIFT))&EIM_CSGCR1_BCD_MASK)
#define EIM_CSGCR1_BCS_MASK                      0xC000u
#define EIM_CSGCR1_BCS_SHIFT                     14
#define EIM_CSGCR1_BCS(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_BCS_SHIFT))&EIM_CSGCR1_BCS_MASK)
#define EIM_CSGCR1_DSZ_MASK                      0x70000u
#define EIM_CSGCR1_DSZ_SHIFT                     16
#define EIM_CSGCR1_DSZ(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_DSZ_SHIFT))&EIM_CSGCR1_DSZ_MASK)
#define EIM_CSGCR1_SP_MASK                       0x80000u
#define EIM_CSGCR1_SP_SHIFT                      19
#define EIM_CSGCR1_CSREC_MASK                    0x700000u
#define EIM_CSGCR1_CSREC_SHIFT                   20
#define EIM_CSGCR1_CSREC(x)                      (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_CSREC_SHIFT))&EIM_CSGCR1_CSREC_MASK)
#define EIM_CSGCR1_AUS_MASK                      0x800000u
#define EIM_CSGCR1_AUS_SHIFT                     23
#define EIM_CSGCR1_GBC_MASK                      0x7000000u
#define EIM_CSGCR1_GBC_SHIFT                     24
#define EIM_CSGCR1_GBC(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_GBC_SHIFT))&EIM_CSGCR1_GBC_MASK)
#define EIM_CSGCR1_WP_MASK                       0x8000000u
#define EIM_CSGCR1_WP_SHIFT                      27
#define EIM_CSGCR1_PSZ_MASK                      0xF0000000u
#define EIM_CSGCR1_PSZ_SHIFT                     28
#define EIM_CSGCR1_PSZ(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR1_PSZ_SHIFT))&EIM_CSGCR1_PSZ_MASK)
/* CSGCR2 Bit Fields */
#define EIM_CSGCR2_ADH_MASK                      0x3u
#define EIM_CSGCR2_ADH_SHIFT                     0
#define EIM_CSGCR2_ADH(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR2_ADH_SHIFT))&EIM_CSGCR2_ADH_MASK)
#define EIM_CSGCR2_DAPS_MASK                     0xF0u
#define EIM_CSGCR2_DAPS_SHIFT                    4
#define EIM_CSGCR2_DAPS(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSGCR2_DAPS_SHIFT))&EIM_CSGCR2_DAPS_MASK)
#define EIM_CSGCR2_DAE_MASK                      0x100u
#define EIM_CSGCR2_DAE_SHIFT                     8
#define EIM_CSGCR2_DAP_MASK                      0x200u
#define EIM_CSGCR2_DAP_SHIFT                     9
#define EIM_CSGCR2_MUX16_BYP_GRANT_MASK          0x1000u
#define EIM_CSGCR2_MUX16_BYP_GRANT_SHIFT         12
/* CSRCR1 Bit Fields */
#define EIM_CSRCR1_RCSN_MASK                     0x7u
#define EIM_CSRCR1_RCSN_SHIFT                    0
#define EIM_CSRCR1_RCSN(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_RCSN_SHIFT))&EIM_CSRCR1_RCSN_MASK)
#define EIM_CSRCR1_RCSA_MASK                     0x70u
#define EIM_CSRCR1_RCSA_SHIFT                    4
#define EIM_CSRCR1_RCSA(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_RCSA_SHIFT))&EIM_CSRCR1_RCSA_MASK)
#define EIM_CSRCR1_OEN_MASK                      0x700u
#define EIM_CSRCR1_OEN_SHIFT                     8
#define EIM_CSRCR1_OEN(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_OEN_SHIFT))&EIM_CSRCR1_OEN_MASK)
#define EIM_CSRCR1_OEA_MASK                      0x7000u
#define EIM_CSRCR1_OEA_SHIFT                     12
#define EIM_CSRCR1_OEA(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_OEA_SHIFT))&EIM_CSRCR1_OEA_MASK)
#define EIM_CSRCR1_RADVN_MASK                    0x70000u
#define EIM_CSRCR1_RADVN_SHIFT                   16
#define EIM_CSRCR1_RADVN(x)                      (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_RADVN_SHIFT))&EIM_CSRCR1_RADVN_MASK)
#define EIM_CSRCR1_RAL_MASK                      0x80000u
#define EIM_CSRCR1_RAL_SHIFT                     19
#define EIM_CSRCR1_RADVA_MASK                    0x700000u
#define EIM_CSRCR1_RADVA_SHIFT                   20
#define EIM_CSRCR1_RADVA(x)                      (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_RADVA_SHIFT))&EIM_CSRCR1_RADVA_MASK)
#define EIM_CSRCR1_RWSC_MASK                     0x3F000000u
#define EIM_CSRCR1_RWSC_SHIFT                    24
#define EIM_CSRCR1_RWSC(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR1_RWSC_SHIFT))&EIM_CSRCR1_RWSC_MASK)
/* CSRCR2 Bit Fields */
#define EIM_CSRCR2_RBEN_MASK                     0x7u
#define EIM_CSRCR2_RBEN_SHIFT                    0
#define EIM_CSRCR2_RBEN(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR2_RBEN_SHIFT))&EIM_CSRCR2_RBEN_MASK)
#define EIM_CSRCR2_RBE_MASK                      0x8u
#define EIM_CSRCR2_RBE_SHIFT                     3
#define EIM_CSRCR2_RBEA_MASK                     0x70u
#define EIM_CSRCR2_RBEA_SHIFT                    4
#define EIM_CSRCR2_RBEA(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR2_RBEA_SHIFT))&EIM_CSRCR2_RBEA_MASK)
#define EIM_CSRCR2_RL_MASK                       0x300u
#define EIM_CSRCR2_RL_SHIFT                      8
#define EIM_CSRCR2_RL(x)                         (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR2_RL_SHIFT))&EIM_CSRCR2_RL_MASK)
#define EIM_CSRCR2_PAT_MASK                      0x7000u
#define EIM_CSRCR2_PAT_SHIFT                     12
#define EIM_CSRCR2_PAT(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSRCR2_PAT_SHIFT))&EIM_CSRCR2_PAT_MASK)
#define EIM_CSRCR2_APR_MASK                      0x8000u
#define EIM_CSRCR2_APR_SHIFT                     15
/* CSWCR1 Bit Fields */
#define EIM_CSWCR1_WCSN_MASK                     0x7u
#define EIM_CSWCR1_WCSN_SHIFT                    0
#define EIM_CSWCR1_WCSN(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WCSN_SHIFT))&EIM_CSWCR1_WCSN_MASK)
#define EIM_CSWCR1_WCSA_MASK                     0x38u
#define EIM_CSWCR1_WCSA_SHIFT                    3
#define EIM_CSWCR1_WCSA(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WCSA_SHIFT))&EIM_CSWCR1_WCSA_MASK)
#define EIM_CSWCR1_WEN_MASK                      0x1C0u
#define EIM_CSWCR1_WEN_SHIFT                     6
#define EIM_CSWCR1_WEN(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WEN_SHIFT))&EIM_CSWCR1_WEN_MASK)
#define EIM_CSWCR1_WEA_MASK                      0xE00u
#define EIM_CSWCR1_WEA_SHIFT                     9
#define EIM_CSWCR1_WEA(x)                        (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WEA_SHIFT))&EIM_CSWCR1_WEA_MASK)
#define EIM_CSWCR1_WBEN_MASK                     0x7000u
#define EIM_CSWCR1_WBEN_SHIFT                    12
#define EIM_CSWCR1_WBEN(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WBEN_SHIFT))&EIM_CSWCR1_WBEN_MASK)
#define EIM_CSWCR1_WBEA_MASK                     0x38000u
#define EIM_CSWCR1_WBEA_SHIFT                    15
#define EIM_CSWCR1_WBEA(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WBEA_SHIFT))&EIM_CSWCR1_WBEA_MASK)
#define EIM_CSWCR1_WADVN_MASK                    0x1C0000u
#define EIM_CSWCR1_WADVN_SHIFT                   18
#define EIM_CSWCR1_WADVN(x)                      (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WADVN_SHIFT))&EIM_CSWCR1_WADVN_MASK)
#define EIM_CSWCR1_WADVA_MASK                    0xE00000u
#define EIM_CSWCR1_WADVA_SHIFT                   21
#define EIM_CSWCR1_WADVA(x)                      (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WADVA_SHIFT))&EIM_CSWCR1_WADVA_MASK)
#define EIM_CSWCR1_WWSC_MASK                     0x3F000000u
#define EIM_CSWCR1_WWSC_SHIFT                    24
#define EIM_CSWCR1_WWSC(x)                       (((uint32_t)(((uint32_t)(x))<<EIM_CSWCR1_WWSC_SHIFT))&EIM_CSWCR1_WWSC_MASK)
#define EIM_CSWCR1_WBED_MASK                     0x40000000u
#define EIM_CSWCR1_WBED_SHIFT                    30
#define EIM_CSWCR1_WAL_MASK                      0x80000000u
#define EIM_CSWCR1_WAL_SHIFT                     31
/* CSWCR2 Bit Fields */
#define EIM_CSWCR2_WBCDD_MASK                    0x1u
#define EIM_CSWCR2_WBCDD_SHIFT                   0
/* WCR Bit Fields */
#define EIM_WCR_BCM_MASK                         0x1u
#define EIM_WCR_BCM_SHIFT                        0
#define EIM_WCR_GBCD_MASK                        0x6u
#define EIM_WCR_GBCD_SHIFT                       1
#define EIM_WCR_GBCD(x)                          (((uint32_t)(((uint32_t)(x))<<EIM_WCR_GBCD_SHIFT))&EIM_WCR_GBCD_MASK)
#define EIM_WCR_CONT_BCLK_SEL_MASK               0x8u
#define EIM_WCR_CONT_BCLK_SEL_SHIFT              3
#define EIM_WCR_INTEN_MASK                       0x10u
#define EIM_WCR_INTEN_SHIFT                      4
#define EIM_WCR_INTPOL_MASK                      0x20u
#define EIM_WCR_INTPOL_SHIFT                     5
#define EIM_WCR_WDOG_EN_MASK                     0x100u
#define EIM_WCR_WDOG_EN_SHIFT                    8
#define EIM_WCR_WDOG_LIMIT_MASK                  0x600u
#define EIM_WCR_WDOG_LIMIT_SHIFT                 9
#define EIM_WCR_WDOG_LIMIT(x)                    (((uint32_t)(((uint32_t)(x))<<EIM_WCR_WDOG_LIMIT_SHIFT))&EIM_WCR_WDOG_LIMIT_MASK)
#define EIM_WCR_FRUN_ACLK_EN_MASK                0x800u
#define EIM_WCR_FRUN_ACLK_EN_SHIFT               11
/* DCR Bit Fields */
#define EIM_DCR_DLL_CTRL_ENABLE_MASK             0x1u
#define EIM_DCR_DLL_CTRL_ENABLE_SHIFT            0
#define EIM_DCR_DLL_CTRL_RESET_MASK              0x2u
#define EIM_DCR_DLL_CTRL_RESET_SHIFT             1
#define EIM_DCR_DLL_CTRL_SLV_FORCE_UPD_MASK      0x4u
#define EIM_DCR_DLL_CTRL_SLV_FORCE_UPD_SHIFT     2
#define EIM_DCR_DLL_CTRL_SLV_OFFSET_DEC_MASK     0x8u
#define EIM_DCR_DLL_CTRL_SLV_OFFSET_DEC_SHIFT    3
#define EIM_DCR_DLL_CTRL_SLV_OFFSET_MASK         0x70u
#define EIM_DCR_DLL_CTRL_SLV_OFFSET_SHIFT        4
#define EIM_DCR_DLL_CTRL_SLV_OFFSET(x)           (((uint32_t)(((uint32_t)(x))<<EIM_DCR_DLL_CTRL_SLV_OFFSET_SHIFT))&EIM_DCR_DLL_CTRL_SLV_OFFSET_MASK)
#define EIM_DCR_DLL_CTRL_GATE_UPDATE_MASK        0x80u
#define EIM_DCR_DLL_CTRL_GATE_UPDATE_SHIFT       7
#define EIM_DCR_DLL_CTRL_SLV_OVERRIDE_MASK       0x100u
#define EIM_DCR_DLL_CTRL_SLV_OVERRIDE_SHIFT      8
#define EIM_DCR_DLL_CTRL_SLV_OVERRIDE_VAL_MASK   0xFE00u
#define EIM_DCR_DLL_CTRL_SLV_OVERRIDE_VAL_SHIFT  9
#define EIM_DCR_DLL_CTRL_SLV_OVERRIDE_VAL(x)     (((uint32_t)(((uint32_t)(x))<<EIM_DCR_DLL_CTRL_SLV_OVERRIDE_VAL_SHIFT))&EIM_DCR_DLL_CTRL_SLV_OVERRIDE_VAL_MASK)
#define EIM_DCR_DLL_CTRL_REF_INITIAL_VAL_MASK    0x7F0000u
#define EIM_DCR_DLL_CTRL_REF_INITIAL_VAL_SHIFT   16
#define EIM_DCR_DLL_CTRL_REF_INITIAL_VAL(x)      (((uint32_t)(((uint32_t)(x))<<EIM_DCR_DLL_CTRL_REF_INITIAL_VAL_SHIFT))&EIM_DCR_DLL_CTRL_REF_INITIAL_VAL_MASK)
#define EIM_DCR_DLL_CTRL_SLV_UPDATE_INT_MASK     0xF800000u
#define EIM_DCR_DLL_CTRL_SLV_UPDATE_INT_SHIFT    23
#define EIM_DCR_DLL_CTRL_SLV_UPDATE_INT(x)       (((uint32_t)(((uint32_t)(x))<<EIM_DCR_DLL_CTRL_SLV_UPDATE_INT_SHIFT))&EIM_DCR_DLL_CTRL_SLV_UPDATE_INT_MASK)
#define EIM_DCR_DLL_CTRL_REF_UPDATE_INT_MASK     0xF0000000u
#define EIM_DCR_DLL_CTRL_REF_UPDATE_INT_SHIFT    28
#define EIM_DCR_DLL_CTRL_REF_UPDATE_INT(x)       (((uint32_t)(((uint32_t)(x))<<EIM_DCR_DLL_CTRL_REF_UPDATE_INT_SHIFT))&EIM_DCR_DLL_CTRL_REF_UPDATE_INT_MASK)
/* DSR Bit Fields */
#define EIM_DSR_DLL_STS_SLV_LOCK_MASK            0x1u
#define EIM_DSR_DLL_STS_SLV_LOCK_SHIFT           0
#define EIM_DSR_DLL_STS_REF_LOCK_MASK            0x2u
#define EIM_DSR_DLL_STS_REF_LOCK_SHIFT           1
#define EIM_DSR_DLL_STS_SLV_SEL_MASK             0x1FCu
#define EIM_DSR_DLL_STS_SLV_SEL_SHIFT            2
#define EIM_DSR_DLL_STS_SLV_SEL(x)               (((uint32_t)(((uint32_t)(x))<<EIM_DSR_DLL_STS_SLV_SEL_SHIFT))&EIM_DSR_DLL_STS_SLV_SEL_MASK)
#define EIM_DSR_DLL_STS_REF_SEL_MASK             0xFE00u
#define EIM_DSR_DLL_STS_REF_SEL_SHIFT            9
#define EIM_DSR_DLL_STS_REF_SEL(x)               (((uint32_t)(((uint32_t)(x))<<EIM_DSR_DLL_STS_REF_SEL_SHIFT))&EIM_DSR_DLL_STS_REF_SEL_MASK)
/* WIAR Bit Fields */
#define EIM_WIAR_IPS_REQ_MASK                    0x1u
#define EIM_WIAR_IPS_REQ_SHIFT                   0
#define EIM_WIAR_IPS_ACK_MASK                    0x2u
#define EIM_WIAR_IPS_ACK_SHIFT                   1
#define EIM_WIAR_INT_MASK                        0x4u
#define EIM_WIAR_INT_SHIFT                       2
#define EIM_WIAR_ERRST_MASK                      0x8u
#define EIM_WIAR_ERRST_SHIFT                     3
#define EIM_WIAR_ACLK_EN_MASK                    0x10u
#define EIM_WIAR_ACLK_EN_SHIFT                   4
/* EAR Bit Fields */
#define EIM_EAR_Error_ADDR_MASK                  0xFFFFFFFFu
#define EIM_EAR_Error_ADDR_SHIFT                 0
#define EIM_EAR_Error_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<EIM_EAR_Error_ADDR_SHIFT))&EIM_EAR_Error_ADDR_MASK)

/*!
 * @}
 */ /* end of group EIM_Register_Masks */


/* EIM - Peripheral instance base addresses */
/** Peripheral EIM base pointer */
#define EIM_BASE_PTR                             ((EIM_MemMapPtr)0x421B8000u)
/** Array initializer of EIM peripheral base pointers */
#define EIM_BASE_PTRS                            { EIM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- EIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Accessor_Macros EIM - Register accessor macros
 * @{
 */


/* EIM - Register instance definitions */
/* EIM */
#define EIM_CS0GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,0)
#define EIM_CS0GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,0)
#define EIM_CS0RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,0)
#define EIM_CS0RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,0)
#define EIM_CS0WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,0)
#define EIM_CS0WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,0)
#define EIM_CS1GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,1)
#define EIM_CS1GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,1)
#define EIM_CS1RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,1)
#define EIM_CS1RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,1)
#define EIM_CS1WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,1)
#define EIM_CS1WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,1)
#define EIM_CS2GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,2)
#define EIM_CS2GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,2)
#define EIM_CS2RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,2)
#define EIM_CS2RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,2)
#define EIM_CS2WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,2)
#define EIM_CS2WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,2)
#define EIM_CS3GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,3)
#define EIM_CS3GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,3)
#define EIM_CS3RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,3)
#define EIM_CS3RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,3)
#define EIM_CS3WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,3)
#define EIM_CS3WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,3)
#define EIM_CS4GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,4)
#define EIM_CS4GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,4)
#define EIM_CS4RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,4)
#define EIM_CS4RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,4)
#define EIM_CS4WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,4)
#define EIM_CS4WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,4)
#define EIM_CS5GCR1                              EIM_CSGCR1_REG(EIM_BASE_PTR,5)
#define EIM_CS5GCR2                              EIM_CSGCR2_REG(EIM_BASE_PTR,5)
#define EIM_CS5RCR1                              EIM_CSRCR1_REG(EIM_BASE_PTR,5)
#define EIM_CS5RCR2                              EIM_CSRCR2_REG(EIM_BASE_PTR,5)
#define EIM_CS5WCR1                              EIM_CSWCR1_REG(EIM_BASE_PTR,5)
#define EIM_CS5WCR2                              EIM_CSWCR2_REG(EIM_BASE_PTR,5)
#define EIM_WCR                                  EIM_WCR_REG(EIM_BASE_PTR)
#define EIM_DCR                                  EIM_DCR_REG(EIM_BASE_PTR)
#define EIM_DSR                                  EIM_DSR_REG(EIM_BASE_PTR)
#define EIM_WIAR                                 EIM_WIAR_REG(EIM_BASE_PTR)
#define EIM_EAR                                  EIM_EAR_REG(EIM_BASE_PTR)

/* EIM - Register array accessors */
#define EIM_CSGCR1(index)                        EIM_CSGCR1_REG(EIM_BASE_PTR,index)
#define EIM_CSGCR2(index)                        EIM_CSGCR2_REG(EIM_BASE_PTR,index)
#define EIM_CSRCR1(index)                        EIM_CSRCR1_REG(EIM_BASE_PTR,index)
#define EIM_CSRCR2(index)                        EIM_CSRCR2_REG(EIM_BASE_PTR,index)
#define EIM_CSWCR1(index)                        EIM_CSWCR1_REG(EIM_BASE_PTR,index)
#define EIM_CSWCR2(index)                        EIM_CSWCR2_REG(EIM_BASE_PTR,index)

/*!
 * @}
 */ /* end of group EIM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group EIM_Peripheral */


/* ----------------------------------------------------------------------------
   -- ENET
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Peripheral ENET
 * @{
 */

/** ENET - Peripheral register structure */
typedef struct ENET_MemMap {
  uint8_t RESERVED_0[4];
  uint32_t EIR;                                    /**< Interrupt Event Register, offset: 0x4 */
  uint32_t EIMR;                                   /**< Interrupt Mask Register, offset: 0x8 */
  uint8_t RESERVED_1[4];
  uint32_t RDAR;                                   /**< Receive Descriptor Active Register - Ring 0, offset: 0x10 */
  uint32_t TDAR;                                   /**< Transmit Descriptor Active Register - Ring 0, offset: 0x14 */
  uint8_t RESERVED_2[12];
  uint32_t ECR;                                    /**< Ethernet Control Register, offset: 0x24 */
  uint8_t RESERVED_3[24];
  uint32_t MMFR;                                   /**< MII Management Frame Register, offset: 0x40 */
  uint32_t MSCR;                                   /**< MII Speed Control Register, offset: 0x44 */
  uint8_t RESERVED_4[28];
  uint32_t MIBC;                                   /**< MIB Control Register, offset: 0x64 */
  uint8_t RESERVED_5[28];
  uint32_t RCR;                                    /**< Receive Control Register, offset: 0x84 */
  uint8_t RESERVED_6[60];
  uint32_t TCR;                                    /**< Transmit Control Register, offset: 0xC4 */
  uint8_t RESERVED_7[28];
  uint32_t PALR;                                   /**< Physical Address Lower Register, offset: 0xE4 */
  uint32_t PAUR;                                   /**< Physical Address Upper Register, offset: 0xE8 */
  uint32_t OPD;                                    /**< Opcode/Pause Duration Register, offset: 0xEC */
  uint32_t TXIC[3];                                /**< Transmit Interrupt Coalescing Register, array offset: 0xF0, array step: 0x4 */
  uint8_t RESERVED_8[4];
  uint32_t RXIC[3];                                /**< Receive Interrupt Coalescing Register, array offset: 0x100, array step: 0x4 */
  uint8_t RESERVED_9[12];
  uint32_t IAUR;                                   /**< Descriptor Individual Upper Address Register, offset: 0x118 */
  uint32_t IALR;                                   /**< Descriptor Individual Lower Address Register, offset: 0x11C */
  uint32_t GAUR;                                   /**< Descriptor Group Upper Address Register, offset: 0x120 */
  uint32_t GALR;                                   /**< Descriptor Group Lower Address Register, offset: 0x124 */
  uint8_t RESERVED_10[28];
  uint32_t TFWR;                                   /**< Transmit FIFO Watermark Register, offset: 0x144 */
  uint8_t RESERVED_11[24];
  uint32_t RDSR1;                                  /**< Receive Descriptor Ring 1 Start Register, offset: 0x160 */
  uint32_t TDSR1;                                  /**< Transmit Buffer Descriptor Ring 1 Start Register, offset: 0x164 */
  uint32_t MRBR1;                                  /**< Maximum Receive Buffer Size Register - Ring 1, offset: 0x168 */
  uint32_t RDSR2;                                  /**< Receive Descriptor Ring 2 Start Register, offset: 0x16C */
  uint32_t TDSR2;                                  /**< Transmit Buffer Descriptor Ring 2 Start Register, offset: 0x170 */
  uint32_t MRBR2;                                  /**< Maximum Receive Buffer Size Register - Ring 2, offset: 0x174 */
  uint8_t RESERVED_12[8];
  uint32_t RDSR;                                   /**< Receive Descriptor Ring 0 Start Register, offset: 0x180 */
  uint32_t TDSR;                                   /**< Transmit Buffer Descriptor Ring 0 Start Register, offset: 0x184 */
  uint32_t MRBR;                                   /**< Maximum Receive Buffer Size Register - Ring 0, offset: 0x188 */
  uint8_t RESERVED_13[4];
  uint32_t RSFL;                                   /**< Receive FIFO Section Full Threshold, offset: 0x190 */
  uint32_t RSEM;                                   /**< Receive FIFO Section Empty Threshold, offset: 0x194 */
  uint32_t RAEM;                                   /**< Receive FIFO Almost Empty Threshold, offset: 0x198 */
  uint32_t RAFL;                                   /**< Receive FIFO Almost Full Threshold, offset: 0x19C */
  uint32_t TSEM;                                   /**< Transmit FIFO Section Empty Threshold, offset: 0x1A0 */
  uint32_t TAEM;                                   /**< Transmit FIFO Almost Empty Threshold, offset: 0x1A4 */
  uint32_t TAFL;                                   /**< Transmit FIFO Almost Full Threshold, offset: 0x1A8 */
  uint32_t TIPG;                                   /**< Transmit Inter-Packet Gap, offset: 0x1AC */
  uint32_t FTRL;                                   /**< Frame Truncation Length, offset: 0x1B0 */
  uint8_t RESERVED_14[12];
  uint32_t TACC;                                   /**< Transmit Accelerator Function Configuration, offset: 0x1C0 */
  uint32_t RACC;                                   /**< Receive Accelerator Function Configuration, offset: 0x1C4 */
  uint32_t RCMR1;                                  /**< Receive Classification Match Register for Class n, offset: 0x1C8 */
  uint32_t RCMR2;                                  /**< Receive Classification Match Register for Class n, offset: 0x1CC */
  uint8_t RESERVED_15[8];
  uint32_t DMA1CFG;                                /**< DMA Class Based Configuration, offset: 0x1D8 */
  uint32_t DMA2CFG;                                /**< DMA Class Based Configuration, offset: 0x1DC */
  uint32_t RDAR1;                                  /**< Receive Descriptor Active Register - Ring 1, offset: 0x1E0 */
  uint32_t TDAR1;                                  /**< Transmit Descriptor Active Register - Ring 1, offset: 0x1E4 */
  uint32_t RDAR2;                                  /**< Receive Descriptor Active Register - Ring 2, offset: 0x1E8 */
  uint32_t TDAR2;                                  /**< Transmit Descriptor Active Register - Ring 2, offset: 0x1EC */
  uint32_t QOS;                                    /**< QOS Scheme, offset: 0x1F0 */
  uint8_t RESERVED_16[16];
  uint32_t RMON_T_PACKETS;                         /**< Tx Packet Count Statistic Register, offset: 0x204 */
  uint32_t RMON_T_BC_PKT;                          /**< Tx Broadcast Packets Statistic Register, offset: 0x208 */
  uint32_t RMON_T_MC_PKT;                          /**< Tx Multicast Packets Statistic Register, offset: 0x20C */
  uint32_t RMON_T_CRC_ALIGN;                       /**< Tx Packets with CRC/Align Error Statistic Register, offset: 0x210 */
  uint32_t RMON_T_UNDERSIZE;                       /**< Tx Packets Less Than Bytes and Good CRC Statistic Register, offset: 0x214 */
  uint32_t RMON_T_OVERSIZE;                        /**< Tx Packets GT MAX_FL bytes and Good CRC Statistic Register, offset: 0x218 */
  uint32_t RMON_T_FRAG;                            /**< Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x21C */
  uint32_t RMON_T_JAB;                             /**< Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register, offset: 0x220 */
  uint32_t RMON_T_COL;                             /**< Tx Collision Count Statistic Register, offset: 0x224 */
  uint32_t RMON_T_P64;                             /**< Tx 64-Byte Packets Statistic Register, offset: 0x228 */
  uint32_t RMON_T_P65TO127;                        /**< Tx 65- to 127-byte Packets Statistic Register, offset: 0x22C */
  uint32_t RMON_T_P128TO255;                       /**< Tx 128- to 255-byte Packets Statistic Register, offset: 0x230 */
  uint32_t RMON_T_P256TO511;                       /**< Tx 256- to 511-byte Packets Statistic Register, offset: 0x234 */
  uint32_t RMON_T_P512TO1023;                      /**< Tx 512- to 1023-byte Packets Statistic Register, offset: 0x238 */
  uint32_t RMON_T_P1024TO2047;                     /**< Tx 1024- to 2047-byte Packets Statistic Register, offset: 0x23C */
  uint32_t RMON_T_P_GTE2048;                       /**< Tx Packets Greater Than 2048 Bytes Statistic Register, offset: 0x240 */
  uint32_t RMON_T_OCTETS;                          /**< Tx Octets Statistic Register, offset: 0x244 */
  uint8_t RESERVED_17[4];
  uint32_t IEEE_T_FRAME_OK;                        /**< Frames Transmitted OK Statistic Register, offset: 0x24C */
  uint32_t IEEE_T_1COL;                            /**< Frames Transmitted with Single Collision Statistic Register, offset: 0x250 */
  uint32_t IEEE_T_MCOL;                            /**< Frames Transmitted with Multiple Collisions Statistic Register, offset: 0x254 */
  uint32_t IEEE_T_DEF;                             /**< Frames Transmitted after Deferral Delay Statistic Register, offset: 0x258 */
  uint32_t IEEE_T_LCOL;                            /**< Frames Transmitted with Late Collision Statistic Register, offset: 0x25C */
  uint32_t IEEE_T_EXCOL;                           /**< Frames Transmitted with Excessive Collisions Statistic Register, offset: 0x260 */
  uint32_t IEEE_T_MACERR;                          /**< Frames Transmitted with Tx FIFO Underrun Statistic Register, offset: 0x264 */
  uint32_t IEEE_T_CSERR;                           /**< Frames Transmitted with Carrier Sense Error Statistic Register, offset: 0x268 */
  uint8_t RESERVED_18[4];
  uint32_t IEEE_T_FDXFC;                           /**< Flow Control Pause Frames Transmitted Statistic Register, offset: 0x270 */
  uint32_t IEEE_T_OCTETS_OK;                       /**< Octet Count for Frames Transmitted w/o Error Statistic Register, offset: 0x274 */
  uint8_t RESERVED_19[12];
  uint32_t RMON_R_PACKETS;                         /**< Rx Packet Count Statistic Register, offset: 0x284 */
  uint32_t RMON_R_BC_PKT;                          /**< Rx Broadcast Packets Statistic Register, offset: 0x288 */
  uint32_t RMON_R_MC_PKT;                          /**< Rx Multicast Packets Statistic Register, offset: 0x28C */
  uint32_t RMON_R_CRC_ALIGN;                       /**< Rx Packets with CRC/Align Error Statistic Register, offset: 0x290 */
  uint32_t RMON_R_UNDERSIZE;                       /**< Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register, offset: 0x294 */
  uint32_t RMON_R_OVERSIZE;                        /**< Rx Packets Greater Than MAX_FL and Good CRC Statistic Register, offset: 0x298 */
  uint32_t RMON_R_FRAG;                            /**< Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register, offset: 0x29C */
  uint32_t RMON_R_JAB;                             /**< Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register, offset: 0x2A0 */
  uint8_t RESERVED_20[4];
  uint32_t RMON_R_P64;                             /**< Rx 64-Byte Packets Statistic Register, offset: 0x2A8 */
  uint32_t RMON_R_P65TO127;                        /**< Rx 65- to 127-Byte Packets Statistic Register, offset: 0x2AC */
  uint32_t RMON_R_P128TO255;                       /**< Rx 128- to 255-Byte Packets Statistic Register, offset: 0x2B0 */
  uint32_t RMON_R_P256TO511;                       /**< Rx 256- to 511-Byte Packets Statistic Register, offset: 0x2B4 */
  uint32_t RMON_R_P512TO1023;                      /**< Rx 512- to 1023-Byte Packets Statistic Register, offset: 0x2B8 */
  uint32_t RMON_R_P1024TO2047;                     /**< Rx 1024- to 2047-Byte Packets Statistic Register, offset: 0x2BC */
  uint32_t RMON_R_P_GTE2048;                       /**< Rx Packets Greater than 2048 Bytes Statistic Register, offset: 0x2C0 */
  uint32_t RMON_R_OCTETS;                          /**< Rx Octets Statistic Register, offset: 0x2C4 */
  uint32_t IEEE_R_DROP;                            /**< Frames not Counted Correctly Statistic Register, offset: 0x2C8 */
  uint32_t IEEE_R_FRAME_OK;                        /**< Frames Received OK Statistic Register, offset: 0x2CC */
  uint32_t IEEE_R_CRC;                             /**< Frames Received with CRC Error Statistic Register, offset: 0x2D0 */
  uint32_t IEEE_R_ALIGN;                           /**< Frames Received with Alignment Error Statistic Register, offset: 0x2D4 */
  uint32_t IEEE_R_MACERR;                          /**< Receive FIFO Overflow Count Statistic Register, offset: 0x2D8 */
  uint32_t IEEE_R_FDXFC;                           /**< Flow Control Pause Frames Received Statistic Register, offset: 0x2DC */
  uint32_t IEEE_R_OCTETS_OK;                       /**< Octet Count for Frames Received without Error Statistic Register, offset: 0x2E0 */
  uint8_t RESERVED_21[284];
  uint32_t ATCR;                                   /**< Adjustable Timer Control Register, offset: 0x400 */
  uint32_t ATVR;                                   /**< Timer Value Register, offset: 0x404 */
  uint32_t ATOFF;                                  /**< Timer Offset Register, offset: 0x408 */
  uint32_t ATPER;                                  /**< Timer Period Register, offset: 0x40C */
  uint32_t ATCOR;                                  /**< Timer Correction Register, offset: 0x410 */
  uint32_t ATINC;                                  /**< Time-Stamping Clock Period Register, offset: 0x414 */
  uint32_t ATSTMP;                                 /**< Timestamp of Last Transmitted Frame, offset: 0x418 */
  uint8_t RESERVED_22[488];
  uint32_t TGSR;                                   /**< Timer Global Status Register, offset: 0x604 */
  struct {                                         /* offset: 0x608, array step: 0x8 */
    uint32_t TCSR;                                   /**< Timer Control Status Register, array offset: 0x608, array step: 0x8 */
    uint32_t TCCR;                                   /**< Timer Compare Capture Register, array offset: 0x60C, array step: 0x8 */
  } TCxR[4];
} volatile *ENET_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ENET - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Accessor_Macros ENET - Register accessor macros
 * @{
 */


/* ENET - Register accessors */
#define ENET_EIR_REG(base)                       ((base)->EIR)
#define ENET_EIMR_REG(base)                      ((base)->EIMR)
#define ENET_RDAR_REG(base)                      ((base)->RDAR)
#define ENET_TDAR_REG(base)                      ((base)->TDAR)
#define ENET_ECR_REG(base)                       ((base)->ECR)
#define ENET_MMFR_REG(base)                      ((base)->MMFR)
#define ENET_MSCR_REG(base)                      ((base)->MSCR)
#define ENET_MIBC_REG(base)                      ((base)->MIBC)
#define ENET_RCR_REG(base)                       ((base)->RCR)
#define ENET_TCR_REG(base)                       ((base)->TCR)
#define ENET_PALR_REG(base)                      ((base)->PALR)
#define ENET_PAUR_REG(base)                      ((base)->PAUR)
#define ENET_OPD_REG(base)                       ((base)->OPD)
#define ENET_TXIC_REG(base,index)                ((base)->TXIC[index])
#define ENET_RXIC_REG(base,index)                ((base)->RXIC[index])
#define ENET_IAUR_REG(base)                      ((base)->IAUR)
#define ENET_IALR_REG(base)                      ((base)->IALR)
#define ENET_GAUR_REG(base)                      ((base)->GAUR)
#define ENET_GALR_REG(base)                      ((base)->GALR)
#define ENET_TFWR_REG(base)                      ((base)->TFWR)
#define ENET_RDSR1_REG(base)                     ((base)->RDSR1)
#define ENET_TDSR1_REG(base)                     ((base)->TDSR1)
#define ENET_MRBR1_REG(base)                     ((base)->MRBR1)
#define ENET_RDSR2_REG(base)                     ((base)->RDSR2)
#define ENET_TDSR2_REG(base)                     ((base)->TDSR2)
#define ENET_MRBR2_REG(base)                     ((base)->MRBR2)
#define ENET_RDSR_REG(base)                      ((base)->RDSR)
#define ENET_TDSR_REG(base)                      ((base)->TDSR)
#define ENET_MRBR_REG(base)                      ((base)->MRBR)
#define ENET_RSFL_REG(base)                      ((base)->RSFL)
#define ENET_RSEM_REG(base)                      ((base)->RSEM)
#define ENET_RAEM_REG(base)                      ((base)->RAEM)
#define ENET_RAFL_REG(base)                      ((base)->RAFL)
#define ENET_TSEM_REG(base)                      ((base)->TSEM)
#define ENET_TAEM_REG(base)                      ((base)->TAEM)
#define ENET_TAFL_REG(base)                      ((base)->TAFL)
#define ENET_TIPG_REG(base)                      ((base)->TIPG)
#define ENET_FTRL_REG(base)                      ((base)->FTRL)
#define ENET_TACC_REG(base)                      ((base)->TACC)
#define ENET_RACC_REG(base)                      ((base)->RACC)
#define ENET_RCMR1_REG(base)                     ((base)->RCMR1)
#define ENET_RCMR2_REG(base)                     ((base)->RCMR2)
#define ENET_DMA1CFG_REG(base)                   ((base)->DMA1CFG)
#define ENET_DMA2CFG_REG(base)                   ((base)->DMA2CFG)
#define ENET_RDAR1_REG(base)                     ((base)->RDAR1)
#define ENET_TDAR1_REG(base)                     ((base)->TDAR1)
#define ENET_RDAR2_REG(base)                     ((base)->RDAR2)
#define ENET_TDAR2_REG(base)                     ((base)->TDAR2)
#define ENET_QOS_REG(base)                       ((base)->QOS)
#define ENET_RMON_T_PACKETS_REG(base)            ((base)->RMON_T_PACKETS)
#define ENET_RMON_T_BC_PKT_REG(base)             ((base)->RMON_T_BC_PKT)
#define ENET_RMON_T_MC_PKT_REG(base)             ((base)->RMON_T_MC_PKT)
#define ENET_RMON_T_CRC_ALIGN_REG(base)          ((base)->RMON_T_CRC_ALIGN)
#define ENET_RMON_T_UNDERSIZE_REG(base)          ((base)->RMON_T_UNDERSIZE)
#define ENET_RMON_T_OVERSIZE_REG(base)           ((base)->RMON_T_OVERSIZE)
#define ENET_RMON_T_FRAG_REG(base)               ((base)->RMON_T_FRAG)
#define ENET_RMON_T_JAB_REG(base)                ((base)->RMON_T_JAB)
#define ENET_RMON_T_COL_REG(base)                ((base)->RMON_T_COL)
#define ENET_RMON_T_P64_REG(base)                ((base)->RMON_T_P64)
#define ENET_RMON_T_P65TO127_REG(base)           ((base)->RMON_T_P65TO127)
#define ENET_RMON_T_P128TO255_REG(base)          ((base)->RMON_T_P128TO255)
#define ENET_RMON_T_P256TO511_REG(base)          ((base)->RMON_T_P256TO511)
#define ENET_RMON_T_P512TO1023_REG(base)         ((base)->RMON_T_P512TO1023)
#define ENET_RMON_T_P1024TO2047_REG(base)        ((base)->RMON_T_P1024TO2047)
#define ENET_RMON_T_P_GTE2048_REG(base)          ((base)->RMON_T_P_GTE2048)
#define ENET_RMON_T_OCTETS_REG(base)             ((base)->RMON_T_OCTETS)
#define ENET_IEEE_T_FRAME_OK_REG(base)           ((base)->IEEE_T_FRAME_OK)
#define ENET_IEEE_T_1COL_REG(base)               ((base)->IEEE_T_1COL)
#define ENET_IEEE_T_MCOL_REG(base)               ((base)->IEEE_T_MCOL)
#define ENET_IEEE_T_DEF_REG(base)                ((base)->IEEE_T_DEF)
#define ENET_IEEE_T_LCOL_REG(base)               ((base)->IEEE_T_LCOL)
#define ENET_IEEE_T_EXCOL_REG(base)              ((base)->IEEE_T_EXCOL)
#define ENET_IEEE_T_MACERR_REG(base)             ((base)->IEEE_T_MACERR)
#define ENET_IEEE_T_CSERR_REG(base)              ((base)->IEEE_T_CSERR)
#define ENET_IEEE_T_FDXFC_REG(base)              ((base)->IEEE_T_FDXFC)
#define ENET_IEEE_T_OCTETS_OK_REG(base)          ((base)->IEEE_T_OCTETS_OK)
#define ENET_RMON_R_PACKETS_REG(base)            ((base)->RMON_R_PACKETS)
#define ENET_RMON_R_BC_PKT_REG(base)             ((base)->RMON_R_BC_PKT)
#define ENET_RMON_R_MC_PKT_REG(base)             ((base)->RMON_R_MC_PKT)
#define ENET_RMON_R_CRC_ALIGN_REG(base)          ((base)->RMON_R_CRC_ALIGN)
#define ENET_RMON_R_UNDERSIZE_REG(base)          ((base)->RMON_R_UNDERSIZE)
#define ENET_RMON_R_OVERSIZE_REG(base)           ((base)->RMON_R_OVERSIZE)
#define ENET_RMON_R_FRAG_REG(base)               ((base)->RMON_R_FRAG)
#define ENET_RMON_R_JAB_REG(base)                ((base)->RMON_R_JAB)
#define ENET_RMON_R_P64_REG(base)                ((base)->RMON_R_P64)
#define ENET_RMON_R_P65TO127_REG(base)           ((base)->RMON_R_P65TO127)
#define ENET_RMON_R_P128TO255_REG(base)          ((base)->RMON_R_P128TO255)
#define ENET_RMON_R_P256TO511_REG(base)          ((base)->RMON_R_P256TO511)
#define ENET_RMON_R_P512TO1023_REG(base)         ((base)->RMON_R_P512TO1023)
#define ENET_RMON_R_P1024TO2047_REG(base)        ((base)->RMON_R_P1024TO2047)
#define ENET_RMON_R_P_GTE2048_REG(base)          ((base)->RMON_R_P_GTE2048)
#define ENET_RMON_R_OCTETS_REG(base)             ((base)->RMON_R_OCTETS)
#define ENET_IEEE_R_DROP_REG(base)               ((base)->IEEE_R_DROP)
#define ENET_IEEE_R_FRAME_OK_REG(base)           ((base)->IEEE_R_FRAME_OK)
#define ENET_IEEE_R_CRC_REG(base)                ((base)->IEEE_R_CRC)
#define ENET_IEEE_R_ALIGN_REG(base)              ((base)->IEEE_R_ALIGN)
#define ENET_IEEE_R_MACERR_REG(base)             ((base)->IEEE_R_MACERR)
#define ENET_IEEE_R_FDXFC_REG(base)              ((base)->IEEE_R_FDXFC)
#define ENET_IEEE_R_OCTETS_OK_REG(base)          ((base)->IEEE_R_OCTETS_OK)
#define ENET_ATCR_REG(base)                      ((base)->ATCR)
#define ENET_ATVR_REG(base)                      ((base)->ATVR)
#define ENET_ATOFF_REG(base)                     ((base)->ATOFF)
#define ENET_ATPER_REG(base)                     ((base)->ATPER)
#define ENET_ATCOR_REG(base)                     ((base)->ATCOR)
#define ENET_ATINC_REG(base)                     ((base)->ATINC)
#define ENET_ATSTMP_REG(base)                    ((base)->ATSTMP)
#define ENET_TGSR_REG(base)                      ((base)->TGSR)
#define ENET_TCSR_REG(base,index)                ((base)->TCxR[index].TCSR)
#define ENET_TCCR_REG(base,index)                ((base)->TCxR[index].TCCR)

/*!
 * @}
 */ /* end of group ENET_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ENET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Masks ENET Register Masks
 * @{
 */

/* EIR Bit Fields */
#define ENET_EIR_RXB1_MASK                       0x1u
#define ENET_EIR_RXB1_SHIFT                      0
#define ENET_EIR_RXF1_MASK                       0x2u
#define ENET_EIR_RXF1_SHIFT                      1
#define ENET_EIR_TXB1_MASK                       0x4u
#define ENET_EIR_TXB1_SHIFT                      2
#define ENET_EIR_TXF1_MASK                       0x8u
#define ENET_EIR_TXF1_SHIFT                      3
#define ENET_EIR_RXB2_MASK                       0x10u
#define ENET_EIR_RXB2_SHIFT                      4
#define ENET_EIR_RXF2_MASK                       0x20u
#define ENET_EIR_RXF2_SHIFT                      5
#define ENET_EIR_TXB2_MASK                       0x40u
#define ENET_EIR_TXB2_SHIFT                      6
#define ENET_EIR_TXF2_MASK                       0x80u
#define ENET_EIR_TXF2_SHIFT                      7
#define ENET_EIR_RXFLUSH_0_MASK                  0x1000u
#define ENET_EIR_RXFLUSH_0_SHIFT                 12
#define ENET_EIR_RXFLUSH_1_MASK                  0x2000u
#define ENET_EIR_RXFLUSH_1_SHIFT                 13
#define ENET_EIR_RXFLUSH_2_MASK                  0x4000u
#define ENET_EIR_RXFLUSH_2_SHIFT                 14
#define ENET_EIR_TS_TIMER_MASK                   0x8000u
#define ENET_EIR_TS_TIMER_SHIFT                  15
#define ENET_EIR_TS_AVAIL_MASK                   0x10000u
#define ENET_EIR_TS_AVAIL_SHIFT                  16
#define ENET_EIR_WAKEUP_MASK                     0x20000u
#define ENET_EIR_WAKEUP_SHIFT                    17
#define ENET_EIR_PLR_MASK                        0x40000u
#define ENET_EIR_PLR_SHIFT                       18
#define ENET_EIR_UN_MASK                         0x80000u
#define ENET_EIR_UN_SHIFT                        19
#define ENET_EIR_RL_MASK                         0x100000u
#define ENET_EIR_RL_SHIFT                        20
#define ENET_EIR_LC_MASK                         0x200000u
#define ENET_EIR_LC_SHIFT                        21
#define ENET_EIR_EBERR_MASK                      0x400000u
#define ENET_EIR_EBERR_SHIFT                     22
#define ENET_EIR_MII_MASK                        0x800000u
#define ENET_EIR_MII_SHIFT                       23
#define ENET_EIR_RXB_MASK                        0x1000000u
#define ENET_EIR_RXB_SHIFT                       24
#define ENET_EIR_RXF_MASK                        0x2000000u
#define ENET_EIR_RXF_SHIFT                       25
#define ENET_EIR_TXB_MASK                        0x4000000u
#define ENET_EIR_TXB_SHIFT                       26
#define ENET_EIR_TXF_MASK                        0x8000000u
#define ENET_EIR_TXF_SHIFT                       27
#define ENET_EIR_GRA_MASK                        0x10000000u
#define ENET_EIR_GRA_SHIFT                       28
#define ENET_EIR_BABT_MASK                       0x20000000u
#define ENET_EIR_BABT_SHIFT                      29
#define ENET_EIR_BABR_MASK                       0x40000000u
#define ENET_EIR_BABR_SHIFT                      30
/* EIMR Bit Fields */
#define ENET_EIMR_RXB1_MASK                      0x1u
#define ENET_EIMR_RXB1_SHIFT                     0
#define ENET_EIMR_RXF1_MASK                      0x2u
#define ENET_EIMR_RXF1_SHIFT                     1
#define ENET_EIMR_TXB1_MASK                      0x4u
#define ENET_EIMR_TXB1_SHIFT                     2
#define ENET_EIMR_TXF1_MASK                      0x8u
#define ENET_EIMR_TXF1_SHIFT                     3
#define ENET_EIMR_RXB2_MASK                      0x10u
#define ENET_EIMR_RXB2_SHIFT                     4
#define ENET_EIMR_RXF2_MASK                      0x20u
#define ENET_EIMR_RXF2_SHIFT                     5
#define ENET_EIMR_TXB2_MASK                      0x40u
#define ENET_EIMR_TXB2_SHIFT                     6
#define ENET_EIMR_TXF2_MASK                      0x80u
#define ENET_EIMR_TXF2_SHIFT                     7
#define ENET_EIMR_RXFLUSH_0_MASK                 0x1000u
#define ENET_EIMR_RXFLUSH_0_SHIFT                12
#define ENET_EIMR_RXFLUSH_1_MASK                 0x2000u
#define ENET_EIMR_RXFLUSH_1_SHIFT                13
#define ENET_EIMR_RXFLUSH_2_MASK                 0x4000u
#define ENET_EIMR_RXFLUSH_2_SHIFT                14
#define ENET_EIMR_TS_TIMER_MASK                  0x8000u
#define ENET_EIMR_TS_TIMER_SHIFT                 15
#define ENET_EIMR_TS_AVAIL_MASK                  0x10000u
#define ENET_EIMR_TS_AVAIL_SHIFT                 16
#define ENET_EIMR_WAKEUP_MASK                    0x20000u
#define ENET_EIMR_WAKEUP_SHIFT                   17
#define ENET_EIMR_PLR_MASK                       0x40000u
#define ENET_EIMR_PLR_SHIFT                      18
#define ENET_EIMR_UN_MASK                        0x80000u
#define ENET_EIMR_UN_SHIFT                       19
#define ENET_EIMR_RL_MASK                        0x100000u
#define ENET_EIMR_RL_SHIFT                       20
#define ENET_EIMR_LC_MASK                        0x200000u
#define ENET_EIMR_LC_SHIFT                       21
#define ENET_EIMR_EBERR_MASK                     0x400000u
#define ENET_EIMR_EBERR_SHIFT                    22
#define ENET_EIMR_MII_MASK                       0x800000u
#define ENET_EIMR_MII_SHIFT                      23
#define ENET_EIMR_RXB_MASK                       0x1000000u
#define ENET_EIMR_RXB_SHIFT                      24
#define ENET_EIMR_RXF_MASK                       0x2000000u
#define ENET_EIMR_RXF_SHIFT                      25
#define ENET_EIMR_TXB_MASK                       0x4000000u
#define ENET_EIMR_TXB_SHIFT                      26
#define ENET_EIMR_TXF_MASK                       0x8000000u
#define ENET_EIMR_TXF_SHIFT                      27
#define ENET_EIMR_GRA_MASK                       0x10000000u
#define ENET_EIMR_GRA_SHIFT                      28
#define ENET_EIMR_BABT_MASK                      0x20000000u
#define ENET_EIMR_BABT_SHIFT                     29
#define ENET_EIMR_BABR_MASK                      0x40000000u
#define ENET_EIMR_BABR_SHIFT                     30
/* RDAR Bit Fields */
#define ENET_RDAR_RDAR_MASK                      0x1000000u
#define ENET_RDAR_RDAR_SHIFT                     24
/* TDAR Bit Fields */
#define ENET_TDAR_TDAR_MASK                      0x1000000u
#define ENET_TDAR_TDAR_SHIFT                     24
/* ECR Bit Fields */
#define ENET_ECR_RESET_MASK                      0x1u
#define ENET_ECR_RESET_SHIFT                     0
#define ENET_ECR_ETHEREN_MASK                    0x2u
#define ENET_ECR_ETHEREN_SHIFT                   1
#define ENET_ECR_MAGICEN_MASK                    0x4u
#define ENET_ECR_MAGICEN_SHIFT                   2
#define ENET_ECR_SLEEP_MASK                      0x8u
#define ENET_ECR_SLEEP_SHIFT                     3
#define ENET_ECR_EN1588_MASK                     0x10u
#define ENET_ECR_EN1588_SHIFT                    4
#define ENET_ECR_SPEED_MASK                      0x20u
#define ENET_ECR_SPEED_SHIFT                     5
#define ENET_ECR_DBGEN_MASK                      0x40u
#define ENET_ECR_DBGEN_SHIFT                     6
#define ENET_ECR_DBSWP_MASK                      0x100u
#define ENET_ECR_DBSWP_SHIFT                     8
#define ENET_ECR_SVLANEN_MASK                    0x200u
#define ENET_ECR_SVLANEN_SHIFT                   9
#define ENET_ECR_VLANUSE2ND_MASK                 0x400u
#define ENET_ECR_VLANUSE2ND_SHIFT                10
#define ENET_ECR_SVLANDBL_MASK                   0x800u
#define ENET_ECR_SVLANDBL_SHIFT                  11
/* MMFR Bit Fields */
#define ENET_MMFR_DATA_MASK                      0xFFFFu
#define ENET_MMFR_DATA_SHIFT                     0
#define ENET_MMFR_DATA(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_DATA_SHIFT))&ENET_MMFR_DATA_MASK)
#define ENET_MMFR_TA_MASK                        0x30000u
#define ENET_MMFR_TA_SHIFT                       16
#define ENET_MMFR_TA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_TA_SHIFT))&ENET_MMFR_TA_MASK)
#define ENET_MMFR_RA_MASK                        0x7C0000u
#define ENET_MMFR_RA_SHIFT                       18
#define ENET_MMFR_RA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_RA_SHIFT))&ENET_MMFR_RA_MASK)
#define ENET_MMFR_PA_MASK                        0xF800000u
#define ENET_MMFR_PA_SHIFT                       23
#define ENET_MMFR_PA(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_PA_SHIFT))&ENET_MMFR_PA_MASK)
#define ENET_MMFR_OP_MASK                        0x30000000u
#define ENET_MMFR_OP_SHIFT                       28
#define ENET_MMFR_OP(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_OP_SHIFT))&ENET_MMFR_OP_MASK)
#define ENET_MMFR_ST_MASK                        0xC0000000u
#define ENET_MMFR_ST_SHIFT                       30
#define ENET_MMFR_ST(x)                          (((uint32_t)(((uint32_t)(x))<<ENET_MMFR_ST_SHIFT))&ENET_MMFR_ST_MASK)
/* MSCR Bit Fields */
#define ENET_MSCR_MII_SPEED_MASK                 0x7Eu
#define ENET_MSCR_MII_SPEED_SHIFT                1
#define ENET_MSCR_MII_SPEED(x)                   (((uint32_t)(((uint32_t)(x))<<ENET_MSCR_MII_SPEED_SHIFT))&ENET_MSCR_MII_SPEED_MASK)
#define ENET_MSCR_DIS_PRE_MASK                   0x80u
#define ENET_MSCR_DIS_PRE_SHIFT                  7
#define ENET_MSCR_HOLDTIME_MASK                  0x700u
#define ENET_MSCR_HOLDTIME_SHIFT                 8
#define ENET_MSCR_HOLDTIME(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_MSCR_HOLDTIME_SHIFT))&ENET_MSCR_HOLDTIME_MASK)
/* MIBC Bit Fields */
#define ENET_MIBC_MIB_CLEAR_MASK                 0x20000000u
#define ENET_MIBC_MIB_CLEAR_SHIFT                29
#define ENET_MIBC_MIB_IDLE_MASK                  0x40000000u
#define ENET_MIBC_MIB_IDLE_SHIFT                 30
#define ENET_MIBC_MIB_DIS_MASK                   0x80000000u
#define ENET_MIBC_MIB_DIS_SHIFT                  31
/* RCR Bit Fields */
#define ENET_RCR_LOOP_MASK                       0x1u
#define ENET_RCR_LOOP_SHIFT                      0
#define ENET_RCR_DRT_MASK                        0x2u
#define ENET_RCR_DRT_SHIFT                       1
#define ENET_RCR_MII_MODE_MASK                   0x4u
#define ENET_RCR_MII_MODE_SHIFT                  2
#define ENET_RCR_PROM_MASK                       0x8u
#define ENET_RCR_PROM_SHIFT                      3
#define ENET_RCR_BC_REJ_MASK                     0x10u
#define ENET_RCR_BC_REJ_SHIFT                    4
#define ENET_RCR_FCE_MASK                        0x20u
#define ENET_RCR_FCE_SHIFT                       5
#define ENET_RCR_RGMII_EN_MASK                   0x40u
#define ENET_RCR_RGMII_EN_SHIFT                  6
#define ENET_RCR_RMII_MODE_MASK                  0x100u
#define ENET_RCR_RMII_MODE_SHIFT                 8
#define ENET_RCR_RMII_10T_MASK                   0x200u
#define ENET_RCR_RMII_10T_SHIFT                  9
#define ENET_RCR_PADEN_MASK                      0x1000u
#define ENET_RCR_PADEN_SHIFT                     12
#define ENET_RCR_PAUFWD_MASK                     0x2000u
#define ENET_RCR_PAUFWD_SHIFT                    13
#define ENET_RCR_CRCFWD_MASK                     0x4000u
#define ENET_RCR_CRCFWD_SHIFT                    14
#define ENET_RCR_CFEN_MASK                       0x8000u
#define ENET_RCR_CFEN_SHIFT                      15
#define ENET_RCR_MAX_FL_MASK                     0x3FFF0000u
#define ENET_RCR_MAX_FL_SHIFT                    16
#define ENET_RCR_MAX_FL(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCR_MAX_FL_SHIFT))&ENET_RCR_MAX_FL_MASK)
#define ENET_RCR_NLC_MASK                        0x40000000u
#define ENET_RCR_NLC_SHIFT                       30
#define ENET_RCR_GRS_MASK                        0x80000000u
#define ENET_RCR_GRS_SHIFT                       31
/* TCR Bit Fields */
#define ENET_TCR_GTS_MASK                        0x1u
#define ENET_TCR_GTS_SHIFT                       0
#define ENET_TCR_FDEN_MASK                       0x4u
#define ENET_TCR_FDEN_SHIFT                      2
#define ENET_TCR_TFC_PAUSE_MASK                  0x8u
#define ENET_TCR_TFC_PAUSE_SHIFT                 3
#define ENET_TCR_RFC_PAUSE_MASK                  0x10u
#define ENET_TCR_RFC_PAUSE_SHIFT                 4
#define ENET_TCR_ADDSEL_MASK                     0xE0u
#define ENET_TCR_ADDSEL_SHIFT                    5
#define ENET_TCR_ADDSEL(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCR_ADDSEL_SHIFT))&ENET_TCR_ADDSEL_MASK)
#define ENET_TCR_ADDINS_MASK                     0x100u
#define ENET_TCR_ADDINS_SHIFT                    8
#define ENET_TCR_CRCFWD_MASK                     0x200u
#define ENET_TCR_CRCFWD_SHIFT                    9
/* PALR Bit Fields */
#define ENET_PALR_PADDR1_MASK                    0xFFFFFFFFu
#define ENET_PALR_PADDR1_SHIFT                   0
#define ENET_PALR_PADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_PALR_PADDR1_SHIFT))&ENET_PALR_PADDR1_MASK)
/* PAUR Bit Fields */
#define ENET_PAUR_TYPE_MASK                      0xFFFFu
#define ENET_PAUR_TYPE_SHIFT                     0
#define ENET_PAUR_TYPE(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_PAUR_TYPE_SHIFT))&ENET_PAUR_TYPE_MASK)
#define ENET_PAUR_PADDR2_MASK                    0xFFFF0000u
#define ENET_PAUR_PADDR2_SHIFT                   16
#define ENET_PAUR_PADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_PAUR_PADDR2_SHIFT))&ENET_PAUR_PADDR2_MASK)
/* OPD Bit Fields */
#define ENET_OPD_PAUSE_DUR_MASK                  0xFFFFu
#define ENET_OPD_PAUSE_DUR_SHIFT                 0
#define ENET_OPD_PAUSE_DUR(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_OPD_PAUSE_DUR_SHIFT))&ENET_OPD_PAUSE_DUR_MASK)
#define ENET_OPD_OPCODE_MASK                     0xFFFF0000u
#define ENET_OPD_OPCODE_SHIFT                    16
#define ENET_OPD_OPCODE(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_OPD_OPCODE_SHIFT))&ENET_OPD_OPCODE_MASK)
/* TXIC Bit Fields */
#define ENET_TXIC_ICTT_MASK                      0xFFFFu
#define ENET_TXIC_ICTT_SHIFT                     0
#define ENET_TXIC_ICTT(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TXIC_ICTT_SHIFT))&ENET_TXIC_ICTT_MASK)
#define ENET_TXIC_ICFT_MASK                      0xFF00000u
#define ENET_TXIC_ICFT_SHIFT                     20
#define ENET_TXIC_ICFT(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TXIC_ICFT_SHIFT))&ENET_TXIC_ICFT_MASK)
#define ENET_TXIC_ICCS_MASK                      0x40000000u
#define ENET_TXIC_ICCS_SHIFT                     30
#define ENET_TXIC_ICEN_MASK                      0x80000000u
#define ENET_TXIC_ICEN_SHIFT                     31
/* RXIC Bit Fields */
#define ENET_RXIC_ICTT_MASK                      0xFFFFu
#define ENET_RXIC_ICTT_SHIFT                     0
#define ENET_RXIC_ICTT(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_RXIC_ICTT_SHIFT))&ENET_RXIC_ICTT_MASK)
#define ENET_RXIC_ICFT_MASK                      0xFF00000u
#define ENET_RXIC_ICFT_SHIFT                     20
#define ENET_RXIC_ICFT(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_RXIC_ICFT_SHIFT))&ENET_RXIC_ICFT_MASK)
#define ENET_RXIC_ICCS_MASK                      0x40000000u
#define ENET_RXIC_ICCS_SHIFT                     30
#define ENET_RXIC_ICEN_MASK                      0x80000000u
#define ENET_RXIC_ICEN_SHIFT                     31
/* IAUR Bit Fields */
#define ENET_IAUR_IADDR1_MASK                    0xFFFFFFFFu
#define ENET_IAUR_IADDR1_SHIFT                   0
#define ENET_IAUR_IADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_IAUR_IADDR1_SHIFT))&ENET_IAUR_IADDR1_MASK)
/* IALR Bit Fields */
#define ENET_IALR_IADDR2_MASK                    0xFFFFFFFFu
#define ENET_IALR_IADDR2_SHIFT                   0
#define ENET_IALR_IADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_IALR_IADDR2_SHIFT))&ENET_IALR_IADDR2_MASK)
/* GAUR Bit Fields */
#define ENET_GAUR_GADDR1_MASK                    0xFFFFFFFFu
#define ENET_GAUR_GADDR1_SHIFT                   0
#define ENET_GAUR_GADDR1(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_GAUR_GADDR1_SHIFT))&ENET_GAUR_GADDR1_MASK)
/* GALR Bit Fields */
#define ENET_GALR_GADDR2_MASK                    0xFFFFFFFFu
#define ENET_GALR_GADDR2_SHIFT                   0
#define ENET_GALR_GADDR2(x)                      (((uint32_t)(((uint32_t)(x))<<ENET_GALR_GADDR2_SHIFT))&ENET_GALR_GADDR2_MASK)
/* TFWR Bit Fields */
#define ENET_TFWR_TFWR_MASK                      0x3Fu
#define ENET_TFWR_TFWR_SHIFT                     0
#define ENET_TFWR_TFWR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_TFWR_TFWR_SHIFT))&ENET_TFWR_TFWR_MASK)
#define ENET_TFWR_STRFWD_MASK                    0x100u
#define ENET_TFWR_STRFWD_SHIFT                   8
/* RDSR1 Bit Fields */
#define ENET_RDSR1_R_DES_START_MASK              0xFFFFFFF8u
#define ENET_RDSR1_R_DES_START_SHIFT             3
#define ENET_RDSR1_R_DES_START(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RDSR1_R_DES_START_SHIFT))&ENET_RDSR1_R_DES_START_MASK)
/* TDSR1 Bit Fields */
#define ENET_TDSR1_X_DES_START_MASK              0xFFFFFFF8u
#define ENET_TDSR1_X_DES_START_SHIFT             3
#define ENET_TDSR1_X_DES_START(x)                (((uint32_t)(((uint32_t)(x))<<ENET_TDSR1_X_DES_START_SHIFT))&ENET_TDSR1_X_DES_START_MASK)
/* MRBR1 Bit Fields */
#define ENET_MRBR1_R_BUF_SIZE_MASK               0x7FF0u
#define ENET_MRBR1_R_BUF_SIZE_SHIFT              4
#define ENET_MRBR1_R_BUF_SIZE(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_MRBR1_R_BUF_SIZE_SHIFT))&ENET_MRBR1_R_BUF_SIZE_MASK)
/* RDSR2 Bit Fields */
#define ENET_RDSR2_R_DES_START_MASK              0xFFFFFFF8u
#define ENET_RDSR2_R_DES_START_SHIFT             3
#define ENET_RDSR2_R_DES_START(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RDSR2_R_DES_START_SHIFT))&ENET_RDSR2_R_DES_START_MASK)
/* TDSR2 Bit Fields */
#define ENET_TDSR2_X_DES_START_MASK              0xFFFFFFF8u
#define ENET_TDSR2_X_DES_START_SHIFT             3
#define ENET_TDSR2_X_DES_START(x)                (((uint32_t)(((uint32_t)(x))<<ENET_TDSR2_X_DES_START_SHIFT))&ENET_TDSR2_X_DES_START_MASK)
/* MRBR2 Bit Fields */
#define ENET_MRBR2_R_BUF_SIZE_MASK               0x7FF0u
#define ENET_MRBR2_R_BUF_SIZE_SHIFT              4
#define ENET_MRBR2_R_BUF_SIZE(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_MRBR2_R_BUF_SIZE_SHIFT))&ENET_MRBR2_R_BUF_SIZE_MASK)
/* RDSR Bit Fields */
#define ENET_RDSR_R_DES_START_MASK               0xFFFFFFF8u
#define ENET_RDSR_R_DES_START_SHIFT              3
#define ENET_RDSR_R_DES_START(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RDSR_R_DES_START_SHIFT))&ENET_RDSR_R_DES_START_MASK)
/* TDSR Bit Fields */
#define ENET_TDSR_X_DES_START_MASK               0xFFFFFFF8u
#define ENET_TDSR_X_DES_START_SHIFT              3
#define ENET_TDSR_X_DES_START(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_TDSR_X_DES_START_SHIFT))&ENET_TDSR_X_DES_START_MASK)
/* MRBR Bit Fields */
#define ENET_MRBR_R_BUF_SIZE_MASK                0x7FF0u
#define ENET_MRBR_R_BUF_SIZE_SHIFT               4
#define ENET_MRBR_R_BUF_SIZE(x)                  (((uint32_t)(((uint32_t)(x))<<ENET_MRBR_R_BUF_SIZE_SHIFT))&ENET_MRBR_R_BUF_SIZE_MASK)
/* RSFL Bit Fields */
#define ENET_RSFL_RX_SECTION_FULL_MASK           0x3FFu
#define ENET_RSFL_RX_SECTION_FULL_SHIFT          0
#define ENET_RSFL_RX_SECTION_FULL(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RSFL_RX_SECTION_FULL_SHIFT))&ENET_RSFL_RX_SECTION_FULL_MASK)
/* RSEM Bit Fields */
#define ENET_RSEM_RX_SECTION_EMPTY_MASK          0x3FFu
#define ENET_RSEM_RX_SECTION_EMPTY_SHIFT         0
#define ENET_RSEM_RX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RSEM_RX_SECTION_EMPTY_SHIFT))&ENET_RSEM_RX_SECTION_EMPTY_MASK)
#define ENET_RSEM_STAT_SECTION_EMPTY_MASK        0x1F0000u
#define ENET_RSEM_STAT_SECTION_EMPTY_SHIFT       16
#define ENET_RSEM_STAT_SECTION_EMPTY(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RSEM_STAT_SECTION_EMPTY_SHIFT))&ENET_RSEM_STAT_SECTION_EMPTY_MASK)
/* RAEM Bit Fields */
#define ENET_RAEM_RX_ALMOST_EMPTY_MASK           0x3FFu
#define ENET_RAEM_RX_ALMOST_EMPTY_SHIFT          0
#define ENET_RAEM_RX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RAEM_RX_ALMOST_EMPTY_SHIFT))&ENET_RAEM_RX_ALMOST_EMPTY_MASK)
/* RAFL Bit Fields */
#define ENET_RAFL_RX_ALMOST_FULL_MASK            0x3FFu
#define ENET_RAFL_RX_ALMOST_FULL_SHIFT           0
#define ENET_RAFL_RX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RAFL_RX_ALMOST_FULL_SHIFT))&ENET_RAFL_RX_ALMOST_FULL_MASK)
/* TSEM Bit Fields */
#define ENET_TSEM_TX_SECTION_EMPTY_MASK          0x3FFu
#define ENET_TSEM_TX_SECTION_EMPTY_SHIFT         0
#define ENET_TSEM_TX_SECTION_EMPTY(x)            (((uint32_t)(((uint32_t)(x))<<ENET_TSEM_TX_SECTION_EMPTY_SHIFT))&ENET_TSEM_TX_SECTION_EMPTY_MASK)
/* TAEM Bit Fields */
#define ENET_TAEM_TX_ALMOST_EMPTY_MASK           0x3FFu
#define ENET_TAEM_TX_ALMOST_EMPTY_SHIFT          0
#define ENET_TAEM_TX_ALMOST_EMPTY(x)             (((uint32_t)(((uint32_t)(x))<<ENET_TAEM_TX_ALMOST_EMPTY_SHIFT))&ENET_TAEM_TX_ALMOST_EMPTY_MASK)
/* TAFL Bit Fields */
#define ENET_TAFL_TX_ALMOST_FULL_MASK            0x3FFu
#define ENET_TAFL_TX_ALMOST_FULL_SHIFT           0
#define ENET_TAFL_TX_ALMOST_FULL(x)              (((uint32_t)(((uint32_t)(x))<<ENET_TAFL_TX_ALMOST_FULL_SHIFT))&ENET_TAFL_TX_ALMOST_FULL_MASK)
/* TIPG Bit Fields */
#define ENET_TIPG_IPG_MASK                       0x1Fu
#define ENET_TIPG_IPG_SHIFT                      0
#define ENET_TIPG_IPG(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TIPG_IPG_SHIFT))&ENET_TIPG_IPG_MASK)
/* FTRL Bit Fields */
#define ENET_FTRL_TRUNC_FL_MASK                  0x3FFFu
#define ENET_FTRL_TRUNC_FL_SHIFT                 0
#define ENET_FTRL_TRUNC_FL(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_FTRL_TRUNC_FL_SHIFT))&ENET_FTRL_TRUNC_FL_MASK)
/* TACC Bit Fields */
#define ENET_TACC_SHIFT16_MASK                   0x1u
#define ENET_TACC_SHIFT16_SHIFT                  0
#define ENET_TACC_IPCHK_MASK                     0x8u
#define ENET_TACC_IPCHK_SHIFT                    3
#define ENET_TACC_PROCHK_MASK                    0x10u
#define ENET_TACC_PROCHK_SHIFT                   4
/* RACC Bit Fields */
#define ENET_RACC_PADREM_MASK                    0x1u
#define ENET_RACC_PADREM_SHIFT                   0
#define ENET_RACC_IPDIS_MASK                     0x2u
#define ENET_RACC_IPDIS_SHIFT                    1
#define ENET_RACC_PRODIS_MASK                    0x4u
#define ENET_RACC_PRODIS_SHIFT                   2
#define ENET_RACC_LINEDIS_MASK                   0x40u
#define ENET_RACC_LINEDIS_SHIFT                  6
#define ENET_RACC_SHIFT16_MASK                   0x80u
#define ENET_RACC_SHIFT16_SHIFT                  7
/* RCMR1 Bit Fields */
#define ENET_RCMR1_CMP0_MASK                     0x7u
#define ENET_RCMR1_CMP0_SHIFT                    0
#define ENET_RCMR1_CMP0(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR1_CMP0_SHIFT))&ENET_RCMR1_CMP0_MASK)
#define ENET_RCMR1_CMP1_MASK                     0x70u
#define ENET_RCMR1_CMP1_SHIFT                    4
#define ENET_RCMR1_CMP1(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR1_CMP1_SHIFT))&ENET_RCMR1_CMP1_MASK)
#define ENET_RCMR1_CMP2_MASK                     0x700u
#define ENET_RCMR1_CMP2_SHIFT                    8
#define ENET_RCMR1_CMP2(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR1_CMP2_SHIFT))&ENET_RCMR1_CMP2_MASK)
#define ENET_RCMR1_CMP3_MASK                     0x7000u
#define ENET_RCMR1_CMP3_SHIFT                    12
#define ENET_RCMR1_CMP3(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR1_CMP3_SHIFT))&ENET_RCMR1_CMP3_MASK)
#define ENET_RCMR1_MATCHEN_MASK                  0x10000u
#define ENET_RCMR1_MATCHEN_SHIFT                 16
/* RCMR2 Bit Fields */
#define ENET_RCMR2_CMP0_MASK                     0x7u
#define ENET_RCMR2_CMP0_SHIFT                    0
#define ENET_RCMR2_CMP0(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR2_CMP0_SHIFT))&ENET_RCMR2_CMP0_MASK)
#define ENET_RCMR2_CMP1_MASK                     0x70u
#define ENET_RCMR2_CMP1_SHIFT                    4
#define ENET_RCMR2_CMP1(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR2_CMP1_SHIFT))&ENET_RCMR2_CMP1_MASK)
#define ENET_RCMR2_CMP2_MASK                     0x700u
#define ENET_RCMR2_CMP2_SHIFT                    8
#define ENET_RCMR2_CMP2(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR2_CMP2_SHIFT))&ENET_RCMR2_CMP2_MASK)
#define ENET_RCMR2_CMP3_MASK                     0x7000u
#define ENET_RCMR2_CMP3_SHIFT                    12
#define ENET_RCMR2_CMP3(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_RCMR2_CMP3_SHIFT))&ENET_RCMR2_CMP3_MASK)
#define ENET_RCMR2_MATCHEN_MASK                  0x10000u
#define ENET_RCMR2_MATCHEN_SHIFT                 16
/* DMA1CFG Bit Fields */
#define ENET_DMA1CFG_IDLE_SLOPE_MASK             0xFFFFu
#define ENET_DMA1CFG_IDLE_SLOPE_SHIFT            0
#define ENET_DMA1CFG_IDLE_SLOPE(x)               (((uint32_t)(((uint32_t)(x))<<ENET_DMA1CFG_IDLE_SLOPE_SHIFT))&ENET_DMA1CFG_IDLE_SLOPE_MASK)
#define ENET_DMA1CFG_DMA_CLASS_EN_MASK           0x10000u
#define ENET_DMA1CFG_DMA_CLASS_EN_SHIFT          16
#define ENET_DMA1CFG_CALC_NOIPG_MASK             0x20000u
#define ENET_DMA1CFG_CALC_NOIPG_SHIFT            17
/* DMA2CFG Bit Fields */
#define ENET_DMA2CFG_IDLE_SLOPE_MASK             0xFFFFu
#define ENET_DMA2CFG_IDLE_SLOPE_SHIFT            0
#define ENET_DMA2CFG_IDLE_SLOPE(x)               (((uint32_t)(((uint32_t)(x))<<ENET_DMA2CFG_IDLE_SLOPE_SHIFT))&ENET_DMA2CFG_IDLE_SLOPE_MASK)
#define ENET_DMA2CFG_DMA_CLASS_EN_MASK           0x10000u
#define ENET_DMA2CFG_DMA_CLASS_EN_SHIFT          16
#define ENET_DMA2CFG_CALC_NOIPG_MASK             0x20000u
#define ENET_DMA2CFG_CALC_NOIPG_SHIFT            17
/* RDAR1 Bit Fields */
#define ENET_RDAR1_RDAR_MASK                     0x1000000u
#define ENET_RDAR1_RDAR_SHIFT                    24
/* TDAR1 Bit Fields */
#define ENET_TDAR1_TDAR_MASK                     0x1000000u
#define ENET_TDAR1_TDAR_SHIFT                    24
/* RDAR2 Bit Fields */
#define ENET_RDAR2_RDAR_MASK                     0x1000000u
#define ENET_RDAR2_RDAR_SHIFT                    24
/* TDAR2 Bit Fields */
#define ENET_TDAR2_TDAR_MASK                     0x1000000u
#define ENET_TDAR2_TDAR_SHIFT                    24
/* QOS Bit Fields */
#define ENET_QOS_TX_SCHEME_MASK                  0x7u
#define ENET_QOS_TX_SCHEME_SHIFT                 0
#define ENET_QOS_TX_SCHEME(x)                    (((uint32_t)(((uint32_t)(x))<<ENET_QOS_TX_SCHEME_SHIFT))&ENET_QOS_TX_SCHEME_MASK)
#define ENET_QOS_RX_FLUSH0_MASK                  0x8u
#define ENET_QOS_RX_FLUSH0_SHIFT                 3
#define ENET_QOS_RX_FLUSH1_MASK                  0x10u
#define ENET_QOS_RX_FLUSH1_SHIFT                 4
#define ENET_QOS_RX_FLUSH2_MASK                  0x20u
#define ENET_QOS_RX_FLUSH2_SHIFT                 5
/* RMON_T_PACKETS Bit Fields */
#define ENET_RMON_T_PACKETS_TXPKTS_MASK          0xFFFFu
#define ENET_RMON_T_PACKETS_TXPKTS_SHIFT         0
#define ENET_RMON_T_PACKETS_TXPKTS(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_PACKETS_TXPKTS_SHIFT))&ENET_RMON_T_PACKETS_TXPKTS_MASK)
/* RMON_T_BC_PKT Bit Fields */
#define ENET_RMON_T_BC_PKT_TXPKTS_MASK           0xFFFFu
#define ENET_RMON_T_BC_PKT_TXPKTS_SHIFT          0
#define ENET_RMON_T_BC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_BC_PKT_TXPKTS_SHIFT))&ENET_RMON_T_BC_PKT_TXPKTS_MASK)
/* RMON_T_MC_PKT Bit Fields */
#define ENET_RMON_T_MC_PKT_TXPKTS_MASK           0xFFFFu
#define ENET_RMON_T_MC_PKT_TXPKTS_SHIFT          0
#define ENET_RMON_T_MC_PKT_TXPKTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_MC_PKT_TXPKTS_SHIFT))&ENET_RMON_T_MC_PKT_TXPKTS_MASK)
/* RMON_T_CRC_ALIGN Bit Fields */
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT       0
#define ENET_RMON_T_CRC_ALIGN_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_CRC_ALIGN_TXPKTS_SHIFT))&ENET_RMON_T_CRC_ALIGN_TXPKTS_MASK)
/* RMON_T_UNDERSIZE Bit Fields */
#define ENET_RMON_T_UNDERSIZE_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT       0
#define ENET_RMON_T_UNDERSIZE_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_UNDERSIZE_TXPKTS_SHIFT))&ENET_RMON_T_UNDERSIZE_TXPKTS_MASK)
/* RMON_T_OVERSIZE Bit Fields */
#define ENET_RMON_T_OVERSIZE_TXPKTS_MASK         0xFFFFu
#define ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT        0
#define ENET_RMON_T_OVERSIZE_TXPKTS(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_OVERSIZE_TXPKTS_SHIFT))&ENET_RMON_T_OVERSIZE_TXPKTS_MASK)
/* RMON_T_FRAG Bit Fields */
#define ENET_RMON_T_FRAG_TXPKTS_MASK             0xFFFFu
#define ENET_RMON_T_FRAG_TXPKTS_SHIFT            0
#define ENET_RMON_T_FRAG_TXPKTS(x)               (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_FRAG_TXPKTS_SHIFT))&ENET_RMON_T_FRAG_TXPKTS_MASK)
/* RMON_T_JAB Bit Fields */
#define ENET_RMON_T_JAB_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_JAB_TXPKTS_SHIFT             0
#define ENET_RMON_T_JAB_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_JAB_TXPKTS_SHIFT))&ENET_RMON_T_JAB_TXPKTS_MASK)
/* RMON_T_COL Bit Fields */
#define ENET_RMON_T_COL_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_COL_TXPKTS_SHIFT             0
#define ENET_RMON_T_COL_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_COL_TXPKTS_SHIFT))&ENET_RMON_T_COL_TXPKTS_MASK)
/* RMON_T_P64 Bit Fields */
#define ENET_RMON_T_P64_TXPKTS_MASK              0xFFFFu
#define ENET_RMON_T_P64_TXPKTS_SHIFT             0
#define ENET_RMON_T_P64_TXPKTS(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P64_TXPKTS_SHIFT))&ENET_RMON_T_P64_TXPKTS_MASK)
/* RMON_T_P65TO127 Bit Fields */
#define ENET_RMON_T_P65TO127_TXPKTS_MASK         0xFFFFu
#define ENET_RMON_T_P65TO127_TXPKTS_SHIFT        0
#define ENET_RMON_T_P65TO127_TXPKTS(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P65TO127_TXPKTS_SHIFT))&ENET_RMON_T_P65TO127_TXPKTS_MASK)
/* RMON_T_P128TO255 Bit Fields */
#define ENET_RMON_T_P128TO255_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P128TO255_TXPKTS_SHIFT       0
#define ENET_RMON_T_P128TO255_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P128TO255_TXPKTS_SHIFT))&ENET_RMON_T_P128TO255_TXPKTS_MASK)
/* RMON_T_P256TO511 Bit Fields */
#define ENET_RMON_T_P256TO511_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P256TO511_TXPKTS_SHIFT       0
#define ENET_RMON_T_P256TO511_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P256TO511_TXPKTS_SHIFT))&ENET_RMON_T_P256TO511_TXPKTS_MASK)
/* RMON_T_P512TO1023 Bit Fields */
#define ENET_RMON_T_P512TO1023_TXPKTS_MASK       0xFFFFu
#define ENET_RMON_T_P512TO1023_TXPKTS_SHIFT      0
#define ENET_RMON_T_P512TO1023_TXPKTS(x)         (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P512TO1023_TXPKTS_SHIFT))&ENET_RMON_T_P512TO1023_TXPKTS_MASK)
/* RMON_T_P1024TO2047 Bit Fields */
#define ENET_RMON_T_P1024TO2047_TXPKTS_MASK      0xFFFFu
#define ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT     0
#define ENET_RMON_T_P1024TO2047_TXPKTS(x)        (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P1024TO2047_TXPKTS_SHIFT))&ENET_RMON_T_P1024TO2047_TXPKTS_MASK)
/* RMON_T_P_GTE2048 Bit Fields */
#define ENET_RMON_T_P_GTE2048_TXPKTS_MASK        0xFFFFu
#define ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT       0
#define ENET_RMON_T_P_GTE2048_TXPKTS(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_P_GTE2048_TXPKTS_SHIFT))&ENET_RMON_T_P_GTE2048_TXPKTS_MASK)
/* RMON_T_OCTETS Bit Fields */
#define ENET_RMON_T_OCTETS_TXOCTS_MASK           0xFFFFFFFFu
#define ENET_RMON_T_OCTETS_TXOCTS_SHIFT          0
#define ENET_RMON_T_OCTETS_TXOCTS(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_T_OCTETS_TXOCTS_SHIFT))&ENET_RMON_T_OCTETS_TXOCTS_MASK)
/* IEEE_T_FRAME_OK Bit Fields */
#define ENET_IEEE_T_FRAME_OK_COUNT_MASK          0xFFFFu
#define ENET_IEEE_T_FRAME_OK_COUNT_SHIFT         0
#define ENET_IEEE_T_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_FRAME_OK_COUNT_SHIFT))&ENET_IEEE_T_FRAME_OK_COUNT_MASK)
/* IEEE_T_1COL Bit Fields */
#define ENET_IEEE_T_1COL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_1COL_COUNT_SHIFT             0
#define ENET_IEEE_T_1COL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_1COL_COUNT_SHIFT))&ENET_IEEE_T_1COL_COUNT_MASK)
/* IEEE_T_MCOL Bit Fields */
#define ENET_IEEE_T_MCOL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_MCOL_COUNT_SHIFT             0
#define ENET_IEEE_T_MCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_MCOL_COUNT_SHIFT))&ENET_IEEE_T_MCOL_COUNT_MASK)
/* IEEE_T_DEF Bit Fields */
#define ENET_IEEE_T_DEF_COUNT_MASK               0xFFFFu
#define ENET_IEEE_T_DEF_COUNT_SHIFT              0
#define ENET_IEEE_T_DEF_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_DEF_COUNT_SHIFT))&ENET_IEEE_T_DEF_COUNT_MASK)
/* IEEE_T_LCOL Bit Fields */
#define ENET_IEEE_T_LCOL_COUNT_MASK              0xFFFFu
#define ENET_IEEE_T_LCOL_COUNT_SHIFT             0
#define ENET_IEEE_T_LCOL_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_LCOL_COUNT_SHIFT))&ENET_IEEE_T_LCOL_COUNT_MASK)
/* IEEE_T_EXCOL Bit Fields */
#define ENET_IEEE_T_EXCOL_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_EXCOL_COUNT_SHIFT            0
#define ENET_IEEE_T_EXCOL_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_EXCOL_COUNT_SHIFT))&ENET_IEEE_T_EXCOL_COUNT_MASK)
/* IEEE_T_MACERR Bit Fields */
#define ENET_IEEE_T_MACERR_COUNT_MASK            0xFFFFu
#define ENET_IEEE_T_MACERR_COUNT_SHIFT           0
#define ENET_IEEE_T_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_MACERR_COUNT_SHIFT))&ENET_IEEE_T_MACERR_COUNT_MASK)
/* IEEE_T_CSERR Bit Fields */
#define ENET_IEEE_T_CSERR_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_CSERR_COUNT_SHIFT            0
#define ENET_IEEE_T_CSERR_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_CSERR_COUNT_SHIFT))&ENET_IEEE_T_CSERR_COUNT_MASK)
/* IEEE_T_FDXFC Bit Fields */
#define ENET_IEEE_T_FDXFC_COUNT_MASK             0xFFFFu
#define ENET_IEEE_T_FDXFC_COUNT_SHIFT            0
#define ENET_IEEE_T_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_FDXFC_COUNT_SHIFT))&ENET_IEEE_T_FDXFC_COUNT_MASK)
/* IEEE_T_OCTETS_OK Bit Fields */
#define ENET_IEEE_T_OCTETS_OK_COUNT_MASK         0xFFFFFFFFu
#define ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT        0
#define ENET_IEEE_T_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_T_OCTETS_OK_COUNT_SHIFT))&ENET_IEEE_T_OCTETS_OK_COUNT_MASK)
/* RMON_R_PACKETS Bit Fields */
#define ENET_RMON_R_PACKETS_COUNT_MASK           0xFFFFu
#define ENET_RMON_R_PACKETS_COUNT_SHIFT          0
#define ENET_RMON_R_PACKETS_COUNT(x)             (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_PACKETS_COUNT_SHIFT))&ENET_RMON_R_PACKETS_COUNT_MASK)
/* RMON_R_BC_PKT Bit Fields */
#define ENET_RMON_R_BC_PKT_COUNT_MASK            0xFFFFu
#define ENET_RMON_R_BC_PKT_COUNT_SHIFT           0
#define ENET_RMON_R_BC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_BC_PKT_COUNT_SHIFT))&ENET_RMON_R_BC_PKT_COUNT_MASK)
/* RMON_R_MC_PKT Bit Fields */
#define ENET_RMON_R_MC_PKT_COUNT_MASK            0xFFFFu
#define ENET_RMON_R_MC_PKT_COUNT_SHIFT           0
#define ENET_RMON_R_MC_PKT_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_MC_PKT_COUNT_SHIFT))&ENET_RMON_R_MC_PKT_COUNT_MASK)
/* RMON_R_CRC_ALIGN Bit Fields */
#define ENET_RMON_R_CRC_ALIGN_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT        0
#define ENET_RMON_R_CRC_ALIGN_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_CRC_ALIGN_COUNT_SHIFT))&ENET_RMON_R_CRC_ALIGN_COUNT_MASK)
/* RMON_R_UNDERSIZE Bit Fields */
#define ENET_RMON_R_UNDERSIZE_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_UNDERSIZE_COUNT_SHIFT        0
#define ENET_RMON_R_UNDERSIZE_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_UNDERSIZE_COUNT_SHIFT))&ENET_RMON_R_UNDERSIZE_COUNT_MASK)
/* RMON_R_OVERSIZE Bit Fields */
#define ENET_RMON_R_OVERSIZE_COUNT_MASK          0xFFFFu
#define ENET_RMON_R_OVERSIZE_COUNT_SHIFT         0
#define ENET_RMON_R_OVERSIZE_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_OVERSIZE_COUNT_SHIFT))&ENET_RMON_R_OVERSIZE_COUNT_MASK)
/* RMON_R_FRAG Bit Fields */
#define ENET_RMON_R_FRAG_COUNT_MASK              0xFFFFu
#define ENET_RMON_R_FRAG_COUNT_SHIFT             0
#define ENET_RMON_R_FRAG_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_FRAG_COUNT_SHIFT))&ENET_RMON_R_FRAG_COUNT_MASK)
/* RMON_R_JAB Bit Fields */
#define ENET_RMON_R_JAB_COUNT_MASK               0xFFFFu
#define ENET_RMON_R_JAB_COUNT_SHIFT              0
#define ENET_RMON_R_JAB_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_JAB_COUNT_SHIFT))&ENET_RMON_R_JAB_COUNT_MASK)
/* RMON_R_P64 Bit Fields */
#define ENET_RMON_R_P64_COUNT_MASK               0xFFFFu
#define ENET_RMON_R_P64_COUNT_SHIFT              0
#define ENET_RMON_R_P64_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P64_COUNT_SHIFT))&ENET_RMON_R_P64_COUNT_MASK)
/* RMON_R_P65TO127 Bit Fields */
#define ENET_RMON_R_P65TO127_COUNT_MASK          0xFFFFu
#define ENET_RMON_R_P65TO127_COUNT_SHIFT         0
#define ENET_RMON_R_P65TO127_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P65TO127_COUNT_SHIFT))&ENET_RMON_R_P65TO127_COUNT_MASK)
/* RMON_R_P128TO255 Bit Fields */
#define ENET_RMON_R_P128TO255_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P128TO255_COUNT_SHIFT        0
#define ENET_RMON_R_P128TO255_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P128TO255_COUNT_SHIFT))&ENET_RMON_R_P128TO255_COUNT_MASK)
/* RMON_R_P256TO511 Bit Fields */
#define ENET_RMON_R_P256TO511_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P256TO511_COUNT_SHIFT        0
#define ENET_RMON_R_P256TO511_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P256TO511_COUNT_SHIFT))&ENET_RMON_R_P256TO511_COUNT_MASK)
/* RMON_R_P512TO1023 Bit Fields */
#define ENET_RMON_R_P512TO1023_COUNT_MASK        0xFFFFu
#define ENET_RMON_R_P512TO1023_COUNT_SHIFT       0
#define ENET_RMON_R_P512TO1023_COUNT(x)          (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P512TO1023_COUNT_SHIFT))&ENET_RMON_R_P512TO1023_COUNT_MASK)
/* RMON_R_P1024TO2047 Bit Fields */
#define ENET_RMON_R_P1024TO2047_COUNT_MASK       0xFFFFu
#define ENET_RMON_R_P1024TO2047_COUNT_SHIFT      0
#define ENET_RMON_R_P1024TO2047_COUNT(x)         (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P1024TO2047_COUNT_SHIFT))&ENET_RMON_R_P1024TO2047_COUNT_MASK)
/* RMON_R_P_GTE2048 Bit Fields */
#define ENET_RMON_R_P_GTE2048_COUNT_MASK         0xFFFFu
#define ENET_RMON_R_P_GTE2048_COUNT_SHIFT        0
#define ENET_RMON_R_P_GTE2048_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_P_GTE2048_COUNT_SHIFT))&ENET_RMON_R_P_GTE2048_COUNT_MASK)
/* RMON_R_OCTETS Bit Fields */
#define ENET_RMON_R_OCTETS_COUNT_MASK            0xFFFFFFFFu
#define ENET_RMON_R_OCTETS_COUNT_SHIFT           0
#define ENET_RMON_R_OCTETS_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_RMON_R_OCTETS_COUNT_SHIFT))&ENET_RMON_R_OCTETS_COUNT_MASK)
/* IEEE_R_DROP Bit Fields */
#define ENET_IEEE_R_DROP_COUNT_MASK              0xFFFFu
#define ENET_IEEE_R_DROP_COUNT_SHIFT             0
#define ENET_IEEE_R_DROP_COUNT(x)                (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_DROP_COUNT_SHIFT))&ENET_IEEE_R_DROP_COUNT_MASK)
/* IEEE_R_FRAME_OK Bit Fields */
#define ENET_IEEE_R_FRAME_OK_COUNT_MASK          0xFFFFu
#define ENET_IEEE_R_FRAME_OK_COUNT_SHIFT         0
#define ENET_IEEE_R_FRAME_OK_COUNT(x)            (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_FRAME_OK_COUNT_SHIFT))&ENET_IEEE_R_FRAME_OK_COUNT_MASK)
/* IEEE_R_CRC Bit Fields */
#define ENET_IEEE_R_CRC_COUNT_MASK               0xFFFFu
#define ENET_IEEE_R_CRC_COUNT_SHIFT              0
#define ENET_IEEE_R_CRC_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_CRC_COUNT_SHIFT))&ENET_IEEE_R_CRC_COUNT_MASK)
/* IEEE_R_ALIGN Bit Fields */
#define ENET_IEEE_R_ALIGN_COUNT_MASK             0xFFFFu
#define ENET_IEEE_R_ALIGN_COUNT_SHIFT            0
#define ENET_IEEE_R_ALIGN_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_ALIGN_COUNT_SHIFT))&ENET_IEEE_R_ALIGN_COUNT_MASK)
/* IEEE_R_MACERR Bit Fields */
#define ENET_IEEE_R_MACERR_COUNT_MASK            0xFFFFu
#define ENET_IEEE_R_MACERR_COUNT_SHIFT           0
#define ENET_IEEE_R_MACERR_COUNT(x)              (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_MACERR_COUNT_SHIFT))&ENET_IEEE_R_MACERR_COUNT_MASK)
/* IEEE_R_FDXFC Bit Fields */
#define ENET_IEEE_R_FDXFC_COUNT_MASK             0xFFFFu
#define ENET_IEEE_R_FDXFC_COUNT_SHIFT            0
#define ENET_IEEE_R_FDXFC_COUNT(x)               (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_FDXFC_COUNT_SHIFT))&ENET_IEEE_R_FDXFC_COUNT_MASK)
/* IEEE_R_OCTETS_OK Bit Fields */
#define ENET_IEEE_R_OCTETS_OK_COUNT_MASK         0xFFFFFFFFu
#define ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT        0
#define ENET_IEEE_R_OCTETS_OK_COUNT(x)           (((uint32_t)(((uint32_t)(x))<<ENET_IEEE_R_OCTETS_OK_COUNT_SHIFT))&ENET_IEEE_R_OCTETS_OK_COUNT_MASK)
/* ATCR Bit Fields */
#define ENET_ATCR_EN_MASK                        0x1u
#define ENET_ATCR_EN_SHIFT                       0
#define ENET_ATCR_OFFEN_MASK                     0x4u
#define ENET_ATCR_OFFEN_SHIFT                    2
#define ENET_ATCR_OFFRST_MASK                    0x8u
#define ENET_ATCR_OFFRST_SHIFT                   3
#define ENET_ATCR_PEREN_MASK                     0x10u
#define ENET_ATCR_PEREN_SHIFT                    4
#define ENET_ATCR_PINPER_MASK                    0x80u
#define ENET_ATCR_PINPER_SHIFT                   7
#define ENET_ATCR_RESTART_MASK                   0x200u
#define ENET_ATCR_RESTART_SHIFT                  9
#define ENET_ATCR_CAPTURE_MASK                   0x800u
#define ENET_ATCR_CAPTURE_SHIFT                  11
#define ENET_ATCR_SLAVE_MASK                     0x2000u
#define ENET_ATCR_SLAVE_SHIFT                    13
/* ATVR Bit Fields */
#define ENET_ATVR_ATIME_MASK                     0xFFFFFFFFu
#define ENET_ATVR_ATIME_SHIFT                    0
#define ENET_ATVR_ATIME(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_ATVR_ATIME_SHIFT))&ENET_ATVR_ATIME_MASK)
/* ATOFF Bit Fields */
#define ENET_ATOFF_OFFSET_MASK                   0xFFFFFFFFu
#define ENET_ATOFF_OFFSET_SHIFT                  0
#define ENET_ATOFF_OFFSET(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATOFF_OFFSET_SHIFT))&ENET_ATOFF_OFFSET_MASK)
/* ATPER Bit Fields */
#define ENET_ATPER_PERIOD_MASK                   0xFFFFFFFFu
#define ENET_ATPER_PERIOD_SHIFT                  0
#define ENET_ATPER_PERIOD(x)                     (((uint32_t)(((uint32_t)(x))<<ENET_ATPER_PERIOD_SHIFT))&ENET_ATPER_PERIOD_MASK)
/* ATCOR Bit Fields */
#define ENET_ATCOR_COR_MASK                      0x7FFFFFFFu
#define ENET_ATCOR_COR_SHIFT                     0
#define ENET_ATCOR_COR(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ATCOR_COR_SHIFT))&ENET_ATCOR_COR_MASK)
/* ATINC Bit Fields */
#define ENET_ATINC_INC_MASK                      0x7Fu
#define ENET_ATINC_INC_SHIFT                     0
#define ENET_ATINC_INC(x)                        (((uint32_t)(((uint32_t)(x))<<ENET_ATINC_INC_SHIFT))&ENET_ATINC_INC_MASK)
#define ENET_ATINC_INC_CORR_MASK                 0x7F00u
#define ENET_ATINC_INC_CORR_SHIFT                8
#define ENET_ATINC_INC_CORR(x)                   (((uint32_t)(((uint32_t)(x))<<ENET_ATINC_INC_CORR_SHIFT))&ENET_ATINC_INC_CORR_MASK)
/* ATSTMP Bit Fields */
#define ENET_ATSTMP_TIMESTAMP_MASK               0xFFFFFFFFu
#define ENET_ATSTMP_TIMESTAMP_SHIFT              0
#define ENET_ATSTMP_TIMESTAMP(x)                 (((uint32_t)(((uint32_t)(x))<<ENET_ATSTMP_TIMESTAMP_SHIFT))&ENET_ATSTMP_TIMESTAMP_MASK)
/* TGSR Bit Fields */
#define ENET_TGSR_TF0_MASK                       0x1u
#define ENET_TGSR_TF0_SHIFT                      0
#define ENET_TGSR_TF1_MASK                       0x2u
#define ENET_TGSR_TF1_SHIFT                      1
#define ENET_TGSR_TF2_MASK                       0x4u
#define ENET_TGSR_TF2_SHIFT                      2
#define ENET_TGSR_TF3_MASK                       0x8u
#define ENET_TGSR_TF3_SHIFT                      3
/* TCSR Bit Fields */
#define ENET_TCSR_TDRE_MASK                      0x1u
#define ENET_TCSR_TDRE_SHIFT                     0
#define ENET_TCSR_TMODE_MASK                     0x3Cu
#define ENET_TCSR_TMODE_SHIFT                    2
#define ENET_TCSR_TMODE(x)                       (((uint32_t)(((uint32_t)(x))<<ENET_TCSR_TMODE_SHIFT))&ENET_TCSR_TMODE_MASK)
#define ENET_TCSR_TIE_MASK                       0x40u
#define ENET_TCSR_TIE_SHIFT                      6
#define ENET_TCSR_TF_MASK                        0x80u
#define ENET_TCSR_TF_SHIFT                       7
/* TCCR Bit Fields */
#define ENET_TCCR_TCC_MASK                       0xFFFFFFFFu
#define ENET_TCCR_TCC_SHIFT                      0
#define ENET_TCCR_TCC(x)                         (((uint32_t)(((uint32_t)(x))<<ENET_TCCR_TCC_SHIFT))&ENET_TCCR_TCC_MASK)

/*!
 * @}
 */ /* end of group ENET_Register_Masks */


/* ENET - Peripheral instance base addresses */
/** Peripheral ENET1 base pointer */
#define ENET1_BASE_PTR                           ((ENET_MemMapPtr)0x42188000u)
/** Peripheral ENET2 base pointer */
#define ENET2_BASE_PTR                           ((ENET_MemMapPtr)0x421B4000u)
/** Array initializer of ENET peripheral base pointers */
#define ENET_BASE_PTRS                           { ENET1_BASE_PTR, ENET2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ENET - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Accessor_Macros ENET - Register accessor macros
 * @{
 */


/* ENET - Register instance definitions */
/* ENET1 */
#define ENET1_EIR                                ENET_EIR_REG(ENET1_BASE_PTR)
#define ENET1_EIMR                               ENET_EIMR_REG(ENET1_BASE_PTR)
#define ENET1_RDAR                               ENET_RDAR_REG(ENET1_BASE_PTR)
#define ENET1_TDAR                               ENET_TDAR_REG(ENET1_BASE_PTR)
#define ENET1_ECR                                ENET_ECR_REG(ENET1_BASE_PTR)
#define ENET1_MMFR                               ENET_MMFR_REG(ENET1_BASE_PTR)
#define ENET1_MSCR                               ENET_MSCR_REG(ENET1_BASE_PTR)
#define ENET1_MIBC                               ENET_MIBC_REG(ENET1_BASE_PTR)
#define ENET1_RCR                                ENET_RCR_REG(ENET1_BASE_PTR)
#define ENET1_TCR                                ENET_TCR_REG(ENET1_BASE_PTR)
#define ENET1_PALR                               ENET_PALR_REG(ENET1_BASE_PTR)
#define ENET1_PAUR                               ENET_PAUR_REG(ENET1_BASE_PTR)
#define ENET1_OPD                                ENET_OPD_REG(ENET1_BASE_PTR)
#define ENET1_TXIC0                              ENET_TXIC_REG(ENET1_BASE_PTR,0)
#define ENET1_TXIC1                              ENET_TXIC_REG(ENET1_BASE_PTR,1)
#define ENET1_TXIC2                              ENET_TXIC_REG(ENET1_BASE_PTR,2)
#define ENET1_RXIC0                              ENET_RXIC_REG(ENET1_BASE_PTR,0)
#define ENET1_RXIC1                              ENET_RXIC_REG(ENET1_BASE_PTR,1)
#define ENET1_RXIC2                              ENET_RXIC_REG(ENET1_BASE_PTR,2)
#define ENET1_IAUR                               ENET_IAUR_REG(ENET1_BASE_PTR)
#define ENET1_IALR                               ENET_IALR_REG(ENET1_BASE_PTR)
#define ENET1_GAUR                               ENET_GAUR_REG(ENET1_BASE_PTR)
#define ENET1_GALR                               ENET_GALR_REG(ENET1_BASE_PTR)
#define ENET1_TFWR                               ENET_TFWR_REG(ENET1_BASE_PTR)
#define ENET1_RDSR1                              ENET_RDSR1_REG(ENET1_BASE_PTR)
#define ENET1_TDSR1                              ENET_TDSR1_REG(ENET1_BASE_PTR)
#define ENET1_MRBR1                              ENET_MRBR1_REG(ENET1_BASE_PTR)
#define ENET1_RDSR2                              ENET_RDSR2_REG(ENET1_BASE_PTR)
#define ENET1_TDSR2                              ENET_TDSR2_REG(ENET1_BASE_PTR)
#define ENET1_MRBR2                              ENET_MRBR2_REG(ENET1_BASE_PTR)
#define ENET1_RDSR                               ENET_RDSR_REG(ENET1_BASE_PTR)
#define ENET1_TDSR                               ENET_TDSR_REG(ENET1_BASE_PTR)
#define ENET1_MRBR                               ENET_MRBR_REG(ENET1_BASE_PTR)
#define ENET1_RSFL                               ENET_RSFL_REG(ENET1_BASE_PTR)
#define ENET1_RSEM                               ENET_RSEM_REG(ENET1_BASE_PTR)
#define ENET1_RAEM                               ENET_RAEM_REG(ENET1_BASE_PTR)
#define ENET1_RAFL                               ENET_RAFL_REG(ENET1_BASE_PTR)
#define ENET1_TSEM                               ENET_TSEM_REG(ENET1_BASE_PTR)
#define ENET1_TAEM                               ENET_TAEM_REG(ENET1_BASE_PTR)
#define ENET1_TAFL                               ENET_TAFL_REG(ENET1_BASE_PTR)
#define ENET1_TIPG                               ENET_TIPG_REG(ENET1_BASE_PTR)
#define ENET1_FTRL                               ENET_FTRL_REG(ENET1_BASE_PTR)
#define ENET1_TACC                               ENET_TACC_REG(ENET1_BASE_PTR)
#define ENET1_RACC                               ENET_RACC_REG(ENET1_BASE_PTR)
#define ENET1_RCMR1                              ENET_RCMR1_REG(ENET1_BASE_PTR)
#define ENET1_RCMR2                              ENET_RCMR2_REG(ENET1_BASE_PTR)
#define ENET1_DMA1CFG                            ENET_DMA1CFG_REG(ENET1_BASE_PTR)
#define ENET1_DMA2CFG                            ENET_DMA2CFG_REG(ENET1_BASE_PTR)
#define ENET1_RDAR1                              ENET_RDAR1_REG(ENET1_BASE_PTR)
#define ENET1_TDAR1                              ENET_TDAR1_REG(ENET1_BASE_PTR)
#define ENET1_RDAR2                              ENET_RDAR2_REG(ENET1_BASE_PTR)
#define ENET1_TDAR2                              ENET_TDAR2_REG(ENET1_BASE_PTR)
#define ENET1_QOS                                ENET_QOS_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_PACKETS                     ENET_RMON_T_PACKETS_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_BC_PKT                      ENET_RMON_T_BC_PKT_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_MC_PKT                      ENET_RMON_T_MC_PKT_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_CRC_ALIGN                   ENET_RMON_T_CRC_ALIGN_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_UNDERSIZE                   ENET_RMON_T_UNDERSIZE_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_OVERSIZE                    ENET_RMON_T_OVERSIZE_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_FRAG                        ENET_RMON_T_FRAG_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_JAB                         ENET_RMON_T_JAB_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_COL                         ENET_RMON_T_COL_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P64                         ENET_RMON_T_P64_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P65TO127                    ENET_RMON_T_P65TO127_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P128TO255                   ENET_RMON_T_P128TO255_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P256TO511                   ENET_RMON_T_P256TO511_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P512TO1023                  ENET_RMON_T_P512TO1023_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P1024TO2047                 ENET_RMON_T_P1024TO2047_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_P_GTE2048                   ENET_RMON_T_P_GTE2048_REG(ENET1_BASE_PTR)
#define ENET1_RMON_T_OCTETS                      ENET_RMON_T_OCTETS_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_FRAME_OK                    ENET_IEEE_T_FRAME_OK_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_1COL                        ENET_IEEE_T_1COL_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_MCOL                        ENET_IEEE_T_MCOL_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_DEF                         ENET_IEEE_T_DEF_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_LCOL                        ENET_IEEE_T_LCOL_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_EXCOL                       ENET_IEEE_T_EXCOL_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_MACERR                      ENET_IEEE_T_MACERR_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_CSERR                       ENET_IEEE_T_CSERR_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_FDXFC                       ENET_IEEE_T_FDXFC_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_T_OCTETS_OK                   ENET_IEEE_T_OCTETS_OK_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_PACKETS                     ENET_RMON_R_PACKETS_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_BC_PKT                      ENET_RMON_R_BC_PKT_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_MC_PKT                      ENET_RMON_R_MC_PKT_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_CRC_ALIGN                   ENET_RMON_R_CRC_ALIGN_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_UNDERSIZE                   ENET_RMON_R_UNDERSIZE_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_OVERSIZE                    ENET_RMON_R_OVERSIZE_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_FRAG                        ENET_RMON_R_FRAG_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_JAB                         ENET_RMON_R_JAB_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P64                         ENET_RMON_R_P64_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P65TO127                    ENET_RMON_R_P65TO127_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P128TO255                   ENET_RMON_R_P128TO255_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P256TO511                   ENET_RMON_R_P256TO511_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P512TO1023                  ENET_RMON_R_P512TO1023_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P1024TO2047                 ENET_RMON_R_P1024TO2047_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_P_GTE2048                   ENET_RMON_R_P_GTE2048_REG(ENET1_BASE_PTR)
#define ENET1_RMON_R_OCTETS                      ENET_RMON_R_OCTETS_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_DROP                        ENET_IEEE_R_DROP_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_FRAME_OK                    ENET_IEEE_R_FRAME_OK_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_CRC                         ENET_IEEE_R_CRC_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_ALIGN                       ENET_IEEE_R_ALIGN_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_MACERR                      ENET_IEEE_R_MACERR_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_FDXFC                       ENET_IEEE_R_FDXFC_REG(ENET1_BASE_PTR)
#define ENET1_IEEE_R_OCTETS_OK                   ENET_IEEE_R_OCTETS_OK_REG(ENET1_BASE_PTR)
#define ENET1_ATCR                               ENET_ATCR_REG(ENET1_BASE_PTR)
#define ENET1_ATVR                               ENET_ATVR_REG(ENET1_BASE_PTR)
#define ENET1_ATOFF                              ENET_ATOFF_REG(ENET1_BASE_PTR)
#define ENET1_ATPER                              ENET_ATPER_REG(ENET1_BASE_PTR)
#define ENET1_ATCOR                              ENET_ATCOR_REG(ENET1_BASE_PTR)
#define ENET1_ATINC                              ENET_ATINC_REG(ENET1_BASE_PTR)
#define ENET1_ATSTMP                             ENET_ATSTMP_REG(ENET1_BASE_PTR)
#define ENET1_TGSR                               ENET_TGSR_REG(ENET1_BASE_PTR)
#define ENET1_TCSR0                              ENET_TCSR_REG(ENET1_BASE_PTR,0)
#define ENET1_TCCR0                              ENET_TCCR_REG(ENET1_BASE_PTR,0)
#define ENET1_TCSR1                              ENET_TCSR_REG(ENET1_BASE_PTR,1)
#define ENET1_TCCR1                              ENET_TCCR_REG(ENET1_BASE_PTR,1)
#define ENET1_TCSR2                              ENET_TCSR_REG(ENET1_BASE_PTR,2)
#define ENET1_TCCR2                              ENET_TCCR_REG(ENET1_BASE_PTR,2)
#define ENET1_TCSR3                              ENET_TCSR_REG(ENET1_BASE_PTR,3)
#define ENET1_TCCR3                              ENET_TCCR_REG(ENET1_BASE_PTR,3)
/* ENET2 */
#define ENET2_EIR                                ENET_EIR_REG(ENET2_BASE_PTR)
#define ENET2_EIMR                               ENET_EIMR_REG(ENET2_BASE_PTR)
#define ENET2_RDAR                               ENET_RDAR_REG(ENET2_BASE_PTR)
#define ENET2_TDAR                               ENET_TDAR_REG(ENET2_BASE_PTR)
#define ENET2_ECR                                ENET_ECR_REG(ENET2_BASE_PTR)
#define ENET2_MMFR                               ENET_MMFR_REG(ENET2_BASE_PTR)
#define ENET2_MSCR                               ENET_MSCR_REG(ENET2_BASE_PTR)
#define ENET2_MIBC                               ENET_MIBC_REG(ENET2_BASE_PTR)
#define ENET2_RCR                                ENET_RCR_REG(ENET2_BASE_PTR)
#define ENET2_TCR                                ENET_TCR_REG(ENET2_BASE_PTR)
#define ENET2_PALR                               ENET_PALR_REG(ENET2_BASE_PTR)
#define ENET2_PAUR                               ENET_PAUR_REG(ENET2_BASE_PTR)
#define ENET2_OPD                                ENET_OPD_REG(ENET2_BASE_PTR)
#define ENET2_TXIC0                              ENET_TXIC_REG(ENET2_BASE_PTR,0)
#define ENET2_TXIC1                              ENET_TXIC_REG(ENET2_BASE_PTR,1)
#define ENET2_TXIC2                              ENET_TXIC_REG(ENET2_BASE_PTR,2)
#define ENET2_RXIC0                              ENET_RXIC_REG(ENET2_BASE_PTR,0)
#define ENET2_RXIC1                              ENET_RXIC_REG(ENET2_BASE_PTR,1)
#define ENET2_RXIC2                              ENET_RXIC_REG(ENET2_BASE_PTR,2)
#define ENET2_IAUR                               ENET_IAUR_REG(ENET2_BASE_PTR)
#define ENET2_IALR                               ENET_IALR_REG(ENET2_BASE_PTR)
#define ENET2_GAUR                               ENET_GAUR_REG(ENET2_BASE_PTR)
#define ENET2_GALR                               ENET_GALR_REG(ENET2_BASE_PTR)
#define ENET2_TFWR                               ENET_TFWR_REG(ENET2_BASE_PTR)
#define ENET2_RDSR1                              ENET_RDSR1_REG(ENET2_BASE_PTR)
#define ENET2_TDSR1                              ENET_TDSR1_REG(ENET2_BASE_PTR)
#define ENET2_MRBR1                              ENET_MRBR1_REG(ENET2_BASE_PTR)
#define ENET2_RDSR2                              ENET_RDSR2_REG(ENET2_BASE_PTR)
#define ENET2_TDSR2                              ENET_TDSR2_REG(ENET2_BASE_PTR)
#define ENET2_MRBR2                              ENET_MRBR2_REG(ENET2_BASE_PTR)
#define ENET2_RDSR                               ENET_RDSR_REG(ENET2_BASE_PTR)
#define ENET2_TDSR                               ENET_TDSR_REG(ENET2_BASE_PTR)
#define ENET2_MRBR                               ENET_MRBR_REG(ENET2_BASE_PTR)
#define ENET2_RSFL                               ENET_RSFL_REG(ENET2_BASE_PTR)
#define ENET2_RSEM                               ENET_RSEM_REG(ENET2_BASE_PTR)
#define ENET2_RAEM                               ENET_RAEM_REG(ENET2_BASE_PTR)
#define ENET2_RAFL                               ENET_RAFL_REG(ENET2_BASE_PTR)
#define ENET2_TSEM                               ENET_TSEM_REG(ENET2_BASE_PTR)
#define ENET2_TAEM                               ENET_TAEM_REG(ENET2_BASE_PTR)
#define ENET2_TAFL                               ENET_TAFL_REG(ENET2_BASE_PTR)
#define ENET2_TIPG                               ENET_TIPG_REG(ENET2_BASE_PTR)
#define ENET2_FTRL                               ENET_FTRL_REG(ENET2_BASE_PTR)
#define ENET2_TACC                               ENET_TACC_REG(ENET2_BASE_PTR)
#define ENET2_RACC                               ENET_RACC_REG(ENET2_BASE_PTR)
#define ENET2_RCMR1                              ENET_RCMR1_REG(ENET2_BASE_PTR)
#define ENET2_RCMR2                              ENET_RCMR2_REG(ENET2_BASE_PTR)
#define ENET2_DMA1CFG                            ENET_DMA1CFG_REG(ENET2_BASE_PTR)
#define ENET2_DMA2CFG                            ENET_DMA2CFG_REG(ENET2_BASE_PTR)
#define ENET2_RDAR1                              ENET_RDAR1_REG(ENET2_BASE_PTR)
#define ENET2_TDAR1                              ENET_TDAR1_REG(ENET2_BASE_PTR)
#define ENET2_RDAR2                              ENET_RDAR2_REG(ENET2_BASE_PTR)
#define ENET2_TDAR2                              ENET_TDAR2_REG(ENET2_BASE_PTR)
#define ENET2_QOS                                ENET_QOS_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_PACKETS                     ENET_RMON_T_PACKETS_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_BC_PKT                      ENET_RMON_T_BC_PKT_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_MC_PKT                      ENET_RMON_T_MC_PKT_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_CRC_ALIGN                   ENET_RMON_T_CRC_ALIGN_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_UNDERSIZE                   ENET_RMON_T_UNDERSIZE_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_OVERSIZE                    ENET_RMON_T_OVERSIZE_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_FRAG                        ENET_RMON_T_FRAG_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_JAB                         ENET_RMON_T_JAB_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_COL                         ENET_RMON_T_COL_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P64                         ENET_RMON_T_P64_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P65TO127                    ENET_RMON_T_P65TO127_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P128TO255                   ENET_RMON_T_P128TO255_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P256TO511                   ENET_RMON_T_P256TO511_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P512TO1023                  ENET_RMON_T_P512TO1023_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P1024TO2047                 ENET_RMON_T_P1024TO2047_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_P_GTE2048                   ENET_RMON_T_P_GTE2048_REG(ENET2_BASE_PTR)
#define ENET2_RMON_T_OCTETS                      ENET_RMON_T_OCTETS_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_FRAME_OK                    ENET_IEEE_T_FRAME_OK_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_1COL                        ENET_IEEE_T_1COL_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_MCOL                        ENET_IEEE_T_MCOL_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_DEF                         ENET_IEEE_T_DEF_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_LCOL                        ENET_IEEE_T_LCOL_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_EXCOL                       ENET_IEEE_T_EXCOL_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_MACERR                      ENET_IEEE_T_MACERR_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_CSERR                       ENET_IEEE_T_CSERR_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_FDXFC                       ENET_IEEE_T_FDXFC_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_T_OCTETS_OK                   ENET_IEEE_T_OCTETS_OK_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_PACKETS                     ENET_RMON_R_PACKETS_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_BC_PKT                      ENET_RMON_R_BC_PKT_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_MC_PKT                      ENET_RMON_R_MC_PKT_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_CRC_ALIGN                   ENET_RMON_R_CRC_ALIGN_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_UNDERSIZE                   ENET_RMON_R_UNDERSIZE_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_OVERSIZE                    ENET_RMON_R_OVERSIZE_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_FRAG                        ENET_RMON_R_FRAG_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_JAB                         ENET_RMON_R_JAB_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P64                         ENET_RMON_R_P64_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P65TO127                    ENET_RMON_R_P65TO127_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P128TO255                   ENET_RMON_R_P128TO255_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P256TO511                   ENET_RMON_R_P256TO511_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P512TO1023                  ENET_RMON_R_P512TO1023_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P1024TO2047                 ENET_RMON_R_P1024TO2047_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_P_GTE2048                   ENET_RMON_R_P_GTE2048_REG(ENET2_BASE_PTR)
#define ENET2_RMON_R_OCTETS                      ENET_RMON_R_OCTETS_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_DROP                        ENET_IEEE_R_DROP_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_FRAME_OK                    ENET_IEEE_R_FRAME_OK_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_CRC                         ENET_IEEE_R_CRC_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_ALIGN                       ENET_IEEE_R_ALIGN_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_MACERR                      ENET_IEEE_R_MACERR_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_FDXFC                       ENET_IEEE_R_FDXFC_REG(ENET2_BASE_PTR)
#define ENET2_IEEE_R_OCTETS_OK                   ENET_IEEE_R_OCTETS_OK_REG(ENET2_BASE_PTR)
#define ENET2_ATCR                               ENET_ATCR_REG(ENET2_BASE_PTR)
#define ENET2_ATVR                               ENET_ATVR_REG(ENET2_BASE_PTR)
#define ENET2_ATOFF                              ENET_ATOFF_REG(ENET2_BASE_PTR)
#define ENET2_ATPER                              ENET_ATPER_REG(ENET2_BASE_PTR)
#define ENET2_ATCOR                              ENET_ATCOR_REG(ENET2_BASE_PTR)
#define ENET2_ATINC                              ENET_ATINC_REG(ENET2_BASE_PTR)
#define ENET2_ATSTMP                             ENET_ATSTMP_REG(ENET2_BASE_PTR)
#define ENET2_TGSR                               ENET_TGSR_REG(ENET2_BASE_PTR)
#define ENET2_TCSR0                              ENET_TCSR_REG(ENET2_BASE_PTR,0)
#define ENET2_TCCR0                              ENET_TCCR_REG(ENET2_BASE_PTR,0)
#define ENET2_TCSR1                              ENET_TCSR_REG(ENET2_BASE_PTR,1)
#define ENET2_TCCR1                              ENET_TCCR_REG(ENET2_BASE_PTR,1)
#define ENET2_TCSR2                              ENET_TCSR_REG(ENET2_BASE_PTR,2)
#define ENET2_TCCR2                              ENET_TCCR_REG(ENET2_BASE_PTR,2)
#define ENET2_TCSR3                              ENET_TCSR_REG(ENET2_BASE_PTR,3)
#define ENET2_TCCR3                              ENET_TCCR_REG(ENET2_BASE_PTR,3)

/* ENET - Register array accessors */
#define ENET1_TXIC(index)                        ENET_TXIC_REG(ENET1_BASE_PTR,index)
#define ENET2_TXIC(index)                        ENET_TXIC_REG(ENET2_BASE_PTR,index)
#define ENET1_RXIC(index)                        ENET_RXIC_REG(ENET1_BASE_PTR,index)
#define ENET2_RXIC(index)                        ENET_RXIC_REG(ENET2_BASE_PTR,index)
#define ENET1_TCSR(index)                        ENET_TCSR_REG(ENET1_BASE_PTR,index)
#define ENET2_TCSR(index)                        ENET_TCSR_REG(ENET2_BASE_PTR,index)
#define ENET1_TCCR(index)                        ENET_TCCR_REG(ENET1_BASE_PTR,index)
#define ENET2_TCCR(index)                        ENET_TCCR_REG(ENET2_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ENET_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ENET_Peripheral */


/* ----------------------------------------------------------------------------
   -- EPIT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EPIT_Peripheral EPIT
 * @{
 */

/** EPIT - Peripheral register structure */
typedef struct EPIT_MemMap {
  uint32_t CR;                                     /**< Control register, offset: 0x0 */
  uint32_t SR;                                     /**< Status register, offset: 0x4 */
  uint32_t LR;                                     /**< Load register, offset: 0x8 */
  uint32_t CMPR;                                   /**< Compare register, offset: 0xC */
  uint32_t CNR;                                    /**< Counter register, offset: 0x10 */
} volatile *EPIT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- EPIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EPIT_Register_Accessor_Macros EPIT - Register accessor macros
 * @{
 */


/* EPIT - Register accessors */
#define EPIT_CR_REG(base)                        ((base)->CR)
#define EPIT_SR_REG(base)                        ((base)->SR)
#define EPIT_LR_REG(base)                        ((base)->LR)
#define EPIT_CMPR_REG(base)                      ((base)->CMPR)
#define EPIT_CNR_REG(base)                       ((base)->CNR)

/*!
 * @}
 */ /* end of group EPIT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- EPIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EPIT_Register_Masks EPIT Register Masks
 * @{
 */

/* CR Bit Fields */
#define EPIT_CR_EN_MASK                          0x1u
#define EPIT_CR_EN_SHIFT                         0
#define EPIT_CR_ENMOD_MASK                       0x2u
#define EPIT_CR_ENMOD_SHIFT                      1
#define EPIT_CR_OCIEN_MASK                       0x4u
#define EPIT_CR_OCIEN_SHIFT                      2
#define EPIT_CR_RLD_MASK                         0x8u
#define EPIT_CR_RLD_SHIFT                        3
#define EPIT_CR_PRESCALAR_MASK                   0xFFF0u
#define EPIT_CR_PRESCALAR_SHIFT                  4
#define EPIT_CR_PRESCALAR(x)                     (((uint32_t)(((uint32_t)(x))<<EPIT_CR_PRESCALAR_SHIFT))&EPIT_CR_PRESCALAR_MASK)
#define EPIT_CR_SWR_MASK                         0x10000u
#define EPIT_CR_SWR_SHIFT                        16
#define EPIT_CR_IOVW_MASK                        0x20000u
#define EPIT_CR_IOVW_SHIFT                       17
#define EPIT_CR_DBGEN_MASK                       0x40000u
#define EPIT_CR_DBGEN_SHIFT                      18
#define EPIT_CR_WAITEN_MASK                      0x80000u
#define EPIT_CR_WAITEN_SHIFT                     19
#define EPIT_CR_STOPEN_MASK                      0x200000u
#define EPIT_CR_STOPEN_SHIFT                     21
#define EPIT_CR_OM_MASK                          0xC00000u
#define EPIT_CR_OM_SHIFT                         22
#define EPIT_CR_OM(x)                            (((uint32_t)(((uint32_t)(x))<<EPIT_CR_OM_SHIFT))&EPIT_CR_OM_MASK)
#define EPIT_CR_CLKSRC_MASK                      0x3000000u
#define EPIT_CR_CLKSRC_SHIFT                     24
#define EPIT_CR_CLKSRC(x)                        (((uint32_t)(((uint32_t)(x))<<EPIT_CR_CLKSRC_SHIFT))&EPIT_CR_CLKSRC_MASK)
/* SR Bit Fields */
#define EPIT_SR_OCIF_MASK                        0x1u
#define EPIT_SR_OCIF_SHIFT                       0
/* LR Bit Fields */
#define EPIT_LR_LOAD_MASK                        0xFFFFFFFFu
#define EPIT_LR_LOAD_SHIFT                       0
#define EPIT_LR_LOAD(x)                          (((uint32_t)(((uint32_t)(x))<<EPIT_LR_LOAD_SHIFT))&EPIT_LR_LOAD_MASK)
/* CMPR Bit Fields */
#define EPIT_CMPR_COMPARE_MASK                   0xFFFFFFFFu
#define EPIT_CMPR_COMPARE_SHIFT                  0
#define EPIT_CMPR_COMPARE(x)                     (((uint32_t)(((uint32_t)(x))<<EPIT_CMPR_COMPARE_SHIFT))&EPIT_CMPR_COMPARE_MASK)
/* CNR Bit Fields */
#define EPIT_CNR_COUNT_MASK                      0xFFFFFFFFu
#define EPIT_CNR_COUNT_SHIFT                     0
#define EPIT_CNR_COUNT(x)                        (((uint32_t)(((uint32_t)(x))<<EPIT_CNR_COUNT_SHIFT))&EPIT_CNR_COUNT_MASK)

/*!
 * @}
 */ /* end of group EPIT_Register_Masks */


/* EPIT - Peripheral instance base addresses */
/** Peripheral EPIT1 base pointer */
#define EPIT1_BASE_PTR                           ((EPIT_MemMapPtr)0x420D0000u)
/** Peripheral EPIT2 base pointer */
#define EPIT2_BASE_PTR                           ((EPIT_MemMapPtr)0x420D4000u)
/** Array initializer of EPIT peripheral base pointers */
#define EPIT_BASE_PTRS                           { EPIT1_BASE_PTR, EPIT2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- EPIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EPIT_Register_Accessor_Macros EPIT - Register accessor macros
 * @{
 */


/* EPIT - Register instance definitions */
/* EPIT1 */
#define EPIT1_CR                                 EPIT_CR_REG(EPIT1_BASE_PTR)
#define EPIT1_SR                                 EPIT_SR_REG(EPIT1_BASE_PTR)
#define EPIT1_LR                                 EPIT_LR_REG(EPIT1_BASE_PTR)
#define EPIT1_CMPR                               EPIT_CMPR_REG(EPIT1_BASE_PTR)
#define EPIT1_CNR                                EPIT_CNR_REG(EPIT1_BASE_PTR)
/* EPIT2 */
#define EPIT2_CR                                 EPIT_CR_REG(EPIT2_BASE_PTR)
#define EPIT2_SR                                 EPIT_SR_REG(EPIT2_BASE_PTR)
#define EPIT2_LR                                 EPIT_LR_REG(EPIT2_BASE_PTR)
#define EPIT2_CMPR                               EPIT_CMPR_REG(EPIT2_BASE_PTR)
#define EPIT2_CNR                                EPIT_CNR_REG(EPIT2_BASE_PTR)

/*!
 * @}
 */ /* end of group EPIT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group EPIT_Peripheral */


/* ----------------------------------------------------------------------------
   -- ESAI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ESAI_Peripheral ESAI
 * @{
 */

/** ESAI - Peripheral register structure */
typedef struct ESAI_MemMap {
  uint32_t ETDR;                                   /**< ESAI Transmit Data Register, offset: 0x0 */
  uint32_t ERDR;                                   /**< ESAI Receive Data Register, offset: 0x4 */
  uint32_t ECR;                                    /**< ESAI Control Register, offset: 0x8 */
  uint32_t ESR;                                    /**< ESAI Status Register, offset: 0xC */
  uint32_t TFCR;                                   /**< Transmit FIFO Configuration Register, offset: 0x10 */
  uint32_t TFSR;                                   /**< Transmit FIFO Status Register, offset: 0x14 */
  uint32_t RFCR;                                   /**< Receive FIFO Configuration Register, offset: 0x18 */
  uint32_t RFSR;                                   /**< Receive FIFO Status Register, offset: 0x1C */
  uint8_t RESERVED_0[96];
  uint32_t TX[6];                                  /**< Transmit Data Register n, array offset: 0x80, array step: 0x4 */
  uint32_t TSR;                                    /**< ESAI Transmit Slot Register, offset: 0x98 */
  uint8_t RESERVED_1[4];
  uint32_t RX[4];                                  /**< Receive Data Register n, array offset: 0xA0, array step: 0x4 */
  uint8_t RESERVED_2[28];
  uint32_t SAISR;                                  /**< Serial Audio Interface Status Register, offset: 0xCC */
  uint32_t SAICR;                                  /**< Serial Audio Interface Control Register, offset: 0xD0 */
  uint32_t TCR;                                    /**< Transmit Control Register, offset: 0xD4 */
  uint32_t TCCR;                                   /**< Transmit Clock Control Register, offset: 0xD8 */
  uint32_t RCR;                                    /**< Receive Control Register, offset: 0xDC */
  uint32_t RCCR;                                   /**< Receive Clock Control Register, offset: 0xE0 */
  uint32_t TSMA;                                   /**< Transmit Slot Mask Register A, offset: 0xE4 */
  uint32_t TSMB;                                   /**< Transmit Slot Mask Register B, offset: 0xE8 */
  uint32_t RSMA;                                   /**< Receive Slot Mask Register A, offset: 0xEC */
  uint32_t RSMB;                                   /**< Receive Slot Mask Register B, offset: 0xF0 */
  uint8_t RESERVED_3[4];
  uint32_t PRRC;                                   /**< Port C Direction Register, offset: 0xF8 */
  uint32_t PCRC;                                   /**< Port C Control Register, offset: 0xFC */
} volatile *ESAI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ESAI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ESAI_Register_Accessor_Macros ESAI - Register accessor macros
 * @{
 */


/* ESAI - Register accessors */
#define ESAI_ETDR_REG(base)                      ((base)->ETDR)
#define ESAI_ERDR_REG(base)                      ((base)->ERDR)
#define ESAI_ECR_REG(base)                       ((base)->ECR)
#define ESAI_ESR_REG(base)                       ((base)->ESR)
#define ESAI_TFCR_REG(base)                      ((base)->TFCR)
#define ESAI_TFSR_REG(base)                      ((base)->TFSR)
#define ESAI_RFCR_REG(base)                      ((base)->RFCR)
#define ESAI_RFSR_REG(base)                      ((base)->RFSR)
#define ESAI_TX_REG(base,index)                  ((base)->TX[index])
#define ESAI_TSR_REG(base)                       ((base)->TSR)
#define ESAI_RX_REG(base,index)                  ((base)->RX[index])
#define ESAI_SAISR_REG(base)                     ((base)->SAISR)
#define ESAI_SAICR_REG(base)                     ((base)->SAICR)
#define ESAI_TCR_REG(base)                       ((base)->TCR)
#define ESAI_TCCR_REG(base)                      ((base)->TCCR)
#define ESAI_RCR_REG(base)                       ((base)->RCR)
#define ESAI_RCCR_REG(base)                      ((base)->RCCR)
#define ESAI_TSMA_REG(base)                      ((base)->TSMA)
#define ESAI_TSMB_REG(base)                      ((base)->TSMB)
#define ESAI_RSMA_REG(base)                      ((base)->RSMA)
#define ESAI_RSMB_REG(base)                      ((base)->RSMB)
#define ESAI_PRRC_REG(base)                      ((base)->PRRC)
#define ESAI_PCRC_REG(base)                      ((base)->PCRC)

/*!
 * @}
 */ /* end of group ESAI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ESAI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ESAI_Register_Masks ESAI Register Masks
 * @{
 */

/* ETDR Bit Fields */
#define ESAI_ETDR_ETDR_MASK                      0xFFFFFFFFu
#define ESAI_ETDR_ETDR_SHIFT                     0
#define ESAI_ETDR_ETDR(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_ETDR_ETDR_SHIFT))&ESAI_ETDR_ETDR_MASK)
/* ERDR Bit Fields */
#define ESAI_ERDR_ERDR_MASK                      0xFFFFFFFFu
#define ESAI_ERDR_ERDR_SHIFT                     0
#define ESAI_ERDR_ERDR(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_ERDR_ERDR_SHIFT))&ESAI_ERDR_ERDR_MASK)
/* ECR Bit Fields */
#define ESAI_ECR_ESAIEN_MASK                     0x1u
#define ESAI_ECR_ESAIEN_SHIFT                    0
#define ESAI_ECR_ERST_MASK                       0x2u
#define ESAI_ECR_ERST_SHIFT                      1
#define ESAI_ECR_ERO_MASK                        0x10000u
#define ESAI_ECR_ERO_SHIFT                       16
#define ESAI_ECR_ERI_MASK                        0x20000u
#define ESAI_ECR_ERI_SHIFT                       17
#define ESAI_ECR_ETO_MASK                        0x40000u
#define ESAI_ECR_ETO_SHIFT                       18
#define ESAI_ECR_ETI_MASK                        0x80000u
#define ESAI_ECR_ETI_SHIFT                       19
/* ESR Bit Fields */
#define ESAI_ESR_RD_MASK                         0x1u
#define ESAI_ESR_RD_SHIFT                        0
#define ESAI_ESR_RED_MASK                        0x2u
#define ESAI_ESR_RED_SHIFT                       1
#define ESAI_ESR_RDE_MASK                        0x4u
#define ESAI_ESR_RDE_SHIFT                       2
#define ESAI_ESR_RLS_MASK                        0x8u
#define ESAI_ESR_RLS_SHIFT                       3
#define ESAI_ESR_TD_MASK                         0x10u
#define ESAI_ESR_TD_SHIFT                        4
#define ESAI_ESR_TED_MASK                        0x20u
#define ESAI_ESR_TED_SHIFT                       5
#define ESAI_ESR_TDE_MASK                        0x40u
#define ESAI_ESR_TDE_SHIFT                       6
#define ESAI_ESR_TLS_MASK                        0x80u
#define ESAI_ESR_TLS_SHIFT                       7
#define ESAI_ESR_TFE_MASK                        0x100u
#define ESAI_ESR_TFE_SHIFT                       8
#define ESAI_ESR_RFF_MASK                        0x200u
#define ESAI_ESR_RFF_SHIFT                       9
#define ESAI_ESR_TINIT_MASK                      0x400u
#define ESAI_ESR_TINIT_SHIFT                     10
/* TFCR Bit Fields */
#define ESAI_TFCR_TFE_MASK                       0x1u
#define ESAI_TFCR_TFE_SHIFT                      0
#define ESAI_TFCR_TFR_MASK                       0x2u
#define ESAI_TFCR_TFR_SHIFT                      1
#define ESAI_TFCR_TE0_MASK                       0x4u
#define ESAI_TFCR_TE0_SHIFT                      2
#define ESAI_TFCR_TE1_MASK                       0x8u
#define ESAI_TFCR_TE1_SHIFT                      3
#define ESAI_TFCR_TE2_MASK                       0x10u
#define ESAI_TFCR_TE2_SHIFT                      4
#define ESAI_TFCR_TE3_MASK                       0x20u
#define ESAI_TFCR_TE3_SHIFT                      5
#define ESAI_TFCR_TE4_MASK                       0x40u
#define ESAI_TFCR_TE4_SHIFT                      6
#define ESAI_TFCR_TE5_MASK                       0x80u
#define ESAI_TFCR_TE5_SHIFT                      7
#define ESAI_TFCR_TFWM_MASK                      0xFF00u
#define ESAI_TFCR_TFWM_SHIFT                     8
#define ESAI_TFCR_TFWM(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_TFCR_TFWM_SHIFT))&ESAI_TFCR_TFWM_MASK)
#define ESAI_TFCR_TWA_MASK                       0x70000u
#define ESAI_TFCR_TWA_SHIFT                      16
#define ESAI_TFCR_TWA(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TFCR_TWA_SHIFT))&ESAI_TFCR_TWA_MASK)
#define ESAI_TFCR_TIEN_MASK                      0x80000u
#define ESAI_TFCR_TIEN_SHIFT                     19
/* TFSR Bit Fields */
#define ESAI_TFSR_TFCNT_MASK                     0xFFu
#define ESAI_TFSR_TFCNT_SHIFT                    0
#define ESAI_TFSR_TFCNT(x)                       (((uint32_t)(((uint32_t)(x))<<ESAI_TFSR_TFCNT_SHIFT))&ESAI_TFSR_TFCNT_MASK)
#define ESAI_TFSR_NTFI_MASK                      0x700u
#define ESAI_TFSR_NTFI_SHIFT                     8
#define ESAI_TFSR_NTFI(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_TFSR_NTFI_SHIFT))&ESAI_TFSR_NTFI_MASK)
#define ESAI_TFSR_NTFO_MASK                      0x7000u
#define ESAI_TFSR_NTFO_SHIFT                     12
#define ESAI_TFSR_NTFO(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_TFSR_NTFO_SHIFT))&ESAI_TFSR_NTFO_MASK)
/* RFCR Bit Fields */
#define ESAI_RFCR_RFE_MASK                       0x1u
#define ESAI_RFCR_RFE_SHIFT                      0
#define ESAI_RFCR_RFR_MASK                       0x2u
#define ESAI_RFCR_RFR_SHIFT                      1
#define ESAI_RFCR_RE0_MASK                       0x4u
#define ESAI_RFCR_RE0_SHIFT                      2
#define ESAI_RFCR_RE1_MASK                       0x8u
#define ESAI_RFCR_RE1_SHIFT                      3
#define ESAI_RFCR_RE2_MASK                       0x10u
#define ESAI_RFCR_RE2_SHIFT                      4
#define ESAI_RFCR_RE3_MASK                       0x20u
#define ESAI_RFCR_RE3_SHIFT                      5
#define ESAI_RFCR_RFWM_MASK                      0xFF00u
#define ESAI_RFCR_RFWM_SHIFT                     8
#define ESAI_RFCR_RFWM(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_RFCR_RFWM_SHIFT))&ESAI_RFCR_RFWM_MASK)
#define ESAI_RFCR_RWA_MASK                       0x70000u
#define ESAI_RFCR_RWA_SHIFT                      16
#define ESAI_RFCR_RWA(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RFCR_RWA_SHIFT))&ESAI_RFCR_RWA_MASK)
#define ESAI_RFCR_REXT_MASK                      0x80000u
#define ESAI_RFCR_REXT_SHIFT                     19
/* RFSR Bit Fields */
#define ESAI_RFSR_RFCNT_MASK                     0xFFu
#define ESAI_RFSR_RFCNT_SHIFT                    0
#define ESAI_RFSR_RFCNT(x)                       (((uint32_t)(((uint32_t)(x))<<ESAI_RFSR_RFCNT_SHIFT))&ESAI_RFSR_RFCNT_MASK)
#define ESAI_RFSR_NRFO_MASK                      0x300u
#define ESAI_RFSR_NRFO_SHIFT                     8
#define ESAI_RFSR_NRFO(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_RFSR_NRFO_SHIFT))&ESAI_RFSR_NRFO_MASK)
#define ESAI_RFSR_NRFI_MASK                      0x3000u
#define ESAI_RFSR_NRFI_SHIFT                     12
#define ESAI_RFSR_NRFI(x)                        (((uint32_t)(((uint32_t)(x))<<ESAI_RFSR_NRFI_SHIFT))&ESAI_RFSR_NRFI_MASK)
/* TX Bit Fields */
#define ESAI_TX_TXn_MASK                         0xFFFFFFu
#define ESAI_TX_TXn_SHIFT                        0
#define ESAI_TX_TXn(x)                           (((uint32_t)(((uint32_t)(x))<<ESAI_TX_TXn_SHIFT))&ESAI_TX_TXn_MASK)
/* TSR Bit Fields */
#define ESAI_TSR_TSR_MASK                        0xFFFFFFu
#define ESAI_TSR_TSR_SHIFT                       0
#define ESAI_TSR_TSR(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_TSR_TSR_SHIFT))&ESAI_TSR_TSR_MASK)
/* RX Bit Fields */
#define ESAI_RX_RXn_MASK                         0xFFFFFFu
#define ESAI_RX_RXn_SHIFT                        0
#define ESAI_RX_RXn(x)                           (((uint32_t)(((uint32_t)(x))<<ESAI_RX_RXn_SHIFT))&ESAI_RX_RXn_MASK)
/* SAISR Bit Fields */
#define ESAI_SAISR_IF0_MASK                      0x1u
#define ESAI_SAISR_IF0_SHIFT                     0
#define ESAI_SAISR_IF1_MASK                      0x2u
#define ESAI_SAISR_IF1_SHIFT                     1
#define ESAI_SAISR_IF2_MASK                      0x4u
#define ESAI_SAISR_IF2_SHIFT                     2
#define ESAI_SAISR_RFS_MASK                      0x40u
#define ESAI_SAISR_RFS_SHIFT                     6
#define ESAI_SAISR_ROE_MASK                      0x80u
#define ESAI_SAISR_ROE_SHIFT                     7
#define ESAI_SAISR_RDF_MASK                      0x100u
#define ESAI_SAISR_RDF_SHIFT                     8
#define ESAI_SAISR_REDF_MASK                     0x200u
#define ESAI_SAISR_REDF_SHIFT                    9
#define ESAI_SAISR_RODF_MASK                     0x400u
#define ESAI_SAISR_RODF_SHIFT                    10
#define ESAI_SAISR_TFS_MASK                      0x2000u
#define ESAI_SAISR_TFS_SHIFT                     13
#define ESAI_SAISR_TUE_MASK                      0x4000u
#define ESAI_SAISR_TUE_SHIFT                     14
#define ESAI_SAISR_TDE_MASK                      0x8000u
#define ESAI_SAISR_TDE_SHIFT                     15
#define ESAI_SAISR_TEDE_MASK                     0x10000u
#define ESAI_SAISR_TEDE_SHIFT                    16
#define ESAI_SAISR_TODFE_MASK                    0x20000u
#define ESAI_SAISR_TODFE_SHIFT                   17
/* SAICR Bit Fields */
#define ESAI_SAICR_OF0_MASK                      0x1u
#define ESAI_SAICR_OF0_SHIFT                     0
#define ESAI_SAICR_OF1_MASK                      0x2u
#define ESAI_SAICR_OF1_SHIFT                     1
#define ESAI_SAICR_OF2_MASK                      0x4u
#define ESAI_SAICR_OF2_SHIFT                     2
#define ESAI_SAICR_SYN_MASK                      0x40u
#define ESAI_SAICR_SYN_SHIFT                     6
#define ESAI_SAICR_TEBE_MASK                     0x80u
#define ESAI_SAICR_TEBE_SHIFT                    7
#define ESAI_SAICR_ALC_MASK                      0x100u
#define ESAI_SAICR_ALC_SHIFT                     8
/* TCR Bit Fields */
#define ESAI_TCR_TE0_MASK                        0x1u
#define ESAI_TCR_TE0_SHIFT                       0
#define ESAI_TCR_TE1_MASK                        0x2u
#define ESAI_TCR_TE1_SHIFT                       1
#define ESAI_TCR_TE2_MASK                        0x4u
#define ESAI_TCR_TE2_SHIFT                       2
#define ESAI_TCR_TE3_MASK                        0x8u
#define ESAI_TCR_TE3_SHIFT                       3
#define ESAI_TCR_TE4_MASK                        0x10u
#define ESAI_TCR_TE4_SHIFT                       4
#define ESAI_TCR_TE5_MASK                        0x20u
#define ESAI_TCR_TE5_SHIFT                       5
#define ESAI_TCR_TSHFD_MASK                      0x40u
#define ESAI_TCR_TSHFD_SHIFT                     6
#define ESAI_TCR_TWA_MASK                        0x80u
#define ESAI_TCR_TWA_SHIFT                       7
#define ESAI_TCR_TMOD_MASK                       0x300u
#define ESAI_TCR_TMOD_SHIFT                      8
#define ESAI_TCR_TMOD(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TCR_TMOD_SHIFT))&ESAI_TCR_TMOD_MASK)
#define ESAI_TCR_TSWS_MASK                       0x7C00u
#define ESAI_TCR_TSWS_SHIFT                      10
#define ESAI_TCR_TSWS(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TCR_TSWS_SHIFT))&ESAI_TCR_TSWS_MASK)
#define ESAI_TCR_TFSL_MASK                       0x8000u
#define ESAI_TCR_TFSL_SHIFT                      15
#define ESAI_TCR_TFSR_MASK                       0x10000u
#define ESAI_TCR_TFSR_SHIFT                      16
#define ESAI_TCR_PADC_MASK                       0x20000u
#define ESAI_TCR_PADC_SHIFT                      17
#define ESAI_TCR_TPR_MASK                        0x80000u
#define ESAI_TCR_TPR_SHIFT                       19
#define ESAI_TCR_TEIE_MASK                       0x100000u
#define ESAI_TCR_TEIE_SHIFT                      20
#define ESAI_TCR_TEDIE_MASK                      0x200000u
#define ESAI_TCR_TEDIE_SHIFT                     21
#define ESAI_TCR_TIE_MASK                        0x400000u
#define ESAI_TCR_TIE_SHIFT                       22
#define ESAI_TCR_TLIE_MASK                       0x800000u
#define ESAI_TCR_TLIE_SHIFT                      23
/* TCCR Bit Fields */
#define ESAI_TCCR_TPM_MASK                       0xFFu
#define ESAI_TCCR_TPM_SHIFT                      0
#define ESAI_TCCR_TPM(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TCCR_TPM_SHIFT))&ESAI_TCCR_TPM_MASK)
#define ESAI_TCCR_TPSR_MASK                      0x100u
#define ESAI_TCCR_TPSR_SHIFT                     8
#define ESAI_TCCR_TDC_MASK                       0x3E00u
#define ESAI_TCCR_TDC_SHIFT                      9
#define ESAI_TCCR_TDC(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TCCR_TDC_SHIFT))&ESAI_TCCR_TDC_MASK)
#define ESAI_TCCR_TFP_MASK                       0x3C000u
#define ESAI_TCCR_TFP_SHIFT                      14
#define ESAI_TCCR_TFP(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_TCCR_TFP_SHIFT))&ESAI_TCCR_TFP_MASK)
#define ESAI_TCCR_TCKP_MASK                      0x40000u
#define ESAI_TCCR_TCKP_SHIFT                     18
#define ESAI_TCCR_TFSP_MASK                      0x80000u
#define ESAI_TCCR_TFSP_SHIFT                     19
#define ESAI_TCCR_THCKP_MASK                     0x100000u
#define ESAI_TCCR_THCKP_SHIFT                    20
#define ESAI_TCCR_TCKD_MASK                      0x200000u
#define ESAI_TCCR_TCKD_SHIFT                     21
#define ESAI_TCCR_TFSD_MASK                      0x400000u
#define ESAI_TCCR_TFSD_SHIFT                     22
#define ESAI_TCCR_THCKD_MASK                     0x800000u
#define ESAI_TCCR_THCKD_SHIFT                    23
/* RCR Bit Fields */
#define ESAI_RCR_RE0_MASK                        0x1u
#define ESAI_RCR_RE0_SHIFT                       0
#define ESAI_RCR_RE1_MASK                        0x2u
#define ESAI_RCR_RE1_SHIFT                       1
#define ESAI_RCR_RE2_MASK                        0x4u
#define ESAI_RCR_RE2_SHIFT                       2
#define ESAI_RCR_RE3_MASK                        0x8u
#define ESAI_RCR_RE3_SHIFT                       3
#define ESAI_RCR_RSHFD_MASK                      0x40u
#define ESAI_RCR_RSHFD_SHIFT                     6
#define ESAI_RCR_RWA_MASK                        0x80u
#define ESAI_RCR_RWA_SHIFT                       7
#define ESAI_RCR_RMOD_MASK                       0x300u
#define ESAI_RCR_RMOD_SHIFT                      8
#define ESAI_RCR_RMOD(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RCR_RMOD_SHIFT))&ESAI_RCR_RMOD_MASK)
#define ESAI_RCR_RSWS_MASK                       0x7C00u
#define ESAI_RCR_RSWS_SHIFT                      10
#define ESAI_RCR_RSWS(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RCR_RSWS_SHIFT))&ESAI_RCR_RSWS_MASK)
#define ESAI_RCR_RFSL_MASK                       0x8000u
#define ESAI_RCR_RFSL_SHIFT                      15
#define ESAI_RCR_RFSR_MASK                       0x10000u
#define ESAI_RCR_RFSR_SHIFT                      16
#define ESAI_RCR_RPR_MASK                        0x80000u
#define ESAI_RCR_RPR_SHIFT                       19
#define ESAI_RCR_REIE_MASK                       0x100000u
#define ESAI_RCR_REIE_SHIFT                      20
#define ESAI_RCR_REDIE_MASK                      0x200000u
#define ESAI_RCR_REDIE_SHIFT                     21
#define ESAI_RCR_RIE_MASK                        0x400000u
#define ESAI_RCR_RIE_SHIFT                       22
#define ESAI_RCR_RLIE_MASK                       0x800000u
#define ESAI_RCR_RLIE_SHIFT                      23
/* RCCR Bit Fields */
#define ESAI_RCCR_RPM_MASK                       0xFFu
#define ESAI_RCCR_RPM_SHIFT                      0
#define ESAI_RCCR_RPM(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RCCR_RPM_SHIFT))&ESAI_RCCR_RPM_MASK)
#define ESAI_RCCR_RPSR_MASK                      0x100u
#define ESAI_RCCR_RPSR_SHIFT                     8
#define ESAI_RCCR_RDC_MASK                       0x3E00u
#define ESAI_RCCR_RDC_SHIFT                      9
#define ESAI_RCCR_RDC(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RCCR_RDC_SHIFT))&ESAI_RCCR_RDC_MASK)
#define ESAI_RCCR_RFP_MASK                       0x3C000u
#define ESAI_RCCR_RFP_SHIFT                      14
#define ESAI_RCCR_RFP(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_RCCR_RFP_SHIFT))&ESAI_RCCR_RFP_MASK)
#define ESAI_RCCR_RCKP_MASK                      0x40000u
#define ESAI_RCCR_RCKP_SHIFT                     18
#define ESAI_RCCR_RFSP_MASK                      0x80000u
#define ESAI_RCCR_RFSP_SHIFT                     19
#define ESAI_RCCR_RHCKP_MASK                     0x100000u
#define ESAI_RCCR_RHCKP_SHIFT                    20
#define ESAI_RCCR_RCKD_MASK                      0x200000u
#define ESAI_RCCR_RCKD_SHIFT                     21
#define ESAI_RCCR_RFSD_MASK                      0x400000u
#define ESAI_RCCR_RFSD_SHIFT                     22
#define ESAI_RCCR_RHCKD_MASK                     0x800000u
#define ESAI_RCCR_RHCKD_SHIFT                    23
/* TSMA Bit Fields */
#define ESAI_TSMA_TS_MASK                        0xFFFFu
#define ESAI_TSMA_TS_SHIFT                       0
#define ESAI_TSMA_TS(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_TSMA_TS_SHIFT))&ESAI_TSMA_TS_MASK)
/* TSMB Bit Fields */
#define ESAI_TSMB_TS_MASK                        0xFFFFu
#define ESAI_TSMB_TS_SHIFT                       0
#define ESAI_TSMB_TS(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_TSMB_TS_SHIFT))&ESAI_TSMB_TS_MASK)
/* RSMA Bit Fields */
#define ESAI_RSMA_RS_MASK                        0xFFFFu
#define ESAI_RSMA_RS_SHIFT                       0
#define ESAI_RSMA_RS(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_RSMA_RS_SHIFT))&ESAI_RSMA_RS_MASK)
/* RSMB Bit Fields */
#define ESAI_RSMB_RS_MASK                        0xFFFFu
#define ESAI_RSMB_RS_SHIFT                       0
#define ESAI_RSMB_RS(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_RSMB_RS_SHIFT))&ESAI_RSMB_RS_MASK)
/* PRRC Bit Fields */
#define ESAI_PRRC_PDC_MASK                       0xFFFu
#define ESAI_PRRC_PDC_SHIFT                      0
#define ESAI_PRRC_PDC(x)                         (((uint32_t)(((uint32_t)(x))<<ESAI_PRRC_PDC_SHIFT))&ESAI_PRRC_PDC_MASK)
/* PCRC Bit Fields */
#define ESAI_PCRC_PC_MASK                        0xFFFu
#define ESAI_PCRC_PC_SHIFT                       0
#define ESAI_PCRC_PC(x)                          (((uint32_t)(((uint32_t)(x))<<ESAI_PCRC_PC_SHIFT))&ESAI_PCRC_PC_MASK)

/*!
 * @}
 */ /* end of group ESAI_Register_Masks */


/* ESAI - Peripheral instance base addresses */
/** Peripheral ESAI base pointer */
#define ESAI_BASE_PTR                            ((ESAI_MemMapPtr)0x42024000u)
/** Array initializer of ESAI peripheral base pointers */
#define ESAI_BASE_PTRS                           { ESAI_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ESAI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ESAI_Register_Accessor_Macros ESAI - Register accessor macros
 * @{
 */


/* ESAI - Register instance definitions */
/* ESAI */
#define ESAI_ETDR                                ESAI_ETDR_REG(ESAI_BASE_PTR)
#define ESAI_ERDR                                ESAI_ERDR_REG(ESAI_BASE_PTR)
#define ESAI_ECR                                 ESAI_ECR_REG(ESAI_BASE_PTR)
#define ESAI_ESR                                 ESAI_ESR_REG(ESAI_BASE_PTR)
#define ESAI_TFCR                                ESAI_TFCR_REG(ESAI_BASE_PTR)
#define ESAI_TFSR                                ESAI_TFSR_REG(ESAI_BASE_PTR)
#define ESAI_RFCR                                ESAI_RFCR_REG(ESAI_BASE_PTR)
#define ESAI_RFSR                                ESAI_RFSR_REG(ESAI_BASE_PTR)
#define ESAI_TX0                                 ESAI_TX_REG(ESAI_BASE_PTR,0)
#define ESAI_TX1                                 ESAI_TX_REG(ESAI_BASE_PTR,1)
#define ESAI_TX2                                 ESAI_TX_REG(ESAI_BASE_PTR,2)
#define ESAI_TX3                                 ESAI_TX_REG(ESAI_BASE_PTR,3)
#define ESAI_TX4                                 ESAI_TX_REG(ESAI_BASE_PTR,4)
#define ESAI_TX5                                 ESAI_TX_REG(ESAI_BASE_PTR,5)
#define ESAI_TSR                                 ESAI_TSR_REG(ESAI_BASE_PTR)
#define ESAI_RX0                                 ESAI_RX_REG(ESAI_BASE_PTR,0)
#define ESAI_RX1                                 ESAI_RX_REG(ESAI_BASE_PTR,1)
#define ESAI_RX2                                 ESAI_RX_REG(ESAI_BASE_PTR,2)
#define ESAI_RX3                                 ESAI_RX_REG(ESAI_BASE_PTR,3)
#define ESAI_SAISR                               ESAI_SAISR_REG(ESAI_BASE_PTR)
#define ESAI_SAICR                               ESAI_SAICR_REG(ESAI_BASE_PTR)
#define ESAI_TCR                                 ESAI_TCR_REG(ESAI_BASE_PTR)
#define ESAI_TCCR                                ESAI_TCCR_REG(ESAI_BASE_PTR)
#define ESAI_RCR                                 ESAI_RCR_REG(ESAI_BASE_PTR)
#define ESAI_RCCR                                ESAI_RCCR_REG(ESAI_BASE_PTR)
#define ESAI_TSMA                                ESAI_TSMA_REG(ESAI_BASE_PTR)
#define ESAI_TSMB                                ESAI_TSMB_REG(ESAI_BASE_PTR)
#define ESAI_RSMA                                ESAI_RSMA_REG(ESAI_BASE_PTR)
#define ESAI_RSMB                                ESAI_RSMB_REG(ESAI_BASE_PTR)
#define ESAI_PRRC                                ESAI_PRRC_REG(ESAI_BASE_PTR)
#define ESAI_PCRC                                ESAI_PCRC_REG(ESAI_BASE_PTR)

/* ESAI - Register array accessors */
#define ESAI_TX(index)                           ESAI_TX_REG(ESAI_BASE_PTR,index)
#define ESAI_RX(index)                           ESAI_RX_REG(ESAI_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ESAI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ESAI_Peripheral */


/* ----------------------------------------------------------------------------
   -- ETB
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETB_Peripheral ETB
 * @{
 */

/** ETB - Peripheral register structure */
typedef struct ETB_MemMap {
  uint8_t RESERVED_0[4];
  uint32_t RDP;                                    /**< RAM Depth Register, offset: 0x4 */
  uint8_t RESERVED_1[4];
  uint32_t STS;                                    /**< Status Register, offset: 0xC */
  uint32_t RRD;                                    /**< RAM Read Data Register, offset: 0x10 */
  uint32_t RRP;                                    /**< RAM Read Pointer Register, offset: 0x14 */
  uint32_t RWP;                                    /**< RAM Write Pointer Register, offset: 0x18 */
  uint32_t TRG;                                    /**< Trigger Counter Register, offset: 0x1C */
  uint32_t CTL;                                    /**< Control Register, offset: 0x20 */
  uint32_t RWD;                                    /**< RAM Write Data Register, offset: 0x24 */
  uint8_t RESERVED_2[728];
  uint32_t FFSR;                                   /**< Formatter and Flush Status Register, offset: 0x300 */
  uint32_t FFCR;                                   /**< Formatter and Flush Control Register, offset: 0x304 */
  uint8_t RESERVED_3[3032];
  uint32_t ITMISCOP0;                              /**< Integration Register, ITMISCOP0, offset: 0xEE0 */
  uint32_t ITTRFLINACK;                            /**< Integration Register, ITTRFLINACK, offset: 0xEE4 */
  uint32_t ITTRFLIN;                               /**< Integration Register, ITTRFLIN, offset: 0xEE8 */
  uint32_t ITATBDATA0;                             /**< Integration Register, ITATBDATA0, offset: 0xEEC */
  uint32_t ITATBCTR2;                              /**< Integration Register, ITATBCTR2, offset: 0xEF0 */
  uint32_t ITATBCTR1;                              /**< Integration Register, ITATBCTR1, offset: 0xEF4 */
  uint32_t ITATBCTR0;                              /**< Integration Register, ITATBCTR0, offset: 0xEF8 */
  uint8_t RESERVED_4[4];
  uint32_t ITCTRL;                                 /**< Integration Mode Control Register, offset: 0xF00 */
  uint8_t RESERVED_5[156];
  uint32_t CLAIMSET;                               /**< Claim Tag Set Register, offset: 0xFA0 */
  uint32_t CLAIMCLR;                               /**< Claim Tag Clear Register, offset: 0xFA4 */
  uint8_t RESERVED_6[8];
  uint32_t LAR;                                    /**< Lock Access Register, offset: 0xFB0 */
  uint32_t LSR;                                    /**< Lock Status Register, offset: 0xFB4 */
  uint32_t AUTHSTATUS;                             /**< Authentication Status Register, offset: 0xFB8 */
  uint8_t RESERVED_7[12];
  uint32_t DEVID;                                  /**< Device ID Register, offset: 0xFC8 */
  uint32_t DEVTYPE;                                /**< Device Type Identifier Register, offset: 0xFCC */
  uint32_t PIDR4;                                  /**< Peripheral Identification Register 4, offset: 0xFD0 */
  uint32_t PIDR5;                                  /**< Peripheral Identification Register 5, offset: 0xFD4 */
  uint32_t PIDR6;                                  /**< Peripheral Identification Register 6, offset: 0xFD8 */
  uint32_t PIDR7;                                  /**< Peripheral Identification Register 7, offset: 0xFDC */
  uint32_t PIDR0;                                  /**< Peripheral Identification Register 0, offset: 0xFE0 */
  uint32_t PIDR1;                                  /**< Peripheral Identification Register 1, offset: 0xFE4 */
  uint32_t PIDR2;                                  /**< Peripheral Identification Register 2, offset: 0xFE8 */
  uint32_t PIDR3;                                  /**< Peripheral Identification Register 3, offset: 0xFEC */
  uint32_t CIDR0;                                  /**< Component Identification Register 0, offset: 0xFF0 */
  uint32_t CIDR1;                                  /**< Component Identification Register 1, offset: 0xFF4 */
  uint32_t CIDR2;                                  /**< Component Identification Register 2, offset: 0xFF8 */
  uint32_t CIDR3;                                  /**< Component Identification Register 3, offset: 0xFFC */
} volatile *ETB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ETB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETB_Register_Accessor_Macros ETB - Register accessor macros
 * @{
 */


/* ETB - Register accessors */
#define ETB_RDP_REG(base)                        ((base)->RDP)
#define ETB_STS_REG(base)                        ((base)->STS)
#define ETB_RRD_REG(base)                        ((base)->RRD)
#define ETB_RRP_REG(base)                        ((base)->RRP)
#define ETB_RWP_REG(base)                        ((base)->RWP)
#define ETB_TRG_REG(base)                        ((base)->TRG)
#define ETB_CTL_REG(base)                        ((base)->CTL)
#define ETB_RWD_REG(base)                        ((base)->RWD)
#define ETB_FFSR_REG(base)                       ((base)->FFSR)
#define ETB_FFCR_REG(base)                       ((base)->FFCR)
#define ETB_ITMISCOP0_REG(base)                  ((base)->ITMISCOP0)
#define ETB_ITTRFLINACK_REG(base)                ((base)->ITTRFLINACK)
#define ETB_ITTRFLIN_REG(base)                   ((base)->ITTRFLIN)
#define ETB_ITATBDATA0_REG(base)                 ((base)->ITATBDATA0)
#define ETB_ITATBCTR2_REG(base)                  ((base)->ITATBCTR2)
#define ETB_ITATBCTR1_REG(base)                  ((base)->ITATBCTR1)
#define ETB_ITATBCTR0_REG(base)                  ((base)->ITATBCTR0)
#define ETB_ITCTRL_REG(base)                     ((base)->ITCTRL)
#define ETB_CLAIMSET_REG(base)                   ((base)->CLAIMSET)
#define ETB_CLAIMCLR_REG(base)                   ((base)->CLAIMCLR)
#define ETB_LAR_REG(base)                        ((base)->LAR)
#define ETB_LSR_REG(base)                        ((base)->LSR)
#define ETB_AUTHSTATUS_REG(base)                 ((base)->AUTHSTATUS)
#define ETB_DEVID_REG(base)                      ((base)->DEVID)
#define ETB_DEVTYPE_REG(base)                    ((base)->DEVTYPE)
#define ETB_PIDR4_REG(base)                      ((base)->PIDR4)
#define ETB_PIDR5_REG(base)                      ((base)->PIDR5)
#define ETB_PIDR6_REG(base)                      ((base)->PIDR6)
#define ETB_PIDR7_REG(base)                      ((base)->PIDR7)
#define ETB_PIDR0_REG(base)                      ((base)->PIDR0)
#define ETB_PIDR1_REG(base)                      ((base)->PIDR1)
#define ETB_PIDR2_REG(base)                      ((base)->PIDR2)
#define ETB_PIDR3_REG(base)                      ((base)->PIDR3)
#define ETB_CIDR0_REG(base)                      ((base)->CIDR0)
#define ETB_CIDR1_REG(base)                      ((base)->CIDR1)
#define ETB_CIDR2_REG(base)                      ((base)->CIDR2)
#define ETB_CIDR3_REG(base)                      ((base)->CIDR3)

/*!
 * @}
 */ /* end of group ETB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ETB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETB_Register_Masks ETB Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group ETB_Register_Masks */


/* ETB - Peripheral instance base addresses */
/** Peripheral ETB base pointer */
#define ETB_BASE_PTR                             ((ETB_MemMapPtr)0xE0042000u)
/** Array initializer of ETB peripheral base pointers */
#define ETB_BASE_PTRS                            { ETB_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ETB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETB_Register_Accessor_Macros ETB - Register accessor macros
 * @{
 */


/* ETB - Register instance definitions */
/* ETB */
#define ETB_RDP                                  ETB_RDP_REG(ETB_BASE_PTR)
#define ETB_STS                                  ETB_STS_REG(ETB_BASE_PTR)
#define ETB_RRD                                  ETB_RRD_REG(ETB_BASE_PTR)
#define ETB_RRP                                  ETB_RRP_REG(ETB_BASE_PTR)
#define ETB_RWP                                  ETB_RWP_REG(ETB_BASE_PTR)
#define ETB_TRG                                  ETB_TRG_REG(ETB_BASE_PTR)
#define ETB_CTL                                  ETB_CTL_REG(ETB_BASE_PTR)
#define ETB_RWD                                  ETB_RWD_REG(ETB_BASE_PTR)
#define ETB_FFSR                                 ETB_FFSR_REG(ETB_BASE_PTR)
#define ETB_FFCR                                 ETB_FFCR_REG(ETB_BASE_PTR)
#define ETB_ITMISCOP0                            ETB_ITMISCOP0_REG(ETB_BASE_PTR)
#define ETB_ITTRFLINACK                          ETB_ITTRFLINACK_REG(ETB_BASE_PTR)
#define ETB_ITTRFLIN                             ETB_ITTRFLIN_REG(ETB_BASE_PTR)
#define ETB_ITATBDATA0                           ETB_ITATBDATA0_REG(ETB_BASE_PTR)
#define ETB_ITATBCTR2                            ETB_ITATBCTR2_REG(ETB_BASE_PTR)
#define ETB_ITATBCTR1                            ETB_ITATBCTR1_REG(ETB_BASE_PTR)
#define ETB_ITATBCTR0                            ETB_ITATBCTR0_REG(ETB_BASE_PTR)
#define ETB_ITCTRL                               ETB_ITCTRL_REG(ETB_BASE_PTR)
#define ETB_CLAIMSET                             ETB_CLAIMSET_REG(ETB_BASE_PTR)
#define ETB_CLAIMCLR                             ETB_CLAIMCLR_REG(ETB_BASE_PTR)
#define ETB_LAR                                  ETB_LAR_REG(ETB_BASE_PTR)
#define ETB_LSR                                  ETB_LSR_REG(ETB_BASE_PTR)
#define ETB_AUTHSTATUS                           ETB_AUTHSTATUS_REG(ETB_BASE_PTR)
#define ETB_DEVID                                ETB_DEVID_REG(ETB_BASE_PTR)
#define ETB_DEVTYPE                              ETB_DEVTYPE_REG(ETB_BASE_PTR)
#define ETB_PIDR4                                ETB_PIDR4_REG(ETB_BASE_PTR)
#define ETB_PIDR5                                ETB_PIDR5_REG(ETB_BASE_PTR)
#define ETB_PIDR6                                ETB_PIDR6_REG(ETB_BASE_PTR)
#define ETB_PIDR7                                ETB_PIDR7_REG(ETB_BASE_PTR)
#define ETB_PIDR0                                ETB_PIDR0_REG(ETB_BASE_PTR)
#define ETB_PIDR1                                ETB_PIDR1_REG(ETB_BASE_PTR)
#define ETB_PIDR2                                ETB_PIDR2_REG(ETB_BASE_PTR)
#define ETB_PIDR3                                ETB_PIDR3_REG(ETB_BASE_PTR)
#define ETB_CIDR0                                ETB_CIDR0_REG(ETB_BASE_PTR)
#define ETB_CIDR1                                ETB_CIDR1_REG(ETB_BASE_PTR)
#define ETB_CIDR2                                ETB_CIDR2_REG(ETB_BASE_PTR)
#define ETB_CIDR3                                ETB_CIDR3_REG(ETB_BASE_PTR)

/*!
 * @}
 */ /* end of group ETB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ETB_Peripheral */


/* ----------------------------------------------------------------------------
   -- ETF
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETF_Peripheral ETF
 * @{
 */

/** ETF - Peripheral register structure */
typedef struct ETF_MemMap {
  uint32_t FCR;                                    /**< Funnel Control Register, offset: 0x0 */
  uint32_t PCR;                                    /**< Priority Control Register, offset: 0x4 */
  uint8_t RESERVED_0[3812];
  uint32_t ITATBDATA0;                             /**< Integration Register, ITATBDATA0, offset: 0xEEC */
  uint32_t ITATBCTR2;                              /**< Integration Register, ITATBCTR2, offset: 0xEF0 */
  uint32_t ITATBCTR1;                              /**< Integration Register, ITATBCTR1, offset: 0xEF4 */
  uint32_t ITATBCTR0;                              /**< Integration Register, ITATBCTR0, offset: 0xEF8 */
  uint8_t RESERVED_1[4];
  uint32_t ITCTRL;                                 /**< Integration Mode Control Register, offset: 0xF00 */
  uint8_t RESERVED_2[156];
  uint32_t CLAIMSET;                               /**< Claim Tag Set Register, offset: 0xFA0 */
  uint32_t CLAIMCLR;                               /**< Claim Tag Clear Register, offset: 0xFA4 */
  uint8_t RESERVED_3[8];
  uint32_t LAR;                                    /**< Lock Access Register, offset: 0xFB0 */
  uint32_t LSR;                                    /**< Lock Status Register, offset: 0xFB4 */
  uint32_t AUTHSTATUS;                             /**< Authentication Status Register, offset: 0xFB8 */
  uint8_t RESERVED_4[12];
  uint32_t DEVID;                                  /**< Device ID Register, offset: 0xFC8 */
  uint32_t DEVTYPE;                                /**< Device Type Identifier Register, offset: 0xFCC */
  uint32_t PIDR4;                                  /**< Peripheral Identification Register 4, offset: 0xFD0 */
  uint32_t PIDR5;                                  /**< Peripheral Identification Register 5, offset: 0xFD4 */
  uint32_t PIDR6;                                  /**< Peripheral Identification Register 6, offset: 0xFD8 */
  uint32_t PIDR7;                                  /**< Peripheral Identification Register 7, offset: 0xFDC */
  uint32_t PIDR0;                                  /**< Peripheral Identification Register 0, offset: 0xFE0 */
  uint32_t PIDR1;                                  /**< Peripheral Identification Register 1, offset: 0xFE4 */
  uint32_t PIDR2;                                  /**< Peripheral Identification Register 2, offset: 0xFE8 */
  uint32_t PIDR3;                                  /**< Peripheral Identification Register 3, offset: 0xFEC */
  uint32_t CIDR0;                                  /**< Component Identification Register 0, offset: 0xFF0 */
  uint32_t CIDR1;                                  /**< Component Identification Register 1, offset: 0xFF4 */
  uint32_t CIDR2;                                  /**< Component Identification Register 2, offset: 0xFF8 */
  uint32_t CIDR3;                                  /**< Component Identification Register 3, offset: 0xFFC */
} volatile *ETF_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ETF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETF_Register_Accessor_Macros ETF - Register accessor macros
 * @{
 */


/* ETF - Register accessors */
#define ETF_FCR_REG(base)                        ((base)->FCR)
#define ETF_PCR_REG(base)                        ((base)->PCR)
#define ETF_ITATBDATA0_REG(base)                 ((base)->ITATBDATA0)
#define ETF_ITATBCTR2_REG(base)                  ((base)->ITATBCTR2)
#define ETF_ITATBCTR1_REG(base)                  ((base)->ITATBCTR1)
#define ETF_ITATBCTR0_REG(base)                  ((base)->ITATBCTR0)
#define ETF_ITCTRL_REG(base)                     ((base)->ITCTRL)
#define ETF_CLAIMSET_REG(base)                   ((base)->CLAIMSET)
#define ETF_CLAIMCLR_REG(base)                   ((base)->CLAIMCLR)
#define ETF_LAR_REG(base)                        ((base)->LAR)
#define ETF_LSR_REG(base)                        ((base)->LSR)
#define ETF_AUTHSTATUS_REG(base)                 ((base)->AUTHSTATUS)
#define ETF_DEVID_REG(base)                      ((base)->DEVID)
#define ETF_DEVTYPE_REG(base)                    ((base)->DEVTYPE)
#define ETF_PIDR4_REG(base)                      ((base)->PIDR4)
#define ETF_PIDR5_REG(base)                      ((base)->PIDR5)
#define ETF_PIDR6_REG(base)                      ((base)->PIDR6)
#define ETF_PIDR7_REG(base)                      ((base)->PIDR7)
#define ETF_PIDR0_REG(base)                      ((base)->PIDR0)
#define ETF_PIDR1_REG(base)                      ((base)->PIDR1)
#define ETF_PIDR2_REG(base)                      ((base)->PIDR2)
#define ETF_PIDR3_REG(base)                      ((base)->PIDR3)
#define ETF_CIDR0_REG(base)                      ((base)->CIDR0)
#define ETF_CIDR1_REG(base)                      ((base)->CIDR1)
#define ETF_CIDR2_REG(base)                      ((base)->CIDR2)
#define ETF_CIDR3_REG(base)                      ((base)->CIDR3)

/*!
 * @}
 */ /* end of group ETF_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ETF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETF_Register_Masks ETF Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group ETF_Register_Masks */


/* ETF - Peripheral instance base addresses */
/** Peripheral ETF base pointer */
#define ETF_BASE_PTR                             ((ETF_MemMapPtr)0xE0043000u)
/** Array initializer of ETF peripheral base pointers */
#define ETF_BASE_PTRS                            { ETF_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ETF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETF_Register_Accessor_Macros ETF - Register accessor macros
 * @{
 */


/* ETF - Register instance definitions */
/* ETF */
#define ETF_FCR                                  ETF_FCR_REG(ETF_BASE_PTR)
#define ETF_PCR                                  ETF_PCR_REG(ETF_BASE_PTR)
#define ETF_ITATBDATA0                           ETF_ITATBDATA0_REG(ETF_BASE_PTR)
#define ETF_ITATBCTR2                            ETF_ITATBCTR2_REG(ETF_BASE_PTR)
#define ETF_ITATBCTR1                            ETF_ITATBCTR1_REG(ETF_BASE_PTR)
#define ETF_ITATBCTR0                            ETF_ITATBCTR0_REG(ETF_BASE_PTR)
#define ETF_ITCTRL                               ETF_ITCTRL_REG(ETF_BASE_PTR)
#define ETF_CLAIMSET                             ETF_CLAIMSET_REG(ETF_BASE_PTR)
#define ETF_CLAIMCLR                             ETF_CLAIMCLR_REG(ETF_BASE_PTR)
#define ETF_LAR                                  ETF_LAR_REG(ETF_BASE_PTR)
#define ETF_LSR                                  ETF_LSR_REG(ETF_BASE_PTR)
#define ETF_AUTHSTATUS                           ETF_AUTHSTATUS_REG(ETF_BASE_PTR)
#define ETF_DEVID                                ETF_DEVID_REG(ETF_BASE_PTR)
#define ETF_DEVTYPE                              ETF_DEVTYPE_REG(ETF_BASE_PTR)
#define ETF_PIDR4                                ETF_PIDR4_REG(ETF_BASE_PTR)
#define ETF_PIDR5                                ETF_PIDR5_REG(ETF_BASE_PTR)
#define ETF_PIDR6                                ETF_PIDR6_REG(ETF_BASE_PTR)
#define ETF_PIDR7                                ETF_PIDR7_REG(ETF_BASE_PTR)
#define ETF_PIDR0                                ETF_PIDR0_REG(ETF_BASE_PTR)
#define ETF_PIDR1                                ETF_PIDR1_REG(ETF_BASE_PTR)
#define ETF_PIDR2                                ETF_PIDR2_REG(ETF_BASE_PTR)
#define ETF_PIDR3                                ETF_PIDR3_REG(ETF_BASE_PTR)
#define ETF_CIDR0                                ETF_CIDR0_REG(ETF_BASE_PTR)
#define ETF_CIDR1                                ETF_CIDR1_REG(ETF_BASE_PTR)
#define ETF_CIDR2                                ETF_CIDR2_REG(ETF_BASE_PTR)
#define ETF_CIDR3                                ETF_CIDR3_REG(ETF_BASE_PTR)

/*!
 * @}
 */ /* end of group ETF_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ETF_Peripheral */


/* ----------------------------------------------------------------------------
   -- ETM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETM_Peripheral ETM
 * @{
 */

/** ETM - Peripheral register structure */
typedef struct ETM_MemMap {
  uint32_t CR;                                     /**< Main Control Register, offset: 0x0 */
  uint32_t CCR;                                    /**< Configuration Code Register, offset: 0x4 */
  uint32_t TRIGGER;                                /**< Trigger Event Register, offset: 0x8 */
  uint8_t RESERVED_0[4];
  uint32_t SR;                                     /**< ETM Status Register, offset: 0x10 */
  uint32_t SCR;                                    /**< System Configuration Register, offset: 0x14 */
  uint8_t RESERVED_1[8];
  uint32_t EEVR;                                   /**< Trace Enable Event Register, offset: 0x20 */
  uint32_t TECR1;                                  /**< Trace Enable Control 1 Register, offset: 0x24 */
  uint32_t FFLR;                                   /**< FIFOFULL Level Register, offset: 0x28 */
  uint8_t RESERVED_2[276];
  uint32_t CNTRLDVR1;                              /**< Free-running counter reload value, offset: 0x140 */
  uint8_t RESERVED_3[156];
  uint32_t SYNCFR;                                 /**< Synchronization Frequency Register, offset: 0x1E0 */
  uint32_t IDR;                                    /**< ID Register, offset: 0x1E4 */
  uint32_t CCER;                                   /**< Configuration Code Extension Register, offset: 0x1E8 */
  uint8_t RESERVED_4[4];
  uint32_t TESSEICR;                               /**< TraceEnable Start/Stop EmbeddedICE Control Register, offset: 0x1F0 */
  uint8_t RESERVED_5[4];
  uint32_t TSEVR;                                  /**< Timestamp Event Register, offset: 0x1F8 */
  uint8_t RESERVED_6[4];
  uint32_t TRACEIDR;                               /**< CoreSight Trace ID Register, offset: 0x200 */
  uint8_t RESERVED_7[4];
  uint32_t IDR2;                                   /**< ETM ID Register 2, offset: 0x208 */
  uint8_t RESERVED_8[264];
  uint32_t PDSR;                                   /**< Device Power-Down Status Register, offset: 0x314 */
  uint8_t RESERVED_9[3016];
  uint32_t ITMISCIN;                               /**< Integration Test Miscelaneous Inputs Register, offset: 0xEE0 */
  uint8_t RESERVED_10[4];
  uint32_t ITTRIGOUT;                              /**< Integration Test Trigger Out Register, offset: 0xEE8 */
  uint8_t RESERVED_11[4];
  uint32_t ITATBCTR2;                              /**< ETM Integration Test ATB Control 2 Register, offset: 0xEF0 */
  uint8_t RESERVED_12[4];
  uint32_t ITATBCTR0;                              /**< ETM Integration Test ATB Control 0 Register, offset: 0xEF8 */
  uint8_t RESERVED_13[4];
  uint32_t ITCTRL;                                 /**< Integration Mode Control Register, offset: 0xF00 */
  uint8_t RESERVED_14[156];
  uint32_t CLAIMSET;                               /**< Claim Tag Set Register, offset: 0xFA0 */
  uint32_t CLAIMCLR;                               /**< Claim Tag Clear Register, offset: 0xFA4 */
  uint8_t RESERVED_15[8];
  uint32_t LAR;                                    /**< Lock Access Register, offset: 0xFB0 */
  uint32_t LSR;                                    /**< Lock Status Register, offset: 0xFB4 */
  uint32_t AUTHSTATUS;                             /**< Authentication Status Register, offset: 0xFB8 */
  uint8_t RESERVED_16[16];
  uint32_t DEVTYPE;                                /**< CoreSight Device Type Register, offset: 0xFCC */
  uint32_t PIDR4;                                  /**< Peripheral Identification Register 4, offset: 0xFD0 */
  uint32_t PIDR5;                                  /**< Peripheral Identification Register 5, offset: 0xFD4 */
  uint32_t PIDR6;                                  /**< Peripheral Identification Register 6, offset: 0xFD8 */
  uint32_t PIDR7;                                  /**< Peripheral Identification Register 7, offset: 0xFDC */
  uint32_t PIDR0;                                  /**< Peripheral Identification Register 0, offset: 0xFE0 */
  uint32_t PIDR1;                                  /**< Peripheral Identification Register 1, offset: 0xFE4 */
  uint32_t PIDR2;                                  /**< Peripheral Identification Register 2, offset: 0xFE8 */
  uint32_t PIDR3;                                  /**< Peripheral Identification Register 3, offset: 0xFEC */
  uint32_t CIDR0;                                  /**< Component Identification Register 0, offset: 0xFF0 */
  uint32_t CIDR1;                                  /**< Component Identification Register 1, offset: 0xFF4 */
  uint32_t CIDR2;                                  /**< Component Identification Register 2, offset: 0xFF8 */
  uint32_t CIDR3;                                  /**< Component Identification Register 3, offset: 0xFFC */
} volatile *ETM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ETM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETM_Register_Accessor_Macros ETM - Register accessor macros
 * @{
 */


/* ETM - Register accessors */
#define ETM_CR_REG(base)                         ((base)->CR)
#define ETM_CCR_REG(base)                        ((base)->CCR)
#define ETM_TRIGGER_REG(base)                    ((base)->TRIGGER)
#define ETM_SR_REG(base)                         ((base)->SR)
#define ETM_SCR_REG(base)                        ((base)->SCR)
#define ETM_EEVR_REG(base)                       ((base)->EEVR)
#define ETM_TECR1_REG(base)                      ((base)->TECR1)
#define ETM_FFLR_REG(base)                       ((base)->FFLR)
#define ETM_CNTRLDVR1_REG(base)                  ((base)->CNTRLDVR1)
#define ETM_SYNCFR_REG(base)                     ((base)->SYNCFR)
#define ETM_IDR_REG(base)                        ((base)->IDR)
#define ETM_CCER_REG(base)                       ((base)->CCER)
#define ETM_TESSEICR_REG(base)                   ((base)->TESSEICR)
#define ETM_TSEVR_REG(base)                      ((base)->TSEVR)
#define ETM_TRACEIDR_REG(base)                   ((base)->TRACEIDR)
#define ETM_IDR2_REG(base)                       ((base)->IDR2)
#define ETM_PDSR_REG(base)                       ((base)->PDSR)
#define ETM_ITMISCIN_REG(base)                   ((base)->ITMISCIN)
#define ETM_ITTRIGOUT_REG(base)                  ((base)->ITTRIGOUT)
#define ETM_ITATBCTR2_REG(base)                  ((base)->ITATBCTR2)
#define ETM_ITATBCTR0_REG(base)                  ((base)->ITATBCTR0)
#define ETM_ITCTRL_REG(base)                     ((base)->ITCTRL)
#define ETM_CLAIMSET_REG(base)                   ((base)->CLAIMSET)
#define ETM_CLAIMCLR_REG(base)                   ((base)->CLAIMCLR)
#define ETM_LAR_REG(base)                        ((base)->LAR)
#define ETM_LSR_REG(base)                        ((base)->LSR)
#define ETM_AUTHSTATUS_REG(base)                 ((base)->AUTHSTATUS)
#define ETM_DEVTYPE_REG(base)                    ((base)->DEVTYPE)
#define ETM_PIDR4_REG(base)                      ((base)->PIDR4)
#define ETM_PIDR5_REG(base)                      ((base)->PIDR5)
#define ETM_PIDR6_REG(base)                      ((base)->PIDR6)
#define ETM_PIDR7_REG(base)                      ((base)->PIDR7)
#define ETM_PIDR0_REG(base)                      ((base)->PIDR0)
#define ETM_PIDR1_REG(base)                      ((base)->PIDR1)
#define ETM_PIDR2_REG(base)                      ((base)->PIDR2)
#define ETM_PIDR3_REG(base)                      ((base)->PIDR3)
#define ETM_CIDR0_REG(base)                      ((base)->CIDR0)
#define ETM_CIDR1_REG(base)                      ((base)->CIDR1)
#define ETM_CIDR2_REG(base)                      ((base)->CIDR2)
#define ETM_CIDR3_REG(base)                      ((base)->CIDR3)

/*!
 * @}
 */ /* end of group ETM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ETM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETM_Register_Masks ETM Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group ETM_Register_Masks */


/* ETM - Peripheral instance base addresses */
/** Peripheral ETM base pointer */
#define ETM_BASE_PTR                             ((ETM_MemMapPtr)0xE0041000u)
/** Array initializer of ETM peripheral base pointers */
#define ETM_BASE_PTRS                            { ETM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ETM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ETM_Register_Accessor_Macros ETM - Register accessor macros
 * @{
 */


/* ETM - Register instance definitions */
/* ETM */
#define ETM_CR                                   ETM_CR_REG(ETM_BASE_PTR)
#define ETM_CCR                                  ETM_CCR_REG(ETM_BASE_PTR)
#define ETM_TRIGGER                              ETM_TRIGGER_REG(ETM_BASE_PTR)
#define ETM_SR                                   ETM_SR_REG(ETM_BASE_PTR)
#define ETM_SCR                                  ETM_SCR_REG(ETM_BASE_PTR)
#define ETM_EEVR                                 ETM_EEVR_REG(ETM_BASE_PTR)
#define ETM_TECR1                                ETM_TECR1_REG(ETM_BASE_PTR)
#define ETM_FFLR                                 ETM_FFLR_REG(ETM_BASE_PTR)
#define ETM_CNTRLDVR1                            ETM_CNTRLDVR1_REG(ETM_BASE_PTR)
#define ETM_SYNCFR                               ETM_SYNCFR_REG(ETM_BASE_PTR)
#define ETM_IDR                                  ETM_IDR_REG(ETM_BASE_PTR)
#define ETM_CCER                                 ETM_CCER_REG(ETM_BASE_PTR)
#define ETM_TESSEICR                             ETM_TESSEICR_REG(ETM_BASE_PTR)
#define ETM_TSEVR                                ETM_TSEVR_REG(ETM_BASE_PTR)
#define ETM_TRACEIDR                             ETM_TRACEIDR_REG(ETM_BASE_PTR)
#define ETM_IDR2                                 ETM_IDR2_REG(ETM_BASE_PTR)
#define ETM_PDSR                                 ETM_PDSR_REG(ETM_BASE_PTR)
#define ETM__ITMISCIN                            ETM_ITMISCIN_REG(ETM_BASE_PTR)
#define ETM__ITTRIGOUT                           ETM_ITTRIGOUT_REG(ETM_BASE_PTR)
#define ETM__ITATBCTR2                           ETM_ITATBCTR2_REG(ETM_BASE_PTR)
#define ETM__ITATBCTR0                           ETM_ITATBCTR0_REG(ETM_BASE_PTR)
#define ETM_ITCTRL                               ETM_ITCTRL_REG(ETM_BASE_PTR)
#define ETM_CLAIMSET                             ETM_CLAIMSET_REG(ETM_BASE_PTR)
#define ETM_CLAIMCLR                             ETM_CLAIMCLR_REG(ETM_BASE_PTR)
#define ETM_LAR                                  ETM_LAR_REG(ETM_BASE_PTR)
#define ETM_LSR                                  ETM_LSR_REG(ETM_BASE_PTR)
#define ETM_AUTHSTATUS                           ETM_AUTHSTATUS_REG(ETM_BASE_PTR)
#define ETM_DEVTYPE                              ETM_DEVTYPE_REG(ETM_BASE_PTR)
#define ETM_PIDR4                                ETM_PIDR4_REG(ETM_BASE_PTR)
#define ETM_PIDR5                                ETM_PIDR5_REG(ETM_BASE_PTR)
#define ETM_PIDR6                                ETM_PIDR6_REG(ETM_BASE_PTR)
#define ETM_PIDR7                                ETM_PIDR7_REG(ETM_BASE_PTR)
#define ETM_PIDR0                                ETM_PIDR0_REG(ETM_BASE_PTR)
#define ETM_PIDR1                                ETM_PIDR1_REG(ETM_BASE_PTR)
#define ETM_PIDR2                                ETM_PIDR2_REG(ETM_BASE_PTR)
#define ETM_PIDR3                                ETM_PIDR3_REG(ETM_BASE_PTR)
#define ETM_CIDR0                                ETM_CIDR0_REG(ETM_BASE_PTR)
#define ETM_CIDR1                                ETM_CIDR1_REG(ETM_BASE_PTR)
#define ETM_CIDR2                                ETM_CIDR2_REG(ETM_BASE_PTR)
#define ETM_CIDR3                                ETM_CIDR3_REG(ETM_BASE_PTR)

/*!
 * @}
 */ /* end of group ETM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ETM_Peripheral */


/* ----------------------------------------------------------------------------
   -- FPB
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FPB_Peripheral FPB
 * @{
 */

/** FPB - Peripheral register structure */
typedef struct FPB_MemMap {
  uint32_t CTRL;                                   /**< FlashPatch Control Register, offset: 0x0 */
  uint32_t REMAP;                                  /**< FlashPatch Remap Register, offset: 0x4 */
  uint32_t COMP[8];                                /**< FlashPatch Comparator Register 0..FlashPatch Comparator Register 7, array offset: 0x8, array step: 0x4 */
  uint8_t RESERVED_0[4008];
  uint32_t PID4;                                   /**< Peripheral Identification Register 4., offset: 0xFD0 */
  uint32_t PID5;                                   /**< Peripheral Identification Register 5., offset: 0xFD4 */
  uint32_t PID6;                                   /**< Peripheral Identification Register 6., offset: 0xFD8 */
  uint32_t PID7;                                   /**< Peripheral Identification Register 7., offset: 0xFDC */
  uint32_t PID0;                                   /**< Peripheral Identification Register 0., offset: 0xFE0 */
  uint32_t PID1;                                   /**< Peripheral Identification Register 1., offset: 0xFE4 */
  uint32_t PID2;                                   /**< Peripheral Identification Register 2., offset: 0xFE8 */
  uint32_t PID3;                                   /**< Peripheral Identification Register 3., offset: 0xFEC */
  uint32_t CID0;                                   /**< Component Identification Register 0., offset: 0xFF0 */
  uint32_t CID1;                                   /**< Component Identification Register 1., offset: 0xFF4 */
  uint32_t CID2;                                   /**< Component Identification Register 2., offset: 0xFF8 */
  uint32_t CID3;                                   /**< Component Identification Register 3., offset: 0xFFC */
} volatile *FPB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FPB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FPB_Register_Accessor_Macros FPB - Register accessor macros
 * @{
 */


/* FPB - Register accessors */
#define FPB_CTRL_REG(base)                       ((base)->CTRL)
#define FPB_REMAP_REG(base)                      ((base)->REMAP)
#define FPB_COMP_REG(base,index)                 ((base)->COMP[index])
#define FPB_PID4_REG(base)                       ((base)->PID4)
#define FPB_PID5_REG(base)                       ((base)->PID5)
#define FPB_PID6_REG(base)                       ((base)->PID6)
#define FPB_PID7_REG(base)                       ((base)->PID7)
#define FPB_PID0_REG(base)                       ((base)->PID0)
#define FPB_PID1_REG(base)                       ((base)->PID1)
#define FPB_PID2_REG(base)                       ((base)->PID2)
#define FPB_PID3_REG(base)                       ((base)->PID3)
#define FPB_CID0_REG(base)                       ((base)->CID0)
#define FPB_CID1_REG(base)                       ((base)->CID1)
#define FPB_CID2_REG(base)                       ((base)->CID2)
#define FPB_CID3_REG(base)                       ((base)->CID3)

/*!
 * @}
 */ /* end of group FPB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FPB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FPB_Register_Masks FPB Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group FPB_Register_Masks */


/* FPB - Peripheral instance base addresses */
/** Peripheral FPB base pointer */
#define FPB_BASE_PTR                             ((FPB_MemMapPtr)0xE0002000u)
/** Array initializer of FPB peripheral base pointers */
#define FPB_BASE_PTRS                            { FPB_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- FPB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FPB_Register_Accessor_Macros FPB - Register accessor macros
 * @{
 */


/* FPB - Register instance definitions */
/* FPB */
#define FPB_CTRL                                 FPB_CTRL_REG(FPB_BASE_PTR)
#define FPB_REMAP                                FPB_REMAP_REG(FPB_BASE_PTR)
#define FPB_COMP0                                FPB_COMP_REG(FPB_BASE_PTR,0)
#define FPB_COMP1                                FPB_COMP_REG(FPB_BASE_PTR,1)
#define FPB_COMP2                                FPB_COMP_REG(FPB_BASE_PTR,2)
#define FPB_COMP3                                FPB_COMP_REG(FPB_BASE_PTR,3)
#define FPB_COMP4                                FPB_COMP_REG(FPB_BASE_PTR,4)
#define FPB_COMP5                                FPB_COMP_REG(FPB_BASE_PTR,5)
#define FPB_COMP6                                FPB_COMP_REG(FPB_BASE_PTR,6)
#define FPB_COMP7                                FPB_COMP_REG(FPB_BASE_PTR,7)
#define FPB_PID4                                 FPB_PID4_REG(FPB_BASE_PTR)
#define FPB_PID5                                 FPB_PID5_REG(FPB_BASE_PTR)
#define FPB_PID6                                 FPB_PID6_REG(FPB_BASE_PTR)
#define FPB_PID7                                 FPB_PID7_REG(FPB_BASE_PTR)
#define FPB_PID0                                 FPB_PID0_REG(FPB_BASE_PTR)
#define FPB_PID1                                 FPB_PID1_REG(FPB_BASE_PTR)
#define FPB_PID2                                 FPB_PID2_REG(FPB_BASE_PTR)
#define FPB_PID3                                 FPB_PID3_REG(FPB_BASE_PTR)
#define FPB_CID0                                 FPB_CID0_REG(FPB_BASE_PTR)
#define FPB_CID1                                 FPB_CID1_REG(FPB_BASE_PTR)
#define FPB_CID2                                 FPB_CID2_REG(FPB_BASE_PTR)
#define FPB_CID3                                 FPB_CID3_REG(FPB_BASE_PTR)

/* FPB - Register array accessors */
#define FPB_COMP(index)                          FPB_COMP_REG(FPB_BASE_PTR,index)

/*!
 * @}
 */ /* end of group FPB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FPB_Peripheral */


/* ----------------------------------------------------------------------------
   -- GIS
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GIS_Peripheral GIS
 * @{
 */

/** GIS - Peripheral register structure */
typedef struct GIS_MemMap {
  uint32_t CTRL;                                   /**< GIS Control Register, offset: 0x0 */
  uint32_t CTRL_SET;                               /**< GIS Control Register, offset: 0x4 */
  uint32_t CTRL_CLR;                               /**< GIS Control Register, offset: 0x8 */
  uint32_t CTRL_TOG;                               /**< GIS Control Register, offset: 0xC */
  uint32_t CONFIG0;                                /**< GIS Configuration 0 Register, offset: 0x10 */
  uint32_t CONFIG0_SET;                            /**< GIS Configuration 0 Register, offset: 0x14 */
  uint32_t CONFIG0_CLR;                            /**< GIS Configuration 0 Register, offset: 0x18 */
  uint32_t CONFIG0_TOG;                            /**< GIS Configuration 0 Register, offset: 0x1C */
  uint32_t CONFIG1;                                /**< GIS Configuration 1 Register, offset: 0x20 */
  uint32_t CONFIG1_SET;                            /**< GIS Configuration 1 Register, offset: 0x24 */
  uint32_t CONFIG1_CLR;                            /**< GIS Configuration 1 Register, offset: 0x28 */
  uint32_t CONFIG1_TOG;                            /**< GIS Configuration 1 Register, offset: 0x2C */
  uint32_t FB0;                                    /**< Camera Frame Buffer Address 0 Register, offset: 0x30 */
  uint8_t RESERVED_0[12];
  uint32_t FB1;                                    /**< Camera Frame Buffer Address 1 Register, offset: 0x40 */
  uint8_t RESERVED_1[12];
  uint32_t PXP_FB0;                                /**< PXP Frame Buffer Address 0 Register., offset: 0x50 */
  uint8_t RESERVED_2[12];
  uint32_t PXP_FB1;                                /**< PXP Frame Buffer Address 1 Register, offset: 0x60 */
  uint8_t RESERVED_3[12];
  uint32_t CH0_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x70 */
  uint32_t CH0_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x74 */
  uint32_t CH0_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x78 */
  uint32_t CH0_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x7C */
  uint32_t CH0_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x80 */
  uint32_t CH0_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x84 */
  uint32_t CH0_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x88 */
  uint32_t CH0_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x8C */
  uint32_t CH0_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x90 */
  uint8_t RESERVED_4[12];
  uint32_t CH0_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0xA0 */
  uint32_t CH0_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0xA4 */
  uint32_t CH0_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0xA8 */
  uint32_t CH0_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0xAC */
  uint32_t CH0_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0xB0 */
  uint8_t RESERVED_5[12];
  uint32_t CH0_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0xC0 */
  uint32_t CH0_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0xC4 */
  uint32_t CH0_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0xC8 */
  uint32_t CH0_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0xCC */
  uint32_t CH0_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0xD0 */
  uint8_t RESERVED_6[12];
  uint32_t CH0_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0xE0 */
  uint32_t CH0_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0xE4 */
  uint32_t CH0_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0xE8 */
  uint32_t CH0_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0xEC */
  uint32_t CH0_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0xF0 */
  uint8_t RESERVED_7[12];
  uint32_t CH1_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x100 */
  uint32_t CH1_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x104 */
  uint32_t CH1_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x108 */
  uint32_t CH1_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x10C */
  uint32_t CH1_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x110 */
  uint32_t CH1_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x114 */
  uint32_t CH1_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x118 */
  uint32_t CH1_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x11C */
  uint32_t CH1_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x120 */
  uint8_t RESERVED_8[12];
  uint32_t CH1_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0x130 */
  uint32_t CH1_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0x134 */
  uint32_t CH1_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0x138 */
  uint32_t CH1_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0x13C */
  uint32_t CH1_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0x140 */
  uint8_t RESERVED_9[12];
  uint32_t CH1_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0x150 */
  uint32_t CH1_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0x154 */
  uint32_t CH1_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0x158 */
  uint32_t CH1_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0x15C */
  uint32_t CH1_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0x160 */
  uint8_t RESERVED_10[12];
  uint32_t CH1_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0x170 */
  uint32_t CH1_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0x174 */
  uint32_t CH1_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0x178 */
  uint32_t CH1_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0x17C */
  uint32_t CH1_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0x180 */
  uint8_t RESERVED_11[12];
  uint32_t CH2_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x190 */
  uint32_t CH2_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x194 */
  uint32_t CH2_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x198 */
  uint32_t CH2_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x19C */
  uint32_t CH2_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x1A0 */
  uint32_t CH2_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x1A4 */
  uint32_t CH2_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x1A8 */
  uint32_t CH2_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x1AC */
  uint32_t CH2_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x1B0 */
  uint8_t RESERVED_12[12];
  uint32_t CH2_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0x1C0 */
  uint32_t CH2_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0x1C4 */
  uint32_t CH2_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0x1C8 */
  uint32_t CH2_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0x1CC */
  uint32_t CH2_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0x1D0 */
  uint8_t RESERVED_13[12];
  uint32_t CH2_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0x1E0 */
  uint32_t CH2_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0x1E4 */
  uint32_t CH2_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0x1E8 */
  uint32_t CH2_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0x1EC */
  uint32_t CH2_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0x1F0 */
  uint8_t RESERVED_14[12];
  uint32_t CH2_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0x200 */
  uint32_t CH2_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0x204 */
  uint32_t CH2_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0x208 */
  uint32_t CH2_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0x20C */
  uint32_t CH2_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0x210 */
  uint8_t RESERVED_15[12];
  uint32_t CH3_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x220 */
  uint32_t CH3_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x224 */
  uint32_t CH3_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x228 */
  uint32_t CH3_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x22C */
  uint32_t CH3_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x230 */
  uint32_t CH3_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x234 */
  uint32_t CH3_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x238 */
  uint32_t CH3_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x23C */
  uint32_t CH3_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x240 */
  uint8_t RESERVED_16[12];
  uint32_t CH3_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0x250 */
  uint32_t CH3_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0x254 */
  uint32_t CH3_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0x258 */
  uint32_t CH3_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0x25C */
  uint32_t CH3_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0x260 */
  uint8_t RESERVED_17[12];
  uint32_t CH3_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0x270 */
  uint32_t CH3_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0x274 */
  uint32_t CH3_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0x278 */
  uint32_t CH3_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0x27C */
  uint32_t CH3_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0x280 */
  uint8_t RESERVED_18[12];
  uint32_t CH3_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0x290 */
  uint32_t CH3_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0x294 */
  uint32_t CH3_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0x298 */
  uint32_t CH3_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0x29C */
  uint32_t CH3_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0x2A0 */
  uint8_t RESERVED_19[12];
  uint32_t CH4_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x2B0 */
  uint32_t CH4_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x2B4 */
  uint32_t CH4_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x2B8 */
  uint32_t CH4_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x2BC */
  uint32_t CH4_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x2C0 */
  uint32_t CH4_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x2C4 */
  uint32_t CH4_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x2C8 */
  uint32_t CH4_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x2CC */
  uint32_t CH4_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x2D0 */
  uint8_t RESERVED_20[12];
  uint32_t CH4_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0x2E0 */
  uint32_t CH4_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0x2E4 */
  uint32_t CH4_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0x2E8 */
  uint32_t CH4_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0x2EC */
  uint32_t CH4_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0x2F0 */
  uint8_t RESERVED_21[12];
  uint32_t CH4_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0x300 */
  uint32_t CH4_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0x304 */
  uint32_t CH4_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0x308 */
  uint32_t CH4_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0x30C */
  uint32_t CH4_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0x310 */
  uint8_t RESERVED_22[12];
  uint32_t CH4_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0x320 */
  uint32_t CH4_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0x324 */
  uint32_t CH4_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0x328 */
  uint32_t CH4_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0x32C */
  uint32_t CH4_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0x330 */
  uint8_t RESERVED_23[12];
  uint32_t CH5_CTRL;                               /**< Control Command Channel 0 Register, offset: 0x340 */
  uint32_t CH5_CTRL_SET;                           /**< Control Command Channel 0 Register, offset: 0x344 */
  uint32_t CH5_CTRL_CLR;                           /**< Control Command Channel 0 Register, offset: 0x348 */
  uint32_t CH5_CTRL_TOG;                           /**< Control Command Channel 0 Register, offset: 0x34C */
  uint32_t CH5_ADDR0;                              /**< Channel 0 Command 0 Address Register., offset: 0x350 */
  uint32_t CH5_ADDR0_SET;                          /**< Channel 0 Command 0 Address Register., offset: 0x354 */
  uint32_t CH5_ADDR0_CLR;                          /**< Channel 0 Command 0 Address Register., offset: 0x358 */
  uint32_t CH5_ADDR0_TOG;                          /**< Channel 0 Command 0 Address Register., offset: 0x35C */
  uint32_t CH5_DATA0;                              /**< Channel 0 Command 0 Data Register, offset: 0x360 */
  uint8_t RESERVED_24[12];
  uint32_t CH5_ADDR1;                              /**< Channel 0 Command 1 Address Register., offset: 0x370 */
  uint32_t CH5_ADDR1_SET;                          /**< Channel 0 Command 1 Address Register., offset: 0x374 */
  uint32_t CH5_ADDR1_CLR;                          /**< Channel 0 Command 1 Address Register., offset: 0x378 */
  uint32_t CH5_ADDR1_TOG;                          /**< Channel 0 Command 1 Address Register., offset: 0x37C */
  uint32_t CH5_DATA1;                              /**< Channel 0 Command 1 Data Register, offset: 0x380 */
  uint8_t RESERVED_25[12];
  uint32_t CH5_ADDR2;                              /**< Channel 0 Command 2 Address Register., offset: 0x390 */
  uint32_t CH5_ADDR2_SET;                          /**< Channel 0 Command 2 Address Register., offset: 0x394 */
  uint32_t CH5_ADDR2_CLR;                          /**< Channel 0 Command 2 Address Register., offset: 0x398 */
  uint32_t CH5_ADDR2_TOG;                          /**< Channel 0 Command 2 Address Register., offset: 0x39C */
  uint32_t CH5_DATA2;                              /**< Channel 0 Command 2 Data Register, offset: 0x3A0 */
  uint8_t RESERVED_26[12];
  uint32_t CH5_ADDR3;                              /**< Channel 0 Command 3 Address Register., offset: 0x3B0 */
  uint32_t CH5_ADDR3_SET;                          /**< Channel 0 Command 3 Address Register., offset: 0x3B4 */
  uint32_t CH5_ADDR3_CLR;                          /**< Channel 0 Command 3 Address Register., offset: 0x3B8 */
  uint32_t CH5_ADDR3_TOG;                          /**< Channel 0 Command 3 Address Register., offset: 0x3BC */
  uint32_t CH5_DATA3;                              /**< Channel 0 Command 3 Data Register, offset: 0x3C0 */
  uint8_t RESERVED_27[12];
  uint32_t DEBUG0;                                 /**< Debug 0 Register, offset: 0x3D0 */
  uint8_t RESERVED_28[12];
  uint32_t DEBUG1;                                 /**< Debug 1 Register, offset: 0x3E0 */
  uint8_t RESERVED_29[12];
  uint32_t VERSION;                                /**< Version Register, offset: 0x3F0 */
} volatile *GIS_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GIS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GIS_Register_Accessor_Macros GIS - Register accessor macros
 * @{
 */


/* GIS - Register accessors */
#define GIS_CTRL_REG(base)                       ((base)->CTRL)
#define GIS_CTRL_SET_REG(base)                   ((base)->CTRL_SET)
#define GIS_CTRL_CLR_REG(base)                   ((base)->CTRL_CLR)
#define GIS_CTRL_TOG_REG(base)                   ((base)->CTRL_TOG)
#define GIS_CONFIG0_REG(base)                    ((base)->CONFIG0)
#define GIS_CONFIG0_SET_REG(base)                ((base)->CONFIG0_SET)
#define GIS_CONFIG0_CLR_REG(base)                ((base)->CONFIG0_CLR)
#define GIS_CONFIG0_TOG_REG(base)                ((base)->CONFIG0_TOG)
#define GIS_CONFIG1_REG(base)                    ((base)->CONFIG1)
#define GIS_CONFIG1_SET_REG(base)                ((base)->CONFIG1_SET)
#define GIS_CONFIG1_CLR_REG(base)                ((base)->CONFIG1_CLR)
#define GIS_CONFIG1_TOG_REG(base)                ((base)->CONFIG1_TOG)
#define GIS_FB0_REG(base)                        ((base)->FB0)
#define GIS_FB1_REG(base)                        ((base)->FB1)
#define GIS_PXP_FB0_REG(base)                    ((base)->PXP_FB0)
#define GIS_PXP_FB1_REG(base)                    ((base)->PXP_FB1)
#define GIS_CH0_CTRL_REG(base)                   ((base)->CH0_CTRL)
#define GIS_CH0_CTRL_SET_REG(base)               ((base)->CH0_CTRL_SET)
#define GIS_CH0_CTRL_CLR_REG(base)               ((base)->CH0_CTRL_CLR)
#define GIS_CH0_CTRL_TOG_REG(base)               ((base)->CH0_CTRL_TOG)
#define GIS_CH0_ADDR0_REG(base)                  ((base)->CH0_ADDR0)
#define GIS_CH0_ADDR0_SET_REG(base)              ((base)->CH0_ADDR0_SET)
#define GIS_CH0_ADDR0_CLR_REG(base)              ((base)->CH0_ADDR0_CLR)
#define GIS_CH0_ADDR0_TOG_REG(base)              ((base)->CH0_ADDR0_TOG)
#define GIS_CH0_DATA0_REG(base)                  ((base)->CH0_DATA0)
#define GIS_CH0_ADDR1_REG(base)                  ((base)->CH0_ADDR1)
#define GIS_CH0_ADDR1_SET_REG(base)              ((base)->CH0_ADDR1_SET)
#define GIS_CH0_ADDR1_CLR_REG(base)              ((base)->CH0_ADDR1_CLR)
#define GIS_CH0_ADDR1_TOG_REG(base)              ((base)->CH0_ADDR1_TOG)
#define GIS_CH0_DATA1_REG(base)                  ((base)->CH0_DATA1)
#define GIS_CH0_ADDR2_REG(base)                  ((base)->CH0_ADDR2)
#define GIS_CH0_ADDR2_SET_REG(base)              ((base)->CH0_ADDR2_SET)
#define GIS_CH0_ADDR2_CLR_REG(base)              ((base)->CH0_ADDR2_CLR)
#define GIS_CH0_ADDR2_TOG_REG(base)              ((base)->CH0_ADDR2_TOG)
#define GIS_CH0_DATA2_REG(base)                  ((base)->CH0_DATA2)
#define GIS_CH0_ADDR3_REG(base)                  ((base)->CH0_ADDR3)
#define GIS_CH0_ADDR3_SET_REG(base)              ((base)->CH0_ADDR3_SET)
#define GIS_CH0_ADDR3_CLR_REG(base)              ((base)->CH0_ADDR3_CLR)
#define GIS_CH0_ADDR3_TOG_REG(base)              ((base)->CH0_ADDR3_TOG)
#define GIS_CH0_DATA3_REG(base)                  ((base)->CH0_DATA3)
#define GIS_CH1_CTRL_REG(base)                   ((base)->CH1_CTRL)
#define GIS_CH1_CTRL_SET_REG(base)               ((base)->CH1_CTRL_SET)
#define GIS_CH1_CTRL_CLR_REG(base)               ((base)->CH1_CTRL_CLR)
#define GIS_CH1_CTRL_TOG_REG(base)               ((base)->CH1_CTRL_TOG)
#define GIS_CH1_ADDR0_REG(base)                  ((base)->CH1_ADDR0)
#define GIS_CH1_ADDR0_SET_REG(base)              ((base)->CH1_ADDR0_SET)
#define GIS_CH1_ADDR0_CLR_REG(base)              ((base)->CH1_ADDR0_CLR)
#define GIS_CH1_ADDR0_TOG_REG(base)              ((base)->CH1_ADDR0_TOG)
#define GIS_CH1_DATA0_REG(base)                  ((base)->CH1_DATA0)
#define GIS_CH1_ADDR1_REG(base)                  ((base)->CH1_ADDR1)
#define GIS_CH1_ADDR1_SET_REG(base)              ((base)->CH1_ADDR1_SET)
#define GIS_CH1_ADDR1_CLR_REG(base)              ((base)->CH1_ADDR1_CLR)
#define GIS_CH1_ADDR1_TOG_REG(base)              ((base)->CH1_ADDR1_TOG)
#define GIS_CH1_DATA1_REG(base)                  ((base)->CH1_DATA1)
#define GIS_CH1_ADDR2_REG(base)                  ((base)->CH1_ADDR2)
#define GIS_CH1_ADDR2_SET_REG(base)              ((base)->CH1_ADDR2_SET)
#define GIS_CH1_ADDR2_CLR_REG(base)              ((base)->CH1_ADDR2_CLR)
#define GIS_CH1_ADDR2_TOG_REG(base)              ((base)->CH1_ADDR2_TOG)
#define GIS_CH1_DATA2_REG(base)                  ((base)->CH1_DATA2)
#define GIS_CH1_ADDR3_REG(base)                  ((base)->CH1_ADDR3)
#define GIS_CH1_ADDR3_SET_REG(base)              ((base)->CH1_ADDR3_SET)
#define GIS_CH1_ADDR3_CLR_REG(base)              ((base)->CH1_ADDR3_CLR)
#define GIS_CH1_ADDR3_TOG_REG(base)              ((base)->CH1_ADDR3_TOG)
#define GIS_CH1_DATA3_REG(base)                  ((base)->CH1_DATA3)
#define GIS_CH2_CTRL_REG(base)                   ((base)->CH2_CTRL)
#define GIS_CH2_CTRL_SET_REG(base)               ((base)->CH2_CTRL_SET)
#define GIS_CH2_CTRL_CLR_REG(base)               ((base)->CH2_CTRL_CLR)
#define GIS_CH2_CTRL_TOG_REG(base)               ((base)->CH2_CTRL_TOG)
#define GIS_CH2_ADDR0_REG(base)                  ((base)->CH2_ADDR0)
#define GIS_CH2_ADDR0_SET_REG(base)              ((base)->CH2_ADDR0_SET)
#define GIS_CH2_ADDR0_CLR_REG(base)              ((base)->CH2_ADDR0_CLR)
#define GIS_CH2_ADDR0_TOG_REG(base)              ((base)->CH2_ADDR0_TOG)
#define GIS_CH2_DATA0_REG(base)                  ((base)->CH2_DATA0)
#define GIS_CH2_ADDR1_REG(base)                  ((base)->CH2_ADDR1)
#define GIS_CH2_ADDR1_SET_REG(base)              ((base)->CH2_ADDR1_SET)
#define GIS_CH2_ADDR1_CLR_REG(base)              ((base)->CH2_ADDR1_CLR)
#define GIS_CH2_ADDR1_TOG_REG(base)              ((base)->CH2_ADDR1_TOG)
#define GIS_CH2_DATA1_REG(base)                  ((base)->CH2_DATA1)
#define GIS_CH2_ADDR2_REG(base)                  ((base)->CH2_ADDR2)
#define GIS_CH2_ADDR2_SET_REG(base)              ((base)->CH2_ADDR2_SET)
#define GIS_CH2_ADDR2_CLR_REG(base)              ((base)->CH2_ADDR2_CLR)
#define GIS_CH2_ADDR2_TOG_REG(base)              ((base)->CH2_ADDR2_TOG)
#define GIS_CH2_DATA2_REG(base)                  ((base)->CH2_DATA2)
#define GIS_CH2_ADDR3_REG(base)                  ((base)->CH2_ADDR3)
#define GIS_CH2_ADDR3_SET_REG(base)              ((base)->CH2_ADDR3_SET)
#define GIS_CH2_ADDR3_CLR_REG(base)              ((base)->CH2_ADDR3_CLR)
#define GIS_CH2_ADDR3_TOG_REG(base)              ((base)->CH2_ADDR3_TOG)
#define GIS_CH2_DATA3_REG(base)                  ((base)->CH2_DATA3)
#define GIS_CH3_CTRL_REG(base)                   ((base)->CH3_CTRL)
#define GIS_CH3_CTRL_SET_REG(base)               ((base)->CH3_CTRL_SET)
#define GIS_CH3_CTRL_CLR_REG(base)               ((base)->CH3_CTRL_CLR)
#define GIS_CH3_CTRL_TOG_REG(base)               ((base)->CH3_CTRL_TOG)
#define GIS_CH3_ADDR0_REG(base)                  ((base)->CH3_ADDR0)
#define GIS_CH3_ADDR0_SET_REG(base)              ((base)->CH3_ADDR0_SET)
#define GIS_CH3_ADDR0_CLR_REG(base)              ((base)->CH3_ADDR0_CLR)
#define GIS_CH3_ADDR0_TOG_REG(base)              ((base)->CH3_ADDR0_TOG)
#define GIS_CH3_DATA0_REG(base)                  ((base)->CH3_DATA0)
#define GIS_CH3_ADDR1_REG(base)                  ((base)->CH3_ADDR1)
#define GIS_CH3_ADDR1_SET_REG(base)              ((base)->CH3_ADDR1_SET)
#define GIS_CH3_ADDR1_CLR_REG(base)              ((base)->CH3_ADDR1_CLR)
#define GIS_CH3_ADDR1_TOG_REG(base)              ((base)->CH3_ADDR1_TOG)
#define GIS_CH3_DATA1_REG(base)                  ((base)->CH3_DATA1)
#define GIS_CH3_ADDR2_REG(base)                  ((base)->CH3_ADDR2)
#define GIS_CH3_ADDR2_SET_REG(base)              ((base)->CH3_ADDR2_SET)
#define GIS_CH3_ADDR2_CLR_REG(base)              ((base)->CH3_ADDR2_CLR)
#define GIS_CH3_ADDR2_TOG_REG(base)              ((base)->CH3_ADDR2_TOG)
#define GIS_CH3_DATA2_REG(base)                  ((base)->CH3_DATA2)
#define GIS_CH3_ADDR3_REG(base)                  ((base)->CH3_ADDR3)
#define GIS_CH3_ADDR3_SET_REG(base)              ((base)->CH3_ADDR3_SET)
#define GIS_CH3_ADDR3_CLR_REG(base)              ((base)->CH3_ADDR3_CLR)
#define GIS_CH3_ADDR3_TOG_REG(base)              ((base)->CH3_ADDR3_TOG)
#define GIS_CH3_DATA3_REG(base)                  ((base)->CH3_DATA3)
#define GIS_CH4_CTRL_REG(base)                   ((base)->CH4_CTRL)
#define GIS_CH4_CTRL_SET_REG(base)               ((base)->CH4_CTRL_SET)
#define GIS_CH4_CTRL_CLR_REG(base)               ((base)->CH4_CTRL_CLR)
#define GIS_CH4_CTRL_TOG_REG(base)               ((base)->CH4_CTRL_TOG)
#define GIS_CH4_ADDR0_REG(base)                  ((base)->CH4_ADDR0)
#define GIS_CH4_ADDR0_SET_REG(base)              ((base)->CH4_ADDR0_SET)
#define GIS_CH4_ADDR0_CLR_REG(base)              ((base)->CH4_ADDR0_CLR)
#define GIS_CH4_ADDR0_TOG_REG(base)              ((base)->CH4_ADDR0_TOG)
#define GIS_CH4_DATA0_REG(base)                  ((base)->CH4_DATA0)
#define GIS_CH4_ADDR1_REG(base)                  ((base)->CH4_ADDR1)
#define GIS_CH4_ADDR1_SET_REG(base)              ((base)->CH4_ADDR1_SET)
#define GIS_CH4_ADDR1_CLR_REG(base)              ((base)->CH4_ADDR1_CLR)
#define GIS_CH4_ADDR1_TOG_REG(base)              ((base)->CH4_ADDR1_TOG)
#define GIS_CH4_DATA1_REG(base)                  ((base)->CH4_DATA1)
#define GIS_CH4_ADDR2_REG(base)                  ((base)->CH4_ADDR2)
#define GIS_CH4_ADDR2_SET_REG(base)              ((base)->CH4_ADDR2_SET)
#define GIS_CH4_ADDR2_CLR_REG(base)              ((base)->CH4_ADDR2_CLR)
#define GIS_CH4_ADDR2_TOG_REG(base)              ((base)->CH4_ADDR2_TOG)
#define GIS_CH4_DATA2_REG(base)                  ((base)->CH4_DATA2)
#define GIS_CH4_ADDR3_REG(base)                  ((base)->CH4_ADDR3)
#define GIS_CH4_ADDR3_SET_REG(base)              ((base)->CH4_ADDR3_SET)
#define GIS_CH4_ADDR3_CLR_REG(base)              ((base)->CH4_ADDR3_CLR)
#define GIS_CH4_ADDR3_TOG_REG(base)              ((base)->CH4_ADDR3_TOG)
#define GIS_CH4_DATA3_REG(base)                  ((base)->CH4_DATA3)
#define GIS_CH5_CTRL_REG(base)                   ((base)->CH5_CTRL)
#define GIS_CH5_CTRL_SET_REG(base)               ((base)->CH5_CTRL_SET)
#define GIS_CH5_CTRL_CLR_REG(base)               ((base)->CH5_CTRL_CLR)
#define GIS_CH5_CTRL_TOG_REG(base)               ((base)->CH5_CTRL_TOG)
#define GIS_CH5_ADDR0_REG(base)                  ((base)->CH5_ADDR0)
#define GIS_CH5_ADDR0_SET_REG(base)              ((base)->CH5_ADDR0_SET)
#define GIS_CH5_ADDR0_CLR_REG(base)              ((base)->CH5_ADDR0_CLR)
#define GIS_CH5_ADDR0_TOG_REG(base)              ((base)->CH5_ADDR0_TOG)
#define GIS_CH5_DATA0_REG(base)                  ((base)->CH5_DATA0)
#define GIS_CH5_ADDR1_REG(base)                  ((base)->CH5_ADDR1)
#define GIS_CH5_ADDR1_SET_REG(base)              ((base)->CH5_ADDR1_SET)
#define GIS_CH5_ADDR1_CLR_REG(base)              ((base)->CH5_ADDR1_CLR)
#define GIS_CH5_ADDR1_TOG_REG(base)              ((base)->CH5_ADDR1_TOG)
#define GIS_CH5_DATA1_REG(base)                  ((base)->CH5_DATA1)
#define GIS_CH5_ADDR2_REG(base)                  ((base)->CH5_ADDR2)
#define GIS_CH5_ADDR2_SET_REG(base)              ((base)->CH5_ADDR2_SET)
#define GIS_CH5_ADDR2_CLR_REG(base)              ((base)->CH5_ADDR2_CLR)
#define GIS_CH5_ADDR2_TOG_REG(base)              ((base)->CH5_ADDR2_TOG)
#define GIS_CH5_DATA2_REG(base)                  ((base)->CH5_DATA2)
#define GIS_CH5_ADDR3_REG(base)                  ((base)->CH5_ADDR3)
#define GIS_CH5_ADDR3_SET_REG(base)              ((base)->CH5_ADDR3_SET)
#define GIS_CH5_ADDR3_CLR_REG(base)              ((base)->CH5_ADDR3_CLR)
#define GIS_CH5_ADDR3_TOG_REG(base)              ((base)->CH5_ADDR3_TOG)
#define GIS_CH5_DATA3_REG(base)                  ((base)->CH5_DATA3)
#define GIS_DEBUG0_REG(base)                     ((base)->DEBUG0)
#define GIS_DEBUG1_REG(base)                     ((base)->DEBUG1)
#define GIS_VERSION_REG(base)                    ((base)->VERSION)

/*!
 * @}
 */ /* end of group GIS_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GIS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GIS_Register_Masks GIS Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define GIS_CTRL_ENABLE_MASK                     0x1u
#define GIS_CTRL_ENABLE_SHIFT                    0
#define GIS_CTRL_FB_START_MASK                   0x2u
#define GIS_CTRL_FB_START_SHIFT                  1
#define GIS_CTRL_LCDIF_SEL_MASK                  0x4u
#define GIS_CTRL_LCDIF_SEL_SHIFT                 2
#define GIS_CTRL_CSI_SEL_MASK                    0x8u
#define GIS_CTRL_CSI_SEL_SHIFT                   3
#define GIS_CTRL_CSI0_IRQ_POLARITY_MASK          0x10u
#define GIS_CTRL_CSI0_IRQ_POLARITY_SHIFT         4
#define GIS_CTRL_CSI1_IRQ_POLARITY_MASK          0x20u
#define GIS_CTRL_CSI1_IRQ_POLARITY_SHIFT         5
#define GIS_CTRL_PXP_IRQ_POLARITY_MASK           0x40u
#define GIS_CTRL_PXP_IRQ_POLARITY_SHIFT          6
#define GIS_CTRL_LCDIF0_IRQ_POLARITY_MASK        0x80u
#define GIS_CTRL_LCDIF0_IRQ_POLARITY_SHIFT       7
#define GIS_CTRL_LCDIF1_IRQ_POLARITY_MASK        0x100u
#define GIS_CTRL_LCDIF1_IRQ_POLARITY_SHIFT       8
#define GIS_CTRL_CLKGATE_MASK                    0x40000000u
#define GIS_CTRL_CLKGATE_SHIFT                   30
#define GIS_CTRL_SFTRST_MASK                     0x80000000u
#define GIS_CTRL_SFTRST_SHIFT                    31
/* CTRL_SET Bit Fields */
#define GIS_CTRL_SET_ENABLE_MASK                 0x1u
#define GIS_CTRL_SET_ENABLE_SHIFT                0
#define GIS_CTRL_SET_FB_START_MASK               0x2u
#define GIS_CTRL_SET_FB_START_SHIFT              1
#define GIS_CTRL_SET_LCDIF_SEL_MASK              0x4u
#define GIS_CTRL_SET_LCDIF_SEL_SHIFT             2
#define GIS_CTRL_SET_CSI_SEL_MASK                0x8u
#define GIS_CTRL_SET_CSI_SEL_SHIFT               3
#define GIS_CTRL_SET_CSI0_IRQ_POLARITY_MASK      0x10u
#define GIS_CTRL_SET_CSI0_IRQ_POLARITY_SHIFT     4
#define GIS_CTRL_SET_CSI1_IRQ_POLARITY_MASK      0x20u
#define GIS_CTRL_SET_CSI1_IRQ_POLARITY_SHIFT     5
#define GIS_CTRL_SET_PXP_IRQ_POLARITY_MASK       0x40u
#define GIS_CTRL_SET_PXP_IRQ_POLARITY_SHIFT      6
#define GIS_CTRL_SET_LCDIF0_IRQ_POLARITY_MASK    0x80u
#define GIS_CTRL_SET_LCDIF0_IRQ_POLARITY_SHIFT   7
#define GIS_CTRL_SET_LCDIF1_IRQ_POLARITY_MASK    0x100u
#define GIS_CTRL_SET_LCDIF1_IRQ_POLARITY_SHIFT   8
#define GIS_CTRL_SET_CLKGATE_MASK                0x40000000u
#define GIS_CTRL_SET_CLKGATE_SHIFT               30
#define GIS_CTRL_SET_SFTRST_MASK                 0x80000000u
#define GIS_CTRL_SET_SFTRST_SHIFT                31
/* CTRL_CLR Bit Fields */
#define GIS_CTRL_CLR_ENABLE_MASK                 0x1u
#define GIS_CTRL_CLR_ENABLE_SHIFT                0
#define GIS_CTRL_CLR_FB_START_MASK               0x2u
#define GIS_CTRL_CLR_FB_START_SHIFT              1
#define GIS_CTRL_CLR_LCDIF_SEL_MASK              0x4u
#define GIS_CTRL_CLR_LCDIF_SEL_SHIFT             2
#define GIS_CTRL_CLR_CSI_SEL_MASK                0x8u
#define GIS_CTRL_CLR_CSI_SEL_SHIFT               3
#define GIS_CTRL_CLR_CSI0_IRQ_POLARITY_MASK      0x10u
#define GIS_CTRL_CLR_CSI0_IRQ_POLARITY_SHIFT     4
#define GIS_CTRL_CLR_CSI1_IRQ_POLARITY_MASK      0x20u
#define GIS_CTRL_CLR_CSI1_IRQ_POLARITY_SHIFT     5
#define GIS_CTRL_CLR_PXP_IRQ_POLARITY_MASK       0x40u
#define GIS_CTRL_CLR_PXP_IRQ_POLARITY_SHIFT      6
#define GIS_CTRL_CLR_LCDIF0_IRQ_POLARITY_MASK    0x80u
#define GIS_CTRL_CLR_LCDIF0_IRQ_POLARITY_SHIFT   7
#define GIS_CTRL_CLR_LCDIF1_IRQ_POLARITY_MASK    0x100u
#define GIS_CTRL_CLR_LCDIF1_IRQ_POLARITY_SHIFT   8
#define GIS_CTRL_CLR_CLKGATE_MASK                0x40000000u
#define GIS_CTRL_CLR_CLKGATE_SHIFT               30
#define GIS_CTRL_CLR_SFTRST_MASK                 0x80000000u
#define GIS_CTRL_CLR_SFTRST_SHIFT                31
/* CTRL_TOG Bit Fields */
#define GIS_CTRL_TOG_ENABLE_MASK                 0x1u
#define GIS_CTRL_TOG_ENABLE_SHIFT                0
#define GIS_CTRL_TOG_FB_START_MASK               0x2u
#define GIS_CTRL_TOG_FB_START_SHIFT              1
#define GIS_CTRL_TOG_LCDIF_SEL_MASK              0x4u
#define GIS_CTRL_TOG_LCDIF_SEL_SHIFT             2
#define GIS_CTRL_TOG_CSI_SEL_MASK                0x8u
#define GIS_CTRL_TOG_CSI_SEL_SHIFT               3
#define GIS_CTRL_TOG_CSI0_IRQ_POLARITY_MASK      0x10u
#define GIS_CTRL_TOG_CSI0_IRQ_POLARITY_SHIFT     4
#define GIS_CTRL_TOG_CSI1_IRQ_POLARITY_MASK      0x20u
#define GIS_CTRL_TOG_CSI1_IRQ_POLARITY_SHIFT     5
#define GIS_CTRL_TOG_PXP_IRQ_POLARITY_MASK       0x40u
#define GIS_CTRL_TOG_PXP_IRQ_POLARITY_SHIFT      6
#define GIS_CTRL_TOG_LCDIF0_IRQ_POLARITY_MASK    0x80u
#define GIS_CTRL_TOG_LCDIF0_IRQ_POLARITY_SHIFT   7
#define GIS_CTRL_TOG_LCDIF1_IRQ_POLARITY_MASK    0x100u
#define GIS_CTRL_TOG_LCDIF1_IRQ_POLARITY_SHIFT   8
#define GIS_CTRL_TOG_CLKGATE_MASK                0x40000000u
#define GIS_CTRL_TOG_CLKGATE_SHIFT               30
#define GIS_CTRL_TOG_SFTRST_MASK                 0x80000000u
#define GIS_CTRL_TOG_SFTRST_SHIFT                31
/* CONFIG0 Bit Fields */
#define GIS_CONFIG0_CH0_MAPPING_MASK             0x7u
#define GIS_CONFIG0_CH0_MAPPING_SHIFT            0
#define GIS_CONFIG0_CH0_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH0_MAPPING_SHIFT))&GIS_CONFIG0_CH0_MAPPING_MASK)
#define GIS_CONFIG0_CH0_NUM_MASK                 0x38u
#define GIS_CONFIG0_CH0_NUM_SHIFT                3
#define GIS_CONFIG0_CH0_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH0_NUM_SHIFT))&GIS_CONFIG0_CH0_NUM_MASK)
#define GIS_CONFIG0_CH1_MAPPING_MASK             0x700u
#define GIS_CONFIG0_CH1_MAPPING_SHIFT            8
#define GIS_CONFIG0_CH1_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH1_MAPPING_SHIFT))&GIS_CONFIG0_CH1_MAPPING_MASK)
#define GIS_CONFIG0_CH1_NUM_MASK                 0x3800u
#define GIS_CONFIG0_CH1_NUM_SHIFT                11
#define GIS_CONFIG0_CH1_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH1_NUM_SHIFT))&GIS_CONFIG0_CH1_NUM_MASK)
#define GIS_CONFIG0_CH2_MAPPING_MASK             0x70000u
#define GIS_CONFIG0_CH2_MAPPING_SHIFT            16
#define GIS_CONFIG0_CH2_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH2_MAPPING_SHIFT))&GIS_CONFIG0_CH2_MAPPING_MASK)
#define GIS_CONFIG0_CH2_NUM_MASK                 0x380000u
#define GIS_CONFIG0_CH2_NUM_SHIFT                19
#define GIS_CONFIG0_CH2_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH2_NUM_SHIFT))&GIS_CONFIG0_CH2_NUM_MASK)
#define GIS_CONFIG0_CH3_MAPPING_MASK             0x7000000u
#define GIS_CONFIG0_CH3_MAPPING_SHIFT            24
#define GIS_CONFIG0_CH3_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH3_MAPPING_SHIFT))&GIS_CONFIG0_CH3_MAPPING_MASK)
#define GIS_CONFIG0_CH3_NUM_MASK                 0x38000000u
#define GIS_CONFIG0_CH3_NUM_SHIFT                27
#define GIS_CONFIG0_CH3_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CH3_NUM_SHIFT))&GIS_CONFIG0_CH3_NUM_MASK)
/* CONFIG0_SET Bit Fields */
#define GIS_CONFIG0_SET_CH0_MAPPING_MASK         0x7u
#define GIS_CONFIG0_SET_CH0_MAPPING_SHIFT        0
#define GIS_CONFIG0_SET_CH0_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH0_MAPPING_SHIFT))&GIS_CONFIG0_SET_CH0_MAPPING_MASK)
#define GIS_CONFIG0_SET_CH0_NUM_MASK             0x38u
#define GIS_CONFIG0_SET_CH0_NUM_SHIFT            3
#define GIS_CONFIG0_SET_CH0_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH0_NUM_SHIFT))&GIS_CONFIG0_SET_CH0_NUM_MASK)
#define GIS_CONFIG0_SET_CH1_MAPPING_MASK         0x700u
#define GIS_CONFIG0_SET_CH1_MAPPING_SHIFT        8
#define GIS_CONFIG0_SET_CH1_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH1_MAPPING_SHIFT))&GIS_CONFIG0_SET_CH1_MAPPING_MASK)
#define GIS_CONFIG0_SET_CH1_NUM_MASK             0x3800u
#define GIS_CONFIG0_SET_CH1_NUM_SHIFT            11
#define GIS_CONFIG0_SET_CH1_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH1_NUM_SHIFT))&GIS_CONFIG0_SET_CH1_NUM_MASK)
#define GIS_CONFIG0_SET_CH2_MAPPING_MASK         0x70000u
#define GIS_CONFIG0_SET_CH2_MAPPING_SHIFT        16
#define GIS_CONFIG0_SET_CH2_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH2_MAPPING_SHIFT))&GIS_CONFIG0_SET_CH2_MAPPING_MASK)
#define GIS_CONFIG0_SET_CH2_NUM_MASK             0x380000u
#define GIS_CONFIG0_SET_CH2_NUM_SHIFT            19
#define GIS_CONFIG0_SET_CH2_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH2_NUM_SHIFT))&GIS_CONFIG0_SET_CH2_NUM_MASK)
#define GIS_CONFIG0_SET_CH3_MAPPING_MASK         0x7000000u
#define GIS_CONFIG0_SET_CH3_MAPPING_SHIFT        24
#define GIS_CONFIG0_SET_CH3_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH3_MAPPING_SHIFT))&GIS_CONFIG0_SET_CH3_MAPPING_MASK)
#define GIS_CONFIG0_SET_CH3_NUM_MASK             0x38000000u
#define GIS_CONFIG0_SET_CH3_NUM_SHIFT            27
#define GIS_CONFIG0_SET_CH3_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_SET_CH3_NUM_SHIFT))&GIS_CONFIG0_SET_CH3_NUM_MASK)
/* CONFIG0_CLR Bit Fields */
#define GIS_CONFIG0_CLR_CH0_MAPPING_MASK         0x7u
#define GIS_CONFIG0_CLR_CH0_MAPPING_SHIFT        0
#define GIS_CONFIG0_CLR_CH0_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH0_MAPPING_SHIFT))&GIS_CONFIG0_CLR_CH0_MAPPING_MASK)
#define GIS_CONFIG0_CLR_CH0_NUM_MASK             0x38u
#define GIS_CONFIG0_CLR_CH0_NUM_SHIFT            3
#define GIS_CONFIG0_CLR_CH0_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH0_NUM_SHIFT))&GIS_CONFIG0_CLR_CH0_NUM_MASK)
#define GIS_CONFIG0_CLR_CH1_MAPPING_MASK         0x700u
#define GIS_CONFIG0_CLR_CH1_MAPPING_SHIFT        8
#define GIS_CONFIG0_CLR_CH1_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH1_MAPPING_SHIFT))&GIS_CONFIG0_CLR_CH1_MAPPING_MASK)
#define GIS_CONFIG0_CLR_CH1_NUM_MASK             0x3800u
#define GIS_CONFIG0_CLR_CH1_NUM_SHIFT            11
#define GIS_CONFIG0_CLR_CH1_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH1_NUM_SHIFT))&GIS_CONFIG0_CLR_CH1_NUM_MASK)
#define GIS_CONFIG0_CLR_CH2_MAPPING_MASK         0x70000u
#define GIS_CONFIG0_CLR_CH2_MAPPING_SHIFT        16
#define GIS_CONFIG0_CLR_CH2_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH2_MAPPING_SHIFT))&GIS_CONFIG0_CLR_CH2_MAPPING_MASK)
#define GIS_CONFIG0_CLR_CH2_NUM_MASK             0x380000u
#define GIS_CONFIG0_CLR_CH2_NUM_SHIFT            19
#define GIS_CONFIG0_CLR_CH2_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH2_NUM_SHIFT))&GIS_CONFIG0_CLR_CH2_NUM_MASK)
#define GIS_CONFIG0_CLR_CH3_MAPPING_MASK         0x7000000u
#define GIS_CONFIG0_CLR_CH3_MAPPING_SHIFT        24
#define GIS_CONFIG0_CLR_CH3_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH3_MAPPING_SHIFT))&GIS_CONFIG0_CLR_CH3_MAPPING_MASK)
#define GIS_CONFIG0_CLR_CH3_NUM_MASK             0x38000000u
#define GIS_CONFIG0_CLR_CH3_NUM_SHIFT            27
#define GIS_CONFIG0_CLR_CH3_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_CLR_CH3_NUM_SHIFT))&GIS_CONFIG0_CLR_CH3_NUM_MASK)
/* CONFIG0_TOG Bit Fields */
#define GIS_CONFIG0_TOG_CH0_MAPPING_MASK         0x7u
#define GIS_CONFIG0_TOG_CH0_MAPPING_SHIFT        0
#define GIS_CONFIG0_TOG_CH0_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH0_MAPPING_SHIFT))&GIS_CONFIG0_TOG_CH0_MAPPING_MASK)
#define GIS_CONFIG0_TOG_CH0_NUM_MASK             0x38u
#define GIS_CONFIG0_TOG_CH0_NUM_SHIFT            3
#define GIS_CONFIG0_TOG_CH0_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH0_NUM_SHIFT))&GIS_CONFIG0_TOG_CH0_NUM_MASK)
#define GIS_CONFIG0_TOG_CH1_MAPPING_MASK         0x700u
#define GIS_CONFIG0_TOG_CH1_MAPPING_SHIFT        8
#define GIS_CONFIG0_TOG_CH1_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH1_MAPPING_SHIFT))&GIS_CONFIG0_TOG_CH1_MAPPING_MASK)
#define GIS_CONFIG0_TOG_CH1_NUM_MASK             0x3800u
#define GIS_CONFIG0_TOG_CH1_NUM_SHIFT            11
#define GIS_CONFIG0_TOG_CH1_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH1_NUM_SHIFT))&GIS_CONFIG0_TOG_CH1_NUM_MASK)
#define GIS_CONFIG0_TOG_CH2_MAPPING_MASK         0x70000u
#define GIS_CONFIG0_TOG_CH2_MAPPING_SHIFT        16
#define GIS_CONFIG0_TOG_CH2_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH2_MAPPING_SHIFT))&GIS_CONFIG0_TOG_CH2_MAPPING_MASK)
#define GIS_CONFIG0_TOG_CH2_NUM_MASK             0x380000u
#define GIS_CONFIG0_TOG_CH2_NUM_SHIFT            19
#define GIS_CONFIG0_TOG_CH2_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH2_NUM_SHIFT))&GIS_CONFIG0_TOG_CH2_NUM_MASK)
#define GIS_CONFIG0_TOG_CH3_MAPPING_MASK         0x7000000u
#define GIS_CONFIG0_TOG_CH3_MAPPING_SHIFT        24
#define GIS_CONFIG0_TOG_CH3_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH3_MAPPING_SHIFT))&GIS_CONFIG0_TOG_CH3_MAPPING_MASK)
#define GIS_CONFIG0_TOG_CH3_NUM_MASK             0x38000000u
#define GIS_CONFIG0_TOG_CH3_NUM_SHIFT            27
#define GIS_CONFIG0_TOG_CH3_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG0_TOG_CH3_NUM_SHIFT))&GIS_CONFIG0_TOG_CH3_NUM_MASK)
/* CONFIG1 Bit Fields */
#define GIS_CONFIG1_CH4_MAPPING_MASK             0x7u
#define GIS_CONFIG1_CH4_MAPPING_SHIFT            0
#define GIS_CONFIG1_CH4_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CH4_MAPPING_SHIFT))&GIS_CONFIG1_CH4_MAPPING_MASK)
#define GIS_CONFIG1_CH4_NUM_MASK                 0x38u
#define GIS_CONFIG1_CH4_NUM_SHIFT                3
#define GIS_CONFIG1_CH4_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CH4_NUM_SHIFT))&GIS_CONFIG1_CH4_NUM_MASK)
#define GIS_CONFIG1_CH5_MAPPING_MASK             0x700u
#define GIS_CONFIG1_CH5_MAPPING_SHIFT            8
#define GIS_CONFIG1_CH5_MAPPING(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CH5_MAPPING_SHIFT))&GIS_CONFIG1_CH5_MAPPING_MASK)
#define GIS_CONFIG1_CH5_NUM_MASK                 0x3800u
#define GIS_CONFIG1_CH5_NUM_SHIFT                11
#define GIS_CONFIG1_CH5_NUM(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CH5_NUM_SHIFT))&GIS_CONFIG1_CH5_NUM_MASK)
/* CONFIG1_SET Bit Fields */
#define GIS_CONFIG1_SET_CH4_MAPPING_MASK         0x7u
#define GIS_CONFIG1_SET_CH4_MAPPING_SHIFT        0
#define GIS_CONFIG1_SET_CH4_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_SET_CH4_MAPPING_SHIFT))&GIS_CONFIG1_SET_CH4_MAPPING_MASK)
#define GIS_CONFIG1_SET_CH4_NUM_MASK             0x38u
#define GIS_CONFIG1_SET_CH4_NUM_SHIFT            3
#define GIS_CONFIG1_SET_CH4_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_SET_CH4_NUM_SHIFT))&GIS_CONFIG1_SET_CH4_NUM_MASK)
#define GIS_CONFIG1_SET_CH5_MAPPING_MASK         0x700u
#define GIS_CONFIG1_SET_CH5_MAPPING_SHIFT        8
#define GIS_CONFIG1_SET_CH5_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_SET_CH5_MAPPING_SHIFT))&GIS_CONFIG1_SET_CH5_MAPPING_MASK)
#define GIS_CONFIG1_SET_CH5_NUM_MASK             0x3800u
#define GIS_CONFIG1_SET_CH5_NUM_SHIFT            11
#define GIS_CONFIG1_SET_CH5_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_SET_CH5_NUM_SHIFT))&GIS_CONFIG1_SET_CH5_NUM_MASK)
/* CONFIG1_CLR Bit Fields */
#define GIS_CONFIG1_CLR_CH4_MAPPING_MASK         0x7u
#define GIS_CONFIG1_CLR_CH4_MAPPING_SHIFT        0
#define GIS_CONFIG1_CLR_CH4_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CLR_CH4_MAPPING_SHIFT))&GIS_CONFIG1_CLR_CH4_MAPPING_MASK)
#define GIS_CONFIG1_CLR_CH4_NUM_MASK             0x38u
#define GIS_CONFIG1_CLR_CH4_NUM_SHIFT            3
#define GIS_CONFIG1_CLR_CH4_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CLR_CH4_NUM_SHIFT))&GIS_CONFIG1_CLR_CH4_NUM_MASK)
#define GIS_CONFIG1_CLR_CH5_MAPPING_MASK         0x700u
#define GIS_CONFIG1_CLR_CH5_MAPPING_SHIFT        8
#define GIS_CONFIG1_CLR_CH5_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CLR_CH5_MAPPING_SHIFT))&GIS_CONFIG1_CLR_CH5_MAPPING_MASK)
#define GIS_CONFIG1_CLR_CH5_NUM_MASK             0x3800u
#define GIS_CONFIG1_CLR_CH5_NUM_SHIFT            11
#define GIS_CONFIG1_CLR_CH5_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_CLR_CH5_NUM_SHIFT))&GIS_CONFIG1_CLR_CH5_NUM_MASK)
/* CONFIG1_TOG Bit Fields */
#define GIS_CONFIG1_TOG_CH4_MAPPING_MASK         0x7u
#define GIS_CONFIG1_TOG_CH4_MAPPING_SHIFT        0
#define GIS_CONFIG1_TOG_CH4_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_TOG_CH4_MAPPING_SHIFT))&GIS_CONFIG1_TOG_CH4_MAPPING_MASK)
#define GIS_CONFIG1_TOG_CH4_NUM_MASK             0x38u
#define GIS_CONFIG1_TOG_CH4_NUM_SHIFT            3
#define GIS_CONFIG1_TOG_CH4_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_TOG_CH4_NUM_SHIFT))&GIS_CONFIG1_TOG_CH4_NUM_MASK)
#define GIS_CONFIG1_TOG_CH5_MAPPING_MASK         0x700u
#define GIS_CONFIG1_TOG_CH5_MAPPING_SHIFT        8
#define GIS_CONFIG1_TOG_CH5_MAPPING(x)           (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_TOG_CH5_MAPPING_SHIFT))&GIS_CONFIG1_TOG_CH5_MAPPING_MASK)
#define GIS_CONFIG1_TOG_CH5_NUM_MASK             0x3800u
#define GIS_CONFIG1_TOG_CH5_NUM_SHIFT            11
#define GIS_CONFIG1_TOG_CH5_NUM(x)               (((uint32_t)(((uint32_t)(x))<<GIS_CONFIG1_TOG_CH5_NUM_SHIFT))&GIS_CONFIG1_TOG_CH5_NUM_MASK)
/* FB0 Bit Fields */
#define GIS_FB0_ADDR_MASK                        0xFFFFFFFFu
#define GIS_FB0_ADDR_SHIFT                       0
#define GIS_FB0_ADDR(x)                          (((uint32_t)(((uint32_t)(x))<<GIS_FB0_ADDR_SHIFT))&GIS_FB0_ADDR_MASK)
/* FB1 Bit Fields */
#define GIS_FB1_ADDR_MASK                        0xFFFFFFFFu
#define GIS_FB1_ADDR_SHIFT                       0
#define GIS_FB1_ADDR(x)                          (((uint32_t)(((uint32_t)(x))<<GIS_FB1_ADDR_SHIFT))&GIS_FB1_ADDR_MASK)
/* PXP_FB0 Bit Fields */
#define GIS_PXP_FB0_ADDR_MASK                    0xFFFFFFFFu
#define GIS_PXP_FB0_ADDR_SHIFT                   0
#define GIS_PXP_FB0_ADDR(x)                      (((uint32_t)(((uint32_t)(x))<<GIS_PXP_FB0_ADDR_SHIFT))&GIS_PXP_FB0_ADDR_MASK)
/* PXP_FB1 Bit Fields */
#define GIS_PXP_FB1_ADDR_MASK                    0xFFFFFFFFu
#define GIS_PXP_FB1_ADDR_SHIFT                   0
#define GIS_PXP_FB1_ADDR(x)                      (((uint32_t)(((uint32_t)(x))<<GIS_PXP_FB1_ADDR_SHIFT))&GIS_PXP_FB1_ADDR_MASK)
/* CH0_CTRL Bit Fields */
#define GIS_CH0_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH0_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH0_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH0_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH0_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH0_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH0_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD0_ALU_SHIFT))&GIS_CH0_CTRL_CMD0_ALU_MASK)
#define GIS_CH0_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH0_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH0_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH0_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH0_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH0_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH0_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH0_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH0_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD1_ALU_SHIFT))&GIS_CH0_CTRL_CMD1_ALU_MASK)
#define GIS_CH0_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH0_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH0_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH0_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH0_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH0_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH0_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH0_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH0_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD2_ALU_SHIFT))&GIS_CH0_CTRL_CMD2_ALU_MASK)
#define GIS_CH0_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH0_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH0_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH0_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH0_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH0_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH0_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH0_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH0_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CMD3_ALU_SHIFT))&GIS_CH0_CTRL_CMD3_ALU_MASK)
#define GIS_CH0_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH0_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH0_CTRL_SET Bit Fields */
#define GIS_CH0_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH0_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH0_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH0_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH0_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH0_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH0_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH0_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH0_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH0_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH0_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH0_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH0_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH0_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH0_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH0_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH0_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH0_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH0_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH0_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH0_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH0_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH0_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH0_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH0_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH0_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH0_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH0_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH0_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH0_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH0_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH0_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH0_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH0_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH0_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH0_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH0_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH0_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH0_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH0_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH0_CTRL_CLR Bit Fields */
#define GIS_CH0_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH0_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH0_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH0_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH0_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH0_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH0_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH0_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH0_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH0_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH0_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH0_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH0_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH0_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH0_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH0_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH0_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH0_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH0_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH0_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH0_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH0_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH0_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH0_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH0_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH0_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH0_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH0_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH0_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH0_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH0_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH0_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH0_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH0_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH0_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH0_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH0_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH0_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH0_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH0_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH0_CTRL_TOG Bit Fields */
#define GIS_CH0_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH0_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH0_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH0_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH0_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH0_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH0_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH0_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH0_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH0_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH0_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH0_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH0_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH0_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH0_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH0_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH0_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH0_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH0_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH0_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH0_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH0_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH0_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH0_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH0_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH0_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH0_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH0_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH0_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH0_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH0_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH0_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH0_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH0_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH0_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH0_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH0_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH0_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH0_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH0_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH0_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH0_ADDR0 Bit Fields */
#define GIS_CH0_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH0_ADDR0_ADDR_SHIFT                 0
#define GIS_CH0_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR0_ADDR_SHIFT))&GIS_CH0_ADDR0_ADDR_MASK)
#define GIS_CH0_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH0_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH0_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH0_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH0_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH0_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH0_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH0_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH0_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH0_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH0_ADDR0_SET Bit Fields */
#define GIS_CH0_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH0_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR0_SET_ADDR_SHIFT))&GIS_CH0_ADDR0_SET_ADDR_MASK)
#define GIS_CH0_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR0_CLR Bit Fields */
#define GIS_CH0_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH0_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR0_CLR_ADDR_SHIFT))&GIS_CH0_ADDR0_CLR_ADDR_MASK)
#define GIS_CH0_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR0_TOG Bit Fields */
#define GIS_CH0_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH0_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR0_TOG_ADDR_SHIFT))&GIS_CH0_ADDR0_TOG_ADDR_MASK)
#define GIS_CH0_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH0_DATA0 Bit Fields */
#define GIS_CH0_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH0_DATA0_DATA_SHIFT                 0
#define GIS_CH0_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_DATA0_DATA_SHIFT))&GIS_CH0_DATA0_DATA_MASK)
/* CH0_ADDR1 Bit Fields */
#define GIS_CH0_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH0_ADDR1_ADDR_SHIFT                 0
#define GIS_CH0_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR1_ADDR_SHIFT))&GIS_CH0_ADDR1_ADDR_MASK)
#define GIS_CH0_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH0_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH0_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH0_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH0_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH0_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH0_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH0_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH0_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH0_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH0_ADDR1_SET Bit Fields */
#define GIS_CH0_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH0_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR1_SET_ADDR_SHIFT))&GIS_CH0_ADDR1_SET_ADDR_MASK)
#define GIS_CH0_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR1_CLR Bit Fields */
#define GIS_CH0_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH0_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR1_CLR_ADDR_SHIFT))&GIS_CH0_ADDR1_CLR_ADDR_MASK)
#define GIS_CH0_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR1_TOG Bit Fields */
#define GIS_CH0_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH0_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR1_TOG_ADDR_SHIFT))&GIS_CH0_ADDR1_TOG_ADDR_MASK)
#define GIS_CH0_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH0_DATA1 Bit Fields */
#define GIS_CH0_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH0_DATA1_DATA_SHIFT                 0
#define GIS_CH0_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_DATA1_DATA_SHIFT))&GIS_CH0_DATA1_DATA_MASK)
/* CH0_ADDR2 Bit Fields */
#define GIS_CH0_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH0_ADDR2_ADDR_SHIFT                 0
#define GIS_CH0_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR2_ADDR_SHIFT))&GIS_CH0_ADDR2_ADDR_MASK)
#define GIS_CH0_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH0_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH0_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH0_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH0_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH0_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH0_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH0_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH0_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH0_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH0_ADDR2_SET Bit Fields */
#define GIS_CH0_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH0_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR2_SET_ADDR_SHIFT))&GIS_CH0_ADDR2_SET_ADDR_MASK)
#define GIS_CH0_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR2_CLR Bit Fields */
#define GIS_CH0_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH0_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR2_CLR_ADDR_SHIFT))&GIS_CH0_ADDR2_CLR_ADDR_MASK)
#define GIS_CH0_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR2_TOG Bit Fields */
#define GIS_CH0_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH0_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR2_TOG_ADDR_SHIFT))&GIS_CH0_ADDR2_TOG_ADDR_MASK)
#define GIS_CH0_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH0_DATA2 Bit Fields */
#define GIS_CH0_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH0_DATA2_DATA_SHIFT                 0
#define GIS_CH0_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_DATA2_DATA_SHIFT))&GIS_CH0_DATA2_DATA_MASK)
/* CH0_ADDR3 Bit Fields */
#define GIS_CH0_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH0_ADDR3_ADDR_SHIFT                 0
#define GIS_CH0_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR3_ADDR_SHIFT))&GIS_CH0_ADDR3_ADDR_MASK)
#define GIS_CH0_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH0_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH0_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH0_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH0_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH0_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH0_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH0_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH0_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH0_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH0_ADDR3_SET Bit Fields */
#define GIS_CH0_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH0_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR3_SET_ADDR_SHIFT))&GIS_CH0_ADDR3_SET_ADDR_MASK)
#define GIS_CH0_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR3_CLR Bit Fields */
#define GIS_CH0_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH0_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR3_CLR_ADDR_SHIFT))&GIS_CH0_ADDR3_CLR_ADDR_MASK)
#define GIS_CH0_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH0_ADDR3_TOG Bit Fields */
#define GIS_CH0_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH0_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH0_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH0_ADDR3_TOG_ADDR_SHIFT))&GIS_CH0_ADDR3_TOG_ADDR_MASK)
#define GIS_CH0_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH0_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH0_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH0_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH0_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH0_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH0_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH0_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH0_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH0_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH0_DATA3 Bit Fields */
#define GIS_CH0_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH0_DATA3_DATA_SHIFT                 0
#define GIS_CH0_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH0_DATA3_DATA_SHIFT))&GIS_CH0_DATA3_DATA_MASK)
/* CH1_CTRL Bit Fields */
#define GIS_CH1_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH1_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH1_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH1_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH1_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH1_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH1_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD0_ALU_SHIFT))&GIS_CH1_CTRL_CMD0_ALU_MASK)
#define GIS_CH1_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH1_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH1_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH1_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH1_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH1_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH1_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH1_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH1_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD1_ALU_SHIFT))&GIS_CH1_CTRL_CMD1_ALU_MASK)
#define GIS_CH1_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH1_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH1_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH1_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH1_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH1_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH1_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH1_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH1_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD2_ALU_SHIFT))&GIS_CH1_CTRL_CMD2_ALU_MASK)
#define GIS_CH1_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH1_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH1_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH1_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH1_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH1_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH1_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH1_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH1_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CMD3_ALU_SHIFT))&GIS_CH1_CTRL_CMD3_ALU_MASK)
#define GIS_CH1_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH1_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH1_CTRL_SET Bit Fields */
#define GIS_CH1_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH1_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH1_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH1_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH1_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH1_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH1_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH1_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH1_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH1_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH1_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH1_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH1_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH1_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH1_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH1_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH1_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH1_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH1_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH1_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH1_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH1_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH1_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH1_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH1_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH1_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH1_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH1_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH1_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH1_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH1_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH1_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH1_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH1_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH1_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH1_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH1_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH1_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH1_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH1_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH1_CTRL_CLR Bit Fields */
#define GIS_CH1_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH1_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH1_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH1_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH1_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH1_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH1_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH1_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH1_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH1_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH1_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH1_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH1_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH1_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH1_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH1_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH1_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH1_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH1_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH1_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH1_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH1_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH1_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH1_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH1_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH1_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH1_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH1_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH1_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH1_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH1_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH1_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH1_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH1_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH1_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH1_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH1_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH1_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH1_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH1_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH1_CTRL_TOG Bit Fields */
#define GIS_CH1_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH1_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH1_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH1_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH1_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH1_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH1_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH1_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH1_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH1_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH1_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH1_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH1_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH1_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH1_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH1_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH1_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH1_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH1_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH1_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH1_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH1_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH1_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH1_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH1_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH1_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH1_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH1_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH1_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH1_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH1_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH1_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH1_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH1_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH1_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH1_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH1_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH1_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH1_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH1_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH1_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH1_ADDR0 Bit Fields */
#define GIS_CH1_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH1_ADDR0_ADDR_SHIFT                 0
#define GIS_CH1_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR0_ADDR_SHIFT))&GIS_CH1_ADDR0_ADDR_MASK)
#define GIS_CH1_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH1_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH1_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH1_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH1_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH1_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH1_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH1_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH1_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH1_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH1_ADDR0_SET Bit Fields */
#define GIS_CH1_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH1_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR0_SET_ADDR_SHIFT))&GIS_CH1_ADDR0_SET_ADDR_MASK)
#define GIS_CH1_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR0_CLR Bit Fields */
#define GIS_CH1_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH1_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR0_CLR_ADDR_SHIFT))&GIS_CH1_ADDR0_CLR_ADDR_MASK)
#define GIS_CH1_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR0_TOG Bit Fields */
#define GIS_CH1_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH1_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR0_TOG_ADDR_SHIFT))&GIS_CH1_ADDR0_TOG_ADDR_MASK)
#define GIS_CH1_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH1_DATA0 Bit Fields */
#define GIS_CH1_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH1_DATA0_DATA_SHIFT                 0
#define GIS_CH1_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_DATA0_DATA_SHIFT))&GIS_CH1_DATA0_DATA_MASK)
/* CH1_ADDR1 Bit Fields */
#define GIS_CH1_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH1_ADDR1_ADDR_SHIFT                 0
#define GIS_CH1_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR1_ADDR_SHIFT))&GIS_CH1_ADDR1_ADDR_MASK)
#define GIS_CH1_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH1_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH1_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH1_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH1_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH1_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH1_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH1_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH1_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH1_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH1_ADDR1_SET Bit Fields */
#define GIS_CH1_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH1_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR1_SET_ADDR_SHIFT))&GIS_CH1_ADDR1_SET_ADDR_MASK)
#define GIS_CH1_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR1_CLR Bit Fields */
#define GIS_CH1_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH1_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR1_CLR_ADDR_SHIFT))&GIS_CH1_ADDR1_CLR_ADDR_MASK)
#define GIS_CH1_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR1_TOG Bit Fields */
#define GIS_CH1_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH1_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR1_TOG_ADDR_SHIFT))&GIS_CH1_ADDR1_TOG_ADDR_MASK)
#define GIS_CH1_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH1_DATA1 Bit Fields */
#define GIS_CH1_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH1_DATA1_DATA_SHIFT                 0
#define GIS_CH1_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_DATA1_DATA_SHIFT))&GIS_CH1_DATA1_DATA_MASK)
/* CH1_ADDR2 Bit Fields */
#define GIS_CH1_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH1_ADDR2_ADDR_SHIFT                 0
#define GIS_CH1_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR2_ADDR_SHIFT))&GIS_CH1_ADDR2_ADDR_MASK)
#define GIS_CH1_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH1_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH1_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH1_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH1_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH1_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH1_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH1_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH1_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH1_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH1_ADDR2_SET Bit Fields */
#define GIS_CH1_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH1_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR2_SET_ADDR_SHIFT))&GIS_CH1_ADDR2_SET_ADDR_MASK)
#define GIS_CH1_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR2_CLR Bit Fields */
#define GIS_CH1_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH1_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR2_CLR_ADDR_SHIFT))&GIS_CH1_ADDR2_CLR_ADDR_MASK)
#define GIS_CH1_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR2_TOG Bit Fields */
#define GIS_CH1_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH1_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR2_TOG_ADDR_SHIFT))&GIS_CH1_ADDR2_TOG_ADDR_MASK)
#define GIS_CH1_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH1_DATA2 Bit Fields */
#define GIS_CH1_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH1_DATA2_DATA_SHIFT                 0
#define GIS_CH1_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_DATA2_DATA_SHIFT))&GIS_CH1_DATA2_DATA_MASK)
/* CH1_ADDR3 Bit Fields */
#define GIS_CH1_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH1_ADDR3_ADDR_SHIFT                 0
#define GIS_CH1_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR3_ADDR_SHIFT))&GIS_CH1_ADDR3_ADDR_MASK)
#define GIS_CH1_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH1_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH1_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH1_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH1_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH1_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH1_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH1_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH1_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH1_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH1_ADDR3_SET Bit Fields */
#define GIS_CH1_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH1_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR3_SET_ADDR_SHIFT))&GIS_CH1_ADDR3_SET_ADDR_MASK)
#define GIS_CH1_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR3_CLR Bit Fields */
#define GIS_CH1_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH1_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR3_CLR_ADDR_SHIFT))&GIS_CH1_ADDR3_CLR_ADDR_MASK)
#define GIS_CH1_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH1_ADDR3_TOG Bit Fields */
#define GIS_CH1_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH1_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH1_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH1_ADDR3_TOG_ADDR_SHIFT))&GIS_CH1_ADDR3_TOG_ADDR_MASK)
#define GIS_CH1_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH1_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH1_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH1_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH1_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH1_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH1_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH1_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH1_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH1_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH1_DATA3 Bit Fields */
#define GIS_CH1_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH1_DATA3_DATA_SHIFT                 0
#define GIS_CH1_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH1_DATA3_DATA_SHIFT))&GIS_CH1_DATA3_DATA_MASK)
/* CH2_CTRL Bit Fields */
#define GIS_CH2_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH2_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH2_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH2_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH2_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH2_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH2_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD0_ALU_SHIFT))&GIS_CH2_CTRL_CMD0_ALU_MASK)
#define GIS_CH2_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH2_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH2_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH2_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH2_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH2_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH2_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH2_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH2_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD1_ALU_SHIFT))&GIS_CH2_CTRL_CMD1_ALU_MASK)
#define GIS_CH2_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH2_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH2_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH2_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH2_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH2_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH2_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH2_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH2_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD2_ALU_SHIFT))&GIS_CH2_CTRL_CMD2_ALU_MASK)
#define GIS_CH2_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH2_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH2_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH2_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH2_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH2_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH2_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH2_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH2_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CMD3_ALU_SHIFT))&GIS_CH2_CTRL_CMD3_ALU_MASK)
#define GIS_CH2_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH2_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH2_CTRL_SET Bit Fields */
#define GIS_CH2_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH2_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH2_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH2_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH2_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH2_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH2_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH2_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH2_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH2_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH2_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH2_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH2_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH2_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH2_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH2_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH2_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH2_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH2_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH2_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH2_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH2_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH2_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH2_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH2_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH2_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH2_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH2_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH2_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH2_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH2_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH2_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH2_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH2_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH2_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH2_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH2_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH2_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH2_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH2_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH2_CTRL_CLR Bit Fields */
#define GIS_CH2_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH2_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH2_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH2_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH2_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH2_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH2_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH2_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH2_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH2_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH2_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH2_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH2_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH2_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH2_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH2_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH2_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH2_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH2_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH2_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH2_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH2_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH2_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH2_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH2_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH2_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH2_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH2_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH2_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH2_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH2_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH2_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH2_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH2_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH2_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH2_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH2_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH2_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH2_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH2_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH2_CTRL_TOG Bit Fields */
#define GIS_CH2_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH2_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH2_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH2_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH2_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH2_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH2_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH2_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH2_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH2_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH2_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH2_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH2_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH2_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH2_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH2_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH2_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH2_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH2_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH2_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH2_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH2_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH2_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH2_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH2_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH2_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH2_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH2_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH2_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH2_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH2_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH2_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH2_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH2_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH2_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH2_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH2_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH2_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH2_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH2_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH2_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH2_ADDR0 Bit Fields */
#define GIS_CH2_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH2_ADDR0_ADDR_SHIFT                 0
#define GIS_CH2_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR0_ADDR_SHIFT))&GIS_CH2_ADDR0_ADDR_MASK)
#define GIS_CH2_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH2_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH2_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH2_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH2_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH2_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH2_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH2_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH2_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH2_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH2_ADDR0_SET Bit Fields */
#define GIS_CH2_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH2_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR0_SET_ADDR_SHIFT))&GIS_CH2_ADDR0_SET_ADDR_MASK)
#define GIS_CH2_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR0_CLR Bit Fields */
#define GIS_CH2_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH2_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR0_CLR_ADDR_SHIFT))&GIS_CH2_ADDR0_CLR_ADDR_MASK)
#define GIS_CH2_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR0_TOG Bit Fields */
#define GIS_CH2_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH2_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR0_TOG_ADDR_SHIFT))&GIS_CH2_ADDR0_TOG_ADDR_MASK)
#define GIS_CH2_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH2_DATA0 Bit Fields */
#define GIS_CH2_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH2_DATA0_DATA_SHIFT                 0
#define GIS_CH2_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_DATA0_DATA_SHIFT))&GIS_CH2_DATA0_DATA_MASK)
/* CH2_ADDR1 Bit Fields */
#define GIS_CH2_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH2_ADDR1_ADDR_SHIFT                 0
#define GIS_CH2_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR1_ADDR_SHIFT))&GIS_CH2_ADDR1_ADDR_MASK)
#define GIS_CH2_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH2_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH2_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH2_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH2_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH2_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH2_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH2_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH2_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH2_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH2_ADDR1_SET Bit Fields */
#define GIS_CH2_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH2_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR1_SET_ADDR_SHIFT))&GIS_CH2_ADDR1_SET_ADDR_MASK)
#define GIS_CH2_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR1_CLR Bit Fields */
#define GIS_CH2_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH2_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR1_CLR_ADDR_SHIFT))&GIS_CH2_ADDR1_CLR_ADDR_MASK)
#define GIS_CH2_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR1_TOG Bit Fields */
#define GIS_CH2_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH2_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR1_TOG_ADDR_SHIFT))&GIS_CH2_ADDR1_TOG_ADDR_MASK)
#define GIS_CH2_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH2_DATA1 Bit Fields */
#define GIS_CH2_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH2_DATA1_DATA_SHIFT                 0
#define GIS_CH2_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_DATA1_DATA_SHIFT))&GIS_CH2_DATA1_DATA_MASK)
/* CH2_ADDR2 Bit Fields */
#define GIS_CH2_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH2_ADDR2_ADDR_SHIFT                 0
#define GIS_CH2_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR2_ADDR_SHIFT))&GIS_CH2_ADDR2_ADDR_MASK)
#define GIS_CH2_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH2_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH2_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH2_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH2_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH2_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH2_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH2_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH2_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH2_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH2_ADDR2_SET Bit Fields */
#define GIS_CH2_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH2_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR2_SET_ADDR_SHIFT))&GIS_CH2_ADDR2_SET_ADDR_MASK)
#define GIS_CH2_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR2_CLR Bit Fields */
#define GIS_CH2_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH2_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR2_CLR_ADDR_SHIFT))&GIS_CH2_ADDR2_CLR_ADDR_MASK)
#define GIS_CH2_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR2_TOG Bit Fields */
#define GIS_CH2_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH2_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR2_TOG_ADDR_SHIFT))&GIS_CH2_ADDR2_TOG_ADDR_MASK)
#define GIS_CH2_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH2_DATA2 Bit Fields */
#define GIS_CH2_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH2_DATA2_DATA_SHIFT                 0
#define GIS_CH2_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_DATA2_DATA_SHIFT))&GIS_CH2_DATA2_DATA_MASK)
/* CH2_ADDR3 Bit Fields */
#define GIS_CH2_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH2_ADDR3_ADDR_SHIFT                 0
#define GIS_CH2_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR3_ADDR_SHIFT))&GIS_CH2_ADDR3_ADDR_MASK)
#define GIS_CH2_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH2_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH2_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH2_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH2_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH2_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH2_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH2_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH2_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH2_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH2_ADDR3_SET Bit Fields */
#define GIS_CH2_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH2_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR3_SET_ADDR_SHIFT))&GIS_CH2_ADDR3_SET_ADDR_MASK)
#define GIS_CH2_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR3_CLR Bit Fields */
#define GIS_CH2_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH2_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR3_CLR_ADDR_SHIFT))&GIS_CH2_ADDR3_CLR_ADDR_MASK)
#define GIS_CH2_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH2_ADDR3_TOG Bit Fields */
#define GIS_CH2_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH2_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH2_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH2_ADDR3_TOG_ADDR_SHIFT))&GIS_CH2_ADDR3_TOG_ADDR_MASK)
#define GIS_CH2_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH2_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH2_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH2_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH2_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH2_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH2_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH2_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH2_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH2_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH2_DATA3 Bit Fields */
#define GIS_CH2_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH2_DATA3_DATA_SHIFT                 0
#define GIS_CH2_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH2_DATA3_DATA_SHIFT))&GIS_CH2_DATA3_DATA_MASK)
/* CH3_CTRL Bit Fields */
#define GIS_CH3_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH3_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH3_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH3_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH3_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH3_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH3_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD0_ALU_SHIFT))&GIS_CH3_CTRL_CMD0_ALU_MASK)
#define GIS_CH3_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH3_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH3_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH3_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH3_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH3_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH3_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH3_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH3_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD1_ALU_SHIFT))&GIS_CH3_CTRL_CMD1_ALU_MASK)
#define GIS_CH3_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH3_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH3_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH3_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH3_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH3_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH3_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH3_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH3_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD2_ALU_SHIFT))&GIS_CH3_CTRL_CMD2_ALU_MASK)
#define GIS_CH3_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH3_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH3_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH3_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH3_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH3_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH3_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH3_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH3_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CMD3_ALU_SHIFT))&GIS_CH3_CTRL_CMD3_ALU_MASK)
#define GIS_CH3_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH3_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH3_CTRL_SET Bit Fields */
#define GIS_CH3_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH3_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH3_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH3_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH3_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH3_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH3_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH3_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH3_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH3_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH3_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH3_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH3_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH3_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH3_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH3_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH3_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH3_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH3_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH3_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH3_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH3_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH3_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH3_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH3_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH3_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH3_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH3_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH3_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH3_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH3_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH3_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH3_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH3_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH3_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH3_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH3_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH3_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH3_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH3_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH3_CTRL_CLR Bit Fields */
#define GIS_CH3_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH3_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH3_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH3_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH3_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH3_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH3_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH3_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH3_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH3_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH3_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH3_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH3_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH3_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH3_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH3_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH3_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH3_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH3_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH3_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH3_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH3_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH3_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH3_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH3_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH3_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH3_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH3_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH3_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH3_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH3_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH3_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH3_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH3_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH3_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH3_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH3_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH3_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH3_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH3_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH3_CTRL_TOG Bit Fields */
#define GIS_CH3_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH3_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH3_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH3_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH3_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH3_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH3_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH3_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH3_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH3_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH3_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH3_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH3_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH3_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH3_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH3_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH3_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH3_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH3_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH3_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH3_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH3_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH3_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH3_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH3_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH3_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH3_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH3_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH3_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH3_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH3_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH3_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH3_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH3_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH3_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH3_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH3_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH3_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH3_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH3_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH3_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH3_ADDR0 Bit Fields */
#define GIS_CH3_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH3_ADDR0_ADDR_SHIFT                 0
#define GIS_CH3_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR0_ADDR_SHIFT))&GIS_CH3_ADDR0_ADDR_MASK)
#define GIS_CH3_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH3_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH3_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH3_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH3_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH3_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH3_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH3_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH3_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH3_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH3_ADDR0_SET Bit Fields */
#define GIS_CH3_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH3_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR0_SET_ADDR_SHIFT))&GIS_CH3_ADDR0_SET_ADDR_MASK)
#define GIS_CH3_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR0_CLR Bit Fields */
#define GIS_CH3_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH3_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR0_CLR_ADDR_SHIFT))&GIS_CH3_ADDR0_CLR_ADDR_MASK)
#define GIS_CH3_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR0_TOG Bit Fields */
#define GIS_CH3_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH3_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR0_TOG_ADDR_SHIFT))&GIS_CH3_ADDR0_TOG_ADDR_MASK)
#define GIS_CH3_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH3_DATA0 Bit Fields */
#define GIS_CH3_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH3_DATA0_DATA_SHIFT                 0
#define GIS_CH3_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_DATA0_DATA_SHIFT))&GIS_CH3_DATA0_DATA_MASK)
/* CH3_ADDR1 Bit Fields */
#define GIS_CH3_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH3_ADDR1_ADDR_SHIFT                 0
#define GIS_CH3_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR1_ADDR_SHIFT))&GIS_CH3_ADDR1_ADDR_MASK)
#define GIS_CH3_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH3_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH3_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH3_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH3_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH3_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH3_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH3_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH3_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH3_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH3_ADDR1_SET Bit Fields */
#define GIS_CH3_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH3_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR1_SET_ADDR_SHIFT))&GIS_CH3_ADDR1_SET_ADDR_MASK)
#define GIS_CH3_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR1_CLR Bit Fields */
#define GIS_CH3_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH3_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR1_CLR_ADDR_SHIFT))&GIS_CH3_ADDR1_CLR_ADDR_MASK)
#define GIS_CH3_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR1_TOG Bit Fields */
#define GIS_CH3_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH3_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR1_TOG_ADDR_SHIFT))&GIS_CH3_ADDR1_TOG_ADDR_MASK)
#define GIS_CH3_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH3_DATA1 Bit Fields */
#define GIS_CH3_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH3_DATA1_DATA_SHIFT                 0
#define GIS_CH3_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_DATA1_DATA_SHIFT))&GIS_CH3_DATA1_DATA_MASK)
/* CH3_ADDR2 Bit Fields */
#define GIS_CH3_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH3_ADDR2_ADDR_SHIFT                 0
#define GIS_CH3_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR2_ADDR_SHIFT))&GIS_CH3_ADDR2_ADDR_MASK)
#define GIS_CH3_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH3_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH3_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH3_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH3_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH3_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH3_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH3_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH3_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH3_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH3_ADDR2_SET Bit Fields */
#define GIS_CH3_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH3_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR2_SET_ADDR_SHIFT))&GIS_CH3_ADDR2_SET_ADDR_MASK)
#define GIS_CH3_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR2_CLR Bit Fields */
#define GIS_CH3_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH3_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR2_CLR_ADDR_SHIFT))&GIS_CH3_ADDR2_CLR_ADDR_MASK)
#define GIS_CH3_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR2_TOG Bit Fields */
#define GIS_CH3_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH3_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR2_TOG_ADDR_SHIFT))&GIS_CH3_ADDR2_TOG_ADDR_MASK)
#define GIS_CH3_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH3_DATA2 Bit Fields */
#define GIS_CH3_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH3_DATA2_DATA_SHIFT                 0
#define GIS_CH3_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_DATA2_DATA_SHIFT))&GIS_CH3_DATA2_DATA_MASK)
/* CH3_ADDR3 Bit Fields */
#define GIS_CH3_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH3_ADDR3_ADDR_SHIFT                 0
#define GIS_CH3_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR3_ADDR_SHIFT))&GIS_CH3_ADDR3_ADDR_MASK)
#define GIS_CH3_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH3_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH3_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH3_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH3_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH3_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH3_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH3_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH3_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH3_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH3_ADDR3_SET Bit Fields */
#define GIS_CH3_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH3_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR3_SET_ADDR_SHIFT))&GIS_CH3_ADDR3_SET_ADDR_MASK)
#define GIS_CH3_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR3_CLR Bit Fields */
#define GIS_CH3_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH3_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR3_CLR_ADDR_SHIFT))&GIS_CH3_ADDR3_CLR_ADDR_MASK)
#define GIS_CH3_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH3_ADDR3_TOG Bit Fields */
#define GIS_CH3_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH3_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH3_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH3_ADDR3_TOG_ADDR_SHIFT))&GIS_CH3_ADDR3_TOG_ADDR_MASK)
#define GIS_CH3_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH3_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH3_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH3_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH3_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH3_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH3_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH3_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH3_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH3_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH3_DATA3 Bit Fields */
#define GIS_CH3_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH3_DATA3_DATA_SHIFT                 0
#define GIS_CH3_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH3_DATA3_DATA_SHIFT))&GIS_CH3_DATA3_DATA_MASK)
/* CH4_CTRL Bit Fields */
#define GIS_CH4_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH4_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH4_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH4_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH4_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH4_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH4_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD0_ALU_SHIFT))&GIS_CH4_CTRL_CMD0_ALU_MASK)
#define GIS_CH4_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH4_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH4_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH4_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH4_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH4_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH4_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH4_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH4_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD1_ALU_SHIFT))&GIS_CH4_CTRL_CMD1_ALU_MASK)
#define GIS_CH4_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH4_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH4_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH4_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH4_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH4_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH4_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH4_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH4_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD2_ALU_SHIFT))&GIS_CH4_CTRL_CMD2_ALU_MASK)
#define GIS_CH4_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH4_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH4_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH4_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH4_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH4_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH4_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH4_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH4_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CMD3_ALU_SHIFT))&GIS_CH4_CTRL_CMD3_ALU_MASK)
#define GIS_CH4_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH4_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH4_CTRL_SET Bit Fields */
#define GIS_CH4_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH4_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH4_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH4_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH4_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH4_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH4_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH4_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH4_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH4_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH4_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH4_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH4_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH4_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH4_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH4_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH4_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH4_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH4_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH4_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH4_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH4_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH4_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH4_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH4_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH4_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH4_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH4_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH4_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH4_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH4_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH4_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH4_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH4_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH4_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH4_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH4_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH4_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH4_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH4_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH4_CTRL_CLR Bit Fields */
#define GIS_CH4_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH4_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH4_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH4_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH4_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH4_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH4_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH4_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH4_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH4_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH4_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH4_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH4_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH4_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH4_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH4_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH4_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH4_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH4_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH4_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH4_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH4_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH4_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH4_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH4_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH4_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH4_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH4_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH4_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH4_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH4_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH4_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH4_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH4_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH4_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH4_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH4_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH4_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH4_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH4_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH4_CTRL_TOG Bit Fields */
#define GIS_CH4_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH4_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH4_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH4_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH4_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH4_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH4_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH4_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH4_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH4_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH4_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH4_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH4_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH4_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH4_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH4_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH4_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH4_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH4_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH4_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH4_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH4_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH4_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH4_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH4_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH4_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH4_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH4_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH4_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH4_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH4_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH4_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH4_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH4_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH4_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH4_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH4_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH4_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH4_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH4_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH4_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH4_ADDR0 Bit Fields */
#define GIS_CH4_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH4_ADDR0_ADDR_SHIFT                 0
#define GIS_CH4_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR0_ADDR_SHIFT))&GIS_CH4_ADDR0_ADDR_MASK)
#define GIS_CH4_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH4_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH4_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH4_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH4_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH4_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH4_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH4_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH4_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH4_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH4_ADDR0_SET Bit Fields */
#define GIS_CH4_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH4_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR0_SET_ADDR_SHIFT))&GIS_CH4_ADDR0_SET_ADDR_MASK)
#define GIS_CH4_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR0_CLR Bit Fields */
#define GIS_CH4_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH4_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR0_CLR_ADDR_SHIFT))&GIS_CH4_ADDR0_CLR_ADDR_MASK)
#define GIS_CH4_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR0_TOG Bit Fields */
#define GIS_CH4_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH4_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR0_TOG_ADDR_SHIFT))&GIS_CH4_ADDR0_TOG_ADDR_MASK)
#define GIS_CH4_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH4_DATA0 Bit Fields */
#define GIS_CH4_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH4_DATA0_DATA_SHIFT                 0
#define GIS_CH4_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_DATA0_DATA_SHIFT))&GIS_CH4_DATA0_DATA_MASK)
/* CH4_ADDR1 Bit Fields */
#define GIS_CH4_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH4_ADDR1_ADDR_SHIFT                 0
#define GIS_CH4_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR1_ADDR_SHIFT))&GIS_CH4_ADDR1_ADDR_MASK)
#define GIS_CH4_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH4_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH4_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH4_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH4_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH4_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH4_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH4_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH4_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH4_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH4_ADDR1_SET Bit Fields */
#define GIS_CH4_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH4_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR1_SET_ADDR_SHIFT))&GIS_CH4_ADDR1_SET_ADDR_MASK)
#define GIS_CH4_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR1_CLR Bit Fields */
#define GIS_CH4_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH4_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR1_CLR_ADDR_SHIFT))&GIS_CH4_ADDR1_CLR_ADDR_MASK)
#define GIS_CH4_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR1_TOG Bit Fields */
#define GIS_CH4_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH4_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR1_TOG_ADDR_SHIFT))&GIS_CH4_ADDR1_TOG_ADDR_MASK)
#define GIS_CH4_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH4_DATA1 Bit Fields */
#define GIS_CH4_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH4_DATA1_DATA_SHIFT                 0
#define GIS_CH4_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_DATA1_DATA_SHIFT))&GIS_CH4_DATA1_DATA_MASK)
/* CH4_ADDR2 Bit Fields */
#define GIS_CH4_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH4_ADDR2_ADDR_SHIFT                 0
#define GIS_CH4_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR2_ADDR_SHIFT))&GIS_CH4_ADDR2_ADDR_MASK)
#define GIS_CH4_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH4_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH4_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH4_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH4_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH4_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH4_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH4_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH4_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH4_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH4_ADDR2_SET Bit Fields */
#define GIS_CH4_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH4_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR2_SET_ADDR_SHIFT))&GIS_CH4_ADDR2_SET_ADDR_MASK)
#define GIS_CH4_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR2_CLR Bit Fields */
#define GIS_CH4_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH4_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR2_CLR_ADDR_SHIFT))&GIS_CH4_ADDR2_CLR_ADDR_MASK)
#define GIS_CH4_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR2_TOG Bit Fields */
#define GIS_CH4_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH4_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR2_TOG_ADDR_SHIFT))&GIS_CH4_ADDR2_TOG_ADDR_MASK)
#define GIS_CH4_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH4_DATA2 Bit Fields */
#define GIS_CH4_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH4_DATA2_DATA_SHIFT                 0
#define GIS_CH4_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_DATA2_DATA_SHIFT))&GIS_CH4_DATA2_DATA_MASK)
/* CH4_ADDR3 Bit Fields */
#define GIS_CH4_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH4_ADDR3_ADDR_SHIFT                 0
#define GIS_CH4_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR3_ADDR_SHIFT))&GIS_CH4_ADDR3_ADDR_MASK)
#define GIS_CH4_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH4_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH4_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH4_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH4_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH4_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH4_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH4_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH4_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH4_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH4_ADDR3_SET Bit Fields */
#define GIS_CH4_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH4_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR3_SET_ADDR_SHIFT))&GIS_CH4_ADDR3_SET_ADDR_MASK)
#define GIS_CH4_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR3_CLR Bit Fields */
#define GIS_CH4_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH4_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR3_CLR_ADDR_SHIFT))&GIS_CH4_ADDR3_CLR_ADDR_MASK)
#define GIS_CH4_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH4_ADDR3_TOG Bit Fields */
#define GIS_CH4_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH4_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH4_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH4_ADDR3_TOG_ADDR_SHIFT))&GIS_CH4_ADDR3_TOG_ADDR_MASK)
#define GIS_CH4_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH4_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH4_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH4_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH4_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH4_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH4_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH4_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH4_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH4_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH4_DATA3 Bit Fields */
#define GIS_CH4_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH4_DATA3_DATA_SHIFT                 0
#define GIS_CH4_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH4_DATA3_DATA_SHIFT))&GIS_CH4_DATA3_DATA_MASK)
/* CH5_CTRL Bit Fields */
#define GIS_CH5_CTRL_CMD0_OPCODE_MASK            0xFu
#define GIS_CH5_CTRL_CMD0_OPCODE_SHIFT           0
#define GIS_CH5_CTRL_CMD0_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD0_OPCODE_SHIFT))&GIS_CH5_CTRL_CMD0_OPCODE_MASK)
#define GIS_CH5_CTRL_CMD0_ALU_MASK               0x70u
#define GIS_CH5_CTRL_CMD0_ALU_SHIFT              4
#define GIS_CH5_CTRL_CMD0_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD0_ALU_SHIFT))&GIS_CH5_CTRL_CMD0_ALU_MASK)
#define GIS_CH5_CTRL_CMD0_ACC_NEG_MASK           0x80u
#define GIS_CH5_CTRL_CMD0_ACC_NEG_SHIFT          7
#define GIS_CH5_CTRL_CMD1_OPCODE_MASK            0xF00u
#define GIS_CH5_CTRL_CMD1_OPCODE_SHIFT           8
#define GIS_CH5_CTRL_CMD1_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD1_OPCODE_SHIFT))&GIS_CH5_CTRL_CMD1_OPCODE_MASK)
#define GIS_CH5_CTRL_CMD1_ALU_MASK               0x7000u
#define GIS_CH5_CTRL_CMD1_ALU_SHIFT              12
#define GIS_CH5_CTRL_CMD1_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD1_ALU_SHIFT))&GIS_CH5_CTRL_CMD1_ALU_MASK)
#define GIS_CH5_CTRL_CMD1_ACC_NEG_MASK           0x8000u
#define GIS_CH5_CTRL_CMD1_ACC_NEG_SHIFT          15
#define GIS_CH5_CTRL_CMD2_OPCODE_MASK            0xF0000u
#define GIS_CH5_CTRL_CMD2_OPCODE_SHIFT           16
#define GIS_CH5_CTRL_CMD2_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD2_OPCODE_SHIFT))&GIS_CH5_CTRL_CMD2_OPCODE_MASK)
#define GIS_CH5_CTRL_CMD2_ALU_MASK               0x700000u
#define GIS_CH5_CTRL_CMD2_ALU_SHIFT              20
#define GIS_CH5_CTRL_CMD2_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD2_ALU_SHIFT))&GIS_CH5_CTRL_CMD2_ALU_MASK)
#define GIS_CH5_CTRL_CMD2_ACC_NEG_MASK           0x800000u
#define GIS_CH5_CTRL_CMD2_ACC_NEG_SHIFT          23
#define GIS_CH5_CTRL_CMD3_OPCODE_MASK            0xF000000u
#define GIS_CH5_CTRL_CMD3_OPCODE_SHIFT           24
#define GIS_CH5_CTRL_CMD3_OPCODE(x)              (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD3_OPCODE_SHIFT))&GIS_CH5_CTRL_CMD3_OPCODE_MASK)
#define GIS_CH5_CTRL_CMD3_ALU_MASK               0x70000000u
#define GIS_CH5_CTRL_CMD3_ALU_SHIFT              28
#define GIS_CH5_CTRL_CMD3_ALU(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CMD3_ALU_SHIFT))&GIS_CH5_CTRL_CMD3_ALU_MASK)
#define GIS_CH5_CTRL_CMD3_ACC_NEG_MASK           0x80000000u
#define GIS_CH5_CTRL_CMD3_ACC_NEG_SHIFT          31
/* CH5_CTRL_SET Bit Fields */
#define GIS_CH5_CTRL_SET_CMD0_OPCODE_MASK        0xFu
#define GIS_CH5_CTRL_SET_CMD0_OPCODE_SHIFT       0
#define GIS_CH5_CTRL_SET_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD0_OPCODE_SHIFT))&GIS_CH5_CTRL_SET_CMD0_OPCODE_MASK)
#define GIS_CH5_CTRL_SET_CMD0_ALU_MASK           0x70u
#define GIS_CH5_CTRL_SET_CMD0_ALU_SHIFT          4
#define GIS_CH5_CTRL_SET_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD0_ALU_SHIFT))&GIS_CH5_CTRL_SET_CMD0_ALU_MASK)
#define GIS_CH5_CTRL_SET_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH5_CTRL_SET_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH5_CTRL_SET_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH5_CTRL_SET_CMD1_OPCODE_SHIFT       8
#define GIS_CH5_CTRL_SET_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD1_OPCODE_SHIFT))&GIS_CH5_CTRL_SET_CMD1_OPCODE_MASK)
#define GIS_CH5_CTRL_SET_CMD1_ALU_MASK           0x7000u
#define GIS_CH5_CTRL_SET_CMD1_ALU_SHIFT          12
#define GIS_CH5_CTRL_SET_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD1_ALU_SHIFT))&GIS_CH5_CTRL_SET_CMD1_ALU_MASK)
#define GIS_CH5_CTRL_SET_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH5_CTRL_SET_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH5_CTRL_SET_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH5_CTRL_SET_CMD2_OPCODE_SHIFT       16
#define GIS_CH5_CTRL_SET_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD2_OPCODE_SHIFT))&GIS_CH5_CTRL_SET_CMD2_OPCODE_MASK)
#define GIS_CH5_CTRL_SET_CMD2_ALU_MASK           0x700000u
#define GIS_CH5_CTRL_SET_CMD2_ALU_SHIFT          20
#define GIS_CH5_CTRL_SET_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD2_ALU_SHIFT))&GIS_CH5_CTRL_SET_CMD2_ALU_MASK)
#define GIS_CH5_CTRL_SET_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH5_CTRL_SET_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH5_CTRL_SET_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH5_CTRL_SET_CMD3_OPCODE_SHIFT       24
#define GIS_CH5_CTRL_SET_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD3_OPCODE_SHIFT))&GIS_CH5_CTRL_SET_CMD3_OPCODE_MASK)
#define GIS_CH5_CTRL_SET_CMD3_ALU_MASK           0x70000000u
#define GIS_CH5_CTRL_SET_CMD3_ALU_SHIFT          28
#define GIS_CH5_CTRL_SET_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_SET_CMD3_ALU_SHIFT))&GIS_CH5_CTRL_SET_CMD3_ALU_MASK)
#define GIS_CH5_CTRL_SET_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH5_CTRL_SET_CMD3_ACC_NEG_SHIFT      31
/* CH5_CTRL_CLR Bit Fields */
#define GIS_CH5_CTRL_CLR_CMD0_OPCODE_MASK        0xFu
#define GIS_CH5_CTRL_CLR_CMD0_OPCODE_SHIFT       0
#define GIS_CH5_CTRL_CLR_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD0_OPCODE_SHIFT))&GIS_CH5_CTRL_CLR_CMD0_OPCODE_MASK)
#define GIS_CH5_CTRL_CLR_CMD0_ALU_MASK           0x70u
#define GIS_CH5_CTRL_CLR_CMD0_ALU_SHIFT          4
#define GIS_CH5_CTRL_CLR_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD0_ALU_SHIFT))&GIS_CH5_CTRL_CLR_CMD0_ALU_MASK)
#define GIS_CH5_CTRL_CLR_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH5_CTRL_CLR_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH5_CTRL_CLR_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH5_CTRL_CLR_CMD1_OPCODE_SHIFT       8
#define GIS_CH5_CTRL_CLR_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD1_OPCODE_SHIFT))&GIS_CH5_CTRL_CLR_CMD1_OPCODE_MASK)
#define GIS_CH5_CTRL_CLR_CMD1_ALU_MASK           0x7000u
#define GIS_CH5_CTRL_CLR_CMD1_ALU_SHIFT          12
#define GIS_CH5_CTRL_CLR_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD1_ALU_SHIFT))&GIS_CH5_CTRL_CLR_CMD1_ALU_MASK)
#define GIS_CH5_CTRL_CLR_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH5_CTRL_CLR_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH5_CTRL_CLR_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH5_CTRL_CLR_CMD2_OPCODE_SHIFT       16
#define GIS_CH5_CTRL_CLR_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD2_OPCODE_SHIFT))&GIS_CH5_CTRL_CLR_CMD2_OPCODE_MASK)
#define GIS_CH5_CTRL_CLR_CMD2_ALU_MASK           0x700000u
#define GIS_CH5_CTRL_CLR_CMD2_ALU_SHIFT          20
#define GIS_CH5_CTRL_CLR_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD2_ALU_SHIFT))&GIS_CH5_CTRL_CLR_CMD2_ALU_MASK)
#define GIS_CH5_CTRL_CLR_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH5_CTRL_CLR_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH5_CTRL_CLR_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH5_CTRL_CLR_CMD3_OPCODE_SHIFT       24
#define GIS_CH5_CTRL_CLR_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD3_OPCODE_SHIFT))&GIS_CH5_CTRL_CLR_CMD3_OPCODE_MASK)
#define GIS_CH5_CTRL_CLR_CMD3_ALU_MASK           0x70000000u
#define GIS_CH5_CTRL_CLR_CMD3_ALU_SHIFT          28
#define GIS_CH5_CTRL_CLR_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_CLR_CMD3_ALU_SHIFT))&GIS_CH5_CTRL_CLR_CMD3_ALU_MASK)
#define GIS_CH5_CTRL_CLR_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH5_CTRL_CLR_CMD3_ACC_NEG_SHIFT      31
/* CH5_CTRL_TOG Bit Fields */
#define GIS_CH5_CTRL_TOG_CMD0_OPCODE_MASK        0xFu
#define GIS_CH5_CTRL_TOG_CMD0_OPCODE_SHIFT       0
#define GIS_CH5_CTRL_TOG_CMD0_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD0_OPCODE_SHIFT))&GIS_CH5_CTRL_TOG_CMD0_OPCODE_MASK)
#define GIS_CH5_CTRL_TOG_CMD0_ALU_MASK           0x70u
#define GIS_CH5_CTRL_TOG_CMD0_ALU_SHIFT          4
#define GIS_CH5_CTRL_TOG_CMD0_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD0_ALU_SHIFT))&GIS_CH5_CTRL_TOG_CMD0_ALU_MASK)
#define GIS_CH5_CTRL_TOG_CMD0_ACC_NEG_MASK       0x80u
#define GIS_CH5_CTRL_TOG_CMD0_ACC_NEG_SHIFT      7
#define GIS_CH5_CTRL_TOG_CMD1_OPCODE_MASK        0xF00u
#define GIS_CH5_CTRL_TOG_CMD1_OPCODE_SHIFT       8
#define GIS_CH5_CTRL_TOG_CMD1_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD1_OPCODE_SHIFT))&GIS_CH5_CTRL_TOG_CMD1_OPCODE_MASK)
#define GIS_CH5_CTRL_TOG_CMD1_ALU_MASK           0x7000u
#define GIS_CH5_CTRL_TOG_CMD1_ALU_SHIFT          12
#define GIS_CH5_CTRL_TOG_CMD1_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD1_ALU_SHIFT))&GIS_CH5_CTRL_TOG_CMD1_ALU_MASK)
#define GIS_CH5_CTRL_TOG_CMD1_ACC_NEG_MASK       0x8000u
#define GIS_CH5_CTRL_TOG_CMD1_ACC_NEG_SHIFT      15
#define GIS_CH5_CTRL_TOG_CMD2_OPCODE_MASK        0xF0000u
#define GIS_CH5_CTRL_TOG_CMD2_OPCODE_SHIFT       16
#define GIS_CH5_CTRL_TOG_CMD2_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD2_OPCODE_SHIFT))&GIS_CH5_CTRL_TOG_CMD2_OPCODE_MASK)
#define GIS_CH5_CTRL_TOG_CMD2_ALU_MASK           0x700000u
#define GIS_CH5_CTRL_TOG_CMD2_ALU_SHIFT          20
#define GIS_CH5_CTRL_TOG_CMD2_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD2_ALU_SHIFT))&GIS_CH5_CTRL_TOG_CMD2_ALU_MASK)
#define GIS_CH5_CTRL_TOG_CMD2_ACC_NEG_MASK       0x800000u
#define GIS_CH5_CTRL_TOG_CMD2_ACC_NEG_SHIFT      23
#define GIS_CH5_CTRL_TOG_CMD3_OPCODE_MASK        0xF000000u
#define GIS_CH5_CTRL_TOG_CMD3_OPCODE_SHIFT       24
#define GIS_CH5_CTRL_TOG_CMD3_OPCODE(x)          (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD3_OPCODE_SHIFT))&GIS_CH5_CTRL_TOG_CMD3_OPCODE_MASK)
#define GIS_CH5_CTRL_TOG_CMD3_ALU_MASK           0x70000000u
#define GIS_CH5_CTRL_TOG_CMD3_ALU_SHIFT          28
#define GIS_CH5_CTRL_TOG_CMD3_ALU(x)             (((uint32_t)(((uint32_t)(x))<<GIS_CH5_CTRL_TOG_CMD3_ALU_SHIFT))&GIS_CH5_CTRL_TOG_CMD3_ALU_MASK)
#define GIS_CH5_CTRL_TOG_CMD3_ACC_NEG_MASK       0x80000000u
#define GIS_CH5_CTRL_TOG_CMD3_ACC_NEG_SHIFT      31
/* CH5_ADDR0 Bit Fields */
#define GIS_CH5_ADDR0_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH5_ADDR0_ADDR_SHIFT                 0
#define GIS_CH5_ADDR0_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR0_ADDR_SHIFT))&GIS_CH5_ADDR0_ADDR_MASK)
#define GIS_CH5_ADDR0_CSI0_SEL_MASK              0x8000000u
#define GIS_CH5_ADDR0_CSI0_SEL_SHIFT             27
#define GIS_CH5_ADDR0_CSI1_SEL_MASK              0x10000000u
#define GIS_CH5_ADDR0_CSI1_SEL_SHIFT             28
#define GIS_CH5_ADDR0_PXP_SEL_MASK               0x20000000u
#define GIS_CH5_ADDR0_PXP_SEL_SHIFT              29
#define GIS_CH5_ADDR0_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH5_ADDR0_LCDIF0_SEL_SHIFT           30
#define GIS_CH5_ADDR0_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH5_ADDR0_LCDIF1_SEL_SHIFT           31
/* CH5_ADDR0_SET Bit Fields */
#define GIS_CH5_ADDR0_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR0_SET_ADDR_SHIFT             0
#define GIS_CH5_ADDR0_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR0_SET_ADDR_SHIFT))&GIS_CH5_ADDR0_SET_ADDR_MASK)
#define GIS_CH5_ADDR0_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR0_SET_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR0_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR0_SET_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR0_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR0_SET_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR0_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR0_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR0_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR0_SET_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR0_CLR Bit Fields */
#define GIS_CH5_ADDR0_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR0_CLR_ADDR_SHIFT             0
#define GIS_CH5_ADDR0_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR0_CLR_ADDR_SHIFT))&GIS_CH5_ADDR0_CLR_ADDR_MASK)
#define GIS_CH5_ADDR0_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR0_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR0_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR0_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR0_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR0_CLR_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR0_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR0_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR0_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR0_CLR_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR0_TOG Bit Fields */
#define GIS_CH5_ADDR0_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR0_TOG_ADDR_SHIFT             0
#define GIS_CH5_ADDR0_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR0_TOG_ADDR_SHIFT))&GIS_CH5_ADDR0_TOG_ADDR_MASK)
#define GIS_CH5_ADDR0_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR0_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR0_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR0_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR0_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR0_TOG_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR0_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR0_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR0_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR0_TOG_LCDIF1_SEL_SHIFT       31
/* CH5_DATA0 Bit Fields */
#define GIS_CH5_DATA0_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH5_DATA0_DATA_SHIFT                 0
#define GIS_CH5_DATA0_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_DATA0_DATA_SHIFT))&GIS_CH5_DATA0_DATA_MASK)
/* CH5_ADDR1 Bit Fields */
#define GIS_CH5_ADDR1_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH5_ADDR1_ADDR_SHIFT                 0
#define GIS_CH5_ADDR1_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR1_ADDR_SHIFT))&GIS_CH5_ADDR1_ADDR_MASK)
#define GIS_CH5_ADDR1_CSI0_SEL_MASK              0x8000000u
#define GIS_CH5_ADDR1_CSI0_SEL_SHIFT             27
#define GIS_CH5_ADDR1_CSI1_SEL_MASK              0x10000000u
#define GIS_CH5_ADDR1_CSI1_SEL_SHIFT             28
#define GIS_CH5_ADDR1_PXP_SEL_MASK               0x20000000u
#define GIS_CH5_ADDR1_PXP_SEL_SHIFT              29
#define GIS_CH5_ADDR1_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH5_ADDR1_LCDIF0_SEL_SHIFT           30
#define GIS_CH5_ADDR1_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH5_ADDR1_LCDIF1_SEL_SHIFT           31
/* CH5_ADDR1_SET Bit Fields */
#define GIS_CH5_ADDR1_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR1_SET_ADDR_SHIFT             0
#define GIS_CH5_ADDR1_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR1_SET_ADDR_SHIFT))&GIS_CH5_ADDR1_SET_ADDR_MASK)
#define GIS_CH5_ADDR1_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR1_SET_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR1_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR1_SET_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR1_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR1_SET_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR1_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR1_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR1_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR1_SET_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR1_CLR Bit Fields */
#define GIS_CH5_ADDR1_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR1_CLR_ADDR_SHIFT             0
#define GIS_CH5_ADDR1_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR1_CLR_ADDR_SHIFT))&GIS_CH5_ADDR1_CLR_ADDR_MASK)
#define GIS_CH5_ADDR1_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR1_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR1_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR1_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR1_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR1_CLR_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR1_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR1_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR1_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR1_CLR_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR1_TOG Bit Fields */
#define GIS_CH5_ADDR1_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR1_TOG_ADDR_SHIFT             0
#define GIS_CH5_ADDR1_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR1_TOG_ADDR_SHIFT))&GIS_CH5_ADDR1_TOG_ADDR_MASK)
#define GIS_CH5_ADDR1_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR1_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR1_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR1_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR1_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR1_TOG_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR1_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR1_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR1_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR1_TOG_LCDIF1_SEL_SHIFT       31
/* CH5_DATA1 Bit Fields */
#define GIS_CH5_DATA1_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH5_DATA1_DATA_SHIFT                 0
#define GIS_CH5_DATA1_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_DATA1_DATA_SHIFT))&GIS_CH5_DATA1_DATA_MASK)
/* CH5_ADDR2 Bit Fields */
#define GIS_CH5_ADDR2_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH5_ADDR2_ADDR_SHIFT                 0
#define GIS_CH5_ADDR2_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR2_ADDR_SHIFT))&GIS_CH5_ADDR2_ADDR_MASK)
#define GIS_CH5_ADDR2_CSI0_SEL_MASK              0x8000000u
#define GIS_CH5_ADDR2_CSI0_SEL_SHIFT             27
#define GIS_CH5_ADDR2_CSI1_SEL_MASK              0x10000000u
#define GIS_CH5_ADDR2_CSI1_SEL_SHIFT             28
#define GIS_CH5_ADDR2_PXP_SEL_MASK               0x20000000u
#define GIS_CH5_ADDR2_PXP_SEL_SHIFT              29
#define GIS_CH5_ADDR2_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH5_ADDR2_LCDIF0_SEL_SHIFT           30
#define GIS_CH5_ADDR2_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH5_ADDR2_LCDIF1_SEL_SHIFT           31
/* CH5_ADDR2_SET Bit Fields */
#define GIS_CH5_ADDR2_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR2_SET_ADDR_SHIFT             0
#define GIS_CH5_ADDR2_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR2_SET_ADDR_SHIFT))&GIS_CH5_ADDR2_SET_ADDR_MASK)
#define GIS_CH5_ADDR2_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR2_SET_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR2_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR2_SET_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR2_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR2_SET_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR2_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR2_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR2_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR2_SET_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR2_CLR Bit Fields */
#define GIS_CH5_ADDR2_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR2_CLR_ADDR_SHIFT             0
#define GIS_CH5_ADDR2_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR2_CLR_ADDR_SHIFT))&GIS_CH5_ADDR2_CLR_ADDR_MASK)
#define GIS_CH5_ADDR2_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR2_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR2_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR2_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR2_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR2_CLR_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR2_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR2_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR2_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR2_CLR_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR2_TOG Bit Fields */
#define GIS_CH5_ADDR2_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR2_TOG_ADDR_SHIFT             0
#define GIS_CH5_ADDR2_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR2_TOG_ADDR_SHIFT))&GIS_CH5_ADDR2_TOG_ADDR_MASK)
#define GIS_CH5_ADDR2_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR2_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR2_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR2_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR2_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR2_TOG_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR2_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR2_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR2_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR2_TOG_LCDIF1_SEL_SHIFT       31
/* CH5_DATA2 Bit Fields */
#define GIS_CH5_DATA2_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH5_DATA2_DATA_SHIFT                 0
#define GIS_CH5_DATA2_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_DATA2_DATA_SHIFT))&GIS_CH5_DATA2_DATA_MASK)
/* CH5_ADDR3 Bit Fields */
#define GIS_CH5_ADDR3_ADDR_MASK                  0x7FFFFFFu
#define GIS_CH5_ADDR3_ADDR_SHIFT                 0
#define GIS_CH5_ADDR3_ADDR(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR3_ADDR_SHIFT))&GIS_CH5_ADDR3_ADDR_MASK)
#define GIS_CH5_ADDR3_CSI0_SEL_MASK              0x8000000u
#define GIS_CH5_ADDR3_CSI0_SEL_SHIFT             27
#define GIS_CH5_ADDR3_CSI1_SEL_MASK              0x10000000u
#define GIS_CH5_ADDR3_CSI1_SEL_SHIFT             28
#define GIS_CH5_ADDR3_PXP_SEL_MASK               0x20000000u
#define GIS_CH5_ADDR3_PXP_SEL_SHIFT              29
#define GIS_CH5_ADDR3_LCDIF0_SEL_MASK            0x40000000u
#define GIS_CH5_ADDR3_LCDIF0_SEL_SHIFT           30
#define GIS_CH5_ADDR3_LCDIF1_SEL_MASK            0x80000000u
#define GIS_CH5_ADDR3_LCDIF1_SEL_SHIFT           31
/* CH5_ADDR3_SET Bit Fields */
#define GIS_CH5_ADDR3_SET_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR3_SET_ADDR_SHIFT             0
#define GIS_CH5_ADDR3_SET_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR3_SET_ADDR_SHIFT))&GIS_CH5_ADDR3_SET_ADDR_MASK)
#define GIS_CH5_ADDR3_SET_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR3_SET_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR3_SET_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR3_SET_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR3_SET_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR3_SET_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR3_SET_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR3_SET_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR3_SET_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR3_SET_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR3_CLR Bit Fields */
#define GIS_CH5_ADDR3_CLR_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR3_CLR_ADDR_SHIFT             0
#define GIS_CH5_ADDR3_CLR_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR3_CLR_ADDR_SHIFT))&GIS_CH5_ADDR3_CLR_ADDR_MASK)
#define GIS_CH5_ADDR3_CLR_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR3_CLR_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR3_CLR_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR3_CLR_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR3_CLR_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR3_CLR_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR3_CLR_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR3_CLR_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR3_CLR_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR3_CLR_LCDIF1_SEL_SHIFT       31
/* CH5_ADDR3_TOG Bit Fields */
#define GIS_CH5_ADDR3_TOG_ADDR_MASK              0x7FFFFFFu
#define GIS_CH5_ADDR3_TOG_ADDR_SHIFT             0
#define GIS_CH5_ADDR3_TOG_ADDR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_CH5_ADDR3_TOG_ADDR_SHIFT))&GIS_CH5_ADDR3_TOG_ADDR_MASK)
#define GIS_CH5_ADDR3_TOG_CSI0_SEL_MASK          0x8000000u
#define GIS_CH5_ADDR3_TOG_CSI0_SEL_SHIFT         27
#define GIS_CH5_ADDR3_TOG_CSI1_SEL_MASK          0x10000000u
#define GIS_CH5_ADDR3_TOG_CSI1_SEL_SHIFT         28
#define GIS_CH5_ADDR3_TOG_PXP_SEL_MASK           0x20000000u
#define GIS_CH5_ADDR3_TOG_PXP_SEL_SHIFT          29
#define GIS_CH5_ADDR3_TOG_LCDIF0_SEL_MASK        0x40000000u
#define GIS_CH5_ADDR3_TOG_LCDIF0_SEL_SHIFT       30
#define GIS_CH5_ADDR3_TOG_LCDIF1_SEL_MASK        0x80000000u
#define GIS_CH5_ADDR3_TOG_LCDIF1_SEL_SHIFT       31
/* CH5_DATA3 Bit Fields */
#define GIS_CH5_DATA3_DATA_MASK                  0xFFFFFFFFu
#define GIS_CH5_DATA3_DATA_SHIFT                 0
#define GIS_CH5_DATA3_DATA(x)                    (((uint32_t)(((uint32_t)(x))<<GIS_CH5_DATA3_DATA_SHIFT))&GIS_CH5_DATA3_DATA_MASK)
/* DEBUG0 Bit Fields */
#define GIS_DEBUG0_CMD_STATE_MASK                0xFFu
#define GIS_DEBUG0_CMD_STATE_SHIFT               0
#define GIS_DEBUG0_CMD_STATE(x)                  (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_CMD_STATE_SHIFT))&GIS_DEBUG0_CMD_STATE_MASK)
#define GIS_DEBUG0_MAIN_STATE_MASK               0x3F00u
#define GIS_DEBUG0_MAIN_STATE_SHIFT              8
#define GIS_DEBUG0_MAIN_STATE(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_MAIN_STATE_SHIFT))&GIS_DEBUG0_MAIN_STATE_MASK)
#define GIS_DEBUG0_CHANNEL_CUR_MASK              0x3C000u
#define GIS_DEBUG0_CHANNEL_CUR_SHIFT             14
#define GIS_DEBUG0_CHANNEL_CUR(x)                (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_CHANNEL_CUR_SHIFT))&GIS_DEBUG0_CHANNEL_CUR_MASK)
#define GIS_DEBUG0_CMD_COUNTER_MASK              0x1C0000u
#define GIS_DEBUG0_CMD_COUNTER_SHIFT             18
#define GIS_DEBUG0_CMD_COUNTER(x)                (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_CMD_COUNTER_SHIFT))&GIS_DEBUG0_CMD_COUNTER_MASK)
#define GIS_DEBUG0_CMD_OPCODE_MASK               0x1E00000u
#define GIS_DEBUG0_CMD_OPCODE_SHIFT              21
#define GIS_DEBUG0_CMD_OPCODE(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_CMD_OPCODE_SHIFT))&GIS_DEBUG0_CMD_OPCODE_MASK)
#define GIS_DEBUG0_PXP_BUSY_MASK                 0x2000000u
#define GIS_DEBUG0_PXP_BUSY_SHIFT                25
#define GIS_DEBUG0_PXP_IRQ_MASK                  0x4000000u
#define GIS_DEBUG0_PXP_IRQ_SHIFT                 26
#define GIS_DEBUG0_CSI_IRQ_MASK                  0x8000000u
#define GIS_DEBUG0_CSI_IRQ_SHIFT                 27
#define GIS_DEBUG0_CSI_FB_REG_MASK               0x30000000u
#define GIS_DEBUG0_CSI_FB_REG_SHIFT              28
#define GIS_DEBUG0_CSI_FB_REG(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG0_CSI_FB_REG_SHIFT))&GIS_DEBUG0_CSI_FB_REG_MASK)
/* DEBUG1 Bit Fields */
#define GIS_DEBUG1_CSI_FB_MASK                   0xFFu
#define GIS_DEBUG1_CSI_FB_SHIFT                  0
#define GIS_DEBUG1_CSI_FB(x)                     (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG1_CSI_FB_SHIFT))&GIS_DEBUG1_CSI_FB_MASK)
#define GIS_DEBUG1_PXP_OUT_FB_MASK               0xFF00u
#define GIS_DEBUG1_PXP_OUT_FB_SHIFT              8
#define GIS_DEBUG1_PXP_OUT_FB(x)                 (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG1_PXP_OUT_FB_SHIFT))&GIS_DEBUG1_PXP_OUT_FB_MASK)
#define GIS_DEBUG1_PXP_IN_FB_MASK                0x30000u
#define GIS_DEBUG1_PXP_IN_FB_SHIFT               16
#define GIS_DEBUG1_PXP_IN_FB(x)                  (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG1_PXP_IN_FB_SHIFT))&GIS_DEBUG1_PXP_IN_FB_MASK)
#define GIS_DEBUG1_LCDIF_FB_MASK                 0xC0000u
#define GIS_DEBUG1_LCDIF_FB_SHIFT                18
#define GIS_DEBUG1_LCDIF_FB(x)                   (((uint32_t)(((uint32_t)(x))<<GIS_DEBUG1_LCDIF_FB_SHIFT))&GIS_DEBUG1_LCDIF_FB_MASK)
/* VERSION Bit Fields */
#define GIS_VERSION_STEP_MASK                    0xFFFFu
#define GIS_VERSION_STEP_SHIFT                   0
#define GIS_VERSION_STEP(x)                      (((uint32_t)(((uint32_t)(x))<<GIS_VERSION_STEP_SHIFT))&GIS_VERSION_STEP_MASK)
#define GIS_VERSION_MINOR_MASK                   0xFF0000u
#define GIS_VERSION_MINOR_SHIFT                  16
#define GIS_VERSION_MINOR(x)                     (((uint32_t)(((uint32_t)(x))<<GIS_VERSION_MINOR_SHIFT))&GIS_VERSION_MINOR_MASK)
#define GIS_VERSION_MAJOR_MASK                   0xFF000000u
#define GIS_VERSION_MAJOR_SHIFT                  24
#define GIS_VERSION_MAJOR(x)                     (((uint32_t)(((uint32_t)(x))<<GIS_VERSION_MAJOR_SHIFT))&GIS_VERSION_MAJOR_MASK)

/*!
 * @}
 */ /* end of group GIS_Register_Masks */


/* GIS - Peripheral instance base addresses */
/** Peripheral GIS base pointer */
#define GIS_BASE_PTR                             ((GIS_MemMapPtr)0x42204000u)
/** Array initializer of GIS peripheral base pointers */
#define GIS_BASE_PTRS                            { GIS_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- GIS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GIS_Register_Accessor_Macros GIS - Register accessor macros
 * @{
 */


/* GIS - Register instance definitions */
/* GIS */
#define GIS_CTRL                                 GIS_CTRL_REG(GIS_BASE_PTR)
#define GIS_CTRL_SET                             GIS_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CTRL_CLR                             GIS_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CTRL_TOG                             GIS_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CONFIG0                              GIS_CONFIG0_REG(GIS_BASE_PTR)
#define GIS_CONFIG0_SET                          GIS_CONFIG0_SET_REG(GIS_BASE_PTR)
#define GIS_CONFIG0_CLR                          GIS_CONFIG0_CLR_REG(GIS_BASE_PTR)
#define GIS_CONFIG0_TOG                          GIS_CONFIG0_TOG_REG(GIS_BASE_PTR)
#define GIS_CONFIG1                              GIS_CONFIG1_REG(GIS_BASE_PTR)
#define GIS_CONFIG1_SET                          GIS_CONFIG1_SET_REG(GIS_BASE_PTR)
#define GIS_CONFIG1_CLR                          GIS_CONFIG1_CLR_REG(GIS_BASE_PTR)
#define GIS_CONFIG1_TOG                          GIS_CONFIG1_TOG_REG(GIS_BASE_PTR)
#define GIS_FB0                                  GIS_FB0_REG(GIS_BASE_PTR)
#define GIS_FB1                                  GIS_FB1_REG(GIS_BASE_PTR)
#define GIS_PXP_FB0                              GIS_PXP_FB0_REG(GIS_BASE_PTR)
#define GIS_PXP_FB1                              GIS_PXP_FB1_REG(GIS_BASE_PTR)
#define GIS_CH0_CTRL                             GIS_CH0_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH0_CTRL_SET                         GIS_CH0_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH0_CTRL_CLR                         GIS_CH0_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH0_CTRL_TOG                         GIS_CH0_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR0                            GIS_CH0_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR0_SET                        GIS_CH0_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR0_CLR                        GIS_CH0_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR0_TOG                        GIS_CH0_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH0_DATA0                            GIS_CH0_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR1                            GIS_CH0_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR1_SET                        GIS_CH0_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR1_CLR                        GIS_CH0_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR1_TOG                        GIS_CH0_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH0_DATA1                            GIS_CH0_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR2                            GIS_CH0_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR2_SET                        GIS_CH0_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR2_CLR                        GIS_CH0_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR2_TOG                        GIS_CH0_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH0_DATA2                            GIS_CH0_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR3                            GIS_CH0_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR3_SET                        GIS_CH0_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR3_CLR                        GIS_CH0_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH0_ADDR3_TOG                        GIS_CH0_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH0_DATA3                            GIS_CH0_DATA3_REG(GIS_BASE_PTR)
#define GIS_CH1_CTRL                             GIS_CH1_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH1_CTRL_SET                         GIS_CH1_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH1_CTRL_CLR                         GIS_CH1_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH1_CTRL_TOG                         GIS_CH1_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR0                            GIS_CH1_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR0_SET                        GIS_CH1_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR0_CLR                        GIS_CH1_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR0_TOG                        GIS_CH1_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH1_DATA0                            GIS_CH1_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR1                            GIS_CH1_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR1_SET                        GIS_CH1_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR1_CLR                        GIS_CH1_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR1_TOG                        GIS_CH1_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH1_DATA1                            GIS_CH1_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR2                            GIS_CH1_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR2_SET                        GIS_CH1_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR2_CLR                        GIS_CH1_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR2_TOG                        GIS_CH1_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH1_DATA2                            GIS_CH1_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR3                            GIS_CH1_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR3_SET                        GIS_CH1_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR3_CLR                        GIS_CH1_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH1_ADDR3_TOG                        GIS_CH1_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH1_DATA3                            GIS_CH1_DATA3_REG(GIS_BASE_PTR)
#define GIS_CH2_CTRL                             GIS_CH2_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH2_CTRL_SET                         GIS_CH2_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH2_CTRL_CLR                         GIS_CH2_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH2_CTRL_TOG                         GIS_CH2_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR0                            GIS_CH2_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR0_SET                        GIS_CH2_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR0_CLR                        GIS_CH2_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR0_TOG                        GIS_CH2_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH2_DATA0                            GIS_CH2_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR1                            GIS_CH2_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR1_SET                        GIS_CH2_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR1_CLR                        GIS_CH2_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR1_TOG                        GIS_CH2_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH2_DATA1                            GIS_CH2_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR2                            GIS_CH2_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR2_SET                        GIS_CH2_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR2_CLR                        GIS_CH2_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR2_TOG                        GIS_CH2_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH2_DATA2                            GIS_CH2_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR3                            GIS_CH2_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR3_SET                        GIS_CH2_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR3_CLR                        GIS_CH2_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH2_ADDR3_TOG                        GIS_CH2_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH2_DATA3                            GIS_CH2_DATA3_REG(GIS_BASE_PTR)
#define GIS_CH3_CTRL                             GIS_CH3_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH3_CTRL_SET                         GIS_CH3_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH3_CTRL_CLR                         GIS_CH3_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH3_CTRL_TOG                         GIS_CH3_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR0                            GIS_CH3_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR0_SET                        GIS_CH3_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR0_CLR                        GIS_CH3_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR0_TOG                        GIS_CH3_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH3_DATA0                            GIS_CH3_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR1                            GIS_CH3_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR1_SET                        GIS_CH3_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR1_CLR                        GIS_CH3_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR1_TOG                        GIS_CH3_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH3_DATA1                            GIS_CH3_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR2                            GIS_CH3_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR2_SET                        GIS_CH3_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR2_CLR                        GIS_CH3_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR2_TOG                        GIS_CH3_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH3_DATA2                            GIS_CH3_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR3                            GIS_CH3_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR3_SET                        GIS_CH3_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR3_CLR                        GIS_CH3_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH3_ADDR3_TOG                        GIS_CH3_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH3_DATA3                            GIS_CH3_DATA3_REG(GIS_BASE_PTR)
#define GIS_CH4_CTRL                             GIS_CH4_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH4_CTRL_SET                         GIS_CH4_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH4_CTRL_CLR                         GIS_CH4_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH4_CTRL_TOG                         GIS_CH4_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR0                            GIS_CH4_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR0_SET                        GIS_CH4_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR0_CLR                        GIS_CH4_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR0_TOG                        GIS_CH4_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH4_DATA0                            GIS_CH4_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR1                            GIS_CH4_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR1_SET                        GIS_CH4_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR1_CLR                        GIS_CH4_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR1_TOG                        GIS_CH4_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH4_DATA1                            GIS_CH4_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR2                            GIS_CH4_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR2_SET                        GIS_CH4_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR2_CLR                        GIS_CH4_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR2_TOG                        GIS_CH4_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH4_DATA2                            GIS_CH4_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR3                            GIS_CH4_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR3_SET                        GIS_CH4_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR3_CLR                        GIS_CH4_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH4_ADDR3_TOG                        GIS_CH4_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH4_DATA3                            GIS_CH4_DATA3_REG(GIS_BASE_PTR)
#define GIS_CH5_CTRL                             GIS_CH5_CTRL_REG(GIS_BASE_PTR)
#define GIS_CH5_CTRL_SET                         GIS_CH5_CTRL_SET_REG(GIS_BASE_PTR)
#define GIS_CH5_CTRL_CLR                         GIS_CH5_CTRL_CLR_REG(GIS_BASE_PTR)
#define GIS_CH5_CTRL_TOG                         GIS_CH5_CTRL_TOG_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR0                            GIS_CH5_ADDR0_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR0_SET                        GIS_CH5_ADDR0_SET_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR0_CLR                        GIS_CH5_ADDR0_CLR_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR0_TOG                        GIS_CH5_ADDR0_TOG_REG(GIS_BASE_PTR)
#define GIS_CH5_DATA0                            GIS_CH5_DATA0_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR1                            GIS_CH5_ADDR1_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR1_SET                        GIS_CH5_ADDR1_SET_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR1_CLR                        GIS_CH5_ADDR1_CLR_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR1_TOG                        GIS_CH5_ADDR1_TOG_REG(GIS_BASE_PTR)
#define GIS_CH5_DATA1                            GIS_CH5_DATA1_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR2                            GIS_CH5_ADDR2_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR2_SET                        GIS_CH5_ADDR2_SET_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR2_CLR                        GIS_CH5_ADDR2_CLR_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR2_TOG                        GIS_CH5_ADDR2_TOG_REG(GIS_BASE_PTR)
#define GIS_CH5_DATA2                            GIS_CH5_DATA2_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR3                            GIS_CH5_ADDR3_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR3_SET                        GIS_CH5_ADDR3_SET_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR3_CLR                        GIS_CH5_ADDR3_CLR_REG(GIS_BASE_PTR)
#define GIS_CH5_ADDR3_TOG                        GIS_CH5_ADDR3_TOG_REG(GIS_BASE_PTR)
#define GIS_CH5_DATA3                            GIS_CH5_DATA3_REG(GIS_BASE_PTR)
#define GIS_DEBUG0                               GIS_DEBUG0_REG(GIS_BASE_PTR)
#define GIS_DEBUG1                               GIS_DEBUG1_REG(GIS_BASE_PTR)
#define GIS_VERSION                              GIS_VERSION_REG(GIS_BASE_PTR)

/*!
 * @}
 */ /* end of group GIS_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GIS_Peripheral */


/* ----------------------------------------------------------------------------
   -- GPC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPC_Peripheral GPC
 * @{
 */

/** GPC - Peripheral register structure */
typedef struct GPC_MemMap {
  uint32_t CNTR;                                   /**< GPC Interface control register, offset: 0x0 */
  uint32_t PGR;                                    /**< GPC Power Gating Register, offset: 0x4 */
  uint32_t IMR1;                                   /**< IRQ masking register 1, offset: 0x8 */
  uint32_t IMR2;                                   /**< IRQ masking register 2, offset: 0xC */
  uint32_t IMR3;                                   /**< IRQ masking register 3, offset: 0x10 */
  uint32_t IMR4;                                   /**< IRQ masking register 4, offset: 0x14 */
  uint32_t ISR1;                                   /**< IRQ status resister 1, offset: 0x18 */
  uint32_t ISR2;                                   /**< IRQ status resister 2, offset: 0x1C */
  uint32_t ISR3;                                   /**< IRQ status resister 3, offset: 0x20 */
  uint32_t ISR4;                                   /**< IRQ status resister 4, offset: 0x24 */
  uint32_t A9_LPSR;                                /**< A9 Low Power Status Register, offset: 0x28 */
  uint32_t M4_LPSR;                                /**< M4 Low Power Status Register, offset: 0x2C */
  uint32_t DR;                                     /**< GPC Debug Register, offset: 0x30 */
} volatile *GPC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPC_Register_Accessor_Macros GPC - Register accessor macros
 * @{
 */


/* GPC - Register accessors */
#define GPC_CNTR_REG(base)                       ((base)->CNTR)
#define GPC_PGR_REG(base)                        ((base)->PGR)
#define GPC_IMR1_REG(base)                       ((base)->IMR1)
#define GPC_IMR2_REG(base)                       ((base)->IMR2)
#define GPC_IMR3_REG(base)                       ((base)->IMR3)
#define GPC_IMR4_REG(base)                       ((base)->IMR4)
#define GPC_ISR1_REG(base)                       ((base)->ISR1)
#define GPC_ISR2_REG(base)                       ((base)->ISR2)
#define GPC_ISR3_REG(base)                       ((base)->ISR3)
#define GPC_ISR4_REG(base)                       ((base)->ISR4)
#define GPC_A9_LPSR_REG(base)                    ((base)->A9_LPSR)
#define GPC_M4_LPSR_REG(base)                    ((base)->M4_LPSR)
#define GPC_DR_REG(base)                         ((base)->DR)

/*!
 * @}
 */ /* end of group GPC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPC_Register_Masks GPC Register Masks
 * @{
 */

/* CNTR Bit Fields */
#define GPC_CNTR_gpu_vpu_pdn_req_MASK            0x1u
#define GPC_CNTR_gpu_vpu_pdn_req_SHIFT           0
#define GPC_CNTR_gpu_vpu_pup_req_MASK            0x2u
#define GPC_CNTR_gpu_vpu_pup_req_SHIFT           1
#define GPC_CNTR_MEGA_PDN_REQ_MASK               0x4u
#define GPC_CNTR_MEGA_PDN_REQ_SHIFT              2
#define GPC_CNTR_MEGA_PUP_REQ_MASK               0x8u
#define GPC_CNTR_MEGA_PUP_REQ_SHIFT              3
#define GPC_CNTR_DISPLAY_PDN_REQ_MASK            0x10u
#define GPC_CNTR_DISPLAY_PDN_REQ_SHIFT           4
#define GPC_CNTR_DISPLAY_PUP_REQ_MASK            0x20u
#define GPC_CNTR_DISPLAY_PUP_REQ_SHIFT           5
#define GPC_CNTR_PCIE_PHY_PDN_REQ_MASK           0x40u
#define GPC_CNTR_PCIE_PHY_PDN_REQ_SHIFT          6
#define GPC_CNTR_PCIE_PHY_PUP_REQ_MASK           0x80u
#define GPC_CNTR_PCIE_PHY_PUP_REQ_SHIFT          7
#define GPC_CNTR_DVFS0CR_MASK                    0x10000u
#define GPC_CNTR_DVFS0CR_SHIFT                   16
#define GPC_CNTR_VADC_ANALOG_OFF_MASK            0x20000u
#define GPC_CNTR_VADC_ANALOG_OFF_SHIFT           17
#define GPC_CNTR_VADC_EXT_PWD_N_MASK             0x40000u
#define GPC_CNTR_VADC_EXT_PWD_N_SHIFT            18
#define GPC_CNTR_GPCIRQM_MASK                    0x200000u
#define GPC_CNTR_GPCIRQM_SHIFT                   21
#define GPC_CNTR_L2_PGE_MASK                     0x400000u
#define GPC_CNTR_L2_PGE_SHIFT                    22
/* PGR Bit Fields */
#define GPC_PGR_DRCIC_MASK                       0x60000000u
#define GPC_PGR_DRCIC_SHIFT                      29
#define GPC_PGR_DRCIC(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_PGR_DRCIC_SHIFT))&GPC_PGR_DRCIC_MASK)
/* IMR1 Bit Fields */
#define GPC_IMR1_IMR1_MASK                       0xFFFFFFFFu
#define GPC_IMR1_IMR1_SHIFT                      0
#define GPC_IMR1_IMR1(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_IMR1_IMR1_SHIFT))&GPC_IMR1_IMR1_MASK)
/* IMR2 Bit Fields */
#define GPC_IMR2_IMR2_MASK                       0xFFFFFFFFu
#define GPC_IMR2_IMR2_SHIFT                      0
#define GPC_IMR2_IMR2(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_IMR2_IMR2_SHIFT))&GPC_IMR2_IMR2_MASK)
/* IMR3 Bit Fields */
#define GPC_IMR3_IMR3_MASK                       0xFFFFFFFFu
#define GPC_IMR3_IMR3_SHIFT                      0
#define GPC_IMR3_IMR3(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_IMR3_IMR3_SHIFT))&GPC_IMR3_IMR3_MASK)
/* IMR4 Bit Fields */
#define GPC_IMR4_IMR4_MASK                       0xFFFFFFFFu
#define GPC_IMR4_IMR4_SHIFT                      0
#define GPC_IMR4_IMR4(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_IMR4_IMR4_SHIFT))&GPC_IMR4_IMR4_MASK)
/* ISR1 Bit Fields */
#define GPC_ISR1_ISR1_MASK                       0xFFFFFFFFu
#define GPC_ISR1_ISR1_SHIFT                      0
#define GPC_ISR1_ISR1(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_ISR1_ISR1_SHIFT))&GPC_ISR1_ISR1_MASK)
/* ISR2 Bit Fields */
#define GPC_ISR2_ISR2_MASK                       0xFFFFFFFFu
#define GPC_ISR2_ISR2_SHIFT                      0
#define GPC_ISR2_ISR2(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_ISR2_ISR2_SHIFT))&GPC_ISR2_ISR2_MASK)
/* ISR3 Bit Fields */
#define GPC_ISR3_ISR3_MASK                       0xFFFFFFFFu
#define GPC_ISR3_ISR3_SHIFT                      0
#define GPC_ISR3_ISR3(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_ISR3_ISR3_SHIFT))&GPC_ISR3_ISR3_MASK)
/* ISR4 Bit Fields */
#define GPC_ISR4_ISR4_MASK                       0xFFFFFFFFu
#define GPC_ISR4_ISR4_SHIFT                      0
#define GPC_ISR4_ISR4(x)                         (((uint32_t)(((uint32_t)(x))<<GPC_ISR4_ISR4_SHIFT))&GPC_ISR4_ISR4_MASK)
/* A9_LPSR Bit Fields */
#define GPC_A9_LPSR_A9_STANDBY_WFI_MASK          0x1u
#define GPC_A9_LPSR_A9_STANDBY_WFI_SHIFT         0
#define GPC_A9_LPSR_A9_SCU_IDLE_MASK             0x10u
#define GPC_A9_LPSR_A9_SCU_IDLE_SHIFT            4
#define GPC_A9_LPSR_A9_L2CC_IDLE_MASK            0x20u
#define GPC_A9_LPSR_A9_L2CC_IDLE_SHIFT           5
#define GPC_A9_LPSR_A9_CLK_ENABLE_MASK           0x40u
#define GPC_A9_LPSR_A9_CLK_ENABLE_SHIFT          6
#define GPC_A9_LPSR_SYSTEM_IN_WAIT_MODE_MASK     0x80u
#define GPC_A9_LPSR_SYSTEM_IN_WAIT_MODE_SHIFT    7
#define GPC_A9_LPSR_SYSTEM_IN_STOP_MODE_MASK     0x100u
#define GPC_A9_LPSR_SYSTEM_IN_STOP_MODE_SHIFT    8
#define GPC_A9_LPSR_A9_DBG_ACK_MASK              0x200u
#define GPC_A9_LPSR_A9_DBG_ACK_SHIFT             9
#define GPC_A9_LPSR_A9_RST_MASK                  0x400u
#define GPC_A9_LPSR_A9_RST_SHIFT                 10
/* M4_LPSR Bit Fields */
#define GPC_M4_LPSR_M4_SLEEP_HOLD_REQ_B_MASK     0x1u
#define GPC_M4_LPSR_M4_SLEEP_HOLD_REQ_B_SHIFT    0
#define GPC_M4_LPSR_M4_SLEEP_HOLD_ACK_B_MASK     0x2u
#define GPC_M4_LPSR_M4_SLEEP_HOLD_ACK_B_SHIFT    1
#define GPC_M4_LPSR_M4_GATE_HCLK_MASK            0x4u
#define GPC_M4_LPSR_M4_GATE_HCLK_SHIFT           2
#define GPC_M4_LPSR_M4_SLEEP_DEEP_MASK           0x8u
#define GPC_M4_LPSR_M4_SLEEP_DEEP_SHIFT          3
#define GPC_M4_LPSR_M4_SLEEPING_MASK             0x10u
#define GPC_M4_LPSR_M4_SLEEPING_SHIFT            4
#define GPC_M4_LPSR_M4_LOCKUP_MASK               0x20u
#define GPC_M4_LPSR_M4_LOCKUP_SHIFT              5
#define GPC_M4_LPSR_M4_HALTED_MASK               0x40u
#define GPC_M4_LPSR_M4_HALTED_SHIFT              6
#define GPC_M4_LPSR_M4_PLATFORM_RESET_B_MASK     0x80u
#define GPC_M4_LPSR_M4_PLATFORM_RESET_B_SHIFT    7
#define GPC_M4_LPSR_M4_CORE_RESET_B_MASK         0x100u
#define GPC_M4_LPSR_M4_CORE_RESET_B_SHIFT        8
/* DR Bit Fields */
#define GPC_DR_PCIE_PHY_RESET_B_MASK             0x1u
#define GPC_DR_PCIE_PHY_RESET_B_SHIFT            0
#define GPC_DR_PCIE_PHY_ISO_MASK                 0x2u
#define GPC_DR_PCIE_PHY_ISO_SHIFT                1
#define GPC_DR_MEGA_RESET_B_MASK                 0x4u
#define GPC_DR_MEGA_RESET_B_SHIFT                2
#define GPC_DR_MEGA_SWITCH_B_MASK                0x8u
#define GPC_DR_MEGA_SWITCH_B_SHIFT               3
#define GPC_DR_MEGA_ISO_MASK                     0x10u
#define GPC_DR_MEGA_ISO_SHIFT                    4
#define GPC_DR_GPC_PUP_ACK_MASK                  0x20u
#define GPC_DR_GPC_PUP_ACK_SHIFT                 5
#define GPC_DR_GPC_PDN_ACK_MASK                  0x40u
#define GPC_DR_GPC_PDN_ACK_SHIFT                 6
#define GPC_DR_GPC_DISP_RESET_B_MASK             0x80u
#define GPC_DR_GPC_DISP_RESET_B_SHIFT            7
#define GPC_DR_GPC_DISP_SWITCH_B_MASK            0x100u
#define GPC_DR_GPC_DISP_SWITCH_B_SHIFT           8
#define GPC_DR_GPC_DISP_ISO_MASK                 0x200u
#define GPC_DR_GPC_DISP_ISO_SHIFT                9
#define GPC_DR_GPC_GPU_RESET_B_MASK              0x400u
#define GPC_DR_GPC_GPU_RESET_B_SHIFT             10
#define GPC_DR_GPC_GPU_SWITCH_B_MASK             0x800u
#define GPC_DR_GPC_GPU_SWITCH_B_SHIFT            11
#define GPC_DR_GPC_GPU_ISO_MASK                  0x1000u
#define GPC_DR_GPC_GPU_ISO_SHIFT                 12
#define GPC_DR_GPC_L2SOC_ISO_MASK                0x2000u
#define GPC_DR_GPC_L2SOC_ISO_SHIFT               13
#define GPC_DR_GPC_L2CPU_ISO_MASK                0x4000u
#define GPC_DR_GPC_L2CPU_ISO_SHIFT               14
#define GPC_DR_GPC_L2_SWITCH_B_MASK              0x8000u
#define GPC_DR_GPC_L2_SWITCH_B_SHIFT             15
#define GPC_DR_GPC_CPU_RESET_B_MASK              0x10000u
#define GPC_DR_GPC_CPU_RESET_B_SHIFT             16
#define GPC_DR_GPC_CPU_SWITCH_B_MASK             0x20000u
#define GPC_DR_GPC_CPU_SWITCH_B_SHIFT            17
#define GPC_DR_GPC_CPU_ISO_MASK                  0x40000u
#define GPC_DR_GPC_CPU_ISO_SHIFT                 18
#define GPC_DR_IPG_STOP_MASK                     0x80000u
#define GPC_DR_IPG_STOP_SHIFT                    19
#define GPC_DR_IPG_WAIT_MASK                     0x100000u
#define GPC_DR_IPG_WAIT_SHIFT                    20

/*!
 * @}
 */ /* end of group GPC_Register_Masks */


/* GPC - Peripheral instance base addresses */
/** Peripheral GPC base pointer */
#define GPC_BASE_PTR                             ((GPC_MemMapPtr)0x420DC000u)
/** Array initializer of GPC peripheral base pointers */
#define GPC_BASE_PTRS                            { GPC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- GPC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPC_Register_Accessor_Macros GPC - Register accessor macros
 * @{
 */


/* GPC - Register instance definitions */
/* GPC */
#define GPC_CNTR                                 GPC_CNTR_REG(GPC_BASE_PTR)
#define GPC_PGR                                  GPC_PGR_REG(GPC_BASE_PTR)
#define GPC_IMR1                                 GPC_IMR1_REG(GPC_BASE_PTR)
#define GPC_IMR2                                 GPC_IMR2_REG(GPC_BASE_PTR)
#define GPC_IMR3                                 GPC_IMR3_REG(GPC_BASE_PTR)
#define GPC_IMR4                                 GPC_IMR4_REG(GPC_BASE_PTR)
#define GPC_ISR1                                 GPC_ISR1_REG(GPC_BASE_PTR)
#define GPC_ISR2                                 GPC_ISR2_REG(GPC_BASE_PTR)
#define GPC_ISR3                                 GPC_ISR3_REG(GPC_BASE_PTR)
#define GPC_ISR4                                 GPC_ISR4_REG(GPC_BASE_PTR)
#define GPC_A9_LPSR                              GPC_A9_LPSR_REG(GPC_BASE_PTR)
#define GPC_M4_LPSR                              GPC_M4_LPSR_REG(GPC_BASE_PTR)
#define GPC_DR                                   GPC_DR_REG(GPC_BASE_PTR)

/*!
 * @}
 */ /* end of group GPC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GPC_Peripheral */


/* ----------------------------------------------------------------------------
   -- GPIO
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral GPIO
 * @{
 */

/** GPIO - Peripheral register structure */
typedef struct GPIO_MemMap {
  uint32_t DR;                                     /**< GPIO data register, offset: 0x0 */
  uint32_t GDIR;                                   /**< GPIO direction register, offset: 0x4 */
  uint32_t PSR;                                    /**< GPIO pad status register, offset: 0x8 */
  uint32_t ICR1;                                   /**< GPIO interrupt configuration register1, offset: 0xC */
  uint32_t ICR2;                                   /**< GPIO interrupt configuration register2, offset: 0x10 */
  uint32_t IMR;                                    /**< GPIO interrupt mask register, offset: 0x14 */
  uint32_t ISR;                                    /**< GPIO interrupt status register, offset: 0x18 */
  uint32_t EDGE_SEL;                               /**< GPIO edge select register, offset: 0x1C */
} volatile *GPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register accessors */
#define GPIO_DR_REG(base)                        ((base)->DR)
#define GPIO_GDIR_REG(base)                      ((base)->GDIR)
#define GPIO_PSR_REG(base)                       ((base)->PSR)
#define GPIO_ICR1_REG(base)                      ((base)->ICR1)
#define GPIO_ICR2_REG(base)                      ((base)->ICR2)
#define GPIO_IMR_REG(base)                       ((base)->IMR)
#define GPIO_ISR_REG(base)                       ((base)->ISR)
#define GPIO_EDGE_SEL_REG(base)                  ((base)->EDGE_SEL)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/* DR Bit Fields */
#define GPIO_DR_DR_MASK                          0xFFFFFFFFu
#define GPIO_DR_DR_SHIFT                         0
#define GPIO_DR_DR(x)                            (((uint32_t)(((uint32_t)(x))<<GPIO_DR_DR_SHIFT))&GPIO_DR_DR_MASK)
/* GDIR Bit Fields */
#define GPIO_GDIR_GDIR_MASK                      0xFFFFFFFFu
#define GPIO_GDIR_GDIR_SHIFT                     0
#define GPIO_GDIR_GDIR(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_GDIR_GDIR_SHIFT))&GPIO_GDIR_GDIR_MASK)
/* PSR Bit Fields */
#define GPIO_PSR_PSR_MASK                        0xFFFFFFFFu
#define GPIO_PSR_PSR_SHIFT                       0
#define GPIO_PSR_PSR(x)                          (((uint32_t)(((uint32_t)(x))<<GPIO_PSR_PSR_SHIFT))&GPIO_PSR_PSR_MASK)
/* ICR1 Bit Fields */
#define GPIO_ICR1_ICR0_MASK                      0x3u
#define GPIO_ICR1_ICR0_SHIFT                     0
#define GPIO_ICR1_ICR0(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR0_SHIFT))&GPIO_ICR1_ICR0_MASK)
#define GPIO_ICR1_ICR1_MASK                      0xCu
#define GPIO_ICR1_ICR1_SHIFT                     2
#define GPIO_ICR1_ICR1(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR1_SHIFT))&GPIO_ICR1_ICR1_MASK)
#define GPIO_ICR1_ICR2_MASK                      0x30u
#define GPIO_ICR1_ICR2_SHIFT                     4
#define GPIO_ICR1_ICR2(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR2_SHIFT))&GPIO_ICR1_ICR2_MASK)
#define GPIO_ICR1_ICR3_MASK                      0xC0u
#define GPIO_ICR1_ICR3_SHIFT                     6
#define GPIO_ICR1_ICR3(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR3_SHIFT))&GPIO_ICR1_ICR3_MASK)
#define GPIO_ICR1_ICR4_MASK                      0x300u
#define GPIO_ICR1_ICR4_SHIFT                     8
#define GPIO_ICR1_ICR4(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR4_SHIFT))&GPIO_ICR1_ICR4_MASK)
#define GPIO_ICR1_ICR5_MASK                      0xC00u
#define GPIO_ICR1_ICR5_SHIFT                     10
#define GPIO_ICR1_ICR5(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR5_SHIFT))&GPIO_ICR1_ICR5_MASK)
#define GPIO_ICR1_ICR6_MASK                      0x3000u
#define GPIO_ICR1_ICR6_SHIFT                     12
#define GPIO_ICR1_ICR6(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR6_SHIFT))&GPIO_ICR1_ICR6_MASK)
#define GPIO_ICR1_ICR7_MASK                      0xC000u
#define GPIO_ICR1_ICR7_SHIFT                     14
#define GPIO_ICR1_ICR7(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR7_SHIFT))&GPIO_ICR1_ICR7_MASK)
#define GPIO_ICR1_ICR8_MASK                      0x30000u
#define GPIO_ICR1_ICR8_SHIFT                     16
#define GPIO_ICR1_ICR8(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR8_SHIFT))&GPIO_ICR1_ICR8_MASK)
#define GPIO_ICR1_ICR9_MASK                      0xC0000u
#define GPIO_ICR1_ICR9_SHIFT                     18
#define GPIO_ICR1_ICR9(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR9_SHIFT))&GPIO_ICR1_ICR9_MASK)
#define GPIO_ICR1_ICR10_MASK                     0x300000u
#define GPIO_ICR1_ICR10_SHIFT                    20
#define GPIO_ICR1_ICR10(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR10_SHIFT))&GPIO_ICR1_ICR10_MASK)
#define GPIO_ICR1_ICR11_MASK                     0xC00000u
#define GPIO_ICR1_ICR11_SHIFT                    22
#define GPIO_ICR1_ICR11(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR11_SHIFT))&GPIO_ICR1_ICR11_MASK)
#define GPIO_ICR1_ICR12_MASK                     0x3000000u
#define GPIO_ICR1_ICR12_SHIFT                    24
#define GPIO_ICR1_ICR12(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR12_SHIFT))&GPIO_ICR1_ICR12_MASK)
#define GPIO_ICR1_ICR13_MASK                     0xC000000u
#define GPIO_ICR1_ICR13_SHIFT                    26
#define GPIO_ICR1_ICR13(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR13_SHIFT))&GPIO_ICR1_ICR13_MASK)
#define GPIO_ICR1_ICR14_MASK                     0x30000000u
#define GPIO_ICR1_ICR14_SHIFT                    28
#define GPIO_ICR1_ICR14(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR14_SHIFT))&GPIO_ICR1_ICR14_MASK)
#define GPIO_ICR1_ICR15_MASK                     0xC0000000u
#define GPIO_ICR1_ICR15_SHIFT                    30
#define GPIO_ICR1_ICR15(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR1_ICR15_SHIFT))&GPIO_ICR1_ICR15_MASK)
/* ICR2 Bit Fields */
#define GPIO_ICR2_ICR16_MASK                     0x3u
#define GPIO_ICR2_ICR16_SHIFT                    0
#define GPIO_ICR2_ICR16(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR16_SHIFT))&GPIO_ICR2_ICR16_MASK)
#define GPIO_ICR2_ICR17_MASK                     0xCu
#define GPIO_ICR2_ICR17_SHIFT                    2
#define GPIO_ICR2_ICR17(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR17_SHIFT))&GPIO_ICR2_ICR17_MASK)
#define GPIO_ICR2_ICR18_MASK                     0x30u
#define GPIO_ICR2_ICR18_SHIFT                    4
#define GPIO_ICR2_ICR18(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR18_SHIFT))&GPIO_ICR2_ICR18_MASK)
#define GPIO_ICR2_ICR19_MASK                     0xC0u
#define GPIO_ICR2_ICR19_SHIFT                    6
#define GPIO_ICR2_ICR19(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR19_SHIFT))&GPIO_ICR2_ICR19_MASK)
#define GPIO_ICR2_ICR20_MASK                     0x300u
#define GPIO_ICR2_ICR20_SHIFT                    8
#define GPIO_ICR2_ICR20(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR20_SHIFT))&GPIO_ICR2_ICR20_MASK)
#define GPIO_ICR2_ICR21_MASK                     0xC00u
#define GPIO_ICR2_ICR21_SHIFT                    10
#define GPIO_ICR2_ICR21(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR21_SHIFT))&GPIO_ICR2_ICR21_MASK)
#define GPIO_ICR2_ICR22_MASK                     0x3000u
#define GPIO_ICR2_ICR22_SHIFT                    12
#define GPIO_ICR2_ICR22(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR22_SHIFT))&GPIO_ICR2_ICR22_MASK)
#define GPIO_ICR2_ICR23_MASK                     0xC000u
#define GPIO_ICR2_ICR23_SHIFT                    14
#define GPIO_ICR2_ICR23(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR23_SHIFT))&GPIO_ICR2_ICR23_MASK)
#define GPIO_ICR2_ICR24_MASK                     0x30000u
#define GPIO_ICR2_ICR24_SHIFT                    16
#define GPIO_ICR2_ICR24(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR24_SHIFT))&GPIO_ICR2_ICR24_MASK)
#define GPIO_ICR2_ICR25_MASK                     0xC0000u
#define GPIO_ICR2_ICR25_SHIFT                    18
#define GPIO_ICR2_ICR25(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR25_SHIFT))&GPIO_ICR2_ICR25_MASK)
#define GPIO_ICR2_ICR26_MASK                     0x300000u
#define GPIO_ICR2_ICR26_SHIFT                    20
#define GPIO_ICR2_ICR26(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR26_SHIFT))&GPIO_ICR2_ICR26_MASK)
#define GPIO_ICR2_ICR27_MASK                     0xC00000u
#define GPIO_ICR2_ICR27_SHIFT                    22
#define GPIO_ICR2_ICR27(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR27_SHIFT))&GPIO_ICR2_ICR27_MASK)
#define GPIO_ICR2_ICR28_MASK                     0x3000000u
#define GPIO_ICR2_ICR28_SHIFT                    24
#define GPIO_ICR2_ICR28(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR28_SHIFT))&GPIO_ICR2_ICR28_MASK)
#define GPIO_ICR2_ICR29_MASK                     0xC000000u
#define GPIO_ICR2_ICR29_SHIFT                    26
#define GPIO_ICR2_ICR29(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR29_SHIFT))&GPIO_ICR2_ICR29_MASK)
#define GPIO_ICR2_ICR30_MASK                     0x30000000u
#define GPIO_ICR2_ICR30_SHIFT                    28
#define GPIO_ICR2_ICR30(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR30_SHIFT))&GPIO_ICR2_ICR30_MASK)
#define GPIO_ICR2_ICR31_MASK                     0xC0000000u
#define GPIO_ICR2_ICR31_SHIFT                    30
#define GPIO_ICR2_ICR31(x)                       (((uint32_t)(((uint32_t)(x))<<GPIO_ICR2_ICR31_SHIFT))&GPIO_ICR2_ICR31_MASK)
/* IMR Bit Fields */
#define GPIO_IMR_IMR_MASK                        0xFFFFFFFFu
#define GPIO_IMR_IMR_SHIFT                       0
#define GPIO_IMR_IMR(x)                          (((uint32_t)(((uint32_t)(x))<<GPIO_IMR_IMR_SHIFT))&GPIO_IMR_IMR_MASK)
/* ISR Bit Fields */
#define GPIO_ISR_ISR_MASK                        0xFFFFFFFFu
#define GPIO_ISR_ISR_SHIFT                       0
#define GPIO_ISR_ISR(x)                          (((uint32_t)(((uint32_t)(x))<<GPIO_ISR_ISR_SHIFT))&GPIO_ISR_ISR_MASK)
/* EDGE_SEL Bit Fields */
#define GPIO_EDGE_SEL_GPIO_EDGE_SEL_MASK         0xFFFFFFFFu
#define GPIO_EDGE_SEL_GPIO_EDGE_SEL_SHIFT        0
#define GPIO_EDGE_SEL_GPIO_EDGE_SEL(x)           (((uint32_t)(((uint32_t)(x))<<GPIO_EDGE_SEL_GPIO_EDGE_SEL_SHIFT))&GPIO_EDGE_SEL_GPIO_EDGE_SEL_MASK)

/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIO1 base pointer */
#define GPIO1_BASE_PTR                           ((GPIO_MemMapPtr)0x4209C000u)
/** Peripheral GPIO2 base pointer */
#define GPIO2_BASE_PTR                           ((GPIO_MemMapPtr)0x420A0000u)
/** Peripheral GPIO3 base pointer */
#define GPIO3_BASE_PTR                           ((GPIO_MemMapPtr)0x420A4000u)
/** Peripheral GPIO4 base pointer */
#define GPIO4_BASE_PTR                           ((GPIO_MemMapPtr)0x420A8000u)
/** Peripheral GPIO5 base pointer */
#define GPIO5_BASE_PTR                           ((GPIO_MemMapPtr)0x420AC000u)
/** Peripheral GPIO6 base pointer */
#define GPIO6_BASE_PTR                           ((GPIO_MemMapPtr)0x420B0000u)
/** Peripheral GPIO7 base pointer */
#define GPIO7_BASE_PTR                           ((GPIO_MemMapPtr)0x420B4000u)
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIO1_BASE_PTR, GPIO2_BASE_PTR, GPIO3_BASE_PTR, GPIO4_BASE_PTR, GPIO5_BASE_PTR, GPIO6_BASE_PTR, GPIO7_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register instance definitions */
/* GPIO1 */
#define GPIO1_DR                                 GPIO_DR_REG(GPIO1_BASE_PTR)
#define GPIO1_GDIR                               GPIO_GDIR_REG(GPIO1_BASE_PTR)
#define GPIO1_PSR                                GPIO_PSR_REG(GPIO1_BASE_PTR)
#define GPIO1_ICR1                               GPIO_ICR1_REG(GPIO1_BASE_PTR)
#define GPIO1_ICR2                               GPIO_ICR2_REG(GPIO1_BASE_PTR)
#define GPIO1_IMR                                GPIO_IMR_REG(GPIO1_BASE_PTR)
#define GPIO1_ISR                                GPIO_ISR_REG(GPIO1_BASE_PTR)
#define GPIO1_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO1_BASE_PTR)
/* GPIO2 */
#define GPIO2_DR                                 GPIO_DR_REG(GPIO2_BASE_PTR)
#define GPIO2_GDIR                               GPIO_GDIR_REG(GPIO2_BASE_PTR)
#define GPIO2_PSR                                GPIO_PSR_REG(GPIO2_BASE_PTR)
#define GPIO2_ICR1                               GPIO_ICR1_REG(GPIO2_BASE_PTR)
#define GPIO2_ICR2                               GPIO_ICR2_REG(GPIO2_BASE_PTR)
#define GPIO2_IMR                                GPIO_IMR_REG(GPIO2_BASE_PTR)
#define GPIO2_ISR                                GPIO_ISR_REG(GPIO2_BASE_PTR)
#define GPIO2_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO2_BASE_PTR)
/* GPIO3 */
#define GPIO3_DR                                 GPIO_DR_REG(GPIO3_BASE_PTR)
#define GPIO3_GDIR                               GPIO_GDIR_REG(GPIO3_BASE_PTR)
#define GPIO3_PSR                                GPIO_PSR_REG(GPIO3_BASE_PTR)
#define GPIO3_ICR1                               GPIO_ICR1_REG(GPIO3_BASE_PTR)
#define GPIO3_ICR2                               GPIO_ICR2_REG(GPIO3_BASE_PTR)
#define GPIO3_IMR                                GPIO_IMR_REG(GPIO3_BASE_PTR)
#define GPIO3_ISR                                GPIO_ISR_REG(GPIO3_BASE_PTR)
#define GPIO3_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO3_BASE_PTR)
/* GPIO4 */
#define GPIO4_DR                                 GPIO_DR_REG(GPIO4_BASE_PTR)
#define GPIO4_GDIR                               GPIO_GDIR_REG(GPIO4_BASE_PTR)
#define GPIO4_PSR                                GPIO_PSR_REG(GPIO4_BASE_PTR)
#define GPIO4_ICR1                               GPIO_ICR1_REG(GPIO4_BASE_PTR)
#define GPIO4_ICR2                               GPIO_ICR2_REG(GPIO4_BASE_PTR)
#define GPIO4_IMR                                GPIO_IMR_REG(GPIO4_BASE_PTR)
#define GPIO4_ISR                                GPIO_ISR_REG(GPIO4_BASE_PTR)
#define GPIO4_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO4_BASE_PTR)
/* GPIO5 */
#define GPIO5_DR                                 GPIO_DR_REG(GPIO5_BASE_PTR)
#define GPIO5_GDIR                               GPIO_GDIR_REG(GPIO5_BASE_PTR)
#define GPIO5_PSR                                GPIO_PSR_REG(GPIO5_BASE_PTR)
#define GPIO5_ICR1                               GPIO_ICR1_REG(GPIO5_BASE_PTR)
#define GPIO5_ICR2                               GPIO_ICR2_REG(GPIO5_BASE_PTR)
#define GPIO5_IMR                                GPIO_IMR_REG(GPIO5_BASE_PTR)
#define GPIO5_ISR                                GPIO_ISR_REG(GPIO5_BASE_PTR)
#define GPIO5_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO5_BASE_PTR)
/* GPIO6 */
#define GPIO6_DR                                 GPIO_DR_REG(GPIO6_BASE_PTR)
#define GPIO6_GDIR                               GPIO_GDIR_REG(GPIO6_BASE_PTR)
#define GPIO6_PSR                                GPIO_PSR_REG(GPIO6_BASE_PTR)
#define GPIO6_ICR1                               GPIO_ICR1_REG(GPIO6_BASE_PTR)
#define GPIO6_ICR2                               GPIO_ICR2_REG(GPIO6_BASE_PTR)
#define GPIO6_IMR                                GPIO_IMR_REG(GPIO6_BASE_PTR)
#define GPIO6_ISR                                GPIO_ISR_REG(GPIO6_BASE_PTR)
#define GPIO6_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO6_BASE_PTR)
/* GPIO7 */
#define GPIO7_DR                                 GPIO_DR_REG(GPIO7_BASE_PTR)
#define GPIO7_GDIR                               GPIO_GDIR_REG(GPIO7_BASE_PTR)
#define GPIO7_PSR                                GPIO_PSR_REG(GPIO7_BASE_PTR)
#define GPIO7_ICR1                               GPIO_ICR1_REG(GPIO7_BASE_PTR)
#define GPIO7_ICR2                               GPIO_ICR2_REG(GPIO7_BASE_PTR)
#define GPIO7_IMR                                GPIO_IMR_REG(GPIO7_BASE_PTR)
#define GPIO7_ISR                                GPIO_ISR_REG(GPIO7_BASE_PTR)
#define GPIO7_EDGE_SEL                           GPIO_EDGE_SEL_REG(GPIO7_BASE_PTR)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GPIO_Peripheral */


/* ----------------------------------------------------------------------------
   -- GPMI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPMI_Peripheral GPMI
 * @{
 */

/** GPMI - Peripheral register structure */
typedef struct GPMI_MemMap {
  uint32_t CTRL0;                                  /**< GPMI Control Register 0 Description, offset: 0x0 */
  uint32_t CTRL0_SET;                              /**< GPMI Control Register 0 Description, offset: 0x4 */
  uint32_t CTRL0_CLR;                              /**< GPMI Control Register 0 Description, offset: 0x8 */
  uint32_t CTRL0_TOG;                              /**< GPMI Control Register 0 Description, offset: 0xC */
  uint32_t COMPARE;                                /**< GPMI Compare Register Description, offset: 0x10 */
  uint8_t RESERVED_0[12];
  uint32_t ECCCTRL;                                /**< GPMI Integrated ECC Control Register Description, offset: 0x20 */
  uint32_t ECCCTRL_SET;                            /**< GPMI Integrated ECC Control Register Description, offset: 0x24 */
  uint32_t ECCCTRL_CLR;                            /**< GPMI Integrated ECC Control Register Description, offset: 0x28 */
  uint32_t ECCCTRL_TOG;                            /**< GPMI Integrated ECC Control Register Description, offset: 0x2C */
  uint32_t ECCCOUNT;                               /**< GPMI Integrated ECC Transfer Count Register Description, offset: 0x30 */
  uint8_t RESERVED_1[12];
  uint32_t PAYLOAD;                                /**< GPMI Payload Address Register Description, offset: 0x40 */
  uint8_t RESERVED_2[12];
  uint32_t AUXILIARY;                              /**< GPMI Auxiliary Address Register Description, offset: 0x50 */
  uint8_t RESERVED_3[12];
  uint32_t CTRL1;                                  /**< GPMI Control Register 1 Description, offset: 0x60 */
  uint32_t CTRL1_SET;                              /**< GPMI Control Register 1 Description, offset: 0x64 */
  uint32_t CTRL1_CLR;                              /**< GPMI Control Register 1 Description, offset: 0x68 */
  uint32_t CTRL1_TOG;                              /**< GPMI Control Register 1 Description, offset: 0x6C */
  uint32_t TIMING0;                                /**< GPMI Timing Register 0 Description, offset: 0x70 */
  uint8_t RESERVED_4[12];
  uint32_t TIMING1;                                /**< GPMI Timing Register 1 Description, offset: 0x80 */
  uint8_t RESERVED_5[12];
  uint32_t TIMING2;                                /**< GPMI Timing Register 2 Description, offset: 0x90 */
  uint8_t RESERVED_6[12];
  uint32_t DATA;                                   /**< GPMI DMA Data Transfer Register Description, offset: 0xA0 */
  uint8_t RESERVED_7[12];
  uint32_t STAT;                                   /**< GPMI Status Register Description, offset: 0xB0 */
  uint8_t RESERVED_8[12];
  uint32_t DEBUG;                                  /**< GPMI Debug Information Register Description, offset: 0xC0 */
  uint8_t RESERVED_9[12];
  uint32_t VERSION;                                /**< GPMI Version Register Description, offset: 0xD0 */
  uint8_t RESERVED_10[12];
  uint32_t DEBUG2;                                 /**< GPMI Debug2 Information Register Description, offset: 0xE0 */
  uint8_t RESERVED_11[12];
  uint32_t DEBUG3;                                 /**< GPMI Debug3 Information Register Description, offset: 0xF0 */
  uint8_t RESERVED_12[12];
  uint32_t READ_DDR_DLL_CTRL;                      /**< GPMI Double Rate Read DLL Control Register Description, offset: 0x100 */
  uint8_t RESERVED_13[12];
  uint32_t WRITE_DDR_DLL_CTRL;                     /**< GPMI Double Rate Write DLL Control Register Description, offset: 0x110 */
  uint8_t RESERVED_14[12];
  uint32_t READ_DDR_DLL_STS;                       /**< GPMI Double Rate Read DLL Status Register Description, offset: 0x120 */
  uint8_t RESERVED_15[12];
  uint32_t WRITE_DDR_DLL_STS;                      /**< GPMI Double Rate Write DLL Status Register Description, offset: 0x130 */
} volatile *GPMI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPMI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPMI_Register_Accessor_Macros GPMI - Register accessor macros
 * @{
 */


/* GPMI - Register accessors */
#define GPMI_CTRL0_REG(base)                     ((base)->CTRL0)
#define GPMI_CTRL0_SET_REG(base)                 ((base)->CTRL0_SET)
#define GPMI_CTRL0_CLR_REG(base)                 ((base)->CTRL0_CLR)
#define GPMI_CTRL0_TOG_REG(base)                 ((base)->CTRL0_TOG)
#define GPMI_COMPARE_REG(base)                   ((base)->COMPARE)
#define GPMI_ECCCTRL_REG(base)                   ((base)->ECCCTRL)
#define GPMI_ECCCTRL_SET_REG(base)               ((base)->ECCCTRL_SET)
#define GPMI_ECCCTRL_CLR_REG(base)               ((base)->ECCCTRL_CLR)
#define GPMI_ECCCTRL_TOG_REG(base)               ((base)->ECCCTRL_TOG)
#define GPMI_ECCCOUNT_REG(base)                  ((base)->ECCCOUNT)
#define GPMI_PAYLOAD_REG(base)                   ((base)->PAYLOAD)
#define GPMI_AUXILIARY_REG(base)                 ((base)->AUXILIARY)
#define GPMI_CTRL1_REG(base)                     ((base)->CTRL1)
#define GPMI_CTRL1_SET_REG(base)                 ((base)->CTRL1_SET)
#define GPMI_CTRL1_CLR_REG(base)                 ((base)->CTRL1_CLR)
#define GPMI_CTRL1_TOG_REG(base)                 ((base)->CTRL1_TOG)
#define GPMI_TIMING0_REG(base)                   ((base)->TIMING0)
#define GPMI_TIMING1_REG(base)                   ((base)->TIMING1)
#define GPMI_TIMING2_REG(base)                   ((base)->TIMING2)
#define GPMI_DATA_REG(base)                      ((base)->DATA)
#define GPMI_STAT_REG(base)                      ((base)->STAT)
#define GPMI_DEBUG_REG(base)                     ((base)->DEBUG)
#define GPMI_VERSION_REG(base)                   ((base)->VERSION)
#define GPMI_DEBUG2_REG(base)                    ((base)->DEBUG2)
#define GPMI_DEBUG3_REG(base)                    ((base)->DEBUG3)
#define GPMI_READ_DDR_DLL_CTRL_REG(base)         ((base)->READ_DDR_DLL_CTRL)
#define GPMI_WRITE_DDR_DLL_CTRL_REG(base)        ((base)->WRITE_DDR_DLL_CTRL)
#define GPMI_READ_DDR_DLL_STS_REG(base)          ((base)->READ_DDR_DLL_STS)
#define GPMI_WRITE_DDR_DLL_STS_REG(base)         ((base)->WRITE_DDR_DLL_STS)

/*!
 * @}
 */ /* end of group GPMI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPMI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPMI_Register_Masks GPMI Register Masks
 * @{
 */

/* CTRL0 Bit Fields */
#define GPMI_CTRL0_XFER_COUNT_MASK               0xFFFFu
#define GPMI_CTRL0_XFER_COUNT_SHIFT              0
#define GPMI_CTRL0_XFER_COUNT(x)                 (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_XFER_COUNT_SHIFT))&GPMI_CTRL0_XFER_COUNT_MASK)
#define GPMI_CTRL0_ADDRESS_INCREMENT_MASK        0x10000u
#define GPMI_CTRL0_ADDRESS_INCREMENT_SHIFT       16
#define GPMI_CTRL0_ADDRESS_MASK                  0xE0000u
#define GPMI_CTRL0_ADDRESS_SHIFT                 17
#define GPMI_CTRL0_ADDRESS(x)                    (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_ADDRESS_SHIFT))&GPMI_CTRL0_ADDRESS_MASK)
#define GPMI_CTRL0_CS_MASK                       0x700000u
#define GPMI_CTRL0_CS_SHIFT                      20
#define GPMI_CTRL0_CS(x)                         (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_CS_SHIFT))&GPMI_CTRL0_CS_MASK)
#define GPMI_CTRL0_WORD_LENGTH_MASK              0x800000u
#define GPMI_CTRL0_WORD_LENGTH_SHIFT             23
#define GPMI_CTRL0_COMMAND_MODE_MASK             0x3000000u
#define GPMI_CTRL0_COMMAND_MODE_SHIFT            24
#define GPMI_CTRL0_COMMAND_MODE(x)               (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_COMMAND_MODE_SHIFT))&GPMI_CTRL0_COMMAND_MODE_MASK)
#define GPMI_CTRL0_UDMA_MASK                     0x4000000u
#define GPMI_CTRL0_UDMA_SHIFT                    26
#define GPMI_CTRL0_LOCK_CS_MASK                  0x8000000u
#define GPMI_CTRL0_LOCK_CS_SHIFT                 27
#define GPMI_CTRL0_DEV_IRQ_EN_MASK               0x10000000u
#define GPMI_CTRL0_DEV_IRQ_EN_SHIFT              28
#define GPMI_CTRL0_RUN_MASK                      0x20000000u
#define GPMI_CTRL0_RUN_SHIFT                     29
#define GPMI_CTRL0_CLKGATE_MASK                  0x40000000u
#define GPMI_CTRL0_CLKGATE_SHIFT                 30
#define GPMI_CTRL0_SFTRST_MASK                   0x80000000u
#define GPMI_CTRL0_SFTRST_SHIFT                  31
/* CTRL0_SET Bit Fields */
#define GPMI_CTRL0_SET_XFER_COUNT_MASK           0xFFFFu
#define GPMI_CTRL0_SET_XFER_COUNT_SHIFT          0
#define GPMI_CTRL0_SET_XFER_COUNT(x)             (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_SET_XFER_COUNT_SHIFT))&GPMI_CTRL0_SET_XFER_COUNT_MASK)
#define GPMI_CTRL0_SET_ADDRESS_INCREMENT_MASK    0x10000u
#define GPMI_CTRL0_SET_ADDRESS_INCREMENT_SHIFT   16
#define GPMI_CTRL0_SET_ADDRESS_MASK              0xE0000u
#define GPMI_CTRL0_SET_ADDRESS_SHIFT             17
#define GPMI_CTRL0_SET_ADDRESS(x)                (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_SET_ADDRESS_SHIFT))&GPMI_CTRL0_SET_ADDRESS_MASK)
#define GPMI_CTRL0_SET_CS_MASK                   0x700000u
#define GPMI_CTRL0_SET_CS_SHIFT                  20
#define GPMI_CTRL0_SET_CS(x)                     (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_SET_CS_SHIFT))&GPMI_CTRL0_SET_CS_MASK)
#define GPMI_CTRL0_SET_WORD_LENGTH_MASK          0x800000u
#define GPMI_CTRL0_SET_WORD_LENGTH_SHIFT         23
#define GPMI_CTRL0_SET_COMMAND_MODE_MASK         0x3000000u
#define GPMI_CTRL0_SET_COMMAND_MODE_SHIFT        24
#define GPMI_CTRL0_SET_COMMAND_MODE(x)           (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_SET_COMMAND_MODE_SHIFT))&GPMI_CTRL0_SET_COMMAND_MODE_MASK)
#define GPMI_CTRL0_SET_UDMA_MASK                 0x4000000u
#define GPMI_CTRL0_SET_UDMA_SHIFT                26
#define GPMI_CTRL0_SET_LOCK_CS_MASK              0x8000000u
#define GPMI_CTRL0_SET_LOCK_CS_SHIFT             27
#define GPMI_CTRL0_SET_DEV_IRQ_EN_MASK           0x10000000u
#define GPMI_CTRL0_SET_DEV_IRQ_EN_SHIFT          28
#define GPMI_CTRL0_SET_RUN_MASK                  0x20000000u
#define GPMI_CTRL0_SET_RUN_SHIFT                 29
#define GPMI_CTRL0_SET_CLKGATE_MASK              0x40000000u
#define GPMI_CTRL0_SET_CLKGATE_SHIFT             30
#define GPMI_CTRL0_SET_SFTRST_MASK               0x80000000u
#define GPMI_CTRL0_SET_SFTRST_SHIFT              31
/* CTRL0_CLR Bit Fields */
#define GPMI_CTRL0_CLR_XFER_COUNT_MASK           0xFFFFu
#define GPMI_CTRL0_CLR_XFER_COUNT_SHIFT          0
#define GPMI_CTRL0_CLR_XFER_COUNT(x)             (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_CLR_XFER_COUNT_SHIFT))&GPMI_CTRL0_CLR_XFER_COUNT_MASK)
#define GPMI_CTRL0_CLR_ADDRESS_INCREMENT_MASK    0x10000u
#define GPMI_CTRL0_CLR_ADDRESS_INCREMENT_SHIFT   16
#define GPMI_CTRL0_CLR_ADDRESS_MASK              0xE0000u
#define GPMI_CTRL0_CLR_ADDRESS_SHIFT             17
#define GPMI_CTRL0_CLR_ADDRESS(x)                (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_CLR_ADDRESS_SHIFT))&GPMI_CTRL0_CLR_ADDRESS_MASK)
#define GPMI_CTRL0_CLR_CS_MASK                   0x700000u
#define GPMI_CTRL0_CLR_CS_SHIFT                  20
#define GPMI_CTRL0_CLR_CS(x)                     (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_CLR_CS_SHIFT))&GPMI_CTRL0_CLR_CS_MASK)
#define GPMI_CTRL0_CLR_WORD_LENGTH_MASK          0x800000u
#define GPMI_CTRL0_CLR_WORD_LENGTH_SHIFT         23
#define GPMI_CTRL0_CLR_COMMAND_MODE_MASK         0x3000000u
#define GPMI_CTRL0_CLR_COMMAND_MODE_SHIFT        24
#define GPMI_CTRL0_CLR_COMMAND_MODE(x)           (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_CLR_COMMAND_MODE_SHIFT))&GPMI_CTRL0_CLR_COMMAND_MODE_MASK)
#define GPMI_CTRL0_CLR_UDMA_MASK                 0x4000000u
#define GPMI_CTRL0_CLR_UDMA_SHIFT                26
#define GPMI_CTRL0_CLR_LOCK_CS_MASK              0x8000000u
#define GPMI_CTRL0_CLR_LOCK_CS_SHIFT             27
#define GPMI_CTRL0_CLR_DEV_IRQ_EN_MASK           0x10000000u
#define GPMI_CTRL0_CLR_DEV_IRQ_EN_SHIFT          28
#define GPMI_CTRL0_CLR_RUN_MASK                  0x20000000u
#define GPMI_CTRL0_CLR_RUN_SHIFT                 29
#define GPMI_CTRL0_CLR_CLKGATE_MASK              0x40000000u
#define GPMI_CTRL0_CLR_CLKGATE_SHIFT             30
#define GPMI_CTRL0_CLR_SFTRST_MASK               0x80000000u
#define GPMI_CTRL0_CLR_SFTRST_SHIFT              31
/* CTRL0_TOG Bit Fields */
#define GPMI_CTRL0_TOG_XFER_COUNT_MASK           0xFFFFu
#define GPMI_CTRL0_TOG_XFER_COUNT_SHIFT          0
#define GPMI_CTRL0_TOG_XFER_COUNT(x)             (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_TOG_XFER_COUNT_SHIFT))&GPMI_CTRL0_TOG_XFER_COUNT_MASK)
#define GPMI_CTRL0_TOG_ADDRESS_INCREMENT_MASK    0x10000u
#define GPMI_CTRL0_TOG_ADDRESS_INCREMENT_SHIFT   16
#define GPMI_CTRL0_TOG_ADDRESS_MASK              0xE0000u
#define GPMI_CTRL0_TOG_ADDRESS_SHIFT             17
#define GPMI_CTRL0_TOG_ADDRESS(x)                (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_TOG_ADDRESS_SHIFT))&GPMI_CTRL0_TOG_ADDRESS_MASK)
#define GPMI_CTRL0_TOG_CS_MASK                   0x700000u
#define GPMI_CTRL0_TOG_CS_SHIFT                  20
#define GPMI_CTRL0_TOG_CS(x)                     (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_TOG_CS_SHIFT))&GPMI_CTRL0_TOG_CS_MASK)
#define GPMI_CTRL0_TOG_WORD_LENGTH_MASK          0x800000u
#define GPMI_CTRL0_TOG_WORD_LENGTH_SHIFT         23
#define GPMI_CTRL0_TOG_COMMAND_MODE_MASK         0x3000000u
#define GPMI_CTRL0_TOG_COMMAND_MODE_SHIFT        24
#define GPMI_CTRL0_TOG_COMMAND_MODE(x)           (((uint32_t)(((uint32_t)(x))<<GPMI_CTRL0_TOG_COMMAND_MODE_SHIFT))&GPMI_CTRL0_TOG_COMMAND_MODE_MASK)
#define GPMI_CTRL0_TOG_UDMA_MASK                 0x4000000u
#define GPMI_CTRL0_TOG_UDMA_SHIFT                26
#define GPMI_CTRL0_TOG_LOCK_CS_MASK              0x8000000u
#define GPMI_CTRL0_TOG_LOCK_CS_SHIFT             27
#define GPMI_CTRL0_TOG_DEV_IRQ_EN_MASK           0x10000000u
#define GPMI_CTRL0_TOG_DEV_IRQ_EN_SHIFT          28
#define GPMI_CTRL0_TOG_RUN_MASK                  0x20000000u
#define GPMI_CTRL0_TOG_RUN_SHIFT                 29
#define GPMI_CTRL0_TOG_CLKGATE_MASK              0x40000000u
#define GPMI_CTRL0_TOG_CLKGATE_SHIFT             30
#define GPMI_CTRL0_TOG_SFTRST_MASK               0x80000000u
#define GPMI_CTRL0_TOG_SFTRST_SHIFT              31
/* COMPARE Bit Fields */
#define GPMI_COMPARE_REFERENCE_MASK              0xFFFFu
#define GPMI_COMPARE_REFERENCE_SHIFT             0
#define GPMI_COMPARE_REFERENCE(x)                (((uint32_t)(((uint32_t)(x))<<GPMI_COMPARE_REFERENCE_SHIFT))&GPMI_COMPARE_REFERENCE_MASK)
#define GPMI_COMPARE_MASK_MASK                   0xFFFF0000u
#define GPMI_COMPARE_MASK_SHIFT                  16
#define GPMI_COMPARE_MASK(x)                     (((uint32_t)(((uint32_t)(x))<<GPMI_COMPARE_MASK_SHIFT))&GPMI_COMPARE_MASK_MASK)
/* ECCCTRL Bit Fields */
#define GPMI_ECCCTRL_BUFFER_MASK_MASK            0x1FFu
#define GPMI_ECCCTRL_BUFFER_MASK_SHIFT           0
#define GPMI_ECCCTRL_BUFFER_MASK(x)              (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_BUFFER_MASK_SHIFT))&GPMI_ECCCTRL_BUFFER_MASK_MASK)
#define GPMI_ECCCTRL_RANDOMIZER_ENABLE_MASK      0x800u
#define GPMI_ECCCTRL_RANDOMIZER_ENABLE_SHIFT     11
#define GPMI_ECCCTRL_ENABLE_ECC_MASK             0x1000u
#define GPMI_ECCCTRL_ENABLE_ECC_SHIFT            12
#define GPMI_ECCCTRL_ECC_CMD_MASK                0x6000u
#define GPMI_ECCCTRL_ECC_CMD_SHIFT               13
#define GPMI_ECCCTRL_ECC_CMD(x)                  (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_ECC_CMD_SHIFT))&GPMI_ECCCTRL_ECC_CMD_MASK)
#define GPMI_ECCCTRL_RSVD2_MASK                  0x8000u
#define GPMI_ECCCTRL_RSVD2_SHIFT                 15
#define GPMI_ECCCTRL_HANDLE_MASK                 0xFFFF0000u
#define GPMI_ECCCTRL_HANDLE_SHIFT                16
#define GPMI_ECCCTRL_HANDLE(x)                   (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_HANDLE_SHIFT))&GPMI_ECCCTRL_HANDLE_MASK)
/* ECCCTRL_SET Bit Fields */
#define GPMI_ECCCTRL_SET_BUFFER_MASK_MASK        0x1FFu
#define GPMI_ECCCTRL_SET_BUFFER_MASK_SHIFT       0
#define GPMI_ECCCTRL_SET_BUFFER_MASK(x)          (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_SET_BUFFER_MASK_SHIFT))&GPMI_ECCCTRL_SET_BUFFER_MASK_MASK)
#define GPMI_ECCCTRL_SET_RANDOMIZER_ENABLE_MASK  0x800u
#define GPMI_ECCCTRL_SET_RANDOMIZER_ENABLE_SHIFT 11
#define GPMI_ECCCTRL_SET_ENABLE_ECC_MASK         0x1000u
#define GPMI_ECCCTRL_SET_ENABLE_ECC_SHIFT        12
#define GPMI_ECCCTRL_SET_ECC_CMD_MASK            0x6000u
#define GPMI_ECCCTRL_SET_ECC_CMD_SHIFT           13
#define GPMI_ECCCTRL_SET_ECC_CMD(x)              (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_SET_ECC_CMD_SHIFT))&GPMI_ECCCTRL_SET_ECC_CMD_MASK)
#define GPMI_ECCCTRL_SET_RSVD2_MASK              0x8000u
#define GPMI_ECCCTRL_SET_RSVD2_SHIFT             15
#define GPMI_ECCCTRL_SET_HANDLE_MASK             0xFFFF0000u
#define GPMI_ECCCTRL_SET_HANDLE_SHIFT            16
#define GPMI_ECCCTRL_SET_HANDLE(x)               (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_SET_HANDLE_SHIFT))&GPMI_ECCCTRL_SET_HANDLE_MASK)
/* ECCCTRL_CLR Bit Fields */
#define GPMI_ECCCTRL_CLR_BUFFER_MASK_MASK        0x1FFu
#define GPMI_ECCCTRL_CLR_BUFFER_MASK_SHIFT       0
#define GPMI_ECCCTRL_CLR_BUFFER_MASK(x)          (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_CLR_BUFFER_MASK_SHIFT))&GPMI_ECCCTRL_CLR_BUFFER_MASK_MASK)
#define GPMI_ECCCTRL_CLR_RANDOMIZER_ENABLE_MASK  0x800u
#define GPMI_ECCCTRL_CLR_RANDOMIZER_ENABLE_SHIFT 11
#define GPMI_ECCCTRL_CLR_ENABLE_ECC_MASK         0x1000u
#define GPMI_ECCCTRL_CLR_ENABLE_ECC_SHIFT        12
#define GPMI_ECCCTRL_CLR_ECC_CMD_MASK            0x6000u
#define GPMI_ECCCTRL_CLR_ECC_CMD_SHIFT           13
#define GPMI_ECCCTRL_CLR_ECC_CMD(x)              (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_CLR_ECC_CMD_SHIFT))&GPMI_ECCCTRL_CLR_ECC_CMD_MASK)
#define GPMI_ECCCTRL_CLR_RSVD2_MASK              0x8000u
#define GPMI_ECCCTRL_CLR_RSVD2_SHIFT             15
#define GPMI_ECCCTRL_CLR_HANDLE_MASK             0xFFFF0000u
#define GPMI_ECCCTRL_CLR_HANDLE_SHIFT            16
#define GPMI_ECCCTRL_CLR_HANDLE(x)               (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_CLR_HANDLE_SHIFT))&GPMI_ECCCTRL_CLR_HANDLE_MASK)
/* ECCCTRL_TOG Bit Fields */
#define GPMI_ECCCTRL_TOG_BUFFER_MASK_MASK        0x1FFu
#define GPMI_ECCCTRL_TOG_BUFFER_MASK_SHIFT       0
#define GPMI_ECCCTRL_TOG_BUFFER_MASK(x)          (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_TOG_BUFFER_MASK_SHIFT))&GPMI_ECCCTRL_TOG_BUFFER_MASK_MASK)
#define GPMI_ECCCTRL_TOG_RANDOMIZER_ENABLE_MASK  0x800u
#define GPMI_ECCCTRL_TOG_RANDOMIZER_ENABLE_SHIFT 11
#define GPMI_ECCCTRL_TOG_ENABLE_ECC_MASK         0x1000u
#define GPMI_ECCCTRL_TOG_ENABLE_ECC_SHIFT        12
#define GPMI_ECCCTRL_TOG_ECC_CMD_MASK            0x6000u
#define GPMI_ECCCTRL_TOG_ECC_CMD_SHIFT           13
#define GPMI_ECCCTRL_TOG_ECC_CMD(x)              (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_TOG_ECC_CMD_SHIFT))&GPMI_ECCCTRL_TOG_ECC_CMD_MASK)
#define GPMI_ECCCTRL_TOG_RSVD2_MASK              0x8000u
#define GPMI_ECCCTRL_TOG_RSVD2_SHIFT             15
#define GPMI_ECCCTRL_TOG_HANDLE_MASK             0xFFFF0000u
#define GPMI_ECCCTRL_TOG_HANDLE_SHIFT            16
#define GPMI_ECCCTRL_TOG_HANDLE(x)               (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCTRL_TOG_HANDLE_SHIFT))&GPMI_ECCCTRL_TOG_HANDLE_MASK)
/* ECCCOUNT Bit Fields */
#define GPMI_ECCCOUNT_COUNT_MASK                 0xFFFFu
#define GPMI_ECCCOUNT_COUNT_SHIFT                0
#define GPMI_ECCCOUNT_COUNT(x)                   (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCOUNT_COUNT_SHIFT))&GPMI_ECCCOUNT_COUNT_MASK)
#define GPMI_ECCCOUNT_RANDOMIZER_PAGE_MASK       0xFF0000u
#define GPMI_ECCCOUNT_RANDOMIZER_PAGE_SHIFT      16
#define GPMI_ECCCOUNT_RANDOMIZER_PAGE(x)         (((uint32_t)(((uint32_t)(x))<<GPMI_ECCCOUNT_RANDOMIZER_PAGE_SHIFT))&GPMI_ECCCOUNT_RANDOMIZER_PAGE_MASK)
/* PAYLOAD Bit Fields */
#define GPMI_PAYLOAD_RSVD0_MASK                  0x3u
#define GPMI_PAYLOAD_RSVD0_SHIFT                 0
#define GPMI_PAYLOAD_RSVD0(x)                    (((uint32_t)(((uint32_t)(x))<<GPMI_PAYLOAD_RSVD0_SHIFT))&GPMI_PAYLOAD_RSVD0_MASK)
#define GPMI_PAYLOAD_ADDRESS_MASK                0xFFFFFFFCu
#define GPMI_PAYLOAD_ADDRESS_SHIFT               2
#define GPMI_PAYLOAD_ADDRESS(x)                  (((uint32_t)(((uint32_t)(x))<<GPMI_PAYLOAD_ADDRESS_SHIFT))&GPMI_PAYLOAD_ADDRESS_MASK)
/* AUXILIARY Bit Fields */
#define GPMI_AUXILIARY_RSVD0_MASK                0x3u
#define GPMI_AUXILIARY_RSVD0_SHIFT               0
#define GPMI_AUXILIARY_RSVD0(x)                  (((uint32_t)(((uint32_t)(x))<<GPMI_AUXILIARY_RSVD0_SHIFT))&GPMI_AUXILIARY_RSVD0_MASK)
#define GPMI_AUXILIARY_ADDRESS_MASK              0xFFFFFFFCu
#define GPMI_AUXILIARY_ADDRESS_SHIFT             2
#define GPMI_AUXILIARY_ADDRESS(x)                (((uint32_t)(((uint32_t)(x))<<GPMI_AUXILIARY_ADDRESS_SHIFT))&GPMI_AUXILIARY_ADDRESS_MASK)
/* CTRL1 Bit Fields */
#define GPMI_CTRL1_GPMI_MODE_MASK                0x1u
#define GPMI_CTRL1_GPMI_MODE_SHIFT               0
#define GPMI_CTRL1_CAMERA_MODE_MASK              0x2u
#define GPMI_CTRL1_CAMERA_MODE_SHIFT             1
#define GPMI