var Galileo = require("galileo-io");
var five = require("johnny-five");
var StateMachine = require("javascript-state-machine");
var keypress = require("keypress");
var tick = global.setImmediate || process.nextTick;

var board = new five.Board({
  io: new Galileo()
});

var constrain = five.Fn.constrain;

board.on("ready", function() {
  var speed = 0.1;

  var drive = new five.Servo({
    pin: 9,
    range: [74, 125],
    type: "continuous",
    isInverted: true,
    center: true
  });

  var steer = new five.Servo({
    pin: 10,
    range: [86, 108],
    startAt: 100
  });


  // TODO:
  //
  //
  //  - Sensors
  //  - Navigation
  //  - GPS
  //
  //
  //

  this.repl.inject({
    drive: drive,
    steer: steer
  });

  var direction = 1;

  // Manual Controls with Remote keyboard.
  function controller(ch, key) {
    var isSteering = false;
    var isThrottle = false;

    // console.log(key);
    if (key) {
      if (key.name === "space") {
        speed = 0.2;
        drive.stop();
      }
      if (key.name === "up") {
        isThrottle = true;
        speed += 0.01;

        // Change direction on shift
        if (key.shift) {
          direction = 1;
        }
      }
      if (key.name === "down") {
        isThrottle = true;
        speed -= 0.01;

        // Change direction on shift
        if (key.shift) {
          direction = -1;
        }
      }
      if (key.name === "right") {
        isSteering = true;
        steer.to(steer.value + 2);
      }
      if (key.name === "left") {
        isSteering = true;
        steer.to(steer.value - 2);
      }
    }

    if (isThrottle) {
      drive[direction === 1 ? "cw" : "ccw"](speed = constrain(speed, 0, 1));
      console.log("Speed: %d", speed);
    }

    if (isSteering) {
      console.log("Steering Angle: %d", steer.value);
    }
  }


  keypress(process.stdin);

  process.stdin.on("keypress", controller);
  process.stdin.setRawMode(true);
  process.stdin.resume();
});

function Sample(samples) {
  Array.call(this, samples);
  Object.defineProperties(this, {
    samples: {
      value: samples
    },
    average: {
      get: function() {
        var average = 0;
        var value = 0;

        if (this.length === samples) {
          for (var i = 0; i < samples; i++) {
            value += this[i];
          }

          average = value / samples;
          this.length = 0;
          return average;
        }
        return null;
      }
    }
  });
}

Sample.prototype = Object.create(Array.prototype, {
  constructor: {
    value: Sample
  }
});
