module.exports = function(five) {
  return (function() {

    function Lever(pin) {
      five.Sensor.call(this, pin);

      var step = 1023 / 3;
      var none = step;
      var up = step * 2;

      var ranges = [
        // RELEASE
        [step, (step * 2) - 1],
        // DOWN
        [0, step - 1],
        // UP
        [step * 2, step *3],
      ];

      var hold = {
        code: null,
        timeout: null
      };

      var last = Object.assign({}, new Lever.Event(0x00));

      this.on("data", function() {
        var code = Lever.RELEASE;
        var now = Date.now();
        var pivot, event;

        if (ranges[Lever.DOWN].includes(this.value)) {
          code = Lever.DOWN;
        }

        if (ranges[Lever.UP].includes(this.value)) {
          code = Lever.UP;
        }

        if (code !== last.code) {
          event = "pivot";
        } else {
          if (code !== Lever.RELEASE && now >= last.timestamp + 100) {
            event = "hold";
          }
        }

        if (event) {
          pivot = new Lever.Event(code);
          this.emit(event, new Lever.Event(code));
        }

        Object.assign(last, pivot);
      });
    }

    Lever.Event = function(code) {
      this.type = Lever.NAMES[code];
      this.timestamp = Date.now();
      this.code = code;
    };

    Object.defineProperties(Lever, {
      RELEASE: {
        value: 0x00
      },
      DOWN: {
        value: 0x01
      },
      UP: {
        value: 0x02
      },
      NAMES: {
        value: ["idle", "down", "up"]
      }
    });

    Lever.prototype = Object.create(five.Sensor.prototype, {
      constructor: {
        value: Lever
      }
    });

    return Lever;
  }());
};
