var five = require("../lib/johnny-five.js");
var temporal = require("temporal");
var board = new five.Board();

board.on("ready", function() {

  var isArming = false;
  var isListening = false;

  var volume = 0;
  var previous = 0;

  var startedAt = null;
  var phase = null;

  var throttle = new five.Sensor("A1");
  var microphone = new five.Sensor("A0");
  var esc = new five.ESC(9);
  var relay = new five.Relay({
    pin: 8,
    type: "NC"
  });

  relay.off();


  throttle.scale([-1, 140]).on("change", function() {
    console.log(this.value | 0);
    esc.speed(this.value | 0);
  });

  microphone.on("data", function() {
    var value = this.value - 760;

    if (!isListening || value < 0) {
      return;
    }

    volume = Math.abs(value);

    if (volume > 100 && volume !== previous && startedAt === null) {
      startedAt = Date.now();
      previous = volume;
    }

    // Phase 1 is complete after a 2s tone is heard
    if (phase === 1 && startedAt !== null && Date.now() >= startedAt + 2000) {
      startedAt = null;
      console.log("Phase 1 complete, shutting relay off");
      relay.off();
      arm();
    }

    if (phase === 2 && startedAt !== null && Date.now() >= startedAt + 100) {
      startedAt = null;
      console.log("Phase 2 complete, safe to throttle up");

      isListening = false;
      phase = 0;
    }
  });

  function arm() {
    isListening = false;
    phase++;

    if (phase === 1 || phase === 2) {
      relay.off();
      esc.speed(100);
    }

    if (phase === 3) {
      esc.speed(1);
    }

    temporal.queue([{
      wait: 1000,
      task: function() {
        console.log("switching relay on");
        relay.on();
      }
    }, {
      wait: 8000,
      task: function() {
        if (phase === 1 || phase === 2) {
          console.log("next phase: ", phase + 1);
          arm();
        } else {
          esc.speed(0);
        }
      }
    }]);
  }

  this.repl.inject({
    arm: arm,
    esc: esc,
    relay: relay
  });
});
