/* test_resolver.c
 * strophe XMPP client library -- tests for resolver
 *
 * Copyright (C) 2015 Dmitry Podgorny <pasis.ua@gmail.com>
 *
 *  This software is provided AS-IS with no warranty, either express
 *  or implied.
 *
 *  This program is dual licensed under the MIT and GPLv3 licenses.
 */

/* gcc -o test_resolver -I. -I./src tests/test_resolver.c -static -lstrophe */

#include <assert.h>
#include <stdio.h>

#include "resolver.h"
#include "test.h"

/* res_query("_xmpp-client._tcp.jabber.kiev.ua", C_IN, T_SRV, ...) */
static const unsigned char data1[] = {
    0x95, 0xf3, 0x81, 0x80, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x5f, 0x78, 0x6d,
    0x70, 0x70, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
    0x74, 0x04, 0x5f, 0x74, 0x63, 0x70, 0x06, 0x6a,
    0x61, 0x62, 0x62, 0x65, 0x72, 0x04, 0x6b, 0x69,
    0x65, 0x76, 0x02, 0x75, 0x61, 0x00, 0x00, 0x21,
    0x00, 0x01, 0xc0, 0x0c, 0x00, 0x21, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x3b, 0x00, 0x16, 0x00, 0x01,
    0x00, 0x00, 0x14, 0x66, 0x06, 0x6a, 0x61, 0x62,
    0x62, 0x65, 0x72, 0x04, 0x6b, 0x69, 0x65, 0x76,
    0x02, 0x75, 0x61, 0x00,
};
/* res_query("_xmpp-client._tcp.jabber.org", C_IN, T_SRV, ...) */
static const unsigned char data2[] = {
    0xf2, 0x98, 0x81, 0x80, 0x00, 0x01, 0x00, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x5f, 0x78, 0x6d,
    0x70, 0x70, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
    0x74, 0x04, 0x5f, 0x74, 0x63, 0x70, 0x06, 0x6a,
    0x61, 0x62, 0x62, 0x65, 0x72, 0x03, 0x6f, 0x72,
    0x67, 0x00, 0x00, 0x21, 0x00, 0x01, 0xc0, 0x0c,
    0x00, 0x21, 0x00, 0x01, 0x00, 0x00, 0x03, 0x83,
    0x00, 0x1a, 0x00, 0x1e, 0x00, 0x1e, 0x14, 0x66,
    0x07, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x73, 0x32,
    0x06, 0x6a, 0x61, 0x62, 0x62, 0x65, 0x72, 0x03,
    0x6f, 0x72, 0x67, 0x00, 0xc0, 0x0c, 0x00, 0x21,
    0x00, 0x01, 0x00, 0x00, 0x03, 0x83, 0x00, 0x1c,
    0x00, 0x1f, 0x00, 0x1e, 0x14, 0x66, 0x09, 0x68,
    0x65, 0x72, 0x6d, 0x65, 0x73, 0x32, 0x76, 0x36,
    0x06, 0x6a, 0x61, 0x62, 0x62, 0x65, 0x72, 0x03,
    0x6f, 0x72, 0x67, 0x00,
};
/* res_query("_xmpp-client._tcp.gmail.com", C_IN, T_SRV, ...) */
static const unsigned char data3[] = {
    0xda, 0xa8, 0x81, 0x80, 0x00, 0x01, 0x00, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x5f, 0x78, 0x6d,
    0x70, 0x70, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
    0x74, 0x04, 0x5f, 0x74, 0x63, 0x70, 0x05, 0x67,
    0x6d, 0x61, 0x69, 0x6c, 0x03, 0x63, 0x6f, 0x6d,
    0x00, 0x00, 0x21, 0x00, 0x01, 0xc0, 0x0c, 0x00,
    0x21, 0x00, 0x01, 0x00, 0x00, 0x02, 0x43, 0x00,
    0x1e, 0x00, 0x14, 0x00, 0x00, 0x14, 0x66, 0x04,
    0x61, 0x6c, 0x74, 0x31, 0x04, 0x78, 0x6d, 0x70,
    0x70, 0x01, 0x6c, 0x06, 0x67, 0x6f, 0x6f, 0x67,
    0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00, 0xc0,
    0x0c, 0x00, 0x21, 0x00, 0x01, 0x00, 0x00, 0x02,
    0x43, 0x00, 0x1e, 0x00, 0x14, 0x00, 0x00, 0x14,
    0x66, 0x04, 0x61, 0x6c, 0x74, 0x34, 0x04, 0x78,
    0x6d, 0x70, 0x70, 0x01, 0x6c, 0x06, 0x67, 0x6f,
    0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d,
    0x00, 0xc0, 0x0c, 0x00, 0x21, 0x00, 0x01, 0x00,
    0x00, 0x02, 0x43, 0x00, 0x1e, 0x00, 0x14, 0x00,
    0x00, 0x14, 0x66, 0x04, 0x61, 0x6c, 0x74, 0x32,
    0x04, 0x78, 0x6d, 0x70, 0x70, 0x01, 0x6c, 0x06,
    0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63,
    0x6f, 0x6d, 0x00, 0xc0, 0x0c, 0x00, 0x21, 0x00,
    0x01, 0x00, 0x00, 0x02, 0x43, 0x00, 0x19, 0x00,
    0x05, 0x00, 0x00, 0x14, 0x66, 0x04, 0x78, 0x6d,
    0x70, 0x70, 0x01, 0x6c, 0x06, 0x67, 0x6f, 0x6f,
    0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f, 0x6d, 0x00,
    0xc0, 0x0c, 0x00, 0x21, 0x00, 0x01, 0x00, 0x00,
    0x02, 0x43, 0x00, 0x1e, 0x00, 0x14, 0x00, 0x00,
    0x14, 0x66, 0x04, 0x61, 0x6c, 0x74, 0x33, 0x04,
    0x78, 0x6d, 0x70, 0x70, 0x01, 0x6c, 0x06, 0x67,
    0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x03, 0x63, 0x6f,
    0x6d, 0x00,
};

static const struct {
    const unsigned char *data;
    size_t len;
    char *target;
    unsigned short port;
} tests[] = {
    {
        .data = data1,
        .len = sizeof(data1),
        .target = "jabber.kiev.ua",
        .port = 5222,
    },
    {
        .data = data2,
        .len = sizeof(data2),
        .target = "hermes2.jabber.org",
        .port = 5222,
    },
    {
        .data = data3,
        .len = sizeof(data3),
        .target = "xmpp.l.google.com",
        .port = 5222,
    },
};

int main(int argc, char **argv)
{
    char domain[2048];
    unsigned short port;
    size_t i;
    int ret;

    printf("resolver_srv_lookup_buf() tests.\n");
    for (i = 0; i < ARRAY_SIZE(tests); ++i) {
        printf("Test #%zu: ", i + 1);
        memset(domain, 'x', sizeof(domain));
        ret = resolver_srv_lookup_buf(tests[i].data, tests[i].len,
                                      domain, sizeof(domain), &port);
        assert(ret == 1);
        COMPARE(tests[i].target, domain);
        if (tests[i].port != port) {
            printf("fail! got port=%u, but should be %u\n",
                   (unsigned)port, (unsigned)tests[i].port);
            return 1;
        }
        printf("ok\n");
    }

    return 0;
}
