/**
 * Copyright 2013 IBM Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

module.exports = function(RED) {
    "use strict";
    var operators = {
        'eq': function(a, b) { return a == b; },
        'neq': function(a, b) { return a != b; },
        'lt': function(a, b) { return a < b; },
        'lte': function(a, b) { return a <= b; },
        'gt': function(a, b) { return a > b; },
        'gte': function(a, b) { return a >= b; },
        'btwn': function(a, b, c) { return a >= b && a <= c; },
        'cont': function(a, b) { return (a + "").indexOf(b) != -1; },
        'regex': function(a, b) { return (a + "").match(new RegExp(b)); },
        'true': function(a) { return a === true; },
        'false': function(a) { return a === false; },
        'null': function(a) { return typeof a == "undefined"; },
        'nnull': function(a) { return typeof a != "undefined"; },
        'else': function(a) { return a === true; }
    };

    function SwitchNode(n) {
        RED.nodes.createNode(this, n);
        this.rules = n.rules;
        this.property = n.property;
        this.checkall = n.checkall || "true";
        var propertyParts = n.property.split(".");
        var node = this;

        for (var i=0; i<this.rules.length; i+=1) {
            var rule = this.rules[i];
            if (!isNaN(Number(rule.v))) {
                rule.v = Number(rule.v);
                rule.v2 = Number(rule.v2);
            }
        }

        function value (v)
        {
            if (v == NaN || !v) return v;
            if (!isNaN (Number(v))) return v;
            else if (v.indexOf("{{")==0 && v.indexOf("}}") == v.length-2) 
            {
                // v.substring (2, v.length-2);
                return RED.settings.functionGlobalContext[v.substring (2, v.length-2)];
            }
            else return v;
        }

        this.on('input', function (msg) {
            var onward = [];
            try {
                var prop = propertyParts.reduce(function (obj, i) {
                    return obj[i]
                }, msg);
                var elseflag = true;
                for (var i=0; i<node.rules.length; i+=1) {
                    var rule = node.rules[i];
                    var test = prop;
                    // console.log (rule);
                    // console.log (value(rule.v));
                    // console.log (value(rule.v2));
                    if (rule.t == "else") { test = elseflag; elseflag = true; }
                    if (operators[rule.t](test,value(rule.v), value(rule.v2))) {
                        onward.push(msg);
                        elseflag = false;
                        if (node.checkall == "false") { break; }
                    } else {
                        onward.push(null);
                    }
                }
                this.send(onward);
            } catch(err) {
                node.warn(err);
            }
        });
    }
    RED.nodes.registerType("switch", SwitchNode);
}
