var topic = null;
var progs = [

  [ "Board" ],
  "board.js",
  "board-with-port.js",
  "board-multi.js",
  "repl.js",
  "shiftregister.js",
  "pin.js",
  "pin-circuit-event.js",
  "pin-dtoa.js",
  "whisker.js",

  [ "Plugin Template", "plugin" ],
  "plugin.js",

  [ "JSConf" ],
  "nodebot.js",


  [ "Nodebots" ],
  "bug.js",
  "ed.js",
  "navigator.js",
  "radar.js",
  "whisker.js",
  "line-follower.js",

  [ "IMU" ],
  "imu-mpu6050.js",

  [ "Servo" ],
  "servo.js",
  "servo-continuous.js",
  "servo-sweep.js",
  "servo-slider.js",
  "servo-prompt.js",
  "servo-keypress.js",
  "servo-drive.js",
  "servo-animation.js",
  "servo-diagnostic.js",
  "servo-array.js",
  "boe-test-servos.js",
  "servo-PCA9685.js",

  [ "Servo Animation"],
  "animation.js",
  "phoenix.js",

  [ "Motor" ],
  "motor.js",
  "motor-directional.js",
  "motor-brake.js",
  "motor-current.js",
  "motor-hbridge.js",
  "motor-PCA9685.js",
  "motor-3-pin.js",
  "motobot.js",


  [ "Stepper" ],
  "stepper-driver.js",
  "stepper-sweep.js",

  [ "ESC & Brushless Motor" ],
  "esc-keypress.js",
  "esc-dualshock.js",

  [ "Sonar/Ultrasonic" ],
  "ping.js",
  "sonar-scan.js",
  "sonar.js",
  "sonar-i2c.js",


  [ "Button" ],
  "button.js",
  "button-bumper.js",
  "button-options.js",
  "button-pullup.js",

  [ "Relay" ],
  "relay.js",

  [ "Claw" ],
  "claw.js",


  [ "Gripper" ],
  "gripper.js",


  [ "Infrared" ],
  "ir-distance.js",
  "ir-motion.js",
  "ir-proximity.js",
  "proximity.js",
  "ir-reflect.js",
  "ir-reflect-array.js",


  [ "Joystick" ],
  "joystick.js",
  "joystick-claw.js",
  "joystick-laser.js",
  "joystick-motor-led.js",


  [ "LCD" ],
  "lcd.js",
  "lcd-enumeratechars.js",
  "lcd-runner-20x4.js",
  "lcd-runner.js",
  "lcd-runner.js",
  "lcd-i2c.js",
  "lcd-i2c-runner.js",


  [ "LED" ],
  "led.js",
  "led-on-off.js",
  "led-strobe.js",
  "led-pulse.js",
  "led-fade.js",
  "led-fade-callback.js",
  "led-analog.js",
  "led-status.js",
  "led-array.js",
  "led-rgb.js",
  "led-rgb-anode.js",
  "led-rainbow.js",
  "led-demo-sequence.js",
  "led-matrix.js",
  "led-matrix-HT16K33.js",
  "seven-segment.js",
  "laser.js",

  [ "Magnetometer (Compass)" ],
  "magnetometer-log.js",
  "magnetometer-north.js",
  "magnetometer.js",


  [ "NodeConf Demos" ],
  "nodeconf-compass.js",
  "nodeconf-navigator.js",
  "nodeconf-radar.js",
  "nodeconf-slider.js",

  [ "Sound" ],
  "piezo.js",

  [ "Kinect"],
  "kinect-arm-controller.js",

  [ "Wii" ],
  "nunchuk.js",
  "classic-controller.js",

  [ "Sensors" ],
  "accelerometer.js",
  "accelerometer-adxl335.js",
  "accelerometer-mpu6050.js",
  "accelerometer-adxl345.js",
  "accelerometer-pan-tilt.js",
  "gyro.js",
  "gyro-mpu6050.js",
  "photoresistor.js",
  "photoresistor-servo.js",
  "potentiometer.js",
  "sensor.js",
  "sensor-fsr-servo.js",
  "sensor-fsr.js",
  "sensor-ir-led-receiver.js",
  "sensor-slider.js",
  "slider-log.js",
  "slider-pan.js",
  "slider-servo-control.js",
  "temperature-tmp36.js",
  "temperature-lm35.js",
  "temperature-ds18b20.js",
  "temperature-mpu6050.js",

  [ "Grove IoT Kit (Seeed Studio)" ],
  "grove-led.js",
  "grove-button.js",
  "grove-touch.js",
  "grove-sensor.js",
  "grove-lcd-rgb.js",
  "grove-lcd-rgb-temperature-display.js",
  "grove-servo.js",

  [ "TinkerKit" ],
  "tinkerkit-accelerometer.js",
  "tinkerkit-blink.js",
  "tinkerkit-button.js",
  "tinkerkit-continuous-servo.js",
  "tinkerkit-combo.js",
  "tinkerkit-gyroscope.js",
  "tinkerkit-joystick.js",
  "tinkerkit-linear-pot.js",
  "tinkerkit-rotary.js",
  "tinkerkit-thermistor.js",
  "tinkerkit-tilt.js",
  "tinkerkit-touch.js",

  [ "Spark" ],
  "spark-io-blink.js"

].reduce(function(accum, value, index, source) {
  var tplType = "eg";

  if (Array.isArray(value)) {
    topic = value[0];
    tplType = value[1] ? value[1] : tplType;

    accum[topic] = {
      topic: topic,
      files: []
    };

    if (tplType !== "eg") {
      accum[topic].tplType = tplType;
    }
  } else {
    accum[topic].files.push(value);
  }

  if (index === source.length - 1) {
    return Object.keys(accum).map(function(key) {
      return accum[key];
    });
  }

  return accum;
}, {});

console.log(JSON.stringify(progs, null, 2));
