// Use require("galileo-io") when running from an npm installation
var Galileo = require("../lib/galileo");
var board = new Galileo();

board.on("ready", function() {
  console.log("READY");
  var min = 1024;
  var max = 0;
  var timeout;
  // var time = Date.now();

  this.pinMode("A0", this.MODES.ANALOG);
  this.pinMode(3, this.MODES.PWM);
  this.analogWrite(3, 0);

  this.analogRead("A0", function(data) {
    min = Math.min(min, data);
    max = Math.max(max, data);

    // Loudness increases resistance,
    // therefore data reading will be lower.
    var value = scale(data, max, min, 0, 10) | 0;

    if (value && value > 5) {
      this.analogWrite(3, 255);

      clearTimeout(timeout);
      timeout = setTimeout(function() {
        this.analogWrite(3, 0);
      }.bind(this), 1000);
    } else {
      this.analogWrite(3, 0);
    }
  });
});


function scale(value, inMin, inMax, outMin, outMax) {
  return (value - inMin) * (outMax - outMin) /
    (inMax - inMin) + outMin;
}
