var chars = {
  "0": 0x7E,
  "1": 0x30,
  "2": 0x6D,
  "3": 0x79,
  "4": 0x33,
  "5": 0x5B,
  "6": 0x5F,
  "7": 0x70,
  "8": 0x7F,
  "9": 0x7B,
  "A": 0x77,
  "a": 0x7D,
  "B": 0x7F,
  "b": 0x1F,
  "C": 0x4E,
  "c": 0x0D,
  "D": 0x7E,
  "d": 0x3D,
  "E": 0x4F,
  "e": 0x6F,
  "F": 0x47,
  "f": 0x47,
  "G": 0x5E,
  "g": 0x7B,
  "H": 0x37,
  "h": 0x17,
  "I": 0x30,
  "i": 0x10,
  "J": 0x3C,
  "j": 0x38,
  "K": 0x76,
  "k": 0x74,
  "L": 0x56,
  "l": 0x06,
  "M": 0x77,
  "m": 0x55,
  "N": 0x84,
  "n": 0x15,
  "O": 0x7E,
  "o": 0x1D,
  "P": 0x67,
  "p": 0x67,
  "Q": 0x73,
  "q": 0x73,
  "R": 0x77,
  "r": 0x05,
  "S": 0x5B,
  "s": 0x5B,
  "T": 0x0F,
  "t": 0x0F,
  "U": 0x3E,
  "u": 0x1C,
  "V": 0x27,
  "v": 0x23,
  "W": 0x3F,
  "w": 0x2B,
  "X": 0x25,
  "x": 0x25,
  "Y": 0x3B,
  "y": 0x33,
  "Z": 0x6D,
  "z": 0x6D,
};

var keys = Object.keys(chars);
var upper = document.getElementById("upper");
var lower = document.getElementById("lower");
var showing = document.getElementById("now-showing");
var classes = ["bottom", "left", "left", "bottom", "right", "right", "top"];

function element(position) {
  return position >= 5 || position <= 1 ? upper : lower;
}

setInterval(function() {
  var char = keys.shift();
  var bits = chars[char];

  upper.className = "";
  lower.className = "";

  showing.textContent = char;

  // Why only 7? Because the 8th is used
  // for a decimal led, that's why.

  for (var i = 6; i >= 0; i--) {
    if (bits >> i & 1) {
      element(i).classList.add(
        "border-" + classes[i]
      );
    }
  }

  if (!keys.length) {
    keys = Object.keys(chars);
  }
}, 1000);
