var five = require("../");
var board = new five.Board();

board.on("ready", function() {
  var temp = new five.Sensor("A0");
  var last = 0;
  // the resolution is 10 mV / degree centigrade
  // (500 mV offset) to make negative temperatures an option

  temp.on("change", function() {
    var C = celcius(this.value);
    if (last !== C) {
      console.log("Temp: %d", C);
    }
    last = C;
  });
});


function celcius(value) {
  // converting from a 0 to 1023 digital range
  // to 0 to 5 volts (each 1 reading equals ~ 5 millivolts
  return (((value * 0.004882814) - 0.5) * 100) | 0;
}
