var five = require("../lib/johnny-five.js"),
  board = new five.Board();

board.on("ready", function() {
  // Creates a piezo object and defines the pin to be used for the signal
  var piezo = new five.Piezo(3);

  // Injects the piezo into the repl
  board.repl.inject({
    piezo: piezo
  });

  // Full note list available to johnny-five. Note
  // that notes at both ends of the list are indistingushable
  // from one another. Octaves 3 to 6 work best.
  piezo.play({
    song: [
      ["c0", 1 / 6],
      ["c#0", 1 / 6],
      ["d0", 1 / 6],
      ["d#0", 1 / 6],
      ["e0", 1 / 6],
      ["f0", 1 / 6],
      ["f#0", 1 / 6],
      ["g0", 1 / 6],
      ["g#0", 1 / 6],
      ["a0", 1 / 6],
      ["a#0", 1 / 6],
      ["b0", 1 / 6],
      ["c1", 1 / 6],
      ["c#1", 1 / 6],
      ["d1", 1 / 6],
      ["d#1", 1 / 6],
      ["e1", 1 / 6],
      ["f1", 1 / 6],
      ["f#1", 1 / 6],
      ["g1", 1 / 6],
      ["g#1", 1 / 6],
      ["a1", 1 / 6],
      ["a#1", 1 / 6],
      ["b1", 1 / 6],
      ["c2", 1 / 6], //Start of noticable range
      ["c#2", 1 / 6],
      ["d2", 1 / 6],
      ["d#2", 1 / 6],
      ["e2", 1 / 6],
      ["f2", 1 / 6],
      ["f#2", 1 / 6],
      ["g2", 1 / 6],
      ["g#2", 1 / 6],
      ["a2", 1 / 6],
      ["a#2", 1 / 6],
      ["b2", 1 / 6],
      ["c3", 1 / 6],
      ["c#3", 1 / 6],
      ["d3", 1 / 6],
      ["d#3", 1 / 6],
      ["e3", 1 / 6],
      ["f3", 1 / 6],
      ["f#3", 1 / 6],
      ["g3", 1 / 6],
      ["g#3", 1 / 6],
      ["a3", 1 / 6],
      ["a#3", 1 / 6],
      ["b3", 1 / 6],
      ["c4", 1 / 6],
      ["c#4", 1 / 6],
      ["d4", 1 / 6],
      ["d#4", 1 / 6],
      ["e4", 1 / 6],
      ["f4", 1 / 6],
      ["f#4", 1 / 6],
      ["g4", 1 / 6],
      ["g#4", 1 / 6],
      ["a4", 1 / 6],
      ["a#4", 1 / 6],
      ["b4", 1 / 6],
      ["c5", 1 / 6],
      ["c#5", 1 / 6],
      ["d5", 1 / 6],
      ["d#5", 1 / 6],
      ["e5", 1 / 6],
      ["f5", 1 / 6],
      ["f#5", 1 / 6],
      ["g5", 1 / 6],
      ["g#5", 1 / 6],
      ["a5", 1 / 6],
      ["a#5", 1 / 6],
      ["b5", 1 / 6],
      ["c6", 1 / 6], //End of noticable range
      ["c#6", 1 / 6],
      ["d6", 1 / 6],
      ["d#6", 1 / 6],
      ["e6", 1 / 6],
      ["f6", 1 / 6],
      ["f#6", 1 / 6],
      ["g6", 1 / 6],
      ["g#6", 1 / 6],
      ["a6", 1 / 6],
      ["a#6", 1 / 6],
      ["b6", 1 / 6],
      ["c7", 1 / 6],
      ["c#7", 1 / 6],
      ["d7", 1 / 6],
      ["d#7", 1 / 6],
      ["e7", 1 / 6],
      ["f7", 1 / 6],
      ["f#7", 1 / 6],
      ["g7", 1 / 6],
      ["g#7", 1 / 6],
      ["a7", 1 / 6],
      ["a#7", 1 / 6],
      ["b7", 1 / 6],
      ["c8", 1 / 6],
      ["c#8", 1 / 6],
      ["d8", 1 / 6],
      ["d#8", 1 / 6],
      ["e8", 1 / 6],
      ["f8", 1 / 6],
      ["f#8", 1 / 6],
      ["g8", 1 / 6],
      ["g#8", 1 / 6],
      ["a8", 1 / 6],
      ["a#8", 1 / 6],
      ["b8", 1 / 6]
    ]
  });
});
