#!/bin/bash

source ~/.nvm/nvm.sh

export PATH=.:$PATH

run() {
  echo "$ $@"
  $@ >/dev/null 2>&1
}

nvm ls | awk '{print $2}' | grep -v -- '->' | \
while read version; do
  echo "==> Running $version"
  rm -rf build node_modules
  run npm install
  run make clean all test
  res=$?
  if [ "$res" -eq 0 ]; then
    printf "\n\e[1;37;49m\\o/\e[0m \e[1;32;49mAll tests passed without errors!\e[0m\n"
  else
    printf "\n\e[1;31;49m!!! WARNING\e[0m Test with %s failed.\n" "$version"
  fi
  echo "<== Done $version"
done 
