'use strict';
var utils = require('../utils'),
    bus = utils.bus,
    childProcess = require('child_process'),
    spawn = childProcess.spawn,
    exec = childProcess.exec,
    watch = require('./watch'),
    config = require('../config'),
    child = null, // the actual child process we spawn
    killedAfterChange = false,
    // timeout = 1000, // check every 1 second
    noop = function() {},
    restart = null,
    psTree = require('ps-tree'),
    hasPS = true;

// discover if the OS has `ps`, and therefore can use psTree
exec('ps', function(error) {
  if (error) {
    hasPS = false;
  }
});

function run(options) {
  var cmd = config.command.raw;

  utils.log.status('starting `' + config.command.string + '`');

  /*jshint validthis:true*/
  restart = run.bind(this, options);
  run.restart = restart;

  config.lastStarted = Date.now();

  var stdio = ['pipe', 'pipe', 'pipe'];

  if (config.options.stdout) {
    stdio = ['pipe', process.stdout, process.stderr];
  }

  var sh = 'sh';
  var shFlag = '-c';

  if (utils.isWindows) {
    sh = 'cmd';
    shFlag = '/c';
  }

  var executable = cmd.executable;

  // special logic for windows, as spaces in the paths need the path fragment
  // quoted, so it reads: c:\"Program Files"\nodejs\node.exe
  if (utils.isWindows && executable.indexOf(' ') !== -1) {
    executable = executable.replace(/\\((\w+\s+)+\w+)(?=([\\\.]))(?=([^"]*"[^"]*")*[^"]*$)/g, '\\"$1"');
  }

  var args = utils.stringify(executable, cmd.args);

  var spawnArgs = [sh, [shFlag, args]];

  if (utils.version.major === 0 && utils.version.minor < 8) {
    // use the old spawn args :-\
  } else {
    spawnArgs.push({
      env: utils.merge(options.execOptions.env, process.env),
      stdio: stdio
    });
  }

  child = spawn.apply(null, spawnArgs);

  if (config.required) {
    var emit = {
      stdout: function (data) {
        bus.emit('stdout', data);
      },
      stderr: function (data) {
        bus.emit('stderr', data);
      }
    };

    // now work out what to bind to...
    if (config.opti