describe.skip('empty', function(){

  it.skip('should error on empty input', function (done) {
    var feedparser = new FeedParser();
    feedparser
      .once('readable', function () {
        debugger;
        var item = this.read();
        done();
      })
      .on('error', function (err) {
        debugger;
        assert.ifError(err);
      })
      .on('end', done);
    feedparser.write('<>');
    // feedparser.end();
  });

  var feed = __dirname + '/feeds/theramblingtour.xml';

  it('should emit an error and no data', function (done) {
    this.timeout(10000);
    var error;
    var req = require('request');
    var feedparser = new FeedParser({ addmeta: false, resume_saxerror: false });
    req('http://theramblingtour.smugglersrecords.com/?feed=rss2').on('response', function (res) {
      res.pipe(feedparser);
      feedparser.on('end', function() {
        debugger;
        res.unpipe(feedparser);
      });
    });
    feedparser
      .on('error', function (err) {
        debugger;
        error = err;
      })
      .on('readable', function () {
        debugger;
        this.end(onEnd);
      })
      .on('end', function onEnd () {
        debugger;
        assert.ok(error instanceof Error);
        done();
      })
  });

});
