module.exports = function(grunt) {

  // Project configuration.
  grunt.initConfig({
    pkg: '<json:package.json>',
    //test: {
    //  files: ['test/**/*.js']
    //},
    lint: {
      files: ['grunt.js', '*.js', 'test/**/*.js', 'samples/*.js', 'samples/*/*.js']
    },
    watch: {
      files: '<config:lint.files>',
      tasks: 'default'
    },
    jshint: {
      options: {
        curly: true,
        eqeqeq: true,
        immed: true,
        latedef: true,
        newcap: true,
        noarg: true,
        sub: true,
        undef: true,
        boss: true,
        eqnull: true,
        node: true,
        strict: false,
        es5: true
      },
      globals: {
        exports: true,
        describe: true,
        it: true
      }
    }
  });

  // Default task.
  grunt.registerTask('default', 'lint test');

};