(function() {
  var BLE, BlendMicro, STATE, UUID_LIST, _, ble, debug, events,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  events = require('eventemitter2');

  _ = require('lodash');

  debug = require('debug')('blendmicro');

  BLE = require('./ble');

  ble = new BLE;

  ble.setMaxListeners(16);

  STATE = require('./state');

  UUID_LIST = {
    blendmicro: {
      service: "713d0000-503e-4c75-ba94-3148f18d941e".replace(/\-/g, ''),
      tx: "713d0003-503e-4c75-ba94-3148f18d941e".replace(/\-/g, ''),
      rx: "713d0002-503e-4c75-ba94-3148f18d941e".replace(/\-/g, '')
    },
    mbed_uart: {
      service: "6e400001-b5a3-f393-e0a9-e50e24dcca9e".replace(/\-/g, ''),
      tx: "6e400002-b5a3-f393-e0a9-e50e24dcca9e".replace(/\-/g, ''),
      rx: "6e400003-b5a3-f393-e0a9-e50e24dcca9e".replace(/\-/g, '')
    }
  };

  module.exports = BlendMicro = (function(superClass) {
    extend(BlendMicro, superClass);

    function BlendMicro(name) {
      this.name = name != null ? name : 'BlendMicro';
      this.peripheral = null;
      this.reconnect = true;
      this.write_queue = [];
      this.writeInterval = 100;
      this.writePacketSize = 20;
      this.state = STATE.CLOSE;
      this.open(this.name);
    }

    BlendMicro.prototype.open = function(name) {
      this.name = name;
      if (this.state !== STATE.CLOSE) {
        return;
      }
      debug("start scanning \"" + this.name + "\"");
      this.state = STATE.SCAN;
      ble.open(this);
      ble.startScanning();
      this.on('discover', (function(_this) {
        return function(peripheral) {
          debug("discover \"" + peripheral.advertisement.localName + "\"");
          if (_this.state !== STATE.SCAN) {
            return;
          }
          if (peripheral.advertisement.localName !== _this.name) {
            return;
          }
          debug("found peripheral \"" + _this.name + "\"");
          _this.state = STATE.CHECK;
          peripheral.connect(function() {
            var j, len, ref, signal;
            ref = ['SIGINT', 'SIGHUP', 'SIGTERM'];
            for (j = 0, len = ref.length; j < len; j++) {
              signal = ref[j];
              process.on(signal, function() {
                if (_this.peripheral == null) {
                  process.exit(1);
                  return;
                }
                if (_this.peripheral.state === 'disconnected') {
                  process.exit(1);
                  return;
                }
                _this.peripheral.disconnect(function() {
                  return process.exit(1);
                });
                return setTimeout(function() {
                  debug('peripheral.disconnect timeout (2000 msec)');
                  return process.exit(1);
                }, 2000);
              });
            }
            debug('connect peripheral');
            return peripheral.discoverServices([], function(err, services) {
              var device_type, service;
              device_type = null;
              service = _.find(services, function(service) {
                var type, uuids;
                for (type in UUID_LIST) {
                  uuids = UUID_LIST[type];
                  if (service.uuid === uuids.service) {
                    device_type = type;
                    return true;
                  }
                }
              });
              if (!service) {
                _this.state = STATE.SCAN;
                return debug('ERROR: Service not found');
              }
              return service.discoverCharacteristics([], function(err, chars) {
                _this.tx = _.find(chars, function(char) {
                  return char.uuid === UUID_LIST[device_type].tx;
                });
                if (!_this.tx) {
                  _this.state = STATE.SCAN;
                  return debug('ERROR: TX characteristics not found');
                }
                _this.rx = _.find(chars, function(char) {
                  return char.uuid === UUID_LIST[device_type].rx;
                });
                if (!_this.rx) {
                  _this.state = STATE.SCAN;
                  return debug('ERROR: RX characteristics not found');
                }
                _this.rx.on('read', function(data) {
                  return _this.emit('data', data);
                });
                _this.rx.notify(true, function(err) {
                  if (err) {
                    return debug(err);
                  }
                });
                _this.peripheral = peripheral;
                _this.state = STATE.OPEN;
                return _this.emit('open');
              });
            });
          });
          return peripheral.on('disconnect', function() {
            debug('disconnect');
            peripheral.removeAllListeners();
            _this.peripheral = null;
            _this.emit('close');
            if (_this.reconnect) {
              debug("re-start scanning \"" + _this.name + "\"");
              _this.state = STATE.SCAN;
              return ble.startScanning();
            } else {
              return _this.state = STATE.CLOSE;
            }
          });
        };
      })(this));
      return this.on('open', (function(_this) {
        return function() {
          _this.state = STATE.OPEN;
          return ble.stopScanning();
        };
      })(this));
    };

    BlendMicro.prototype.close = function(callback) {
      this.state = STATE.CLOSE;
      ble.close(this);
      this.peripheral.removeAllListeners();
      this.peripheral.disconnect((function(_this) {
        return function() {
          if (typeof callback === "function") {
            callback(null);
          }
          return _this.emit('close');
        };
      })(this));
      return this.peripheral = null;
    };

    BlendMicro.prototype.write = function(data, callback) {
      var i, j, packet_num, ref, start_at;
      if (this.state !== STATE.OPEN) {
        return typeof callback === "function" ? callback(this.state) : void 0;
      }
      if (!(data instanceof Buffer)) {
        data = new Buffer(data);
      }
      packet_num = Math.floor((data.length - 1) / this.writePacketSize) + 1;
      debug("write " + data.length + "bytes " + packet_num + "packets");
      for (i = j = 0, ref = packet_num; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        start_at = i * this.writePacketSize;
        this.write_queue.push(data.slice(start_at, start_at + this.writePacketSize));
      }
      if (this.write_interval_id) {
        return;
      }
      return this.write_interval_id = setInterval((function(_this) {
        return function() {
          if (_this.write_queue.length > 0 && _this.peripheral) {
            return _this.tx.write(_this.write_queue.shift());
          } else {
            clearInterval(_this.write_interval_id);
            _this.write_interval_id = null;
            return _this.write_queue = [];
          }
        };
      })(this), this.writeInterval);
    };

    BlendMicro.prototype.updateRssi = function(callback) {
      if (this.state !== STATE.OPEN) {
        return typeof callback === "function" ? callback(this.state) : void 0;
      }
      return this.peripheral.updateRssi(callback);
    };

    return BlendMicro;

  })(events.EventEmitter2);

}).call(this);
