(function() {
  var BLE, EventEmitter2, STATE, debug, noble,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  noble = require('noble');

  debug = require('debug')('blendmicro:ble');

  EventEmitter2 = require('eventemitter2').EventEmitter2;

  STATE = require('./state');

  module.exports = BLE = (function(superClass) {
    extend(BLE, superClass);

    function BLE() {
      var attr, attrs, fn, i, len;
      this.devices = [];
      this.scanCount = 0;
      attrs = ['state'];
      fn = (function(_this) {
        return function(attr) {
          return _this.__defineGetter__(attr, function() {
            return noble[attr];
          });
        };
      })(this);
      for (i = 0, len = attrs.length; i < len; i++) {
        attr = attrs[i];
        fn(attr);
      }
      noble.on('discover', (function(_this) {
        return function(peripheral) {
          var device, j, len1, ref, results;
          ref = _this.devices;
          results = [];
          for (j = 0, len1 = ref.length; j < len1; j++) {
            device = ref[j];
            if (device.state === STATE.SCAN && device.name === peripheral.advertisement.localName) {
              results.push(device.emit('discover', peripheral));
            } else {
              results.push(void 0);
            }
          }
          return results;
        };
      })(this));
    }

    BLE.prototype.open = function(device) {
      if (this.devices.indexOf(device) > -1) {
        return;
      }
      return this.devices.push(device);
    };

    BLE.prototype.close = function(device) {
      return this.devices.splice(this.devices.indexOf(device), 1);
    };

    BLE.prototype.getNumberOfScanningDevices = function() {
      return this.devices.filter(function(device) {
        return device.state === STATE.SCAN;
      }).length;
    };

    BLE.prototype.startScanning = function() {
      var scanCount;
      scanCount = this.getNumberOfScanningDevices();
      debug("scanCount: " + scanCount);
      if (scanCount !== 1) {
        return;
      }
      debug("noble.startScanning");
      if (noble.state === 'poweredOn') {
        return noble.startScanning([], true);
      }
      return noble.once('stateChange', function(state) {
        if (state === 'poweredOn') {
          return noble.startScanning([], true);
        } else {
          return noble.stopScanning();
        }
      });
    };

    BLE.prototype.stopScanning = function() {
      var scanCount;
      scanCount = this.getNumberOfScanningDevices();
      debug("scanCount: " + scanCount);
      if (scanCount !== 0) {
        return;
      }
      debug("noble.stopScanning");
      return noble.stopScanning();
    };

    return BLE;

  })(EventEmitter2);

}).call(this);
